"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InitSource = exports.InitService = exports.InitPackage = exports.InitUser = exports.InitGroup = exports.InitFile = exports.InitCommand = exports.InitCommandWaitDuration = exports.InitElement = exports.InitServiceRestartHandle = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const s3_assets = require("@aws-cdk/aws-s3-assets");
const core_1 = require("@aws-cdk/core");
const cfn_init_internal_1 = require("./private/cfn-init-internal");
/**
 * An object that represents reasons to restart an InitService
 *
 * Pass an instance of this object to the `InitFile`, `InitCommand`,
 * `InitSource` and `InitPackage` objects, and finally to an `InitService`
 * itself to cause the actions (files, commands, sources, and packages)
 * to trigger a restart of the service.
 *
 * For example, the following will run a custom command to install Nginx,
 * and trigger the nginx service to be restarted after the command has run.
 *
 * ```ts
 * const handle = new ec2.InitServiceRestartHandle();
 * ec2.CloudFormationInit.fromElements(
 *   ec2.InitCommand.shellCommand('/usr/bin/custom-nginx-install.sh', { serviceRestartHandles: [handle] }),
 *   ec2.InitService.enable('nginx', { serviceRestartHandle: handle }),
 * );
 * ```
 */
class InitServiceRestartHandle {
    constructor() {
        this.commands = new Array();
        this.files = new Array();
        this.sources = new Array();
        this.packages = {};
    }
    /**
     * Add a command key to the restart set
     * @internal
     */
    _addCommand(key) {
        return this.commands.push(key);
    }
    /**
     * Add a file key to the restart set
     * @internal
     */
    _addFile(key) {
        return this.files.push(key);
    }
    /**
     * Add a source key to the restart set
     * @internal
     */
    _addSource(key) {
        return this.sources.push(key);
    }
    /**
     * Add a package key to the restart set
     * @internal
     */
    _addPackage(packageType, key) {
        if (!this.packages[packageType]) {
            this.packages[packageType] = [];
        }
        this.packages[packageType].push(key);
    }
    /**
     * Render the restart handles for use in an InitService declaration
     * @internal
     */
    _renderRestartHandles() {
        const nonEmpty = (x) => x.length > 0 ? x : undefined;
        return {
            commands: nonEmpty(this.commands),
            files: nonEmpty(this.files),
            packages: Object.keys(this.packages).length > 0 ? this.packages : undefined,
            sources: nonEmpty(this.sources),
        };
    }
}
exports.InitServiceRestartHandle = InitServiceRestartHandle;
_a = JSII_RTTI_SYMBOL_1;
InitServiceRestartHandle[_a] = { fqn: "@aws-cdk/aws-ec2.InitServiceRestartHandle", version: "1.152.0" };
/**
 * Base class for all CloudFormation Init elements
 */
class InitElement {
}
exports.InitElement = InitElement;
_b = JSII_RTTI_SYMBOL_1;
InitElement[_b] = { fqn: "@aws-cdk/aws-ec2.InitElement", version: "1.152.0" };
/**
 * Represents a duration to wait after a command has finished, in case of a reboot (Windows only).
 */
class InitCommandWaitDuration {
    /** Wait for a specified duration after a command. */
    static of(duration) {
        return new class extends InitCommandWaitDuration {
            /** @internal */
            _render() { return duration.toSeconds(); }
        }();
    }
    /** Do not wait for this command. */
    static none() {
        return InitCommandWaitDuration.of(core_1.Duration.seconds(0));
    }
    /** cfn-init will exit and resume only after a reboot. */
    static forever() {
        return new class extends InitCommandWaitDuration {
            /** @internal */
            _render() { return 'forever'; }
        }();
    }
}
exports.InitCommandWaitDuration = InitCommandWaitDuration;
_c = JSII_RTTI_SYMBOL_1;
InitCommandWaitDuration[_c] = { fqn: "@aws-cdk/aws-ec2.InitCommandWaitDuration", version: "1.152.0" };
/**
 * Command to execute on the instance
 */
class InitCommand extends InitElement {
    constructor(command, options) {
        super();
        this.command = command;
        this.options = options;
        this.elementType = cfn_init_internal_1.InitElementType.COMMAND.toString();
    }
    /**
     * Run a shell command
     *
     * Remember that some characters like `&`, `|`, `;`, `>` etc. have special meaning in a shell and
     * need to be preceded by a `\` if you want to treat them as part of a filename.
     */
    static shellCommand(shellCommand, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitCommandOptions(options);
        return new InitCommand(shellCommand, options);
    }
    /**
     * Run a command from an argv array
     *
     * You do not need to escape space characters or enclose command parameters in quotes.
     */
    static argvCommand(argv, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitCommandOptions(options);
        if (argv.length === 0) {
            throw new Error('Cannot define argvCommand with an empty arguments');
        }
        return new InitCommand(argv, options);
    }
    /** @internal */
    _bind(options) {
        var _l, _m;
        const commandKey = this.options.key || `${options.index}`.padStart(3, '0'); // 001, 005, etc.
        if (options.platform !== cfn_init_internal_1.InitPlatform.WINDOWS && this.options.waitAfterCompletion !== undefined) {
            throw new Error(`Command '${this.command}': 'waitAfterCompletion' is only valid for Windows systems.`);
        }
        for (const handle of (_l = this.options.serviceRestartHandles) !== null && _l !== void 0 ? _l : []) {
            handle._addCommand(commandKey);
        }
        return {
            config: {
                [commandKey]: {
                    command: this.command,
                    env: this.options.env,
                    cwd: this.options.cwd,
                    test: this.options.testCmd,
                    ignoreErrors: this.options.ignoreErrors,
                    waitAfterCompletion: (_m = this.options.waitAfterCompletion) === null || _m === void 0 ? void 0 : _m._render(),
                },
            },
        };
    }
}
exports.InitCommand = InitCommand;
_d = JSII_RTTI_SYMBOL_1;
InitCommand[_d] = { fqn: "@aws-cdk/aws-ec2.InitCommand", version: "1.152.0" };
/**
 * Create files on the EC2 instance.
 */
class InitFile extends InitElement {
    constructor(fileName, options) {
        super();
        this.fileName = fileName;
        this.options = options;
        this.elementType = cfn_init_internal_1.InitElementType.FILE.toString();
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
    }
    /**
     * Use a literal string as the file content
     */
    static fromString(fileName, content, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        if (!content) {
            throw new Error(`InitFile ${fileName}: cannot create empty file. Please supply at least one character of content.`);
        }
        return new class extends InitFile {
            _doBind(bindOptions) {
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        content,
                        encoding: this.options.base64Encoded ? 'base64' : 'plain',
                    }),
                };
            }
        }(fileName, options);
    }
    /**
     * Write a symlink with the given symlink target
     */
    static symlink(fileName, target, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        const { mode, ...otherOptions } = options;
        if (mode && mode.slice(0, 3) !== '120') {
            throw new Error('File mode for symlinks must begin with 120XXX');
        }
        return InitFile.fromString(fileName, target, { mode: (mode || '120644'), ...otherOptions });
    }
    /**
     * Use a JSON-compatible object as the file content, write it to a JSON file.
     *
     * May contain tokens.
     */
    static fromObject(fileName, obj, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        content: obj,
                    }),
                };
            }
        }(fileName, options);
    }
    /**
     * Read a file from disk and use its contents
     *
     * The file will be embedded in the template, so care should be taken to not
     * exceed the template size.
     *
     * If options.base64encoded is set to true, this will base64-encode the file's contents.
     */
    static fromFileInline(targetFileName, sourceFileName, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        const encoding = options.base64Encoded ? 'base64' : 'utf8';
        const fileContents = fs.readFileSync(sourceFileName).toString(encoding);
        return InitFile.fromString(targetFileName, fileContents, options);
    }
    /**
     * Download from a URL at instance startup time
     */
    static fromUrl(fileName, url, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: url,
                    }),
                };
            }
        }(fileName, options);
    }
    /**
     * Download a file from an S3 bucket at instance startup time
     */
    static fromS3Object(fileName, bucket, key, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                bucket.grantRead(bindOptions.instanceRole, key);
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: bucket.urlForObject(key),
                    }),
                    authentication: standardS3Auth(bindOptions.instanceRole, bucket.bucketName),
                };
            }
        }(fileName, options);
    }
    /**
     * Create an asset from the given file
     *
     * This is appropriate for files that are too large to embed into the template.
     */
    static fromAsset(targetFileName, path, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileAssetOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                const asset = new s3_assets.Asset(bindOptions.scope, `${targetFileName}Asset`, {
                    path,
                    ...options,
                });
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: asset.httpUrl,
                    }),
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetFileName, options);
    }
    /**
     * Use a file from an asset at instance startup time
     */
    static fromExistingAsset(targetFileName, asset, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitFileOptions(options);
        return new class extends InitFile {
            _doBind(bindOptions) {
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: this._standardConfig(options, bindOptions.platform, {
                        source: asset.httpUrl,
                    }),
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetFileName, options);
    }
    /** @internal */
    _bind(bindOptions) {
        var _l;
        for (const handle of (_l = this.options.serviceRestartHandles) !== null && _l !== void 0 ? _l : []) {
            handle._addFile(this.fileName);
        }
        return this._doBind(bindOptions);
    }
    /**
     * Render the standard config block, given content vars
     * @internal
     */
    _standardConfig(fileOptions, platform, contentVars) {
        if (platform === cfn_init_internal_1.InitPlatform.WINDOWS) {
            if (fileOptions.group || fileOptions.owner || fileOptions.mode) {
                throw new Error('Owner, group, and mode options not supported for Windows.');
            }
            return {
                [this.fileName]: { ...contentVars },
            };
        }
        return {
            [this.fileName]: {
                ...contentVars,
                mode: fileOptions.mode || '000644',
                owner: fileOptions.owner || 'root',
                group: fileOptions.group || 'root',
            },
        };
    }
}
exports.InitFile = InitFile;
_e = JSII_RTTI_SYMBOL_1;
InitFile[_e] = { fqn: "@aws-cdk/aws-ec2.InitFile", version: "1.152.0" };
/**
 * Create Linux/UNIX groups and assign group IDs.
 *
 * Not supported for Windows systems.
 */
class InitGroup extends InitElement {
    constructor(groupName, groupId) {
        super();
        this.groupName = groupName;
        this.groupId = groupId;
        this.elementType = cfn_init_internal_1.InitElementType.GROUP.toString();
    }
    /**
     * Create a group from its name, and optionally, group id
     */
    static fromName(groupName, groupId) {
        return new InitGroup(groupName, groupId);
    }
    /** @internal */
    _bind(options) {
        if (options.platform === cfn_init_internal_1.InitPlatform.WINDOWS) {
            throw new Error('Init groups are not supported on Windows');
        }
        return {
            config: {
                [this.groupName]: this.groupId !== undefined ? { gid: this.groupId } : {},
            },
        };
    }
}
exports.InitGroup = InitGroup;
_f = JSII_RTTI_SYMBOL_1;
InitGroup[_f] = { fqn: "@aws-cdk/aws-ec2.InitGroup", version: "1.152.0" };
/**
 * Create Linux/UNIX users and to assign user IDs.
 *
 * Users are created as non-interactive system users with a shell of
 * /sbin/nologin. This is by design and cannot be modified.
 *
 * Not supported for Windows systems.
 */
class InitUser extends InitElement {
    constructor(userName, userOptions) {
        super();
        this.userName = userName;
        this.userOptions = userOptions;
        this.elementType = cfn_init_internal_1.InitElementType.USER.toString();
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitUserOptions(userOptions);
    }
    /**
     * Create a user from user name.
     */
    static fromName(userName, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitUserOptions(options);
        return new InitUser(userName, options);
    }
    /** @internal */
    _bind(options) {
        if (options.platform === cfn_init_internal_1.InitPlatform.WINDOWS) {
            throw new Error('Init users are not supported on Windows');
        }
        return {
            config: {
                [this.userName]: {
                    uid: this.userOptions.userId,
                    groups: this.userOptions.groups,
                    homeDir: this.userOptions.homeDir,
                },
            },
        };
    }
}
exports.InitUser = InitUser;
_g = JSII_RTTI_SYMBOL_1;
InitUser[_g] = { fqn: "@aws-cdk/aws-ec2.InitUser", version: "1.152.0" };
/**
 * A package to be installed during cfn-init time
 */
class InitPackage extends InitElement {
    constructor(type, versions, packageName, serviceHandles) {
        super();
        this.type = type;
        this.versions = versions;
        this.packageName = packageName;
        this.serviceHandles = serviceHandles;
        this.elementType = cfn_init_internal_1.InitElementType.PACKAGE.toString();
    }
    /**
     * Install an RPM from an HTTP URL or a location on disk
     */
    static rpm(location, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_LocationPackageOptions(options);
        return new InitPackage('rpm', [location], options.key, options.serviceRestartHandles);
    }
    /**
     * Install a package using Yum
     */
    static yum(packageName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_NamedPackageOptions(options);
        return new InitPackage('yum', (_l = options.version) !== null && _l !== void 0 ? _l : [], packageName, options.serviceRestartHandles);
    }
    /**
     * Install a package from RubyGems
     */
    static rubyGem(gemName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_NamedPackageOptions(options);
        return new InitPackage('rubygems', (_l = options.version) !== null && _l !== void 0 ? _l : [], gemName, options.serviceRestartHandles);
    }
    /**
     * Install a package from PyPI
     */
    static python(packageName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_NamedPackageOptions(options);
        return new InitPackage('python', (_l = options.version) !== null && _l !== void 0 ? _l : [], packageName, options.serviceRestartHandles);
    }
    /**
     * Install a package using APT
     */
    static apt(packageName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_NamedPackageOptions(options);
        return new InitPackage('apt', (_l = options.version) !== null && _l !== void 0 ? _l : [], packageName, options.serviceRestartHandles);
    }
    /**
     * Install an MSI package from an HTTP URL or a location on disk
     */
    static msi(location, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_LocationPackageOptions(options);
        // The MSI package version must be a string, not an array.
        return new class extends InitPackage {
            renderPackageVersions() { return location; }
        }('msi', [location], options.key, options.serviceRestartHandles);
    }
    /** @internal */
    _bind(options) {
        var _l;
        if ((this.type === 'msi') !== (options.platform === cfn_init_internal_1.InitPlatform.WINDOWS)) {
            if (this.type === 'msi') {
                throw new Error('MSI installers are only supported on Windows systems.');
            }
            else {
                throw new Error('Windows only supports the MSI package type');
            }
        }
        if (!this.packageName && !['rpm', 'msi'].includes(this.type)) {
            throw new Error('Package name must be specified for all package types besides RPM and MSI.');
        }
        const packageName = this.packageName || `${options.index}`.padStart(3, '0');
        for (const handle of (_l = this.serviceHandles) !== null && _l !== void 0 ? _l : []) {
            handle._addPackage(this.type, packageName);
        }
        return {
            config: {
                [this.type]: {
                    [packageName]: this.renderPackageVersions(),
                },
            },
        };
    }
    renderPackageVersions() {
        return this.versions;
    }
}
exports.InitPackage = InitPackage;
_h = JSII_RTTI_SYMBOL_1;
InitPackage[_h] = { fqn: "@aws-cdk/aws-ec2.InitPackage", version: "1.152.0" };
/**
 * A services that be enabled, disabled or restarted when the instance is launched.
 */
class InitService extends InitElement {
    constructor(serviceName, serviceOptions) {
        super();
        this.serviceName = serviceName;
        this.serviceOptions = serviceOptions;
        this.elementType = cfn_init_internal_1.InitElementType.SERVICE.toString();
    }
    /**
     * Enable and start the given service, optionally restarting it
     */
    static enable(serviceName, options = {}) {
        var _l;
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitServiceOptions(options);
        const { enabled, ensureRunning, ...otherOptions } = options;
        return new InitService(serviceName, {
            enabled: enabled !== null && enabled !== void 0 ? enabled : true,
            ensureRunning: (_l = ensureRunning !== null && ensureRunning !== void 0 ? ensureRunning : enabled) !== null && _l !== void 0 ? _l : true,
            ...otherOptions,
        });
    }
    /**
     * Disable and stop the given service
     */
    static disable(serviceName) {
        return new InitService(serviceName, { enabled: false, ensureRunning: false });
    }
    /** @internal */
    _bind(options) {
        var _l;
        const serviceManager = options.platform === cfn_init_internal_1.InitPlatform.LINUX ? 'sysvinit' : 'windows';
        return {
            config: {
                [serviceManager]: {
                    [this.serviceName]: {
                        enabled: this.serviceOptions.enabled,
                        ensureRunning: this.serviceOptions.ensureRunning,
                        ...(_l = this.serviceOptions.serviceRestartHandle) === null || _l === void 0 ? void 0 : _l._renderRestartHandles(),
                    },
                },
            },
        };
    }
}
exports.InitService = InitService;
_j = JSII_RTTI_SYMBOL_1;
InitService[_j] = { fqn: "@aws-cdk/aws-ec2.InitService", version: "1.152.0" };
/**
 * Extract an archive into a directory
 */
class InitSource extends InitElement {
    constructor(targetDirectory, serviceHandles) {
        super();
        this.targetDirectory = targetDirectory;
        this.serviceHandles = serviceHandles;
        this.elementType = cfn_init_internal_1.InitElementType.SOURCE.toString();
    }
    /**
     * Retrieve a URL and extract it into the given directory
     */
    static fromUrl(targetDirectory, url, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceOptions(options);
        return new class extends InitSource {
            _doBind() {
                return {
                    config: { [this.targetDirectory]: url },
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /**
     * Extract a GitHub branch into a given directory
     */
    static fromGitHub(targetDirectory, owner, repo, refSpec, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceOptions(options);
        return InitSource.fromUrl(targetDirectory, `https://github.com/${owner}/${repo}/tarball/${refSpec !== null && refSpec !== void 0 ? refSpec : 'master'}`, options);
    }
    /**
     * Extract an archive stored in an S3 bucket into the given directory
     */
    static fromS3Object(targetDirectory, bucket, key, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceOptions(options);
        return new class extends InitSource {
            _doBind(bindOptions) {
                bucket.grantRead(bindOptions.instanceRole, key);
                return {
                    config: { [this.targetDirectory]: bucket.urlForObject(key) },
                    authentication: standardS3Auth(bindOptions.instanceRole, bucket.bucketName),
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /**
     * Create an InitSource from an asset created from the given path.
     */
    static fromAsset(targetDirectory, path, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceAssetOptions(options);
        return new class extends InitSource {
            _doBind(bindOptions) {
                const asset = new s3_assets.Asset(bindOptions.scope, `${targetDirectory}Asset`, {
                    path,
                    ...bindOptions,
                });
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: { [this.targetDirectory]: asset.httpUrl },
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /**
     * Extract a directory from an existing directory asset.
     */
    static fromExistingAsset(targetDirectory, asset, options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_InitSourceOptions(options);
        return new class extends InitSource {
            _doBind(bindOptions) {
                asset.grantRead(bindOptions.instanceRole);
                return {
                    config: { [this.targetDirectory]: asset.httpUrl },
                    authentication: standardS3Auth(bindOptions.instanceRole, asset.s3BucketName),
                    assetHash: asset.assetHash,
                };
            }
        }(targetDirectory, options.serviceRestartHandles);
    }
    /** @internal */
    _bind(options) {
        var _l;
        for (const handle of (_l = this.serviceHandles) !== null && _l !== void 0 ? _l : []) {
            handle._addSource(this.targetDirectory);
        }
        // Delegate actual bind to subclasses
        return this._doBind(options);
    }
}
exports.InitSource = InitSource;
_k = JSII_RTTI_SYMBOL_1;
InitSource[_k] = { fqn: "@aws-cdk/aws-ec2.InitSource", version: "1.152.0" };
/**
 * Render a standard S3 auth block for use in AWS::CloudFormation::Authentication
 *
 * This block is the same every time (modulo bucket name), so it has the same
 * key every time so the blocks are merged into one in the final render.
 */
function standardS3Auth(role, bucketName) {
    return {
        S3AccessCreds: {
            type: 'S3',
            roleName: role.roleName,
            buckets: [bucketName],
        },
    };
}
//# sourceMappingURL=data:application/json;base64,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