import random

from sybil_engine.contract.deploy_contract import DeployContract
from sybil_engine.data.networks import get_chain_instance
from sybil_engine.module.module import Module
from sybil_engine.utils.web3_utils import init_web3

erc_20_decoded = (
    "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"
    "8746573746261736500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000087465737462617365000000000000000000000000000000000000000000000000")


class SmartContractDeployment(Module):
    module_name = 'SMART_CONTRACT_DEPLOYMENT'
    module_config = 'smart_contract_deployment'

    def execute(self, chain, account):
        chain_instance = get_chain_instance(chain)
        web3 = init_web3(chain_instance, account.proxy)

        random_string = self.generate_random_string()

        erc_20_decoded = (
            f"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"
            f"{random_string}000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000{random_string}000000000000000000000000000000000000000000000000")

        DeployContract(None, web3).deploy(account, erc_20_decoded)

    def generate_random_string(self, length=18):
        random_hex = ''.join(random.choice('0123456789abcdef') for _ in range(length))
        return random_hex

    def log(self):
        return "Smart Contract Deployment"

    def parse_params(self, module_params):
        return [module_params['chain']]
