from sybil_engine.data.contracts import get_contracts_for_chain
from sybil_engine.data.networks import get_chain_instance
from sybil_engine.utils.web3_utils import init_web3

from libs.web3_wizzard_lib.core.contract.nidum_contract import NidumContract
from libs.web3_wizzard_lib.core.utils.sub_module import SubModule


class NidumBonus(SubModule):
    module_name = 'NIDUM_BONUS'
    allow_reuse_address = True

    def execute(self, account, chain='LINEA'):
        chain_instance = get_chain_instance(chain)
        web3 = init_web3(chain_instance, account.proxy)

        contract_address = get_contracts_for_chain(chain)['NIDUM']
        nidum_nft = NidumContract(contract_address, web3)

        nidum_nft.burn(account)

    def log(self):
        return "NIDUM BONUS NFT"