from sybil_engine.contract.weth import WETH
from sybil_engine.data.networks import get_ids_chain
from sybil_engine.data.tokens import get_tokens_for_chain

from libs.web3_wizzard_lib.core.contract.aavecontract import AaveContract
from libs.web3_wizzard_lib.core.modules.bank.bank import Bank


class Aave(Bank):
    app_name = 'AAVE'
    supported_chains = ['SCROLL']

    def __init__(self, contract, web3):
        self.contract = AaveContract(contract, web3)

    def supply(self, account, amount):
        self.contract.depositETH(account, amount.wei)

    def redeem(self, account, withdraw):
        self.contract.withdrawETH(account, withdraw.wei)

    def get_deposit_amount(self, account, token):
        weth_token = get_tokens_for_chain(get_ids_chain()[self.contract.web3.eth.chain_id])['AAVE_WETH']

        return WETH(weth_token, self.contract.web3).balance_of(account)
