# -*- coding: utf-8
conversation={
    "test2Axes":[
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Execute>
      <Command>
        <Statement>select {[Measures].ALLMEMBERS} * {[Date].[Month of Year].ALLMEMBERS} on columns, 
                       [Product].[Product Categories].[Category].ALLMEMBERS on rows 
                from [Sales Summary]</Statement>
      </Command>
      <Properties>
        <PropertyList>
          <Format>Multidimensional</Format>
          <AxisFormat>TupleFormat</AxisFormat>
          <Catalog>Adventure Works DW 2008R2</Catalog>
        </PropertyList>
      </Properties>
    </Execute>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
  <soap:Body>
    <ExecuteResponse xmlns="urn:schemas-microsoft-com:xml-analysis">
      <return>
        <root xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla">
          <xs:schema xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla" targetNamespace="urn:schemas-microsoft-com:xml-analysis:mddataset" elementFormDefault="qualified">
            <xs:import namespace="http://schemas.microsoft.com/analysisservices/2003/xmla"/>
            <xs:complexType name="MemberType">
              <xs:sequence>
                <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string"/>
            </xs:complexType>
            <xs:complexType name="PropType">
              <xs:sequence>
                <xs:element name="Default" minOccurs="0"/>
              </xs:sequence>
              <xs:attribute name="name" type="xs:string" use="required"/>
              <xs:attribute name="type" type="xs:QName"/>
            </xs:complexType>
            <xs:complexType name="TupleType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="MembersType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string" use="required"/>
            </xs:complexType>
            <xs:complexType name="TuplesType">
              <xs:sequence>
                <xs:element name="Tuple" type="TupleType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:group name="SetType">
              <xs:choice>
                <xs:element name="Members" type="MembersType"/>
                <xs:element name="Tuples" type="TuplesType"/>
                <xs:element name="CrossProduct" type="SetListType"/>
                <xs:element ref="msxmla:NormTupleSet"/>
                <xs:element name="Union">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                  </xs:complexType>
                </xs:element>
              </xs:choice>
            </xs:group>
            <xs:complexType name="SetListType">
              <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
              <xs:attribute name="Size" type="xs:unsignedInt"/>
            </xs:complexType>
            <xs:complexType name="OlapInfo">
              <xs:sequence>
                <xs:element name="CubeInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="Cube" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="CubeName" type="xs:string"/>
                            <xs:element name="LastDataUpdate" minOccurs="0" type="xs:dateTime"/>
                            <xs:element name="LastSchemaUpdate" minOccurs="0" type="xs:dateTime"/>
                          </xs:sequence>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="AxesInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="AxisInfo" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="HierarchyInfo" minOccurs="0" maxOccurs="unbounded">
                              <xs:complexType>
                                <xs:sequence>
                                  <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                                </xs:sequence>
                                <xs:attribute name="name" type="xs:string" use="required"/>
                              </xs:complexType>
                            </xs:element>
                          </xs:sequence>
                          <xs:attribute name="name" type="xs:string"/>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="CellInfo">
                  <xs:complexType>
                    <xs:choice minOccurs="0" maxOccurs="unbounded">
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:choice>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="Axes">
              <xs:sequence>
                <xs:element name="Axis" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                    <xs:attribute name="name" type="xs:string"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="CellData">
              <xs:sequence>
                <xs:element name="Cell" minOccurs="0" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:sequence>
                    <xs:attribute name="CellOrdinal" type="xs:unsignedInt" use="required"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:element name="root">
              <xs:complexType>
                <xs:sequence>
                  <xs:any namespace="http://www.w3.org/2001/XMLSchema" processContents="strict" minOccurs="0"/>
                  <xs:element name="OlapInfo" type="OlapInfo" minOccurs="0"/>
                  <xs:element name="Axes" type="Axes" minOccurs="0"/>
                  <xs:element name="CellData" type="CellData" minOccurs="0"/>
                </xs:sequence>
              </xs:complexType>
            </xs:element>
          </xs:schema>
          <OlapInfo>
            <CubeInfo>
              <Cube>
                <CubeName>Sales Summary</CubeName>
                <LastDataUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-24T11:57:43.523333</LastDataUpdate>
                <LastSchemaUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-23T23:01:05.413333</LastSchemaUpdate>
              </Cube>
            </CubeInfo>
            <AxesInfo>
              <AxisInfo name="Axis0">
                <HierarchyInfo name="[Measures]">
                  <UName name="[Measures].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Measures].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Measures].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Measures].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Measures].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Month of Year]">
                  <UName name="[Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
              <AxisInfo name="Axis1">
                <HierarchyInfo name="[Product].[Product Categories]">
                  <UName name="[Product].[Product Categories].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Categories].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Categories].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Categories].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Categories].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
              <AxisInfo name="SlicerAxis">
                <HierarchyInfo name="[Date].[Fiscal]">
                  <UName name="[Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar]">
                  <UName name="[Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Weeks]">
                  <UName name="[Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Weeks]">
                  <UName name="[Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Year]">
                  <UName name="[Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Date]">
                  <UName name="[Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Week]">
                  <UName name="[Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day Name]">
                  <UName name="[Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Month]">
                  <UName name="[Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Year]">
                  <UName name="[Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Year]">
                  <UName name="[Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Semester of Year]">
                  <UName name="[Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Semester of Year]">
                  <UName name="[Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Quarter of Year]">
                  <UName name="[Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Quarter of Year]">
                  <UName name="[Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Week of Year]">
                  <UName name="[Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Week of Year]">
                  <UName name="[Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal]">
                  <UName name="[Ship Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar]">
                  <UName name="[Ship Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Weeks]">
                  <UName name="[Ship Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Weeks]">
                  <UName name="[Ship Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Year]">
                  <UName name="[Ship Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Date]">
                  <UName name="[Ship Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Week]">
                  <UName name="[Ship Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day Name]">
                  <UName name="[Ship Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Month]">
                  <UName name="[Ship Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Year]">
                  <UName name="[Ship Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Year]">
                  <UName name="[Ship Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Semester of Year]">
                  <UName name="[Ship Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Semester of Year]">
                  <UName name="[Ship Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Quarter of Year]">
                  <UName name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Quarter of Year]">
                  <UName name="[Ship Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Month of Year]">
                  <UName name="[Ship Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Week of Year]">
                  <UName name="[Ship Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Week of Year]">
                  <UName name="[Ship Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal]">
                  <UName name="[Delivery Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar]">
                  <UName name="[Delivery Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Weeks]">
                  <UName name="[Delivery Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Weeks]">
                  <UName name="[Delivery Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Year]">
                  <UName name="[Delivery Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Date]">
                  <UName name="[Delivery Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Week]">
                  <UName name="[Delivery Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day Name]">
                  <UName name="[Delivery Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Month]">
                  <UName name="[Delivery Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Year]">
                  <UName name="[Delivery Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Year]">
                  <UName name="[Delivery Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Semester of Year]">
                  <UName name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Semester of Year]">
                  <UName name="[Delivery Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Quarter of Year]">
                  <UName name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Quarter of Year]">
                  <UName name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Month of Year]">
                  <UName name="[Delivery Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Week of Year]">
                  <UName name="[Delivery Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Week of Year]">
                  <UName name="[Delivery Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotions]">
                  <UName name="[Promotion].[Promotions].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotions].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotions].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotions].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotions].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion]">
                  <UName name="[Promotion].[Promotion].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Discount Percent]">
                  <UName name="[Promotion].[Discount Percent].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Discount Percent].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Discount Percent].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Discount Percent].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Discount Percent].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Max Quantity]">
                  <UName name="[Promotion].[Max Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Max Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Max Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Max Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Max Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Type]">
                  <UName name="[Promotion].[Promotion Type].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Type].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Type].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Type].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Type].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Min Quantity]">
                  <UName name="[Promotion].[Min Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Min Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Min Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Min Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Min Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Category]">
                  <UName name="[Promotion].[Promotion Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[End Date]">
                  <UName name="[Promotion].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Start Date]">
                  <UName name="[Promotion].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Model Lines]">
                  <UName name="[Product].[Product Model Lines].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Model Lines].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Model Lines].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Model Lines].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Model Lines].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Stock Level]">
                  <UName name="[Product].[Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product]">
                  <UName name="[Product].[Product].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Standard Cost]">
                  <UName name="[Product].[Standard Cost].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Standard Cost].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Standard Cost].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Standard Cost].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Standard Cost].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Category]">
                  <UName name="[Product].[Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Color]">
                  <UName name="[Product].[Color].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Color].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Color].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Color].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Color].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Safety Stock Level]">
                  <UName name="[Product].[Safety Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Safety Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Safety Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Safety Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Safety Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Reorder Point]">
                  <UName name="[Product].[Reorder Point].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Reorder Point].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Reorder Point].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Reorder Point].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Reorder Point].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[List Price]">
                  <UName name="[Product].[List Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[List Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[List Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[List Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[List Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size]">
                  <UName name="[Product].[Size].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size Range]">
                  <UName name="[Product].[Size Range].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size Range].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size Range].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size Range].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size Range].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Weight]">
                  <UName name="[Product].[Weight].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Weight].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Weight].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Weight].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Weight].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Days to Manufacture]">
                  <UName name="[Product].[Days to Manufacture].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Days to Manufacture].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Days to Manufacture].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Days to Manufacture].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Days to Manufacture].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Dealer Price]">
                  <UName name="[Product].[Dealer Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Dealer Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Dealer Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Dealer Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Dealer Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Class]">
                  <UName name="[Product].[Class].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Class].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Class].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Class].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Class].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Style]">
                  <UName name="[Product].[Style].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Style].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Style].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Style].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Style].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Model Name]">
                  <UName name="[Product].[Model Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Model Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Model Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Model Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Model Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Line]">
                  <UName name="[Product].[Product Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Subcategory]">
                  <UName name="[Product].[Subcategory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Subcategory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Subcategory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Subcategory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Subcategory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Status]">
                  <UName name="[Product].[Status].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Status].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Status].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Status].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Status].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Start Date]">
                  <UName name="[Product].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[End Date]">
                  <UName name="[Product].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Large Photo]">
                  <UName name="[Product].[Large Photo].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Large Photo].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Large Photo].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Large Photo].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Large Photo].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory]">
                  <UName name="[Sales Territory].[Sales Territory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Region]">
                  <UName name="[Sales Territory].[Sales Territory Region].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Region].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Region].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Region].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Region].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Country]">
                  <UName name="[Sales Territory].[Sales Territory Country].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Country].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Country].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Country].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Country].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Group]">
                  <UName name="[Sales Territory].[Sales Territory Group].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Group].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Group].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Group].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Group].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Orders]">
                  <UName name="[Sales Summary Order Details].[Sales Orders].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Orders].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Orders].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Orders].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Orders].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Carrier Tracking Number]">
                  <UName name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Carrier Tracking Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Customer PO Number]">
                  <UName name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Customer PO Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Number]">
                  <UName name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Line]">
                  <UName name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency Code]">
                  <UName name="[Source Currency].[Source Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency]">
                  <UName name="[Source Currency].[Source Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency]">
                  <UName name="[Destination Currency].[Destination Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency Code]">
                  <UName name="[Destination Currency].[Destination Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Channel].[Sales Channel]">
                  <UName name="[Sales Channel].[Sales Channel].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Channel].[Sales Channel].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Channel].[Sales Channel].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Channel].[Sales Channel].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Channel].[Sales Channel].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
            </AxesInfo>
            <CellInfo>
              <Value name="VALUE"/>
              <FmtValue name="FORMATTED_VALUE" type="xsd:string"/>
              <CellOrdinal name="CELL_ORDINAL" type="xsd:unsignedInt"/>
            </CellInfo>
          </OlapInfo>
          <Axes>
            <Axis name="Axis0">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
            <Axis name="Axis1">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[Category].&amp;[4]</UName>
                    <Caption>Accessories</Caption>
                    <LName>[Product].[Product Categories].[Category]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[Category].&amp;[1]</UName>
                    <Caption>Bikes</Caption>
                    <LName>[Product].[Product Categories].[Category]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131075</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[Category].&amp;[3]</UName>
                    <Caption>Clothing</Caption>
                    <LName>[Product].[Product Categories].[Category]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131080</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[Category].&amp;[2]</UName>
                    <Caption>Components</Caption>
                    <LName>[Product].[Product Categories].[Category]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131086</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
            <Axis name="SlicerAxis">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Date].[Fiscal]">
                    <UName>[Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar]">
                    <UName>[Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Weeks]">
                    <UName>[Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Weeks]">
                    <UName>[Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Year]">
                    <UName>[Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Date]">
                    <UName>[Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Week]">
                    <UName>[Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day Name]">
                    <UName>[Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Month]">
                    <UName>[Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Year]">
                    <UName>[Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Year]">
                    <UName>[Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Semester of Year]">
                    <UName>[Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Semester of Year]">
                    <UName>[Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Quarter of Year]">
                    <UName>[Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Quarter of Year]">
                    <UName>[Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Week of Year]">
                    <UName>[Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Week of Year]">
                    <UName>[Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal]">
                    <UName>[Ship Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar]">
                    <UName>[Ship Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Weeks]">
                    <UName>[Ship Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Weeks]">
                    <UName>[Ship Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Year]">
                    <UName>[Ship Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Date]">
                    <UName>[Ship Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Week]">
                    <UName>[Ship Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day Name]">
                    <UName>[Ship Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Month]">
                    <UName>[Ship Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Year]">
                    <UName>[Ship Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Year]">
                    <UName>[Ship Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Semester of Year]">
                    <UName>[Ship Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Semester of Year]">
                    <UName>[Ship Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Quarter of Year]">
                    <UName>[Ship Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Quarter of Year]">
                    <UName>[Ship Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Month of Year]">
                    <UName>[Ship Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Week of Year]">
                    <UName>[Ship Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Week of Year]">
                    <UName>[Ship Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal]">
                    <UName>[Delivery Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar]">
                    <UName>[Delivery Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Weeks]">
                    <UName>[Delivery Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Weeks]">
                    <UName>[Delivery Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Year]">
                    <UName>[Delivery Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Date]">
                    <UName>[Delivery Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Week]">
                    <UName>[Delivery Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day Name]">
                    <UName>[Delivery Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Month]">
                    <UName>[Delivery Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Year]">
                    <UName>[Delivery Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Year]">
                    <UName>[Delivery Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Semester of Year]">
                    <UName>[Delivery Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Semester of Year]">
                    <UName>[Delivery Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Quarter of Year]">
                    <UName>[Delivery Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Quarter of Year]">
                    <UName>[Delivery Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Month of Year]">
                    <UName>[Delivery Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Week of Year]">
                    <UName>[Delivery Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Week of Year]">
                    <UName>[Delivery Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotions]">
                    <UName>[Promotion].[Promotions].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotions].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion]">
                    <UName>[Promotion].[Promotion].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>16</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Discount Percent]">
                    <UName>[Promotion].[Discount Percent].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Discount Percent].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Max Quantity]">
                    <UName>[Promotion].[Max Quantity].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Max Quantity].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion Type]">
                    <UName>[Promotion].[Promotion Type].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion Type].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Min Quantity]">
                    <UName>[Promotion].[Min Quantity].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Min Quantity].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion Category]">
                    <UName>[Promotion].[Promotion Category].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion Category].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>3</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[End Date]">
                    <UName>[Promotion].[End Date].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[End Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Start Date]">
                    <UName>[Promotion].[Start Date].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Start Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>8</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Model Lines]">
                    <UName>[Product].[Product Model Lines].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Model Lines].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Stock Level]">
                    <UName>[Product].[Stock Level].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Stock Level].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product]">
                    <UName>[Product].[Product].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>397</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Standard Cost]">
                    <UName>[Product].[Standard Cost].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Standard Cost].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>135</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Category]">
                    <UName>[Product].[Category].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Category].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Color]">
                    <UName>[Product].[Color].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Color].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Safety Stock Level]">
                    <UName>[Product].[Safety Stock Level].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Safety Stock Level].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Reorder Point]">
                    <UName>[Product].[Reorder Point].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Reorder Point].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[List Price]">
                    <UName>[Product].[List Price].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[List Price].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>121</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Size]">
                    <UName>[Product].[Size].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Size].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>19</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Size Range]">
                    <UName>[Product].[Size Range].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Size Range].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>11</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Weight]">
                    <UName>[Product].[Weight].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Weight].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>128</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Days to Manufacture]">
                    <UName>[Product].[Days to Manufacture].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Days to Manufacture].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Dealer Price]">
                    <UName>[Product].[Dealer Price].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Dealer Price].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>121</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Class]">
                    <UName>[Product].[Class].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Class].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Style]">
                    <UName>[Product].[Style].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Style].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Model Name]">
                    <UName>[Product].[Model Name].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Model Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>120</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Line]">
                    <UName>[Product].[Product Line].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Line].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Subcategory]">
                    <UName>[Product].[Subcategory].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Subcategory].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>37</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Status]">
                    <UName>[Product].[Status].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Status].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Start Date]">
                    <UName>[Product].[Start Date].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Start Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[End Date]">
                    <UName>[Product].[End Date].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[End Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>3</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Large Photo]">
                    <UName>[Product].[Large Photo].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Large Photo].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>606</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory]">
                    <UName>[Sales Territory].[Sales Territory].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Region]">
                    <UName>[Sales Territory].[Sales Territory Region].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Region].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>11</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Country]">
                    <UName>[Sales Territory].[Sales Territory Country].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Country].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Group]">
                    <UName>[Sales Territory].[Sales Territory Group].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Group].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Orders]">
                    <UName>[Sales Summary Order Details].[Sales Orders].[All]</UName>
                    <Caption>All</Caption>
                    <LName>[Sales Summary Order Details].[Sales Orders].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Carrier Tracking Number]">
                    <UName>[Sales Summary Order Details].[Carrier Tracking Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Carrier Tracking Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Customer PO Number]">
                    <UName>[Sales Summary Order Details].[Customer PO Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Customer PO Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Order Number]">
                    <UName>[Sales Summary Order Details].[Sales Order Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Sales Order Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Order Line]">
                    <UName>[Sales Summary Order Details].[Sales Order Line].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Sales Order Line].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Source Currency].[Source Currency Code]">
                    <UName>[Source Currency].[Source Currency Code].[All Source Currencies]</UName>
                    <Caption>All Source Currencies</Caption>
                    <LName>[Source Currency].[Source Currency Code].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>105</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Source Currency].[Source Currency]">
                    <UName>[Source Currency].[Source Currency].[All Source Currencies]</UName>
                    <Caption>All Source Currencies</Caption>
                    <LName>[Source Currency].[Source Currency].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>105</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Destination Currency].[Destination Currency]">
                    <UName>[Destination Currency].[Destination Currency].&amp;[US Dollar]</UName>
                    <Caption>US Dollar</Caption>
                    <LName>[Destination Currency].[Destination Currency].[Destination Currency]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Destination Currency].[Destination Currency Code]">
                    <UName>[Destination Currency].[Destination Currency Code].[All Destination Currencies]</UName>
                    <Caption>All Destination Currencies</Caption>
                    <LName>[Destination Currency].[Destination Currency Code].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>14</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Channel].[Sales Channel]">
                    <UName>[Sales Channel].[Sales Channel].[All Sales Channels]</UName>
                    <Caption>All Sales Channels</Caption>
                    <LName>[Sales Channel].[Sales Channel].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
          </Axes>
          <CellData>
            <Cell CellOrdinal="0">
              <Value xsi:type="xsd:int">61931</Value>
              <FmtValue>61,931</FmtValue>
            </Cell>
            <Cell CellOrdinal="1">
              <Value xsi:type="xsd:int">4009</Value>
              <FmtValue>4,009</FmtValue>
            </Cell>
            <Cell CellOrdinal="2">
              <Value xsi:type="xsd:int">4133</Value>
              <FmtValue>4,133</FmtValue>
            </Cell>
            <Cell CellOrdinal="3">
              <Value xsi:type="xsd:int">4186</Value>
              <FmtValue>4,186</FmtValue>
            </Cell>
            <Cell CellOrdinal="4">
              <Value xsi:type="xsd:int">5106</Value>
              <FmtValue>5,106</FmtValue>
            </Cell>
            <Cell CellOrdinal="5">
              <Value xsi:type="xsd:int">6091</Value>
              <FmtValue>6,091</FmtValue>
            </Cell>
            <Cell CellOrdinal="6">
              <Value xsi:type="xsd:int">5782</Value>
              <FmtValue>5,782</FmtValue>
            </Cell>
            <Cell CellOrdinal="7">
              <Value xsi:type="xsd:int">4911</Value>
              <FmtValue>4,911</FmtValue>
            </Cell>
            <Cell CellOrdinal="8">
              <Value xsi:type="xsd:int">6167</Value>
              <FmtValue>6,167</FmtValue>
            </Cell>
            <Cell CellOrdinal="9">
              <Value xsi:type="xsd:int">5800</Value>
              <FmtValue>5,800</FmtValue>
            </Cell>
            <Cell CellOrdinal="10">
              <Value xsi:type="xsd:int">4664</Value>
              <FmtValue>4,664</FmtValue>
            </Cell>
            <Cell CellOrdinal="11">
              <Value xsi:type="xsd:int">5357</Value>
              <FmtValue>5,357</FmtValue>
            </Cell>
            <Cell CellOrdinal="12">
              <Value xsi:type="xsd:int">5725</Value>
              <FmtValue>5,725</FmtValue>
            </Cell>
            <Cell CellOrdinal="13">
              <Value xsi:type="xsd:double">1.278745912500016E6</Value>
              <FmtValue>$1,278,745.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="14">
              <Value xsi:type="xsd:double">7.849123800000052E4</Value>
              <FmtValue>$78,491.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="15">
              <Value xsi:type="xsd:double">8.387708010000059E4</Value>
              <FmtValue>$83,877.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="16">
              <Value xsi:type="xsd:double">8.668909420000086E4</Value>
              <FmtValue>$86,689.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="17">
              <Value xsi:type="xsd:double">1.0211755460000111E5</Value>
              <FmtValue>$102,117.55</FmtValue>
            </Cell>
            <Cell CellOrdinal="18">
              <Value xsi:type="xsd:double">1.308690574000023E5</Value>
              <FmtValue>$130,869.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="19">
              <Value xsi:type="xsd:double">1.1897936210000154E5</Value>
              <FmtValue>$118,979.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="20">
              <Value xsi:type="xsd:double">9.44542341E4</Value>
              <FmtValue>$94,454.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="21">
              <Value xsi:type="xsd:double">1.2935175920000227E5</Value>
              <FmtValue>$129,351.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="22">
              <Value xsi:type="xsd:double">1.2642585030000248E5</Value>
              <FmtValue>$126,425.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="23">
              <Value xsi:type="xsd:double">9.499382970000095E4</Value>
              <FmtValue>$94,993.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="24">
              <Value xsi:type="xsd:double">1.1363819050000171E5</Value>
              <FmtValue>$113,638.19</FmtValue>
            </Cell>
            <Cell CellOrdinal="25">
              <Value xsi:type="xsd:double">1.1885866230000168E5</Value>
              <FmtValue>$118,858.66</FmtValue>
            </Cell>
            <Cell CellOrdinal="26">
              <Value xsi:type="xsd:double">3.332082835000037E5</Value>
              <FmtValue>$333,208.28</FmtValue>
            </Cell>
            <Cell CellOrdinal="27">
              <Value xsi:type="xsd:double">2.455239320000022E4</Value>
              <FmtValue>$24,552.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="28">
              <Value xsi:type="xsd:double">2.5473195900000286E4</Value>
              <FmtValue>$25,473.20</FmtValue>
            </Cell>
            <Cell CellOrdinal="29">
              <Value xsi:type="xsd:double">2.6580156200000332E4</Value>
              <FmtValue>$26,580.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="30">
              <Value xsi:type="xsd:double">2.7999770400000332E4</Value>
              <FmtValue>$27,999.77</FmtValue>
            </Cell>
            <Cell CellOrdinal="31">
              <Value xsi:type="xsd:double">3.4040667100000464E4</Value>
              <FmtValue>$34,040.67</FmtValue>
            </Cell>
            <Cell CellOrdinal="32">
              <Value xsi:type="xsd:double">3.091493140000048E4</Value>
              <FmtValue>$30,914.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="33">
              <Value xsi:type="xsd:double">2.3280379099999903E4</Value>
              <FmtValue>$23,280.38</FmtValue>
            </Cell>
            <Cell CellOrdinal="34">
              <Value xsi:type="xsd:double">2.927191790000037E4</Value>
              <FmtValue>$29,271.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="35">
              <Value xsi:type="xsd:double">2.7631528300000362E4</Value>
              <FmtValue>$27,631.53</FmtValue>
            </Cell>
            <Cell CellOrdinal="36">
              <Value xsi:type="xsd:double">2.486094400000022E4</Value>
              <FmtValue>$24,860.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="37">
              <Value xsi:type="xsd:double">2.7735914300000367E4</Value>
              <FmtValue>$27,735.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="38">
              <Value xsi:type="xsd:double">3.086648570000037E4</Value>
              <FmtValue>$30,866.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="39">
              <Value xsi:type="xsd:double">6.375907260000077E5</Value>
              <FmtValue>$637,590.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="40">
              <Value xsi:type="xsd:double">3.513692940000054E4</Value>
              <FmtValue>$35,136.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="41">
              <Value xsi:type="xsd:double">3.83948251000006E4</Value>
              <FmtValue>$38,394.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="42">
              <Value xsi:type="xsd:double">3.934058720000064E4</Value>
              <FmtValue>$39,340.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="43">
              <Value xsi:type="xsd:double">4.9107745000000774E4</Value>
              <FmtValue>$49,107.75</FmtValue>
            </Cell>
            <Cell CellOrdinal="44">
              <Value xsi:type="xsd:double">6.4615463100000736E4</Value>
              <FmtValue>$64,615.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="45">
              <Value xsi:type="xsd:double">5.880935850000073E4</Value>
              <FmtValue>$58,809.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="46">
              <Value xsi:type="xsd:double">5.143729600000018E4</Value>
              <FmtValue>$51,437.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="47">
              <Value xsi:type="xsd:double">6.960403490000065E4</Value>
              <FmtValue>$69,604.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="48">
              <Value xsi:type="xsd:double">6.778843390000067E4</Value>
              <FmtValue>$67,788.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="49">
              <Value xsi:type="xsd:double">4.6472736700000736E4</Value>
              <FmtValue>$46,472.74</FmtValue>
            </Cell>
            <Cell CellOrdinal="50">
              <Value xsi:type="xsd:double">5.8255437300000616E4</Value>
              <FmtValue>$58,255.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="51">
              <Value xsi:type="xsd:double">5.862787890000084E4</Value>
              <FmtValue>$58,627.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="52">
              <Value xsi:type="xsd:double">1.272057887800016E6</Value>
              <FmtValue>$1,272,057.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="53">
              <Value xsi:type="xsd:double">7.849123800000052E4</Value>
              <FmtValue>$78,491.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="54">
              <Value xsi:type="xsd:double">8.38540568000006E4</Value>
              <FmtValue>$83,854.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="55">
              <Value xsi:type="xsd:double">8.668339650000086E4</Value>
              <FmtValue>$86,683.40</FmtValue>
            </Cell>
            <Cell CellOrdinal="56">
              <Value xsi:type="xsd:double">1.0167032570000105E5</Value>
              <FmtValue>$101,670.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="57">
              <Value xsi:type="xsd:double">1.3057750940000231E5</Value>
              <FmtValue>$130,577.51</FmtValue>
            </Cell>
            <Cell CellOrdinal="58">
              <Value xsi:type="xsd:double">1.1868037840000156E5</Value>
              <FmtValue>$118,680.38</FmtValue>
            </Cell>
            <Cell CellOrdinal="59">
              <Value xsi:type="xsd:double">9.153785850000013E4</Value>
              <FmtValue>$91,537.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="60">
              <Value xsi:type="xsd:double">1.286070443000022E5</Value>
              <FmtValue>$128,607.04</FmtValue>
            </Cell>
            <Cell CellOrdinal="61">
              <Value xsi:type="xsd:double">1.2548515060000241E5</Value>
              <FmtValue>$125,485.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="62">
              <Value xsi:type="xsd:double">9.468758350000095E4</Value>
              <FmtValue>$94,687.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="63">
              <Value xsi:type="xsd:double">1.1325114030000168E5</Value>
              <FmtValue>$113,251.14</FmtValue>
            </Cell>
            <Cell CellOrdinal="64">
              <Value xsi:type="xsd:double">1.1853220580000171E5</Value>
              <FmtValue>$118,532.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="65">
              <Value xsi:type="xsd:double">1.0176462860000023E5</Value>
              <FmtValue>$101,764.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="66">
              <Value xsi:type="xsd:double">6.279298699999981E3</Value>
              <FmtValue>$6,279.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="67">
              <Value xsi:type="xsd:double">6.70832459999999E3</Value>
              <FmtValue>$6,708.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="68">
              <Value xsi:type="xsd:double">6.934671499999995E3</Value>
              <FmtValue>$6,934.67</FmtValue>
            </Cell>
            <Cell CellOrdinal="69">
              <Value xsi:type="xsd:double">8.133625800000027E3</Value>
              <FmtValue>$8,133.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="70">
              <Value xsi:type="xsd:double">1.0446200800000011E4</Value>
              <FmtValue>$10,446.20</FmtValue>
            </Cell>
            <Cell CellOrdinal="71">
              <Value xsi:type="xsd:double">9.494430000000044E3</Value>
              <FmtValue>$9,494.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="72">
              <Value xsi:type="xsd:double">7.32303029999996E3</Value>
              <FmtValue>$7,323.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="73">
              <Value xsi:type="xsd:double">1.0288562700000055E4</Value>
              <FmtValue>$10,288.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="74">
              <Value xsi:type="xsd:double">1.0038811100000062E4</Value>
              <FmtValue>$10,038.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="75">
              <Value xsi:type="xsd:double">7.575006100000007E3</Value>
              <FmtValue>$7,575.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="76">
              <Value xsi:type="xsd:double">9.060091100000061E3</Value>
              <FmtValue>$9,060.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="77">
              <Value xsi:type="xsd:double">9.482575900000049E3</Value>
              <FmtValue>$9,482.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="78">
              <Value xsi:type="xsd:double">3.1803079100000483E4</Value>
              <FmtValue>$31,803.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="79">
              <Value xsi:type="xsd:double">1.9624154000000344E3</Value>
              <FmtValue>$1,962.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="80">
              <Value xsi:type="xsd:double">2.0964879000000355E3</Value>
              <FmtValue>$2,096.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="81">
              <Value xsi:type="xsd:double">2.1672222000000365E3</Value>
              <FmtValue>$2,167.22</FmtValue>
            </Cell>
            <Cell CellOrdinal="82">
              <Value xsi:type="xsd:double">2.541905800000038E3</Value>
              <FmtValue>$2,541.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="83">
              <Value xsi:type="xsd:double">3.2645949000000532E3</Value>
              <FmtValue>$3,264.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="84">
              <Value xsi:type="xsd:double">2.967164700000046E3</Value>
              <FmtValue>$2,967.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="85">
              <Value xsi:type="xsd:double">2.288556900000021E3</Value>
              <FmtValue>$2,288.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="86">
              <Value xsi:type="xsd:double">3.2153009000000456E3</Value>
              <FmtValue>$3,215.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="87">
              <Value xsi:type="xsd:double">3.137250100000046E3</Value>
              <FmtValue>$3,137.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="88">
              <Value xsi:type="xsd:double">2.367315900000038E3</Value>
              <FmtValue>$2,367.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="89">
              <Value xsi:type="xsd:double">2.8314055000000394E3</Value>
              <FmtValue>$2,831.41</FmtValue>
            </Cell>
            <Cell CellOrdinal="90">
              <Value xsi:type="xsd:double">2.96345890000005E3</Value>
              <FmtValue>$2,963.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="91">
              <Value xsi:type="xsd:int">19523</Value>
              <FmtValue>19,523</FmtValue>
            </Cell>
            <Cell CellOrdinal="92">
              <Value xsi:type="xsd:int">1571</Value>
              <FmtValue>1,571</FmtValue>
            </Cell>
            <Cell CellOrdinal="93">
              <Value xsi:type="xsd:int">1621</Value>
              <FmtValue>1,621</FmtValue>
            </Cell>
            <Cell CellOrdinal="94">
              <Value xsi:type="xsd:int">1674</Value>
              <FmtValue>1,674</FmtValue>
            </Cell>
            <Cell CellOrdinal="95">
              <Value xsi:type="xsd:int">1719</Value>
              <FmtValue>1,719</FmtValue>
            </Cell>
            <Cell CellOrdinal="96">
              <Value xsi:type="xsd:int">1952</Value>
              <FmtValue>1,952</FmtValue>
            </Cell>
            <Cell CellOrdinal="97">
              <Value xsi:type="xsd:int">1844</Value>
              <FmtValue>1,844</FmtValue>
            </Cell>
            <Cell CellOrdinal="98">
              <Value xsi:type="xsd:int">1344</Value>
              <FmtValue>1,344</FmtValue>
            </Cell>
            <Cell CellOrdinal="99">
              <Value xsi:type="xsd:int">1482</Value>
              <FmtValue>1,482</FmtValue>
            </Cell>
            <Cell CellOrdinal="100">
              <Value xsi:type="xsd:int">1467</Value>
              <FmtValue>1,467</FmtValue>
            </Cell>
            <Cell CellOrdinal="101">
              <Value xsi:type="xsd:int">1498</Value>
              <FmtValue>1,498</FmtValue>
            </Cell>
            <Cell CellOrdinal="102">
              <Value xsi:type="xsd:int">1553</Value>
              <FmtValue>1,553</FmtValue>
            </Cell>
            <Cell CellOrdinal="103">
              <Value xsi:type="xsd:int">1798</Value>
              <FmtValue>1,798</FmtValue>
            </Cell>
            <Cell CellOrdinal="104">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="105">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="106">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="107">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="108">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="109">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="110">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="111">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="112">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="113">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="114">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="115">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="116">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="117">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="118">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="119">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="120">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="121">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="122">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="123">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="124">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="125">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="126">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="127">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="128">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="129">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="130">
              <Value xsi:type="xsd:double">1.9694656456194074E1</Value>
              <FmtValue>$19.69</FmtValue>
            </Cell>
            <Cell CellOrdinal="131">
              <Value xsi:type="xsd:double">1.8883690687022923E1</Value>
              <FmtValue>$18.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="132">
              <Value xsi:type="xsd:double">1.928544031572557E1</Value>
              <FmtValue>$19.29</FmtValue>
            </Cell>
            <Cell CellOrdinal="133">
              <Value xsi:type="xsd:double">1.9928503621670142E1</Value>
              <FmtValue>$19.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="134">
              <Value xsi:type="xsd:double">1.9304786908386425E1</Value>
              <FmtValue>$19.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="135">
              <Value xsi:type="xsd:double">2.057933442298184E1</Value>
              <FmtValue>$20.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="136">
              <Value xsi:type="xsd:double">1.955296580310894E1</Value>
              <FmtValue>$19.55</FmtValue>
            </Cell>
            <Cell CellOrdinal="137">
              <Value xsi:type="xsd:double">1.92639100866553E1</Value>
              <FmtValue>$19.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="138">
              <Value xsi:type="xsd:double">1.9882416740478326E1</Value>
              <FmtValue>$19.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="139">
              <Value xsi:type="xsd:double">2.0226630536494074E1</Value>
              <FmtValue>$20.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="140">
              <Value xsi:type="xsd:double">1.9448146601327867E1</Value>
              <FmtValue>$19.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="141">
              <Value xsi:type="xsd:double">2.003372403875265E1</Value>
              <FmtValue>$20.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="142">
              <Value xsi:type="xsd:double">1.9738230956113E1</Value>
              <FmtValue>$19.74</FmtValue>
            </Cell>
            <Cell CellOrdinal="143">
              <Value xsi:type="xsd:double">6.515688612405962E1</Value>
              <FmtValue>$65.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="144">
              <Value xsi:type="xsd:double">4.9962595798854565E1</Value>
              <FmtValue>$49.96</FmtValue>
            </Cell>
            <Cell CellOrdinal="145">
              <Value xsi:type="xsd:double">5.172983146206083E1</Value>
              <FmtValue>$51.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="146">
              <Value xsi:type="xsd:double">5.1782196236559656E1</Value>
              <FmtValue>$51.78</FmtValue>
            </Cell>
            <Cell CellOrdinal="147">
              <Value xsi:type="xsd:double">5.9145041128563726E1</Value>
              <FmtValue>$59.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="148">
              <Value xsi:type="xsd:double">6.689421588114872E1</Value>
              <FmtValue>$66.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="149">
              <Value xsi:type="xsd:double">6.436029197397047E1</Value>
              <FmtValue>$64.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="150">
              <Value xsi:type="xsd:double">6.810852566964296E1</Value>
              <FmtValue>$68.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="151">
              <Value xsi:type="xsd:double">8.677938211875992E1</Value>
              <FmtValue>$86.78</FmtValue>
            </Cell>
            <Cell CellOrdinal="152">
              <Value xsi:type="xsd:double">8.553861663258514E1</Value>
              <FmtValue>$85.54</FmtValue>
            </Cell>
            <Cell CellOrdinal="153">
              <Value xsi:type="xsd:double">6.3209334779706914E1</Value>
              <FmtValue>$63.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="154">
              <Value xsi:type="xsd:double">7.292410837089612E1</Value>
              <FmtValue>$72.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="155">
              <Value xsi:type="xsd:double">6.592447486095757E1</Value>
              <FmtValue>$65.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="156">
              <Value xsi:type="xsd:double">6.344671618000083E5</Value>
              <FmtValue>$634,467.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="157">
              <Value xsi:type="xsd:double">4.335430859999998E4</Value>
              <FmtValue>$43,354.31</FmtValue>
            </Cell>
            <Cell CellOrdinal="158">
              <Value xsi:type="xsd:double">4.5459231700000004E4</Value>
              <FmtValue>$45,459.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="159">
              <Value xsi:type="xsd:double">4.734280930000022E4</Value>
              <FmtValue>$47,342.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="160">
              <Value xsi:type="xsd:double">5.2562580700000275E4</Value>
              <FmtValue>$52,562.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="161">
              <Value xsi:type="xsd:double">6.596204630000157E4</Value>
              <FmtValue>$65,962.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="162">
              <Value xsi:type="xsd:double">5.987101990000083E4</Value>
              <FmtValue>$59,871.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="163">
              <Value xsi:type="xsd:double">4.0100562499999956E4</Value>
              <FmtValue>$40,100.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="164">
              <Value xsi:type="xsd:double">5.900300940000155E4</Value>
              <FmtValue>$59,003.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="165">
              <Value xsi:type="xsd:double">5.7696716700001736E4</Value>
              <FmtValue>$57,696.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="166">
              <Value xsi:type="xsd:double">4.821484680000022E4</Value>
              <FmtValue>$48,214.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="167">
              <Value xsi:type="xsd:double">5.499570300000107E4</Value>
              <FmtValue>$54,995.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="168">
              <Value xsi:type="xsd:double">5.990432690000087E4</Value>
              <FmtValue>$59,904.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="169">
              <Value xsi:type="xsd:double">4.987722397581286E-1</Value>
              <FmtValue>49.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="170">
              <Value xsi:type="xsd:double">5.52345837633491E-1</Value>
              <FmtValue>55.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="171">
              <Value xsi:type="xsd:double">5.421232249791363E-1</Value>
              <FmtValue>54.21%</FmtValue>
            </Cell>
            <Cell CellOrdinal="172">
              <Value xsi:type="xsd:double">5.461577558281273E-1</Value>
              <FmtValue>54.62%</FmtValue>
            </Cell>
            <Cell CellOrdinal="173">
              <Value xsi:type="xsd:double">5.169903837536318E-1</Value>
              <FmtValue>51.70%</FmtValue>
            </Cell>
            <Cell CellOrdinal="174">
              <Value xsi:type="xsd:double">5.051562600871633E-1</Value>
              <FmtValue>50.52%</FmtValue>
            </Cell>
            <Cell CellOrdinal="175">
              <Value xsi:type="xsd:double">5.044727755940492E-1</Value>
              <FmtValue>50.45%</FmtValue>
            </Cell>
            <Cell CellOrdinal="176">
              <Value xsi:type="xsd:double">4.3807625781413595E-1</Value>
              <FmtValue>43.81%</FmtValue>
            </Cell>
            <Cell CellOrdinal="177">
              <Value xsi:type="xsd:double">4.5878520668249695E-1</Value>
              <FmtValue>45.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="178">
              <Value xsi:type="xsd:double">4.5978919755944913E-1</Value>
              <FmtValue>45.98%</FmtValue>
            </Cell>
            <Cell CellOrdinal="179">
              <Value xsi:type="xsd:double">5.091992531417779E-1</Value>
              <FmtValue>50.92%</FmtValue>
            </Cell>
            <Cell CellOrdinal="180">
              <Value xsi:type="xsd:double">4.8560838199348577E-1</Value>
              <FmtValue>48.56%</FmtValue>
            </Cell>
            <Cell CellOrdinal="181">
              <Value xsi:type="xsd:double">5.053843931756141E-1</Value>
              <FmtValue>50.54%</FmtValue>
            </Cell>
            <Cell CellOrdinal="195">
              <Value xsi:type="xsd:double">1.158424820701752E-2</Value>
              <FmtValue>1.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="196">
              <Value xsi:type="xsd:double">1.2933008616329643E-2</Value>
              <FmtValue>1.29%</FmtValue>
            </Cell>
            <Cell CellOrdinal="197">
              <Value xsi:type="xsd:double">8.837171442328026E-3</Value>
              <FmtValue>0.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="198">
              <Value xsi:type="xsd:double">1.0357402408519312E-2</Value>
              <FmtValue>1.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="199">
              <Value xsi:type="xsd:double">1.3149897666316705E-2</Value>
              <FmtValue>1.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="200">
              <Value xsi:type="xsd:double">1.1276327278388445E-2</Value>
              <FmtValue>1.13%</FmtValue>
            </Cell>
            <Cell CellOrdinal="201">
              <Value xsi:type="xsd:double">1.2380491730774935E-2</Value>
              <FmtValue>1.24%</FmtValue>
            </Cell>
            <Cell CellOrdinal="202">
              <Value xsi:type="xsd:double">1.2270603200486301E-2</Value>
              <FmtValue>1.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="203">
              <Value xsi:type="xsd:double">1.1429525319851067E-2</Value>
              <FmtValue>1.14%</FmtValue>
            </Cell>
            <Cell CellOrdinal="204">
              <Value xsi:type="xsd:double">1.2632523275972177E-2</Value>
              <FmtValue>1.26%</FmtValue>
            </Cell>
            <Cell CellOrdinal="205">
              <Value xsi:type="xsd:double">1.3647361607923203E-2</Value>
              <FmtValue>1.36%</FmtValue>
            </Cell>
            <Cell CellOrdinal="206">
              <Value xsi:type="xsd:double">1.0354689954481853E-2</Value>
              <FmtValue>1.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="207">
              <Value xsi:type="xsd:double">1.1327904688104371E-2</Value>
              <FmtValue>1.13%</FmtValue>
            </Cell>
            <Cell CellOrdinal="208">
              <Value xsi:type="xsd:double">1.158424820701752E-2</Value>
              <FmtValue>1.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="209">
              <Value xsi:type="xsd:double">1.2933008616329643E-2</Value>
              <FmtValue>1.29%</FmtValue>
            </Cell>
            <Cell CellOrdinal="210">
              <Value xsi:type="xsd:double">8.837171442328026E-3</Value>
              <FmtValue>0.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="211">
              <Value xsi:type="xsd:double">1.0357402408519312E-2</Value>
              <FmtValue>1.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="212">
              <Value xsi:type="xsd:double">1.3149897666316705E-2</Value>
              <FmtValue>1.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="213">
              <Value xsi:type="xsd:double">1.1276327278388445E-2</Value>
              <FmtValue>1.13%</FmtValue>
            </Cell>
            <Cell CellOrdinal="214">
              <Value xsi:type="xsd:double">1.2380491730774935E-2</Value>
              <FmtValue>1.24%</FmtValue>
            </Cell>
            <Cell CellOrdinal="215">
              <Value xsi:type="xsd:double">1.2270603200486301E-2</Value>
              <FmtValue>1.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="216">
              <Value xsi:type="xsd:double">1.1429525319851067E-2</Value>
              <FmtValue>1.14%</FmtValue>
            </Cell>
            <Cell CellOrdinal="217">
              <Value xsi:type="xsd:double">1.2632523275972177E-2</Value>
              <FmtValue>1.26%</FmtValue>
            </Cell>
            <Cell CellOrdinal="218">
              <Value xsi:type="xsd:double">1.3647361607923203E-2</Value>
              <FmtValue>1.36%</FmtValue>
            </Cell>
            <Cell CellOrdinal="219">
              <Value xsi:type="xsd:double">1.0354689954481853E-2</Value>
              <FmtValue>1.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="220">
              <Value xsi:type="xsd:double">1.1327904688104371E-2</Value>
              <FmtValue>1.13%</FmtValue>
            </Cell>
            <Cell CellOrdinal="221">
              <Value xsi:type="xsd:int">90220</Value>
              <FmtValue>90,220</FmtValue>
            </Cell>
            <Cell CellOrdinal="222">
              <Value xsi:type="xsd:int">5030</Value>
              <FmtValue>5,030</FmtValue>
            </Cell>
            <Cell CellOrdinal="223">
              <Value xsi:type="xsd:int">8061</Value>
              <FmtValue>8,061</FmtValue>
            </Cell>
            <Cell CellOrdinal="224">
              <Value xsi:type="xsd:int">6922</Value>
              <FmtValue>6,922</FmtValue>
            </Cell>
            <Cell CellOrdinal="225">
              <Value xsi:type="xsd:int">6207</Value>
              <FmtValue>6,207</FmtValue>
            </Cell>
            <Cell CellOrdinal="226">
              <Value xsi:type="xsd:int">9367</Value>
              <FmtValue>9,367</FmtValue>
            </Cell>
            <Cell CellOrdinal="227">
              <Value xsi:type="xsd:int">8005</Value>
              <FmtValue>8,005</FmtValue>
            </Cell>
            <Cell CellOrdinal="228">
              <Value xsi:type="xsd:int">6206</Value>
              <FmtValue>6,206</FmtValue>
            </Cell>
            <Cell CellOrdinal="229">
              <Value xsi:type="xsd:int">9234</Value>
              <FmtValue>9,234</FmtValue>
            </Cell>
            <Cell CellOrdinal="230">
              <Value xsi:type="xsd:int">8089</Value>
              <FmtValue>8,089</FmtValue>
            </Cell>
            <Cell CellOrdinal="231">
              <Value xsi:type="xsd:int">5780</Value>
              <FmtValue>5,780</FmtValue>
            </Cell>
            <Cell CellOrdinal="232">
              <Value xsi:type="xsd:int">9033</Value>
              <FmtValue>9,033</FmtValue>
            </Cell>
            <Cell CellOrdinal="233">
              <Value xsi:type="xsd:int">8286</Value>
              <FmtValue>8,286</FmtValue>
            </Cell>
            <Cell CellOrdinal="234">
              <Value xsi:type="xsd:double">9.511516683990124E7</Value>
              <FmtValue>$95,115,166.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="235">
              <Value xsi:type="xsd:double">5.604506835900047E6</Value>
              <FmtValue>$5,604,506.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="236">
              <Value xsi:type="xsd:double">8.744840333400115E6</Value>
              <FmtValue>$8,744,840.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="237">
              <Value xsi:type="xsd:double">7.6898874692001045E6</Value>
              <FmtValue>$7,689,887.47</FmtValue>
            </Cell>
            <Cell CellOrdinal="238">
              <Value xsi:type="xsd:double">6.801900205300098E6</Value>
              <FmtValue>$6,801,900.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="239">
              <Value xsi:type="xsd:double">1.0115199500000171E7</Value>
              <FmtValue>$10,115,199.50</FmtValue>
            </Cell>
            <Cell CellOrdinal="240">
              <Value xsi:type="xsd:double">8.336578886400139E6</Value>
              <FmtValue>$8,336,578.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="241">
              <Value xsi:type="xsd:double">6.091857417300074E6</Value>
              <FmtValue>$6,091,857.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="242">
              <Value xsi:type="xsd:double">9.124105037900092E6</Value>
              <FmtValue>$9,124,105.04</FmtValue>
            </Cell>
            <Cell CellOrdinal="243">
              <Value xsi:type="xsd:double">7.9850850036001E6</Value>
              <FmtValue>$7,985,085.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="244">
              <Value xsi:type="xsd:double">6.056723293100059E6</Value>
              <FmtValue>$6,056,723.29</FmtValue>
            </Cell>
            <Cell CellOrdinal="245">
              <Value xsi:type="xsd:double">9.457512686300112E6</Value>
              <FmtValue>$9,457,512.69</FmtValue>
            </Cell>
            <Cell CellOrdinal="246">
              <Value xsi:type="xsd:double">9.106970171500139E6</Value>
              <FmtValue>$9,106,970.17</FmtValue>
            </Cell>
            <Cell CellOrdinal="247">
              <Value xsi:type="xsd:double">3.8851410537299976E7</Value>
              <FmtValue>$38,851,410.54</FmtValue>
            </Cell>
            <Cell CellOrdinal="248">
              <Value xsi:type="xsd:double">2.528077206600002E6</Value>
              <FmtValue>$2,528,077.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="249">
              <Value xsi:type="xsd:double">3.7158861785000004E6</Value>
              <FmtValue>$3,715,886.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="250">
              <Value xsi:type="xsd:double">3.394189151799996E6</Value>
              <FmtValue>$3,394,189.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="251">
              <Value xsi:type="xsd:double">2.8493968184999972E6</Value>
              <FmtValue>$2,849,396.82</FmtValue>
            </Cell>
            <Cell CellOrdinal="252">
              <Value xsi:type="xsd:double">4.131695421999993E6</Value>
              <FmtValue>$4,131,695.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="253">
              <Value xsi:type="xsd:double">3.8145481252999925E6</Value>
              <FmtValue>$3,814,548.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="254">
              <Value xsi:type="xsd:double">2.299322950500002E6</Value>
              <FmtValue>$2,299,322.95</FmtValue>
            </Cell>
            <Cell CellOrdinal="255">
              <Value xsi:type="xsd:double">3.356940640399998E6</Value>
              <FmtValue>$3,356,940.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="256">
              <Value xsi:type="xsd:double">2.9639489906000015E6</Value>
              <FmtValue>$2,963,948.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="257">
              <Value xsi:type="xsd:double">2.4050391772000007E6</Value>
              <FmtValue>$2,405,039.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="258">
              <Value xsi:type="xsd:double">3.5781282628000006E6</Value>
              <FmtValue>$3,578,128.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="259">
              <Value xsi:type="xsd:double">3.8142376130999927E6</Value>
              <FmtValue>$3,814,237.61</FmtValue>
            </Cell>
            <Cell CellOrdinal="260">
              <Value xsi:type="xsd:double">8.410542959930005E7</Value>
              <FmtValue>$84,105,429.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="261">
              <Value xsi:type="xsd:double">4.6368575231000045E6</Value>
              <FmtValue>$4,636,857.52</FmtValue>
            </Cell>
            <Cell CellOrdinal="262">
              <Value xsi:type="xsd:double">7.677423651000002E6</Value>
              <FmtValue>$7,677,423.65</FmtValue>
            </Cell>
            <Cell CellOrdinal="263">
              <Value xsi:type="xsd:double">6.602443595299995E6</Value>
              <FmtValue>$6,602,443.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="264">
              <Value xsi:type="xsd:double">5.675780847999999E6</Value>
              <FmtValue>$5,675,780.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="265">
              <Value xsi:type="xsd:double">8.8401810086E6</Value>
              <FmtValue>$8,840,181.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="266">
              <Value xsi:type="xsd:double">7.585842270300001E6</Value>
              <FmtValue>$7,585,842.27</FmtValue>
            </Cell>
            <Cell CellOrdinal="267">
              <Value xsi:type="xsd:double">5.49663475710002E6</Value>
              <FmtValue>$5,496,634.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="268">
              <Value xsi:type="xsd:double">8.542726621300026E6</Value>
              <FmtValue>$8,542,726.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="269">
              <Value xsi:type="xsd:double">7.428347623200012E6</Value>
              <FmtValue>$7,428,347.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="270">
              <Value xsi:type="xsd:double">5.250047832700008E6</Value>
              <FmtValue>$5,250,047.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="271">
              <Value xsi:type="xsd:double">8.547195019800003E6</Value>
              <FmtValue>$8,547,195.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="272">
              <Value xsi:type="xsd:double">7.821948848899994E6</Value>
              <FmtValue>$7,821,948.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="273">
              <Value xsi:type="xsd:double">9.462052620770125E7</Value>
              <FmtValue>$94,620,526.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="274">
              <Value xsi:type="xsd:double">5.602193746400048E6</Value>
              <FmtValue>$5,602,193.75</FmtValue>
            </Cell>
            <Cell CellOrdinal="275">
              <Value xsi:type="xsd:double">8.741352104600114E6</Value>
              <FmtValue>$8,741,352.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="276">
              <Value xsi:type="xsd:double">7.687470114300106E6</Value>
              <FmtValue>$7,687,470.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="277">
              <Value xsi:type="xsd:double">6.793351276300097E6</Value>
              <FmtValue>$6,793,351.28</FmtValue>
            </Cell>
            <Cell CellOrdinal="278">
              <Value xsi:type="xsd:double">1.0100476028000172E7</Value>
              <FmtValue>$10,100,476.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="279">
              <Value xsi:type="xsd:double">8.187712617900138E6</Value>
              <FmtValue>$8,187,712.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="280">
              <Value xsi:type="xsd:double">6.018342166800067E6</Value>
              <FmtValue>$6,018,342.17</FmtValue>
            </Cell>
            <Cell CellOrdinal="281">
              <Value xsi:type="xsd:double">9.01926388130009E6</Value>
              <FmtValue>$9,019,263.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="282">
              <Value xsi:type="xsd:double">7.875706350700096E6</Value>
              <FmtValue>$7,875,706.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="283">
              <Value xsi:type="xsd:double">6.045785563000059E6</Value>
              <FmtValue>$6,045,785.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="284">
              <Value xsi:type="xsd:double">9.449348344400111E6</Value>
              <FmtValue>$9,449,348.34</FmtValue>
            </Cell>
            <Cell CellOrdinal="285">
              <Value xsi:type="xsd:double">9.099524014000138E6</Value>
              <FmtValue>$9,099,524.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="286">
              <Value xsi:type="xsd:double">7.569642020899961E6</Value>
              <FmtValue>$7,569,642.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="287">
              <Value xsi:type="xsd:double">4.481754944E5</Value>
              <FmtValue>$448,175.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="288">
              <Value xsi:type="xsd:double">6.993081577999978E5</Value>
              <FmtValue>$699,308.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="289">
              <Value xsi:type="xsd:double">6.149976018999971E5</Value>
              <FmtValue>$614,997.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="290">
              <Value xsi:type="xsd:double">5.434680999000003E5</Value>
              <FmtValue>$543,468.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="291">
              <Value xsi:type="xsd:double">8.080380744999931E5</Value>
              <FmtValue>$808,038.07</FmtValue>
            </Cell>
            <Cell CellOrdinal="292">
              <Value xsi:type="xsd:double">6.550170058999933E5</Value>
              <FmtValue>$655,017.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="293">
              <Value xsi:type="xsd:double">4.8146737079999875E5</Value>
              <FmtValue>$481,467.37</FmtValue>
            </Cell>
            <Cell CellOrdinal="294">
              <Value xsi:type="xsd:double">7.215411026999948E5</Value>
              <FmtValue>$721,541.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="295">
              <Value xsi:type="xsd:double">6.30056499199996E5</Value>
              <FmtValue>$630,056.50</FmtValue>
            </Cell>
            <Cell CellOrdinal="296">
              <Value xsi:type="xsd:double">4.8366284079999965E5</Value>
              <FmtValue>$483,662.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="297">
              <Value xsi:type="xsd:double">7.559478562999965E5</Value>
              <FmtValue>$755,947.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="298">
              <Value xsi:type="xsd:double">7.27961916699993E5</Value>
              <FmtValue>$727,961.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="299">
              <Value xsi:type="xsd:double">2.365514355900008E6</Value>
              <FmtValue>$2,365,514.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="300">
              <Value xsi:type="xsd:double">1.400549268999995E5</Value>
              <FmtValue>$140,054.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="301">
              <Value xsi:type="xsd:double">2.1853391630000097E5</Value>
              <FmtValue>$218,533.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="302">
              <Value xsi:type="xsd:double">1.9218686090000128E5</Value>
              <FmtValue>$192,186.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="303">
              <Value xsi:type="xsd:double">1.6983387860000035E5</Value>
              <FmtValue>$169,833.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="304">
              <Value xsi:type="xsd:double">2.5251203150000138E5</Value>
              <FmtValue>$252,512.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="305">
              <Value xsi:type="xsd:double">2.0469293750000198E5</Value>
              <FmtValue>$204,692.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="306">
              <Value xsi:type="xsd:double">1.5045862109999993E5</Value>
              <FmtValue>$150,458.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="307">
              <Value xsi:type="xsd:double">2.2548168739999935E5</Value>
              <FmtValue>$225,481.69</FmtValue>
            </Cell>
            <Cell CellOrdinal="308">
              <Value xsi:type="xsd:double">1.9689273660000108E5</Value>
              <FmtValue>$196,892.74</FmtValue>
            </Cell>
            <Cell CellOrdinal="309">
              <Value xsi:type="xsd:double">1.5114471779999993E5</Value>
              <FmtValue>$151,144.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="310">
              <Value xsi:type="xsd:double">2.3623381440000067E5</Value>
              <FmtValue>$236,233.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="311">
              <Value xsi:type="xsd:double">2.274882269000018E5</Value>
              <FmtValue>$227,488.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="312">
              <Value xsi:type="xsd:int">18358</Value>
              <FmtValue>18,358</FmtValue>
            </Cell>
            <Cell CellOrdinal="313">
              <Value xsi:type="xsd:int">1390</Value>
              <FmtValue>1,390</FmtValue>
            </Cell>
            <Cell CellOrdinal="314">
              <Value xsi:type="xsd:int">1620</Value>
              <FmtValue>1,620</FmtValue>
            </Cell>
            <Cell CellOrdinal="315">
              <Value xsi:type="xsd:int">1635</Value>
              <FmtValue>1,635</FmtValue>
            </Cell>
            <Cell CellOrdinal="316">
              <Value xsi:type="xsd:int">1641</Value>
              <FmtValue>1,641</FmtValue>
            </Cell>
            <Cell CellOrdinal="317">
              <Value xsi:type="xsd:int">2015</Value>
              <FmtValue>2,015</FmtValue>
            </Cell>
            <Cell CellOrdinal="318">
              <Value xsi:type="xsd:int">2006</Value>
              <FmtValue>2,006</FmtValue>
            </Cell>
            <Cell CellOrdinal="319">
              <Value xsi:type="xsd:int">1088</Value>
              <FmtValue>1,088</FmtValue>
            </Cell>
            <Cell CellOrdinal="320">
              <Value xsi:type="xsd:int">1262</Value>
              <FmtValue>1,262</FmtValue>
            </Cell>
            <Cell CellOrdinal="321">
              <Value xsi:type="xsd:int">1208</Value>
              <FmtValue>1,208</FmtValue>
            </Cell>
            <Cell CellOrdinal="322">
              <Value xsi:type="xsd:int">1186</Value>
              <FmtValue>1,186</FmtValue>
            </Cell>
            <Cell CellOrdinal="323">
              <Value xsi:type="xsd:int">1399</Value>
              <FmtValue>1,399</FmtValue>
            </Cell>
            <Cell CellOrdinal="324">
              <Value xsi:type="xsd:int">1908</Value>
              <FmtValue>1,908</FmtValue>
            </Cell>
            <Cell CellOrdinal="325">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="326">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="327">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="328">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="329">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="330">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="331">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="332">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="333">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="334">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="335">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="336">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="337">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="338">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="339">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="340">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="341">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="342">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="343">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="344">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="345">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="346">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="347">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="348">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="349">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="350">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="351">
              <Value xsi:type="xsd:double">1.2550806949631355E3</Value>
              <FmtValue>$1,255.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="352">
              <Value xsi:type="xsd:double">1.3462123162078337E3</Value>
              <FmtValue>$1,346.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="353">
              <Value xsi:type="xsd:double">1.248380459185836E3</Value>
              <FmtValue>$1,248.38</FmtValue>
            </Cell>
            <Cell CellOrdinal="354">
              <Value xsi:type="xsd:double">1.2883008531322591E3</Value>
              <FmtValue>$1,288.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="355">
              <Value xsi:type="xsd:double">1.3538076840356304E3</Value>
              <FmtValue>$1,353.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="356">
              <Value xsi:type="xsd:double">1.2493189684357646E3</Value>
              <FmtValue>$1,249.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="357">
              <Value xsi:type="xsd:double">1.2540994624745058E3</Value>
              <FmtValue>$1,254.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="358">
              <Value xsi:type="xsd:double">1.2896326363013693E3</Value>
              <FmtValue>$1,289.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="359">
              <Value xsi:type="xsd:double">1.1645499877082147E3</Value>
              <FmtValue>$1,164.55</FmtValue>
            </Cell>
            <Cell CellOrdinal="360">
              <Value xsi:type="xsd:double">1.162118655159115E3</Value>
              <FmtValue>$1,162.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="361">
              <Value xsi:type="xsd:double">1.2790750253397288E3</Value>
              <FmtValue>$1,279.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="362">
              <Value xsi:type="xsd:double">1.1910984542510136E3</Value>
              <FmtValue>$1,191.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="363">
              <Value xsi:type="xsd:double">1.2848793808868642E3</Value>
              <FmtValue>$1,284.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="364">
              <Value xsi:type="xsd:double">5.15418488984101E3</Value>
              <FmtValue>$5,154.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="365">
              <Value xsi:type="xsd:double">4.030355213237445E3</Value>
              <FmtValue>$4,030.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="366">
              <Value xsi:type="xsd:double">5.395896360864268E3</Value>
              <FmtValue>$5,395.90</FmtValue>
            </Cell>
            <Cell CellOrdinal="367">
              <Value xsi:type="xsd:double">4.701816583669789E3</Value>
              <FmtValue>$4,701.82</FmtValue>
            </Cell>
            <Cell CellOrdinal="368">
              <Value xsi:type="xsd:double">4.1397631177940875E3</Value>
              <FmtValue>$4,139.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="369">
              <Value xsi:type="xsd:double">5.012643190074527E3</Value>
              <FmtValue>$5,012.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="370">
              <Value xsi:type="xsd:double">4.0816114745264895E3</Value>
              <FmtValue>$4,081.61</FmtValue>
            </Cell>
            <Cell CellOrdinal="371">
              <Value xsi:type="xsd:double">5.531564491544179E3</Value>
              <FmtValue>$5,531.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="372">
              <Value xsi:type="xsd:double">7.146801807686284E3</Value>
              <FmtValue>$7,146.80</FmtValue>
            </Cell>
            <Cell CellOrdinal="373">
              <Value xsi:type="xsd:double">6.51962446250008E3</Value>
              <FmtValue>$6,519.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="374">
              <Value xsi:type="xsd:double">5.097626950253E3</Value>
              <FmtValue>$5,097.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="375">
              <Value xsi:type="xsd:double">6.7543590739100155E3</Value>
              <FmtValue>$6,754.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="376">
              <Value xsi:type="xsd:double">4.76914256498959E3</Value>
              <FmtValue>$4,769.14</FmtValue>
            </Cell>
            <Cell CellOrdinal="377">
              <Value xsi:type="xsd:double">1.0515096608401194E7</Value>
              <FmtValue>$10,515,096.61</FmtValue>
            </Cell>
            <Cell CellOrdinal="378">
              <Value xsi:type="xsd:double">9.653362233000435E5</Value>
              <FmtValue>$965,336.22</FmtValue>
            </Cell>
            <Cell CellOrdinal="379">
              <Value xsi:type="xsd:double">1.0639284536001123E6</Value>
              <FmtValue>$1,063,928.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="380">
              <Value xsi:type="xsd:double">1.0850265190001111E6</Value>
              <FmtValue>$1,085,026.52</FmtValue>
            </Cell>
            <Cell CellOrdinal="381">
              <Value xsi:type="xsd:double">1.1175704283000976E6</Value>
              <FmtValue>$1,117,570.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="382">
              <Value xsi:type="xsd:double">1.260295019400172E6</Value>
              <FmtValue>$1,260,295.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="383">
              <Value xsi:type="xsd:double">6.018703476001369E5</Value>
              <FmtValue>$601,870.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="384">
              <Value xsi:type="xsd:double">5.217074097000472E5</Value>
              <FmtValue>$521,707.41</FmtValue>
            </Cell>
            <Cell CellOrdinal="385">
              <Value xsi:type="xsd:double">4.765372600000631E5</Value>
              <FmtValue>$476,537.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="386">
              <Value xsi:type="xsd:double">4.4735872750008385E5</Value>
              <FmtValue>$447,358.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="387">
              <Value xsi:type="xsd:double">7.957377303000512E5</Value>
              <FmtValue>$795,737.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="388">
              <Value xsi:type="xsd:double">9.02153324600108E5</Value>
              <FmtValue>$902,153.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="389">
              <Value xsi:type="xsd:double">1.2775751651001442E6</Value>
              <FmtValue>$1,277,575.17</FmtValue>
            </Cell>
            <Cell CellOrdinal="390">
              <Value xsi:type="xsd:double">1.1112912842314505E-1</Value>
              <FmtValue>11.11%</FmtValue>
            </Cell>
            <Cell CellOrdinal="391">
              <Value xsi:type="xsd:double">1.723139660995062E-1</Value>
              <FmtValue>17.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="392">
              <Value xsi:type="xsd:double">1.2171211511320115E-1</Value>
              <FmtValue>12.17%</FmtValue>
            </Cell>
            <Cell CellOrdinal="393">
              <Value xsi:type="xsd:double">1.4114220970846608E-1</Value>
              <FmtValue>14.11%</FmtValue>
            </Cell>
            <Cell CellOrdinal="394">
              <Value xsi:type="xsd:double">1.6450944207742582E-1</Value>
              <FmtValue>16.45%</FmtValue>
            </Cell>
            <Cell CellOrdinal="395">
              <Value xsi:type="xsd:double">1.2477580422016031E-1</Value>
              <FmtValue>12.48%</FmtValue>
            </Cell>
            <Cell CellOrdinal="396">
              <Value xsi:type="xsd:double">7.350897322462395E-2</Value>
              <FmtValue>7.35%</FmtValue>
            </Cell>
            <Cell CellOrdinal="397">
              <Value xsi:type="xsd:double">8.668623272668416E-2</Value>
              <FmtValue>8.67%</FmtValue>
            </Cell>
            <Cell CellOrdinal="398">
              <Value xsi:type="xsd:double">5.2835493702327756E-2</Value>
              <FmtValue>5.28%</FmtValue>
            </Cell>
            <Cell CellOrdinal="399">
              <Value xsi:type="xsd:double">5.6802362553844674E-2</Value>
              <FmtValue>5.68%</FmtValue>
            </Cell>
            <Cell CellOrdinal="400">
              <Value xsi:type="xsd:double">1.3161858322761743E-1</Value>
              <FmtValue>13.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="401">
              <Value xsi:type="xsd:double">9.547254389608184E-2</Value>
              <FmtValue>9.55%</FmtValue>
            </Cell>
            <Cell CellOrdinal="402">
              <Value xsi:type="xsd:double">1.404002190811873E-1</Value>
              <FmtValue>14.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="416">
              <Value xsi:type="xsd:double">8.616806448677434E-1</Value>
              <FmtValue>86.17%</FmtValue>
            </Cell>
            <Cell CellOrdinal="417">
              <Value xsi:type="xsd:double">9.230739868383703E-1</Value>
              <FmtValue>92.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="418">
              <Value xsi:type="xsd:double">9.212294566779454E-1</Value>
              <FmtValue>92.12%</FmtValue>
            </Cell>
            <Cell CellOrdinal="419">
              <Value xsi:type="xsd:double">9.185406282190541E-1</Value>
              <FmtValue>91.85%</FmtValue>
            </Cell>
            <Cell CellOrdinal="420">
              <Value xsi:type="xsd:double">8.786425486457091E-1</Value>
              <FmtValue>87.86%</FmtValue>
            </Cell>
            <Cell CellOrdinal="421">
              <Value xsi:type="xsd:double">8.722503123439488E-1</Value>
              <FmtValue>87.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="422">
              <Value xsi:type="xsd:double">8.541252541192852E-1</Value>
              <FmtValue>85.41%</FmtValue>
            </Cell>
            <Cell CellOrdinal="423">
              <Value xsi:type="xsd:double">8.067556950063285E-1</Value>
              <FmtValue>80.68%</FmtValue>
            </Cell>
            <Cell CellOrdinal="424">
              <Value xsi:type="xsd:double">8.015572199705379E-1</Value>
              <FmtValue>80.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="425">
              <Value xsi:type="xsd:double">7.928431636271945E-1</Value>
              <FmtValue>79.28%</FmtValue>
            </Cell>
            <Cell CellOrdinal="426">
              <Value xsi:type="xsd:double">8.713816398347788E-1</Value>
              <FmtValue>87.14%</FmtValue>
            </Cell>
            <Cell CellOrdinal="427">
              <Value xsi:type="xsd:double">8.639654498751047E-1</Value>
              <FmtValue>86.40%</FmtValue>
            </Cell>
            <Cell CellOrdinal="428">
              <Value xsi:type="xsd:double">8.696247576092015E-1</Value>
              <FmtValue>86.96%</FmtValue>
            </Cell>
            <Cell CellOrdinal="429">
              <Value xsi:type="xsd:double">8.616806448677434E-1</Value>
              <FmtValue>86.17%</FmtValue>
            </Cell>
            <Cell CellOrdinal="430">
              <Value xsi:type="xsd:double">9.230739868383703E-1</Value>
              <FmtValue>92.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="431">
              <Value xsi:type="xsd:double">9.212294566779454E-1</Value>
              <FmtValue>92.12%</FmtValue>
            </Cell>
            <Cell CellOrdinal="432">
              <Value xsi:type="xsd:double">9.185406282190541E-1</Value>
              <FmtValue>91.85%</FmtValue>
            </Cell>
            <Cell CellOrdinal="433">
              <Value xsi:type="xsd:double">8.786425486457091E-1</Value>
              <FmtValue>87.86%</FmtValue>
            </Cell>
            <Cell CellOrdinal="434">
              <Value xsi:type="xsd:double">8.722503123439488E-1</Value>
              <FmtValue>87.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="435">
              <Value xsi:type="xsd:double">8.541252541192852E-1</Value>
              <FmtValue>85.41%</FmtValue>
            </Cell>
            <Cell CellOrdinal="436">
              <Value xsi:type="xsd:double">8.067556950063285E-1</Value>
              <FmtValue>80.68%</FmtValue>
            </Cell>
            <Cell CellOrdinal="437">
              <Value xsi:type="xsd:double">8.015572199705379E-1</Value>
              <FmtValue>80.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="438">
              <Value xsi:type="xsd:double">7.928431636271945E-1</Value>
              <FmtValue>79.28%</FmtValue>
            </Cell>
            <Cell CellOrdinal="439">
              <Value xsi:type="xsd:double">8.713816398347788E-1</Value>
              <FmtValue>87.14%</FmtValue>
            </Cell>
            <Cell CellOrdinal="440">
              <Value xsi:type="xsd:double">8.639654498751047E-1</Value>
              <FmtValue>86.40%</FmtValue>
            </Cell>
            <Cell CellOrdinal="441">
              <Value xsi:type="xsd:double">8.696247576092015E-1</Value>
              <FmtValue>86.96%</FmtValue>
            </Cell>
            <Cell CellOrdinal="442">
              <Value xsi:type="xsd:int">73598</Value>
              <FmtValue>73,598</FmtValue>
            </Cell>
            <Cell CellOrdinal="443">
              <Value xsi:type="xsd:int">3449</Value>
              <FmtValue>3,449</FmtValue>
            </Cell>
            <Cell CellOrdinal="444">
              <Value xsi:type="xsd:int">4398</Value>
              <FmtValue>4,398</FmtValue>
            </Cell>
            <Cell CellOrdinal="445">
              <Value xsi:type="xsd:int">4053</Value>
              <FmtValue>4,053</FmtValue>
            </Cell>
            <Cell CellOrdinal="446">
              <Value xsi:type="xsd:int">5237</Value>
              <FmtValue>5,237</FmtValue>
            </Cell>
            <Cell CellOrdinal="447">
              <Value xsi:type="xsd:int">7054</Value>
              <FmtValue>7,054</FmtValue>
            </Cell>
            <Cell CellOrdinal="448">
              <Value xsi:type="xsd:int">6438</Value>
              <FmtValue>6,438</FmtValue>
            </Cell>
            <Cell CellOrdinal="449">
              <Value xsi:type="xsd:int">6434</Value>
              <FmtValue>6,434</FmtValue>
            </Cell>
            <Cell CellOrdinal="450">
              <Value xsi:type="xsd:int">9419</Value>
              <FmtValue>9,419</FmtValue>
            </Cell>
            <Cell CellOrdinal="451">
              <Value xsi:type="xsd:int">8313</Value>
              <FmtValue>8,313</FmtValue>
            </Cell>
            <Cell CellOrdinal="452">
              <Value xsi:type="xsd:int">5282</Value>
              <FmtValue>5,282</FmtValue>
            </Cell>
            <Cell CellOrdinal="453">
              <Value xsi:type="xsd:int">6973</Value>
              <FmtValue>6,973</FmtValue>
            </Cell>
            <Cell CellOrdinal="454">
              <Value xsi:type="xsd:int">6548</Value>
              <FmtValue>6,548</FmtValue>
            </Cell>
            <Cell CellOrdinal="455">
              <Value xsi:type="xsd:double">2.138577942500014E6</Value>
              <FmtValue>$2,138,577.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="456">
              <Value xsi:type="xsd:double">1.0591661740000032E5</Value>
              <FmtValue>$105,916.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="457">
              <Value xsi:type="xsd:double">1.28374575700001E5</Value>
              <FmtValue>$128,374.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="458">
              <Value xsi:type="xsd:double">1.2249622600000124E5</Value>
              <FmtValue>$122,496.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="459">
              <Value xsi:type="xsd:double">1.554124626000028E5</Value>
              <FmtValue>$155,412.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="460">
              <Value xsi:type="xsd:double">2.0273367690000246E5</Value>
              <FmtValue>$202,733.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="461">
              <Value xsi:type="xsd:double">1.9035508970000283E5</Value>
              <FmtValue>$190,355.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="462">
              <Value xsi:type="xsd:double">1.848404386000007E5</Value>
              <FmtValue>$184,840.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="463">
              <Value xsi:type="xsd:double">2.657464784999966E5</Value>
              <FmtValue>$265,746.48</FmtValue>
            </Cell>
            <Cell CellOrdinal="464">
              <Value xsi:type="xsd:double">2.4127788729999843E5</Value>
              <FmtValue>$241,277.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="465">
              <Value xsi:type="xsd:double">1.5359724100000234E5</Value>
              <FmtValue>$153,597.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="466">
              <Value xsi:type="xsd:double">1.983436515000024E5</Value>
              <FmtValue>$198,343.65</FmtValue>
            </Cell>
            <Cell CellOrdinal="467">
              <Value xsi:type="xsd:double">1.8948359730000276E5</Value>
              <FmtValue>$189,483.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="468">
              <Value xsi:type="xsd:double">4.978712978999987E5</Value>
              <FmtValue>$497,871.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="469">
              <Value xsi:type="xsd:double">3.229927539999991E4</Value>
              <FmtValue>$32,299.28</FmtValue>
            </Cell>
            <Cell CellOrdinal="470">
              <Value xsi:type="xsd:double">3.6844727799999935E4</Value>
              <FmtValue>$36,844.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="471">
              <Value xsi:type="xsd:double">3.48147899999999E4</Value>
              <FmtValue>$34,814.79</FmtValue>
            </Cell>
            <Cell CellOrdinal="472">
              <Value xsi:type="xsd:double">3.9289256399999925E4</Value>
              <FmtValue>$39,289.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="473">
              <Value xsi:type="xsd:double">4.9246115799999854E4</Value>
              <FmtValue>$49,246.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="474">
              <Value xsi:type="xsd:double">4.731913429999988E4</Value>
              <FmtValue>$47,319.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="475">
              <Value xsi:type="xsd:double">3.594470329999992E4</Value>
              <FmtValue>$35,944.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="476">
              <Value xsi:type="xsd:double">5.060498169999985E4</Value>
              <FmtValue>$50,604.98</FmtValue>
            </Cell>
            <Cell CellOrdinal="477">
              <Value xsi:type="xsd:double">4.62879322999999E4</Value>
              <FmtValue>$46,287.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="478">
              <Value xsi:type="xsd:double">3.4645623699999894E4</Value>
              <FmtValue>$34,645.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="479">
              <Value xsi:type="xsd:double">4.584034929999989E4</Value>
              <FmtValue>$45,840.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="480">
              <Value xsi:type="xsd:double">4.473440789999989E4</Value>
              <FmtValue>$44,734.41</FmtValue>
            </Cell>
            <Cell CellOrdinal="481">
              <Value xsi:type="xsd:double">1.7487774507999986E6</Value>
              <FmtValue>$1,748,777.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="482">
              <Value xsi:type="xsd:double">8.347976059999958E4</Value>
              <FmtValue>$83,479.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="483">
              <Value xsi:type="xsd:double">1.0054143539999958E5</Value>
              <FmtValue>$100,541.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="484">
              <Value xsi:type="xsd:double">9.620808779999966E4</Value>
              <FmtValue>$96,208.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="485">
              <Value xsi:type="xsd:double">1.2620634119999988E5</Value>
              <FmtValue>$126,206.34</FmtValue>
            </Cell>
            <Cell CellOrdinal="486">
              <Value xsi:type="xsd:double">1.6220180589999963E5</Value>
              <FmtValue>$162,201.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="487">
              <Value xsi:type="xsd:double">1.536025448999997E5</Value>
              <FmtValue>$153,602.54</FmtValue>
            </Cell>
            <Cell CellOrdinal="488">
              <Value xsi:type="xsd:double">1.5670814500000002E5</Value>
              <FmtValue>$156,708.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="489">
              <Value xsi:type="xsd:double">2.2415163520000072E5</Value>
              <FmtValue>$224,151.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="490">
              <Value xsi:type="xsd:double">2.0282312459999992E5</Value>
              <FmtValue>$202,823.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="491">
              <Value xsi:type="xsd:double">1.2475883339999997E5</Value>
              <FmtValue>$124,758.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="492">
              <Value xsi:type="xsd:double">1.6284443329999995E5</Value>
              <FmtValue>$162,844.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="493">
              <Value xsi:type="xsd:double">1.5525130349999998E5</Value>
              <FmtValue>$155,251.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="494">
              <Value xsi:type="xsd:double">2.117613449100015E6</Value>
              <FmtValue>$2,117,613.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="495">
              <Value xsi:type="xsd:double">1.0542047220000025E5</Value>
              <FmtValue>$105,420.47</FmtValue>
            </Cell>
            <Cell CellOrdinal="496">
              <Value xsi:type="xsd:double">1.2797334480000101E5</Value>
              <FmtValue>$127,973.34</FmtValue>
            </Cell>
            <Cell CellOrdinal="497">
              <Value xsi:type="xsd:double">1.2202530440000118E5</Value>
              <FmtValue>$122,025.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="498">
              <Value xsi:type="xsd:double">1.538109406000028E5</Value>
              <FmtValue>$153,810.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="499">
              <Value xsi:type="xsd:double">2.0123548730000254E5</Value>
              <FmtValue>$201,235.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="500">
              <Value xsi:type="xsd:double">1.890078360000028E5</Value>
              <FmtValue>$189,007.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="501">
              <Value xsi:type="xsd:double">1.8159649510000076E5</Value>
              <FmtValue>$181,596.50</FmtValue>
            </Cell>
            <Cell CellOrdinal="502">
              <Value xsi:type="xsd:double">2.622614361999973E5</Value>
              <FmtValue>$262,261.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="503">
              <Value xsi:type="xsd:double">2.376829756999992E5</Value>
              <FmtValue>$237,682.98</FmtValue>
            </Cell>
            <Cell CellOrdinal="504">
              <Value xsi:type="xsd:double">1.518882601000023E5</Value>
              <FmtValue>$151,888.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="505">
              <Value xsi:type="xsd:double">1.9691982990000246E5</Value>
              <FmtValue>$196,919.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="506">
              <Value xsi:type="xsd:double">1.8779106680000276E5</Value>
              <FmtValue>$187,791.07</FmtValue>
            </Cell>
            <Cell CellOrdinal="507">
              <Value xsi:type="xsd:double">1.6940906349999923E5</Value>
              <FmtValue>$169,409.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="508">
              <Value xsi:type="xsd:double">8.433637099999961E3</Value>
              <FmtValue>$8,433.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="509">
              <Value xsi:type="xsd:double">1.0237865599999946E4</Value>
              <FmtValue>$10,237.87</FmtValue>
            </Cell>
            <Cell CellOrdinal="510">
              <Value xsi:type="xsd:double">9.762022999999948E3</Value>
              <FmtValue>$9,762.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="511">
              <Value xsi:type="xsd:double">1.2304872899999951E4</Value>
              <FmtValue>$12,304.87</FmtValue>
            </Cell>
            <Cell CellOrdinal="512">
              <Value xsi:type="xsd:double">1.6098836499999908E4</Value>
              <FmtValue>$16,098.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="513">
              <Value xsi:type="xsd:double">1.5120625099999928E4</Value>
              <FmtValue>$15,120.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="514">
              <Value xsi:type="xsd:double">1.4527718399999978E4</Value>
              <FmtValue>$14,527.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="515">
              <Value xsi:type="xsd:double">2.098091549999991E4</Value>
              <FmtValue>$20,980.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="516">
              <Value xsi:type="xsd:double">1.9014637399999916E4</Value>
              <FmtValue>$19,014.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="517">
              <Value xsi:type="xsd:double">1.2151059999999946E4</Value>
              <FmtValue>$12,151.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="518">
              <Value xsi:type="xsd:double">1.5753585399999923E4</Value>
              <FmtValue>$15,753.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="519">
              <Value xsi:type="xsd:double">1.502328659999992E4</Value>
              <FmtValue>$15,023.29</FmtValue>
            </Cell>
            <Cell CellOrdinal="520">
              <Value xsi:type="xsd:double">5.294093679999985E4</Value>
              <FmtValue>$52,940.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="521">
              <Value xsi:type="xsd:double">2.635557900000004E3</Value>
              <FmtValue>$2,635.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="522">
              <Value xsi:type="xsd:double">3.1993841000000043E3</Value>
              <FmtValue>$3,199.38</FmtValue>
            </Cell>
            <Cell CellOrdinal="523">
              <Value xsi:type="xsd:double">3.050679300000003E3</Value>
              <FmtValue>$3,050.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="524">
              <Value xsi:type="xsd:double">3.8453237999999905E3</Value>
              <FmtValue>$3,845.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="525">
              <Value xsi:type="xsd:double">5.030942999999976E3</Value>
              <FmtValue>$5,030.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="526">
              <Value xsi:type="xsd:double">4.725256099999971E3</Value>
              <FmtValue>$4,725.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="527">
              <Value xsi:type="xsd:double">4.539953299999996E3</Value>
              <FmtValue>$4,539.95</FmtValue>
            </Cell>
            <Cell CellOrdinal="528">
              <Value xsi:type="xsd:double">6.556588099999981E3</Value>
              <FmtValue>$6,556.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="529">
              <Value xsi:type="xsd:double">5.942122699999978E3</Value>
              <FmtValue>$5,942.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="530">
              <Value xsi:type="xsd:double">3.7972494999999917E3</Value>
              <FmtValue>$3,797.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="531">
              <Value xsi:type="xsd:double">4.92304659999998E3</Value>
              <FmtValue>$4,923.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="532">
              <Value xsi:type="xsd:double">4.694832399999974E3</Value>
              <FmtValue>$4,694.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="533">
              <Value xsi:type="xsd:int">9871</Value>
              <FmtValue>9,871</FmtValue>
            </Cell>
            <Cell CellOrdinal="534">
              <Value xsi:type="xsd:int">770</Value>
              <FmtValue>770</FmtValue>
            </Cell>
            <Cell CellOrdinal="535">
              <Value xsi:type="xsd:int">865</Value>
              <FmtValue>865</FmtValue>
            </Cell>
            <Cell CellOrdinal="536">
              <Value xsi:type="xsd:int">851</Value>
              <FmtValue>851</FmtValue>
            </Cell>
            <Cell CellOrdinal="537">
              <Value xsi:type="xsd:int">832</Value>
              <FmtValue>832</FmtValue>
            </Cell>
            <Cell CellOrdinal="538">
              <Value xsi:type="xsd:int">964</Value>
              <FmtValue>964</FmtValue>
            </Cell>
            <Cell CellOrdinal="539">
              <Value xsi:type="xsd:int">1005</Value>
              <FmtValue>1,005</FmtValue>
            </Cell>
            <Cell CellOrdinal="540">
              <Value xsi:type="xsd:int">643</Value>
              <FmtValue>643</FmtValue>
            </Cell>
            <Cell CellOrdinal="541">
              <Value xsi:type="xsd:int">769</Value>
              <FmtValue>769</FmtValue>
            </Cell>
            <Cell CellOrdinal="542">
              <Value xsi:type="xsd:int">760</Value>
              <FmtValue>760</FmtValue>
            </Cell>
            <Cell CellOrdinal="543">
              <Value xsi:type="xsd:int">697</Value>
              <FmtValue>697</FmtValue>
            </Cell>
            <Cell CellOrdinal="544">
              <Value xsi:type="xsd:int">810</Value>
              <FmtValue>810</FmtValue>
            </Cell>
            <Cell CellOrdinal="545">
              <Value xsi:type="xsd:int">905</Value>
              <FmtValue>905</FmtValue>
            </Cell>
            <Cell CellOrdinal="546">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="547">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="548">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="549">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="550">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="551">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="552">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="553">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="554">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="555">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="556">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="557">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="558">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="559">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="560">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="561">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="562">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="563">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="564">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="565">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="566">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="567">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="568">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="569">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="570">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="571">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="572">
              <Value xsi:type="xsd:double">3.209498043803827E1</Value>
              <FmtValue>$32.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="573">
              <Value xsi:type="xsd:double">3.394140825420028E1</Value>
              <FmtValue>$33.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="574">
              <Value xsi:type="xsd:double">3.2115427750611374E1</Value>
              <FmtValue>$32.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="575">
              <Value xsi:type="xsd:double">3.287628023793803E1</Value>
              <FmtValue>$32.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="576">
              <Value xsi:type="xsd:double">3.3422709047333846E1</Value>
              <FmtValue>$33.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="577">
              <Value xsi:type="xsd:double">3.1513020524836E1</Value>
              <FmtValue>$31.51</FmtValue>
            </Cell>
            <Cell CellOrdinal="578">
              <Value xsi:type="xsd:double">3.226711215551181E1</Value>
              <FmtValue>$32.27</FmtValue>
            </Cell>
            <Cell CellOrdinal="579">
              <Value xsi:type="xsd:double">3.247905155526138E1</Value>
              <FmtValue>$32.48</FmtValue>
            </Cell>
            <Cell CellOrdinal="580">
              <Value xsi:type="xsd:double">3.0799475092764435E1</Value>
              <FmtValue>$30.80</FmtValue>
            </Cell>
            <Cell CellOrdinal="581">
              <Value xsi:type="xsd:double">3.1903548609680843E1</Value>
              <FmtValue>$31.90</FmtValue>
            </Cell>
            <Cell CellOrdinal="582">
              <Value xsi:type="xsd:double">3.2354987866666896E1</Value>
              <FmtValue>$32.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="583">
              <Value xsi:type="xsd:double">3.1031832409274312E1</Value>
              <FmtValue>$31.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="584">
              <Value xsi:type="xsd:double">3.1697814412070773E1</Value>
              <FmtValue>$31.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="585">
              <Value xsi:type="xsd:double">2.1452876599128916E2</Value>
              <FmtValue>$214.53</FmtValue>
            </Cell>
            <Cell CellOrdinal="586">
              <Value xsi:type="xsd:double">1.3690970415584448E2</Value>
              <FmtValue>$136.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="587">
              <Value xsi:type="xsd:double">1.4794606335260232E2</Value>
              <FmtValue>$147.95</FmtValue>
            </Cell>
            <Cell CellOrdinal="588">
              <Value xsi:type="xsd:double">1.4339048695652315E2</Value>
              <FmtValue>$143.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="589">
              <Value xsi:type="xsd:double">1.8486891899038798E2</Value>
              <FmtValue>$184.87</FmtValue>
            </Cell>
            <Cell CellOrdinal="590">
              <Value xsi:type="xsd:double">2.0875050549792795E2</Value>
              <FmtValue>$208.75</FmtValue>
            </Cell>
            <Cell CellOrdinal="591">
              <Value xsi:type="xsd:double">1.8806749850746547E2</Value>
              <FmtValue>$188.07</FmtValue>
            </Cell>
            <Cell CellOrdinal="592">
              <Value xsi:type="xsd:double">2.824206766718519E2</Value>
              <FmtValue>$282.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="593">
              <Value xsi:type="xsd:double">3.410421797139107E2</Value>
              <FmtValue>$341.04</FmtValue>
            </Cell>
            <Cell CellOrdinal="594">
              <Value xsi:type="xsd:double">3.1274075749999895E2</Value>
              <FmtValue>$312.74</FmtValue>
            </Cell>
            <Cell CellOrdinal="595">
              <Value xsi:type="xsd:double">2.1791715939742082E2</Value>
              <FmtValue>$217.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="596">
              <Value xsi:type="xsd:double">2.4311090111111414E2</Value>
              <FmtValue>$243.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="597">
              <Value xsi:type="xsd:double">2.0750394121547268E2</Value>
              <FmtValue>$207.50</FmtValue>
            </Cell>
            <Cell CellOrdinal="598">
              <Value xsi:type="xsd:double">3.688359983000166E5</Value>
              <FmtValue>$368,836.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="599">
              <Value xsi:type="xsd:double">2.1940711600000664E4</Value>
              <FmtValue>$21,940.71</FmtValue>
            </Cell>
            <Cell CellOrdinal="600">
              <Value xsi:type="xsd:double">2.743190940000143E4</Value>
              <FmtValue>$27,431.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="601">
              <Value xsi:type="xsd:double">2.5817216600001527E4</Value>
              <FmtValue>$25,817.22</FmtValue>
            </Cell>
            <Cell CellOrdinal="602">
              <Value xsi:type="xsd:double">2.7604599400002916E4</Value>
              <FmtValue>$27,604.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="603">
              <Value xsi:type="xsd:double">3.903368140000291E4</Value>
              <FmtValue>$39,033.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="604">
              <Value xsi:type="xsd:double">3.5405291100003116E4</Value>
              <FmtValue>$35,405.29</FmtValue>
            </Cell>
            <Cell CellOrdinal="605">
              <Value xsi:type="xsd:double">2.4888350100000738E4</Value>
              <FmtValue>$24,888.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="606">
              <Value xsi:type="xsd:double">3.81098009999966E4</Value>
              <FmtValue>$38,109.80</FmtValue>
            </Cell>
            <Cell CellOrdinal="607">
              <Value xsi:type="xsd:double">3.485985109999927E4</Value>
              <FmtValue>$34,859.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="608">
              <Value xsi:type="xsd:double">2.712942670000234E4</Value>
              <FmtValue>$27,129.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="609">
              <Value xsi:type="xsd:double">3.407539660000251E4</Value>
              <FmtValue>$34,075.40</FmtValue>
            </Cell>
            <Cell CellOrdinal="610">
              <Value xsi:type="xsd:double">3.2539763300002785E4</Value>
              <FmtValue>$32,539.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="611">
              <Value xsi:type="xsd:double">1.7417531913426964E-1</Value>
              <FmtValue>17.42%</FmtValue>
            </Cell>
            <Cell CellOrdinal="612">
              <Value xsi:type="xsd:double">2.0812571924716358E-1</Value>
              <FmtValue>20.81%</FmtValue>
            </Cell>
            <Cell CellOrdinal="613">
              <Value xsi:type="xsd:double">2.1435643057444892E-1</Value>
              <FmtValue>21.44%</FmtValue>
            </Cell>
            <Cell CellOrdinal="614">
              <Value xsi:type="xsd:double">2.1157264656658603E-1</Value>
              <FmtValue>21.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="615">
              <Value xsi:type="xsd:double">1.7947097451143482E-1</Value>
              <FmtValue>17.95%</FmtValue>
            </Cell>
            <Cell CellOrdinal="616">
              <Value xsi:type="xsd:double">1.9397016860058766E-1</Value>
              <FmtValue>19.40%</FmtValue>
            </Cell>
            <Cell CellOrdinal="617">
              <Value xsi:type="xsd:double">1.8732181611773277E-1</Value>
              <FmtValue>18.73%</FmtValue>
            </Cell>
            <Cell CellOrdinal="618">
              <Value xsi:type="xsd:double">1.3705303115181452E-1</Value>
              <FmtValue>13.71%</FmtValue>
            </Cell>
            <Cell CellOrdinal="619">
              <Value xsi:type="xsd:double">1.453122561676759E-1</Value>
              <FmtValue>14.53%</FmtValue>
            </Cell>
            <Cell CellOrdinal="620">
              <Value xsi:type="xsd:double">1.466653259339827E-1</Value>
              <FmtValue>14.67%</FmtValue>
            </Cell>
            <Cell CellOrdinal="621">
              <Value xsi:type="xsd:double">1.7861437534501012E-1</Value>
              <FmtValue>17.86%</FmtValue>
            </Cell>
            <Cell CellOrdinal="622">
              <Value xsi:type="xsd:double">1.730419766120369E-1</Value>
              <FmtValue>17.30%</FmtValue>
            </Cell>
            <Cell CellOrdinal="623">
              <Value xsi:type="xsd:double">1.7327641753405443E-1</Value>
              <FmtValue>17.33%</FmtValue>
            </Cell>
            <Cell CellOrdinal="637">
              <Value xsi:type="xsd:double">1.9284468133221953E-2</Value>
              <FmtValue>1.93%</FmtValue>
            </Cell>
            <Cell CellOrdinal="638">
              <Value xsi:type="xsd:double">1.737014105064993E-2</Value>
              <FmtValue>1.74%</FmtValue>
            </Cell>
            <Cell CellOrdinal="639">
              <Value xsi:type="xsd:double">1.3486793975193324E-2</Value>
              <FmtValue>1.35%</FmtValue>
            </Cell>
            <Cell CellOrdinal="640">
              <Value xsi:type="xsd:double">1.4580245268687204E-2</Value>
              <FmtValue>1.46%</FmtValue>
            </Cell>
            <Cell CellOrdinal="641">
              <Value xsi:type="xsd:double">1.9893691841000302E-2</Value>
              <FmtValue>1.99%</FmtValue>
            </Cell>
            <Cell CellOrdinal="642">
              <Value xsi:type="xsd:double">1.7378162788122302E-2</Value>
              <FmtValue>1.74%</FmtValue>
            </Cell>
            <Cell CellOrdinal="643">
              <Value xsi:type="xsd:double">1.971690672204386E-2</Value>
              <FmtValue>1.97%</FmtValue>
            </Cell>
            <Cell CellOrdinal="644">
              <Value xsi:type="xsd:double">2.4342917460442457E-2</Value>
              <FmtValue>2.43%</FmtValue>
            </Cell>
            <Cell CellOrdinal="645">
              <Value xsi:type="xsd:double">2.330761694885109E-2</Value>
              <FmtValue>2.33%</FmtValue>
            </Cell>
            <Cell CellOrdinal="646">
              <Value xsi:type="xsd:double">2.3927418570851295E-2</Value>
              <FmtValue>2.39%</FmtValue>
            </Cell>
            <Cell CellOrdinal="647">
              <Value xsi:type="xsd:double">2.189171940989501E-2</Value>
              <FmtValue>2.19%</FmtValue>
            </Cell>
            <Cell CellOrdinal="648">
              <Value xsi:type="xsd:double">1.800462034291588E-2</Value>
              <FmtValue>1.80%</FmtValue>
            </Cell>
            <Cell CellOrdinal="649">
              <Value xsi:type="xsd:double">1.7946846526902666E-2</Value>
              <FmtValue>1.79%</FmtValue>
            </Cell>
            <Cell CellOrdinal="650">
              <Value xsi:type="xsd:double">1.9284468133221953E-2</Value>
              <FmtValue>1.93%</FmtValue>
            </Cell>
            <Cell CellOrdinal="651">
              <Value xsi:type="xsd:double">1.737014105064993E-2</Value>
              <FmtValue>1.74%</FmtValue>
            </Cell>
            <Cell CellOrdinal="652">
              <Value xsi:type="xsd:double">1.3486793975193324E-2</Value>
              <FmtValue>1.35%</FmtValue>
            </Cell>
            <Cell CellOrdinal="653">
              <Value xsi:type="xsd:double">1.4580245268687204E-2</Value>
              <FmtValue>1.46%</FmtValue>
            </Cell>
            <Cell CellOrdinal="654">
              <Value xsi:type="xsd:double">1.9893691841000302E-2</Value>
              <FmtValue>1.99%</FmtValue>
            </Cell>
            <Cell CellOrdinal="655">
              <Value xsi:type="xsd:double">1.7378162788122302E-2</Value>
              <FmtValue>1.74%</FmtValue>
            </Cell>
            <Cell CellOrdinal="656">
              <Value xsi:type="xsd:double">1.971690672204386E-2</Value>
              <FmtValue>1.97%</FmtValue>
            </Cell>
            <Cell CellOrdinal="657">
              <Value xsi:type="xsd:double">2.4342917460442457E-2</Value>
              <FmtValue>2.43%</FmtValue>
            </Cell>
            <Cell CellOrdinal="658">
              <Value xsi:type="xsd:double">2.330761694885109E-2</Value>
              <FmtValue>2.33%</FmtValue>
            </Cell>
            <Cell CellOrdinal="659">
              <Value xsi:type="xsd:double">2.3927418570851295E-2</Value>
              <FmtValue>2.39%</FmtValue>
            </Cell>
            <Cell CellOrdinal="660">
              <Value xsi:type="xsd:double">2.189171940989501E-2</Value>
              <FmtValue>2.19%</FmtValue>
            </Cell>
            <Cell CellOrdinal="661">
              <Value xsi:type="xsd:double">1.800462034291588E-2</Value>
              <FmtValue>1.80%</FmtValue>
            </Cell>
            <Cell CellOrdinal="662">
              <Value xsi:type="xsd:double">1.7946846526902666E-2</Value>
              <FmtValue>1.79%</FmtValue>
            </Cell>
            <Cell CellOrdinal="663">
              <Value xsi:type="xsd:int">49027</Value>
              <FmtValue>49,027</FmtValue>
            </Cell>
            <Cell CellOrdinal="664">
              <Value xsi:type="xsd:int">1306</Value>
              <FmtValue>1,306</FmtValue>
            </Cell>
            <Cell CellOrdinal="665">
              <Value xsi:type="xsd:int">2129</Value>
              <FmtValue>2,129</FmtValue>
            </Cell>
            <Cell CellOrdinal="666">
              <Value xsi:type="xsd:int">2120</Value>
              <FmtValue>2,120</FmtValue>
            </Cell>
            <Cell CellOrdinal="667">
              <Value xsi:type="xsd:int">2833</Value>
              <FmtValue>2,833</FmtValue>
            </Cell>
            <Cell CellOrdinal="668">
              <Value xsi:type="xsd:int">4587</Value>
              <FmtValue>4,587</FmtValue>
            </Cell>
            <Cell CellOrdinal="669">
              <Value xsi:type="xsd:int">4442</Value>
              <FmtValue>4,442</FmtValue>
            </Cell>
            <Cell CellOrdinal="670">
              <Value xsi:type="xsd:int">4661</Value>
              <FmtValue>4,661</FmtValue>
            </Cell>
            <Cell CellOrdinal="671">
              <Value xsi:type="xsd:int">7672</Value>
              <FmtValue>7,672</FmtValue>
            </Cell>
            <Cell CellOrdinal="672">
              <Value xsi:type="xsd:int">7181</Value>
              <FmtValue>7,181</FmtValue>
            </Cell>
            <Cell CellOrdinal="673">
              <Value xsi:type="xsd:int">2864</Value>
              <FmtValue>2,864</FmtValue>
            </Cell>
            <Cell CellOrdinal="674">
              <Value xsi:type="xsd:int">4795</Value>
              <FmtValue>4,795</FmtValue>
            </Cell>
            <Cell CellOrdinal="675">
              <Value xsi:type="xsd:int">4437</Value>
              <FmtValue>4,437</FmtValue>
            </Cell>
            <Cell CellOrdinal="676">
              <Value xsi:type="xsd:double">1.1804291396499998E7</Value>
              <FmtValue>$11,804,291.40</FmtValue>
            </Cell>
            <Cell CellOrdinal="677">
              <Value xsi:type="xsd:double">2.829701261E5</Value>
              <FmtValue>$282,970.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="678">
              <Value xsi:type="xsd:double">5.356096779E5</Value>
              <FmtValue>$535,609.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="679">
              <Value xsi:type="xsd:double">4.7304283720000006E5</Value>
              <FmtValue>$473,042.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="680">
              <Value xsi:type="xsd:double">6.828711498999997E5</Value>
              <FmtValue>$682,871.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="681">
              <Value xsi:type="xsd:double">1.1475193436999994E6</Value>
              <FmtValue>$1,147,519.34</FmtValue>
            </Cell>
            <Cell CellOrdinal="682">
              <Value xsi:type="xsd:double">1.0909368285999996E6</Value>
              <FmtValue>$1,090,936.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="683">
              <Value xsi:type="xsd:double">1.170190906999999E6</Value>
              <FmtValue>$1,170,190.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="684">
              <Value xsi:type="xsd:double">1.842987461100001E6</Value>
              <FmtValue>$1,842,987.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="685">
              <Value xsi:type="xsd:double">1.6963031882999995E6</Value>
              <FmtValue>$1,696,303.19</FmtValue>
            </Cell>
            <Cell CellOrdinal="686">
              <Value xsi:type="xsd:double">6.460909261999992E5</Value>
              <FmtValue>$646,090.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="687">
              <Value xsi:type="xsd:double">1.177803561E6</Value>
              <FmtValue>$1,177,803.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="688">
              <Value xsi:type="xsd:double">1.0579653895E6</Value>
              <FmtValue>$1,057,965.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="689">
              <Value xsi:type="xsd:double">4.289134029700003E6</Value>
              <FmtValue>$4,289,134.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="690">
              <Value xsi:type="xsd:double">1.1039080989999995E5</Value>
              <FmtValue>$110,390.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="691">
              <Value xsi:type="xsd:double">2.2304665370000002E5</Value>
              <FmtValue>$223,046.65</FmtValue>
            </Cell>
            <Cell CellOrdinal="692">
              <Value xsi:type="xsd:double">1.968472351E5</Value>
              <FmtValue>$196,847.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="693">
              <Value xsi:type="xsd:double">2.5440039390000002E5</Value>
              <FmtValue>$254,400.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="694">
              <Value xsi:type="xsd:double">4.4169943920000025E5</Value>
              <FmtValue>$441,699.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="695">
              <Value xsi:type="xsd:double">4.206609149000002E5</Value>
              <FmtValue>$420,660.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="696">
              <Value xsi:type="xsd:double">3.649674901000003E5</Value>
              <FmtValue>$364,967.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="697">
              <Value xsi:type="xsd:double">6.393072481000009E5</Value>
              <FmtValue>$639,307.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="698">
              <Value xsi:type="xsd:double">5.694709829000003E5</Value>
              <FmtValue>$569,470.98</FmtValue>
            </Cell>
            <Cell CellOrdinal="699">
              <Value xsi:type="xsd:double">2.3606721060000005E5</Value>
              <FmtValue>$236,067.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="700">
              <Value xsi:type="xsd:double">4.4040916040000016E5</Value>
              <FmtValue>$440,409.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="701">
              <Value xsi:type="xsd:double">3.918664909000001E5</Value>
              <FmtValue>$391,866.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="702">
              <Value xsi:type="xsd:double">1.0766110178599996E7</Value>
              <FmtValue>$10,766,110.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="703">
              <Value xsi:type="xsd:double">2.5715104580000025E5</Value>
              <FmtValue>$257,151.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="704">
              <Value xsi:type="xsd:double">4.8420461550000013E5</Value>
              <FmtValue>$484,204.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="705">
              <Value xsi:type="xsd:double">4.233847106000001E5</Value>
              <FmtValue>$423,384.71</FmtValue>
            </Cell>
            <Cell CellOrdinal="706">
              <Value xsi:type="xsd:double">6.221485197000001E5</Value>
              <FmtValue>$622,148.52</FmtValue>
            </Cell>
            <Cell CellOrdinal="707">
              <Value xsi:type="xsd:double">1.0459987862000001E6</Value>
              <FmtValue>$1,045,998.79</FmtValue>
            </Cell>
            <Cell CellOrdinal="708">
              <Value xsi:type="xsd:double">9.930644573000001E5</Value>
              <FmtValue>$993,064.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="709">
              <Value xsi:type="xsd:double">1.0808248195999995E6</Value>
              <FmtValue>$1,080,824.82</FmtValue>
            </Cell>
            <Cell CellOrdinal="710">
              <Value xsi:type="xsd:double">1.6864799940999986E6</Value>
              <FmtValue>$1,686,479.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="711">
              <Value xsi:type="xsd:double">1.554415801299999E6</Value>
              <FmtValue>$1,554,415.80</FmtValue>
            </Cell>
            <Cell CellOrdinal="712">
              <Value xsi:type="xsd:double">5.875087858000003E5</Value>
              <FmtValue>$587,508.79</FmtValue>
            </Cell>
            <Cell CellOrdinal="713">
              <Value xsi:type="xsd:double">1.0717920500999996E6</Value>
              <FmtValue>$1,071,792.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="714">
              <Value xsi:type="xsd:double">9.591365926000004E5</Value>
              <FmtValue>$959,136.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="715">
              <Value xsi:type="xsd:double">1.17990766584E7</Value>
              <FmtValue>$11,799,076.66</FmtValue>
            </Cell>
            <Cell CellOrdinal="716">
              <Value xsi:type="xsd:double">2.8295707389999996E5</Value>
              <FmtValue>$282,957.07</FmtValue>
            </Cell>
            <Cell CellOrdinal="717">
              <Value xsi:type="xsd:double">5.356096779E5</Value>
              <FmtValue>$535,609.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="718">
              <Value xsi:type="xsd:double">4.7304283720000006E5</Value>
              <FmtValue>$473,042.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="719">
              <Value xsi:type="xsd:double">6.828113286999998E5</Value>
              <FmtValue>$682,811.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="720">
              <Value xsi:type="xsd:double">1.1475016443999991E6</Value>
              <FmtValue>$1,147,501.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="721">
              <Value xsi:type="xsd:double">1.0906787015999995E6</Value>
              <FmtValue>$1,090,678.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="722">
              <Value xsi:type="xsd:double">1.168454911199999E6</Value>
              <FmtValue>$1,168,454.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="723">
              <Value xsi:type="xsd:double">1.8420448460000008E6</Value>
              <FmtValue>$1,842,044.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="724">
              <Value xsi:type="xsd:double">1.6946239902999994E6</Value>
              <FmtValue>$1,694,623.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="725">
              <Value xsi:type="xsd:double">6.457989660999991E5</Value>
              <FmtValue>$645,798.97</FmtValue>
            </Cell>
            <Cell CellOrdinal="726">
              <Value xsi:type="xsd:double">1.1776638166999998E6</Value>
              <FmtValue>$1,177,663.82</FmtValue>
            </Cell>
            <Cell CellOrdinal="727">
              <Value xsi:type="xsd:double">1.0578888644E6</Value>
              <FmtValue>$1,057,888.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="728">
              <Value xsi:type="xsd:double">9.439261237000002E5</Value>
              <FmtValue>$943,926.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="729">
              <Value xsi:type="xsd:double">2.2636565799999996E4</Value>
              <FmtValue>$22,636.57</FmtValue>
            </Cell>
            <Cell CellOrdinal="730">
              <Value xsi:type="xsd:double">4.2848772200000014E4</Value>
              <FmtValue>$42,848.77</FmtValue>
            </Cell>
            <Cell CellOrdinal="731">
              <Value xsi:type="xsd:double">3.78434257E4</Value>
              <FmtValue>$37,843.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="732">
              <Value xsi:type="xsd:double">5.462490340000001E4</Value>
              <FmtValue>$54,624.90</FmtValue>
            </Cell>
            <Cell CellOrdinal="733">
              <Value xsi:type="xsd:double">9.180012860000002E4</Value>
              <FmtValue>$91,800.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="734">
              <Value xsi:type="xsd:double">8.725429520000008E4</Value>
              <FmtValue>$87,254.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="735">
              <Value xsi:type="xsd:double">9.347639159999999E4</Value>
              <FmtValue>$93,476.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="736">
              <Value xsi:type="xsd:double">1.4736358730000007E5</Value>
              <FmtValue>$147,363.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="737">
              <Value xsi:type="xsd:double">1.3556992080000008E5</Value>
              <FmtValue>$135,569.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="738">
              <Value xsi:type="xsd:double">5.1663916700000045E4</Value>
              <FmtValue>$51,663.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="739">
              <Value xsi:type="xsd:double">9.42131071E4</Value>
              <FmtValue>$94,213.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="740">
              <Value xsi:type="xsd:double">8.463110929999998E4</Value>
              <FmtValue>$84,631.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="741">
              <Value xsi:type="xsd:double">2.949771531E5</Value>
              <FmtValue>$294,977.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="742">
              <Value xsi:type="xsd:double">7.073934500000003E3</Value>
              <FmtValue>$7,073.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="743">
              <Value xsi:type="xsd:double">1.3390253799999995E4</Value>
              <FmtValue>$13,390.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="744">
              <Value xsi:type="xsd:double">1.1826081899999997E4</Value>
              <FmtValue>$11,826.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="745">
              <Value xsi:type="xsd:double">1.707029719999999E4</Value>
              <FmtValue>$17,070.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="746">
              <Value xsi:type="xsd:double">2.8687565499999982E4</Value>
              <FmtValue>$28,687.57</FmtValue>
            </Cell>
            <Cell CellOrdinal="747">
              <Value xsi:type="xsd:double">2.7266990500000003E4</Value>
              <FmtValue>$27,266.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="748">
              <Value xsi:type="xsd:double">2.92113909E4</Value>
              <FmtValue>$29,211.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="749">
              <Value xsi:type="xsd:double">4.6051152900000015E4</Value>
              <FmtValue>$46,051.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="750">
              <Value xsi:type="xsd:double">4.2365631599999986E4</Value>
              <FmtValue>$42,365.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="751">
              <Value xsi:type="xsd:double">1.6144987800000002E4</Value>
              <FmtValue>$16,144.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="752">
              <Value xsi:type="xsd:double">2.944162109999999E4</Value>
              <FmtValue>$29,441.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="753">
              <Value xsi:type="xsd:double">2.644724539999999E4</Value>
              <FmtValue>$26,447.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="754">
              <Value xsi:type="xsd:int">2646</Value>
              <FmtValue>2,646</FmtValue>
            </Cell>
            <Cell CellOrdinal="755">
              <Value xsi:type="xsd:int">97</Value>
              <FmtValue>97</FmtValue>
            </Cell>
            <Cell CellOrdinal="756">
              <Value xsi:type="xsd:int">200</Value>
              <FmtValue>200</FmtValue>
            </Cell>
            <Cell CellOrdinal="757">
              <Value xsi:type="xsd:int">190</Value>
              <FmtValue>190</FmtValue>
            </Cell>
            <Cell CellOrdinal="758">
              <Value xsi:type="xsd:int">155</Value>
              <FmtValue>155</FmtValue>
            </Cell>
            <Cell CellOrdinal="759">
              <Value xsi:type="xsd:int">279</Value>
              <FmtValue>279</FmtValue>
            </Cell>
            <Cell CellOrdinal="760">
              <Value xsi:type="xsd:int">255</Value>
              <FmtValue>255</FmtValue>
            </Cell>
            <Cell CellOrdinal="761">
              <Value xsi:type="xsd:int">161</Value>
              <FmtValue>161</FmtValue>
            </Cell>
            <Cell CellOrdinal="762">
              <Value xsi:type="xsd:int">332</Value>
              <FmtValue>332</FmtValue>
            </Cell>
            <Cell CellOrdinal="763">
              <Value xsi:type="xsd:int">289</Value>
              <FmtValue>289</FmtValue>
            </Cell>
            <Cell CellOrdinal="764">
              <Value xsi:type="xsd:int">152</Value>
              <FmtValue>152</FmtValue>
            </Cell>
            <Cell CellOrdinal="765">
              <Value xsi:type="xsd:int">279</Value>
              <FmtValue>279</FmtValue>
            </Cell>
            <Cell CellOrdinal="766">
              <Value xsi:type="xsd:int">257</Value>
              <FmtValue>257</FmtValue>
            </Cell>
            <Cell CellOrdinal="767">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="768">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="769">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="770">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="771">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="772">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="773">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="774">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="775">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="776">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="777">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="778">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="779">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="780">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="781">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="782">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="783">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="784">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="785">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="786">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="787">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="788">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="789">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="790">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="791">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="792">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="793">
              <Value xsi:type="xsd:double">2.5140162914860568E2</Value>
              <FmtValue>$251.40</FmtValue>
            </Cell>
            <Cell CellOrdinal="794">
              <Value xsi:type="xsd:double">2.263468304104479E2</Value>
              <FmtValue>$226.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="795">
              <Value xsi:type="xsd:double">2.592563720881426E2</Value>
              <FmtValue>$259.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="796">
              <Value xsi:type="xsd:double">2.369773573593073E2</Value>
              <FmtValue>$236.98</FmtValue>
            </Cell>
            <Cell CellOrdinal="797">
              <Value xsi:type="xsd:double">2.4772037415630532E2</Value>
              <FmtValue>$247.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="798">
              <Value xsi:type="xsd:double">2.5971790924234244E2</Value>
              <FmtValue>$259.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="799">
              <Value xsi:type="xsd:double">2.5786790649132587E2</Value>
              <FmtValue>$257.87</FmtValue>
            </Cell>
            <Cell CellOrdinal="800">
              <Value xsi:type="xsd:double">2.5544949011627855E2</Value>
              <FmtValue>$255.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="801">
              <Value xsi:type="xsd:double">2.5460606254572042E2</Value>
              <FmtValue>$254.61</FmtValue>
            </Cell>
            <Cell CellOrdinal="802">
              <Value xsi:type="xsd:double">2.4793259043062164E2</Value>
              <FmtValue>$247.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="803">
              <Value xsi:type="xsd:double">2.388275662062613E2</Value>
              <FmtValue>$238.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="804">
              <Value xsi:type="xsd:double">2.5489487409162672E2</Value>
              <FmtValue>$254.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="805">
              <Value xsi:type="xsd:double">2.497089839999998E2</Value>
              <FmtValue>$249.71</FmtValue>
            </Cell>
            <Cell CellOrdinal="806">
              <Value xsi:type="xsd:double">4.459212644897959E3</Value>
              <FmtValue>$4,459.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="807">
              <Value xsi:type="xsd:double">2.917083236082474E3</Value>
              <FmtValue>$2,917.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="808">
              <Value xsi:type="xsd:double">2.6780483895E3</Value>
              <FmtValue>$2,678.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="809">
              <Value xsi:type="xsd:double">2.489699143157895E3</Value>
              <FmtValue>$2,489.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="810">
              <Value xsi:type="xsd:double">4.405234378709676E3</Value>
              <FmtValue>$4,405.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="811">
              <Value xsi:type="xsd:double">4.112909119713258E3</Value>
              <FmtValue>$4,112.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="812">
              <Value xsi:type="xsd:double">4.277171378823527E3</Value>
              <FmtValue>$4,277.17</FmtValue>
            </Cell>
            <Cell CellOrdinal="813">
              <Value xsi:type="xsd:double">7.2574839204968885E3</Value>
              <FmtValue>$7,257.48</FmtValue>
            </Cell>
            <Cell CellOrdinal="814">
              <Value xsi:type="xsd:double">5.548327849397593E3</Value>
              <FmtValue>$5,548.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="815">
              <Value xsi:type="xsd:double">5.863750831487888E3</Value>
              <FmtValue>$5,863.75</FmtValue>
            </Cell>
            <Cell CellOrdinal="816">
              <Value xsi:type="xsd:double">4.248677408552626E3</Value>
              <FmtValue>$4,248.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="817">
              <Value xsi:type="xsd:double">4.2210172641577055E3</Value>
              <FmtValue>$4,221.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="818">
              <Value xsi:type="xsd:double">4.116299083268483E3</Value>
              <FmtValue>$4,116.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="819">
              <Value xsi:type="xsd:double">1.0329664798000026E6</Value>
              <FmtValue>$1,032,966.48</FmtValue>
            </Cell>
            <Cell CellOrdinal="820">
              <Value xsi:type="xsd:double">2.5806028099999705E4</Value>
              <FmtValue>$25,806.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="821">
              <Value xsi:type="xsd:double">5.140506239999988E4</Value>
              <FmtValue>$51,405.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="822">
              <Value xsi:type="xsd:double">4.965812659999996E4</Value>
              <FmtValue>$49,658.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="823">
              <Value xsi:type="xsd:double">6.0662808999999775E4</Value>
              <FmtValue>$60,662.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="824">
              <Value xsi:type="xsd:double">1.0150285819999908E5</Value>
              <FmtValue>$101,502.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="825">
              <Value xsi:type="xsd:double">9.761424429999944E4</Value>
              <FmtValue>$97,614.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="826">
              <Value xsi:type="xsd:double">8.763009159999946E4</Value>
              <FmtValue>$87,630.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="827">
              <Value xsi:type="xsd:double">1.5556485190000222E5</Value>
              <FmtValue>$155,564.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="828">
              <Value xsi:type="xsd:double">1.4020818900000048E5</Value>
              <FmtValue>$140,208.19</FmtValue>
            </Cell>
            <Cell CellOrdinal="829">
              <Value xsi:type="xsd:double">5.829018029999884E4</Value>
              <FmtValue>$58,290.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="830">
              <Value xsi:type="xsd:double">1.058717666000002E5</Value>
              <FmtValue>$105,871.77</FmtValue>
            </Cell>
            <Cell CellOrdinal="831">
              <Value xsi:type="xsd:double">9.875227179999964E4</Value>
              <FmtValue>$98,752.27</FmtValue>
            </Cell>
            <Cell CellOrdinal="832">
              <Value xsi:type="xsd:double">8.754638262856044E-2</Value>
              <FmtValue>8.75%</FmtValue>
            </Cell>
            <Cell CellOrdinal="833">
              <Value xsi:type="xsd:double">9.120121205776897E-2</Value>
              <FmtValue>9.12%</FmtValue>
            </Cell>
            <Cell CellOrdinal="834">
              <Value xsi:type="xsd:double">9.597485729075523E-2</Value>
              <FmtValue>9.60%</FmtValue>
            </Cell>
            <Cell CellOrdinal="835">
              <Value xsi:type="xsd:double">1.049759613609893E-1</Value>
              <FmtValue>10.50%</FmtValue>
            </Cell>
            <Cell CellOrdinal="836">
              <Value xsi:type="xsd:double">8.88427102044357E-2</Value>
              <FmtValue>8.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="837">
              <Value xsi:type="xsd:double">8.845552308822396E-2</Value>
              <FmtValue>8.85%</FmtValue>
            </Cell>
            <Cell CellOrdinal="838">
              <Value xsi:type="xsd:double">8.949862517421646E-2</Value>
              <FmtValue>8.95%</FmtValue>
            </Cell>
            <Cell CellOrdinal="839">
              <Value xsi:type="xsd:double">7.499655379085503E-2</Value>
              <FmtValue>7.50%</FmtValue>
            </Cell>
            <Cell CellOrdinal="840">
              <Value xsi:type="xsd:double">8.445226088703063E-2</Value>
              <FmtValue>8.45%</FmtValue>
            </Cell>
            <Cell CellOrdinal="841">
              <Value xsi:type="xsd:double">8.273704951809363E-2</Value>
              <FmtValue>8.27%</FmtValue>
            </Cell>
            <Cell CellOrdinal="842">
              <Value xsi:type="xsd:double">9.02605661511277E-2</Value>
              <FmtValue>9.03%</FmtValue>
            </Cell>
            <Cell CellOrdinal="843">
              <Value xsi:type="xsd:double">8.989982123817783E-2</Value>
              <FmtValue>8.99%</FmtValue>
            </Cell>
            <Cell CellOrdinal="844">
              <Value xsi:type="xsd:double">9.334843680012521E-2</Value>
              <FmtValue>9.33%</FmtValue>
            </Cell>
            <Cell CellOrdinal="858">
              <Value xsi:type="xsd:double">1.0745063879201452E-1</Value>
              <FmtValue>10.75%</FmtValue>
            </Cell>
            <Cell CellOrdinal="859">
              <Value xsi:type="xsd:double">4.6622863494650175E-2</Value>
              <FmtValue>4.66%</FmtValue>
            </Cell>
            <Cell CellOrdinal="860">
              <Value xsi:type="xsd:double">5.6446577904533286E-2</Value>
              <FmtValue>5.64%</FmtValue>
            </Cell>
            <Cell CellOrdinal="861">
              <Value xsi:type="xsd:double">5.6521724103739304E-2</Value>
              <FmtValue>5.65%</FmtValue>
            </Cell>
            <Cell CellOrdinal="862">
              <Value xsi:type="xsd:double">8.831386184697394E-2</Value>
              <FmtValue>8.83%</FmtValue>
            </Cell>
            <Cell CellOrdinal="863">
              <Value xsi:type="xsd:double">9.909519758954048E-2</Value>
              <FmtValue>9.91%</FmtValue>
            </Cell>
            <Cell CellOrdinal="864">
              <Value xsi:type="xsd:double">1.1377734742789598E-1</Value>
              <FmtValue>11.38%</FmtValue>
            </Cell>
            <Cell CellOrdinal="865">
              <Value xsi:type="xsd:double">1.5663078433274277E-1</Value>
              <FmtValue>15.66%</FmtValue>
            </Cell>
            <Cell CellOrdinal="866">
              <Value xsi:type="xsd:double">1.6370563776075994E-1</Value>
              <FmtValue>16.37%</FmtValue>
            </Cell>
            <Cell CellOrdinal="867">
              <Value xsi:type="xsd:double">1.7059689452598212E-1</Value>
              <FmtValue>17.06%</FmtValue>
            </Cell>
            <Cell CellOrdinal="868">
              <Value xsi:type="xsd:double">9.307927914740307E-2</Value>
              <FmtValue>9.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="869">
              <Value xsi:type="xsd:double">1.0767523982749748E-1</Value>
              <FmtValue>10.77%</FmtValue>
            </Cell>
            <Cell CellOrdinal="870">
              <Value xsi:type="xsd:double">1.0110049117579146E-1</Value>
              <FmtValue>10.11%</FmtValue>
            </Cell>
            <Cell CellOrdinal="871">
              <Value xsi:type="xsd:double">1.0745063879201452E-1</Value>
              <FmtValue>10.75%</FmtValue>
            </Cell>
            <Cell CellOrdinal="872">
              <Value xsi:type="xsd:double">4.6622863494650175E-2</Value>
              <FmtValue>4.66%</FmtValue>
            </Cell>
            <Cell CellOrdinal="873">
              <Value xsi:type="xsd:double">5.6446577904533286E-2</Value>
              <FmtValue>5.64%</FmtValue>
            </Cell>
            <Cell CellOrdinal="874">
              <Value xsi:type="xsd:double">5.6521724103739304E-2</Value>
              <FmtValue>5.65%</FmtValue>
            </Cell>
            <Cell CellOrdinal="875">
              <Value xsi:type="xsd:double">8.831386184697394E-2</Value>
              <FmtValue>8.83%</FmtValue>
            </Cell>
            <Cell CellOrdinal="876">
              <Value xsi:type="xsd:double">9.909519758954048E-2</Value>
              <FmtValue>9.91%</FmtValue>
            </Cell>
            <Cell CellOrdinal="877">
              <Value xsi:type="xsd:double">1.1377734742789598E-1</Value>
              <FmtValue>11.38%</FmtValue>
            </Cell>
            <Cell CellOrdinal="878">
              <Value xsi:type="xsd:double">1.5663078433274277E-1</Value>
              <FmtValue>15.66%</FmtValue>
            </Cell>
            <Cell CellOrdinal="879">
              <Value xsi:type="xsd:double">1.6370563776075994E-1</Value>
              <FmtValue>16.37%</FmtValue>
            </Cell>
            <Cell CellOrdinal="880">
              <Value xsi:type="xsd:double">1.7059689452598212E-1</Value>
              <FmtValue>17.06%</FmtValue>
            </Cell>
            <Cell CellOrdinal="881">
              <Value xsi:type="xsd:double">9.307927914740307E-2</Value>
              <FmtValue>9.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="882">
              <Value xsi:type="xsd:double">1.0767523982749748E-1</Value>
              <FmtValue>10.77%</FmtValue>
            </Cell>
            <Cell CellOrdinal="883">
              <Value xsi:type="xsd:double">1.0110049117579146E-1</Value>
              <FmtValue>10.11%</FmtValue>
            </Cell>
          </CellData>
        </root>
      </return>
    </ExecuteResponse>
  </soap:Body>
</soap:Envelope>
"""),
    ],
    "test3Axes":[
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Execute>
      <Command>
        <Statement>select [Measures].ALLMEMBERS on columns, 
                       [Date].[Month of Year].ALLMEMBERS on rows, [Product].[Product Categories].[Category].ALLMEMBERS on Axis(2) 
                from [Sales Summary]</Statement>
      </Command>
      <Properties>
        <PropertyList>
          <Format>Multidimensional</Format>
          <AxisFormat>TupleFormat</AxisFormat>
          <Catalog>Adventure Works DW 2008R2</Catalog>
        </PropertyList>
      </Properties>
    </Execute>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
  <soap:Body>
    <ExecuteResponse xmlns="urn:schemas-microsoft-com:xml-analysis">
      <return>
        <root xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla">
          <xs:schema xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla" targetNamespace="urn:schemas-microsoft-com:xml-analysis:mddataset" elementFormDefault="qualified">
            <xs:import namespace="http://schemas.microsoft.com/analysisservices/2003/xmla"/>
            <xs:complexType name="MemberType">
              <xs:sequence>
                <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string"/>
            </xs:complexType>
            <xs:complexType name="PropType">
              <xs:sequence>
                <xs:element name="Default" minOccurs="0"/>
              </xs:sequence>
              <xs:attribute name="name" type="xs:string" use="required"/>
              <xs:attribute name="type" type="xs:QName"/>
            </xs:complexType>
            <xs:complexType name="TupleType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="MembersType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string" use="required"/>
            </xs:complexType>
            <xs:complexType name="TuplesType">
              <xs:sequence>
                <xs:element name="Tuple" type="TupleType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:group name="SetType">
              <xs:choice>
                <xs:element name="Members" type="MembersType"/>
                <xs:element name="Tuples" type="TuplesType"/>
                <xs:element name="CrossProduct" type="SetListType"/>
                <xs:element ref="msxmla:NormTupleSet"/>
                <xs:element name="Union">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                  </xs:complexType>
                </xs:element>
              </xs:choice>
            </xs:group>
            <xs:complexType name="SetListType">
              <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
              <xs:attribute name="Size" type="xs:unsignedInt"/>
            </xs:complexType>
            <xs:complexType name="OlapInfo">
              <xs:sequence>
                <xs:element name="CubeInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="Cube" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="CubeName" type="xs:string"/>
                            <xs:element name="LastDataUpdate" minOccurs="0" type="xs:dateTime"/>
                            <xs:element name="LastSchemaUpdate" minOccurs="0" type="xs:dateTime"/>
                          </xs:sequence>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="AxesInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="AxisInfo" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="HierarchyInfo" minOccurs="0" maxOccurs="unbounded">
                              <xs:complexType>
                                <xs:sequence>
                                  <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                                </xs:sequence>
                                <xs:attribute name="name" type="xs:string" use="required"/>
                              </xs:complexType>
                            </xs:element>
                          </xs:sequence>
                          <xs:attribute name="name" type="xs:string"/>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="CellInfo">
                  <xs:complexType>
                    <xs:choice minOccurs="0" maxOccurs="unbounded">
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:choice>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="Axes">
              <xs:sequence>
                <xs:element name="Axis" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                    <xs:attribute name="name" type="xs:string"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="CellData">
              <xs:sequence>
                <xs:element name="Cell" minOccurs="0" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:sequence>
                    <xs:attribute name="CellOrdinal" type="xs:unsignedInt" use="required"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:element name="root">
              <xs:complexType>
                <xs:sequence>
                  <xs:any namespace="http://www.w3.org/2001/XMLSchema" processContents="strict" minOccurs="0"/>
                  <xs:element name="OlapInfo" type="OlapInfo" minOccurs="0"/>
                  <xs:element name="Axes" type="Axes" minOccurs="0"/>
                  <xs:element name="CellData" type="CellData" minOccurs="0"/>
                </xs:sequence>
              </xs:complexType>
            </xs:element>
          </xs:schema>
          <OlapInfo>
            <CubeInfo>
              <Cube>
                <CubeName>Sales Summary</CubeName>
                <LastDataUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-24T11:57:43.523333</LastDataUpdate>
                <LastSchemaUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-23T23:01:05.413333</LastSchemaUpdate>
              </Cube>
            </CubeInfo>
            <AxesInfo>
              <AxisInfo name="Axis0">
                <HierarchyInfo name="[Measures]">
                  <UName name="[Measures].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Measures].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Measures].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Measures].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Measures].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
              <AxisInfo name="Axis1">
                <HierarchyInfo name="[Date].[Month of Year]">
                  <UName name="[Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
              <AxisInfo name="Axis2">
                <HierarchyInfo name="[Product].[Product Categories]">
                  <UName name="[Product].[Product Categories].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Categories].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Categories].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Categories].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Categories].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
              <AxisInfo name="SlicerAxis">
                <HierarchyInfo name="[Date].[Fiscal]">
                  <UName name="[Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar]">
                  <UName name="[Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Weeks]">
                  <UName name="[Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Weeks]">
                  <UName name="[Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Year]">
                  <UName name="[Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Date]">
                  <UName name="[Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Week]">
                  <UName name="[Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day Name]">
                  <UName name="[Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Month]">
                  <UName name="[Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Year]">
                  <UName name="[Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Year]">
                  <UName name="[Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Semester of Year]">
                  <UName name="[Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Semester of Year]">
                  <UName name="[Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Quarter of Year]">
                  <UName name="[Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Quarter of Year]">
                  <UName name="[Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Week of Year]">
                  <UName name="[Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Week of Year]">
                  <UName name="[Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal]">
                  <UName name="[Ship Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar]">
                  <UName name="[Ship Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Weeks]">
                  <UName name="[Ship Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Weeks]">
                  <UName name="[Ship Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Year]">
                  <UName name="[Ship Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Date]">
                  <UName name="[Ship Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Week]">
                  <UName name="[Ship Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day Name]">
                  <UName name="[Ship Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Month]">
                  <UName name="[Ship Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Year]">
                  <UName name="[Ship Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Year]">
                  <UName name="[Ship Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Semester of Year]">
                  <UName name="[Ship Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Semester of Year]">
                  <UName name="[Ship Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Quarter of Year]">
                  <UName name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Quarter of Year]">
                  <UName name="[Ship Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Month of Year]">
                  <UName name="[Ship Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Week of Year]">
                  <UName name="[Ship Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Week of Year]">
                  <UName name="[Ship Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal]">
                  <UName name="[Delivery Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar]">
                  <UName name="[Delivery Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Weeks]">
                  <UName name="[Delivery Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Weeks]">
                  <UName name="[Delivery Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Year]">
                  <UName name="[Delivery Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Date]">
                  <UName name="[Delivery Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Week]">
                  <UName name="[Delivery Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day Name]">
                  <UName name="[Delivery Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Month]">
                  <UName name="[Delivery Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Year]">
                  <UName name="[Delivery Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Year]">
                  <UName name="[Delivery Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Semester of Year]">
                  <UName name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Semester of Year]">
                  <UName name="[Delivery Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Quarter of Year]">
                  <UName name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Quarter of Year]">
                  <UName name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Month of Year]">
                  <UName name="[Delivery Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Week of Year]">
                  <UName name="[Delivery Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Week of Year]">
                  <UName name="[Delivery Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotions]">
                  <UName name="[Promotion].[Promotions].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotions].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotions].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotions].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotions].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion]">
                  <UName name="[Promotion].[Promotion].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Discount Percent]">
                  <UName name="[Promotion].[Discount Percent].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Discount Percent].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Discount Percent].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Discount Percent].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Discount Percent].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Max Quantity]">
                  <UName name="[Promotion].[Max Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Max Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Max Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Max Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Max Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Type]">
                  <UName name="[Promotion].[Promotion Type].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Type].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Type].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Type].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Type].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Min Quantity]">
                  <UName name="[Promotion].[Min Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Min Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Min Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Min Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Min Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Category]">
                  <UName name="[Promotion].[Promotion Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[End Date]">
                  <UName name="[Promotion].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Start Date]">
                  <UName name="[Promotion].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Model Lines]">
                  <UName name="[Product].[Product Model Lines].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Model Lines].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Model Lines].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Model Lines].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Model Lines].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Stock Level]">
                  <UName name="[Product].[Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product]">
                  <UName name="[Product].[Product].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Standard Cost]">
                  <UName name="[Product].[Standard Cost].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Standard Cost].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Standard Cost].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Standard Cost].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Standard Cost].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Category]">
                  <UName name="[Product].[Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Color]">
                  <UName name="[Product].[Color].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Color].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Color].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Color].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Color].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Safety Stock Level]">
                  <UName name="[Product].[Safety Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Safety Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Safety Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Safety Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Safety Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Reorder Point]">
                  <UName name="[Product].[Reorder Point].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Reorder Point].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Reorder Point].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Reorder Point].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Reorder Point].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[List Price]">
                  <UName name="[Product].[List Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[List Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[List Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[List Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[List Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size]">
                  <UName name="[Product].[Size].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size Range]">
                  <UName name="[Product].[Size Range].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size Range].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size Range].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size Range].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size Range].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Weight]">
                  <UName name="[Product].[Weight].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Weight].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Weight].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Weight].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Weight].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Days to Manufacture]">
                  <UName name="[Product].[Days to Manufacture].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Days to Manufacture].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Days to Manufacture].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Days to Manufacture].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Days to Manufacture].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Dealer Price]">
                  <UName name="[Product].[Dealer Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Dealer Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Dealer Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Dealer Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Dealer Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Class]">
                  <UName name="[Product].[Class].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Class].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Class].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Class].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Class].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Style]">
                  <UName name="[Product].[Style].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Style].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Style].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Style].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Style].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Model Name]">
                  <UName name="[Product].[Model Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Model Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Model Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Model Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Model Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Line]">
                  <UName name="[Product].[Product Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Subcategory]">
                  <UName name="[Product].[Subcategory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Subcategory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Subcategory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Subcategory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Subcategory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Status]">
                  <UName name="[Product].[Status].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Status].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Status].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Status].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Status].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Start Date]">
                  <UName name="[Product].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[End Date]">
                  <UName name="[Product].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Large Photo]">
                  <UName name="[Product].[Large Photo].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Large Photo].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Large Photo].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Large Photo].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Large Photo].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory]">
                  <UName name="[Sales Territory].[Sales Territory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Region]">
                  <UName name="[Sales Territory].[Sales Territory Region].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Region].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Region].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Region].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Region].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Country]">
                  <UName name="[Sales Territory].[Sales Territory Country].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Country].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Country].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Country].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Country].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Group]">
                  <UName name="[Sales Territory].[Sales Territory Group].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Group].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Group].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Group].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Group].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Orders]">
                  <UName name="[Sales Summary Order Details].[Sales Orders].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Orders].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Orders].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Orders].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Orders].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Carrier Tracking Number]">
                  <UName name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Carrier Tracking Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Customer PO Number]">
                  <UName name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Customer PO Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Number]">
                  <UName name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Line]">
                  <UName name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency Code]">
                  <UName name="[Source Currency].[Source Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency]">
                  <UName name="[Source Currency].[Source Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency]">
                  <UName name="[Destination Currency].[Destination Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency Code]">
                  <UName name="[Destination Currency].[Destination Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Channel].[Sales Channel]">
                  <UName name="[Sales Channel].[Sales Channel].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Channel].[Sales Channel].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Channel].[Sales Channel].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Channel].[Sales Channel].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Channel].[Sales Channel].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
            </AxesInfo>
            <CellInfo>
              <Value name="VALUE"/>
              <FmtValue name="FORMATTED_VALUE" type="xsd:string"/>
              <CellOrdinal name="CELL_ORDINAL" type="xsd:unsignedInt"/>
            </CellInfo>
          </OlapInfo>
          <Axes>
            <Axis name="Axis0">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
            <Axis name="Axis1">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>65548</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[1]</UName>
                    <Caption>January</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[2]</UName>
                    <Caption>February</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[3]</UName>
                    <Caption>March</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[4]</UName>
                    <Caption>April</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[5]</UName>
                    <Caption>May</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[6]</UName>
                    <Caption>June</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[7]</UName>
                    <Caption>July</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[8]</UName>
                    <Caption>August</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[9]</UName>
                    <Caption>September</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[10]</UName>
                    <Caption>October</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[11]</UName>
                    <Caption>November</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].&amp;[12]</UName>
                    <Caption>December</Caption>
                    <LName>[Date].[Month of Year].[Month of Year]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
            <Axis name="Axis2">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[Category].&amp;[4]</UName>
                    <Caption>Accessories</Caption>
                    <LName>[Product].[Product Categories].[Category]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[Category].&amp;[1]</UName>
                    <Caption>Bikes</Caption>
                    <LName>[Product].[Product Categories].[Category]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131075</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[Category].&amp;[3]</UName>
                    <Caption>Clothing</Caption>
                    <LName>[Product].[Product Categories].[Category]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131080</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[Category].&amp;[2]</UName>
                    <Caption>Components</Caption>
                    <LName>[Product].[Product Categories].[Category]</LName>
                    <LNum>1</LNum>
                    <DisplayInfo>131086</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
            <Axis name="SlicerAxis">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Date].[Fiscal]">
                    <UName>[Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar]">
                    <UName>[Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Weeks]">
                    <UName>[Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Weeks]">
                    <UName>[Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Year]">
                    <UName>[Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Date]">
                    <UName>[Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Week]">
                    <UName>[Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day Name]">
                    <UName>[Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Month]">
                    <UName>[Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Year]">
                    <UName>[Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Year]">
                    <UName>[Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Semester of Year]">
                    <UName>[Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Semester of Year]">
                    <UName>[Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Quarter of Year]">
                    <UName>[Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Quarter of Year]">
                    <UName>[Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Week of Year]">
                    <UName>[Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Week of Year]">
                    <UName>[Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal]">
                    <UName>[Ship Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar]">
                    <UName>[Ship Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Weeks]">
                    <UName>[Ship Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Weeks]">
                    <UName>[Ship Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Year]">
                    <UName>[Ship Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Date]">
                    <UName>[Ship Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Week]">
                    <UName>[Ship Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day Name]">
                    <UName>[Ship Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Month]">
                    <UName>[Ship Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Year]">
                    <UName>[Ship Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Year]">
                    <UName>[Ship Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Semester of Year]">
                    <UName>[Ship Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Semester of Year]">
                    <UName>[Ship Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Quarter of Year]">
                    <UName>[Ship Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Quarter of Year]">
                    <UName>[Ship Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Month of Year]">
                    <UName>[Ship Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Week of Year]">
                    <UName>[Ship Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Week of Year]">
                    <UName>[Ship Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal]">
                    <UName>[Delivery Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar]">
                    <UName>[Delivery Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Weeks]">
                    <UName>[Delivery Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Weeks]">
                    <UName>[Delivery Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Year]">
                    <UName>[Delivery Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Date]">
                    <UName>[Delivery Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Week]">
                    <UName>[Delivery Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day Name]">
                    <UName>[Delivery Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Month]">
                    <UName>[Delivery Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Year]">
                    <UName>[Delivery Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Year]">
                    <UName>[Delivery Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Semester of Year]">
                    <UName>[Delivery Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Semester of Year]">
                    <UName>[Delivery Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Quarter of Year]">
                    <UName>[Delivery Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Quarter of Year]">
                    <UName>[Delivery Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Month of Year]">
                    <UName>[Delivery Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Week of Year]">
                    <UName>[Delivery Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Week of Year]">
                    <UName>[Delivery Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotions]">
                    <UName>[Promotion].[Promotions].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotions].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion]">
                    <UName>[Promotion].[Promotion].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>16</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Discount Percent]">
                    <UName>[Promotion].[Discount Percent].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Discount Percent].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Max Quantity]">
                    <UName>[Promotion].[Max Quantity].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Max Quantity].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion Type]">
                    <UName>[Promotion].[Promotion Type].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion Type].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Min Quantity]">
                    <UName>[Promotion].[Min Quantity].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Min Quantity].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion Category]">
                    <UName>[Promotion].[Promotion Category].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion Category].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>3</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[End Date]">
                    <UName>[Promotion].[End Date].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[End Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Start Date]">
                    <UName>[Promotion].[Start Date].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Start Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>8</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Model Lines]">
                    <UName>[Product].[Product Model Lines].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Model Lines].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Stock Level]">
                    <UName>[Product].[Stock Level].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Stock Level].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product]">
                    <UName>[Product].[Product].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>397</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Standard Cost]">
                    <UName>[Product].[Standard Cost].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Standard Cost].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>135</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Category]">
                    <UName>[Product].[Category].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Category].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Color]">
                    <UName>[Product].[Color].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Color].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Safety Stock Level]">
                    <UName>[Product].[Safety Stock Level].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Safety Stock Level].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Reorder Point]">
                    <UName>[Product].[Reorder Point].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Reorder Point].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[List Price]">
                    <UName>[Product].[List Price].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[List Price].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>121</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Size]">
                    <UName>[Product].[Size].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Size].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>19</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Size Range]">
                    <UName>[Product].[Size Range].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Size Range].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>11</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Weight]">
                    <UName>[Product].[Weight].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Weight].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>128</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Days to Manufacture]">
                    <UName>[Product].[Days to Manufacture].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Days to Manufacture].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Dealer Price]">
                    <UName>[Product].[Dealer Price].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Dealer Price].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>121</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Class]">
                    <UName>[Product].[Class].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Class].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Style]">
                    <UName>[Product].[Style].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Style].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Model Name]">
                    <UName>[Product].[Model Name].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Model Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>120</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Line]">
                    <UName>[Product].[Product Line].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Line].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Subcategory]">
                    <UName>[Product].[Subcategory].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Subcategory].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>37</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Status]">
                    <UName>[Product].[Status].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Status].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Start Date]">
                    <UName>[Product].[Start Date].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Start Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[End Date]">
                    <UName>[Product].[End Date].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[End Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>3</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Large Photo]">
                    <UName>[Product].[Large Photo].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Large Photo].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>606</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory]">
                    <UName>[Sales Territory].[Sales Territory].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Region]">
                    <UName>[Sales Territory].[Sales Territory Region].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Region].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>11</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Country]">
                    <UName>[Sales Territory].[Sales Territory Country].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Country].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Group]">
                    <UName>[Sales Territory].[Sales Territory Group].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Group].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Orders]">
                    <UName>[Sales Summary Order Details].[Sales Orders].[All]</UName>
                    <Caption>All</Caption>
                    <LName>[Sales Summary Order Details].[Sales Orders].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Carrier Tracking Number]">
                    <UName>[Sales Summary Order Details].[Carrier Tracking Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Carrier Tracking Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Customer PO Number]">
                    <UName>[Sales Summary Order Details].[Customer PO Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Customer PO Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Order Number]">
                    <UName>[Sales Summary Order Details].[Sales Order Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Sales Order Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Order Line]">
                    <UName>[Sales Summary Order Details].[Sales Order Line].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Sales Order Line].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Source Currency].[Source Currency Code]">
                    <UName>[Source Currency].[Source Currency Code].[All Source Currencies]</UName>
                    <Caption>All Source Currencies</Caption>
                    <LName>[Source Currency].[Source Currency Code].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>105</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Source Currency].[Source Currency]">
                    <UName>[Source Currency].[Source Currency].[All Source Currencies]</UName>
                    <Caption>All Source Currencies</Caption>
                    <LName>[Source Currency].[Source Currency].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>105</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Destination Currency].[Destination Currency]">
                    <UName>[Destination Currency].[Destination Currency].&amp;[US Dollar]</UName>
                    <Caption>US Dollar</Caption>
                    <LName>[Destination Currency].[Destination Currency].[Destination Currency]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Destination Currency].[Destination Currency Code]">
                    <UName>[Destination Currency].[Destination Currency Code].[All Destination Currencies]</UName>
                    <Caption>All Destination Currencies</Caption>
                    <LName>[Destination Currency].[Destination Currency Code].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>14</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Channel].[Sales Channel]">
                    <UName>[Sales Channel].[Sales Channel].[All Sales Channels]</UName>
                    <Caption>All Sales Channels</Caption>
                    <LName>[Sales Channel].[Sales Channel].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
          </Axes>
          <CellData>
            <Cell CellOrdinal="0">
              <Value xsi:type="xsd:int">61931</Value>
              <FmtValue>61,931</FmtValue>
            </Cell>
            <Cell CellOrdinal="1">
              <Value xsi:type="xsd:double">1.278745912500016E6</Value>
              <FmtValue>$1,278,745.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="2">
              <Value xsi:type="xsd:double">3.332082835000037E5</Value>
              <FmtValue>$333,208.28</FmtValue>
            </Cell>
            <Cell CellOrdinal="3">
              <Value xsi:type="xsd:double">6.375907260000077E5</Value>
              <FmtValue>$637,590.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="4">
              <Value xsi:type="xsd:double">1.272057887800016E6</Value>
              <FmtValue>$1,272,057.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="5">
              <Value xsi:type="xsd:double">1.0176462860000023E5</Value>
              <FmtValue>$101,764.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="6">
              <Value xsi:type="xsd:double">3.1803079100000483E4</Value>
              <FmtValue>$31,803.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="7">
              <Value xsi:type="xsd:int">19523</Value>
              <FmtValue>19,523</FmtValue>
            </Cell>
            <Cell CellOrdinal="8">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="9">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="10">
              <Value xsi:type="xsd:double">1.9694656456194074E1</Value>
              <FmtValue>$19.69</FmtValue>
            </Cell>
            <Cell CellOrdinal="11">
              <Value xsi:type="xsd:double">6.515688612405962E1</Value>
              <FmtValue>$65.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="12">
              <Value xsi:type="xsd:double">6.344671618000083E5</Value>
              <FmtValue>$634,467.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="13">
              <Value xsi:type="xsd:double">4.987722397581286E-1</Value>
              <FmtValue>49.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="15">
              <Value xsi:type="xsd:double">1.158424820701752E-2</Value>
              <FmtValue>1.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="16">
              <Value xsi:type="xsd:double">1.158424820701752E-2</Value>
              <FmtValue>1.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="17">
              <Value xsi:type="xsd:int">4009</Value>
              <FmtValue>4,009</FmtValue>
            </Cell>
            <Cell CellOrdinal="18">
              <Value xsi:type="xsd:double">7.849123800000052E4</Value>
              <FmtValue>$78,491.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="19">
              <Value xsi:type="xsd:double">2.455239320000022E4</Value>
              <FmtValue>$24,552.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="20">
              <Value xsi:type="xsd:double">3.513692940000054E4</Value>
              <FmtValue>$35,136.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="21">
              <Value xsi:type="xsd:double">7.849123800000052E4</Value>
              <FmtValue>$78,491.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="22">
              <Value xsi:type="xsd:double">6.279298699999981E3</Value>
              <FmtValue>$6,279.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="23">
              <Value xsi:type="xsd:double">1.9624154000000344E3</Value>
              <FmtValue>$1,962.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="24">
              <Value xsi:type="xsd:int">1571</Value>
              <FmtValue>1,571</FmtValue>
            </Cell>
            <Cell CellOrdinal="25">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="26">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="27">
              <Value xsi:type="xsd:double">1.8883690687022923E1</Value>
              <FmtValue>$18.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="28">
              <Value xsi:type="xsd:double">4.9962595798854565E1</Value>
              <FmtValue>$49.96</FmtValue>
            </Cell>
            <Cell CellOrdinal="29">
              <Value xsi:type="xsd:double">4.335430859999998E4</Value>
              <FmtValue>$43,354.31</FmtValue>
            </Cell>
            <Cell CellOrdinal="30">
              <Value xsi:type="xsd:double">5.52345837633491E-1</Value>
              <FmtValue>55.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="32">
              <Value xsi:type="xsd:double">1.2933008616329643E-2</Value>
              <FmtValue>1.29%</FmtValue>
            </Cell>
            <Cell CellOrdinal="33">
              <Value xsi:type="xsd:double">1.2933008616329643E-2</Value>
              <FmtValue>1.29%</FmtValue>
            </Cell>
            <Cell CellOrdinal="34">
              <Value xsi:type="xsd:int">4133</Value>
              <FmtValue>4,133</FmtValue>
            </Cell>
            <Cell CellOrdinal="35">
              <Value xsi:type="xsd:double">8.387708010000059E4</Value>
              <FmtValue>$83,877.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="36">
              <Value xsi:type="xsd:double">2.5473195900000286E4</Value>
              <FmtValue>$25,473.20</FmtValue>
            </Cell>
            <Cell CellOrdinal="37">
              <Value xsi:type="xsd:double">3.83948251000006E4</Value>
              <FmtValue>$38,394.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="38">
              <Value xsi:type="xsd:double">8.38540568000006E4</Value>
              <FmtValue>$83,854.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="39">
              <Value xsi:type="xsd:double">6.70832459999999E3</Value>
              <FmtValue>$6,708.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="40">
              <Value xsi:type="xsd:double">2.0964879000000355E3</Value>
              <FmtValue>$2,096.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="41">
              <Value xsi:type="xsd:int">1621</Value>
              <FmtValue>1,621</FmtValue>
            </Cell>
            <Cell CellOrdinal="42">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="43">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="44">
              <Value xsi:type="xsd:double">1.928544031572557E1</Value>
              <FmtValue>$19.29</FmtValue>
            </Cell>
            <Cell CellOrdinal="45">
              <Value xsi:type="xsd:double">5.172983146206083E1</Value>
              <FmtValue>$51.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="46">
              <Value xsi:type="xsd:double">4.5459231700000004E4</Value>
              <FmtValue>$45,459.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="47">
              <Value xsi:type="xsd:double">5.421232249791363E-1</Value>
              <FmtValue>54.21%</FmtValue>
            </Cell>
            <Cell CellOrdinal="49">
              <Value xsi:type="xsd:double">8.837171442328026E-3</Value>
              <FmtValue>0.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="50">
              <Value xsi:type="xsd:double">8.837171442328026E-3</Value>
              <FmtValue>0.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="51">
              <Value xsi:type="xsd:int">4186</Value>
              <FmtValue>4,186</FmtValue>
            </Cell>
            <Cell CellOrdinal="52">
              <Value xsi:type="xsd:double">8.668909420000086E4</Value>
              <FmtValue>$86,689.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="53">
              <Value xsi:type="xsd:double">2.6580156200000332E4</Value>
              <FmtValue>$26,580.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="54">
              <Value xsi:type="xsd:double">3.934058720000064E4</Value>
              <FmtValue>$39,340.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="55">
              <Value xsi:type="xsd:double">8.668339650000086E4</Value>
              <FmtValue>$86,683.40</FmtValue>
            </Cell>
            <Cell CellOrdinal="56">
              <Value xsi:type="xsd:double">6.934671499999995E3</Value>
              <FmtValue>$6,934.67</FmtValue>
            </Cell>
            <Cell CellOrdinal="57">
              <Value xsi:type="xsd:double">2.1672222000000365E3</Value>
              <FmtValue>$2,167.22</FmtValue>
            </Cell>
            <Cell CellOrdinal="58">
              <Value xsi:type="xsd:int">1674</Value>
              <FmtValue>1,674</FmtValue>
            </Cell>
            <Cell CellOrdinal="59">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="60">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="61">
              <Value xsi:type="xsd:double">1.9928503621670142E1</Value>
              <FmtValue>$19.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="62">
              <Value xsi:type="xsd:double">5.1782196236559656E1</Value>
              <FmtValue>$51.78</FmtValue>
            </Cell>
            <Cell CellOrdinal="63">
              <Value xsi:type="xsd:double">4.734280930000022E4</Value>
              <FmtValue>$47,342.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="64">
              <Value xsi:type="xsd:double">5.461577558281273E-1</Value>
              <FmtValue>54.62%</FmtValue>
            </Cell>
            <Cell CellOrdinal="66">
              <Value xsi:type="xsd:double">1.0357402408519312E-2</Value>
              <FmtValue>1.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="67">
              <Value xsi:type="xsd:double">1.0357402408519312E-2</Value>
              <FmtValue>1.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="68">
              <Value xsi:type="xsd:int">5106</Value>
              <FmtValue>5,106</FmtValue>
            </Cell>
            <Cell CellOrdinal="69">
              <Value xsi:type="xsd:double">1.0211755460000111E5</Value>
              <FmtValue>$102,117.55</FmtValue>
            </Cell>
            <Cell CellOrdinal="70">
              <Value xsi:type="xsd:double">2.7999770400000332E4</Value>
              <FmtValue>$27,999.77</FmtValue>
            </Cell>
            <Cell CellOrdinal="71">
              <Value xsi:type="xsd:double">4.9107745000000774E4</Value>
              <FmtValue>$49,107.75</FmtValue>
            </Cell>
            <Cell CellOrdinal="72">
              <Value xsi:type="xsd:double">1.0167032570000105E5</Value>
              <FmtValue>$101,670.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="73">
              <Value xsi:type="xsd:double">8.133625800000027E3</Value>
              <FmtValue>$8,133.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="74">
              <Value xsi:type="xsd:double">2.541905800000038E3</Value>
              <FmtValue>$2,541.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="75">
              <Value xsi:type="xsd:int">1719</Value>
              <FmtValue>1,719</FmtValue>
            </Cell>
            <Cell CellOrdinal="76">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="77">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="78">
              <Value xsi:type="xsd:double">1.9304786908386425E1</Value>
              <FmtValue>$19.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="79">
              <Value xsi:type="xsd:double">5.9145041128563726E1</Value>
              <FmtValue>$59.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="80">
              <Value xsi:type="xsd:double">5.2562580700000275E4</Value>
              <FmtValue>$52,562.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="81">
              <Value xsi:type="xsd:double">5.169903837536318E-1</Value>
              <FmtValue>51.70%</FmtValue>
            </Cell>
            <Cell CellOrdinal="83">
              <Value xsi:type="xsd:double">1.3149897666316705E-2</Value>
              <FmtValue>1.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="84">
              <Value xsi:type="xsd:double">1.3149897666316705E-2</Value>
              <FmtValue>1.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="85">
              <Value xsi:type="xsd:int">6091</Value>
              <FmtValue>6,091</FmtValue>
            </Cell>
            <Cell CellOrdinal="86">
              <Value xsi:type="xsd:double">1.308690574000023E5</Value>
              <FmtValue>$130,869.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="87">
              <Value xsi:type="xsd:double">3.4040667100000464E4</Value>
              <FmtValue>$34,040.67</FmtValue>
            </Cell>
            <Cell CellOrdinal="88">
              <Value xsi:type="xsd:double">6.4615463100000736E4</Value>
              <FmtValue>$64,615.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="89">
              <Value xsi:type="xsd:double">1.3057750940000231E5</Value>
              <FmtValue>$130,577.51</FmtValue>
            </Cell>
            <Cell CellOrdinal="90">
              <Value xsi:type="xsd:double">1.0446200800000011E4</Value>
              <FmtValue>$10,446.20</FmtValue>
            </Cell>
            <Cell CellOrdinal="91">
              <Value xsi:type="xsd:double">3.2645949000000532E3</Value>
              <FmtValue>$3,264.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="92">
              <Value xsi:type="xsd:int">1952</Value>
              <FmtValue>1,952</FmtValue>
            </Cell>
            <Cell CellOrdinal="93">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="94">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="95">
              <Value xsi:type="xsd:double">2.057933442298184E1</Value>
              <FmtValue>$20.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="96">
              <Value xsi:type="xsd:double">6.689421588114872E1</Value>
              <FmtValue>$66.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="97">
              <Value xsi:type="xsd:double">6.596204630000157E4</Value>
              <FmtValue>$65,962.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="98">
              <Value xsi:type="xsd:double">5.051562600871633E-1</Value>
              <FmtValue>50.52%</FmtValue>
            </Cell>
            <Cell CellOrdinal="100">
              <Value xsi:type="xsd:double">1.1276327278388445E-2</Value>
              <FmtValue>1.13%</FmtValue>
            </Cell>
            <Cell CellOrdinal="101">
              <Value xsi:type="xsd:double">1.1276327278388445E-2</Value>
              <FmtValue>1.13%</FmtValue>
            </Cell>
            <Cell CellOrdinal="102">
              <Value xsi:type="xsd:int">5782</Value>
              <FmtValue>5,782</FmtValue>
            </Cell>
            <Cell CellOrdinal="103">
              <Value xsi:type="xsd:double">1.1897936210000154E5</Value>
              <FmtValue>$118,979.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="104">
              <Value xsi:type="xsd:double">3.091493140000048E4</Value>
              <FmtValue>$30,914.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="105">
              <Value xsi:type="xsd:double">5.880935850000073E4</Value>
              <FmtValue>$58,809.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="106">
              <Value xsi:type="xsd:double">1.1868037840000156E5</Value>
              <FmtValue>$118,680.38</FmtValue>
            </Cell>
            <Cell CellOrdinal="107">
              <Value xsi:type="xsd:double">9.494430000000044E3</Value>
              <FmtValue>$9,494.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="108">
              <Value xsi:type="xsd:double">2.967164700000046E3</Value>
              <FmtValue>$2,967.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="109">
              <Value xsi:type="xsd:int">1844</Value>
              <FmtValue>1,844</FmtValue>
            </Cell>
            <Cell CellOrdinal="110">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="111">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="112">
              <Value xsi:type="xsd:double">1.955296580310894E1</Value>
              <FmtValue>$19.55</FmtValue>
            </Cell>
            <Cell CellOrdinal="113">
              <Value xsi:type="xsd:double">6.436029197397047E1</Value>
              <FmtValue>$64.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="114">
              <Value xsi:type="xsd:double">5.987101990000083E4</Value>
              <FmtValue>$59,871.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="115">
              <Value xsi:type="xsd:double">5.044727755940492E-1</Value>
              <FmtValue>50.45%</FmtValue>
            </Cell>
            <Cell CellOrdinal="117">
              <Value xsi:type="xsd:double">1.2380491730774935E-2</Value>
              <FmtValue>1.24%</FmtValue>
            </Cell>
            <Cell CellOrdinal="118">
              <Value xsi:type="xsd:double">1.2380491730774935E-2</Value>
              <FmtValue>1.24%</FmtValue>
            </Cell>
            <Cell CellOrdinal="119">
              <Value xsi:type="xsd:int">4911</Value>
              <FmtValue>4,911</FmtValue>
            </Cell>
            <Cell CellOrdinal="120">
              <Value xsi:type="xsd:double">9.44542341E4</Value>
              <FmtValue>$94,454.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="121">
              <Value xsi:type="xsd:double">2.3280379099999903E4</Value>
              <FmtValue>$23,280.38</FmtValue>
            </Cell>
            <Cell CellOrdinal="122">
              <Value xsi:type="xsd:double">5.143729600000018E4</Value>
              <FmtValue>$51,437.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="123">
              <Value xsi:type="xsd:double">9.153785850000013E4</Value>
              <FmtValue>$91,537.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="124">
              <Value xsi:type="xsd:double">7.32303029999996E3</Value>
              <FmtValue>$7,323.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="125">
              <Value xsi:type="xsd:double">2.288556900000021E3</Value>
              <FmtValue>$2,288.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="126">
              <Value xsi:type="xsd:int">1344</Value>
              <FmtValue>1,344</FmtValue>
            </Cell>
            <Cell CellOrdinal="127">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="128">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="129">
              <Value xsi:type="xsd:double">1.92639100866553E1</Value>
              <FmtValue>$19.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="130">
              <Value xsi:type="xsd:double">6.810852566964296E1</Value>
              <FmtValue>$68.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="131">
              <Value xsi:type="xsd:double">4.0100562499999956E4</Value>
              <FmtValue>$40,100.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="132">
              <Value xsi:type="xsd:double">4.3807625781413595E-1</Value>
              <FmtValue>43.81%</FmtValue>
            </Cell>
            <Cell CellOrdinal="134">
              <Value xsi:type="xsd:double">1.2270603200486301E-2</Value>
              <FmtValue>1.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="135">
              <Value xsi:type="xsd:double">1.2270603200486301E-2</Value>
              <FmtValue>1.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="136">
              <Value xsi:type="xsd:int">6167</Value>
              <FmtValue>6,167</FmtValue>
            </Cell>
            <Cell CellOrdinal="137">
              <Value xsi:type="xsd:double">1.2935175920000227E5</Value>
              <FmtValue>$129,351.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="138">
              <Value xsi:type="xsd:double">2.927191790000037E4</Value>
              <FmtValue>$29,271.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="139">
              <Value xsi:type="xsd:double">6.960403490000065E4</Value>
              <FmtValue>$69,604.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="140">
              <Value xsi:type="xsd:double">1.286070443000022E5</Value>
              <FmtValue>$128,607.04</FmtValue>
            </Cell>
            <Cell CellOrdinal="141">
              <Value xsi:type="xsd:double">1.0288562700000055E4</Value>
              <FmtValue>$10,288.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="142">
              <Value xsi:type="xsd:double">3.2153009000000456E3</Value>
              <FmtValue>$3,215.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="143">
              <Value xsi:type="xsd:int">1482</Value>
              <FmtValue>1,482</FmtValue>
            </Cell>
            <Cell CellOrdinal="144">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="145">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="146">
              <Value xsi:type="xsd:double">1.9882416740478326E1</Value>
              <FmtValue>$19.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="147">
              <Value xsi:type="xsd:double">8.677938211875992E1</Value>
              <FmtValue>$86.78</FmtValue>
            </Cell>
            <Cell CellOrdinal="148">
              <Value xsi:type="xsd:double">5.900300940000155E4</Value>
              <FmtValue>$59,003.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="149">
              <Value xsi:type="xsd:double">4.5878520668249695E-1</Value>
              <FmtValue>45.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="151">
              <Value xsi:type="xsd:double">1.1429525319851067E-2</Value>
              <FmtValue>1.14%</FmtValue>
            </Cell>
            <Cell CellOrdinal="152">
              <Value xsi:type="xsd:double">1.1429525319851067E-2</Value>
              <FmtValue>1.14%</FmtValue>
            </Cell>
            <Cell CellOrdinal="153">
              <Value xsi:type="xsd:int">5800</Value>
              <FmtValue>5,800</FmtValue>
            </Cell>
            <Cell CellOrdinal="154">
              <Value xsi:type="xsd:double">1.2642585030000248E5</Value>
              <FmtValue>$126,425.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="155">
              <Value xsi:type="xsd:double">2.7631528300000362E4</Value>
              <FmtValue>$27,631.53</FmtValue>
            </Cell>
            <Cell CellOrdinal="156">
              <Value xsi:type="xsd:double">6.778843390000067E4</Value>
              <FmtValue>$67,788.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="157">
              <Value xsi:type="xsd:double">1.2548515060000241E5</Value>
              <FmtValue>$125,485.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="158">
              <Value xsi:type="xsd:double">1.0038811100000062E4</Value>
              <FmtValue>$10,038.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="159">
              <Value xsi:type="xsd:double">3.137250100000046E3</Value>
              <FmtValue>$3,137.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="160">
              <Value xsi:type="xsd:int">1467</Value>
              <FmtValue>1,467</FmtValue>
            </Cell>
            <Cell CellOrdinal="161">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="162">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="163">
              <Value xsi:type="xsd:double">2.0226630536494074E1</Value>
              <FmtValue>$20.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="164">
              <Value xsi:type="xsd:double">8.553861663258514E1</Value>
              <FmtValue>$85.54</FmtValue>
            </Cell>
            <Cell CellOrdinal="165">
              <Value xsi:type="xsd:double">5.7696716700001736E4</Value>
              <FmtValue>$57,696.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="166">
              <Value xsi:type="xsd:double">4.5978919755944913E-1</Value>
              <FmtValue>45.98%</FmtValue>
            </Cell>
            <Cell CellOrdinal="168">
              <Value xsi:type="xsd:double">1.2632523275972177E-2</Value>
              <FmtValue>1.26%</FmtValue>
            </Cell>
            <Cell CellOrdinal="169">
              <Value xsi:type="xsd:double">1.2632523275972177E-2</Value>
              <FmtValue>1.26%</FmtValue>
            </Cell>
            <Cell CellOrdinal="170">
              <Value xsi:type="xsd:int">4664</Value>
              <FmtValue>4,664</FmtValue>
            </Cell>
            <Cell CellOrdinal="171">
              <Value xsi:type="xsd:double">9.499382970000095E4</Value>
              <FmtValue>$94,993.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="172">
              <Value xsi:type="xsd:double">2.486094400000022E4</Value>
              <FmtValue>$24,860.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="173">
              <Value xsi:type="xsd:double">4.6472736700000736E4</Value>
              <FmtValue>$46,472.74</FmtValue>
            </Cell>
            <Cell CellOrdinal="174">
              <Value xsi:type="xsd:double">9.468758350000095E4</Value>
              <FmtValue>$94,687.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="175">
              <Value xsi:type="xsd:double">7.575006100000007E3</Value>
              <FmtValue>$7,575.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="176">
              <Value xsi:type="xsd:double">2.367315900000038E3</Value>
              <FmtValue>$2,367.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="177">
              <Value xsi:type="xsd:int">1498</Value>
              <FmtValue>1,498</FmtValue>
            </Cell>
            <Cell CellOrdinal="178">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="179">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="180">
              <Value xsi:type="xsd:double">1.9448146601327867E1</Value>
              <FmtValue>$19.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="181">
              <Value xsi:type="xsd:double">6.3209334779706914E1</Value>
              <FmtValue>$63.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="182">
              <Value xsi:type="xsd:double">4.821484680000022E4</Value>
              <FmtValue>$48,214.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="183">
              <Value xsi:type="xsd:double">5.091992531417779E-1</Value>
              <FmtValue>50.92%</FmtValue>
            </Cell>
            <Cell CellOrdinal="185">
              <Value xsi:type="xsd:double">1.3647361607923203E-2</Value>
              <FmtValue>1.36%</FmtValue>
            </Cell>
            <Cell CellOrdinal="186">
              <Value xsi:type="xsd:double">1.3647361607923203E-2</Value>
              <FmtValue>1.36%</FmtValue>
            </Cell>
            <Cell CellOrdinal="187">
              <Value xsi:type="xsd:int">5357</Value>
              <FmtValue>5,357</FmtValue>
            </Cell>
            <Cell CellOrdinal="188">
              <Value xsi:type="xsd:double">1.1363819050000171E5</Value>
              <FmtValue>$113,638.19</FmtValue>
            </Cell>
            <Cell CellOrdinal="189">
              <Value xsi:type="xsd:double">2.7735914300000367E4</Value>
              <FmtValue>$27,735.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="190">
              <Value xsi:type="xsd:double">5.8255437300000616E4</Value>
              <FmtValue>$58,255.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="191">
              <Value xsi:type="xsd:double">1.1325114030000168E5</Value>
              <FmtValue>$113,251.14</FmtValue>
            </Cell>
            <Cell CellOrdinal="192">
              <Value xsi:type="xsd:double">9.060091100000061E3</Value>
              <FmtValue>$9,060.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="193">
              <Value xsi:type="xsd:double">2.8314055000000394E3</Value>
              <FmtValue>$2,831.41</FmtValue>
            </Cell>
            <Cell CellOrdinal="194">
              <Value xsi:type="xsd:int">1553</Value>
              <FmtValue>1,553</FmtValue>
            </Cell>
            <Cell CellOrdinal="195">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="196">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="197">
              <Value xsi:type="xsd:double">2.003372403875265E1</Value>
              <FmtValue>$20.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="198">
              <Value xsi:type="xsd:double">7.292410837089612E1</Value>
              <FmtValue>$72.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="199">
              <Value xsi:type="xsd:double">5.499570300000107E4</Value>
              <FmtValue>$54,995.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="200">
              <Value xsi:type="xsd:double">4.8560838199348577E-1</Value>
              <FmtValue>48.56%</FmtValue>
            </Cell>
            <Cell CellOrdinal="202">
              <Value xsi:type="xsd:double">1.0354689954481853E-2</Value>
              <FmtValue>1.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="203">
              <Value xsi:type="xsd:double">1.0354689954481853E-2</Value>
              <FmtValue>1.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="204">
              <Value xsi:type="xsd:int">5725</Value>
              <FmtValue>5,725</FmtValue>
            </Cell>
            <Cell CellOrdinal="205">
              <Value xsi:type="xsd:double">1.1885866230000168E5</Value>
              <FmtValue>$118,858.66</FmtValue>
            </Cell>
            <Cell CellOrdinal="206">
              <Value xsi:type="xsd:double">3.086648570000037E4</Value>
              <FmtValue>$30,866.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="207">
              <Value xsi:type="xsd:double">5.862787890000084E4</Value>
              <FmtValue>$58,627.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="208">
              <Value xsi:type="xsd:double">1.1853220580000171E5</Value>
              <FmtValue>$118,532.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="209">
              <Value xsi:type="xsd:double">9.482575900000049E3</Value>
              <FmtValue>$9,482.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="210">
              <Value xsi:type="xsd:double">2.96345890000005E3</Value>
              <FmtValue>$2,963.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="211">
              <Value xsi:type="xsd:int">1798</Value>
              <FmtValue>1,798</FmtValue>
            </Cell>
            <Cell CellOrdinal="212">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="213">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="214">
              <Value xsi:type="xsd:double">1.9738230956113E1</Value>
              <FmtValue>$19.74</FmtValue>
            </Cell>
            <Cell CellOrdinal="215">
              <Value xsi:type="xsd:double">6.592447486095757E1</Value>
              <FmtValue>$65.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="216">
              <Value xsi:type="xsd:double">5.990432690000087E4</Value>
              <FmtValue>$59,904.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="217">
              <Value xsi:type="xsd:double">5.053843931756141E-1</Value>
              <FmtValue>50.54%</FmtValue>
            </Cell>
            <Cell CellOrdinal="219">
              <Value xsi:type="xsd:double">1.1327904688104371E-2</Value>
              <FmtValue>1.13%</FmtValue>
            </Cell>
            <Cell CellOrdinal="220">
              <Value xsi:type="xsd:double">1.1327904688104371E-2</Value>
              <FmtValue>1.13%</FmtValue>
            </Cell>
            <Cell CellOrdinal="221">
              <Value xsi:type="xsd:int">90220</Value>
              <FmtValue>90,220</FmtValue>
            </Cell>
            <Cell CellOrdinal="222">
              <Value xsi:type="xsd:double">9.511516683990124E7</Value>
              <FmtValue>$95,115,166.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="223">
              <Value xsi:type="xsd:double">3.8851410537299976E7</Value>
              <FmtValue>$38,851,410.54</FmtValue>
            </Cell>
            <Cell CellOrdinal="224">
              <Value xsi:type="xsd:double">8.410542959930005E7</Value>
              <FmtValue>$84,105,429.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="225">
              <Value xsi:type="xsd:double">9.462052620770125E7</Value>
              <FmtValue>$94,620,526.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="226">
              <Value xsi:type="xsd:double">7.569642020899961E6</Value>
              <FmtValue>$7,569,642.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="227">
              <Value xsi:type="xsd:double">2.365514355900008E6</Value>
              <FmtValue>$2,365,514.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="228">
              <Value xsi:type="xsd:int">18358</Value>
              <FmtValue>18,358</FmtValue>
            </Cell>
            <Cell CellOrdinal="229">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="230">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="231">
              <Value xsi:type="xsd:double">1.2550806949631355E3</Value>
              <FmtValue>$1,255.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="232">
              <Value xsi:type="xsd:double">5.15418488984101E3</Value>
              <FmtValue>$5,154.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="233">
              <Value xsi:type="xsd:double">1.0515096608401194E7</Value>
              <FmtValue>$10,515,096.61</FmtValue>
            </Cell>
            <Cell CellOrdinal="234">
              <Value xsi:type="xsd:double">1.1112912842314505E-1</Value>
              <FmtValue>11.11%</FmtValue>
            </Cell>
            <Cell CellOrdinal="236">
              <Value xsi:type="xsd:double">8.616806448677434E-1</Value>
              <FmtValue>86.17%</FmtValue>
            </Cell>
            <Cell CellOrdinal="237">
              <Value xsi:type="xsd:double">8.616806448677434E-1</Value>
              <FmtValue>86.17%</FmtValue>
            </Cell>
            <Cell CellOrdinal="238">
              <Value xsi:type="xsd:int">5030</Value>
              <FmtValue>5,030</FmtValue>
            </Cell>
            <Cell CellOrdinal="239">
              <Value xsi:type="xsd:double">5.604506835900047E6</Value>
              <FmtValue>$5,604,506.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="240">
              <Value xsi:type="xsd:double">2.528077206600002E6</Value>
              <FmtValue>$2,528,077.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="241">
              <Value xsi:type="xsd:double">4.6368575231000045E6</Value>
              <FmtValue>$4,636,857.52</FmtValue>
            </Cell>
            <Cell CellOrdinal="242">
              <Value xsi:type="xsd:double">5.602193746400048E6</Value>
              <FmtValue>$5,602,193.75</FmtValue>
            </Cell>
            <Cell CellOrdinal="243">
              <Value xsi:type="xsd:double">4.481754944E5</Value>
              <FmtValue>$448,175.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="244">
              <Value xsi:type="xsd:double">1.400549268999995E5</Value>
              <FmtValue>$140,054.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="245">
              <Value xsi:type="xsd:int">1390</Value>
              <FmtValue>1,390</FmtValue>
            </Cell>
            <Cell CellOrdinal="246">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="247">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="248">
              <Value xsi:type="xsd:double">1.3462123162078337E3</Value>
              <FmtValue>$1,346.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="249">
              <Value xsi:type="xsd:double">4.030355213237445E3</Value>
              <FmtValue>$4,030.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="250">
              <Value xsi:type="xsd:double">9.653362233000435E5</Value>
              <FmtValue>$965,336.22</FmtValue>
            </Cell>
            <Cell CellOrdinal="251">
              <Value xsi:type="xsd:double">1.723139660995062E-1</Value>
              <FmtValue>17.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="253">
              <Value xsi:type="xsd:double">9.230739868383703E-1</Value>
              <FmtValue>92.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="254">
              <Value xsi:type="xsd:double">9.230739868383703E-1</Value>
              <FmtValue>92.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="255">
              <Value xsi:type="xsd:int">8061</Value>
              <FmtValue>8,061</FmtValue>
            </Cell>
            <Cell CellOrdinal="256">
              <Value xsi:type="xsd:double">8.744840333400115E6</Value>
              <FmtValue>$8,744,840.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="257">
              <Value xsi:type="xsd:double">3.7158861785000004E6</Value>
              <FmtValue>$3,715,886.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="258">
              <Value xsi:type="xsd:double">7.677423651000002E6</Value>
              <FmtValue>$7,677,423.65</FmtValue>
            </Cell>
            <Cell CellOrdinal="259">
              <Value xsi:type="xsd:double">8.741352104600114E6</Value>
              <FmtValue>$8,741,352.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="260">
              <Value xsi:type="xsd:double">6.993081577999978E5</Value>
              <FmtValue>$699,308.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="261">
              <Value xsi:type="xsd:double">2.1853391630000097E5</Value>
              <FmtValue>$218,533.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="262">
              <Value xsi:type="xsd:int">1620</Value>
              <FmtValue>1,620</FmtValue>
            </Cell>
            <Cell CellOrdinal="263">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="264">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="265">
              <Value xsi:type="xsd:double">1.248380459185836E3</Value>
              <FmtValue>$1,248.38</FmtValue>
            </Cell>
            <Cell CellOrdinal="266">
              <Value xsi:type="xsd:double">5.395896360864268E3</Value>
              <FmtValue>$5,395.90</FmtValue>
            </Cell>
            <Cell CellOrdinal="267">
              <Value xsi:type="xsd:double">1.0639284536001123E6</Value>
              <FmtValue>$1,063,928.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="268">
              <Value xsi:type="xsd:double">1.2171211511320115E-1</Value>
              <FmtValue>12.17%</FmtValue>
            </Cell>
            <Cell CellOrdinal="270">
              <Value xsi:type="xsd:double">9.212294566779454E-1</Value>
              <FmtValue>92.12%</FmtValue>
            </Cell>
            <Cell CellOrdinal="271">
              <Value xsi:type="xsd:double">9.212294566779454E-1</Value>
              <FmtValue>92.12%</FmtValue>
            </Cell>
            <Cell CellOrdinal="272">
              <Value xsi:type="xsd:int">6922</Value>
              <FmtValue>6,922</FmtValue>
            </Cell>
            <Cell CellOrdinal="273">
              <Value xsi:type="xsd:double">7.6898874692001045E6</Value>
              <FmtValue>$7,689,887.47</FmtValue>
            </Cell>
            <Cell CellOrdinal="274">
              <Value xsi:type="xsd:double">3.394189151799996E6</Value>
              <FmtValue>$3,394,189.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="275">
              <Value xsi:type="xsd:double">6.602443595299995E6</Value>
              <FmtValue>$6,602,443.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="276">
              <Value xsi:type="xsd:double">7.687470114300106E6</Value>
              <FmtValue>$7,687,470.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="277">
              <Value xsi:type="xsd:double">6.149976018999971E5</Value>
              <FmtValue>$614,997.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="278">
              <Value xsi:type="xsd:double">1.9218686090000128E5</Value>
              <FmtValue>$192,186.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="279">
              <Value xsi:type="xsd:int">1635</Value>
              <FmtValue>1,635</FmtValue>
            </Cell>
            <Cell CellOrdinal="280">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="281">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="282">
              <Value xsi:type="xsd:double">1.2883008531322591E3</Value>
              <FmtValue>$1,288.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="283">
              <Value xsi:type="xsd:double">4.701816583669789E3</Value>
              <FmtValue>$4,701.82</FmtValue>
            </Cell>
            <Cell CellOrdinal="284">
              <Value xsi:type="xsd:double">1.0850265190001111E6</Value>
              <FmtValue>$1,085,026.52</FmtValue>
            </Cell>
            <Cell CellOrdinal="285">
              <Value xsi:type="xsd:double">1.4114220970846608E-1</Value>
              <FmtValue>14.11%</FmtValue>
            </Cell>
            <Cell CellOrdinal="287">
              <Value xsi:type="xsd:double">9.185406282190541E-1</Value>
              <FmtValue>91.85%</FmtValue>
            </Cell>
            <Cell CellOrdinal="288">
              <Value xsi:type="xsd:double">9.185406282190541E-1</Value>
              <FmtValue>91.85%</FmtValue>
            </Cell>
            <Cell CellOrdinal="289">
              <Value xsi:type="xsd:int">6207</Value>
              <FmtValue>6,207</FmtValue>
            </Cell>
            <Cell CellOrdinal="290">
              <Value xsi:type="xsd:double">6.801900205300098E6</Value>
              <FmtValue>$6,801,900.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="291">
              <Value xsi:type="xsd:double">2.8493968184999972E6</Value>
              <FmtValue>$2,849,396.82</FmtValue>
            </Cell>
            <Cell CellOrdinal="292">
              <Value xsi:type="xsd:double">5.675780847999999E6</Value>
              <FmtValue>$5,675,780.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="293">
              <Value xsi:type="xsd:double">6.793351276300097E6</Value>
              <FmtValue>$6,793,351.28</FmtValue>
            </Cell>
            <Cell CellOrdinal="294">
              <Value xsi:type="xsd:double">5.434680999000003E5</Value>
              <FmtValue>$543,468.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="295">
              <Value xsi:type="xsd:double">1.6983387860000035E5</Value>
              <FmtValue>$169,833.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="296">
              <Value xsi:type="xsd:int">1641</Value>
              <FmtValue>1,641</FmtValue>
            </Cell>
            <Cell CellOrdinal="297">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="298">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="299">
              <Value xsi:type="xsd:double">1.3538076840356304E3</Value>
              <FmtValue>$1,353.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="300">
              <Value xsi:type="xsd:double">4.1397631177940875E3</Value>
              <FmtValue>$4,139.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="301">
              <Value xsi:type="xsd:double">1.1175704283000976E6</Value>
              <FmtValue>$1,117,570.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="302">
              <Value xsi:type="xsd:double">1.6450944207742582E-1</Value>
              <FmtValue>16.45%</FmtValue>
            </Cell>
            <Cell CellOrdinal="304">
              <Value xsi:type="xsd:double">8.786425486457091E-1</Value>
              <FmtValue>87.86%</FmtValue>
            </Cell>
            <Cell CellOrdinal="305">
              <Value xsi:type="xsd:double">8.786425486457091E-1</Value>
              <FmtValue>87.86%</FmtValue>
            </Cell>
            <Cell CellOrdinal="306">
              <Value xsi:type="xsd:int">9367</Value>
              <FmtValue>9,367</FmtValue>
            </Cell>
            <Cell CellOrdinal="307">
              <Value xsi:type="xsd:double">1.0115199500000171E7</Value>
              <FmtValue>$10,115,199.50</FmtValue>
            </Cell>
            <Cell CellOrdinal="308">
              <Value xsi:type="xsd:double">4.131695421999993E6</Value>
              <FmtValue>$4,131,695.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="309">
              <Value xsi:type="xsd:double">8.8401810086E6</Value>
              <FmtValue>$8,840,181.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="310">
              <Value xsi:type="xsd:double">1.0100476028000172E7</Value>
              <FmtValue>$10,100,476.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="311">
              <Value xsi:type="xsd:double">8.080380744999931E5</Value>
              <FmtValue>$808,038.07</FmtValue>
            </Cell>
            <Cell CellOrdinal="312">
              <Value xsi:type="xsd:double">2.5251203150000138E5</Value>
              <FmtValue>$252,512.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="313">
              <Value xsi:type="xsd:int">2015</Value>
              <FmtValue>2,015</FmtValue>
            </Cell>
            <Cell CellOrdinal="314">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="315">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="316">
              <Value xsi:type="xsd:double">1.2493189684357646E3</Value>
              <FmtValue>$1,249.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="317">
              <Value xsi:type="xsd:double">5.012643190074527E3</Value>
              <FmtValue>$5,012.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="318">
              <Value xsi:type="xsd:double">1.260295019400172E6</Value>
              <FmtValue>$1,260,295.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="319">
              <Value xsi:type="xsd:double">1.2477580422016031E-1</Value>
              <FmtValue>12.48%</FmtValue>
            </Cell>
            <Cell CellOrdinal="321">
              <Value xsi:type="xsd:double">8.722503123439488E-1</Value>
              <FmtValue>87.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="322">
              <Value xsi:type="xsd:double">8.722503123439488E-1</Value>
              <FmtValue>87.23%</FmtValue>
            </Cell>
            <Cell CellOrdinal="323">
              <Value xsi:type="xsd:int">8005</Value>
              <FmtValue>8,005</FmtValue>
            </Cell>
            <Cell CellOrdinal="324">
              <Value xsi:type="xsd:double">8.336578886400139E6</Value>
              <FmtValue>$8,336,578.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="325">
              <Value xsi:type="xsd:double">3.8145481252999925E6</Value>
              <FmtValue>$3,814,548.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="326">
              <Value xsi:type="xsd:double">7.585842270300001E6</Value>
              <FmtValue>$7,585,842.27</FmtValue>
            </Cell>
            <Cell CellOrdinal="327">
              <Value xsi:type="xsd:double">8.187712617900138E6</Value>
              <FmtValue>$8,187,712.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="328">
              <Value xsi:type="xsd:double">6.550170058999933E5</Value>
              <FmtValue>$655,017.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="329">
              <Value xsi:type="xsd:double">2.0469293750000198E5</Value>
              <FmtValue>$204,692.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="330">
              <Value xsi:type="xsd:int">2006</Value>
              <FmtValue>2,006</FmtValue>
            </Cell>
            <Cell CellOrdinal="331">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="332">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="333">
              <Value xsi:type="xsd:double">1.2540994624745058E3</Value>
              <FmtValue>$1,254.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="334">
              <Value xsi:type="xsd:double">4.0816114745264895E3</Value>
              <FmtValue>$4,081.61</FmtValue>
            </Cell>
            <Cell CellOrdinal="335">
              <Value xsi:type="xsd:double">6.018703476001369E5</Value>
              <FmtValue>$601,870.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="336">
              <Value xsi:type="xsd:double">7.350897322462395E-2</Value>
              <FmtValue>7.35%</FmtValue>
            </Cell>
            <Cell CellOrdinal="338">
              <Value xsi:type="xsd:double">8.541252541192852E-1</Value>
              <FmtValue>85.41%</FmtValue>
            </Cell>
            <Cell CellOrdinal="339">
              <Value xsi:type="xsd:double">8.541252541192852E-1</Value>
              <FmtValue>85.41%</FmtValue>
            </Cell>
            <Cell CellOrdinal="340">
              <Value xsi:type="xsd:int">6206</Value>
              <FmtValue>6,206</FmtValue>
            </Cell>
            <Cell CellOrdinal="341">
              <Value xsi:type="xsd:double">6.091857417300074E6</Value>
              <FmtValue>$6,091,857.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="342">
              <Value xsi:type="xsd:double">2.299322950500002E6</Value>
              <FmtValue>$2,299,322.95</FmtValue>
            </Cell>
            <Cell CellOrdinal="343">
              <Value xsi:type="xsd:double">5.49663475710002E6</Value>
              <FmtValue>$5,496,634.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="344">
              <Value xsi:type="xsd:double">6.018342166800067E6</Value>
              <FmtValue>$6,018,342.17</FmtValue>
            </Cell>
            <Cell CellOrdinal="345">
              <Value xsi:type="xsd:double">4.8146737079999875E5</Value>
              <FmtValue>$481,467.37</FmtValue>
            </Cell>
            <Cell CellOrdinal="346">
              <Value xsi:type="xsd:double">1.5045862109999993E5</Value>
              <FmtValue>$150,458.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="347">
              <Value xsi:type="xsd:int">1088</Value>
              <FmtValue>1,088</FmtValue>
            </Cell>
            <Cell CellOrdinal="348">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="349">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="350">
              <Value xsi:type="xsd:double">1.2896326363013693E3</Value>
              <FmtValue>$1,289.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="351">
              <Value xsi:type="xsd:double">5.531564491544179E3</Value>
              <FmtValue>$5,531.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="352">
              <Value xsi:type="xsd:double">5.217074097000472E5</Value>
              <FmtValue>$521,707.41</FmtValue>
            </Cell>
            <Cell CellOrdinal="353">
              <Value xsi:type="xsd:double">8.668623272668416E-2</Value>
              <FmtValue>8.67%</FmtValue>
            </Cell>
            <Cell CellOrdinal="355">
              <Value xsi:type="xsd:double">8.067556950063285E-1</Value>
              <FmtValue>80.68%</FmtValue>
            </Cell>
            <Cell CellOrdinal="356">
              <Value xsi:type="xsd:double">8.067556950063285E-1</Value>
              <FmtValue>80.68%</FmtValue>
            </Cell>
            <Cell CellOrdinal="357">
              <Value xsi:type="xsd:int">9234</Value>
              <FmtValue>9,234</FmtValue>
            </Cell>
            <Cell CellOrdinal="358">
              <Value xsi:type="xsd:double">9.124105037900092E6</Value>
              <FmtValue>$9,124,105.04</FmtValue>
            </Cell>
            <Cell CellOrdinal="359">
              <Value xsi:type="xsd:double">3.356940640399998E6</Value>
              <FmtValue>$3,356,940.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="360">
              <Value xsi:type="xsd:double">8.542726621300026E6</Value>
              <FmtValue>$8,542,726.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="361">
              <Value xsi:type="xsd:double">9.01926388130009E6</Value>
              <FmtValue>$9,019,263.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="362">
              <Value xsi:type="xsd:double">7.215411026999948E5</Value>
              <FmtValue>$721,541.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="363">
              <Value xsi:type="xsd:double">2.2548168739999935E5</Value>
              <FmtValue>$225,481.69</FmtValue>
            </Cell>
            <Cell CellOrdinal="364">
              <Value xsi:type="xsd:int">1262</Value>
              <FmtValue>1,262</FmtValue>
            </Cell>
            <Cell CellOrdinal="365">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="366">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="367">
              <Value xsi:type="xsd:double">1.1645499877082147E3</Value>
              <FmtValue>$1,164.55</FmtValue>
            </Cell>
            <Cell CellOrdinal="368">
              <Value xsi:type="xsd:double">7.146801807686284E3</Value>
              <FmtValue>$7,146.80</FmtValue>
            </Cell>
            <Cell CellOrdinal="369">
              <Value xsi:type="xsd:double">4.765372600000631E5</Value>
              <FmtValue>$476,537.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="370">
              <Value xsi:type="xsd:double">5.2835493702327756E-2</Value>
              <FmtValue>5.28%</FmtValue>
            </Cell>
            <Cell CellOrdinal="372">
              <Value xsi:type="xsd:double">8.015572199705379E-1</Value>
              <FmtValue>80.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="373">
              <Value xsi:type="xsd:double">8.015572199705379E-1</Value>
              <FmtValue>80.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="374">
              <Value xsi:type="xsd:int">8089</Value>
              <FmtValue>8,089</FmtValue>
            </Cell>
            <Cell CellOrdinal="375">
              <Value xsi:type="xsd:double">7.9850850036001E6</Value>
              <FmtValue>$7,985,085.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="376">
              <Value xsi:type="xsd:double">2.9639489906000015E6</Value>
              <FmtValue>$2,963,948.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="377">
              <Value xsi:type="xsd:double">7.428347623200012E6</Value>
              <FmtValue>$7,428,347.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="378">
              <Value xsi:type="xsd:double">7.875706350700096E6</Value>
              <FmtValue>$7,875,706.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="379">
              <Value xsi:type="xsd:double">6.30056499199996E5</Value>
              <FmtValue>$630,056.50</FmtValue>
            </Cell>
            <Cell CellOrdinal="380">
              <Value xsi:type="xsd:double">1.9689273660000108E5</Value>
              <FmtValue>$196,892.74</FmtValue>
            </Cell>
            <Cell CellOrdinal="381">
              <Value xsi:type="xsd:int">1208</Value>
              <FmtValue>1,208</FmtValue>
            </Cell>
            <Cell CellOrdinal="382">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="383">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="384">
              <Value xsi:type="xsd:double">1.162118655159115E3</Value>
              <FmtValue>$1,162.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="385">
              <Value xsi:type="xsd:double">6.51962446250008E3</Value>
              <FmtValue>$6,519.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="386">
              <Value xsi:type="xsd:double">4.4735872750008385E5</Value>
              <FmtValue>$447,358.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="387">
              <Value xsi:type="xsd:double">5.6802362553844674E-2</Value>
              <FmtValue>5.68%</FmtValue>
            </Cell>
            <Cell CellOrdinal="389">
              <Value xsi:type="xsd:double">7.928431636271945E-1</Value>
              <FmtValue>79.28%</FmtValue>
            </Cell>
            <Cell CellOrdinal="390">
              <Value xsi:type="xsd:double">7.928431636271945E-1</Value>
              <FmtValue>79.28%</FmtValue>
            </Cell>
            <Cell CellOrdinal="391">
              <Value xsi:type="xsd:int">5780</Value>
              <FmtValue>5,780</FmtValue>
            </Cell>
            <Cell CellOrdinal="392">
              <Value xsi:type="xsd:double">6.056723293100059E6</Value>
              <FmtValue>$6,056,723.29</FmtValue>
            </Cell>
            <Cell CellOrdinal="393">
              <Value xsi:type="xsd:double">2.4050391772000007E6</Value>
              <FmtValue>$2,405,039.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="394">
              <Value xsi:type="xsd:double">5.250047832700008E6</Value>
              <FmtValue>$5,250,047.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="395">
              <Value xsi:type="xsd:double">6.045785563000059E6</Value>
              <FmtValue>$6,045,785.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="396">
              <Value xsi:type="xsd:double">4.8366284079999965E5</Value>
              <FmtValue>$483,662.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="397">
              <Value xsi:type="xsd:double">1.5114471779999993E5</Value>
              <FmtValue>$151,144.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="398">
              <Value xsi:type="xsd:int">1186</Value>
              <FmtValue>1,186</FmtValue>
            </Cell>
            <Cell CellOrdinal="399">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="400">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="401">
              <Value xsi:type="xsd:double">1.2790750253397288E3</Value>
              <FmtValue>$1,279.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="402">
              <Value xsi:type="xsd:double">5.097626950253E3</Value>
              <FmtValue>$5,097.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="403">
              <Value xsi:type="xsd:double">7.957377303000512E5</Value>
              <FmtValue>$795,737.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="404">
              <Value xsi:type="xsd:double">1.3161858322761743E-1</Value>
              <FmtValue>13.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="406">
              <Value xsi:type="xsd:double">8.713816398347788E-1</Value>
              <FmtValue>87.14%</FmtValue>
            </Cell>
            <Cell CellOrdinal="407">
              <Value xsi:type="xsd:double">8.713816398347788E-1</Value>
              <FmtValue>87.14%</FmtValue>
            </Cell>
            <Cell CellOrdinal="408">
              <Value xsi:type="xsd:int">9033</Value>
              <FmtValue>9,033</FmtValue>
            </Cell>
            <Cell CellOrdinal="409">
              <Value xsi:type="xsd:double">9.457512686300112E6</Value>
              <FmtValue>$9,457,512.69</FmtValue>
            </Cell>
            <Cell CellOrdinal="410">
              <Value xsi:type="xsd:double">3.5781282628000006E6</Value>
              <FmtValue>$3,578,128.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="411">
              <Value xsi:type="xsd:double">8.547195019800003E6</Value>
              <FmtValue>$8,547,195.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="412">
              <Value xsi:type="xsd:double">9.449348344400111E6</Value>
              <FmtValue>$9,449,348.34</FmtValue>
            </Cell>
            <Cell CellOrdinal="413">
              <Value xsi:type="xsd:double">7.559478562999965E5</Value>
              <FmtValue>$755,947.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="414">
              <Value xsi:type="xsd:double">2.3623381440000067E5</Value>
              <FmtValue>$236,233.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="415">
              <Value xsi:type="xsd:int">1399</Value>
              <FmtValue>1,399</FmtValue>
            </Cell>
            <Cell CellOrdinal="416">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="417">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="418">
              <Value xsi:type="xsd:double">1.1910984542510136E3</Value>
              <FmtValue>$1,191.10</FmtValue>
            </Cell>
            <Cell CellOrdinal="419">
              <Value xsi:type="xsd:double">6.7543590739100155E3</Value>
              <FmtValue>$6,754.36</FmtValue>
            </Cell>
            <Cell CellOrdinal="420">
              <Value xsi:type="xsd:double">9.02153324600108E5</Value>
              <FmtValue>$902,153.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="421">
              <Value xsi:type="xsd:double">9.547254389608184E-2</Value>
              <FmtValue>9.55%</FmtValue>
            </Cell>
            <Cell CellOrdinal="423">
              <Value xsi:type="xsd:double">8.639654498751047E-1</Value>
              <FmtValue>86.40%</FmtValue>
            </Cell>
            <Cell CellOrdinal="424">
              <Value xsi:type="xsd:double">8.639654498751047E-1</Value>
              <FmtValue>86.40%</FmtValue>
            </Cell>
            <Cell CellOrdinal="425">
              <Value xsi:type="xsd:int">8286</Value>
              <FmtValue>8,286</FmtValue>
            </Cell>
            <Cell CellOrdinal="426">
              <Value xsi:type="xsd:double">9.106970171500139E6</Value>
              <FmtValue>$9,106,970.17</FmtValue>
            </Cell>
            <Cell CellOrdinal="427">
              <Value xsi:type="xsd:double">3.8142376130999927E6</Value>
              <FmtValue>$3,814,237.61</FmtValue>
            </Cell>
            <Cell CellOrdinal="428">
              <Value xsi:type="xsd:double">7.821948848899994E6</Value>
              <FmtValue>$7,821,948.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="429">
              <Value xsi:type="xsd:double">9.099524014000138E6</Value>
              <FmtValue>$9,099,524.01</FmtValue>
            </Cell>
            <Cell CellOrdinal="430">
              <Value xsi:type="xsd:double">7.27961916699993E5</Value>
              <FmtValue>$727,961.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="431">
              <Value xsi:type="xsd:double">2.274882269000018E5</Value>
              <FmtValue>$227,488.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="432">
              <Value xsi:type="xsd:int">1908</Value>
              <FmtValue>1,908</FmtValue>
            </Cell>
            <Cell CellOrdinal="433">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="434">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="435">
              <Value xsi:type="xsd:double">1.2848793808868642E3</Value>
              <FmtValue>$1,284.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="436">
              <Value xsi:type="xsd:double">4.76914256498959E3</Value>
              <FmtValue>$4,769.14</FmtValue>
            </Cell>
            <Cell CellOrdinal="437">
              <Value xsi:type="xsd:double">1.2775751651001442E6</Value>
              <FmtValue>$1,277,575.17</FmtValue>
            </Cell>
            <Cell CellOrdinal="438">
              <Value xsi:type="xsd:double">1.404002190811873E-1</Value>
              <FmtValue>14.04%</FmtValue>
            </Cell>
            <Cell CellOrdinal="440">
              <Value xsi:type="xsd:double">8.696247576092015E-1</Value>
              <FmtValue>86.96%</FmtValue>
            </Cell>
            <Cell CellOrdinal="441">
              <Value xsi:type="xsd:double">8.696247576092015E-1</Value>
              <FmtValue>86.96%</FmtValue>
            </Cell>
            <Cell CellOrdinal="442">
              <Value xsi:type="xsd:int">73598</Value>
              <FmtValue>73,598</FmtValue>
            </Cell>
            <Cell CellOrdinal="443">
              <Value xsi:type="xsd:double">2.138577942500014E6</Value>
              <FmtValue>$2,138,577.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="444">
              <Value xsi:type="xsd:double">4.978712978999987E5</Value>
              <FmtValue>$497,871.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="445">
              <Value xsi:type="xsd:double">1.7487774507999986E6</Value>
              <FmtValue>$1,748,777.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="446">
              <Value xsi:type="xsd:double">2.117613449100015E6</Value>
              <FmtValue>$2,117,613.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="447">
              <Value xsi:type="xsd:double">1.6940906349999923E5</Value>
              <FmtValue>$169,409.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="448">
              <Value xsi:type="xsd:double">5.294093679999985E4</Value>
              <FmtValue>$52,940.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="449">
              <Value xsi:type="xsd:int">9871</Value>
              <FmtValue>9,871</FmtValue>
            </Cell>
            <Cell CellOrdinal="450">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="451">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="452">
              <Value xsi:type="xsd:double">3.209498043803827E1</Value>
              <FmtValue>$32.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="453">
              <Value xsi:type="xsd:double">2.1452876599128916E2</Value>
              <FmtValue>$214.53</FmtValue>
            </Cell>
            <Cell CellOrdinal="454">
              <Value xsi:type="xsd:double">3.688359983000166E5</Value>
              <FmtValue>$368,836.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="455">
              <Value xsi:type="xsd:double">1.7417531913426964E-1</Value>
              <FmtValue>17.42%</FmtValue>
            </Cell>
            <Cell CellOrdinal="457">
              <Value xsi:type="xsd:double">1.9284468133221953E-2</Value>
              <FmtValue>1.93%</FmtValue>
            </Cell>
            <Cell CellOrdinal="458">
              <Value xsi:type="xsd:double">1.9284468133221953E-2</Value>
              <FmtValue>1.93%</FmtValue>
            </Cell>
            <Cell CellOrdinal="459">
              <Value xsi:type="xsd:int">3449</Value>
              <FmtValue>3,449</FmtValue>
            </Cell>
            <Cell CellOrdinal="460">
              <Value xsi:type="xsd:double">1.0591661740000032E5</Value>
              <FmtValue>$105,916.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="461">
              <Value xsi:type="xsd:double">3.229927539999991E4</Value>
              <FmtValue>$32,299.28</FmtValue>
            </Cell>
            <Cell CellOrdinal="462">
              <Value xsi:type="xsd:double">8.347976059999958E4</Value>
              <FmtValue>$83,479.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="463">
              <Value xsi:type="xsd:double">1.0542047220000025E5</Value>
              <FmtValue>$105,420.47</FmtValue>
            </Cell>
            <Cell CellOrdinal="464">
              <Value xsi:type="xsd:double">8.433637099999961E3</Value>
              <FmtValue>$8,433.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="465">
              <Value xsi:type="xsd:double">2.635557900000004E3</Value>
              <FmtValue>$2,635.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="466">
              <Value xsi:type="xsd:int">770</Value>
              <FmtValue>770</FmtValue>
            </Cell>
            <Cell CellOrdinal="467">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="468">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="469">
              <Value xsi:type="xsd:double">3.394140825420028E1</Value>
              <FmtValue>$33.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="470">
              <Value xsi:type="xsd:double">1.3690970415584448E2</Value>
              <FmtValue>$136.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="471">
              <Value xsi:type="xsd:double">2.1940711600000664E4</Value>
              <FmtValue>$21,940.71</FmtValue>
            </Cell>
            <Cell CellOrdinal="472">
              <Value xsi:type="xsd:double">2.0812571924716358E-1</Value>
              <FmtValue>20.81%</FmtValue>
            </Cell>
            <Cell CellOrdinal="474">
              <Value xsi:type="xsd:double">1.737014105064993E-2</Value>
              <FmtValue>1.74%</FmtValue>
            </Cell>
            <Cell CellOrdinal="475">
              <Value xsi:type="xsd:double">1.737014105064993E-2</Value>
              <FmtValue>1.74%</FmtValue>
            </Cell>
            <Cell CellOrdinal="476">
              <Value xsi:type="xsd:int">4398</Value>
              <FmtValue>4,398</FmtValue>
            </Cell>
            <Cell CellOrdinal="477">
              <Value xsi:type="xsd:double">1.28374575700001E5</Value>
              <FmtValue>$128,374.58</FmtValue>
            </Cell>
            <Cell CellOrdinal="478">
              <Value xsi:type="xsd:double">3.6844727799999935E4</Value>
              <FmtValue>$36,844.73</FmtValue>
            </Cell>
            <Cell CellOrdinal="479">
              <Value xsi:type="xsd:double">1.0054143539999958E5</Value>
              <FmtValue>$100,541.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="480">
              <Value xsi:type="xsd:double">1.2797334480000101E5</Value>
              <FmtValue>$127,973.34</FmtValue>
            </Cell>
            <Cell CellOrdinal="481">
              <Value xsi:type="xsd:double">1.0237865599999946E4</Value>
              <FmtValue>$10,237.87</FmtValue>
            </Cell>
            <Cell CellOrdinal="482">
              <Value xsi:type="xsd:double">3.1993841000000043E3</Value>
              <FmtValue>$3,199.38</FmtValue>
            </Cell>
            <Cell CellOrdinal="483">
              <Value xsi:type="xsd:int">865</Value>
              <FmtValue>865</FmtValue>
            </Cell>
            <Cell CellOrdinal="484">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="485">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="486">
              <Value xsi:type="xsd:double">3.2115427750611374E1</Value>
              <FmtValue>$32.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="487">
              <Value xsi:type="xsd:double">1.4794606335260232E2</Value>
              <FmtValue>$147.95</FmtValue>
            </Cell>
            <Cell CellOrdinal="488">
              <Value xsi:type="xsd:double">2.743190940000143E4</Value>
              <FmtValue>$27,431.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="489">
              <Value xsi:type="xsd:double">2.1435643057444892E-1</Value>
              <FmtValue>21.44%</FmtValue>
            </Cell>
            <Cell CellOrdinal="491">
              <Value xsi:type="xsd:double">1.3486793975193324E-2</Value>
              <FmtValue>1.35%</FmtValue>
            </Cell>
            <Cell CellOrdinal="492">
              <Value xsi:type="xsd:double">1.3486793975193324E-2</Value>
              <FmtValue>1.35%</FmtValue>
            </Cell>
            <Cell CellOrdinal="493">
              <Value xsi:type="xsd:int">4053</Value>
              <FmtValue>4,053</FmtValue>
            </Cell>
            <Cell CellOrdinal="494">
              <Value xsi:type="xsd:double">1.2249622600000124E5</Value>
              <FmtValue>$122,496.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="495">
              <Value xsi:type="xsd:double">3.48147899999999E4</Value>
              <FmtValue>$34,814.79</FmtValue>
            </Cell>
            <Cell CellOrdinal="496">
              <Value xsi:type="xsd:double">9.620808779999966E4</Value>
              <FmtValue>$96,208.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="497">
              <Value xsi:type="xsd:double">1.2202530440000118E5</Value>
              <FmtValue>$122,025.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="498">
              <Value xsi:type="xsd:double">9.762022999999948E3</Value>
              <FmtValue>$9,762.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="499">
              <Value xsi:type="xsd:double">3.050679300000003E3</Value>
              <FmtValue>$3,050.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="500">
              <Value xsi:type="xsd:int">851</Value>
              <FmtValue>851</FmtValue>
            </Cell>
            <Cell CellOrdinal="501">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="502">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="503">
              <Value xsi:type="xsd:double">3.287628023793803E1</Value>
              <FmtValue>$32.88</FmtValue>
            </Cell>
            <Cell CellOrdinal="504">
              <Value xsi:type="xsd:double">1.4339048695652315E2</Value>
              <FmtValue>$143.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="505">
              <Value xsi:type="xsd:double">2.5817216600001527E4</Value>
              <FmtValue>$25,817.22</FmtValue>
            </Cell>
            <Cell CellOrdinal="506">
              <Value xsi:type="xsd:double">2.1157264656658603E-1</Value>
              <FmtValue>21.16%</FmtValue>
            </Cell>
            <Cell CellOrdinal="508">
              <Value xsi:type="xsd:double">1.4580245268687204E-2</Value>
              <FmtValue>1.46%</FmtValue>
            </Cell>
            <Cell CellOrdinal="509">
              <Value xsi:type="xsd:double">1.4580245268687204E-2</Value>
              <FmtValue>1.46%</FmtValue>
            </Cell>
            <Cell CellOrdinal="510">
              <Value xsi:type="xsd:int">5237</Value>
              <FmtValue>5,237</FmtValue>
            </Cell>
            <Cell CellOrdinal="511">
              <Value xsi:type="xsd:double">1.554124626000028E5</Value>
              <FmtValue>$155,412.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="512">
              <Value xsi:type="xsd:double">3.9289256399999925E4</Value>
              <FmtValue>$39,289.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="513">
              <Value xsi:type="xsd:double">1.2620634119999988E5</Value>
              <FmtValue>$126,206.34</FmtValue>
            </Cell>
            <Cell CellOrdinal="514">
              <Value xsi:type="xsd:double">1.538109406000028E5</Value>
              <FmtValue>$153,810.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="515">
              <Value xsi:type="xsd:double">1.2304872899999951E4</Value>
              <FmtValue>$12,304.87</FmtValue>
            </Cell>
            <Cell CellOrdinal="516">
              <Value xsi:type="xsd:double">3.8453237999999905E3</Value>
              <FmtValue>$3,845.32</FmtValue>
            </Cell>
            <Cell CellOrdinal="517">
              <Value xsi:type="xsd:int">832</Value>
              <FmtValue>832</FmtValue>
            </Cell>
            <Cell CellOrdinal="518">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="519">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="520">
              <Value xsi:type="xsd:double">3.3422709047333846E1</Value>
              <FmtValue>$33.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="521">
              <Value xsi:type="xsd:double">1.8486891899038798E2</Value>
              <FmtValue>$184.87</FmtValue>
            </Cell>
            <Cell CellOrdinal="522">
              <Value xsi:type="xsd:double">2.7604599400002916E4</Value>
              <FmtValue>$27,604.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="523">
              <Value xsi:type="xsd:double">1.7947097451143482E-1</Value>
              <FmtValue>17.95%</FmtValue>
            </Cell>
            <Cell CellOrdinal="525">
              <Value xsi:type="xsd:double">1.9893691841000302E-2</Value>
              <FmtValue>1.99%</FmtValue>
            </Cell>
            <Cell CellOrdinal="526">
              <Value xsi:type="xsd:double">1.9893691841000302E-2</Value>
              <FmtValue>1.99%</FmtValue>
            </Cell>
            <Cell CellOrdinal="527">
              <Value xsi:type="xsd:int">7054</Value>
              <FmtValue>7,054</FmtValue>
            </Cell>
            <Cell CellOrdinal="528">
              <Value xsi:type="xsd:double">2.0273367690000246E5</Value>
              <FmtValue>$202,733.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="529">
              <Value xsi:type="xsd:double">4.9246115799999854E4</Value>
              <FmtValue>$49,246.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="530">
              <Value xsi:type="xsd:double">1.6220180589999963E5</Value>
              <FmtValue>$162,201.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="531">
              <Value xsi:type="xsd:double">2.0123548730000254E5</Value>
              <FmtValue>$201,235.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="532">
              <Value xsi:type="xsd:double">1.6098836499999908E4</Value>
              <FmtValue>$16,098.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="533">
              <Value xsi:type="xsd:double">5.030942999999976E3</Value>
              <FmtValue>$5,030.94</FmtValue>
            </Cell>
            <Cell CellOrdinal="534">
              <Value xsi:type="xsd:int">964</Value>
              <FmtValue>964</FmtValue>
            </Cell>
            <Cell CellOrdinal="535">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="536">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="537">
              <Value xsi:type="xsd:double">3.1513020524836E1</Value>
              <FmtValue>$31.51</FmtValue>
            </Cell>
            <Cell CellOrdinal="538">
              <Value xsi:type="xsd:double">2.0875050549792795E2</Value>
              <FmtValue>$208.75</FmtValue>
            </Cell>
            <Cell CellOrdinal="539">
              <Value xsi:type="xsd:double">3.903368140000291E4</Value>
              <FmtValue>$39,033.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="540">
              <Value xsi:type="xsd:double">1.9397016860058766E-1</Value>
              <FmtValue>19.40%</FmtValue>
            </Cell>
            <Cell CellOrdinal="542">
              <Value xsi:type="xsd:double">1.7378162788122302E-2</Value>
              <FmtValue>1.74%</FmtValue>
            </Cell>
            <Cell CellOrdinal="543">
              <Value xsi:type="xsd:double">1.7378162788122302E-2</Value>
              <FmtValue>1.74%</FmtValue>
            </Cell>
            <Cell CellOrdinal="544">
              <Value xsi:type="xsd:int">6438</Value>
              <FmtValue>6,438</FmtValue>
            </Cell>
            <Cell CellOrdinal="545">
              <Value xsi:type="xsd:double">1.9035508970000283E5</Value>
              <FmtValue>$190,355.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="546">
              <Value xsi:type="xsd:double">4.731913429999988E4</Value>
              <FmtValue>$47,319.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="547">
              <Value xsi:type="xsd:double">1.536025448999997E5</Value>
              <FmtValue>$153,602.54</FmtValue>
            </Cell>
            <Cell CellOrdinal="548">
              <Value xsi:type="xsd:double">1.890078360000028E5</Value>
              <FmtValue>$189,007.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="549">
              <Value xsi:type="xsd:double">1.5120625099999928E4</Value>
              <FmtValue>$15,120.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="550">
              <Value xsi:type="xsd:double">4.725256099999971E3</Value>
              <FmtValue>$4,725.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="551">
              <Value xsi:type="xsd:int">1005</Value>
              <FmtValue>1,005</FmtValue>
            </Cell>
            <Cell CellOrdinal="552">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="553">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="554">
              <Value xsi:type="xsd:double">3.226711215551181E1</Value>
              <FmtValue>$32.27</FmtValue>
            </Cell>
            <Cell CellOrdinal="555">
              <Value xsi:type="xsd:double">1.8806749850746547E2</Value>
              <FmtValue>$188.07</FmtValue>
            </Cell>
            <Cell CellOrdinal="556">
              <Value xsi:type="xsd:double">3.5405291100003116E4</Value>
              <FmtValue>$35,405.29</FmtValue>
            </Cell>
            <Cell CellOrdinal="557">
              <Value xsi:type="xsd:double">1.8732181611773277E-1</Value>
              <FmtValue>18.73%</FmtValue>
            </Cell>
            <Cell CellOrdinal="559">
              <Value xsi:type="xsd:double">1.971690672204386E-2</Value>
              <FmtValue>1.97%</FmtValue>
            </Cell>
            <Cell CellOrdinal="560">
              <Value xsi:type="xsd:double">1.971690672204386E-2</Value>
              <FmtValue>1.97%</FmtValue>
            </Cell>
            <Cell CellOrdinal="561">
              <Value xsi:type="xsd:int">6434</Value>
              <FmtValue>6,434</FmtValue>
            </Cell>
            <Cell CellOrdinal="562">
              <Value xsi:type="xsd:double">1.848404386000007E5</Value>
              <FmtValue>$184,840.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="563">
              <Value xsi:type="xsd:double">3.594470329999992E4</Value>
              <FmtValue>$35,944.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="564">
              <Value xsi:type="xsd:double">1.5670814500000002E5</Value>
              <FmtValue>$156,708.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="565">
              <Value xsi:type="xsd:double">1.8159649510000076E5</Value>
              <FmtValue>$181,596.50</FmtValue>
            </Cell>
            <Cell CellOrdinal="566">
              <Value xsi:type="xsd:double">1.4527718399999978E4</Value>
              <FmtValue>$14,527.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="567">
              <Value xsi:type="xsd:double">4.539953299999996E3</Value>
              <FmtValue>$4,539.95</FmtValue>
            </Cell>
            <Cell CellOrdinal="568">
              <Value xsi:type="xsd:int">643</Value>
              <FmtValue>643</FmtValue>
            </Cell>
            <Cell CellOrdinal="569">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="570">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="571">
              <Value xsi:type="xsd:double">3.247905155526138E1</Value>
              <FmtValue>$32.48</FmtValue>
            </Cell>
            <Cell CellOrdinal="572">
              <Value xsi:type="xsd:double">2.824206766718519E2</Value>
              <FmtValue>$282.42</FmtValue>
            </Cell>
            <Cell CellOrdinal="573">
              <Value xsi:type="xsd:double">2.4888350100000738E4</Value>
              <FmtValue>$24,888.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="574">
              <Value xsi:type="xsd:double">1.3705303115181452E-1</Value>
              <FmtValue>13.71%</FmtValue>
            </Cell>
            <Cell CellOrdinal="576">
              <Value xsi:type="xsd:double">2.4342917460442457E-2</Value>
              <FmtValue>2.43%</FmtValue>
            </Cell>
            <Cell CellOrdinal="577">
              <Value xsi:type="xsd:double">2.4342917460442457E-2</Value>
              <FmtValue>2.43%</FmtValue>
            </Cell>
            <Cell CellOrdinal="578">
              <Value xsi:type="xsd:int">9419</Value>
              <FmtValue>9,419</FmtValue>
            </Cell>
            <Cell CellOrdinal="579">
              <Value xsi:type="xsd:double">2.657464784999966E5</Value>
              <FmtValue>$265,746.48</FmtValue>
            </Cell>
            <Cell CellOrdinal="580">
              <Value xsi:type="xsd:double">5.060498169999985E4</Value>
              <FmtValue>$50,604.98</FmtValue>
            </Cell>
            <Cell CellOrdinal="581">
              <Value xsi:type="xsd:double">2.2415163520000072E5</Value>
              <FmtValue>$224,151.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="582">
              <Value xsi:type="xsd:double">2.622614361999973E5</Value>
              <FmtValue>$262,261.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="583">
              <Value xsi:type="xsd:double">2.098091549999991E4</Value>
              <FmtValue>$20,980.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="584">
              <Value xsi:type="xsd:double">6.556588099999981E3</Value>
              <FmtValue>$6,556.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="585">
              <Value xsi:type="xsd:int">769</Value>
              <FmtValue>769</FmtValue>
            </Cell>
            <Cell CellOrdinal="586">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="587">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="588">
              <Value xsi:type="xsd:double">3.0799475092764435E1</Value>
              <FmtValue>$30.80</FmtValue>
            </Cell>
            <Cell CellOrdinal="589">
              <Value xsi:type="xsd:double">3.410421797139107E2</Value>
              <FmtValue>$341.04</FmtValue>
            </Cell>
            <Cell CellOrdinal="590">
              <Value xsi:type="xsd:double">3.81098009999966E4</Value>
              <FmtValue>$38,109.80</FmtValue>
            </Cell>
            <Cell CellOrdinal="591">
              <Value xsi:type="xsd:double">1.453122561676759E-1</Value>
              <FmtValue>14.53%</FmtValue>
            </Cell>
            <Cell CellOrdinal="593">
              <Value xsi:type="xsd:double">2.330761694885109E-2</Value>
              <FmtValue>2.33%</FmtValue>
            </Cell>
            <Cell CellOrdinal="594">
              <Value xsi:type="xsd:double">2.330761694885109E-2</Value>
              <FmtValue>2.33%</FmtValue>
            </Cell>
            <Cell CellOrdinal="595">
              <Value xsi:type="xsd:int">8313</Value>
              <FmtValue>8,313</FmtValue>
            </Cell>
            <Cell CellOrdinal="596">
              <Value xsi:type="xsd:double">2.4127788729999843E5</Value>
              <FmtValue>$241,277.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="597">
              <Value xsi:type="xsd:double">4.62879322999999E4</Value>
              <FmtValue>$46,287.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="598">
              <Value xsi:type="xsd:double">2.0282312459999992E5</Value>
              <FmtValue>$202,823.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="599">
              <Value xsi:type="xsd:double">2.376829756999992E5</Value>
              <FmtValue>$237,682.98</FmtValue>
            </Cell>
            <Cell CellOrdinal="600">
              <Value xsi:type="xsd:double">1.9014637399999916E4</Value>
              <FmtValue>$19,014.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="601">
              <Value xsi:type="xsd:double">5.942122699999978E3</Value>
              <FmtValue>$5,942.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="602">
              <Value xsi:type="xsd:int">760</Value>
              <FmtValue>760</FmtValue>
            </Cell>
            <Cell CellOrdinal="603">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="604">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="605">
              <Value xsi:type="xsd:double">3.1903548609680843E1</Value>
              <FmtValue>$31.90</FmtValue>
            </Cell>
            <Cell CellOrdinal="606">
              <Value xsi:type="xsd:double">3.1274075749999895E2</Value>
              <FmtValue>$312.74</FmtValue>
            </Cell>
            <Cell CellOrdinal="607">
              <Value xsi:type="xsd:double">3.485985109999927E4</Value>
              <FmtValue>$34,859.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="608">
              <Value xsi:type="xsd:double">1.466653259339827E-1</Value>
              <FmtValue>14.67%</FmtValue>
            </Cell>
            <Cell CellOrdinal="610">
              <Value xsi:type="xsd:double">2.3927418570851295E-2</Value>
              <FmtValue>2.39%</FmtValue>
            </Cell>
            <Cell CellOrdinal="611">
              <Value xsi:type="xsd:double">2.3927418570851295E-2</Value>
              <FmtValue>2.39%</FmtValue>
            </Cell>
            <Cell CellOrdinal="612">
              <Value xsi:type="xsd:int">5282</Value>
              <FmtValue>5,282</FmtValue>
            </Cell>
            <Cell CellOrdinal="613">
              <Value xsi:type="xsd:double">1.5359724100000234E5</Value>
              <FmtValue>$153,597.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="614">
              <Value xsi:type="xsd:double">3.4645623699999894E4</Value>
              <FmtValue>$34,645.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="615">
              <Value xsi:type="xsd:double">1.2475883339999997E5</Value>
              <FmtValue>$124,758.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="616">
              <Value xsi:type="xsd:double">1.518882601000023E5</Value>
              <FmtValue>$151,888.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="617">
              <Value xsi:type="xsd:double">1.2151059999999946E4</Value>
              <FmtValue>$12,151.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="618">
              <Value xsi:type="xsd:double">3.7972494999999917E3</Value>
              <FmtValue>$3,797.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="619">
              <Value xsi:type="xsd:int">697</Value>
              <FmtValue>697</FmtValue>
            </Cell>
            <Cell CellOrdinal="620">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="621">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="622">
              <Value xsi:type="xsd:double">3.2354987866666896E1</Value>
              <FmtValue>$32.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="623">
              <Value xsi:type="xsd:double">2.1791715939742082E2</Value>
              <FmtValue>$217.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="624">
              <Value xsi:type="xsd:double">2.712942670000234E4</Value>
              <FmtValue>$27,129.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="625">
              <Value xsi:type="xsd:double">1.7861437534501012E-1</Value>
              <FmtValue>17.86%</FmtValue>
            </Cell>
            <Cell CellOrdinal="627">
              <Value xsi:type="xsd:double">2.189171940989501E-2</Value>
              <FmtValue>2.19%</FmtValue>
            </Cell>
            <Cell CellOrdinal="628">
              <Value xsi:type="xsd:double">2.189171940989501E-2</Value>
              <FmtValue>2.19%</FmtValue>
            </Cell>
            <Cell CellOrdinal="629">
              <Value xsi:type="xsd:int">6973</Value>
              <FmtValue>6,973</FmtValue>
            </Cell>
            <Cell CellOrdinal="630">
              <Value xsi:type="xsd:double">1.983436515000024E5</Value>
              <FmtValue>$198,343.65</FmtValue>
            </Cell>
            <Cell CellOrdinal="631">
              <Value xsi:type="xsd:double">4.584034929999989E4</Value>
              <FmtValue>$45,840.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="632">
              <Value xsi:type="xsd:double">1.6284443329999995E5</Value>
              <FmtValue>$162,844.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="633">
              <Value xsi:type="xsd:double">1.9691982990000246E5</Value>
              <FmtValue>$196,919.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="634">
              <Value xsi:type="xsd:double">1.5753585399999923E4</Value>
              <FmtValue>$15,753.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="635">
              <Value xsi:type="xsd:double">4.92304659999998E3</Value>
              <FmtValue>$4,923.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="636">
              <Value xsi:type="xsd:int">810</Value>
              <FmtValue>810</FmtValue>
            </Cell>
            <Cell CellOrdinal="637">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="638">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="639">
              <Value xsi:type="xsd:double">3.1031832409274312E1</Value>
              <FmtValue>$31.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="640">
              <Value xsi:type="xsd:double">2.4311090111111414E2</Value>
              <FmtValue>$243.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="641">
              <Value xsi:type="xsd:double">3.407539660000251E4</Value>
              <FmtValue>$34,075.40</FmtValue>
            </Cell>
            <Cell CellOrdinal="642">
              <Value xsi:type="xsd:double">1.730419766120369E-1</Value>
              <FmtValue>17.30%</FmtValue>
            </Cell>
            <Cell CellOrdinal="644">
              <Value xsi:type="xsd:double">1.800462034291588E-2</Value>
              <FmtValue>1.80%</FmtValue>
            </Cell>
            <Cell CellOrdinal="645">
              <Value xsi:type="xsd:double">1.800462034291588E-2</Value>
              <FmtValue>1.80%</FmtValue>
            </Cell>
            <Cell CellOrdinal="646">
              <Value xsi:type="xsd:int">6548</Value>
              <FmtValue>6,548</FmtValue>
            </Cell>
            <Cell CellOrdinal="647">
              <Value xsi:type="xsd:double">1.8948359730000276E5</Value>
              <FmtValue>$189,483.60</FmtValue>
            </Cell>
            <Cell CellOrdinal="648">
              <Value xsi:type="xsd:double">4.473440789999989E4</Value>
              <FmtValue>$44,734.41</FmtValue>
            </Cell>
            <Cell CellOrdinal="649">
              <Value xsi:type="xsd:double">1.5525130349999998E5</Value>
              <FmtValue>$155,251.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="650">
              <Value xsi:type="xsd:double">1.8779106680000276E5</Value>
              <FmtValue>$187,791.07</FmtValue>
            </Cell>
            <Cell CellOrdinal="651">
              <Value xsi:type="xsd:double">1.502328659999992E4</Value>
              <FmtValue>$15,023.29</FmtValue>
            </Cell>
            <Cell CellOrdinal="652">
              <Value xsi:type="xsd:double">4.694832399999974E3</Value>
              <FmtValue>$4,694.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="653">
              <Value xsi:type="xsd:int">905</Value>
              <FmtValue>905</FmtValue>
            </Cell>
            <Cell CellOrdinal="654">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="655">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="656">
              <Value xsi:type="xsd:double">3.1697814412070773E1</Value>
              <FmtValue>$31.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="657">
              <Value xsi:type="xsd:double">2.0750394121547268E2</Value>
              <FmtValue>$207.50</FmtValue>
            </Cell>
            <Cell CellOrdinal="658">
              <Value xsi:type="xsd:double">3.2539763300002785E4</Value>
              <FmtValue>$32,539.76</FmtValue>
            </Cell>
            <Cell CellOrdinal="659">
              <Value xsi:type="xsd:double">1.7327641753405443E-1</Value>
              <FmtValue>17.33%</FmtValue>
            </Cell>
            <Cell CellOrdinal="661">
              <Value xsi:type="xsd:double">1.7946846526902666E-2</Value>
              <FmtValue>1.79%</FmtValue>
            </Cell>
            <Cell CellOrdinal="662">
              <Value xsi:type="xsd:double">1.7946846526902666E-2</Value>
              <FmtValue>1.79%</FmtValue>
            </Cell>
            <Cell CellOrdinal="663">
              <Value xsi:type="xsd:int">49027</Value>
              <FmtValue>49,027</FmtValue>
            </Cell>
            <Cell CellOrdinal="664">
              <Value xsi:type="xsd:double">1.1804291396499998E7</Value>
              <FmtValue>$11,804,291.40</FmtValue>
            </Cell>
            <Cell CellOrdinal="665">
              <Value xsi:type="xsd:double">4.289134029700003E6</Value>
              <FmtValue>$4,289,134.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="666">
              <Value xsi:type="xsd:double">1.0766110178599996E7</Value>
              <FmtValue>$10,766,110.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="667">
              <Value xsi:type="xsd:double">1.17990766584E7</Value>
              <FmtValue>$11,799,076.66</FmtValue>
            </Cell>
            <Cell CellOrdinal="668">
              <Value xsi:type="xsd:double">9.439261237000002E5</Value>
              <FmtValue>$943,926.12</FmtValue>
            </Cell>
            <Cell CellOrdinal="669">
              <Value xsi:type="xsd:double">2.949771531E5</Value>
              <FmtValue>$294,977.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="670">
              <Value xsi:type="xsd:int">2646</Value>
              <FmtValue>2,646</FmtValue>
            </Cell>
            <Cell CellOrdinal="671">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="672">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="673">
              <Value xsi:type="xsd:double">2.5140162914860568E2</Value>
              <FmtValue>$251.40</FmtValue>
            </Cell>
            <Cell CellOrdinal="674">
              <Value xsi:type="xsd:double">4.459212644897959E3</Value>
              <FmtValue>$4,459.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="675">
              <Value xsi:type="xsd:double">1.0329664798000026E6</Value>
              <FmtValue>$1,032,966.48</FmtValue>
            </Cell>
            <Cell CellOrdinal="676">
              <Value xsi:type="xsd:double">8.754638262856044E-2</Value>
              <FmtValue>8.75%</FmtValue>
            </Cell>
            <Cell CellOrdinal="678">
              <Value xsi:type="xsd:double">1.0745063879201452E-1</Value>
              <FmtValue>10.75%</FmtValue>
            </Cell>
            <Cell CellOrdinal="679">
              <Value xsi:type="xsd:double">1.0745063879201452E-1</Value>
              <FmtValue>10.75%</FmtValue>
            </Cell>
            <Cell CellOrdinal="680">
              <Value xsi:type="xsd:int">1306</Value>
              <FmtValue>1,306</FmtValue>
            </Cell>
            <Cell CellOrdinal="681">
              <Value xsi:type="xsd:double">2.829701261E5</Value>
              <FmtValue>$282,970.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="682">
              <Value xsi:type="xsd:double">1.1039080989999995E5</Value>
              <FmtValue>$110,390.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="683">
              <Value xsi:type="xsd:double">2.5715104580000025E5</Value>
              <FmtValue>$257,151.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="684">
              <Value xsi:type="xsd:double">2.8295707389999996E5</Value>
              <FmtValue>$282,957.07</FmtValue>
            </Cell>
            <Cell CellOrdinal="685">
              <Value xsi:type="xsd:double">2.2636565799999996E4</Value>
              <FmtValue>$22,636.57</FmtValue>
            </Cell>
            <Cell CellOrdinal="686">
              <Value xsi:type="xsd:double">7.073934500000003E3</Value>
              <FmtValue>$7,073.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="687">
              <Value xsi:type="xsd:int">97</Value>
              <FmtValue>97</FmtValue>
            </Cell>
            <Cell CellOrdinal="688">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="689">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="690">
              <Value xsi:type="xsd:double">2.263468304104479E2</Value>
              <FmtValue>$226.35</FmtValue>
            </Cell>
            <Cell CellOrdinal="691">
              <Value xsi:type="xsd:double">2.917083236082474E3</Value>
              <FmtValue>$2,917.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="692">
              <Value xsi:type="xsd:double">2.5806028099999705E4</Value>
              <FmtValue>$25,806.03</FmtValue>
            </Cell>
            <Cell CellOrdinal="693">
              <Value xsi:type="xsd:double">9.120121205776897E-2</Value>
              <FmtValue>9.12%</FmtValue>
            </Cell>
            <Cell CellOrdinal="695">
              <Value xsi:type="xsd:double">4.6622863494650175E-2</Value>
              <FmtValue>4.66%</FmtValue>
            </Cell>
            <Cell CellOrdinal="696">
              <Value xsi:type="xsd:double">4.6622863494650175E-2</Value>
              <FmtValue>4.66%</FmtValue>
            </Cell>
            <Cell CellOrdinal="697">
              <Value xsi:type="xsd:int">2129</Value>
              <FmtValue>2,129</FmtValue>
            </Cell>
            <Cell CellOrdinal="698">
              <Value xsi:type="xsd:double">5.356096779E5</Value>
              <FmtValue>$535,609.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="699">
              <Value xsi:type="xsd:double">2.2304665370000002E5</Value>
              <FmtValue>$223,046.65</FmtValue>
            </Cell>
            <Cell CellOrdinal="700">
              <Value xsi:type="xsd:double">4.8420461550000013E5</Value>
              <FmtValue>$484,204.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="701">
              <Value xsi:type="xsd:double">5.356096779E5</Value>
              <FmtValue>$535,609.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="702">
              <Value xsi:type="xsd:double">4.2848772200000014E4</Value>
              <FmtValue>$42,848.77</FmtValue>
            </Cell>
            <Cell CellOrdinal="703">
              <Value xsi:type="xsd:double">1.3390253799999995E4</Value>
              <FmtValue>$13,390.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="704">
              <Value xsi:type="xsd:int">200</Value>
              <FmtValue>200</FmtValue>
            </Cell>
            <Cell CellOrdinal="705">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="706">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="707">
              <Value xsi:type="xsd:double">2.592563720881426E2</Value>
              <FmtValue>$259.26</FmtValue>
            </Cell>
            <Cell CellOrdinal="708">
              <Value xsi:type="xsd:double">2.6780483895E3</Value>
              <FmtValue>$2,678.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="709">
              <Value xsi:type="xsd:double">5.140506239999988E4</Value>
              <FmtValue>$51,405.06</FmtValue>
            </Cell>
            <Cell CellOrdinal="710">
              <Value xsi:type="xsd:double">9.597485729075523E-2</Value>
              <FmtValue>9.60%</FmtValue>
            </Cell>
            <Cell CellOrdinal="712">
              <Value xsi:type="xsd:double">5.6446577904533286E-2</Value>
              <FmtValue>5.64%</FmtValue>
            </Cell>
            <Cell CellOrdinal="713">
              <Value xsi:type="xsd:double">5.6446577904533286E-2</Value>
              <FmtValue>5.64%</FmtValue>
            </Cell>
            <Cell CellOrdinal="714">
              <Value xsi:type="xsd:int">2120</Value>
              <FmtValue>2,120</FmtValue>
            </Cell>
            <Cell CellOrdinal="715">
              <Value xsi:type="xsd:double">4.7304283720000006E5</Value>
              <FmtValue>$473,042.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="716">
              <Value xsi:type="xsd:double">1.968472351E5</Value>
              <FmtValue>$196,847.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="717">
              <Value xsi:type="xsd:double">4.233847106000001E5</Value>
              <FmtValue>$423,384.71</FmtValue>
            </Cell>
            <Cell CellOrdinal="718">
              <Value xsi:type="xsd:double">4.7304283720000006E5</Value>
              <FmtValue>$473,042.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="719">
              <Value xsi:type="xsd:double">3.78434257E4</Value>
              <FmtValue>$37,843.43</FmtValue>
            </Cell>
            <Cell CellOrdinal="720">
              <Value xsi:type="xsd:double">1.1826081899999997E4</Value>
              <FmtValue>$11,826.08</FmtValue>
            </Cell>
            <Cell CellOrdinal="721">
              <Value xsi:type="xsd:int">190</Value>
              <FmtValue>190</FmtValue>
            </Cell>
            <Cell CellOrdinal="722">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="723">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="724">
              <Value xsi:type="xsd:double">2.369773573593073E2</Value>
              <FmtValue>$236.98</FmtValue>
            </Cell>
            <Cell CellOrdinal="725">
              <Value xsi:type="xsd:double">2.489699143157895E3</Value>
              <FmtValue>$2,489.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="726">
              <Value xsi:type="xsd:double">4.965812659999996E4</Value>
              <FmtValue>$49,658.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="727">
              <Value xsi:type="xsd:double">1.049759613609893E-1</Value>
              <FmtValue>10.50%</FmtValue>
            </Cell>
            <Cell CellOrdinal="729">
              <Value xsi:type="xsd:double">5.6521724103739304E-2</Value>
              <FmtValue>5.65%</FmtValue>
            </Cell>
            <Cell CellOrdinal="730">
              <Value xsi:type="xsd:double">5.6521724103739304E-2</Value>
              <FmtValue>5.65%</FmtValue>
            </Cell>
            <Cell CellOrdinal="731">
              <Value xsi:type="xsd:int">2833</Value>
              <FmtValue>2,833</FmtValue>
            </Cell>
            <Cell CellOrdinal="732">
              <Value xsi:type="xsd:double">6.828711498999997E5</Value>
              <FmtValue>$682,871.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="733">
              <Value xsi:type="xsd:double">2.5440039390000002E5</Value>
              <FmtValue>$254,400.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="734">
              <Value xsi:type="xsd:double">6.221485197000001E5</Value>
              <FmtValue>$622,148.52</FmtValue>
            </Cell>
            <Cell CellOrdinal="735">
              <Value xsi:type="xsd:double">6.828113286999998E5</Value>
              <FmtValue>$682,811.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="736">
              <Value xsi:type="xsd:double">5.462490340000001E4</Value>
              <FmtValue>$54,624.90</FmtValue>
            </Cell>
            <Cell CellOrdinal="737">
              <Value xsi:type="xsd:double">1.707029719999999E4</Value>
              <FmtValue>$17,070.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="738">
              <Value xsi:type="xsd:int">155</Value>
              <FmtValue>155</FmtValue>
            </Cell>
            <Cell CellOrdinal="739">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="740">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="741">
              <Value xsi:type="xsd:double">2.4772037415630532E2</Value>
              <FmtValue>$247.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="742">
              <Value xsi:type="xsd:double">4.405234378709676E3</Value>
              <FmtValue>$4,405.23</FmtValue>
            </Cell>
            <Cell CellOrdinal="743">
              <Value xsi:type="xsd:double">6.0662808999999775E4</Value>
              <FmtValue>$60,662.81</FmtValue>
            </Cell>
            <Cell CellOrdinal="744">
              <Value xsi:type="xsd:double">8.88427102044357E-2</Value>
              <FmtValue>8.88%</FmtValue>
            </Cell>
            <Cell CellOrdinal="746">
              <Value xsi:type="xsd:double">8.831386184697394E-2</Value>
              <FmtValue>8.83%</FmtValue>
            </Cell>
            <Cell CellOrdinal="747">
              <Value xsi:type="xsd:double">8.831386184697394E-2</Value>
              <FmtValue>8.83%</FmtValue>
            </Cell>
            <Cell CellOrdinal="748">
              <Value xsi:type="xsd:int">4587</Value>
              <FmtValue>4,587</FmtValue>
            </Cell>
            <Cell CellOrdinal="749">
              <Value xsi:type="xsd:double">1.1475193436999994E6</Value>
              <FmtValue>$1,147,519.34</FmtValue>
            </Cell>
            <Cell CellOrdinal="750">
              <Value xsi:type="xsd:double">4.4169943920000025E5</Value>
              <FmtValue>$441,699.44</FmtValue>
            </Cell>
            <Cell CellOrdinal="751">
              <Value xsi:type="xsd:double">1.0459987862000001E6</Value>
              <FmtValue>$1,045,998.79</FmtValue>
            </Cell>
            <Cell CellOrdinal="752">
              <Value xsi:type="xsd:double">1.1475016443999991E6</Value>
              <FmtValue>$1,147,501.64</FmtValue>
            </Cell>
            <Cell CellOrdinal="753">
              <Value xsi:type="xsd:double">9.180012860000002E4</Value>
              <FmtValue>$91,800.13</FmtValue>
            </Cell>
            <Cell CellOrdinal="754">
              <Value xsi:type="xsd:double">2.8687565499999982E4</Value>
              <FmtValue>$28,687.57</FmtValue>
            </Cell>
            <Cell CellOrdinal="755">
              <Value xsi:type="xsd:int">279</Value>
              <FmtValue>279</FmtValue>
            </Cell>
            <Cell CellOrdinal="756">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="757">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="758">
              <Value xsi:type="xsd:double">2.5971790924234244E2</Value>
              <FmtValue>$259.72</FmtValue>
            </Cell>
            <Cell CellOrdinal="759">
              <Value xsi:type="xsd:double">4.112909119713258E3</Value>
              <FmtValue>$4,112.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="760">
              <Value xsi:type="xsd:double">1.0150285819999908E5</Value>
              <FmtValue>$101,502.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="761">
              <Value xsi:type="xsd:double">8.845552308822396E-2</Value>
              <FmtValue>8.85%</FmtValue>
            </Cell>
            <Cell CellOrdinal="763">
              <Value xsi:type="xsd:double">9.909519758954048E-2</Value>
              <FmtValue>9.91%</FmtValue>
            </Cell>
            <Cell CellOrdinal="764">
              <Value xsi:type="xsd:double">9.909519758954048E-2</Value>
              <FmtValue>9.91%</FmtValue>
            </Cell>
            <Cell CellOrdinal="765">
              <Value xsi:type="xsd:int">4442</Value>
              <FmtValue>4,442</FmtValue>
            </Cell>
            <Cell CellOrdinal="766">
              <Value xsi:type="xsd:double">1.0909368285999996E6</Value>
              <FmtValue>$1,090,936.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="767">
              <Value xsi:type="xsd:double">4.206609149000002E5</Value>
              <FmtValue>$420,660.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="768">
              <Value xsi:type="xsd:double">9.930644573000001E5</Value>
              <FmtValue>$993,064.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="769">
              <Value xsi:type="xsd:double">1.0906787015999995E6</Value>
              <FmtValue>$1,090,678.70</FmtValue>
            </Cell>
            <Cell CellOrdinal="770">
              <Value xsi:type="xsd:double">8.725429520000008E4</Value>
              <FmtValue>$87,254.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="771">
              <Value xsi:type="xsd:double">2.7266990500000003E4</Value>
              <FmtValue>$27,266.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="772">
              <Value xsi:type="xsd:int">255</Value>
              <FmtValue>255</FmtValue>
            </Cell>
            <Cell CellOrdinal="773">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="774">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="775">
              <Value xsi:type="xsd:double">2.5786790649132587E2</Value>
              <FmtValue>$257.87</FmtValue>
            </Cell>
            <Cell CellOrdinal="776">
              <Value xsi:type="xsd:double">4.277171378823527E3</Value>
              <FmtValue>$4,277.17</FmtValue>
            </Cell>
            <Cell CellOrdinal="777">
              <Value xsi:type="xsd:double">9.761424429999944E4</Value>
              <FmtValue>$97,614.24</FmtValue>
            </Cell>
            <Cell CellOrdinal="778">
              <Value xsi:type="xsd:double">8.949862517421646E-2</Value>
              <FmtValue>8.95%</FmtValue>
            </Cell>
            <Cell CellOrdinal="780">
              <Value xsi:type="xsd:double">1.1377734742789598E-1</Value>
              <FmtValue>11.38%</FmtValue>
            </Cell>
            <Cell CellOrdinal="781">
              <Value xsi:type="xsd:double">1.1377734742789598E-1</Value>
              <FmtValue>11.38%</FmtValue>
            </Cell>
            <Cell CellOrdinal="782">
              <Value xsi:type="xsd:int">4661</Value>
              <FmtValue>4,661</FmtValue>
            </Cell>
            <Cell CellOrdinal="783">
              <Value xsi:type="xsd:double">1.170190906999999E6</Value>
              <FmtValue>$1,170,190.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="784">
              <Value xsi:type="xsd:double">3.649674901000003E5</Value>
              <FmtValue>$364,967.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="785">
              <Value xsi:type="xsd:double">1.0808248195999995E6</Value>
              <FmtValue>$1,080,824.82</FmtValue>
            </Cell>
            <Cell CellOrdinal="786">
              <Value xsi:type="xsd:double">1.168454911199999E6</Value>
              <FmtValue>$1,168,454.91</FmtValue>
            </Cell>
            <Cell CellOrdinal="787">
              <Value xsi:type="xsd:double">9.347639159999999E4</Value>
              <FmtValue>$93,476.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="788">
              <Value xsi:type="xsd:double">2.92113909E4</Value>
              <FmtValue>$29,211.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="789">
              <Value xsi:type="xsd:int">161</Value>
              <FmtValue>161</FmtValue>
            </Cell>
            <Cell CellOrdinal="790">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="791">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="792">
              <Value xsi:type="xsd:double">2.5544949011627855E2</Value>
              <FmtValue>$255.45</FmtValue>
            </Cell>
            <Cell CellOrdinal="793">
              <Value xsi:type="xsd:double">7.2574839204968885E3</Value>
              <FmtValue>$7,257.48</FmtValue>
            </Cell>
            <Cell CellOrdinal="794">
              <Value xsi:type="xsd:double">8.763009159999946E4</Value>
              <FmtValue>$87,630.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="795">
              <Value xsi:type="xsd:double">7.499655379085503E-2</Value>
              <FmtValue>7.50%</FmtValue>
            </Cell>
            <Cell CellOrdinal="797">
              <Value xsi:type="xsd:double">1.5663078433274277E-1</Value>
              <FmtValue>15.66%</FmtValue>
            </Cell>
            <Cell CellOrdinal="798">
              <Value xsi:type="xsd:double">1.5663078433274277E-1</Value>
              <FmtValue>15.66%</FmtValue>
            </Cell>
            <Cell CellOrdinal="799">
              <Value xsi:type="xsd:int">7672</Value>
              <FmtValue>7,672</FmtValue>
            </Cell>
            <Cell CellOrdinal="800">
              <Value xsi:type="xsd:double">1.842987461100001E6</Value>
              <FmtValue>$1,842,987.46</FmtValue>
            </Cell>
            <Cell CellOrdinal="801">
              <Value xsi:type="xsd:double">6.393072481000009E5</Value>
              <FmtValue>$639,307.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="802">
              <Value xsi:type="xsd:double">1.6864799940999986E6</Value>
              <FmtValue>$1,686,479.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="803">
              <Value xsi:type="xsd:double">1.8420448460000008E6</Value>
              <FmtValue>$1,842,044.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="804">
              <Value xsi:type="xsd:double">1.4736358730000007E5</Value>
              <FmtValue>$147,363.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="805">
              <Value xsi:type="xsd:double">4.6051152900000015E4</Value>
              <FmtValue>$46,051.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="806">
              <Value xsi:type="xsd:int">332</Value>
              <FmtValue>332</FmtValue>
            </Cell>
            <Cell CellOrdinal="807">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="808">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="809">
              <Value xsi:type="xsd:double">2.5460606254572042E2</Value>
              <FmtValue>$254.61</FmtValue>
            </Cell>
            <Cell CellOrdinal="810">
              <Value xsi:type="xsd:double">5.548327849397593E3</Value>
              <FmtValue>$5,548.33</FmtValue>
            </Cell>
            <Cell CellOrdinal="811">
              <Value xsi:type="xsd:double">1.5556485190000222E5</Value>
              <FmtValue>$155,564.85</FmtValue>
            </Cell>
            <Cell CellOrdinal="812">
              <Value xsi:type="xsd:double">8.445226088703063E-2</Value>
              <FmtValue>8.45%</FmtValue>
            </Cell>
            <Cell CellOrdinal="814">
              <Value xsi:type="xsd:double">1.6370563776075994E-1</Value>
              <FmtValue>16.37%</FmtValue>
            </Cell>
            <Cell CellOrdinal="815">
              <Value xsi:type="xsd:double">1.6370563776075994E-1</Value>
              <FmtValue>16.37%</FmtValue>
            </Cell>
            <Cell CellOrdinal="816">
              <Value xsi:type="xsd:int">7181</Value>
              <FmtValue>7,181</FmtValue>
            </Cell>
            <Cell CellOrdinal="817">
              <Value xsi:type="xsd:double">1.6963031882999995E6</Value>
              <FmtValue>$1,696,303.19</FmtValue>
            </Cell>
            <Cell CellOrdinal="818">
              <Value xsi:type="xsd:double">5.694709829000003E5</Value>
              <FmtValue>$569,470.98</FmtValue>
            </Cell>
            <Cell CellOrdinal="819">
              <Value xsi:type="xsd:double">1.554415801299999E6</Value>
              <FmtValue>$1,554,415.80</FmtValue>
            </Cell>
            <Cell CellOrdinal="820">
              <Value xsi:type="xsd:double">1.6946239902999994E6</Value>
              <FmtValue>$1,694,623.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="821">
              <Value xsi:type="xsd:double">1.3556992080000008E5</Value>
              <FmtValue>$135,569.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="822">
              <Value xsi:type="xsd:double">4.2365631599999986E4</Value>
              <FmtValue>$42,365.63</FmtValue>
            </Cell>
            <Cell CellOrdinal="823">
              <Value xsi:type="xsd:int">289</Value>
              <FmtValue>289</FmtValue>
            </Cell>
            <Cell CellOrdinal="824">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="825">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="826">
              <Value xsi:type="xsd:double">2.4793259043062164E2</Value>
              <FmtValue>$247.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="827">
              <Value xsi:type="xsd:double">5.863750831487888E3</Value>
              <FmtValue>$5,863.75</FmtValue>
            </Cell>
            <Cell CellOrdinal="828">
              <Value xsi:type="xsd:double">1.4020818900000048E5</Value>
              <FmtValue>$140,208.19</FmtValue>
            </Cell>
            <Cell CellOrdinal="829">
              <Value xsi:type="xsd:double">8.273704951809363E-2</Value>
              <FmtValue>8.27%</FmtValue>
            </Cell>
            <Cell CellOrdinal="831">
              <Value xsi:type="xsd:double">1.7059689452598212E-1</Value>
              <FmtValue>17.06%</FmtValue>
            </Cell>
            <Cell CellOrdinal="832">
              <Value xsi:type="xsd:double">1.7059689452598212E-1</Value>
              <FmtValue>17.06%</FmtValue>
            </Cell>
            <Cell CellOrdinal="833">
              <Value xsi:type="xsd:int">2864</Value>
              <FmtValue>2,864</FmtValue>
            </Cell>
            <Cell CellOrdinal="834">
              <Value xsi:type="xsd:double">6.460909261999992E5</Value>
              <FmtValue>$646,090.93</FmtValue>
            </Cell>
            <Cell CellOrdinal="835">
              <Value xsi:type="xsd:double">2.3606721060000005E5</Value>
              <FmtValue>$236,067.21</FmtValue>
            </Cell>
            <Cell CellOrdinal="836">
              <Value xsi:type="xsd:double">5.875087858000003E5</Value>
              <FmtValue>$587,508.79</FmtValue>
            </Cell>
            <Cell CellOrdinal="837">
              <Value xsi:type="xsd:double">6.457989660999991E5</Value>
              <FmtValue>$645,798.97</FmtValue>
            </Cell>
            <Cell CellOrdinal="838">
              <Value xsi:type="xsd:double">5.1663916700000045E4</Value>
              <FmtValue>$51,663.92</FmtValue>
            </Cell>
            <Cell CellOrdinal="839">
              <Value xsi:type="xsd:double">1.6144987800000002E4</Value>
              <FmtValue>$16,144.99</FmtValue>
            </Cell>
            <Cell CellOrdinal="840">
              <Value xsi:type="xsd:int">152</Value>
              <FmtValue>152</FmtValue>
            </Cell>
            <Cell CellOrdinal="841">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="842">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="843">
              <Value xsi:type="xsd:double">2.388275662062613E2</Value>
              <FmtValue>$238.83</FmtValue>
            </Cell>
            <Cell CellOrdinal="844">
              <Value xsi:type="xsd:double">4.248677408552626E3</Value>
              <FmtValue>$4,248.68</FmtValue>
            </Cell>
            <Cell CellOrdinal="845">
              <Value xsi:type="xsd:double">5.829018029999884E4</Value>
              <FmtValue>$58,290.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="846">
              <Value xsi:type="xsd:double">9.02605661511277E-2</Value>
              <FmtValue>9.03%</FmtValue>
            </Cell>
            <Cell CellOrdinal="848">
              <Value xsi:type="xsd:double">9.307927914740307E-2</Value>
              <FmtValue>9.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="849">
              <Value xsi:type="xsd:double">9.307927914740307E-2</Value>
              <FmtValue>9.31%</FmtValue>
            </Cell>
            <Cell CellOrdinal="850">
              <Value xsi:type="xsd:int">4795</Value>
              <FmtValue>4,795</FmtValue>
            </Cell>
            <Cell CellOrdinal="851">
              <Value xsi:type="xsd:double">1.177803561E6</Value>
              <FmtValue>$1,177,803.56</FmtValue>
            </Cell>
            <Cell CellOrdinal="852">
              <Value xsi:type="xsd:double">4.4040916040000016E5</Value>
              <FmtValue>$440,409.16</FmtValue>
            </Cell>
            <Cell CellOrdinal="853">
              <Value xsi:type="xsd:double">1.0717920500999996E6</Value>
              <FmtValue>$1,071,792.05</FmtValue>
            </Cell>
            <Cell CellOrdinal="854">
              <Value xsi:type="xsd:double">1.1776638166999998E6</Value>
              <FmtValue>$1,177,663.82</FmtValue>
            </Cell>
            <Cell CellOrdinal="855">
              <Value xsi:type="xsd:double">9.42131071E4</Value>
              <FmtValue>$94,213.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="856">
              <Value xsi:type="xsd:double">2.944162109999999E4</Value>
              <FmtValue>$29,441.62</FmtValue>
            </Cell>
            <Cell CellOrdinal="857">
              <Value xsi:type="xsd:int">279</Value>
              <FmtValue>279</FmtValue>
            </Cell>
            <Cell CellOrdinal="858">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="859">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="860">
              <Value xsi:type="xsd:double">2.5489487409162672E2</Value>
              <FmtValue>$254.89</FmtValue>
            </Cell>
            <Cell CellOrdinal="861">
              <Value xsi:type="xsd:double">4.2210172641577055E3</Value>
              <FmtValue>$4,221.02</FmtValue>
            </Cell>
            <Cell CellOrdinal="862">
              <Value xsi:type="xsd:double">1.058717666000002E5</Value>
              <FmtValue>$105,871.77</FmtValue>
            </Cell>
            <Cell CellOrdinal="863">
              <Value xsi:type="xsd:double">8.989982123817783E-2</Value>
              <FmtValue>8.99%</FmtValue>
            </Cell>
            <Cell CellOrdinal="865">
              <Value xsi:type="xsd:double">1.0767523982749748E-1</Value>
              <FmtValue>10.77%</FmtValue>
            </Cell>
            <Cell CellOrdinal="866">
              <Value xsi:type="xsd:double">1.0767523982749748E-1</Value>
              <FmtValue>10.77%</FmtValue>
            </Cell>
            <Cell CellOrdinal="867">
              <Value xsi:type="xsd:int">4437</Value>
              <FmtValue>4,437</FmtValue>
            </Cell>
            <Cell CellOrdinal="868">
              <Value xsi:type="xsd:double">1.0579653895E6</Value>
              <FmtValue>$1,057,965.39</FmtValue>
            </Cell>
            <Cell CellOrdinal="869">
              <Value xsi:type="xsd:double">3.918664909000001E5</Value>
              <FmtValue>$391,866.49</FmtValue>
            </Cell>
            <Cell CellOrdinal="870">
              <Value xsi:type="xsd:double">9.591365926000004E5</Value>
              <FmtValue>$959,136.59</FmtValue>
            </Cell>
            <Cell CellOrdinal="871">
              <Value xsi:type="xsd:double">1.0578888644E6</Value>
              <FmtValue>$1,057,888.86</FmtValue>
            </Cell>
            <Cell CellOrdinal="872">
              <Value xsi:type="xsd:double">8.463110929999998E4</Value>
              <FmtValue>$84,631.11</FmtValue>
            </Cell>
            <Cell CellOrdinal="873">
              <Value xsi:type="xsd:double">2.644724539999999E4</Value>
              <FmtValue>$26,447.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="874">
              <Value xsi:type="xsd:int">257</Value>
              <FmtValue>257</FmtValue>
            </Cell>
            <Cell CellOrdinal="875">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="876">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="877">
              <Value xsi:type="xsd:double">2.497089839999998E2</Value>
              <FmtValue>$249.71</FmtValue>
            </Cell>
            <Cell CellOrdinal="878">
              <Value xsi:type="xsd:double">4.116299083268483E3</Value>
              <FmtValue>$4,116.30</FmtValue>
            </Cell>
            <Cell CellOrdinal="879">
              <Value xsi:type="xsd:double">9.875227179999964E4</Value>
              <FmtValue>$98,752.27</FmtValue>
            </Cell>
            <Cell CellOrdinal="880">
              <Value xsi:type="xsd:double">9.334843680012521E-2</Value>
              <FmtValue>9.33%</FmtValue>
            </Cell>
            <Cell CellOrdinal="882">
              <Value xsi:type="xsd:double">1.0110049117579146E-1</Value>
              <FmtValue>10.11%</FmtValue>
            </Cell>
            <Cell CellOrdinal="883">
              <Value xsi:type="xsd:double">1.0110049117579146E-1</Value>
              <FmtValue>10.11%</FmtValue>
            </Cell>
          </CellData>
        </root>
      </return>
    </ExecuteResponse>
  </soap:Body>
</soap:Envelope>
"""),
    ],
    "testNoAxesButOneCell":[
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Execute>
      <Command>
        <Statement>select from [Sales Summary]</Statement>
      </Command>
      <Properties>
        <PropertyList>
          <Format>Multidimensional</Format>
          <AxisFormat>TupleFormat</AxisFormat>
          <Catalog>Adventure Works DW 2008R2</Catalog>
        </PropertyList>
      </Properties>
    </Execute>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
  <soap:Body>
    <ExecuteResponse xmlns="urn:schemas-microsoft-com:xml-analysis">
      <return>
        <root xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla">
          <xs:schema xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla" targetNamespace="urn:schemas-microsoft-com:xml-analysis:mddataset" elementFormDefault="qualified">
            <xs:import namespace="http://schemas.microsoft.com/analysisservices/2003/xmla"/>
            <xs:complexType name="MemberType">
              <xs:sequence>
                <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string"/>
            </xs:complexType>
            <xs:complexType name="PropType">
              <xs:sequence>
                <xs:element name="Default" minOccurs="0"/>
              </xs:sequence>
              <xs:attribute name="name" type="xs:string" use="required"/>
              <xs:attribute name="type" type="xs:QName"/>
            </xs:complexType>
            <xs:complexType name="TupleType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="MembersType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string" use="required"/>
            </xs:complexType>
            <xs:complexType name="TuplesType">
              <xs:sequence>
                <xs:element name="Tuple" type="TupleType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:group name="SetType">
              <xs:choice>
                <xs:element name="Members" type="MembersType"/>
                <xs:element name="Tuples" type="TuplesType"/>
                <xs:element name="CrossProduct" type="SetListType"/>
                <xs:element ref="msxmla:NormTupleSet"/>
                <xs:element name="Union">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                  </xs:complexType>
                </xs:element>
              </xs:choice>
            </xs:group>
            <xs:complexType name="SetListType">
              <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
              <xs:attribute name="Size" type="xs:unsignedInt"/>
            </xs:complexType>
            <xs:complexType name="OlapInfo">
              <xs:sequence>
                <xs:element name="CubeInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="Cube" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="CubeName" type="xs:string"/>
                            <xs:element name="LastDataUpdate" minOccurs="0" type="xs:dateTime"/>
                            <xs:element name="LastSchemaUpdate" minOccurs="0" type="xs:dateTime"/>
                          </xs:sequence>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="AxesInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="AxisInfo" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="HierarchyInfo" minOccurs="0" maxOccurs="unbounded">
                              <xs:complexType>
                                <xs:sequence>
                                  <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                                </xs:sequence>
                                <xs:attribute name="name" type="xs:string" use="required"/>
                              </xs:complexType>
                            </xs:element>
                          </xs:sequence>
                          <xs:attribute name="name" type="xs:string"/>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="CellInfo">
                  <xs:complexType>
                    <xs:choice minOccurs="0" maxOccurs="unbounded">
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:choice>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="Axes">
              <xs:sequence>
                <xs:element name="Axis" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                    <xs:attribute name="name" type="xs:string"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="CellData">
              <xs:sequence>
                <xs:element name="Cell" minOccurs="0" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:sequence>
                    <xs:attribute name="CellOrdinal" type="xs:unsignedInt" use="required"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:element name="root">
              <xs:complexType>
                <xs:sequence>
                  <xs:any namespace="http://www.w3.org/2001/XMLSchema" processContents="strict" minOccurs="0"/>
                  <xs:element name="OlapInfo" type="OlapInfo" minOccurs="0"/>
                  <xs:element name="Axes" type="Axes" minOccurs="0"/>
                  <xs:element name="CellData" type="CellData" minOccurs="0"/>
                </xs:sequence>
              </xs:complexType>
            </xs:element>
          </xs:schema>
          <OlapInfo>
            <CubeInfo>
              <Cube>
                <CubeName>Sales Summary</CubeName>
                <LastDataUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-24T11:57:43.523333</LastDataUpdate>
                <LastSchemaUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-23T23:01:05.413333</LastSchemaUpdate>
              </Cube>
            </CubeInfo>
            <AxesInfo>
              <AxisInfo name="SlicerAxis">
                <HierarchyInfo name="[Measures]">
                  <UName name="[Measures].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Measures].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Measures].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Measures].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Measures].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal]">
                  <UName name="[Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar]">
                  <UName name="[Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Weeks]">
                  <UName name="[Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Weeks]">
                  <UName name="[Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Year]">
                  <UName name="[Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Date]">
                  <UName name="[Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Week]">
                  <UName name="[Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day Name]">
                  <UName name="[Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Month]">
                  <UName name="[Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Year]">
                  <UName name="[Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Year]">
                  <UName name="[Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Semester of Year]">
                  <UName name="[Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Semester of Year]">
                  <UName name="[Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Quarter of Year]">
                  <UName name="[Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Quarter of Year]">
                  <UName name="[Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Month of Year]">
                  <UName name="[Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Week of Year]">
                  <UName name="[Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Week of Year]">
                  <UName name="[Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal]">
                  <UName name="[Ship Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar]">
                  <UName name="[Ship Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Weeks]">
                  <UName name="[Ship Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Weeks]">
                  <UName name="[Ship Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Year]">
                  <UName name="[Ship Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Date]">
                  <UName name="[Ship Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Week]">
                  <UName name="[Ship Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day Name]">
                  <UName name="[Ship Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Month]">
                  <UName name="[Ship Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Year]">
                  <UName name="[Ship Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Year]">
                  <UName name="[Ship Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Semester of Year]">
                  <UName name="[Ship Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Semester of Year]">
                  <UName name="[Ship Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Quarter of Year]">
                  <UName name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Quarter of Year]">
                  <UName name="[Ship Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Month of Year]">
                  <UName name="[Ship Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Week of Year]">
                  <UName name="[Ship Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Week of Year]">
                  <UName name="[Ship Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal]">
                  <UName name="[Delivery Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar]">
                  <UName name="[Delivery Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Weeks]">
                  <UName name="[Delivery Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Weeks]">
                  <UName name="[Delivery Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Year]">
                  <UName name="[Delivery Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Date]">
                  <UName name="[Delivery Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Week]">
                  <UName name="[Delivery Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day Name]">
                  <UName name="[Delivery Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Month]">
                  <UName name="[Delivery Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Year]">
                  <UName name="[Delivery Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Year]">
                  <UName name="[Delivery Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Semester of Year]">
                  <UName name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Semester of Year]">
                  <UName name="[Delivery Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Quarter of Year]">
                  <UName name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Quarter of Year]">
                  <UName name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Month of Year]">
                  <UName name="[Delivery Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Week of Year]">
                  <UName name="[Delivery Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Week of Year]">
                  <UName name="[Delivery Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotions]">
                  <UName name="[Promotion].[Promotions].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotions].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotions].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotions].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotions].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion]">
                  <UName name="[Promotion].[Promotion].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Discount Percent]">
                  <UName name="[Promotion].[Discount Percent].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Discount Percent].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Discount Percent].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Discount Percent].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Discount Percent].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Max Quantity]">
                  <UName name="[Promotion].[Max Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Max Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Max Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Max Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Max Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Type]">
                  <UName name="[Promotion].[Promotion Type].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Type].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Type].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Type].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Type].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Min Quantity]">
                  <UName name="[Promotion].[Min Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Min Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Min Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Min Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Min Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Category]">
                  <UName name="[Promotion].[Promotion Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[End Date]">
                  <UName name="[Promotion].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Start Date]">
                  <UName name="[Promotion].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Categories]">
                  <UName name="[Product].[Product Categories].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Categories].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Categories].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Categories].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Categories].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Model Lines]">
                  <UName name="[Product].[Product Model Lines].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Model Lines].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Model Lines].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Model Lines].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Model Lines].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Stock Level]">
                  <UName name="[Product].[Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product]">
                  <UName name="[Product].[Product].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Standard Cost]">
                  <UName name="[Product].[Standard Cost].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Standard Cost].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Standard Cost].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Standard Cost].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Standard Cost].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Category]">
                  <UName name="[Product].[Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Color]">
                  <UName name="[Product].[Color].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Color].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Color].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Color].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Color].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Safety Stock Level]">
                  <UName name="[Product].[Safety Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Safety Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Safety Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Safety Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Safety Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Reorder Point]">
                  <UName name="[Product].[Reorder Point].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Reorder Point].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Reorder Point].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Reorder Point].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Reorder Point].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[List Price]">
                  <UName name="[Product].[List Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[List Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[List Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[List Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[List Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size]">
                  <UName name="[Product].[Size].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size Range]">
                  <UName name="[Product].[Size Range].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size Range].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size Range].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size Range].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size Range].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Weight]">
                  <UName name="[Product].[Weight].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Weight].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Weight].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Weight].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Weight].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Days to Manufacture]">
                  <UName name="[Product].[Days to Manufacture].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Days to Manufacture].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Days to Manufacture].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Days to Manufacture].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Days to Manufacture].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Dealer Price]">
                  <UName name="[Product].[Dealer Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Dealer Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Dealer Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Dealer Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Dealer Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Class]">
                  <UName name="[Product].[Class].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Class].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Class].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Class].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Class].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Style]">
                  <UName name="[Product].[Style].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Style].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Style].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Style].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Style].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Model Name]">
                  <UName name="[Product].[Model Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Model Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Model Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Model Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Model Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Line]">
                  <UName name="[Product].[Product Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Subcategory]">
                  <UName name="[Product].[Subcategory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Subcategory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Subcategory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Subcategory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Subcategory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Status]">
                  <UName name="[Product].[Status].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Status].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Status].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Status].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Status].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Start Date]">
                  <UName name="[Product].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[End Date]">
                  <UName name="[Product].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Large Photo]">
                  <UName name="[Product].[Large Photo].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Large Photo].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Large Photo].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Large Photo].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Large Photo].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory]">
                  <UName name="[Sales Territory].[Sales Territory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Region]">
                  <UName name="[Sales Territory].[Sales Territory Region].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Region].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Region].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Region].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Region].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Country]">
                  <UName name="[Sales Territory].[Sales Territory Country].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Country].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Country].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Country].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Country].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Group]">
                  <UName name="[Sales Territory].[Sales Territory Group].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Group].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Group].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Group].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Group].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Orders]">
                  <UName name="[Sales Summary Order Details].[Sales Orders].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Orders].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Orders].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Orders].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Orders].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Carrier Tracking Number]">
                  <UName name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Carrier Tracking Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Customer PO Number]">
                  <UName name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Customer PO Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Number]">
                  <UName name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Line]">
                  <UName name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency Code]">
                  <UName name="[Source Currency].[Source Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency]">
                  <UName name="[Source Currency].[Source Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency]">
                  <UName name="[Destination Currency].[Destination Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency Code]">
                  <UName name="[Destination Currency].[Destination Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Channel].[Sales Channel]">
                  <UName name="[Sales Channel].[Sales Channel].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Channel].[Sales Channel].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Channel].[Sales Channel].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Channel].[Sales Channel].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Channel].[Sales Channel].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
            </AxesInfo>
            <CellInfo>
              <Value name="VALUE"/>
              <FmtValue name="FORMATTED_VALUE" type="xsd:string"/>
              <CellOrdinal name="CELL_ORDINAL" type="xsd:unsignedInt"/>
            </CellInfo>
          </OlapInfo>
          <Axes>
            <Axis name="SlicerAxis">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal]">
                    <UName>[Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar]">
                    <UName>[Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Weeks]">
                    <UName>[Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Weeks]">
                    <UName>[Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Year]">
                    <UName>[Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Date]">
                    <UName>[Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Week]">
                    <UName>[Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day Name]">
                    <UName>[Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Month]">
                    <UName>[Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Year]">
                    <UName>[Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Year]">
                    <UName>[Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Semester of Year]">
                    <UName>[Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Semester of Year]">
                    <UName>[Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Quarter of Year]">
                    <UName>[Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Quarter of Year]">
                    <UName>[Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Week of Year]">
                    <UName>[Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Week of Year]">
                    <UName>[Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal]">
                    <UName>[Ship Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar]">
                    <UName>[Ship Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Weeks]">
                    <UName>[Ship Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Weeks]">
                    <UName>[Ship Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Year]">
                    <UName>[Ship Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Date]">
                    <UName>[Ship Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Week]">
                    <UName>[Ship Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day Name]">
                    <UName>[Ship Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Month]">
                    <UName>[Ship Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Year]">
                    <UName>[Ship Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Year]">
                    <UName>[Ship Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Semester of Year]">
                    <UName>[Ship Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Semester of Year]">
                    <UName>[Ship Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Quarter of Year]">
                    <UName>[Ship Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Quarter of Year]">
                    <UName>[Ship Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Month of Year]">
                    <UName>[Ship Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Week of Year]">
                    <UName>[Ship Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Week of Year]">
                    <UName>[Ship Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal]">
                    <UName>[Delivery Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar]">
                    <UName>[Delivery Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Weeks]">
                    <UName>[Delivery Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Weeks]">
                    <UName>[Delivery Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Year]">
                    <UName>[Delivery Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Date]">
                    <UName>[Delivery Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Week]">
                    <UName>[Delivery Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day Name]">
                    <UName>[Delivery Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Month]">
                    <UName>[Delivery Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Year]">
                    <UName>[Delivery Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Year]">
                    <UName>[Delivery Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Semester of Year]">
                    <UName>[Delivery Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Semester of Year]">
                    <UName>[Delivery Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Quarter of Year]">
                    <UName>[Delivery Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Quarter of Year]">
                    <UName>[Delivery Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Month of Year]">
                    <UName>[Delivery Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Week of Year]">
                    <UName>[Delivery Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Week of Year]">
                    <UName>[Delivery Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotions]">
                    <UName>[Promotion].[Promotions].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotions].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion]">
                    <UName>[Promotion].[Promotion].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>16</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Discount Percent]">
                    <UName>[Promotion].[Discount Percent].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Discount Percent].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Max Quantity]">
                    <UName>[Promotion].[Max Quantity].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Max Quantity].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion Type]">
                    <UName>[Promotion].[Promotion Type].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion Type].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Min Quantity]">
                    <UName>[Promotion].[Min Quantity].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Min Quantity].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion Category]">
                    <UName>[Promotion].[Promotion Category].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion Category].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>3</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[End Date]">
                    <UName>[Promotion].[End Date].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[End Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Start Date]">
                    <UName>[Promotion].[Start Date].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Start Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>8</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Categories].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Model Lines]">
                    <UName>[Product].[Product Model Lines].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Model Lines].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Stock Level]">
                    <UName>[Product].[Stock Level].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Stock Level].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product]">
                    <UName>[Product].[Product].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>397</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Standard Cost]">
                    <UName>[Product].[Standard Cost].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Standard Cost].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>135</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Category]">
                    <UName>[Product].[Category].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Category].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Color]">
                    <UName>[Product].[Color].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Color].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Safety Stock Level]">
                    <UName>[Product].[Safety Stock Level].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Safety Stock Level].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Reorder Point]">
                    <UName>[Product].[Reorder Point].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Reorder Point].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[List Price]">
                    <UName>[Product].[List Price].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[List Price].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>121</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Size]">
                    <UName>[Product].[Size].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Size].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>19</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Size Range]">
                    <UName>[Product].[Size Range].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Size Range].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>11</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Weight]">
                    <UName>[Product].[Weight].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Weight].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>128</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Days to Manufacture]">
                    <UName>[Product].[Days to Manufacture].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Days to Manufacture].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Dealer Price]">
                    <UName>[Product].[Dealer Price].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Dealer Price].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>121</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Class]">
                    <UName>[Product].[Class].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Class].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Style]">
                    <UName>[Product].[Style].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Style].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Model Name]">
                    <UName>[Product].[Model Name].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Model Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>120</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Line]">
                    <UName>[Product].[Product Line].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Line].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Subcategory]">
                    <UName>[Product].[Subcategory].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Subcategory].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>37</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Status]">
                    <UName>[Product].[Status].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Status].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Start Date]">
                    <UName>[Product].[Start Date].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Start Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[End Date]">
                    <UName>[Product].[End Date].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[End Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>3</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Large Photo]">
                    <UName>[Product].[Large Photo].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Large Photo].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>606</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory]">
                    <UName>[Sales Territory].[Sales Territory].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Region]">
                    <UName>[Sales Territory].[Sales Territory Region].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Region].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>11</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Country]">
                    <UName>[Sales Territory].[Sales Territory Country].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Country].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Group]">
                    <UName>[Sales Territory].[Sales Territory Group].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Group].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Orders]">
                    <UName>[Sales Summary Order Details].[Sales Orders].[All]</UName>
                    <Caption>All</Caption>
                    <LName>[Sales Summary Order Details].[Sales Orders].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Carrier Tracking Number]">
                    <UName>[Sales Summary Order Details].[Carrier Tracking Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Carrier Tracking Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Customer PO Number]">
                    <UName>[Sales Summary Order Details].[Customer PO Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Customer PO Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Order Number]">
                    <UName>[Sales Summary Order Details].[Sales Order Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Sales Order Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Order Line]">
                    <UName>[Sales Summary Order Details].[Sales Order Line].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Sales Order Line].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Source Currency].[Source Currency Code]">
                    <UName>[Source Currency].[Source Currency Code].[All Source Currencies]</UName>
                    <Caption>All Source Currencies</Caption>
                    <LName>[Source Currency].[Source Currency Code].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>105</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Source Currency].[Source Currency]">
                    <UName>[Source Currency].[Source Currency].[All Source Currencies]</UName>
                    <Caption>All Source Currencies</Caption>
                    <LName>[Source Currency].[Source Currency].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>105</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Destination Currency].[Destination Currency]">
                    <UName>[Destination Currency].[Destination Currency].&amp;[US Dollar]</UName>
                    <Caption>US Dollar</Caption>
                    <LName>[Destination Currency].[Destination Currency].[Destination Currency]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Destination Currency].[Destination Currency Code]">
                    <UName>[Destination Currency].[Destination Currency Code].[All Destination Currencies]</UName>
                    <Caption>All Destination Currencies</Caption>
                    <LName>[Destination Currency].[Destination Currency Code].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>14</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Channel].[Sales Channel]">
                    <UName>[Sales Channel].[Sales Channel].[All Sales Channels]</UName>
                    <Caption>All Sales Channels</Caption>
                    <LName>[Sales Channel].[Sales Channel].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
          </Axes>
          <CellData>
            <Cell CellOrdinal="0">
              <Value xsi:type="xsd:double">1.0980927420300156E8</Value>
              <FmtValue>$109,809,274.20</FmtValue>
            </Cell>
          </CellData>
        </root>
      </return>
    </ExecuteResponse>
  </soap:Body>
</soap:Envelope>
"""),
    ],
    "testOneDimensional":[
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Execute>
      <Command>
        <Statement>select [Measures].ALLMEMBERS on columns from [Sales Summary]</Statement>
      </Command>
      <Properties>
        <PropertyList>
          <Format>Multidimensional</Format>
          <AxisFormat>TupleFormat</AxisFormat>
          <Catalog>Adventure Works DW 2008R2</Catalog>
        </PropertyList>
      </Properties>
    </Execute>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
  <soap:Body>
    <ExecuteResponse xmlns="urn:schemas-microsoft-com:xml-analysis">
      <return>
        <root xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla">
          <xs:schema xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla" targetNamespace="urn:schemas-microsoft-com:xml-analysis:mddataset" elementFormDefault="qualified">
            <xs:import namespace="http://schemas.microsoft.com/analysisservices/2003/xmla"/>
            <xs:complexType name="MemberType">
              <xs:sequence>
                <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string"/>
            </xs:complexType>
            <xs:complexType name="PropType">
              <xs:sequence>
                <xs:element name="Default" minOccurs="0"/>
              </xs:sequence>
              <xs:attribute name="name" type="xs:string" use="required"/>
              <xs:attribute name="type" type="xs:QName"/>
            </xs:complexType>
            <xs:complexType name="TupleType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="MembersType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string" use="required"/>
            </xs:complexType>
            <xs:complexType name="TuplesType">
              <xs:sequence>
                <xs:element name="Tuple" type="TupleType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:group name="SetType">
              <xs:choice>
                <xs:element name="Members" type="MembersType"/>
                <xs:element name="Tuples" type="TuplesType"/>
                <xs:element name="CrossProduct" type="SetListType"/>
                <xs:element ref="msxmla:NormTupleSet"/>
                <xs:element name="Union">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                  </xs:complexType>
                </xs:element>
              </xs:choice>
            </xs:group>
            <xs:complexType name="SetListType">
              <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
              <xs:attribute name="Size" type="xs:unsignedInt"/>
            </xs:complexType>
            <xs:complexType name="OlapInfo">
              <xs:sequence>
                <xs:element name="CubeInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="Cube" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="CubeName" type="xs:string"/>
                            <xs:element name="LastDataUpdate" minOccurs="0" type="xs:dateTime"/>
                            <xs:element name="LastSchemaUpdate" minOccurs="0" type="xs:dateTime"/>
                          </xs:sequence>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="AxesInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="AxisInfo" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="HierarchyInfo" minOccurs="0" maxOccurs="unbounded">
                              <xs:complexType>
                                <xs:sequence>
                                  <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                                </xs:sequence>
                                <xs:attribute name="name" type="xs:string" use="required"/>
                              </xs:complexType>
                            </xs:element>
                          </xs:sequence>
                          <xs:attribute name="name" type="xs:string"/>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="CellInfo">
                  <xs:complexType>
                    <xs:choice minOccurs="0" maxOccurs="unbounded">
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:choice>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="Axes">
              <xs:sequence>
                <xs:element name="Axis" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                    <xs:attribute name="name" type="xs:string"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="CellData">
              <xs:sequence>
                <xs:element name="Cell" minOccurs="0" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:sequence>
                    <xs:attribute name="CellOrdinal" type="xs:unsignedInt" use="required"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:element name="root">
              <xs:complexType>
                <xs:sequence>
                  <xs:any namespace="http://www.w3.org/2001/XMLSchema" processContents="strict" minOccurs="0"/>
                  <xs:element name="OlapInfo" type="OlapInfo" minOccurs="0"/>
                  <xs:element name="Axes" type="Axes" minOccurs="0"/>
                  <xs:element name="CellData" type="CellData" minOccurs="0"/>
                </xs:sequence>
              </xs:complexType>
            </xs:element>
          </xs:schema>
          <OlapInfo>
            <CubeInfo>
              <Cube>
                <CubeName>Sales Summary</CubeName>
                <LastDataUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-24T11:57:43.523333</LastDataUpdate>
                <LastSchemaUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-23T23:01:05.413333</LastSchemaUpdate>
              </Cube>
            </CubeInfo>
            <AxesInfo>
              <AxisInfo name="Axis0">
                <HierarchyInfo name="[Measures]">
                  <UName name="[Measures].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Measures].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Measures].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Measures].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Measures].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
              <AxisInfo name="SlicerAxis">
                <HierarchyInfo name="[Date].[Fiscal]">
                  <UName name="[Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar]">
                  <UName name="[Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Weeks]">
                  <UName name="[Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Weeks]">
                  <UName name="[Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Year]">
                  <UName name="[Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Date]">
                  <UName name="[Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Week]">
                  <UName name="[Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day Name]">
                  <UName name="[Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Month]">
                  <UName name="[Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Year]">
                  <UName name="[Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Year]">
                  <UName name="[Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Semester of Year]">
                  <UName name="[Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Semester of Year]">
                  <UName name="[Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Quarter of Year]">
                  <UName name="[Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Quarter of Year]">
                  <UName name="[Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Month of Year]">
                  <UName name="[Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Week of Year]">
                  <UName name="[Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Week of Year]">
                  <UName name="[Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal]">
                  <UName name="[Ship Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar]">
                  <UName name="[Ship Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Weeks]">
                  <UName name="[Ship Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Weeks]">
                  <UName name="[Ship Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Year]">
                  <UName name="[Ship Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Date]">
                  <UName name="[Ship Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Week]">
                  <UName name="[Ship Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day Name]">
                  <UName name="[Ship Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Month]">
                  <UName name="[Ship Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Year]">
                  <UName name="[Ship Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Year]">
                  <UName name="[Ship Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Semester of Year]">
                  <UName name="[Ship Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Semester of Year]">
                  <UName name="[Ship Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Quarter of Year]">
                  <UName name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Quarter of Year]">
                  <UName name="[Ship Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Month of Year]">
                  <UName name="[Ship Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Week of Year]">
                  <UName name="[Ship Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Week of Year]">
                  <UName name="[Ship Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal]">
                  <UName name="[Delivery Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar]">
                  <UName name="[Delivery Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Weeks]">
                  <UName name="[Delivery Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Weeks]">
                  <UName name="[Delivery Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Year]">
                  <UName name="[Delivery Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Date]">
                  <UName name="[Delivery Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Week]">
                  <UName name="[Delivery Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day Name]">
                  <UName name="[Delivery Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Month]">
                  <UName name="[Delivery Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Year]">
                  <UName name="[Delivery Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Year]">
                  <UName name="[Delivery Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Semester of Year]">
                  <UName name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Semester of Year]">
                  <UName name="[Delivery Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Quarter of Year]">
                  <UName name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Quarter of Year]">
                  <UName name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Month of Year]">
                  <UName name="[Delivery Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Week of Year]">
                  <UName name="[Delivery Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Week of Year]">
                  <UName name="[Delivery Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotions]">
                  <UName name="[Promotion].[Promotions].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotions].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotions].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotions].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotions].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion]">
                  <UName name="[Promotion].[Promotion].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Discount Percent]">
                  <UName name="[Promotion].[Discount Percent].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Discount Percent].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Discount Percent].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Discount Percent].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Discount Percent].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Max Quantity]">
                  <UName name="[Promotion].[Max Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Max Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Max Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Max Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Max Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Type]">
                  <UName name="[Promotion].[Promotion Type].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Type].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Type].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Type].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Type].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Min Quantity]">
                  <UName name="[Promotion].[Min Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Min Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Min Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Min Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Min Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Category]">
                  <UName name="[Promotion].[Promotion Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[End Date]">
                  <UName name="[Promotion].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Start Date]">
                  <UName name="[Promotion].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Categories]">
                  <UName name="[Product].[Product Categories].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Categories].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Categories].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Categories].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Categories].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Model Lines]">
                  <UName name="[Product].[Product Model Lines].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Model Lines].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Model Lines].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Model Lines].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Model Lines].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Stock Level]">
                  <UName name="[Product].[Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product]">
                  <UName name="[Product].[Product].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Standard Cost]">
                  <UName name="[Product].[Standard Cost].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Standard Cost].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Standard Cost].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Standard Cost].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Standard Cost].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Category]">
                  <UName name="[Product].[Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Color]">
                  <UName name="[Product].[Color].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Color].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Color].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Color].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Color].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Safety Stock Level]">
                  <UName name="[Product].[Safety Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Safety Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Safety Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Safety Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Safety Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Reorder Point]">
                  <UName name="[Product].[Reorder Point].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Reorder Point].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Reorder Point].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Reorder Point].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Reorder Point].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[List Price]">
                  <UName name="[Product].[List Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[List Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[List Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[List Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[List Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size]">
                  <UName name="[Product].[Size].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size Range]">
                  <UName name="[Product].[Size Range].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size Range].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size Range].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size Range].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size Range].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Weight]">
                  <UName name="[Product].[Weight].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Weight].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Weight].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Weight].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Weight].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Days to Manufacture]">
                  <UName name="[Product].[Days to Manufacture].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Days to Manufacture].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Days to Manufacture].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Days to Manufacture].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Days to Manufacture].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Dealer Price]">
                  <UName name="[Product].[Dealer Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Dealer Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Dealer Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Dealer Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Dealer Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Class]">
                  <UName name="[Product].[Class].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Class].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Class].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Class].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Class].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Style]">
                  <UName name="[Product].[Style].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Style].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Style].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Style].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Style].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Model Name]">
                  <UName name="[Product].[Model Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Model Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Model Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Model Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Model Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Line]">
                  <UName name="[Product].[Product Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Subcategory]">
                  <UName name="[Product].[Subcategory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Subcategory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Subcategory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Subcategory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Subcategory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Status]">
                  <UName name="[Product].[Status].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Status].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Status].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Status].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Status].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Start Date]">
                  <UName name="[Product].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[End Date]">
                  <UName name="[Product].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Large Photo]">
                  <UName name="[Product].[Large Photo].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Large Photo].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Large Photo].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Large Photo].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Large Photo].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory]">
                  <UName name="[Sales Territory].[Sales Territory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Region]">
                  <UName name="[Sales Territory].[Sales Territory Region].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Region].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Region].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Region].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Region].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Country]">
                  <UName name="[Sales Territory].[Sales Territory Country].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Country].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Country].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Country].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Country].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Group]">
                  <UName name="[Sales Territory].[Sales Territory Group].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Group].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Group].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Group].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Group].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Orders]">
                  <UName name="[Sales Summary Order Details].[Sales Orders].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Orders].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Orders].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Orders].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Orders].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Carrier Tracking Number]">
                  <UName name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Carrier Tracking Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Customer PO Number]">
                  <UName name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Customer PO Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Number]">
                  <UName name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Line]">
                  <UName name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency Code]">
                  <UName name="[Source Currency].[Source Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency]">
                  <UName name="[Source Currency].[Source Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency]">
                  <UName name="[Destination Currency].[Destination Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency Code]">
                  <UName name="[Destination Currency].[Destination Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Channel].[Sales Channel]">
                  <UName name="[Sales Channel].[Sales Channel].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Channel].[Sales Channel].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Channel].[Sales Channel].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Channel].[Sales Channel].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Channel].[Sales Channel].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
            </AxesInfo>
            <CellInfo>
              <Value name="VALUE"/>
              <FmtValue name="FORMATTED_VALUE" type="xsd:string"/>
              <CellOrdinal name="CELL_ORDINAL" type="xsd:unsignedInt"/>
            </CellInfo>
          </OlapInfo>
          <Axes>
            <Axis name="Axis0">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
            <Axis name="SlicerAxis">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Date].[Fiscal]">
                    <UName>[Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar]">
                    <UName>[Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Weeks]">
                    <UName>[Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Weeks]">
                    <UName>[Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Year]">
                    <UName>[Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Date]">
                    <UName>[Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Week]">
                    <UName>[Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day Name]">
                    <UName>[Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Month]">
                    <UName>[Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Year]">
                    <UName>[Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Year]">
                    <UName>[Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Semester of Year]">
                    <UName>[Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Semester of Year]">
                    <UName>[Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Quarter of Year]">
                    <UName>[Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Quarter of Year]">
                    <UName>[Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Week of Year]">
                    <UName>[Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Week of Year]">
                    <UName>[Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal]">
                    <UName>[Ship Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar]">
                    <UName>[Ship Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Weeks]">
                    <UName>[Ship Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Weeks]">
                    <UName>[Ship Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Year]">
                    <UName>[Ship Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Date]">
                    <UName>[Ship Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Week]">
                    <UName>[Ship Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day Name]">
                    <UName>[Ship Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Month]">
                    <UName>[Ship Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Year]">
                    <UName>[Ship Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Year]">
                    <UName>[Ship Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Semester of Year]">
                    <UName>[Ship Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Semester of Year]">
                    <UName>[Ship Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Quarter of Year]">
                    <UName>[Ship Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Quarter of Year]">
                    <UName>[Ship Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Month of Year]">
                    <UName>[Ship Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Week of Year]">
                    <UName>[Ship Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Week of Year]">
                    <UName>[Ship Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal]">
                    <UName>[Delivery Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar]">
                    <UName>[Delivery Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Weeks]">
                    <UName>[Delivery Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Weeks]">
                    <UName>[Delivery Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Year]">
                    <UName>[Delivery Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Date]">
                    <UName>[Delivery Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Week]">
                    <UName>[Delivery Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day Name]">
                    <UName>[Delivery Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Month]">
                    <UName>[Delivery Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Day of Year]">
                    <UName>[Delivery Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Year]">
                    <UName>[Delivery Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Semester of Year]">
                    <UName>[Delivery Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Semester of Year]">
                    <UName>[Delivery Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Quarter of Year]">
                    <UName>[Delivery Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Quarter of Year]">
                    <UName>[Delivery Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Month of Year]">
                    <UName>[Delivery Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Calendar Week of Year]">
                    <UName>[Delivery Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Delivery Date].[Fiscal Week of Year]">
                    <UName>[Delivery Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Delivery Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotions]">
                    <UName>[Promotion].[Promotions].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotions].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion]">
                    <UName>[Promotion].[Promotion].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>16</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Discount Percent]">
                    <UName>[Promotion].[Discount Percent].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Discount Percent].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Max Quantity]">
                    <UName>[Promotion].[Max Quantity].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Max Quantity].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion Type]">
                    <UName>[Promotion].[Promotion Type].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion Type].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Min Quantity]">
                    <UName>[Promotion].[Min Quantity].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Min Quantity].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Promotion Category]">
                    <UName>[Promotion].[Promotion Category].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Promotion Category].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>3</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[End Date]">
                    <UName>[Promotion].[End Date].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[End Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Promotion].[Start Date]">
                    <UName>[Promotion].[Start Date].[All Promotions]</UName>
                    <Caption>All Promotions</Caption>
                    <LName>[Promotion].[Start Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>8</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Categories]">
                    <UName>[Product].[Product Categories].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Categories].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Model Lines]">
                    <UName>[Product].[Product Model Lines].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Model Lines].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Stock Level]">
                    <UName>[Product].[Stock Level].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Stock Level].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product]">
                    <UName>[Product].[Product].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>397</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Standard Cost]">
                    <UName>[Product].[Standard Cost].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Standard Cost].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>135</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Category]">
                    <UName>[Product].[Category].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Category].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Color]">
                    <UName>[Product].[Color].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Color].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>10</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Safety Stock Level]">
                    <UName>[Product].[Safety Stock Level].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Safety Stock Level].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Reorder Point]">
                    <UName>[Product].[Reorder Point].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Reorder Point].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>6</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[List Price]">
                    <UName>[Product].[List Price].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[List Price].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>121</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Size]">
                    <UName>[Product].[Size].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Size].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>19</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Size Range]">
                    <UName>[Product].[Size Range].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Size Range].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>11</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Weight]">
                    <UName>[Product].[Weight].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Weight].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>128</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Days to Manufacture]">
                    <UName>[Product].[Days to Manufacture].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Days to Manufacture].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Dealer Price]">
                    <UName>[Product].[Dealer Price].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Dealer Price].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>121</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Class]">
                    <UName>[Product].[Class].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Class].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Style]">
                    <UName>[Product].[Style].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Style].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Model Name]">
                    <UName>[Product].[Model Name].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Model Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>120</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Product Line]">
                    <UName>[Product].[Product Line].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Product Line].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Subcategory]">
                    <UName>[Product].[Subcategory].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Subcategory].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>37</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Status]">
                    <UName>[Product].[Status].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Status].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Start Date]">
                    <UName>[Product].[Start Date].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Start Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[End Date]">
                    <UName>[Product].[End Date].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[End Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>3</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Product].[Large Photo]">
                    <UName>[Product].[Large Photo].[All Products]</UName>
                    <Caption>All Products</Caption>
                    <LName>[Product].[Large Photo].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>606</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory]">
                    <UName>[Sales Territory].[Sales Territory].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Region]">
                    <UName>[Sales Territory].[Sales Territory Region].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Region].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>11</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Country]">
                    <UName>[Sales Territory].[Sales Territory Country].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Country].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Territory].[Sales Territory Group]">
                    <UName>[Sales Territory].[Sales Territory Group].[All Sales Territories]</UName>
                    <Caption>All Sales Territories</Caption>
                    <LName>[Sales Territory].[Sales Territory Group].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Orders]">
                    <UName>[Sales Summary Order Details].[Sales Orders].[All]</UName>
                    <Caption>All</Caption>
                    <LName>[Sales Summary Order Details].[Sales Orders].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Carrier Tracking Number]">
                    <UName>[Sales Summary Order Details].[Carrier Tracking Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Carrier Tracking Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Customer PO Number]">
                    <UName>[Sales Summary Order Details].[Customer PO Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Customer PO Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Order Number]">
                    <UName>[Sales Summary Order Details].[Sales Order Number].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Sales Order Number].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Summary Order Details].[Sales Order Line]">
                    <UName>[Sales Summary Order Details].[Sales Order Line].[All Sales Order Details]</UName>
                    <Caption>All Sales Order Details</Caption>
                    <LName>[Sales Summary Order Details].[Sales Order Line].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1000</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Source Currency].[Source Currency Code]">
                    <UName>[Source Currency].[Source Currency Code].[All Source Currencies]</UName>
                    <Caption>All Source Currencies</Caption>
                    <LName>[Source Currency].[Source Currency Code].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>105</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Source Currency].[Source Currency]">
                    <UName>[Source Currency].[Source Currency].[All Source Currencies]</UName>
                    <Caption>All Source Currencies</Caption>
                    <LName>[Source Currency].[Source Currency].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>105</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Destination Currency].[Destination Currency]">
                    <UName>[Destination Currency].[Destination Currency].&amp;[US Dollar]</UName>
                    <Caption>US Dollar</Caption>
                    <LName>[Destination Currency].[Destination Currency].[Destination Currency]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Destination Currency].[Destination Currency Code]">
                    <UName>[Destination Currency].[Destination Currency Code].[All Destination Currencies]</UName>
                    <Caption>All Destination Currencies</Caption>
                    <LName>[Destination Currency].[Destination Currency Code].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>14</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Sales Channel].[Sales Channel]">
                    <UName>[Sales Channel].[Sales Channel].[All Sales Channels]</UName>
                    <Caption>All Sales Channels</Caption>
                    <LName>[Sales Channel].[Sales Channel].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
          </Axes>
          <CellData>
            <Cell CellOrdinal="0">
              <Value xsi:type="xsd:int">274776</Value>
              <FmtValue>274,776</FmtValue>
            </Cell>
            <Cell CellOrdinal="1">
              <Value xsi:type="xsd:double">1.1033678209140154E8</Value>
              <FmtValue>$110,336,782.09</FmtValue>
            </Cell>
            <Cell CellOrdinal="2">
              <Value xsi:type="xsd:double">4.397162414840007E7</Value>
              <FmtValue>$43,971,624.15</FmtValue>
            </Cell>
            <Cell CellOrdinal="3">
              <Value xsi:type="xsd:double">9.725790795469968E7</Value>
              <FmtValue>$97,257,907.95</FmtValue>
            </Cell>
            <Cell CellOrdinal="4">
              <Value xsi:type="xsd:double">1.0980927420300156E8</Value>
              <FmtValue>$109,809,274.20</FmtValue>
            </Cell>
            <Cell CellOrdinal="5">
              <Value xsi:type="xsd:double">8.784741836700124E6</Value>
              <FmtValue>$8,784,741.84</FmtValue>
            </Cell>
            <Cell CellOrdinal="6">
              <Value xsi:type="xsd:double">2.745235524899985E6</Value>
              <FmtValue>$2,745,235.52</FmtValue>
            </Cell>
            <Cell CellOrdinal="7">
              <Value xsi:type="xsd:int">31455</Value>
              <FmtValue>31,455</FmtValue>
            </Cell>
            <Cell CellOrdinal="8">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="9">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>1.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="10">
              <Value xsi:type="xsd:double">4.651805148845871E2</Value>
              <FmtValue>$465.18</FmtValue>
            </Cell>
            <Cell CellOrdinal="11">
              <Value xsi:type="xsd:double">3.490995841774012E3</Value>
              <FmtValue>$3,491.00</FmtValue>
            </Cell>
            <Cell CellOrdinal="12">
              <Value xsi:type="xsd:double">1.2551366248301878E7</Value>
              <FmtValue>$12,551,366.25</FmtValue>
            </Cell>
            <Cell CellOrdinal="13">
              <Value xsi:type="xsd:double">1.1430151359618763E-1</Value>
              <FmtValue>11.43%</FmtValue>
            </Cell>
            <Cell CellOrdinal="14">
              <Value xsi:type="xsd:double">2.5190830829882565E-1</Value>
              <FmtValue>25.19%</FmtValue>
            </Cell>
            <Cell CellOrdinal="15">
              <Value xsi:type="xsd:double">1.</Value>
              <FmtValue>100.00%</FmtValue>
            </Cell>
            <Cell CellOrdinal="16">
              <Value xsi:type="xsd:short">1</Value>
              <FmtValue>100.00%</FmtValue>
            </Cell>
          </CellData>
        </root>
      </return>
    </ExecuteResponse>
  </soap:Body>
</soap:Envelope>
"""),
    ],
    "testOneDimensional2":[
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Execute>
      <Command>
        <Statement>select {} on columns, [Measures].ALLMEMBERS on rows from [Sales Summary]</Statement>
      </Command>
      <Properties>
        <PropertyList>
          <Format>Multidimensional</Format>
          <AxisFormat>TupleFormat</AxisFormat>
          <Catalog>Adventure Works DW 2008R2</Catalog>
        </PropertyList>
      </Properties>
    </Execute>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
  <soap:Body>
    <ExecuteResponse xmlns="urn:schemas-microsoft-com:xml-analysis">
      <return>
        <root xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla">
          <xs:schema xmlns="urn:schemas-microsoft-com:xml-analysis:mddataset" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:msxmla="http://schemas.microsoft.com/analysisservices/2003/xmla" targetNamespace="urn:schemas-microsoft-com:xml-analysis:mddataset" elementFormDefault="qualified">
            <xs:import namespace="http://schemas.microsoft.com/analysisservices/2003/xmla"/>
            <xs:complexType name="MemberType">
              <xs:sequence>
                <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string"/>
            </xs:complexType>
            <xs:complexType name="PropType">
              <xs:sequence>
                <xs:element name="Default" minOccurs="0"/>
              </xs:sequence>
              <xs:attribute name="name" type="xs:string" use="required"/>
              <xs:attribute name="type" type="xs:QName"/>
            </xs:complexType>
            <xs:complexType name="TupleType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="MembersType">
              <xs:sequence>
                <xs:element name="Member" type="MemberType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
              <xs:attribute name="Hierarchy" type="xs:string" use="required"/>
            </xs:complexType>
            <xs:complexType name="TuplesType">
              <xs:sequence>
                <xs:element name="Tuple" type="TupleType" minOccurs="0" maxOccurs="unbounded"/>
              </xs:sequence>
            </xs:complexType>
            <xs:group name="SetType">
              <xs:choice>
                <xs:element name="Members" type="MembersType"/>
                <xs:element name="Tuples" type="TuplesType"/>
                <xs:element name="CrossProduct" type="SetListType"/>
                <xs:element ref="msxmla:NormTupleSet"/>
                <xs:element name="Union">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                  </xs:complexType>
                </xs:element>
              </xs:choice>
            </xs:group>
            <xs:complexType name="SetListType">
              <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
              <xs:attribute name="Size" type="xs:unsignedInt"/>
            </xs:complexType>
            <xs:complexType name="OlapInfo">
              <xs:sequence>
                <xs:element name="CubeInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="Cube" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="CubeName" type="xs:string"/>
                            <xs:element name="LastDataUpdate" minOccurs="0" type="xs:dateTime"/>
                            <xs:element name="LastSchemaUpdate" minOccurs="0" type="xs:dateTime"/>
                          </xs:sequence>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="AxesInfo">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:element name="AxisInfo" maxOccurs="unbounded">
                        <xs:complexType>
                          <xs:sequence>
                            <xs:element name="HierarchyInfo" minOccurs="0" maxOccurs="unbounded">
                              <xs:complexType>
                                <xs:sequence>
                                  <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                                </xs:sequence>
                                <xs:attribute name="name" type="xs:string" use="required"/>
                              </xs:complexType>
                            </xs:element>
                          </xs:sequence>
                          <xs:attribute name="name" type="xs:string"/>
                        </xs:complexType>
                      </xs:element>
                    </xs:sequence>
                  </xs:complexType>
                </xs:element>
                <xs:element name="CellInfo">
                  <xs:complexType>
                    <xs:choice minOccurs="0" maxOccurs="unbounded">
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:choice>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="Axes">
              <xs:sequence>
                <xs:element name="Axis" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:group ref="SetType" minOccurs="0" maxOccurs="unbounded"/>
                    <xs:attribute name="name" type="xs:string"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:complexType name="CellData">
              <xs:sequence>
                <xs:element name="Cell" minOccurs="0" maxOccurs="unbounded">
                  <xs:complexType>
                    <xs:sequence>
                      <xs:any namespace="##targetNamespace" minOccurs="0" maxOccurs="unbounded" processContents="skip"/>
                    </xs:sequence>
                    <xs:attribute name="CellOrdinal" type="xs:unsignedInt" use="required"/>
                  </xs:complexType>
                </xs:element>
              </xs:sequence>
            </xs:complexType>
            <xs:element name="root">
              <xs:complexType>
                <xs:sequence>
                  <xs:any namespace="http://www.w3.org/2001/XMLSchema" processContents="strict" minOccurs="0"/>
                  <xs:element name="OlapInfo" type="OlapInfo" minOccurs="0"/>
                  <xs:element name="Axes" type="Axes" minOccurs="0"/>
                  <xs:element name="CellData" type="CellData" minOccurs="0"/>
                </xs:sequence>
              </xs:complexType>
            </xs:element>
          </xs:schema>
          <OlapInfo>
            <CubeInfo>
              <Cube>
                <CubeName>Sales Summary</CubeName>
                <LastDataUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-24T11:57:43.523333</LastDataUpdate>
                <LastSchemaUpdate xmlns="http://schemas.microsoft.com/analysisservices/2003/engine">2011-06-23T23:01:05.413333</LastSchemaUpdate>
              </Cube>
            </CubeInfo>
            <AxesInfo>
              <AxisInfo name="Axis0"/>
              <AxisInfo name="Axis1">
                <HierarchyInfo name="[Measures]">
                  <UName name="[Measures].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Measures].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Measures].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Measures].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Measures].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
              <AxisInfo name="SlicerAxis">
                <HierarchyInfo name="[Date].[Fiscal]">
                  <UName name="[Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar]">
                  <UName name="[Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Weeks]">
                  <UName name="[Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Weeks]">
                  <UName name="[Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Year]">
                  <UName name="[Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Date]">
                  <UName name="[Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Week]">
                  <UName name="[Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day Name]">
                  <UName name="[Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Month]">
                  <UName name="[Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Day of Year]">
                  <UName name="[Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Year]">
                  <UName name="[Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Semester of Year]">
                  <UName name="[Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Semester of Year]">
                  <UName name="[Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Quarter of Year]">
                  <UName name="[Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Quarter of Year]">
                  <UName name="[Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Month of Year]">
                  <UName name="[Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Calendar Week of Year]">
                  <UName name="[Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Date].[Fiscal Week of Year]">
                  <UName name="[Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal]">
                  <UName name="[Ship Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar]">
                  <UName name="[Ship Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Weeks]">
                  <UName name="[Ship Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Weeks]">
                  <UName name="[Ship Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Year]">
                  <UName name="[Ship Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Date]">
                  <UName name="[Ship Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Week]">
                  <UName name="[Ship Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day Name]">
                  <UName name="[Ship Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Month]">
                  <UName name="[Ship Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Day of Year]">
                  <UName name="[Ship Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Year]">
                  <UName name="[Ship Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Semester of Year]">
                  <UName name="[Ship Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Semester of Year]">
                  <UName name="[Ship Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Quarter of Year]">
                  <UName name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Quarter of Year]">
                  <UName name="[Ship Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Month of Year]">
                  <UName name="[Ship Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Calendar Week of Year]">
                  <UName name="[Ship Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Ship Date].[Fiscal Week of Year]">
                  <UName name="[Ship Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Ship Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Ship Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Ship Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Ship Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal]">
                  <UName name="[Delivery Date].[Fiscal].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar]">
                  <UName name="[Delivery Date].[Calendar].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Weeks]">
                  <UName name="[Delivery Date].[Calendar Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Weeks]">
                  <UName name="[Delivery Date].[Fiscal Weeks].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Weeks].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Weeks].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Weeks].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Weeks].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Year]">
                  <UName name="[Delivery Date].[Fiscal Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Date]">
                  <UName name="[Delivery Date].[Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Week]">
                  <UName name="[Delivery Date].[Day of Week].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Week].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Week].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Week].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Week].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day Name]">
                  <UName name="[Delivery Date].[Day Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Month]">
                  <UName name="[Delivery Date].[Day of Month].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Month].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Month].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Month].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Month].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Day of Year]">
                  <UName name="[Delivery Date].[Day of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Day of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Day of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Day of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Day of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Year]">
                  <UName name="[Delivery Date].[Calendar Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Semester of Year]">
                  <UName name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Semester of Year]">
                  <UName name="[Delivery Date].[Calendar Semester of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Semester of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Semester of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Semester of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Semester of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Quarter of Year]">
                  <UName name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Quarter of Year]">
                  <UName name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Quarter of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Quarter of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Quarter of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Month of Year]">
                  <UName name="[Delivery Date].[Month of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Month of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Month of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Month of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Month of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Calendar Week of Year]">
                  <UName name="[Delivery Date].[Calendar Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Calendar Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Calendar Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Calendar Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Calendar Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Delivery Date].[Fiscal Week of Year]">
                  <UName name="[Delivery Date].[Fiscal Week of Year].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Delivery Date].[Fiscal Week of Year].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Delivery Date].[Fiscal Week of Year].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Delivery Date].[Fiscal Week of Year].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Delivery Date].[Fiscal Week of Year].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotions]">
                  <UName name="[Promotion].[Promotions].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotions].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotions].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotions].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotions].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion]">
                  <UName name="[Promotion].[Promotion].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Discount Percent]">
                  <UName name="[Promotion].[Discount Percent].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Discount Percent].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Discount Percent].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Discount Percent].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Discount Percent].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Max Quantity]">
                  <UName name="[Promotion].[Max Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Max Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Max Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Max Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Max Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Type]">
                  <UName name="[Promotion].[Promotion Type].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Type].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Type].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Type].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Type].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Min Quantity]">
                  <UName name="[Promotion].[Min Quantity].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Min Quantity].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Min Quantity].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Min Quantity].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Min Quantity].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Promotion Category]">
                  <UName name="[Promotion].[Promotion Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Promotion Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Promotion Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Promotion Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Promotion Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[End Date]">
                  <UName name="[Promotion].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Promotion].[Start Date]">
                  <UName name="[Promotion].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Promotion].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Promotion].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Promotion].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Promotion].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Categories]">
                  <UName name="[Product].[Product Categories].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Categories].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Categories].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Categories].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Categories].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Model Lines]">
                  <UName name="[Product].[Product Model Lines].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Model Lines].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Model Lines].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Model Lines].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Model Lines].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Stock Level]">
                  <UName name="[Product].[Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product]">
                  <UName name="[Product].[Product].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Standard Cost]">
                  <UName name="[Product].[Standard Cost].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Standard Cost].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Standard Cost].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Standard Cost].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Standard Cost].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Category]">
                  <UName name="[Product].[Category].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Category].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Category].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Category].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Category].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Color]">
                  <UName name="[Product].[Color].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Color].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Color].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Color].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Color].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Safety Stock Level]">
                  <UName name="[Product].[Safety Stock Level].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Safety Stock Level].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Safety Stock Level].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Safety Stock Level].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Safety Stock Level].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Reorder Point]">
                  <UName name="[Product].[Reorder Point].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Reorder Point].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Reorder Point].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Reorder Point].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Reorder Point].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[List Price]">
                  <UName name="[Product].[List Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[List Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[List Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[List Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[List Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size]">
                  <UName name="[Product].[Size].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Size Range]">
                  <UName name="[Product].[Size Range].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Size Range].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Size Range].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Size Range].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Size Range].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Weight]">
                  <UName name="[Product].[Weight].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Weight].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Weight].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Weight].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Weight].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Days to Manufacture]">
                  <UName name="[Product].[Days to Manufacture].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Days to Manufacture].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Days to Manufacture].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Days to Manufacture].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Days to Manufacture].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Dealer Price]">
                  <UName name="[Product].[Dealer Price].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Dealer Price].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Dealer Price].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Dealer Price].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Dealer Price].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Class]">
                  <UName name="[Product].[Class].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Class].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Class].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Class].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Class].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Style]">
                  <UName name="[Product].[Style].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Style].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Style].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Style].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Style].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Model Name]">
                  <UName name="[Product].[Model Name].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Model Name].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Model Name].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Model Name].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Model Name].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Product Line]">
                  <UName name="[Product].[Product Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Product Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Product Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Product Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Product Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Subcategory]">
                  <UName name="[Product].[Subcategory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Subcategory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Subcategory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Subcategory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Subcategory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Status]">
                  <UName name="[Product].[Status].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Status].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Status].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Status].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Status].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Start Date]">
                  <UName name="[Product].[Start Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Start Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Start Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Start Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Start Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[End Date]">
                  <UName name="[Product].[End Date].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[End Date].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[End Date].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[End Date].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[End Date].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Product].[Large Photo]">
                  <UName name="[Product].[Large Photo].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Product].[Large Photo].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Product].[Large Photo].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Product].[Large Photo].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Product].[Large Photo].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory]">
                  <UName name="[Sales Territory].[Sales Territory].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Region]">
                  <UName name="[Sales Territory].[Sales Territory Region].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Region].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Region].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Region].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Region].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Country]">
                  <UName name="[Sales Territory].[Sales Territory Country].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Country].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Country].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Country].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Country].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Territory].[Sales Territory Group]">
                  <UName name="[Sales Territory].[Sales Territory Group].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Territory].[Sales Territory Group].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Territory].[Sales Territory Group].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Territory].[Sales Territory Group].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Territory].[Sales Territory Group].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Orders]">
                  <UName name="[Sales Summary Order Details].[Sales Orders].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Orders].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Orders].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Orders].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Orders].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Carrier Tracking Number]">
                  <UName name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Carrier Tracking Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Carrier Tracking Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Carrier Tracking Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Customer PO Number]">
                  <UName name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Customer PO Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Customer PO Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Customer PO Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Number]">
                  <UName name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Number].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Number].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Number].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Summary Order Details].[Sales Order Line]">
                  <UName name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Summary Order Details].[Sales Order Line].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Summary Order Details].[Sales Order Line].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Summary Order Details].[Sales Order Line].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency Code]">
                  <UName name="[Source Currency].[Source Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Source Currency].[Source Currency]">
                  <UName name="[Source Currency].[Source Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Source Currency].[Source Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Source Currency].[Source Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Source Currency].[Source Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Source Currency].[Source Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency]">
                  <UName name="[Destination Currency].[Destination Currency].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Destination Currency].[Destination Currency Code]">
                  <UName name="[Destination Currency].[Destination Currency Code].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Destination Currency].[Destination Currency Code].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Destination Currency].[Destination Currency Code].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Destination Currency].[Destination Currency Code].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Destination Currency].[Destination Currency Code].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
                <HierarchyInfo name="[Sales Channel].[Sales Channel]">
                  <UName name="[Sales Channel].[Sales Channel].[MEMBER_UNIQUE_NAME]" type="xsd:string"/>
                  <Caption name="[Sales Channel].[Sales Channel].[MEMBER_CAPTION]" type="xsd:string"/>
                  <LName name="[Sales Channel].[Sales Channel].[LEVEL_UNIQUE_NAME]" type="xsd:string"/>
                  <LNum name="[Sales Channel].[Sales Channel].[LEVEL_NUMBER]" type="xsd:int"/>
                  <DisplayInfo name="[Sales Channel].[Sales Channel].[DISPLAY_INFO]" type="xsd:unsignedInt"/>
                </HierarchyInfo>
              </AxisInfo>
            </AxesInfo>
            <CellInfo>
              <Value name="VALUE"/>
              <FmtValue name="FORMATTED_VALUE" type="xsd:string"/>
              <CellOrdinal name="CELL_ORDINAL" type="xsd:unsignedInt"/>
            </CellInfo>
          </OlapInfo>
          <Axes>
            <Axis name="Axis0">
              <Tuples/>
            </Axis>
            <Axis name="Axis1">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Quantity]</UName>
                    <Caption>Order Quantity</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>0</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Extended Amount]</UName>
                    <Caption>Extended Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Standard Product Cost]</UName>
                    <Caption>Standard Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Total Product Cost]</UName>
                    <Caption>Total Product Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Sales Amount]</UName>
                    <Caption>Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Tax Amount]</UName>
                    <Caption>Tax Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Freight Cost]</UName>
                    <Caption>Freight Cost</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Order Count]</UName>
                    <Caption>Order Count</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Rate]</UName>
                    <Caption>Average Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[End of Day Rate]</UName>
                    <Caption>End of Day Rate</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Unit Price]</UName>
                    <Caption>Average Unit Price</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Average Sales Amount]</UName>
                    <Caption>Average Sales Amount</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit]</UName>
                    <Caption>Gross Profit</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Gross Profit Margin]</UName>
                    <Caption>Gross Profit Margin</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Expense to Revenue Ratio]</UName>
                    <Caption>Expense to Revenue Ratio</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to All Products]</UName>
                    <Caption>Ratio to All Products</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
                <Tuple>
                  <Member Hierarchy="[Measures]">
                    <UName>[Measures].[Ratio to Parent Product]</UName>
                    <Caption>Ratio to Parent Product</Caption>
                    <LName>[Measures].[MeasuresLevel]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>131072</DisplayInfo>
                  </Member>
                </Tuple>
              </Tuples>
            </Axis>
            <Axis name="SlicerAxis">
              <Tuples>
                <Tuple>
                  <Member Hierarchy="[Date].[Fiscal]">
                    <UName>[Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar]">
                    <UName>[Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Weeks]">
                    <UName>[Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Weeks]">
                    <UName>[Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Year]">
                    <UName>[Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Date]">
                    <UName>[Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Week]">
                    <UName>[Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day Name]">
                    <UName>[Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Month]">
                    <UName>[Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Day of Year]">
                    <UName>[Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Day of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>365</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Year]">
                    <UName>[Date].[Calendar Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Semester of Year]">
                    <UName>[Date].[Fiscal Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Semester of Year]">
                    <UName>[Date].[Calendar Semester of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Semester of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>2</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Quarter of Year]">
                    <UName>[Date].[Fiscal Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Quarter of Year]">
                    <UName>[Date].[Calendar Quarter of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Quarter of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>4</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Month of Year]">
                    <UName>[Date].[Month of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Month of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>12</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Calendar Week of Year]">
                    <UName>[Date].[Calendar Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Calendar Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Date].[Fiscal Week of Year]">
                    <UName>[Date].[Fiscal Week of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Date].[Fiscal Week of Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>53</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal]">
                    <UName>[Ship Date].[Fiscal].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar]">
                    <UName>[Ship Date].[Calendar].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Calendar Weeks]">
                    <UName>[Ship Date].[Calendar Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Calendar Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Weeks]">
                    <UName>[Ship Date].[Fiscal Weeks].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Weeks].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Fiscal Year]">
                    <UName>[Ship Date].[Fiscal Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Fiscal Year].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>5</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Date]">
                    <UName>[Ship Date].[Date].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Date].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>1188</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Week]">
                    <UName>[Ship Date].[Day of Week].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Week].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day Name]">
                    <UName>[Ship Date].[Day Name].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day Name].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>7</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Month]">
                    <UName>[Ship Date].[Day of Month].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Month].[(All)]</LName>
                    <LNum>0</LNum>
                    <DisplayInfo>31</DisplayInfo>
                  </Member>
                  <Member Hierarchy="[Ship Date].[Day of Year]">
                    <UName>[Ship Date].[Day of Year].[All Periods]</UName>
                    <Caption>All Periods</Caption>
                    <LName>[Ship Date].[Day of Yea