# -*- coding: utf-8
conversation={
    "testFlow":[
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>DISCOVER_SCHEMA_ROWSETS</RequestType>
      <Restrictions xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
      <Properties xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="SchemaName" name="SchemaName" type="xsd:string"/>
            <xsd:element sql:field="SchemaGuid" name="SchemaGuid" type="uuid" minOccurs="0"/>
            <xsd:element sql:field="Restrictions" name="Restrictions" minOccurs="0" maxOccurs="unbounded">
              <xsd:complexType>
                <xsd:sequence>
                  <xsd:element name="Name" type="xsd:string" sql:field="Name"/>
                  <xsd:element name="Type" type="xsd:string" sql:field="Type"/>
                </xsd:sequence>
              </xsd:complexType>
            </xsd:element>
            <xsd:element sql:field="Description" name="Description" type="xsd:string"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <SchemaName>DBSCHEMA_CATALOGS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Identifies the physical attributes associated with catalogs accessible from the provider.</Description>
      </row>
      <row>
        <SchemaName>DBSCHEMA_COLUMNS</SchemaName>
        <Restrictions>
          <Name>TABLE_CATALOG</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_SCHEMA</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>COLUMN_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_PROVIDER_TYPES</SchemaName>
        <Restrictions>
          <Name>DATA_TYPE</Name>
          <Type>xsd:unsignedShort</Type>
        </Restrictions>
        <Restrictions>
          <Name>BEST_MATCH</Name>
          <Type>xsd:boolean</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_SCHEMATA</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_OWNER</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_TABLES</SchemaName>
        <Restrictions>
          <Name>TABLE_CATALOG</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_SCHEMA</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_TYPE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_TABLES_INFO</SchemaName>
        <Restrictions>
          <Name>TABLE_CATALOG</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_SCHEMA</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_TYPE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DISCOVER_DATASOURCES</SchemaName>
        <Restrictions>
          <Name>DataSourceName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>URL</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ProviderName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ProviderType</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>AuthenticationMode</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns a list of XML for Analysis data sources available on the server or Web Service.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_ENUMERATORS</SchemaName>
        <Restrictions>
          <Name>EnumName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns a list of names, data types, and enumeration values for enumerators supported by the provider of a specific data source.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_KEYWORDS</SchemaName>
        <Restrictions>
          <Name>Keyword</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns an XML list of keywords reserved by the provider.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_LITERALS</SchemaName>
        <Restrictions>
          <Name>LiteralName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns information about literals supported by the provider.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_PROPERTIES</SchemaName>
        <Restrictions>
          <Name>PropertyName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns a list of information and values about the requested properties that are supported by the specified data source provider.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_SCHEMA_ROWSETS</SchemaName>
        <Restrictions>
          <Name>SchemaName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns the names, values, and other information of all supported RequestType enumeration values.</Description>
      </row>
      <row>
        <SchemaName>MDSCHEMA_ACTIONS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ACTION_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>COORDINATE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>COORDINATE_TYPE</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_CUBES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_TYPE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_DIMENSIONS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_FUNCTIONS</SchemaName>
        <Restrictions>
          <Name>FUNCTION_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ORIGIN</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Restrictions>
          <Name>INTERFACE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LIBRARY_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_HIERARCHIES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_LEVELS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_MEASURES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEASURE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEASURE_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_MEMBERS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_NUMBER</Name>
          <Type>xsd:unsignedInt</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_TYPE</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_CAPTION</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TREE_OP</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_PROPERTIES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>PROPERTY_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>PROPERTY_TYPE</Name>
          <Type>xsd:short</Type>
        </Restrictions>
        <Restrictions>
          <Name>PROPERTY_CONTENT_TYPE</Name>
          <Type>xsd:short</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_SETS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SET_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCOPE</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Description/>
      </row>
    </root>
  </cxmla:return>
</cxmla:DiscoverResponse>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""),
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>DBSCHEMA_CATALOGS</RequestType>
      <Restrictions>
        <RestrictionList>
          <CATALOG_NAME>FoodMart</CATALOG_NAME>
        </RestrictionList>
      </Restrictions>
      <Properties xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="CATALOG_NAME" name="CATALOG_NAME" type="xsd:string"/>
            <xsd:element sql:field="DESCRIPTION" name="DESCRIPTION" type="xsd:string"/>
            <xsd:element sql:field="ROLES" name="ROLES" type="xsd:string"/>
            <xsd:element sql:field="DATE_MODIFIED" name="DATE_MODIFIED" type="xsd:dateTime" minOccurs="0"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <CATALOG_NAME>FoodMart</CATALOG_NAME>
        <DESCRIPTION>No description available</DESCRIPTION>
        <ROLES/>
      </row>
    </root>
  </cxmla:return>
</cxmla:DiscoverResponse>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""),
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>MDSCHEMA_CUBES</RequestType>
      <Restrictions>
        <RestrictionList>
          <CUBE_NAME>Sales</CUBE_NAME>
        </RestrictionList>
      </Restrictions>
      <Properties>
        <PropertyList>
          <Catalog>FoodMart</Catalog>
        </PropertyList>
      </Properties>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="CATALOG_NAME" name="CATALOG_NAME" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="SCHEMA_NAME" name="SCHEMA_NAME" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="CUBE_NAME" name="CUBE_NAME" type="xsd:string"/>
            <xsd:element sql:field="CUBE_TYPE" name="CUBE_TYPE" type="xsd:string"/>
            <xsd:element sql:field="CUBE_GUID" name="CUBE_GUID" type="uuid" minOccurs="0"/>
            <xsd:element sql:field="CREATED_ON" name="CREATED_ON" type="xsd:dateTime" minOccurs="0"/>
            <xsd:element sql:field="LAST_SCHEMA_UPDATE" name="LAST_SCHEMA_UPDATE" type="xsd:dateTime" minOccurs="0"/>
            <xsd:element sql:field="SCHEMA_UPDATED_BY" name="SCHEMA_UPDATED_BY" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="LAST_DATA_UPDATE" name="LAST_DATA_UPDATE" type="xsd:dateTime" minOccurs="0"/>
            <xsd:element sql:field="DATA_UPDATED_BY" name="DATA_UPDATED_BY" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="IS_DRILLTHROUGH_ENABLED" name="IS_DRILLTHROUGH_ENABLED" type="xsd:boolean"/>
            <xsd:element sql:field="IS_WRITE_ENABLED" name="IS_WRITE_ENABLED" type="xsd:boolean"/>
            <xsd:element sql:field="IS_LINKABLE" name="IS_LINKABLE" type="xsd:boolean"/>
            <xsd:element sql:field="IS_SQL_ENABLED" name="IS_SQL_ENABLED" type="xsd:boolean"/>
            <xsd:element sql:field="CUBE_CAPTION" name="CUBE_CAPTION" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="DESCRIPTION" name="DESCRIPTION" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="DIMENSIONS" name="DIMENSIONS" minOccurs="0"/>
            <xsd:element sql:field="SETS" name="SETS" minOccurs="0"/>
            <xsd:element sql:field="MEASURES" name="MEASURES" minOccurs="0"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <CATALOG_NAME>FoodMart</CATALOG_NAME>
        <SCHEMA_NAME>FoodMart</SCHEMA_NAME>
        <CUBE_NAME>Sales</CUBE_NAME>
        <CUBE_TYPE>CUBE</CUBE_TYPE>
        <LAST_SCHEMA_UPDATE>2019-04-10T20:16:40</LAST_SCHEMA_UPDATE>
        <IS_DRILLTHROUGH_ENABLED>true</IS_DRILLTHROUGH_ENABLED>
        <IS_WRITE_ENABLED>false</IS_WRITE_ENABLED>
        <IS_LINKABLE>false</IS_LINKABLE>
        <IS_SQL_ENABLED>false</IS_SQL_ENABLED>
        <CUBE_CAPTION>Verkaufen</CUBE_CAPTION>
        <DESCRIPTION>Cube Verkaufen</DESCRIPTION>
      </row>
    </root>
  </cxmla:return>
</cxmla:DiscoverResponse>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""),
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>MDSCHEMA_HIERARCHIES</RequestType>
      <Restrictions>
        <RestrictionList>
          <CUBE_NAME>Sales</CUBE_NAME>
          <HIERARCHY_UNIQUE_NAME>[Product]</HIERARCHY_UNIQUE_NAME>
        </RestrictionList>
      </Restrictions>
      <Properties>
        <PropertyList>
          <Catalog>FoodMart</Catalog>
        </PropertyList>
      </Properties>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="CATALOG_NAME" name="CATALOG_NAME" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="SCHEMA_NAME" name="SCHEMA_NAME" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="CUBE_NAME" name="CUBE_NAME" type="xsd:string"/>
            <xsd:element sql:field="DIMENSION_UNIQUE_NAME" name="DIMENSION_UNIQUE_NAME" type="xsd:string"/>
            <xsd:element sql:field="HIERARCHY_NAME" name="HIERARCHY_NAME" type="xsd:string"/>
            <xsd:element sql:field="HIERARCHY_UNIQUE_NAME" name="HIERARCHY_UNIQUE_NAME" type="xsd:string"/>
            <xsd:element sql:field="HIERARCHY_GUID" name="HIERARCHY_GUID" type="uuid" minOccurs="0"/>
            <xsd:element sql:field="HIERARCHY_CAPTION" name="HIERARCHY_CAPTION" type="xsd:string"/>
            <xsd:element sql:field="DIMENSION_TYPE" name="DIMENSION_TYPE" type="xsd:short"/>
            <xsd:element sql:field="HIERARCHY_CARDINALITY" name="HIERARCHY_CARDINALITY" type="xsd:unsignedInt"/>
            <xsd:element sql:field="DEFAULT_MEMBER" name="DEFAULT_MEMBER" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="ALL_MEMBER" name="ALL_MEMBER" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="DESCRIPTION" name="DESCRIPTION" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="STRUCTURE" name="STRUCTURE" type="xsd:short"/>
            <xsd:element sql:field="IS_VIRTUAL" name="IS_VIRTUAL" type="xsd:boolean"/>
            <xsd:element sql:field="IS_READWRITE" name="IS_READWRITE" type="xsd:boolean"/>
            <xsd:element sql:field="DIMENSION_UNIQUE_SETTINGS" name="DIMENSION_UNIQUE_SETTINGS" type="xsd:int"/>
            <xsd:element sql:field="DIMENSION_IS_VISIBLE" name="DIMENSION_IS_VISIBLE" type="xsd:boolean"/>
            <xsd:element sql:field="HIERARCHY_IS_VISIBLE" name="HIERARCHY_IS_VISIBLE" type="xsd:boolean"/>
            <xsd:element sql:field="HIERARCHY_ORDINAL" name="HIERARCHY_ORDINAL" type="xsd:unsignedInt"/>
            <xsd:element sql:field="DIMENSION_IS_SHARED" name="DIMENSION_IS_SHARED" type="xsd:boolean"/>
            <xsd:element sql:field="PARENT_CHILD" name="PARENT_CHILD" type="xsd:boolean" minOccurs="0"/>
            <xsd:element sql:field="LEVELS" name="LEVELS" minOccurs="0"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <CATALOG_NAME>FoodMart</CATALOG_NAME>
        <SCHEMA_NAME>FoodMart</SCHEMA_NAME>
        <CUBE_NAME>Sales</CUBE_NAME>
        <DIMENSION_UNIQUE_NAME>[Product]</DIMENSION_UNIQUE_NAME>
        <HIERARCHY_NAME>Product</HIERARCHY_NAME>
        <HIERARCHY_UNIQUE_NAME>[Product]</HIERARCHY_UNIQUE_NAME>
        <HIERARCHY_CAPTION>Product</HIERARCHY_CAPTION>
        <DIMENSION_TYPE>3</DIMENSION_TYPE>
        <HIERARCHY_CARDINALITY>2256</HIERARCHY_CARDINALITY>
        <DEFAULT_MEMBER>[Product].[All Products]</DEFAULT_MEMBER>
        <ALL_MEMBER>[Product].[All Products]</ALL_MEMBER>
        <DESCRIPTION>Sales Cube - Product Hierarchy</DESCRIPTION>
        <STRUCTURE>0</STRUCTURE>
        <IS_VIRTUAL>false</IS_VIRTUAL>
        <IS_READWRITE>false</IS_READWRITE>
        <DIMENSION_UNIQUE_SETTINGS>0</DIMENSION_UNIQUE_SETTINGS>
        <DIMENSION_IS_VISIBLE>true</DIMENSION_IS_VISIBLE>
        <HIERARCHY_IS_VISIBLE>true</HIERARCHY_IS_VISIBLE>
        <HIERARCHY_ORDINAL>6</HIERARCHY_ORDINAL>
        <DIMENSION_IS_SHARED>true</DIMENSION_IS_SHARED>
        <PARENT_CHILD>false</PARENT_CHILD>
      </row>
    </root>
  </cxmla:return>
</cxmla:DiscoverResponse>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""),
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>MDSCHEMA_LEVELS</RequestType>
      <Restrictions>
        <RestrictionList>
          <CUBE_NAME>Sales</CUBE_NAME>
          <HIERARCHY_UNIQUE_NAME>[Product]</HIERARCHY_UNIQUE_NAME>
          <LEVEL_UNIQUE_NAME>[Product].[Product Category]</LEVEL_UNIQUE_NAME>
        </RestrictionList>
      </Restrictions>
      <Properties>
        <PropertyList>
          <Catalog>FoodMart</Catalog>
        </PropertyList>
      </Properties>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="CATALOG_NAME" name="CATALOG_NAME" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="SCHEMA_NAME" name="SCHEMA_NAME" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="CUBE_NAME" name="CUBE_NAME" type="xsd:string"/>
            <xsd:element sql:field="DIMENSION_UNIQUE_NAME" name="DIMENSION_UNIQUE_NAME" type="xsd:string"/>
            <xsd:element sql:field="HIERARCHY_UNIQUE_NAME" name="HIERARCHY_UNIQUE_NAME" type="xsd:string"/>
            <xsd:element sql:field="LEVEL_NAME" name="LEVEL_NAME" type="xsd:string"/>
            <xsd:element sql:field="LEVEL_UNIQUE_NAME" name="LEVEL_UNIQUE_NAME" type="xsd:string"/>
            <xsd:element sql:field="LEVEL_GUID" name="LEVEL_GUID" type="uuid" minOccurs="0"/>
            <xsd:element sql:field="LEVEL_CAPTION" name="LEVEL_CAPTION" type="xsd:string"/>
            <xsd:element sql:field="LEVEL_NUMBER" name="LEVEL_NUMBER" type="xsd:unsignedInt"/>
            <xsd:element sql:field="LEVEL_CARDINALITY" name="LEVEL_CARDINALITY" type="xsd:unsignedInt"/>
            <xsd:element sql:field="LEVEL_TYPE" name="LEVEL_TYPE" type="xsd:int"/>
            <xsd:element sql:field="CUSTOM_ROLLUP_SETTINGS" name="CUSTOM_ROLLUP_SETTINGS" type="xsd:int"/>
            <xsd:element sql:field="LEVEL_UNIQUE_SETTINGS" name="LEVEL_UNIQUE_SETTINGS" type="xsd:int"/>
            <xsd:element sql:field="LEVEL_IS_VISIBLE" name="LEVEL_IS_VISIBLE" type="xsd:boolean"/>
            <xsd:element sql:field="DESCRIPTION" name="DESCRIPTION" type="xsd:string" minOccurs="0"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <CATALOG_NAME>FoodMart</CATALOG_NAME>
        <SCHEMA_NAME>FoodMart</SCHEMA_NAME>
        <CUBE_NAME>Sales</CUBE_NAME>
        <DIMENSION_UNIQUE_NAME>[Product]</DIMENSION_UNIQUE_NAME>
        <HIERARCHY_UNIQUE_NAME>[Product]</HIERARCHY_UNIQUE_NAME>
        <LEVEL_NAME>Product Category</LEVEL_NAME>
        <LEVEL_UNIQUE_NAME>[Product].[Product Category]</LEVEL_UNIQUE_NAME>
        <LEVEL_CAPTION>Product Category</LEVEL_CAPTION>
        <LEVEL_NUMBER>3</LEVEL_NUMBER>
        <LEVEL_CARDINALITY>55</LEVEL_CARDINALITY>
        <LEVEL_TYPE>0</LEVEL_TYPE>
        <CUSTOM_ROLLUP_SETTINGS>0</CUSTOM_ROLLUP_SETTINGS>
        <LEVEL_UNIQUE_SETTINGS>0</LEVEL_UNIQUE_SETTINGS>
        <LEVEL_IS_VISIBLE>true</LEVEL_IS_VISIBLE>
        <DESCRIPTION>Sales Cube - Product Hierarchy - Product Category Level</DESCRIPTION>
      </row>
    </root>
  </cxmla:return>
</cxmla:DiscoverResponse>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""),
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>MDSCHEMA_MEMBERS</RequestType>
      <Restrictions>
        <RestrictionList>
          <CUBE_NAME>Sales</CUBE_NAME>
          <HIERARCHY_UNIQUE_NAME>[Product]</HIERARCHY_UNIQUE_NAME>
          <LEVEL_UNIQUE_NAME>[Product].[Product Category]</LEVEL_UNIQUE_NAME>
          <MEMBER_UNIQUE_NAME>[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]</MEMBER_UNIQUE_NAME>
        </RestrictionList>
      </Restrictions>
      <Properties>
        <PropertyList>
          <Catalog>FoodMart</Catalog>
        </PropertyList>
      </Properties>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="CATALOG_NAME" name="CATALOG_NAME" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="SCHEMA_NAME" name="SCHEMA_NAME" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="CUBE_NAME" name="CUBE_NAME" type="xsd:string"/>
            <xsd:element sql:field="DIMENSION_UNIQUE_NAME" name="DIMENSION_UNIQUE_NAME" type="xsd:string"/>
            <xsd:element sql:field="HIERARCHY_UNIQUE_NAME" name="HIERARCHY_UNIQUE_NAME" type="xsd:string"/>
            <xsd:element sql:field="LEVEL_UNIQUE_NAME" name="LEVEL_UNIQUE_NAME" type="xsd:string"/>
            <xsd:element sql:field="LEVEL_NUMBER" name="LEVEL_NUMBER" type="xsd:unsignedInt"/>
            <xsd:element sql:field="MEMBER_ORDINAL" name="MEMBER_ORDINAL" type="xsd:unsignedInt"/>
            <xsd:element sql:field="MEMBER_NAME" name="MEMBER_NAME" type="xsd:string"/>
            <xsd:element sql:field="MEMBER_UNIQUE_NAME" name="MEMBER_UNIQUE_NAME" type="xsd:string"/>
            <xsd:element sql:field="MEMBER_TYPE" name="MEMBER_TYPE" type="xsd:int"/>
            <xsd:element sql:field="MEMBER_GUID" name="MEMBER_GUID" type="uuid" minOccurs="0"/>
            <xsd:element sql:field="MEMBER_CAPTION" name="MEMBER_CAPTION" type="xsd:string"/>
            <xsd:element sql:field="CHILDREN_CARDINALITY" name="CHILDREN_CARDINALITY" type="xsd:unsignedInt"/>
            <xsd:element sql:field="PARENT_LEVEL" name="PARENT_LEVEL" type="xsd:unsignedInt"/>
            <xsd:element sql:field="PARENT_UNIQUE_NAME" name="PARENT_UNIQUE_NAME" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="PARENT_COUNT" name="PARENT_COUNT" type="xsd:unsignedInt"/>
            <xsd:element sql:field="TREE_OP" name="TREE_OP" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="DEPTH" name="DEPTH" type="xsd:int" minOccurs="0"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <CATALOG_NAME>FoodMart</CATALOG_NAME>
        <SCHEMA_NAME>FoodMart</SCHEMA_NAME>
        <CUBE_NAME>Sales</CUBE_NAME>
        <DIMENSION_UNIQUE_NAME>[Product]</DIMENSION_UNIQUE_NAME>
        <HIERARCHY_UNIQUE_NAME>[Product]</HIERARCHY_UNIQUE_NAME>
        <LEVEL_UNIQUE_NAME>[Product].[Product Category]</LEVEL_UNIQUE_NAME>
        <LEVEL_NUMBER>3</LEVEL_NUMBER>
        <MEMBER_ORDINAL>3</MEMBER_ORDINAL>
        <MEMBER_NAME>Beer and Wine</MEMBER_NAME>
        <MEMBER_UNIQUE_NAME>[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]</MEMBER_UNIQUE_NAME>
        <MEMBER_TYPE>1</MEMBER_TYPE>
        <MEMBER_CAPTION>Beer and Wine</MEMBER_CAPTION>
        <CHILDREN_CARDINALITY>2</CHILDREN_CARDINALITY>
        <PARENT_LEVEL>2</PARENT_LEVEL>
        <PARENT_UNIQUE_NAME>[Product].[Drink].[Alcoholic Beverages]</PARENT_UNIQUE_NAME>
        <PARENT_COUNT>1</PARENT_COUNT>
        <DEPTH>3</DEPTH>
      </row>
    </root>
  </cxmla:return>
</cxmla:DiscoverResponse>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""),
    ],
    "testGetDBSchemaCatalogs":[
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>DISCOVER_SCHEMA_ROWSETS</RequestType>
      <Restrictions xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
      <Properties xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="SchemaName" name="SchemaName" type="xsd:string"/>
            <xsd:element sql:field="SchemaGuid" name="SchemaGuid" type="uuid" minOccurs="0"/>
            <xsd:element sql:field="Restrictions" name="Restrictions" minOccurs="0" maxOccurs="unbounded">
              <xsd:complexType>
                <xsd:sequence>
                  <xsd:element name="Name" type="xsd:string" sql:field="Name"/>
                  <xsd:element name="Type" type="xsd:string" sql:field="Type"/>
                </xsd:sequence>
              </xsd:complexType>
            </xsd:element>
            <xsd:element sql:field="Description" name="Description" type="xsd:string"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <SchemaName>DBSCHEMA_CATALOGS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Identifies the physical attributes associated with catalogs accessible from the provider.</Description>
      </row>
      <row>
        <SchemaName>DBSCHEMA_COLUMNS</SchemaName>
        <Restrictions>
          <Name>TABLE_CATALOG</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_SCHEMA</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>COLUMN_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_PROVIDER_TYPES</SchemaName>
        <Restrictions>
          <Name>DATA_TYPE</Name>
          <Type>xsd:unsignedShort</Type>
        </Restrictions>
        <Restrictions>
          <Name>BEST_MATCH</Name>
          <Type>xsd:boolean</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_SCHEMATA</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_OWNER</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_TABLES</SchemaName>
        <Restrictions>
          <Name>TABLE_CATALOG</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_SCHEMA</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_TYPE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_TABLES_INFO</SchemaName>
        <Restrictions>
          <Name>TABLE_CATALOG</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_SCHEMA</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_TYPE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DISCOVER_DATASOURCES</SchemaName>
        <Restrictions>
          <Name>DataSourceName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>URL</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ProviderName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ProviderType</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>AuthenticationMode</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns a list of XML for Analysis data sources available on the server or Web Service.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_ENUMERATORS</SchemaName>
        <Restrictions>
          <Name>EnumName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns a list of names, data types, and enumeration values for enumerators supported by the provider of a specific data source.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_KEYWORDS</SchemaName>
        <Restrictions>
          <Name>Keyword</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns an XML list of keywords reserved by the provider.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_LITERALS</SchemaName>
        <Restrictions>
          <Name>LiteralName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns information about literals supported by the provider.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_PROPERTIES</SchemaName>
        <Restrictions>
          <Name>PropertyName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns a list of information and values about the requested properties that are supported by the specified data source provider.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_SCHEMA_ROWSETS</SchemaName>
        <Restrictions>
          <Name>SchemaName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns the names, values, and other information of all supported RequestType enumeration values.</Description>
      </row>
      <row>
        <SchemaName>MDSCHEMA_ACTIONS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ACTION_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>COORDINATE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>COORDINATE_TYPE</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_CUBES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_TYPE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_DIMENSIONS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_FUNCTIONS</SchemaName>
        <Restrictions>
          <Name>FUNCTION_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ORIGIN</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Restrictions>
          <Name>INTERFACE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LIBRARY_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_HIERARCHIES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_LEVELS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_MEASURES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEASURE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEASURE_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_MEMBERS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_NUMBER</Name>
          <Type>xsd:unsignedInt</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_TYPE</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_CAPTION</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TREE_OP</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_PROPERTIES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>PROPERTY_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>PROPERTY_TYPE</Name>
          <Type>xsd:short</Type>
        </Restrictions>
        <Restrictions>
          <Name>PROPERTY_CONTENT_TYPE</Name>
          <Type>xsd:short</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_SETS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SET_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCOPE</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Description/>
      </row>
    </root>
  </cxmla:return>
</cxmla:DiscoverResponse>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""),
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>DBSCHEMA_CATALOGS</RequestType>
      <Restrictions xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
      <Properties xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="CATALOG_NAME" name="CATALOG_NAME" type="xsd:string"/>
            <xsd:element sql:field="DESCRIPTION" name="DESCRIPTION" type="xsd:string"/>
            <xsd:element sql:field="ROLES" name="ROLES" type="xsd:string"/>
            <xsd:element sql:field="DATE_MODIFIED" name="DATE_MODIFIED" type="xsd:dateTime" minOccurs="0"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <CATALOG_NAME>FoodMart</CATALOG_NAME>
        <DESCRIPTION>No description available</DESCRIPTION>
        <ROLES/>
      </row>
    </root>
  </cxmla:return>
</cxmla:DiscoverResponse>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""),
    ],
    "testGetDBSchemaColumns":[
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>DISCOVER_SCHEMA_ROWSETS</RequestType>
      <Restrictions xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
      <Properties xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="SchemaName" name="SchemaName" type="xsd:string"/>
            <xsd:element sql:field="SchemaGuid" name="SchemaGuid" type="uuid" minOccurs="0"/>
            <xsd:element sql:field="Restrictions" name="Restrictions" minOccurs="0" maxOccurs="unbounded">
              <xsd:complexType>
                <xsd:sequence>
                  <xsd:element name="Name" type="xsd:string" sql:field="Name"/>
                  <xsd:element name="Type" type="xsd:string" sql:field="Type"/>
                </xsd:sequence>
              </xsd:complexType>
            </xsd:element>
            <xsd:element sql:field="Description" name="Description" type="xsd:string"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <SchemaName>DBSCHEMA_CATALOGS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Identifies the physical attributes associated with catalogs accessible from the provider.</Description>
      </row>
      <row>
        <SchemaName>DBSCHEMA_COLUMNS</SchemaName>
        <Restrictions>
          <Name>TABLE_CATALOG</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_SCHEMA</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>COLUMN_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_PROVIDER_TYPES</SchemaName>
        <Restrictions>
          <Name>DATA_TYPE</Name>
          <Type>xsd:unsignedShort</Type>
        </Restrictions>
        <Restrictions>
          <Name>BEST_MATCH</Name>
          <Type>xsd:boolean</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_SCHEMATA</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_OWNER</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_TABLES</SchemaName>
        <Restrictions>
          <Name>TABLE_CATALOG</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_SCHEMA</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_TYPE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DBSCHEMA_TABLES_INFO</SchemaName>
        <Restrictions>
          <Name>TABLE_CATALOG</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_SCHEMA</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TABLE_TYPE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>DISCOVER_DATASOURCES</SchemaName>
        <Restrictions>
          <Name>DataSourceName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>URL</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ProviderName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ProviderType</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>AuthenticationMode</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns a list of XML for Analysis data sources available on the server or Web Service.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_ENUMERATORS</SchemaName>
        <Restrictions>
          <Name>EnumName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns a list of names, data types, and enumeration values for enumerators supported by the provider of a specific data source.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_KEYWORDS</SchemaName>
        <Restrictions>
          <Name>Keyword</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns an XML list of keywords reserved by the provider.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_LITERALS</SchemaName>
        <Restrictions>
          <Name>LiteralName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns information about literals supported by the provider.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_PROPERTIES</SchemaName>
        <Restrictions>
          <Name>PropertyName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns a list of information and values about the requested properties that are supported by the specified data source provider.</Description>
      </row>
      <row>
        <SchemaName>DISCOVER_SCHEMA_ROWSETS</SchemaName>
        <Restrictions>
          <Name>SchemaName</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description>Returns the names, values, and other information of all supported RequestType enumeration values.</Description>
      </row>
      <row>
        <SchemaName>MDSCHEMA_ACTIONS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ACTION_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>COORDINATE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>COORDINATE_TYPE</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_CUBES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_TYPE</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_DIMENSIONS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_FUNCTIONS</SchemaName>
        <Restrictions>
          <Name>FUNCTION_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>ORIGIN</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Restrictions>
          <Name>INTERFACE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LIBRARY_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_HIERARCHIES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_LEVELS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_MEASURES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEASURE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEASURE_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_MEMBERS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_NUMBER</Name>
          <Type>xsd:unsignedInt</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_TYPE</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_CAPTION</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>TREE_OP</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_PROPERTIES</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>DIMENSION_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>HIERARCHY_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>LEVEL_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>MEMBER_UNIQUE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>PROPERTY_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>PROPERTY_TYPE</Name>
          <Type>xsd:short</Type>
        </Restrictions>
        <Restrictions>
          <Name>PROPERTY_CONTENT_TYPE</Name>
          <Type>xsd:short</Type>
        </Restrictions>
        <Description/>
      </row>
      <row>
        <SchemaName>MDSCHEMA_SETS</SchemaName>
        <Restrictions>
          <Name>CATALOG_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCHEMA_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>CUBE_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SET_NAME</Name>
          <Type>xsd:string</Type>
        </Restrictions>
        <Restrictions>
          <Name>SCOPE</Name>
          <Type>xsd:int</Type>
        </Restrictions>
        <Description/>
      </row>
    </root>
  </cxmla:return>
</cxmla:DiscoverResponse>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
"""),
        ("request", """<soap-env:Envelope xmlns:soap-env="http://schemas.xmlsoap.org/soap/envelope/" xmlns="urn:schemas-microsoft-com:xml-analysis">
  <soap-env:Body>
    <Discover>
      <RequestType>DBSCHEMA_COLUMNS</RequestType>
      <Restrictions xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
      <Properties xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:nil="true"/>
    </Discover>
  </soap-env:Body>
</soap-env:Envelope>
"""),
        ("response", """<SOAP-ENV:Envelope xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/" SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Header>
</SOAP-ENV:Header>
<SOAP-ENV:Body>
<cxmla:DiscoverResponse xmlns:cxmla="urn:schemas-microsoft-com:xml-analysis">
  <cxmla:return>
    <root xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:EX="urn:schemas-microsoft-com:xml-analysis:exception">
      <xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns="urn:schemas-microsoft-com:xml-analysis:rowset" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:sql="urn:schemas-microsoft-com:xml-sql" targetNamespace="urn:schemas-microsoft-com:xml-analysis:rowset" elementFormDefault="qualified">
        <xsd:element name="root">
          <xsd:complexType>
            <xsd:sequence>
              <xsd:element name="row" type="row" minOccurs="0" maxOccurs="unbounded"/>
            </xsd:sequence>
          </xsd:complexType>
        </xsd:element>
        <xsd:simpleType name="uuid">
          <xsd:restriction base="xsd:string">
            <xsd:pattern value="[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"/>
          </xsd:restriction>
        </xsd:simpleType>
        <xsd:complexType name="row">
          <xsd:sequence>
            <xsd:element sql:field="TABLE_CATALOG" name="TABLE_CATALOG" type="xsd:string"/>
            <xsd:element sql:field="TABLE_SCHEMA" name="TABLE_SCHEMA" type="xsd:string" minOccurs="0"/>
            <xsd:element sql:field="TABLE_NAME" name="TABLE_NAME" type="xsd:string"/>
            <xsd:element sql:field="COLUMN_NAME" name="COLUMN_NAME" type="xsd:string"/>
            <xsd:element sql:field="ORDINAL_POSITION" name="ORDINAL_POSITION" type="xsd:unsignedInt"/>
            <xsd:element sql:field="COLUMN_HAS_DEFAULT" name="COLUMN_HAS_DEFAULT" type="xsd:boolean" minOccurs="0"/>
            <xsd:element sql:field="COLUMN_FLAGS" name="COLUMN_FLAGS" type="xsd:unsignedInt"/>
            <xsd:element sql:field="IS_NULLABLE" name="IS_NULLABLE" type="xsd:boolean"/>
            <xsd:element sql:field="DATA_TYPE" name="DATA_TYPE" type="xsd:unsignedShort"/>
            <xsd:element sql:field="CHARACTER_MAXIMUM_LENGTH" name="CHARACTER_MAXIMUM_LENGTH" type="xsd:unsignedInt" minOccurs="0"/>
            <xsd:element sql:field="CHARACTER_OCTET_LENGTH" name="CHARACTER_OCTET_LENGTH" type="xsd:unsignedInt" minOccurs="0"/>
            <xsd:element sql:field="NUMERIC_PRECISION" name="NUMERIC_PRECISION" type="xsd:unsignedShort" minOccurs="0"/>
            <xsd:element sql:field="NUMERIC_SCALE" name="NUMERIC_SCALE" type="xsd:short" minOccurs="0"/>
          </xsd:sequence>
        </xsd:complexType>
      </xsd:schema>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>2</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>3</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>4</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>5</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>6</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>7</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>8</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>9</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>10</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>11</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>12</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>13</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>14</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>15</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>16</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>17</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>18</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>19</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>20</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>21</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>22</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>23</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>24</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>25</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>26</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>27</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>28</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>29</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>30</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>31</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>32</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>33</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>34</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>35</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>36</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>37</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>38</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>39</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>40</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>41</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>42</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>43</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>44</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>45</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>46</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>47</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>48</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>49</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>50</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>51</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>52</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>53</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>54</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>55</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>56</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>57</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>58</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>59</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>60</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>61</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>62</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>63</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>64</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>65</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>66</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>67</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Year!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>68</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>69</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>70</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>71</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>72</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>73</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>74</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>75</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>76</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>77</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>78</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>79</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>80</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>81</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>82</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>83</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>84</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>85</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>86</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>87</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>88</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>89</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>90</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>91</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>92</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>93</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>94</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>95</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>96</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>97</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>98</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>99</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>100</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>101</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>102</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>103</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>104</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>105</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>106</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>107</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>108</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>109</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>110</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>111</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>112</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>113</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>114</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>115</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>116</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>117</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>118</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>119</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>120</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>121</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>122</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>123</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>124</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>125</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>126</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>127</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>128</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>129</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>130</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>131</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>132</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>133</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>134</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>135</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>136</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Time:Month!$name</COLUMN_NAME>
        <ORDINAL_POSITION>137</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>138</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>139</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>140</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>141</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>142</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>143</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>144</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>145</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>146</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>147</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>148</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>149</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>150</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>151</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>152</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>153</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>154</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>155</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>156</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>157</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>158</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>159</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>160</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>161</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>162</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>163</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>164</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>165</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>166</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>167</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>168</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>169</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>170</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>171</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>172</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>173</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>174</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>175</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>176</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>177</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>178</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>179</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>180</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>181</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>182</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>183</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>184</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>185</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>186</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>187</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>188</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>189</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>190</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>191</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>192</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>193</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>194</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>195</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>196</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>197</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>198</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>199</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>200</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>201</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>202</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>203</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>204</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>205</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>206</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>207</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>208</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>209</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>210</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>211</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>212</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>213</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>214</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>215</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>216</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>217</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>218</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>219</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>220</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>221</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>222</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>223</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>224</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>225</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>226</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>227</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>228</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>229</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>230</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>231</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>232</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>233</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>234</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>235</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>236</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>237</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>238</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>239</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>240</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>241</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>242</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>243</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>244</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>245</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>246</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>247</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>248</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>249</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>250</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>251</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>252</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>253</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>254</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>255</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>256</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>257</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>258</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>259</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>260</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>261</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>262</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>263</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>264</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>265</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>266</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>267</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>268</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>269</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>270</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>271</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>272</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>273</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>274</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>275</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>276</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>277</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>278</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>279</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>280</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>281</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>282</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>283</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>284</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>285</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>286</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>287</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>288</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>289</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>290</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>291</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>292</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>293</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>294</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>295</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>296</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>297</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>298</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>299</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>300</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>301</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>302</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>303</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>304</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>305</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>306</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>307</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>308</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>309</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Store Type</COLUMN_NAME>
        <ORDINAL_POSITION>310</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Store Manager</COLUMN_NAME>
        <ORDINAL_POSITION>311</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Store Sqft</COLUMN_NAME>
        <ORDINAL_POSITION>312</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Grocery Sqft</COLUMN_NAME>
        <ORDINAL_POSITION>313</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Frozen Sqft</COLUMN_NAME>
        <ORDINAL_POSITION>314</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Meat Sqft</COLUMN_NAME>
        <ORDINAL_POSITION>315</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Has coffee bar</COLUMN_NAME>
        <ORDINAL_POSITION>316</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Street address</COLUMN_NAME>
        <ORDINAL_POSITION>317</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>318</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>319</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>320</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>321</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>322</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>323</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>324</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>325</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>326</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>327</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>328</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>329</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>330</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>331</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>332</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>333</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>334</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>335</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>336</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>337</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>338</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>339</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>340</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>341</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>342</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>343</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>344</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>345</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>346</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>347</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>348</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>349</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>350</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>351</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>352</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>353</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>354</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>355</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>356</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>357</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>358</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>359</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>360</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>361</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>362</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>363</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>364</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>365</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>366</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>367</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>368</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>369</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>370</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>371</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>372</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>373</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>374</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>375</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>376</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>377</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>378</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>379</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>380</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>381</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>382</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>383</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>384</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>385</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>386</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Pay Type:Pay Type!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>387</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>388</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>389</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>390</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>391</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>392</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>393</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>394</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>395</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>396</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>397</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>398</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>399</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>400</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>401</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>402</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>403</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>404</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>405</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>406</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>407</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>408</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>409</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>410</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>411</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>412</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>413</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>414</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>415</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>416</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>417</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>418</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>419</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>420</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>421</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>422</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>423</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>424</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>425</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>426</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>427</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>428</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>429</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>430</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>431</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>432</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>433</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>434</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>435</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>436</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>437</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>438</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>439</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>440</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>441</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>442</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>443</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>444</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>445</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>446</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>447</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>448</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>449</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>450</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>451</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>452</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>453</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>454</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>455</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>456</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>457</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>458</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>459</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>460</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>461</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>462</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>463</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>464</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>465</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>466</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>467</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>468</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>469</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>470</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>471</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>472</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>473</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>474</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>475</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>476</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>477</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>478</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>479</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>480</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>481</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>482</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>483</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>484</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>485</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>486</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>487</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>488</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>489</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>490</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>491</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>492</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>493</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>494</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>495</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>496</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>497</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>498</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>499</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>500</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>501</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>502</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>503</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>504</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>505</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>506</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>507</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>508</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>509</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>510</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>511</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>512</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>513</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>514</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>515</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>516</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>517</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>518</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>519</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>520</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>521</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>522</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>523</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>524</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>525</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>526</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Management Role!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>527</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>528</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>529</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>530</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>531</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>532</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>533</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>534</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>535</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>536</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>537</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>538</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>539</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>540</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>541</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>542</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>543</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>544</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>545</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>546</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>547</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>548</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>549</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>550</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>551</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>552</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>553</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>554</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>555</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>556</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>557</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>558</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>559</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>560</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Position:Position Title!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>561</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>562</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>563</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>564</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>565</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>566</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>567</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>568</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>569</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>570</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>571</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>572</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>573</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>574</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>575</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>576</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>577</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>578</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>579</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>580</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>581</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>582</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>583</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>584</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>585</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>586</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>587</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>588</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>589</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>590</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>591</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>592</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>593</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>594</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>595</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>596</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>597</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>598</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>599</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>600</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>601</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>602</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>603</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>604</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>605</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>606</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>607</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>608</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>609</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>610</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>611</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>612</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>613</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>614</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>615</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>616</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>617</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>618</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>619</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>620</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>621</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>622</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>623</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>624</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>625</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>626</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>627</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>628</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>629</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>630</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Department:Department Description!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>631</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>632</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>633</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>634</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>635</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>636</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>637</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>638</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>639</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>640</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>641</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>642</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>643</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>644</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>645</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>646</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>647</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>648</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>649</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>650</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>651</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>652</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>653</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>654</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>655</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>656</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>657</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>658</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>659</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>660</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>661</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>662</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>663</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>664</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>665</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>666</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>667</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>668</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>669</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>670</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>671</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>672</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>673</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>674</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>675</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>676</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>677</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>678</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>679</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>680</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>681</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>682</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>683</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>684</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>685</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>686</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>687</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>688</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>689</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>690</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>691</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>692</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>693</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>694</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>695</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>696</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>697</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>698</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>699</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>700</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>701</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!$name</COLUMN_NAME>
        <ORDINAL_POSITION>702</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!Marital Status</COLUMN_NAME>
        <ORDINAL_POSITION>703</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!Position Title</COLUMN_NAME>
        <ORDINAL_POSITION>704</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!Gender</COLUMN_NAME>
        <ORDINAL_POSITION>705</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!Salary</COLUMN_NAME>
        <ORDINAL_POSITION>706</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!Education Level</COLUMN_NAME>
        <ORDINAL_POSITION>707</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Employees:Employee Id!Management Role</COLUMN_NAME>
        <ORDINAL_POSITION>708</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:Count</COLUMN_NAME>
        <ORDINAL_POSITION>709</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:Number of Employees</COLUMN_NAME>
        <ORDINAL_POSITION>710</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:Employee Salary</COLUMN_NAME>
        <ORDINAL_POSITION>711</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>HR</TABLE_NAME>
        <COLUMN_NAME>Measures:Avg Salary</COLUMN_NAME>
        <ORDINAL_POSITION>712</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>713</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>714</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>715</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>716</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>717</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>718</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>719</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>720</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>721</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>722</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>723</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>724</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>725</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>726</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>727</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>728</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>729</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>730</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>731</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>732</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>733</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>734</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>735</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>736</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>737</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>738</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>739</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>740</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>741</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>742</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>743</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>744</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>745</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Measures:MeasuresLevel!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>746</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>747</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>748</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>749</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>750</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>751</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>752</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>753</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>754</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>755</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>756</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>757</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>758</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>759</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>760</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>761</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>762</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>763</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>764</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>765</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>766</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>767</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>768</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>769</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>770</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>771</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>772</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>773</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>774</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>775</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>776</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>777</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>778</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>779</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>780</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>781</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>782</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>783</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>784</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>785</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>786</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>787</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>788</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>789</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>790</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>791</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>792</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>793</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>794</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>795</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>796</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>797</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>798</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>799</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>800</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>801</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>802</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>803</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>804</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>805</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>806</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>807</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>808</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>809</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>810</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>811</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>812</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>813</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>814</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>815</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Country!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>816</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>817</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>818</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>819</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>820</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>821</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>822</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>823</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>824</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>825</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>826</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>827</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>828</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>829</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>830</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>831</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>832</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>833</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>834</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>835</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>836</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>837</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>838</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>839</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>840</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>841</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>842</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>843</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>844</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>845</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>846</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>847</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>848</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>849</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store State!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>850</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>851</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>852</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>853</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>854</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>855</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>856</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>857</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>858</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>859</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>860</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>861</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>862</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>863</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>864</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>865</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>866</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>867</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>868</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>869</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>870</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>871</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>872</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>873</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>874</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>875</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>876</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>877</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>878</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>879</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>880</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>881</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>882</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>883</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store City!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>884</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>885</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>886</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>887</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>888</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>889</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>890</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>891</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>892</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>893</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>894</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>895</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>896</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>897</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>898</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>899</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>900</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>901</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>902</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>903</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>904</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>905</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>906</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>907</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>908</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>909</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>910</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>911</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>912</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>913</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>914</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>915</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>916</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>917</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>918</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Store Type</COLUMN_NAME>
        <ORDINAL_POSITION>919</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Store Manager</COLUMN_NAME>
        <ORDINAL_POSITION>920</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Store Sqft</COLUMN_NAME>
        <ORDINAL_POSITION>921</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Grocery Sqft</COLUMN_NAME>
        <ORDINAL_POSITION>922</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Frozen Sqft</COLUMN_NAME>
        <ORDINAL_POSITION>923</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Meat Sqft</COLUMN_NAME>
        <ORDINAL_POSITION>924</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Has coffee bar</COLUMN_NAME>
        <ORDINAL_POSITION>925</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store:Store Name!Street address</COLUMN_NAME>
        <ORDINAL_POSITION>926</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>927</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>928</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>929</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>930</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>931</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>932</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>933</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>934</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>935</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>936</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>937</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>938</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>939</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>940</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>941</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>942</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>943</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>944</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>945</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>946</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>947</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>948</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>949</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>950</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>951</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>952</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>953</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>954</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>955</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>956</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>957</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>958</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>959</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>960</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>961</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>962</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>963</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>964</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>965</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>966</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>967</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>968</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>969</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>970</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>971</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>972</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>973</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>974</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>975</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>976</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>977</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>978</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>979</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>980</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>981</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>982</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>983</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>984</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>985</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>986</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>987</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>988</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>989</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>990</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>991</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>992</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>993</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>994</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>995</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Size in SQFT:Store Sqft!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>996</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>997</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>998</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>999</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1000</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1001</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1002</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1003</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1004</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1005</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1006</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1007</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1008</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1009</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1010</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1011</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1012</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1013</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1014</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1015</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1016</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1017</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1018</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1019</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1020</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1021</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1022</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1023</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1024</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1025</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1026</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1027</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1028</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1029</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1030</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1031</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1032</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1033</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1034</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1035</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1036</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1037</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1038</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1039</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1040</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1041</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1042</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1043</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1044</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1045</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1046</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1047</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1048</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1049</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1050</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1051</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1052</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1053</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1054</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1055</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1056</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1057</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1058</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1059</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1060</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1061</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1062</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1063</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1064</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1065</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Store Type:Store Type!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1066</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1067</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1068</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1069</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1070</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1071</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1072</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1073</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1074</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1075</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1076</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1077</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1078</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1079</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1080</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1081</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1082</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1083</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1084</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1085</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1086</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1087</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1088</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1089</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1090</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1091</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1092</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1093</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1094</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1095</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1096</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1097</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1098</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1099</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Year!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1100</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1101</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1102</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1103</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1104</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1105</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1106</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1107</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1108</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1109</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1110</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1111</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1112</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1113</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1114</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1115</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1116</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1117</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1118</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1119</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1120</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1121</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1122</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1123</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1124</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1125</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1126</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1127</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1128</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1129</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1130</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1131</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1132</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1133</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Quarter!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1134</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1135</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1136</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1137</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1138</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1139</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1140</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1141</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1142</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1143</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1144</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1145</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1146</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1147</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1148</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1149</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1150</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1151</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1152</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1153</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1154</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1155</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1156</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1157</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1158</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1159</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1160</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1161</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1162</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1163</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1164</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1165</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1166</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1167</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time:Month!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1168</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1169</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1170</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1171</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1172</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1173</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1174</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1175</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1176</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1177</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1178</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1179</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1180</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1181</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1182</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1183</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1184</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1185</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1186</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1187</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1188</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1189</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1190</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1191</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1192</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1193</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1194</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1195</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1196</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1197</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1198</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1199</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1200</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1201</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1202</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1203</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1204</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1205</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1206</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1207</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1208</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1209</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1210</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1211</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1212</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1213</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1214</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1215</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1216</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1217</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1218</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1219</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1220</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1221</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1222</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1223</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1224</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1225</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1226</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1227</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1228</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1229</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1230</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1231</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1232</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1233</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1234</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1235</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1236</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1237</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Year!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1238</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1239</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1240</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1241</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1242</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1243</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1244</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1245</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1246</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1247</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1248</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1249</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1250</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1251</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1252</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1253</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1254</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1255</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1256</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1257</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1258</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1259</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1260</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1261</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1262</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1263</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1264</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1265</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1266</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1267</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1268</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1269</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1270</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1271</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Week!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1272</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1273</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1274</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1275</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1276</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1277</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1278</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1279</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1280</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1281</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1282</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1283</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1284</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1285</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1286</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1287</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1288</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1289</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1290</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1291</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1292</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1293</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1294</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1295</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1296</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1297</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1298</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1299</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1300</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1301</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1302</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1303</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1304</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1305</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Time.Weekly:Day!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1306</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1307</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1308</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1309</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1310</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1311</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1312</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1313</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1314</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1315</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1316</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1317</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1318</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1319</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1320</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1321</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1322</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1323</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1324</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1325</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1326</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1327</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1328</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1329</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1330</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1331</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1332</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1333</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1334</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1335</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1336</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1337</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1338</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1339</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1340</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1341</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1342</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1343</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1344</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1345</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1346</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1347</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1348</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1349</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1350</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1351</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1352</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1353</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1354</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1355</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1356</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1357</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1358</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1359</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1360</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1361</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1362</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1363</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1364</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1365</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1366</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1367</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1368</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1369</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1370</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1371</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1372</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1373</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1374</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1375</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Family!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1376</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1377</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1378</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1379</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1380</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1381</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1382</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1383</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1384</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1385</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1386</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1387</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1388</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1389</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1390</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1391</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1392</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1393</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1394</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1395</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1396</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1397</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1398</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1399</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1400</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1401</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1402</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1403</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1404</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1405</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1406</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1407</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1408</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1409</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Department!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1410</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1411</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1412</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1413</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1414</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1415</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1416</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1417</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1418</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1419</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1420</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1421</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1422</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1423</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1424</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1425</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1426</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1427</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1428</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1429</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1430</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1431</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1432</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1433</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1434</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1435</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1436</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1437</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1438</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1439</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1440</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1441</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1442</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1443</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Category!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1444</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1445</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1446</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1447</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1448</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1449</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1450</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1451</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1452</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1453</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1454</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1455</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1456</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1457</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1458</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1459</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1460</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1461</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1462</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1463</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1464</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1465</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1466</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1467</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1468</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1469</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1470</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1471</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1472</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1473</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1474</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1475</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1476</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1477</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Subcategory!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1478</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1479</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1480</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1481</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1482</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1483</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1484</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1485</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1486</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1487</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1488</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1489</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1490</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1491</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1492</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1493</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1494</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1495</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1496</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1497</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1498</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1499</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1500</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1501</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1502</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1503</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1504</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1505</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1506</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1507</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1508</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1509</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1510</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1511</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Brand Name!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1512</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1513</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1514</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1515</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1516</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1517</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1518</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1519</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1520</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1521</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1522</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1523</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1524</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1525</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1526</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1527</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1528</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1529</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1530</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1531</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1532</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1533</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1534</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1535</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1536</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1537</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1538</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1539</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1540</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1541</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1542</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1543</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1544</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1545</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Product:Product Name!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1546</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1547</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1548</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1549</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1550</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1551</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1552</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1553</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1554</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1555</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1556</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1557</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1558</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1559</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1560</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1561</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1562</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1563</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1564</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1565</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1566</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1567</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1568</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1569</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1570</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1571</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1572</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1573</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1574</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1575</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1576</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1577</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1578</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1579</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1580</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1581</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1582</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1583</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1584</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1585</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1586</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1587</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1588</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1589</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1590</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1591</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1592</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1593</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1594</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1595</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1596</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1597</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1598</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1599</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1600</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1601</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1602</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1603</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1604</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1605</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1606</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1607</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1608</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1609</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1610</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1611</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1612</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1613</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1614</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1615</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotion Media:Media Type!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1616</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1617</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1618</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1619</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1620</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1621</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1622</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1623</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1624</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1625</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1626</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1627</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1628</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1629</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1630</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1631</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1632</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1633</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1634</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1635</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1636</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1637</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1638</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1639</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1640</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1641</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1642</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1643</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1644</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1645</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1646</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1647</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1648</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1649</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1650</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1651</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1652</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1653</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1654</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1655</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1656</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1657</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1658</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1659</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1660</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1661</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1662</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1663</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1664</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1665</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1666</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1667</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1668</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1669</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1670</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1671</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1672</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1673</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1674</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1675</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1676</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1677</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1678</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1679</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1680</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1681</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1682</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1683</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1684</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1685</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Promotions:Promotion Name!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1686</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1687</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1688</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1689</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1690</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1691</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1692</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1693</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1694</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1695</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1696</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1697</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1698</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1699</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1700</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1701</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1702</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1703</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1704</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1705</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1706</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1707</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1708</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1709</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1710</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1711</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1712</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1713</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1714</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1715</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1716</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1717</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1718</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1719</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1720</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1721</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:(All)!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1722</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1723</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1724</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1725</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1726</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1727</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1728</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1729</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1730</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1731</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1732</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1733</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1734</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1735</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1736</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1737</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1738</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1739</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1740</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1741</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1742</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1743</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1744</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1745</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1746</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1747</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1748</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1749</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1750</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1751</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1752</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1753</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1754</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1755</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:Country!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1756</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1757</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1758</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1759</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1760</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1761</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1762</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1763</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1764</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1765</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1766</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1767</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1768</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1769</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!MEMBER_GUID</COLUMN_NAME>
        <ORDINAL_POSITION>1770</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!MEMBER_CAPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1771</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!CHILDREN_CARDINALITY</COLUMN_NAME>
        <ORDINAL_POSITION>1772</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!PARENT_LEVEL</COLUMN_NAME>
        <ORDINAL_POSITION>1773</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!PARENT_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1774</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!PARENT_COUNT</COLUMN_NAME>
        <ORDINAL_POSITION>1775</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!DESCRIPTION</COLUMN_NAME>
        <ORDINAL_POSITION>1776</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!$visible</COLUMN_NAME>
        <ORDINAL_POSITION>1777</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!MEMBER_KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1778</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!IS_PLACEHOLDERMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1779</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!IS_DATAMEMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1780</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>11</DATA_TYPE>
        <NUMERIC_PRECISION>255</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!DEPTH</COLUMN_NAME>
        <ORDINAL_POSITION>1781</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!DISPLAY_INFO</COLUMN_NAME>
        <ORDINAL_POSITION>1782</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!VALUE</COLUMN_NAME>
        <ORDINAL_POSITION>1783</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!$scenario</COLUMN_NAME>
        <ORDINAL_POSITION>1784</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!CELL_FORMATTER</COLUMN_NAME>
        <ORDINAL_POSITION>1785</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!CELL_FORMATTER_SCRIPT</COLUMN_NAME>
        <ORDINAL_POSITION>1786</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!CELL_FORMATTER_SCRIPT_LANGUAGE</COLUMN_NAME>
        <ORDINAL_POSITION>1787</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!DISPLAY_FOLDER</COLUMN_NAME>
        <ORDINAL_POSITION>1788</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!FORMAT_EXP</COLUMN_NAME>
        <ORDINAL_POSITION>1789</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:State Province!KEY</COLUMN_NAME>
        <ORDINAL_POSITION>1790</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1791</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1792</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!CATALOG_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1793</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!SCHEMA_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1794</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!CUBE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1795</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!DIMENSION_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1796</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!HIERARCHY_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1797</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!LEVEL_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1798</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!LEVEL_NUMBER</COLUMN_NAME>
        <ORDINAL_POSITION>1799</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!MEMBER_ORDINAL</COLUMN_NAME>
        <ORDINAL_POSITION>1800</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>5</DATA_TYPE>
        <NUMERIC_PRECISION>16</NUMERIC_PRECISION>
        <NUMERIC_SCALE>255</NUMERIC_SCALE>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!MEMBER_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1801</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!MEMBER_UNIQUE_NAME</COLUMN_NAME>
        <ORDINAL_POSITION>1802</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS_NULLABLE>false</IS_NULLABLE>
        <DATA_TYPE>130</DATA_TYPE>
        <CHARACTER_MAXIMUM_LENGTH>0</CHARACTER_MAXIMUM_LENGTH>
        <CHARACTER_OCTET_LENGTH>0</CHARACTER_OCTET_LENGTH>
      </row>
      <row>
        <TABLE_CATALOG>FoodMart</TABLE_CATALOG>
        <TABLE_NAME>Sales</TABLE_NAME>
        <COLUMN_NAME>Customers:City!MEMBER_TYPE</COLUMN_NAME>
        <ORDINAL_POSITION>1803</ORDINAL_POSITION>
        <COLUMN_HAS_DEFAULT>false</COLUMN_HAS_DEFAULT>
        <COLUMN_FLAGS>0</COLUMN_FLAGS>
        <IS