"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpServiceDiscoveryIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_1 = require("./private/integration");
/**
 * The Service Discovery integration resource for HTTP API
 */
class HttpServiceDiscoveryIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param service the service discovery resource to integrate with
     * @param props properties to configure the integration
     */
    constructor(id, service, props = {}) {
        super(id);
        this.service = service;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpServiceDiscoveryIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpServiceDiscoveryIntegration);
            }
            throw error;
        }
    }
    bind(_) {
        if (!this.props.vpcLink) {
            throw new Error('The vpcLink property is mandatory');
        }
        return {
            method: this.props.method ?? this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: this.props.vpcLink.vpcLinkId,
            uri: this.service.serviceArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
HttpServiceDiscoveryIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpServiceDiscoveryIntegration", version: "2.72.0-alpha.0" };
exports.HttpServiceDiscoveryIntegration = HttpServiceDiscoveryIntegration;
//# sourceMappingURL=data:application/json;base64,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