"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpNlbIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
const integration_1 = require("./private/integration");
/**
 * The Network Load Balancer integration resource for HTTP API
 */
class HttpNlbIntegration extends integration_1.HttpPrivateIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param listener the ELB network listener
     * @param props properties to configure the integration
     */
    constructor(id, listener, props = {}) {
        super(id);
        this.listener = listener;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpNlbIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpNlbIntegration);
            }
            throw error;
        }
    }
    bind(options) {
        let vpc = this.props.vpcLink?.vpc;
        if (!vpc && (this.listener instanceof elbv2.NetworkListener)) {
            vpc = this.listener.loadBalancer.vpc;
        }
        if (!vpc) {
            throw new Error('The vpcLink property must be specified when using an imported Network Listener.');
        }
        const vpcLink = this._configureVpcLink(options, {
            vpcLink: this.props.vpcLink,
            vpc,
        });
        return {
            method: this.props.method ?? this.httpMethod,
            payloadFormatVersion: this.payloadFormatVersion,
            type: this.integrationType,
            connectionType: this.connectionType,
            connectionId: vpcLink.vpcLinkId,
            uri: this.listener.listenerArn,
            secureServerName: this.props.secureServerName,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
HttpNlbIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpNlbIntegration", version: "2.72.0-alpha.0" };
exports.HttpNlbIntegration = HttpNlbIntegration;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmxiLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibmxiLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLGdFQUFnRTtBQUVoRSx1REFBK0Q7QUFRL0Q7O0dBRUc7QUFDSCxNQUFhLGtCQUFtQixTQUFRLG9DQUFzQjtJQUM1RDs7OztPQUlHO0lBQ0gsWUFDRSxFQUFVLEVBQ08sUUFBZ0MsRUFDaEMsUUFBaUMsRUFBRTtRQUVwRCxLQUFLLENBQUMsRUFBRSxDQUFDLENBQUM7UUFITyxhQUFRLEdBQVIsUUFBUSxDQUF3QjtRQUNoQyxVQUFLLEdBQUwsS0FBSyxDQUE4Qjs7Ozs7OytDQVQzQyxrQkFBa0I7Ozs7S0FZNUI7SUFFTSxJQUFJLENBQUMsT0FBd0M7UUFDbEQsSUFBSSxHQUFHLEdBQXlCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQztRQUN4RCxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsWUFBWSxLQUFLLENBQUMsZUFBZSxDQUFDLEVBQUU7WUFDNUQsR0FBRyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQztTQUN0QztRQUNELElBQUksQ0FBQyxHQUFHLEVBQUU7WUFDUixNQUFNLElBQUksS0FBSyxDQUFDLGlGQUFpRixDQUFDLENBQUM7U0FDcEc7UUFFRCxNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFO1lBQzlDLE9BQU8sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU87WUFDM0IsR0FBRztTQUNKLENBQUMsQ0FBQztRQUVILE9BQU87WUFDTCxNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLElBQUksSUFBSSxDQUFDLFVBQVU7WUFDNUMsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUMvQyxJQUFJLEVBQUUsSUFBSSxDQUFDLGVBQWU7WUFDMUIsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLFlBQVksRUFBRSxPQUFPLENBQUMsU0FBUztZQUMvQixHQUFHLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXO1lBQzlCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCO1lBQzdDLGdCQUFnQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCO1NBQzlDLENBQUM7S0FDSDs7OztBQXRDVSxnREFBa0IiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBIdHRwUm91dGVJbnRlZ3JhdGlvbkJpbmRPcHRpb25zLCBIdHRwUm91dGVJbnRlZ3JhdGlvbkNvbmZpZyB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1hcGlnYXRld2F5djItYWxwaGEnO1xuaW1wb3J0ICogYXMgZWMyIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgZWxidjIgZnJvbSAnYXdzLWNkay1saWIvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5ndjInO1xuaW1wb3J0IHsgSHR0cFByaXZhdGVJbnRlZ3JhdGlvbk9wdGlvbnMgfSBmcm9tICcuL2Jhc2UtdHlwZXMnO1xuaW1wb3J0IHsgSHR0cFByaXZhdGVJbnRlZ3JhdGlvbiB9IGZyb20gJy4vcHJpdmF0ZS9pbnRlZ3JhdGlvbic7XG5cbi8qKlxuICogUHJvcGVydGllcyB0byBpbml0aWFsaXplIGBIdHRwTmxiSW50ZWdyYXRpb25gLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBObGJJbnRlZ3JhdGlvblByb3BzIGV4dGVuZHMgSHR0cFByaXZhdGVJbnRlZ3JhdGlvbk9wdGlvbnMge1xufVxuXG4vKipcbiAqIFRoZSBOZXR3b3JrIExvYWQgQmFsYW5jZXIgaW50ZWdyYXRpb24gcmVzb3VyY2UgZm9yIEhUVFAgQVBJXG4gKi9cbmV4cG9ydCBjbGFzcyBIdHRwTmxiSW50ZWdyYXRpb24gZXh0ZW5kcyBIdHRwUHJpdmF0ZUludGVncmF0aW9uIHtcbiAgLyoqXG4gICAqIEBwYXJhbSBpZCBpZCBvZiB0aGUgdW5kZXJseWluZyBpbnRlZ3JhdGlvbiBjb25zdHJ1Y3RcbiAgICogQHBhcmFtIGxpc3RlbmVyIHRoZSBFTEIgbmV0d29yayBsaXN0ZW5lclxuICAgKiBAcGFyYW0gcHJvcHMgcHJvcGVydGllcyB0byBjb25maWd1cmUgdGhlIGludGVncmF0aW9uXG4gICAqL1xuICBjb25zdHJ1Y3RvcihcbiAgICBpZDogc3RyaW5nLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgbGlzdGVuZXI6IGVsYnYyLklOZXR3b3JrTGlzdGVuZXIsXG4gICAgcHJpdmF0ZSByZWFkb25seSBwcm9wczogSHR0cE5sYkludGVncmF0aW9uUHJvcHMgPSB7fSkge1xuXG4gICAgc3VwZXIoaWQpO1xuICB9XG5cbiAgcHVibGljIGJpbmQob3B0aW9uczogSHR0cFJvdXRlSW50ZWdyYXRpb25CaW5kT3B0aW9ucyk6IEh0dHBSb3V0ZUludGVncmF0aW9uQ29uZmlnIHtcbiAgICBsZXQgdnBjOiBlYzIuSVZwYyB8IHVuZGVmaW5lZCA9IHRoaXMucHJvcHMudnBjTGluaz8udnBjO1xuICAgIGlmICghdnBjICYmICh0aGlzLmxpc3RlbmVyIGluc3RhbmNlb2YgZWxidjIuTmV0d29ya0xpc3RlbmVyKSkge1xuICAgICAgdnBjID0gdGhpcy5saXN0ZW5lci5sb2FkQmFsYW5jZXIudnBjO1xuICAgIH1cbiAgICBpZiAoIXZwYykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdUaGUgdnBjTGluayBwcm9wZXJ0eSBtdXN0IGJlIHNwZWNpZmllZCB3aGVuIHVzaW5nIGFuIGltcG9ydGVkIE5ldHdvcmsgTGlzdGVuZXIuJyk7XG4gICAgfVxuXG4gICAgY29uc3QgdnBjTGluayA9IHRoaXMuX2NvbmZpZ3VyZVZwY0xpbmsob3B0aW9ucywge1xuICAgICAgdnBjTGluazogdGhpcy5wcm9wcy52cGNMaW5rLFxuICAgICAgdnBjLFxuICAgIH0pO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIG1ldGhvZDogdGhpcy5wcm9wcy5tZXRob2QgPz8gdGhpcy5odHRwTWV0aG9kLFxuICAgICAgcGF5bG9hZEZvcm1hdFZlcnNpb246IHRoaXMucGF5bG9hZEZvcm1hdFZlcnNpb24sXG4gICAgICB0eXBlOiB0aGlzLmludGVncmF0aW9uVHlwZSxcbiAgICAgIGNvbm5lY3Rpb25UeXBlOiB0aGlzLmNvbm5lY3Rpb25UeXBlLFxuICAgICAgY29ubmVjdGlvbklkOiB2cGNMaW5rLnZwY0xpbmtJZCxcbiAgICAgIHVyaTogdGhpcy5saXN0ZW5lci5saXN0ZW5lckFybixcbiAgICAgIHNlY3VyZVNlcnZlck5hbWU6IHRoaXMucHJvcHMuc2VjdXJlU2VydmVyTmFtZSxcbiAgICAgIHBhcmFtZXRlck1hcHBpbmc6IHRoaXMucHJvcHMucGFyYW1ldGVyTWFwcGluZyxcbiAgICB9O1xuICB9XG59XG4iXX0=