/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.util.HashMap;
import java.util.Map;
import thredds.util.PathAliasReplacement;
import ucar.unidata.util.StringUtil2;

public class PathAliasReplacementFromMap
implements PathAliasReplacement {
    private final Map<String, String> aliases;

    public PathAliasReplacementFromMap(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public PathAliasReplacementFromMap(String ... keyvals) {
        this.aliases = new HashMap<String, String>();
        for (int i = 0; i < keyvals.length; i += 2) {
            this.aliases.put(keyvals[i], keyvals[i + 1]);
        }
    }

    @Override
    public boolean containsPathAlias(String path) {
        for (String key : this.aliases.keySet()) {
            if (!path.contains(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String replaceIfMatch(String path) {
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            if (!path.contains(entry.getKey())) continue;
            return StringUtil2.replace(path, entry.getKey(), entry.getValue());
        }
        return path;
    }

    @Override
    public String replacePathAlias(String path) {
        return this.replaceIfMatch(path);
    }
}

