/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import loci.common.DateTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffRational;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTiffReader
extends MinimalTiffReader {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseTiffReader.class);
    public static final String[] DATE_FORMATS = new String[]{"yyyy:MM:dd HH:mm:ss", "dd/MM/yyyy HH:mm:ss", "MM/dd/yyyy hh:mm:ss aa", "yyyyMMdd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssZ"};

    public BaseTiffReader(String name, String suffix) {
        super(name, suffix);
    }

    public BaseTiffReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    protected void initMetadata() throws FormatException, IOException {
        this.initStandardMetadata();
        this.initMetadataStore();
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        IFDList exifIFDs;
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        for (int i = 0; i < this.ifds.size(); ++i) {
            this.put("PageName #" + i, (IFD)this.ifds.get(i), 285);
        }
        IFD firstIFD = (IFD)this.ifds.get(0);
        this.put("ImageWidth", firstIFD, 256);
        this.put("ImageLength", firstIFD, 257);
        this.put("BitsPerSample", firstIFD, 258);
        if (((IFD)this.ifds.get(0)).containsKey(34665) && (exifIFDs = this.tiffParser.getExifIFDs()).size() > 0) {
            IFD exif = (IFD)exifIFDs.get(0);
            this.tiffParser.fillInIFD(exif);
            for (Integer key : exif.keySet()) {
                int k = key;
                this.addGlobalMeta(BaseTiffReader.getExifTagName(k), exif.get(key));
            }
        }
        TiffCompression comp = firstIFD.getCompression();
        this.put("Compression", comp.getCodecName());
        PhotoInterp photo = firstIFD.getPhotometricInterpretation();
        String photoInterp = photo.getName();
        String metaDataPhotoInterp = photo.getMetadataType();
        this.put("PhotometricInterpretation", photoInterp);
        this.put("MetaDataPhotometricInterpretation", metaDataPhotoInterp);
        this.putInt("CellWidth", firstIFD, 264);
        this.putInt("CellLength", firstIFD, 265);
        int or = firstIFD.getIFDIntValue(274);
        if (or == 8) {
            this.put("ImageWidth", firstIFD, 257);
            this.put("ImageLength", firstIFD, 256);
        }
        String orientation = null;
        switch (or) {
            case 1: {
                orientation = "1st row -> top; 1st column -> left";
                break;
            }
            case 2: {
                orientation = "1st row -> top; 1st column -> right";
                break;
            }
            case 3: {
                orientation = "1st row -> bottom; 1st column -> right";
                break;
            }
            case 4: {
                orientation = "1st row -> bottom; 1st column -> left";
                break;
            }
            case 5: {
                orientation = "1st row -> left; 1st column -> top";
                break;
            }
            case 6: {
                orientation = "1st row -> right; 1st column -> top";
                break;
            }
            case 7: {
                orientation = "1st row -> right; 1st column -> bottom";
                break;
            }
            case 8: {
                orientation = "1st row -> left; 1st column -> bottom";
            }
        }
        this.put("Orientation", orientation);
        this.putInt("SamplesPerPixel", firstIFD, 277);
        this.put("Software", firstIFD, 305);
        this.put("Instrument Make", firstIFD, 271);
        this.put("Instrument Model", firstIFD, 272);
        this.put("Document Name", firstIFD, 269);
        this.put("DateTime", this.getImageCreationDate());
        this.put("Artist", firstIFD, 315);
        this.put("HostComputer", firstIFD, 316);
        this.put("Copyright", firstIFD, 33432);
        this.put("NewSubfileType", firstIFD, 254);
        int thresh = firstIFD.getIFDIntValue(263);
        String threshholding = null;
        switch (thresh) {
            case 1: {
                threshholding = "No dithering or halftoning";
                break;
            }
            case 2: {
                threshholding = "Ordered dithering or halftoning";
                break;
            }
            case 3: {
                threshholding = "Randomized error diffusion";
            }
        }
        this.put("Threshholding", threshholding);
        int fill = firstIFD.getIFDIntValue(266);
        String fillOrder = null;
        switch (fill) {
            case 1: {
                fillOrder = "Pixels with lower column values are stored in the higher order bits of a byte";
                break;
            }
            case 2: {
                fillOrder = "Pixels with lower column values are stored in the lower order bits of a byte";
            }
        }
        this.put("FillOrder", fillOrder);
        this.putInt("Make", firstIFD, 271);
        this.putInt("Model", firstIFD, 272);
        this.putInt("MinSampleValue", firstIFD, 280);
        this.putInt("MaxSampleValue", firstIFD, 281);
        this.putDouble("XResolution", firstIFD, 282);
        this.putDouble("YResolution", firstIFD, 283);
        int planar = firstIFD.getIFDIntValue(284);
        String planarConfig = null;
        switch (planar) {
            case 1: {
                planarConfig = "Chunky";
                break;
            }
            case 2: {
                planarConfig = "Planar";
            }
        }
        this.put("PlanarConfiguration", planarConfig);
        this.putDouble("XPosition", firstIFD, 286);
        this.putDouble("YPosition", firstIFD, 287);
        this.putInt("FreeOffsets", firstIFD, 288);
        this.putInt("FreeByteCounts", firstIFD, 289);
        this.putInt("GrayResponseUnit", firstIFD, 290);
        this.putInt("GrayResponseCurve", firstIFD, 291);
        this.putInt("T4Options", firstIFD, 292);
        this.putInt("T6Options", firstIFD, 293);
        int res = firstIFD.getIFDIntValue(296);
        String resUnit = null;
        switch (res) {
            case 1: {
                resUnit = "None";
                break;
            }
            case 2: {
                resUnit = "Inch";
                break;
            }
            case 3: {
                resUnit = "Centimeter";
            }
        }
        this.put("ResolutionUnit", resUnit);
        this.putString("PageNumber", firstIFD, 297);
        this.putInt("TransferFunction", firstIFD, 301);
        int predict = firstIFD.getIFDIntValue(317);
        String predictor = null;
        switch (predict) {
            case 1: {
                predictor = "No prediction scheme";
                break;
            }
            case 2: {
                predictor = "Horizontal differencing";
            }
        }
        this.put("Predictor", predictor);
        this.putInt("WhitePoint", firstIFD, 318);
        this.putInt("PrimaryChromacities", firstIFD, 319);
        this.putInt("HalftoneHints", firstIFD, 321);
        this.putInt("TileWidth", firstIFD, 322);
        this.putInt("TileLength", firstIFD, 323);
        this.putInt("TileOffsets", firstIFD, 324);
        this.putInt("TileByteCounts", firstIFD, 325);
        int ink = firstIFD.getIFDIntValue(332);
        String inkSet = null;
        switch (ink) {
            case 1: {
                inkSet = "CMYK";
                break;
            }
            case 2: {
                inkSet = "Other";
            }
        }
        this.put("InkSet", inkSet);
        this.putInt("InkNames", firstIFD, 333);
        this.putInt("NumberOfInks", firstIFD, 334);
        this.putInt("DotRange", firstIFD, 336);
        this.put("TargetPrinter", firstIFD, 337);
        this.putInt("ExtraSamples", firstIFD, 338);
        int fmt = firstIFD.getIFDIntValue(339);
        String sampleFormat = null;
        switch (fmt) {
            case 1: {
                sampleFormat = "unsigned integer";
                break;
            }
            case 2: {
                sampleFormat = "two's complement signed integer";
                break;
            }
            case 3: {
                sampleFormat = "IEEE floating point";
                break;
            }
            case 4: {
                sampleFormat = "undefined";
            }
        }
        this.put("SampleFormat", sampleFormat);
        this.putInt("SMinSampleValue", firstIFD, 340);
        this.putInt("SMaxSampleValue", firstIFD, 341);
        this.putInt("TransferRange", firstIFD, 342);
        int jpeg = firstIFD.getIFDIntValue(512);
        String jpegProc = null;
        switch (jpeg) {
            case 1: {
                jpegProc = "baseline sequential process";
                break;
            }
            case 14: {
                jpegProc = "lossless process with Huffman coding";
            }
        }
        this.put("JPEGProc", jpegProc);
        this.putInt("JPEGInterchangeFormat", firstIFD, 513);
        this.putInt("JPEGRestartInterval", firstIFD, 515);
        this.putInt("JPEGLosslessPredictors", firstIFD, 517);
        this.putInt("JPEGPointTransforms", firstIFD, 518);
        this.putInt("JPEGQTables", firstIFD, 519);
        this.putInt("JPEGDCTables", firstIFD, 520);
        this.putInt("JPEGACTables", firstIFD, 521);
        this.putInt("YCbCrCoefficients", firstIFD, 529);
        int ycbcr = firstIFD.getIFDIntValue(530);
        String subSampling = null;
        switch (ycbcr) {
            case 1: {
                subSampling = "chroma image dimensions = luma image dimensions";
                break;
            }
            case 2: {
                subSampling = "chroma image dimensions are half the luma image dimensions";
                break;
            }
            case 4: {
                subSampling = "chroma image dimensions are 1/4 the luma image dimensions";
            }
        }
        this.put("YCbCrSubSampling", subSampling);
        this.putInt("YCbCrPositioning", firstIFD, 531);
        this.putInt("ReferenceBlackWhite", firstIFD, 532);
        int[] q = firstIFD.getBitsPerSample();
        int bps = q[0];
        int numC = q.length;
        if (photo == PhotoInterp.RGB_PALETTE || photo == PhotoInterp.CFA_ARRAY) {
            numC = 3;
        }
        this.put("BitsPerSample", bps);
        this.put("NumberOfChannels", numC);
    }

    protected void initMetadataStore() throws FormatException {
        LOGGER.info("Populating OME metadata");
        MetadataStore store = this.makeFilterMetadata();
        IFD firstIFD = (IFD)this.ifds.get(0);
        IFD exif = null;
        if (((IFD)this.ifds.get(0)).containsKey(34665)) {
            try {
                IFDList exifIFDs = this.tiffParser.getExifIFDs();
                if (exifIFDs.size() > 0) {
                    exif = (IFD)exifIFDs.get(0);
                }
                this.tiffParser.fillInIFD(exif);
            }
            catch (IOException e) {
                LOGGER.debug("Could not read EXIF IFDs", e);
            }
        }
        MetadataTools.populatePixels(store, this, exif != null);
        String creationDate = this.getImageCreationDate();
        String date = DateTools.formatDate(creationDate, DATE_FORMATS, ".");
        if (creationDate != null && date == null) {
            LOGGER.warn("unknown creation date format: {}", (Object)creationDate);
        }
        if ((creationDate = date) != null) {
            store.setImageAcquisitionDate(new Timestamp(creationDate), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Object exp;
            String artist = firstIFD.getIFDTextValue(315);
            if (artist != null) {
                String firstName = null;
                String lastName = null;
                int ndx = artist.indexOf(32);
                if (ndx < 0) {
                    lastName = artist;
                } else {
                    firstName = artist.substring(0, ndx);
                    lastName = artist.substring(ndx + 1);
                }
                String email = firstIFD.getIFDStringValue(316);
                store.setExperimenterFirstName(firstName, 0);
                store.setExperimenterLastName(lastName, 0);
                store.setExperimenterEmail(email, 0);
                store.setExperimenterID(MetadataTools.createLSID("Experimenter", 0), 0);
            }
            store.setImageDescription(firstIFD.getComment(), 0);
            double pixX = firstIFD.getXResolution();
            double pixY = firstIFD.getYResolution();
            String unit = this.getResolutionUnitFromComment(firstIFD);
            Length sizeX = FormatTools.getPhysicalSizeX((Double)pixX, unit);
            Length sizeY = FormatTools.getPhysicalSizeY((Double)pixY, unit);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            store.setPixelsPhysicalSizeZ(null, 0);
            if (exif != null && exif.containsKey(33434) && (exp = exif.get(33434)) instanceof TiffRational) {
                Time exposure = new Time(((TiffRational)exp).doubleValue(), UNITS.SECOND);
                for (int i = 0; i < this.getImageCount(); ++i) {
                    store.setPlaneExposureTime(exposure, 0, i);
                }
            }
        }
    }

    private String getResolutionUnitFromComment(IFD ifd) {
        String p;
        Pattern pattern;
        Matcher m3;
        String comment = ifd.getComment();
        if (comment != null && comment.trim().length() > 0 && (m3 = (pattern = Pattern.compile(p = "(.*)unit=(\\w+)(.*)", 32)).matcher(comment)).matches()) {
            return m3.group(2);
        }
        return null;
    }

    protected String getImageCreationDate() {
        Object o = ((IFD)this.ifds.get(0)).getIFDValue(306);
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof String[] && ((String[])o).length > 0) {
            return ((String[])o)[0];
        }
        return null;
    }

    protected void put(String key, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            value = ((String)value).trim();
        }
        this.addGlobalMeta(key, value);
    }

    protected void put(String key, int value) {
        if (value == -1) {
            return;
        }
        this.addGlobalMeta(key, value);
    }

    protected void put(String key, boolean value) {
        this.put(key, new Boolean(value));
    }

    protected void put(String key, byte value) {
        this.put(key, new Byte(value));
    }

    protected void put(String key, char value) {
        this.put(key, new Character(value));
    }

    protected void put(String key, double value) {
        this.put(key, new Double(value));
    }

    protected void put(String key, float value) {
        this.put(key, new Float(value));
    }

    protected void put(String key, long value) {
        this.put(key, new Long(value));
    }

    protected void put(String key, short value) {
        this.put(key, new Short(value));
    }

    protected void put(String key, IFD ifd, int tag) {
        this.put(key, ifd.getIFDValue(tag));
    }

    protected void putInt(String key, IFD ifd, int tag) {
        this.put(key, ifd.getIFDIntValue(tag));
    }

    protected void putString(String key, IFD ifd, int tag) {
        String value = "";
        try {
            value = ifd.getIFDStringValue(tag);
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        this.put(key, value);
    }

    protected void putDouble(String key, IFD ifd, int tag) {
        Number number;
        if (ifd.getIFDValue(tag) instanceof Number && (number = (Number)ifd.getIFDValue(tag)) != null) {
            this.put(key, number.doubleValue());
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.initMetadata();
    }

    public static String getExifTagName(int tag) {
        return IFD.getIFDTagName(tag);
    }
}

