"""
ContactID codes from: http://www.voip-sip-sdk.com/attachments/583/contact_id.pdf
"""

EVENT_CATEGORIES = {
    "100": "Alarms",
    "200": "Supervisory",
    "300": "Troubles",
    "400": "Open/Close, Remote Access",
    "500": "Bypasses/Disables",
    "600": "Test/Misc",
}

CODES = {
    "100": {"name": "Medical", "type": "zone"},
    "101": {"name": "Personal Emergency", "type": "zone"},
    "102": {"name": "Fail to report in", "type": "zone"},
    "110": {"name": "Fire", "type": "zone"},
    "111": {"name": "Smoke", "type": "zone"},
    "112": {"name": "Combustion", "type": "zone"},
    "113": {"name": "Water flow", "type": "zone"},
    "114": {"name": "Heat", "type": "zone"},
    "115": {"name": "Pull Station", "type": "zone"},
    "116": {"name": "Duct", "type": "zone"},
    "117": {"name": "Flame", "type": "zone"},
    "118": {"name": "Near Alarm", "type": "zone"},
    "120": {"name": "Panic", "type": "zone"},
    "121": {"name": "Duress", "type": "user"},
    "122": {"name": "Silent", "type": "zone"},
    "123": {"name": "Audible", "type": "zone"},
    "124": {"name": "Duress – Access granted", "type": "zone"},
    "125": {"name": "Duress – Egress granted", "type": "zone"},
    "130": {"name": "Burglary", "type": "zone"},
    "131": {"name": "Perimeter", "type": "zone"},
    "132": {"name": "Interior", "type": "zone"},
    "133": {"name": "24 Hour (Safe)", "type": "zone"},
    "134": {"name": "Entry/Exit", "type": "zone"},
    "135": {"name": "Day/night", "type": "zone"},
    "136": {"name": "Outdoor", "type": "zone"},
    "137": {"name": "Tamper", "type": "zone"},
    "138": {"name": "Near alarm", "type": "zone"},
    "139": {"name": "Intrusion Verifier", "type": "zone"},
    "140": {"name": "General Alarm", "type": "zone"},
    "141": {"name": "Polling loop open", "type": "zone"},
    "142": {"name": "Polling loop short", "type": "zone"},
    "143": {"name": "Expansion module failure", "type": "zone"},
    "144": {"name": "Sensor tamper", "type": "zone"},
    "145": {"name": "Expansion module tamper", "type": "zone"},
    "146": {"name": "Silent Burglary", "type": "zone"},
    "147": {"name": "Sensor Supervision Failure", "type": "zone"},
    "150": {"name": "24 Hour Non-Burglary", "type": "zone"},
    "151": {"name": "Gas detected", "type": "zone"},
    "152": {"name": "Refrigeration", "type": "zone"},
    "153": {"name": "Loss of heat", "type": "zone"},
    "154": {"name": "Water Leakage", "type": "zone"},
    "155": {"name": "Foil Break", "type": "zone"},
    "156": {"name": "Day Trouble", "type": "zone"},
    "157": {"name": "Low bottled gas level", "type": "zone"},
    "158": {"name": "High temp", "type": "zone"},
    "159": {"name": "Low temp", "type": "zone"},
    "161": {"name": "Loss of air flow", "type": "zone"},
    "162": {"name": "Carbon Monoxide detected", "type": "zone"},
    "163": {"name": "Tank level", "type": "zone"},
    "200": {"name": "Fire Supervisory", "type": "zone"},
    "201": {"name": "Low water pressure", "type": "zone"},
    "202": {"name": "Low CO2", "type": "zone"},
    "203": {"name": "Gate valve sensor", "type": "zone"},
    "204": {"name": "Low water level", "type": "zone"},
    "205": {"name": "Pump activated", "type": "zone"},
    "206": {"name": "Pump failure", "type": "zone"},
    "300": {"name": "System Trouble", "type": "zone"},
    "301": {"name": "AC Loss", "type": "zone"},
    "302": {"name": "Low system battery", "type": "zone"},
    "303": {"name": "RAM Checksum bad", "type": "zone"},
    "304": {"name": "ROM checksum bad", "type": "zone"},
    "305": {"name": "System reset", "type": "zone"},
    "306": {"name": "Panel programming changed", "type": "zone"},
    "307": {"name": "Self-test failure", "type": "zone"},
    "308": {"name": "System shutdown", "type": "zone"},
    "309": {"name": "Battery test failure", "type": "zone"},
    "310": {"name": "Ground fault", "type": "zone"},
    "311": {"name": "Battery Missing/Dead", "type": "zone"},
    "312": {"name": "Power Supply Overcurrent", "type": "zone"},
    "313": {"name": "Engineer Reset", "type": "user"},
    "320": {"name": "Sounder/Relay", "type": "zone"},
    "321": {"name": "Bell 1", "type": "zone"},
    "322": {"name": "Bell 2", "type": "zone"},
    "323": {"name": "Alarm relay", "type": "zone"},
    "324": {"name": "Trouble relay", "type": "zone"},
    "325": {"name": "Reversing relay", "type": "zone"},
    "326": {"name": "Notification Appliance Ckt. # 3", "type": "zone"},
    "327": {"name": "Notification Appliance Ckt. #4", "type": "zone"},
    "330": {"name": "System Peripheral trouble", "type": "zone"},
    "331": {"name": "Polling loop open", "type": "zone"},
    "332": {"name": "Polling loop short", "type": "zone"},
    "333": {"name": "Expansion module failure", "type": "zone"},
    "334": {"name": "Repeater failure", "type": "zone"},
    "335": {"name": "Local printer out of paper", "type": "zone"},
    "336": {"name": "Local printer failure", "type": "zone"},
    "337": {"name": "Exp. Module DC Loss", "type": "zone"},
    "338": {"name": "Exp. Module Low Batt.", "type": "zone"},
    "339": {"name": "Exp. Module Reset", "type": "zone"},
    "341": {"name": "Exp. Module Tamper", "type": "zone"},
    "342": {"name": "Exp. Module AC Loss", "type": "zone"},
    "343": {"name": "Exp. Module self-test fail", "type": "zone"},
    "344": {"name": "RF Receiver Jam Detect", "type": "zone"},
    "350": {"name": "Communication trouble", "type": "zone"},
    "351": {"name": "Telco 1 fault", "type": "zone"},
    "352": {"name": "Telco 2 fault", "type": "zone"},
    "353": {"name": "Long Range Radio xmitter fault", "type": "zone"},
    "354": {"name": "Failure to communicate event", "type": "zone"},
    "355": {"name": "Loss of Radio supervision", "type": "zone"},
    "356": {"name": "Loss of central polling", "type": "zone"},
    "357": {"name": "Long Range Radio VSWR problem", "type": "zone"},
    "370": {"name": "Protection loop", "type": "zone"},
    "371": {"name": "Protection loop open", "type": "zone"},
    "372": {"name": "Protection loop short", "type": "zone"},
    "373": {"name": "Fire trouble", "type": "zone"},
    "374": {"name": "Exit error alarm (zone)", "type": "zone"},
    "375": {"name": "Panic zone trouble", "type": "zone"},
    "376": {"name": "Hold-up zone trouble", "type": "zone"},
    "377": {"name": "Swinger Trouble", "type": "zone"},
    "378": {"name": "Cross-zone Trouble", "type": "zone"},
    "380": {"name": "Sensor trouble", "type": "zone"},
    "381": {"name": "Loss of supervision - RF", "type": "zone"},
    "382": {"name": "Loss of supervision - RPM", "type": "zone"},
    "383": {"name": "Sensor tamper", "type": "zone"},
    "384": {"name": "RF low battery", "type": "zone"},
    "385": {"name": "Smoke detector Hi sensitivity", "type": "zone"},
    "386": {"name": "Smoke detector Low sensitivity", "type": "zone"},
    "387": {"name": "Intrusion detector Hi sensitivity", "type": "zone"},
    "388": {"name": "Intrusion detector Low sensitivity", "type": "zone"},
    "389": {"name": "Sensor self-test failure", "type": "zone"},
    "391": {"name": "Sensor Watch trouble", "type": "zone"},
    "392": {"name": "Drift Compensation Error", "type": "zone"},
    "393": {"name": "Maintenance Alert", "type": "zone"},
    "400": {"name": "Open/Close", "type": "user"},
    "401": {"name": "O/C by user", "type": "user"},
    "402": {"name": "Group O/C", "type": "user"},
    "403": {"name": "Automatic O/C", "type": "user"},
    "404": {"name": "Late to O/C", "type": "user"},
    "405": {"name": "Deferred O/C (Obsolete- do not use )", "type": "user"},
    "406": {"name": "Cancel", "type": "user"},
    "407": {"name": "Remote arm/disarm", "type": "user"},
    "408": {"name": "Quick arm", "type": "user"},
    "409": {"name": "Keyswitch O/C", "type": "user"},
    "411": {"name": "Callback request made", "type": "user"},
    "412": {"name": "Successful download/access", "type": "user"},
    "413": {"name": "Unsuccessful access", "type": "user"},
    "414": {"name": "System shutdown command received", "type": "user"},
    "415": {"name": "Dialer shutdown command received", "type": "user"},
    "416": {"name": "Successful Upload", "type": "zone"},
    "421": {"name": "Access denied", "type": "user"},
    "422": {"name": "Access report by user", "type": "user"},
    "423": {"name": "Forced Access", "type": "zone"},
    "424": {"name": "Egress Denied", "type": "user"},
    "425": {"name": "Egress Granted", "type": "user"},
    "426": {"name": "Access Door propped open", "type": "zone"},
    "427": {"name": "Access point Door Status Monitor trouble", "type": "zone"},
    "428": {"name": "Access point Request To Exit trouble", "type": "zone"},
    "429": {"name": "Access program mode entry", "type": "user"},
    "430": {"name": "Access program mode exit", "type": "user"},
    "431": {"name": "Access threat level change", "type": "user"},
    "432": {"name": "Access relay/trigger fail", "type": "zone"},
    "433": {"name": "Access RTE shunt", "type": "zone"},
    "434": {"name": "Access DSM shunt", "type": "zone"},
    "441": {"name": "Armed STAY", "type": "user"},
    "442": {"name": "Keyswitch Armed STAY", "type": "user"},
    "450": {"name": "Exception O/C", "type": "user"},
    "451": {"name": "Early O/C", "type": "user"},
    "452": {"name": "Late O/C", "type": "user"},
    "453": {"name": "Failed to Open", "type": "user"},
    "454": {"name": "Failed to Close", "type": "user"},
    "455": {"name": "Auto-arm Failed", "type": "user"},
    "456": {"name": "Partial Arm", "type": "user"},
    "457": {"name": "Exit Error (user)", "type": "user"},
    "458": {"name": "User on Premises", "type": "user"},
    "459": {"name": "Recent Close", "type": "user"},
    "461": {"name": "Wrong Code Entry", "type": "zone"},
    "462": {"name": "Legal Code Entry", "type": "user"},
    "463": {"name": "Re-arm after Alarm", "type": "user"},
    "464": {"name": "Auto-arm Time Extended", "type": "user"},
    "465": {"name": "Panic Alarm Reset", "type": "zone"},
    "466": {"name": "Service On/Off Premises", "type": "user"},
    "501": {"name": "Access reader disable", "type": "zone"},
    "520": {"name": "Sounder/Relay Disable", "type": "zone"},
    "521": {"name": "Bell 1 disable", "type": "zone"},
    "522": {"name": "Bell 2 disable", "type": "zone"},
    "523": {"name": "Alarm relay disable", "type": "zone"},
    "524": {"name": "Trouble relay disable", "type": "zone"},
    "525": {"name": "Reversing relay disable", "type": "zone"},
    "526": {"name": "Notification Appliance Ckt. # 3 disable", "type": "zone"},
    "527": {"name": "Notification Appliance Ckt. # 4 disable", "type": "zone"},
    "531": {"name": "Module Added", "type": "zone"},
    "532": {"name": "Module Removed", "type": "zone"},
    "551": {"name": "Dialer disabled", "type": "zone"},
    "552": {"name": "Radio transmitter disabled", "type": "zone"},
    "553": {"name": "Remote Upload/Download disabled", "type": "zone"},
    "570": {"name": "Zone/Sensor bypass", "type": "zone"},
    "571": {"name": "Fire bypass", "type": "zone"},
    "572": {"name": "24 Hour zone bypass", "type": "zone"},
    "573": {"name": "Burg. Bypass", "type": "zone"},
    "574": {"name": "Group bypass", "type": "user"},
    "575": {"name": "Swinger bypass", "type": "zone"},
    "576": {"name": "Access zone shunt", "type": "zone"},
    "577": {"name": "Access point bypass", "type": "zone"},
    "601": {"name": "Manual trigger test report", "type": "zone"},
    "602": {"name": "Periodic test report", "type": "zone"},
    "603": {"name": "Periodic RF transmission", "type": "zone"},
    "604": {"name": "Fire test", "type": "user"},
    "605": {"name": "Status report to follow", "type": "zone"},
    "606": {"name": "Listen-in to follow", "type": "zone"},
    "607": {"name": "Walk test mode", "type": "user"},
    "608": {"name": "Periodic test - System Trouble Present", "type": "zone"},
    "609": {"name": "Video Xmitter active", "type": "zone"},
    "611": {"name": "Point tested OK", "type": "zone"},
    "612": {"name": "Point not tested", "type": "zone"},
    "613": {"name": "Intrusion Zone Walk Tested", "type": "zone"},
    "614": {"name": "Fire Zone Walk Tested", "type": "zone"},
    "615": {"name": "Panic Zone Walk Tested", "type": "zone"},
    "616": {"name": "Service Request", "type": "zone"},
    "621": {"name": "Event Log reset", "type": "zone"},
    "622": {"name": "Event Log 50% full", "type": "zone"},
    "623": {"name": "Event Log 90% full", "type": "zone"},
    "624": {"name": "Event Log overflow", "type": "zone"},
    "625": {"name": "Time/Date reset", "type": "user"},
    "626": {"name": "Time/Date inaccurate", "type": "zone"},
    "627": {"name": "Program mode entry", "type": "zone"},
    "628": {"name": "Program mode exit", "type": "zone"},
    "629": {"name": "32 Hour Event log marker", "type": "zone"},
    "630": {"name": "Schedule change", "type": "zone"},
    "631": {"name": "Exception schedule change", "type": "zone"},
    "632": {"name": "Access schedule change", "type": "zone"},
    "641": {"name": "Senior Watch Trouble", "type": "zone"},
    "642": {"name": "Latch-key Supervision", "type": "user"},
    "651": {"name": "Reserved for Ademco Use", "type": "zone"},
    "652": {"name": "Reserved for Ademco Use", "type": "user"},
    "653": {"name": "Reserved for Ademco Use", "type": "user"},
    "654": {"name": "System Inactivity", "type": "zone"},
}
