# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue with the owners of this repository before making a change. 

Please note we have a code of conduct, please follow it in all your interactions with the project.

## How to contribute to doccano

### Reporting Bugs

#### Before submitting a bug report

* Check the FAQs for a list of common questions and problems.
* Ensure the bug was not already reported by searching on GitHub under [Issues](https://github.com/doccano/doccano-transformer/issues).
* [Open a new issue](https://github.com/doccano/doccano-transformer/issues/new/choose) if you're unable to find an open one addressing the problem.
* Use the relevant bug report templates to create the issue.

#### How do I submit a good bug report?

Explain the problem and include additional details to help maintainers reproduce the problem:

* Use a clear and descriptive title for the issue to identify the problem.
* Describe the exact steps which reproduce the problem in as many details as possible.
* Provide specific examples to demonstrate the steps.
* Describe the behavior you observed after following the steps and point out what exactly is the problem with that behavior.
* Explain which behavior you expected to see instead and why.
* Include screenshots and animated GIFs which show you following the described steps and clearly demonstrate the problem.
* If the problem is related to performance or memory, include a CPU profile capture with your report.
* If the problem is related to network, include a network activity in Chrome/Firefox/Safari DevTools.
* If the problem wasn't triggered by a specific action, describe what you were doing before the problem happened and share more information using the guidelines below.

### Suggesting Enhancements

#### Before submitting an enhancement suggestion

* Ensure the suggestion was not already reported by searching on GitHub under [Issues](https://github.com/doccano/doccano-transformer/issues).
* [Open a new issue](https://github.com/doccano/doccano-transformer/issues/new/choose) if you're unable to find an open one addressing the suggestion.
* Use the relevant issue templates to create one.

#### How do I submit a good enhancement suggestion?

Explain the suggestion and include additional details to help developers understand it:

* Use a clear and descriptive title for the issue to identify the suggestion.
* Provide a step-by-step description of the suggested enhancement in as many details as possible.
* Provide specific examples to demonstrate the steps.
* Describe the current behavior and explain which behavior you expected to see instead and why.
* Include screenshots and animated GIFs which help you demonstrate the steps or point out the part of doccano which the suggestion is related to.
* Explain why this enhancement would be useful to most doccano users.
* List some other annotation tools or applications where this enhancement exists.
* Specify which version of doccano you're using.
* Specify the name and version of the OS you're using.

### Pull Request Process

Please follow these steps to have your contribution considered by the maintainers:

1. Open a related issue before making a pull request as much as possible.
2. Follow all instructions in [the template](PULL_REQUEST_TEMPLATE.md)
3. Follow the [styleguides](#styleguides)
4. After you submit your pull request, verify that all [status checks](https://help.github.com/articles/about-status-checks/) are passing <details><summary>What if the status checks are failing?</summary>If a status check is failing, and you believe that the failure is unrelated to your change, please leave a comment on the pull request explaining why you believe the failure is unrelated. A maintainer will re-run the status check for you. If we conclude that the failure was a false positive, then we will open an issue to track that problem with our status check suite.</details>
5. You may merge the Pull Request in once you have the sign-off of the project members([@Hironsan](https://github.com/Hironsan), [@yasufumy](https://github.com/yasufumy) or [@icoxfog417](https://github.com/icoxfog417)).

While the prerequisites above must be satisfied prior to having your pull request reviewed, the reviewer(s) may ask you to complete additional design work, tests, or other changes before your pull request can be ultimately accepted.

## Styleguides

### Git Commit Messages

* Use the present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
* Limit the first line to 72 characters or less
* Reference issues and pull requests liberally after the first line
