# predictr - Predict the Reliability

predictr: predict + reliability, in other words: A tool to predict the reliability.<br>
The aim of this package is to provide state of the art tools for all kinds of Weibull analyses. <br>
predictr already includes many methods (see tables below). A guideline on when to use which method will be added soon.

![](https://img.shields.io/pypi/v/predictr?color=blue&style=flat&label=pypi)
[![Downloads](https://pepy.tech/badge/predictr)](https://pepy.tech/project/predictr)
![](https://img.shields.io/pypi/pyversions/predictr)
![](https://img.shields.io/pypi/l/predictr)
![](https://img.shields.io/github/stars/tvtoglu/predictr?style=flat)
![Hits](https://hitcounter.pythonanywhere.com/count/tag.svg?url=https%3A%2F%2Ftvtoglu.github.io%2Fpredictr%2F)

### Main Features
#### Parameter Estimation

- Uncensored two-parameter Weibull distribution
- Type I and type II right-censored two-parameter Weibull distribution
- Maximum Likelihood Estimation (MLE)
- Median Rank Regression (MRR)

#### Bias-correction methods

- C4 method (reduced bias adjustment)
- Hirose and Ross method
- Non-Parametric Bootstrap correction (mean, median, trimmed mean)
- Parametric Bootstrap correction (mean, median, trimmed mean)

#### Confidence bounds

- Beta-Binomial Bounds
- Monte-Carlo Pivotal Bounds
- Non-Parametric Bootstrap Bounds
- Parametric Bootstrap Bounds
- Fisher Bounds
- Likelihood Ratio Bounds

#### Plots

- Weibull Probability Plots with all needed information on them

### Important Links
[PyPi](https://pypi.org/project/predictr/)

[Github Repository](https://github.com/tvtoglu/predictr)


[Documentation](https://tvtoglu.github.io/predictr/)
