/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.css.parser.Node;
import com.helger.css.parser.ParserCSSCharsetDetector;
import com.helger.css.parser.ParserCSSCharsetDetectorTreeConstants;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected ParserCSSCharsetDetector parser;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(ParserCSSCharsetDetector parserCSSCharsetDetector, int n) {
        this(n);
        this.parser = parserCSSCharsetDetector;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    @Override
    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object object) {
        this.value = object;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public String toString() {
        return ParserCSSCharsetDetectorTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    protected void dumpString(String string) {
        System.out.println(string);
    }

    public void dump(String string) {
        this.dumpString(this.toString(string));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + " ");
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }
}

