/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.PostWriter;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.testelement.property.JMeterProperty;

public class PutWriter
extends PostWriter {
    public PutWriter() {
        super(null);
    }

    @Override
    public void setHeaders(URLConnection connection, HTTPSamplerBase sampler) throws IOException {
        String contentEncoding = sampler.getContentEncoding();
        if (contentEncoding == null || contentEncoding.length() == 0) {
            contentEncoding = ENCODING;
        }
        long contentLength = 0L;
        boolean hasPutBody = false;
        String contentTypeHeader = connection.getRequestProperty("Content-Type");
        boolean hasContentTypeHeader = contentTypeHeader != null && contentTypeHeader.length() > 0;
        HTTPFileArg[] files = sampler.getHTTPFiles();
        if (sampler.getArguments() != null && sampler.getArguments().getArgumentCount() == 0 && sampler.getSendFileAsPostBody()) {
            HTTPFileArg file = files[0];
            hasPutBody = true;
            if (!hasContentTypeHeader && file.getMimeType().length() > 0) {
                connection.setRequestProperty("Content-Type", file.getMimeType());
            }
            File inputFile = new File(file.getPath());
            contentLength = inputFile.length();
        } else if (sampler.getSendParameterValuesAsPostBody()) {
            hasPutBody = true;
            if (!hasContentTypeHeader && files.length == 1 && files[0].getMimeType().length() > 0) {
                connection.setRequestProperty("Content-Type", files[0].getMimeType());
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StringBuilder putBodyBuffer = new StringBuilder();
            for (JMeterProperty jMeterProperty : sampler.getArguments()) {
                HTTPArgument arg = (HTTPArgument)jMeterProperty.getObjectValue();
                putBodyBuffer.append(arg.getEncodedValue(contentEncoding));
            }
            bos.write(putBodyBuffer.toString().getBytes(contentEncoding));
            bos.flush();
            bos.close();
            this.formDataUrlEncoded = bos.toByteArray();
            contentLength = bos.toByteArray().length;
        }
        if (hasPutBody) {
            connection.setRequestProperty("Content-Length", Long.toString(contentLength));
            connection.setDoOutput(true);
        }
    }
}

