/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.gui.util.HeaderAsPropertyRenderer;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="auth_manager_title")
public class AuthPanel
extends AbstractConfigGui
implements ActionListener {
    private static final long serialVersionUID = -378312656300713635L;
    private static final Logger log = LoggerFactory.getLogger(AuthPanel.class);
    private static final String ADD_COMMAND = "Add";
    private static final String DELETE_COMMAND = "Delete";
    private static final String LOAD_COMMAND = "Load";
    private static final String SAVE_COMMAND = "Save";
    private static final String CONTROLLED_BY_THREADGROUP = "Controlled_By_ThreadGroup";
    private InnerTableModel tableModel = new InnerTableModel();
    private JCheckBox clearEachIteration;
    private JCheckBox controlledByThreadGroup;
    private JTable authTable;
    private JButton addButton;
    private JButton deleteButton;
    private JButton loadButton;
    private JButton saveButton;

    public AuthPanel() {
        this.init();
    }

    public TestElement createTestElement() {
        AuthManager authMan = this.tableModel.manager;
        this.configureTestElement((TestElement)authMan);
        authMan.setClearEachIteration(this.clearEachIteration.isSelected());
        return (TestElement)authMan.clone();
    }

    public void modifyTestElement(TestElement el) {
        GuiUtils.stopTableEditing((JTable)this.authTable);
        AuthManager authManager = (AuthManager)el;
        authManager.clear();
        authManager.addTestElement((TestElement)this.tableModel.manager.clone());
        authManager.setClearEachIteration(this.clearEachIteration.isSelected());
        authManager.setControlledByThread(this.controlledByThreadGroup.isSelected());
        this.configureTestElement(el);
    }

    public void clearGui() {
        super.clearGui();
        this.tableModel.clearData();
        this.deleteButton.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.clearEachIteration.setSelected(false);
        this.controlledByThreadGroup.setSelected(false);
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.tableModel.manager.clear();
        AuthManager authManager = (AuthManager)el;
        this.tableModel.manager.addTestElement((TestElement)((AuthManager)authManager.clone()));
        this.clearEachIteration.setSelected(authManager.getClearEachIteration());
        this.controlledByThreadGroup.setSelected(authManager.getControlledByThread());
        this.checkButtonsStatus();
    }

    public String getLabelResource() {
        return "auth_manager_title";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        JPanel northPanel = new JPanel();
        northPanel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        northPanel.add(this.makeTitlePanel());
        JPanel optionsPane = new JPanel();
        optionsPane.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"auth_manager_options")));
        optionsPane.setLayout((LayoutManager)new VerticalLayout(5, 3));
        this.clearEachIteration = new JCheckBox(JMeterUtils.getResString((String)"auth_manager_clear_per_iter"), false);
        this.controlledByThreadGroup = new JCheckBox(JMeterUtils.getResString((String)"auth_manager_clear_controlled_by_threadgroup"), false);
        this.controlledByThreadGroup.setActionCommand(CONTROLLED_BY_THREADGROUP);
        this.controlledByThreadGroup.addActionListener(this);
        optionsPane.add(this.clearEachIteration);
        optionsPane.add(this.controlledByThreadGroup);
        northPanel.add(optionsPane);
        this.add(northPanel, "North");
        this.add(this.createAuthTablePanel(), "Center");
    }

    protected void deleteRows() {
        GuiUtils.cancelEditing((JTable)this.authTable);
        int[] rowsSelected = this.authTable.getSelectedRows();
        int anchorSelection = this.authTable.getSelectionModel().getAnchorSelectionIndex();
        this.authTable.clearSelection();
        if (rowsSelected.length > 0) {
            for (int i = rowsSelected.length - 1; i >= 0; --i) {
                this.tableModel.removeRow(rowsSelected[i]);
            }
            this.tableModel.fireTableDataChanged();
            if (this.tableModel.getRowCount() > 0) {
                if (anchorSelection >= this.tableModel.getRowCount()) {
                    anchorSelection = this.tableModel.getRowCount() - 1;
                }
                this.authTable.setRowSelectionInterval(anchorSelection, anchorSelection);
            }
            this.checkButtonsStatus();
        }
    }

    private void checkButtonsStatus() {
        if (this.tableModel.getRowCount() == 0) {
            this.deleteButton.setEnabled(false);
            this.saveButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
            this.saveButton.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(CONTROLLED_BY_THREADGROUP)) {
            this.clearEachIteration.setEnabled(!this.controlledByThreadGroup.isSelected());
        }
        if (action.equals(DELETE_COMMAND)) {
            this.deleteRows();
        } else if (action.equals(ADD_COMMAND)) {
            GuiUtils.stopTableEditing((JTable)this.authTable);
            this.tableModel.addNewRow();
            this.tableModel.fireTableDataChanged();
            this.checkButtonsStatus();
            int rowToSelect = this.tableModel.getRowCount() - 1;
            this.authTable.setRowSelectionInterval(rowToSelect, rowToSelect);
        } else if (action.equals(LOAD_COMMAND)) {
            try {
                String[] _txt = new String[]{".txt"};
                JFileChooser dialog = FileDialoger.promptToOpenFile((String[])_txt);
                if (dialog != null) {
                    this.tableModel.manager.addFile(dialog.getSelectedFile().getAbsolutePath());
                    this.tableModel.fireTableDataChanged();
                    this.checkButtonsStatus();
                }
            }
            catch (IOException ex) {
                log.error("Error loading auth data", (Throwable)ex);
            }
        } else if (action.equals(SAVE_COMMAND)) {
            try {
                JFileChooser chooser = FileDialoger.promptToSaveFile((String)"auth.txt");
                if (chooser != null) {
                    this.tableModel.manager.save(chooser.getSelectedFile().getAbsolutePath());
                }
            }
            catch (IOException ex) {
                JMeterUtils.reportErrorToUser((String)ex.getMessage(), (String)"Error saving auth data");
            }
        }
    }

    public JPanel createAuthTablePanel() {
        this.authTable = new JTable(this.tableModel);
        JMeterUtils.applyHiDPI((JTable)this.authTable);
        this.authTable.getTableHeader().setDefaultRenderer((TableCellRenderer)new HeaderAsPropertyRenderer());
        this.authTable.setSelectionMode(2);
        this.authTable.setPreferredScrollableViewportSize(new Dimension(100, 70));
        TableColumn passwordColumn = this.authTable.getColumnModel().getColumn(2);
        passwordColumn.setCellRenderer(new PasswordCellRenderer());
        TableColumn mechanismColumn = this.authTable.getColumnModel().getColumn(5);
        mechanismColumn.setCellEditor(new MechanismCellEditor());
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"auths_stored")));
        panel.add(new JScrollPane(this.authTable));
        panel.add((Component)this.createButtonPanel(), "South");
        return panel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.tableModel.getRowCount() == 0;
        this.addButton = this.createButton("add", 'A', ADD_COMMAND, true);
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        this.loadButton = this.createButton("load", 'L', LOAD_COMMAND, true);
        this.saveButton = this.createButton("save", 'S', SAVE_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.loadButton);
        buttonPanel.add(this.saveButton);
        return buttonPanel;
    }

    private static class PasswordCellRenderer
    extends JPasswordField
    implements TableCellRenderer {
        private static final long serialVersionUID = 5169856333827579927L;
        private Border myBorder = new EmptyBorder(1, 2, 1, 2);

        public PasswordCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.myBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText((String)value);
            this.setBackground(isSelected && !hasFocus ? table.getSelectionBackground() : table.getBackground());
            this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            this.setFont(table.getFont());
            return this;
        }
    }

    private static class MechanismCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 6085773573067229265L;

        public MechanismCellEditor() {
            super(new JComboBox<AuthManager.Mechanism>(AuthManager.Mechanism.values()));
        }
    }

    private static class InnerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4638155137475747946L;
        final AuthManager manager = new AuthManager();

        public void clearData() {
            this.manager.clear();
            this.fireTableDataChanged();
        }

        public void removeRow(int row) {
            this.manager.remove(row);
        }

        public void addNewRow() {
            this.manager.addAuth();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        @Override
        public int getRowCount() {
            return this.manager.getAuthObjects().size();
        }

        @Override
        public int getColumnCount() {
            return this.manager.getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return this.manager.getColumnName(column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            Authorization auth = this.manager.getAuthObjectAt(row);
            switch (column) {
                case 0: {
                    return auth.getURL();
                }
                case 1: {
                    return auth.getUser();
                }
                case 2: {
                    return auth.getPass();
                }
                case 3: {
                    return auth.getDomain();
                }
                case 4: {
                    return auth.getRealm();
                }
                case 5: {
                    return auth.getMechanism();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Authorization auth = this.manager.getAuthObjectAt(row);
            log.debug("Setting auth value: {}", value);
            switch (column) {
                case 0: {
                    auth.setURL((String)value);
                    break;
                }
                case 1: {
                    auth.setUser((String)value);
                    break;
                }
                case 2: {
                    auth.setPass((String)value);
                    break;
                }
                case 3: {
                    auth.setDomain((String)value);
                    break;
                }
                case 4: {
                    auth.setRealm((String)value);
                    break;
                }
                case 5: {
                    auth.setMechanism((AuthManager.Mechanism)((Object)value));
                    break;
                }
            }
        }
    }
}

