/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.config;

import java.io.Serializable;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArgs;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartUrlConfig
implements Serializable {
    private static final long serialVersionUID = 240L;
    private static final String CRLF = "\r\n";
    private static final String CRLFCRLF = "\r\n\r\n";
    private static final String LF = "\n";
    private static final String LFLF = "\n\n";
    private final String boundary;
    private final Arguments args = new Arguments();
    private static final Logger log = LoggerFactory.getLogger(MultipartUrlConfig.class);
    private static final boolean USE_JAVA_REGEX = !JMeterUtils.getPropDefault((String)"jmeter.regex.engine", (String)"oro").equalsIgnoreCase("oro");
    private final HTTPFileArgs files = new HTTPFileArgs();

    @Deprecated
    public MultipartUrlConfig() {
        this(null);
    }

    public MultipartUrlConfig(String boundary) {
        this.boundary = boundary;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public Arguments getArguments() {
        return this.args;
    }

    public void addArgument(String name, String value) {
        Arguments myArgs = this.getArguments();
        myArgs.addArgument((Argument)new HTTPArgument(name, value));
    }

    public void addArgument(String name, String value, String metadata) {
        Arguments myArgs = this.getArguments();
        myArgs.addArgument((Argument)new HTTPArgument(name, value, metadata));
    }

    public HTTPFileArgs getHTTPFileArgs() {
        return this.files;
    }

    private void addNonEncodedArgument(String name, String value, String contentType) {
        Arguments myArgs = this.getArguments();
        HTTPArgument arg = new HTTPArgument(name, value, false);
        if (!StringUtils.isEmpty((CharSequence)contentType)) {
            int indexOfSemiColon = contentType.indexOf(59);
            if (indexOfSemiColon > 0) {
                arg.setContentType(contentType.substring(0, indexOfSemiColon));
            } else {
                arg.setContentType(contentType);
            }
        }
        arg.setAlwaysEncoded(false);
        myArgs.addArgument((Argument)arg);
    }

    public void parseArguments(String queryString) {
        String[] parts;
        for (String part : parts = JOrphanUtils.split((String)queryString, (String)("--" + this.getBoundary()))) {
            String contentDisposition = MultipartUrlConfig.getHeaderValue("Content-disposition", part);
            String contentType = MultipartUrlConfig.getHeaderValue("Content-type", part);
            if (contentDisposition == null || !contentDisposition.contains("form-data")) continue;
            HeaderElement[] headerElements = null;
            try {
                headerElements = BasicHeaderValueParser.parseElements((String)contentDisposition, (HeaderValueParser)BasicHeaderValueParser.INSTANCE);
            }
            catch (ParseException e) {
                log.info("Can't parse header {}", (Object)contentDisposition, (Object)e);
            }
            String name = "";
            String path = null;
            if (headerElements != null) {
                for (HeaderElement element : headerElements) {
                    name = MultipartUrlConfig.getParameterValue(element, "name", "");
                    path = MultipartUrlConfig.getParameterValue(element, "filename", null);
                }
            }
            if (path != null && !path.isEmpty()) {
                this.files.addHTTPFileArg(path, name, contentType);
                continue;
            }
            int indexEmptyCrLfCrLfLinePos = part.indexOf(CRLFCRLF);
            int indexEmptyLfLfLinePos = part.indexOf(LFLF);
            String value = null;
            if (indexEmptyCrLfCrLfLinePos > -1) {
                value = part.substring(indexEmptyCrLfCrLfLinePos + CRLFCRLF.length(), part.lastIndexOf(CRLF));
            } else if (indexEmptyLfLfLinePos > -1) {
                value = part.substring(indexEmptyLfLfLinePos + LFLF.length(), part.lastIndexOf(LF));
            }
            this.addNonEncodedArgument(name, value, contentType);
        }
    }

    private static String getParameterValue(HeaderElement element, String name, String defaultValue) {
        NameValuePair parameter = element.getParameterByName(name);
        if (parameter == null) {
            return defaultValue;
        }
        return parameter.getValue();
    }

    private static String getHeaderValue(String headerName, String multiPart) {
        String regularExpression = headerName + "\\s*:\\s*(.*)$";
        if (USE_JAVA_REGEX) {
            return MultipartUrlConfig.getHeaderValueWithJavaRegex(multiPart, regularExpression);
        }
        return MultipartUrlConfig.getHeaderValueWithOroRegex(multiPart, regularExpression);
    }

    private static String getHeaderValueWithJavaRegex(String multiPart, String regularExpression) {
        java.util.regex.Pattern pattern = JMeterUtils.compilePattern((String)regularExpression, (int)10);
        Matcher matcher = pattern.matcher(multiPart);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    private static String getHeaderValueWithOroRegex(String multiPart, String regularExpression) {
        Pattern pattern;
        Perl5Matcher localMatcher = JMeterUtils.getMatcher();
        if (localMatcher.contains(multiPart, pattern = JMeterUtils.getPattern((String)regularExpression, (int)32777))) {
            return localMatcher.getMatch().group(1).trim();
        }
        return null;
    }
}

