/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.io.IOException;
import java.io.Writer;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriter;

public class UnicodeWriterToWriter
implements UnicodeWriter {
    private final Writer writer;

    public UnicodeWriterToWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void write(UnicodeString chars) throws IOException {
        this.writer.write(chars.toString());
    }

    @Override
    public void writeCodePoint(int codepoint) throws IOException {
        if (codepoint > 65535) {
            this.writer.write(UTF16CharacterSet.highSurrogate(codepoint));
            this.writer.write(UTF16CharacterSet.lowSurrogate(codepoint));
        } else {
            this.writer.write((char)codepoint);
        }
    }

    @Override
    public void write(String chars) throws IOException {
        this.writer.write(chars);
    }

    @Override
    public void writeAscii(byte[] content) throws IOException {
        char[] chars = new char[content.length];
        StringTool.copy8to16(content, 0, chars, 0, content.length);
        this.writer.write(chars);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }
}

