/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.cache.CacheEntry;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryCatalog;
import org.xmlresolver.catalog.entry.EntryPublic;
import org.xmlresolver.catalog.entry.EntrySystem;
import org.xmlresolver.catalog.entry.EntryUri;

public class CacheEntryCatalog
extends EntryCatalog {
    public final ArrayList<CacheEntry> cached = new ArrayList();
    private final URI baseURI;

    public CacheEntryCatalog(ResolverConfiguration config, URI baseURI, String id, boolean prefer) {
        super(config, baseURI, id, prefer);
        this.baseURI = baseURI;
    }

    @Override
    protected void add(Entry entry) {
        throw new IllegalStateException("Attempt to add entry to cache catalog");
    }

    protected void add(Entry entry, Long time) {
        int pos;
        for (pos = 0; pos < this.cached.size() && this.cached.get((int)pos).time <= time; ++pos) {
        }
        switch (entry.getType()) {
            case URI: {
                this.cached.add(pos, new CacheEntry((EntryUri)entry, (long)time));
                break;
            }
            case SYSTEM: {
                this.cached.add(pos, new CacheEntry((EntrySystem)entry, (long)time));
                break;
            }
            case PUBLIC: {
                this.cached.add(pos, new CacheEntry((EntryPublic)entry, (long)time));
                break;
            }
            default: {
                throw new IllegalArgumentException("Attempt to cache unknown entry type");
            }
        }
        super.add(entry);
    }

    @Override
    protected void error(String message, Object ... params) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseURI);
        if (this.locator != null && this.locator.getLineNumber() > 0) {
            sb.append(":");
            sb.append(this.locator.getLineNumber());
            if (this.locator.getColumnNumber() > 0) {
                sb.append(":");
                sb.append(this.locator.getColumnNumber());
            }
        }
        sb.append(":");
        Formatter formatter = new Formatter(sb);
        formatter.format(message, params);
        this.logger.log("cache", sb.toString(), new Object[0]);
    }

    protected EntryUri addUri(URI baseURI, String name, String uri, String nature, String purpose, long timestamp) {
        EntryUri entry = null;
        if (name != null && uri != null) {
            entry = new EntryUri(this.config, baseURI, null, name, uri, nature, purpose);
            this.add(entry, timestamp);
        } else {
            this.error("Invalid uri entry (missing name or uri attribute)", new Object[0]);
        }
        return entry;
    }

    protected EntryPublic addPublic(URI baseURI, String publicId, String uri, long timestamp) {
        EntryPublic entry = null;
        if (publicId != null && uri != null) {
            entry = new EntryPublic(this.config, baseURI, null, publicId, uri, true);
            this.add(entry, timestamp);
        } else {
            this.error("Invalid public entry (missing publicId or uri attribute)", new Object[0]);
        }
        return entry;
    }

    protected EntrySystem addSystem(URI baseURI, String systemId, String uri, long timestamp) {
        EntrySystem entry = null;
        if (systemId != null && uri != null) {
            entry = new EntrySystem(this.config, baseURI, null, systemId, uri);
            this.add(entry, timestamp);
        } else {
            this.error("Invalid system entry (missing systemId or uri attribute)", new Object[0]);
        }
        return entry;
    }

    protected void writeCacheEntry(Entry entry, File cacheFile) throws IOException {
        try (PrintStream xml = new PrintStream(new FileOutputStream(cacheFile));){
            switch (entry.getType()) {
                case URI: {
                    EntryUri uri = (EntryUri)entry;
                    xml.println("<uri xmlns='urn:oasis:names:tc:entity:xmlns:xml:catalog'");
                    xml.println("     xmlns:xr='http://xmlresolver.org/ns/catalog'");
                    xml.println("     name='" + CacheEntryCatalog.xmlEscape(uri.name) + "'");
                    xml.println("     uri='" + CacheEntryCatalog.xmlEscape(uri.uri.toString()) + "'");
                    if (uri.nature != null) {
                        xml.println("     nature='" + CacheEntryCatalog.xmlEscape(uri.nature) + "'");
                    }
                    if (uri.purpose == null) break;
                    xml.println("     purpose='" + CacheEntryCatalog.xmlEscape(uri.purpose) + "'");
                    break;
                }
                case SYSTEM: {
                    EntrySystem system = (EntrySystem)entry;
                    xml.println("<system xmlns='urn:oasis:names:tc:entity:xmlns:xml:catalog'");
                    xml.println("        xmlns:xr='http://xmlresolver.org/ns/catalog'");
                    xml.println("        systemId='" + CacheEntryCatalog.xmlEscape(system.systemId) + "'");
                    xml.println("        uri='" + CacheEntryCatalog.xmlEscape(system.uri.toString()) + "'");
                    break;
                }
                case PUBLIC: {
                    EntryPublic pub = (EntryPublic)entry;
                    xml.println("<public xmlns='urn:oasis:names:tc:entity:xmlns:xml:catalog'");
                    xml.println("        xmlns:xr='http://xmlresolver.org/ns/catalog'");
                    xml.println("        publicId='" + CacheEntryCatalog.xmlEscape(pub.publicId) + "'");
                    xml.println("        uri='" + CacheEntryCatalog.xmlEscape(pub.uri.toString()) + "'");
                    break;
                }
                default: {
                    this.error("Attempt to cache unexpected entry type.", new Object[0]);
                }
            }
            for (String name : entry.getProperties().keySet()) {
                if (entry.getProperty(name) == null) continue;
                xml.println("     xr:" + name + "='" + CacheEntryCatalog.xmlEscape(entry.getProperty(name)) + "'");
            }
            xml.println("/>");
        }
    }

    public static String xmlEscape(String line) {
        return line.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&apos;");
    }

    protected void flushCache(Pattern uriPattern, long maxCount, long maxSize, File expired) {
        ArrayList<Entry> newEntries = new ArrayList<Entry>();
        HashMap newTypedEntries = new HashMap();
        ArrayList<CacheEntry> newCache = new ArrayList<CacheEntry>();
        int cacheCount = 0;
        long cacheSize = 0L;
        boolean last = false;
        for (CacheEntry entry : this.cached) {
            boolean add = true;
            if (uriPattern.matcher(entry.uri.toString()).find()) {
                boolean bl = add = (long)(++cacheCount) <= maxCount && (cacheSize += entry.file.length()) <= maxSize;
            }
            if (add) {
                newCache.add(entry);
                newEntries.add(entry.entry);
                if (!newTypedEntries.containsKey((Object)entry.entry.getType())) {
                    newTypedEntries.put(entry.entry.getType(), new ArrayList());
                }
                ((ArrayList)newTypedEntries.get((Object)entry.entry.getType())).add(entry.entry);
                continue;
            }
            this.logger.log("cache", "Expiring %s (%s)", entry.file.getAbsolutePath(), entry.uri);
            entry.expired = true;
            File entryFile = new File(entry.entry.baseURI);
            Path source = entryFile.toPath();
            Path target = new File(expired, entryFile.getName()).toPath();
            try {
                Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                this.logger.log("error", "Attempt to expire cache entry failed: %s: %s", entry.file.getAbsolutePath(), ex.getMessage());
            }
        }
        this.cached.clear();
        this.cached.addAll(newCache);
        this.entries.clear();
        this.entries.addAll(newEntries);
        this.typedEntries.clear();
        for (Entry.Type type : newTypedEntries.keySet()) {
            this.typedEntries.put(type, newTypedEntries.get((Object)type));
        }
    }

    protected void expire(CacheEntry entry) {
        entry.expired = true;
        this.cached.remove(entry);
        super.remove(entry.entry);
    }
}

