/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;
import org.xmlresolver.CatalogResolver;
import org.xmlresolver.NamespaceResolver;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.logging.ResolverLogger;
import org.xmlresolver.sources.ResolverInputSource;
import org.xmlresolver.sources.ResolverLSInput;
import org.xmlresolver.sources.ResolverSAXSource;

public class Resolver
implements URIResolver,
EntityResolver,
EntityResolver2,
NamespaceResolver,
LSResourceResolver {
    private final ResolverLogger logger;
    protected final XMLResolverConfiguration config;
    protected final CatalogResolver resolver;

    public Resolver() {
        this.config = new XMLResolverConfiguration();
        this.resolver = new CatalogResolver(this.config);
        this.logger = this.config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public Resolver(XMLResolverConfiguration config) {
        this.config = config;
        this.resolver = new CatalogResolver(config);
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public Resolver(CatalogResolver resolver) {
        this.config = resolver.getConfiguration();
        this.resolver = resolver;
        this.logger = this.config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public static String version() {
        return "4.2.0";
    }

    public XMLResolverConfiguration getConfiguration() {
        return this.resolver.getConfiguration();
    }

    public CatalogResolver getCatalogResolver() {
        return this.resolver;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        ResolvedResource rsrc = this.resolver.resolveURI(href, base);
        if (rsrc == null) {
            return null;
        }
        ResolverSAXSource source = new ResolverSAXSource(rsrc.getLocalURI(), new InputSource(rsrc.getInputStream()));
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        ResolvedResource rsrc = null;
        if (type == null || "http://www.w3.org/TR/REC-xml".equals(type)) {
            this.logger.log("request", "resolveResource: XML: %s (baseURI: %s, publicId: %s)", systemId, baseURI, publicId);
            rsrc = this.resolver.resolveEntity(null, publicId, systemId, baseURI);
        } else {
            this.logger.log("request", "resolveResource: %s, %s (namespace: %s, baseURI: %s, publicId: %s)", type, systemId, namespaceURI, baseURI, publicId);
            String purpose = null;
            if ("http://www.w3.org/2001/XMLSchema".equals(type) || "http://www.w3.org/XML/XMLSchema/v1.1".equals(type) || "http://relaxng.org/ns/structure/1.0".equals(type)) {
                purpose = "http://www.rddl.org/purposes#schema-validation";
            }
            rsrc = this.resolver.resolveNamespace(systemId, baseURI, type, purpose);
        }
        if (rsrc == null) {
            return null;
        }
        return new ResolverLSInput(rsrc, publicId);
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        ResolvedResource rsrc = this.resolver.resolveEntity(name, null, null, baseURI);
        if (rsrc == null) {
            return null;
        }
        ResolverInputSource source = new ResolverInputSource(rsrc.getLocalURI(), rsrc.getInputStream());
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        ResolvedResource rsrc = this.resolver.resolveEntity(name, publicId, systemId, baseURI);
        if (rsrc == null) {
            return null;
        }
        ResolverInputSource source = new ResolverInputSource(rsrc.getLocalURI(), rsrc.getInputStream());
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        ResolvedResource rsrc = this.resolver.resolveEntity(null, publicId, systemId, null);
        if (rsrc == null) {
            return null;
        }
        ResolverInputSource source = new ResolverInputSource(rsrc.getLocalURI(), rsrc.getInputStream());
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }

    @Override
    public Source resolveNamespace(String uri, String nature, String purpose) throws TransformerException {
        ResolvedResource rsrc = this.resolver.resolveNamespace(uri, null, nature, purpose);
        if (rsrc == null) {
            return null;
        }
        ResolverSAXSource source = new ResolverSAXSource(rsrc.getLocalURI(), new InputSource(rsrc.getInputStream()));
        source.setSystemId(rsrc.getResolvedURI().toString());
        return source;
    }
}

