/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.properties;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.properties.AxisChartTypeProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.test.HTMLGenerator;

public final class LineChartProperties
extends AxisChartTypeProperties {
    public static final Stroke DEFAULT_LINE_STROKE = new BasicStroke(1.5f);
    private Stroke[] lineStrokes;
    private Shape[] shapes;

    public LineChartProperties(Stroke[] strokeArray, Shape[] shapeArray) {
        this.lineStrokes = strokeArray;
        this.shapes = shapeArray;
    }

    public Stroke[] getLineStrokes() {
        return this.lineStrokes;
    }

    public Shape[] getShapes() {
        return this.shapes;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart("LineChartProperties");
        hTMLGenerator.propertiesTableEnd();
    }

    public void validate(IAxisPlotDataSet iAxisPlotDataSet) throws PropertyException {
        if (this.lineStrokes == null) {
            throw new PropertyException("You must define Stroke Objects for the LineChart in the LineChartProperties Object.");
        }
        if (iAxisPlotDataSet.getNumberOfDataSets() != this.lineStrokes.length) {
            throw new PropertyException("You must define a Stroke Object for each Line in the LineChart.");
        }
        if (this.shapes != null && this.shapes.length != this.lineStrokes.length) {
            throw new PropertyException("The number of Shapes defined in the LineChartProperties Object must equal the number of Lines.");
        }
    }
}

