/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table;

import com.github.weisj.darklaf.ui.table.TableUIBridge;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class DarkTableUIBridge
extends TableUIBridge {
    protected Color dropLine;
    protected Color dropLineShort;

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.dropLine = UIManager.getColor("Table.dropLineColor");
        this.dropLineShort = UIManager.getColor("Table.dropLineShortColor");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container comp;
        Object printMode;
        Rectangle clip = g.getClipBounds();
        Rectangle bounds = this.table.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !bounds.intersects(clip)) {
            this.paintDropLines(g);
            return;
        }
        boolean ltr = this.table.getComponentOrientation().isLeftToRight();
        Rectangle visibleBounds = clip.intersection(bounds);
        Point upperLeft = visibleBounds.getLocation();
        Point lowerRight = new Point(visibleBounds.x + visibleBounds.width - 1, visibleBounds.y + visibleBounds.height - 1);
        int rMin = this.table.rowAtPoint(upperLeft);
        int rMax = this.table.rowAtPoint(lowerRight);
        if (rMin == -1) {
            rMin = 0;
        }
        if (rMax == -1) {
            rMax = this.table.getRowCount() - 1;
        }
        if ((printMode = this.table.getClientProperty("Table.printMode")) == JTable.PrintMode.FIT_WIDTH) {
            upperLeft = clip.getLocation();
            lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        }
        int cMin = this.table.columnAtPoint(ltr ? upperLeft : lowerRight);
        int cMax = this.table.columnAtPoint(ltr ? lowerRight : upperLeft);
        if (cMin == -1) {
            cMin = 0;
        }
        if (cMax == -1) {
            cMax = this.table.getColumnCount() - 1;
        }
        if ((comp = DarkUIUtil.getUnwrappedParent(this.table)) != null) {
            comp = comp.getParent();
        }
        if (comp != null && !(comp instanceof JViewport) && !(comp instanceof JScrollPane) && rMax != this.table.getRowCount() - 1 && this.table.getSelectedRow() == -1 && rMax - rMin > 1) {
            --rMax;
        }
        this.paintGrid(g, rMin, rMax, cMin, cMax);
        this.paintCells(g, rMin, rMax, cMin, cMax);
        this.paintDropLines(g);
    }

    @Override
    protected void paintDropLines(Graphics g) {
        JTable.DropLocation loc = this.table.getDropLocation();
        if (loc == null) {
            return;
        }
        Color color = this.dropLine;
        Color shortColor = this.dropLineShort;
        if (color == null && shortColor == null) {
            return;
        }
        Rectangle rect = this.getHDropLineRect(loc);
        if (rect != null) {
            int x = rect.x;
            int w = rect.width;
            if (color != null) {
                this.extendRect(rect, true);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertColumn() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(x, rect.y, w, rect.height);
            }
        }
        if ((rect = this.getVDropLineRect(loc)) != null) {
            int y = rect.y;
            int h = rect.height;
            if (color != null) {
                this.extendRect(rect, false);
                g.setColor(color);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!loc.isInsertRow() && shortColor != null) {
                g.setColor(shortColor);
                g.fillRect(rect.x, y, rect.width, h);
            }
        }
    }

    @Override
    protected abstract void paintGrid(Graphics var1, int var2, int var3, int var4, int var5);

    @Override
    protected void paintCells(Graphics g, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = this.table.getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = this.table.getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int row = rMin; row <= rMax; ++row) {
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                for (int column = cMin; column <= cMax; ++column) {
                    TableColumn aColumn = cm.getColumn(column);
                    int columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (aColumn != draggedColumn) {
                        this.paintCell(g, cellRect, row, column, rMin, rMax);
                    }
                    cellRect.x += columnWidth;
                }
            }
        } else {
            for (int row = rMin; row <= rMax; ++row) {
                int columnWidth;
                Rectangle cellRect = this.table.getCellRect(row, cMin, false);
                TableColumn aColumn = cm.getColumn(cMin);
                if (aColumn != draggedColumn) {
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    this.paintCell(g, cellRect, row, cMin, cMin, cMax);
                }
                for (int column = cMin + 1; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    cellRect.x -= columnWidth;
                    if (aColumn == draggedColumn) continue;
                    this.paintCell(g, cellRect, row, column, cMin, cMax);
                }
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedArea(g, rMin, rMax, cMin, cMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    @Override
    @Deprecated
    protected final void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
    }

    protected abstract void paintCell(Graphics var1, Rectangle var2, int var3, int var4, int var5, int var6);

    @Override
    protected int viewIndexForColumn(TableColumn aColumn) {
        return DarkTableUIBridge.viewIndexForColumn(aColumn, this.table);
    }

    protected abstract void paintDraggedArea(Graphics var1, int var2, int var3, int var4, int var5, TableColumn var6, int var7);

    public static int viewIndexForColumn(TableColumn aColumn, JTable table) {
        TableColumnModel cm = table.getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            if (cm.getColumn(column) != aColumn) continue;
            return column;
        }
        return -1;
    }
}

