/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.cell.hint;

import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.DarkPopupFactory;
import com.github.weisj.darklaf.ui.cell.hint.IndexedCellContainer;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.WindowUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class CellHintPopupListener<T extends JComponent, I>
extends MouseInputAdapter {
    private static final Logger LOGGER = LogUtil.getLogger(CellHintPopupListener.class);
    private final IndexedCellContainer<T, I> cellContainer;
    private final PopupComponent popupComponent;
    private I lastIndex;
    private Popup popup;

    public CellHintPopupListener(IndexedCellContainer<T, I> cellContainer) {
        this.cellContainer = cellContainer;
        this.popupComponent = new PopupComponent(this);
    }

    public void install() {
        Object comp = this.cellContainer.getComponent();
        ((Component)comp).addMouseListener(this);
        ((Component)comp).addMouseMotionListener(this);
    }

    public void uninstall() {
        Object comp = this.cellContainer.getComponent();
        ((Component)comp).removeMouseListener(this);
        ((Component)comp).removeMouseMotionListener(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        I index = this.cellContainer.getCellPosition(p);
        this.updatePopup(index, p);
    }

    private void updatePopup(I index, Point p) {
        if (this.cellContainer.getComponent() == null || index == null) {
            return;
        }
        if (this.isDifferentPopupOpen()) {
            return;
        }
        boolean isEditing = this.cellContainer.isEditingCell(index);
        Rectangle allocation = this.cellContainer.getAllocation();
        Rectangle cellBounds = this.cellContainer.getCellBoundsAt(index, isEditing);
        if (cellBounds != null && allocation != null) {
            Rectangle visibleBounds = allocation.intersection(cellBounds);
            LOGGER.finer(() -> "Visible bounds at index " + index + ": " + visibleBounds);
            if (visibleBounds.contains(p)) {
                Component comp = this.cellContainer.getEffectiveCellRendererComponent(index, isEditing);
                Dimension prefSize = this.getPreferredSize(isEditing, comp);
                LOGGER.finer(() -> "Necessary cell size at index " + index + ": " + prefSize);
                if (!this.fitsInside(prefSize, visibleBounds)) {
                    this.cellContainer.adjustCellBoundsToPreferredSize(cellBounds, prefSize);
                    Point popupLocation = ((Component)this.cellContainer.getComponent()).getLocationOnScreen();
                    Rectangle popupBounds = this.calculatePopupBounds(cellBounds, visibleBounds, !isEditing);
                    LOGGER.finer(() -> "Popup bounds at index " + index + ": " + popupBounds);
                    if (!visibleBounds.contains(popupBounds)) {
                        cellBounds.x = popupBounds.x - cellBounds.x;
                        cellBounds.y = popupBounds.y - cellBounds.y;
                        popupBounds.x += popupLocation.x;
                        popupBounds.y += popupLocation.y;
                        this.enter(index, popupBounds, cellBounds);
                    }
                } else {
                    this.leave();
                }
                return;
            }
        }
        this.lastIndex = null;
        this.leave();
    }

    private boolean isDifferentPopupOpen() {
        return MenuSelectionManager.defaultManager().getSelectedPath().length > 0;
    }

    private boolean fitsInside(Dimension size, Rectangle bounds) {
        return bounds.width >= size.width && bounds.height >= size.height;
    }

    private Dimension getPreferredSize(boolean isEditing, Component comp) {
        Border border;
        Dimension prefSize = isEditing ? comp.getBounds().getSize() : this.cellContainer.getRequiredCellSize(this.lastIndex, comp);
        if (comp instanceof JComponent && (border = ((JComponent)comp).getBorder()) != null) {
            Insets borderInsets = border.getBorderInsets(comp);
            prefSize.width -= borderInsets.left + borderInsets.right;
            prefSize.height -= borderInsets.top + borderInsets.bottom;
        }
        return prefSize;
    }

    private Rectangle calculatePopupBounds(Rectangle cellBounds, Rectangle visibleBounds, boolean addBorder) {
        Rectangle rect = new Rectangle(visibleBounds);
        boolean ltr = ((Component)this.cellContainer.getComponent()).getComponentOrientation().isLeftToRight();
        this.popupComponent.setBorderInsets(1, 1, 1, 1);
        int hiddenVerticalSpace = Math.abs(cellBounds.width - visibleBounds.width);
        int hiddenHorizontalSpace = Math.abs(cellBounds.height - visibleBounds.height);
        if (hiddenHorizontalSpace > hiddenVerticalSpace) {
            this.calculatePopupHeight(cellBounds, visibleBounds, rect);
        } else {
            this.calculatePopupWidth(cellBounds, visibleBounds, rect, ltr);
        }
        if (!addBorder) {
            this.popupComponent.setBorderInsets(0, 0, 0, 0);
        } else {
            rect.x -= this.popupComponent.getLeft();
            rect.y -= this.popupComponent.getTop();
            rect.width += this.popupComponent.getLeft() + this.popupComponent.getRight();
            rect.height += this.popupComponent.getTop() + this.popupComponent.getBottom();
        }
        return rect;
    }

    private void calculatePopupHeight(Rectangle cellBounds, Rectangle visibleBounds, Rectangle rect) {
        if (cellBounds.y >= visibleBounds.y && cellBounds.y + cellBounds.height <= visibleBounds.y + visibleBounds.height) {
            rect.y = cellBounds.y;
            rect.height = cellBounds.height;
        } else {
            int upperDiff = Math.max(cellBounds.y + cellBounds.height - visibleBounds.y - visibleBounds.height, 0);
            int lowerDiff = Math.max(visibleBounds.y - cellBounds.y, 0);
            if (upperDiff > 0) {
                lowerDiff = 0;
            }
            if (upperDiff >= lowerDiff) {
                rect.y = visibleBounds.y + visibleBounds.height;
                rect.height = upperDiff;
                this.popupComponent.setTop(0);
            } else {
                rect.y = cellBounds.y;
                rect.height = lowerDiff;
                this.popupComponent.setBottom(0);
            }
        }
    }

    private void calculatePopupWidth(Rectangle cellBounds, Rectangle visibleBounds, Rectangle rect, boolean ltr) {
        if (cellBounds.x >= visibleBounds.x && cellBounds.x + cellBounds.width <= visibleBounds.x + visibleBounds.width) {
            rect.x = cellBounds.x;
            rect.width = cellBounds.width;
        } else {
            int upperDiff = Math.max(cellBounds.x + cellBounds.width - visibleBounds.x - visibleBounds.width, 0);
            int lowerDiff = Math.max(visibleBounds.x - cellBounds.x, 0);
            if (ltr && upperDiff > 0) {
                lowerDiff = 0;
            }
            if (!ltr && lowerDiff > 0) {
                upperDiff = 0;
            }
            if (upperDiff >= lowerDiff) {
                rect.x = visibleBounds.x + visibleBounds.width;
                rect.width = upperDiff;
                this.popupComponent.setLeft(0);
            } else {
                rect.x = cellBounds.x;
                rect.width = lowerDiff;
                this.popupComponent.setRight(0);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isOverEditor(e.getPoint())) {
            if (this.popup == null) {
                this.mouseMoved(e);
            }
            return;
        }
        this.leave();
    }

    private boolean isOverEditor(Point p) {
        return this.cellContainer.isEditing() && this.cellContainer.getCellEditorComponent(this.lastIndex).getBounds().contains(p);
    }

    public void repaint() {
        if (!((Component)this.cellContainer.getComponent()).isShowing()) {
            return;
        }
        if (this.popup != null) {
            this.popupComponent.repaint();
        }
        if (this.lastIndex != null) {
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, this.cellContainer.getComponent());
            this.updatePopup(this.lastIndex, p);
        }
    }

    private void enter(I index, Rectangle bounds, Rectangle rendererBounds) {
        LOGGER.log(this.popupComponent.isShowing() ? Level.FINEST : Level.FINE, "Showing cell popup at index " + index);
        if (index != null) {
            this.lastIndex = index;
            this.popupComponent.setPreferredSize(bounds.getSize());
            this.popupComponent.setRendererBounds(rendererBounds);
            if (this.popup != null) {
                Point p;
                Point point = p = this.popupComponent.isShowing() ? this.popupComponent.getLocationOnScreen() : null;
                if (p == null || p.x != bounds.x || p.y != bounds.y || this.popupComponent.getWidth() != bounds.width || this.popupComponent.getHeight() != bounds.height) {
                    this.movePopup(bounds);
                }
            }
            if (this.popup == null) {
                this.popup = PopupFactory.getSharedInstance().getPopup((Component)this.cellContainer.getComponent(), this.popupComponent, bounds.x, bounds.y);
                this.popup.show();
                if (DarkPopupFactory.getPopupType(this.popup) == DarkPopupFactory.PopupType.HEAVY_WEIGHT) {
                    SwingUtilities.invokeLater(() -> {
                        Window w = DarkUIUtil.getWindow(this.popupComponent);
                        if (w != null) {
                            w.setBounds(bounds);
                            WindowUtil.moveWindow(w, this.popupComponent, bounds.x, bounds.y);
                        }
                    });
                }
            }
        }
    }

    private void movePopup(Rectangle bounds) {
        if (this.popup == null) {
            return;
        }
        DarkPopupFactory.PopupType popupType = DarkPopupFactory.getPopupType(this.popup);
        Window w = DarkUIUtil.getWindow(this.popupComponent);
        if (popupType == DarkPopupFactory.PopupType.HEAVY_WEIGHT) {
            this.moveHeavyWeightPopup(bounds, w);
        } else if (w instanceof RootPaneContainer) {
            this.moveMediumLightWeightPopup(bounds, w);
        }
        this.popupComponent.repaint();
    }

    private void moveHeavyWeightPopup(Rectangle bounds, Window popupWindow) {
        GraphicsConfiguration gc = popupWindow.getGraphicsConfiguration();
        GraphicsConfiguration componentGc = ((Component)this.cellContainer.getComponent()).getGraphicsConfiguration();
        if (!Objects.equals(componentGc, gc)) {
            this.popup.hide();
            this.popup = null;
        } else {
            popupWindow.setBounds(bounds);
            WindowUtil.moveWindow(popupWindow, this.popupComponent, bounds.x, bounds.y);
        }
    }

    private void moveMediumLightWeightPopup(Rectangle bounds, Window parentWindow) {
        JLayeredPane layeredPane = ((RootPaneContainer)((Object)parentWindow)).getLayeredPane();
        JRootPane rootPane = ((RootPaneContainer)((Object)parentWindow)).getRootPane();
        Container comp = DarkUIUtil.getParentBeforeMatching(this.popupComponent.getParent(), c -> c == layeredPane);
        Rectangle windowBounds = parentWindow.getBounds();
        if (windowBounds.contains(bounds.x, bounds.y) && windowBounds.contains(bounds.x + bounds.width, bounds.y + bounds.height)) {
            Point windowPos = rootPane.getLocationOnScreen();
            bounds.x -= windowPos.x;
            bounds.y -= windowPos.y;
            comp.setBounds(bounds);
            for (Container c2 = this.popupComponent; c2 != null && comp != c2; c2 = c2.getParent()) {
                c2.setBounds(0, 0, bounds.width, bounds.height);
            }
        } else {
            this.popup.hide();
            this.popup = null;
        }
    }

    private void leave() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private Component getRenderer() {
        return this.cellContainer.getEffectiveCellRendererComponent(this.lastIndex, this.isCurrentCellEditing());
    }

    private boolean isCurrentCellEditing() {
        return this.cellContainer.isEditingCell(this.lastIndex);
    }

    private Color getBackground(Component renderer) {
        return this.cellContainer.getBackgroundAt(this.lastIndex, renderer);
    }

    private static class PopupComponent
    extends JComponent {
        private final CellHintPopupListener<?, ?> cellHintPopupListener;
        private final Insets borderInsets = new Insets(0, 0, 0, 0);
        private final Color borderColor;
        private Rectangle rendererBounds;

        private PopupComponent(CellHintPopupListener<?, ?> cellHintPopupListener) {
            this.cellHintPopupListener = cellHintPopupListener;
            this.borderColor = UIManager.getColor("CellHintPopup.borderColor");
            this.putClientProperty("JPopupFactory.noDecorations", true);
            this.putClientProperty("JPopupFactory.opaque", true);
        }

        public void setTop(int top) {
            this.borderInsets.top = top;
        }

        public void setBottom(int bottom) {
            this.borderInsets.bottom = bottom;
        }

        public void setLeft(int left) {
            this.borderInsets.left = left;
        }

        public void setRight(int right) {
            this.borderInsets.right = right;
        }

        public int getTop() {
            return this.borderInsets.top;
        }

        public int getBottom() {
            return this.borderInsets.bottom;
        }

        public int getLeft() {
            return this.borderInsets.left;
        }

        public int getRight() {
            return this.borderInsets.right;
        }

        public void setBorderInsets(int top, int left, int bottom, int right) {
            this.borderInsets.set(top, left, bottom, right);
        }

        public void setRendererBounds(Rectangle rendererBounds) {
            this.rendererBounds = rendererBounds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            Component renderer = ((CellHintPopupListener)this.cellHintPopupListener).getRenderer();
            if (this.rendererBounds != null && renderer != null) {
                this.paintBackground(g, renderer);
                g.translate(-this.rendererBounds.x, -this.rendererBounds.y);
                Rectangle bounds = renderer.getBounds();
                boolean doubleBuffered = renderer.isDoubleBuffered();
                try {
                    if (renderer instanceof JComponent) {
                        ((JComponent)renderer).setDoubleBuffered(false);
                    }
                    if (!((CellHintPopupListener)this.cellHintPopupListener).isCurrentCellEditing()) {
                        ((CellHintPopupListener)this.cellHintPopupListener).cellContainer.addRenderer(renderer);
                    }
                    renderer.setBounds(0, 0, this.rendererBounds.width, this.rendererBounds.height);
                    renderer.doLayout();
                    renderer.paint(g);
                }
                finally {
                    if (renderer instanceof JComponent) {
                        ((JComponent)renderer).setDoubleBuffered(doubleBuffered);
                    }
                }
                renderer.setBounds(bounds);
                g.translate(this.rendererBounds.x, this.rendererBounds.y);
            }
            g.setColor(this.getBorderColor());
            PaintUtil.drawRect(g, 0, 0, this.getWidth(), this.getHeight(), this.borderInsets);
        }

        public void paintBackground(Graphics g, Component renderer) {
            Color bg = ((CellHintPopupListener)this.cellHintPopupListener).getBackground(renderer);
            if (bg == null) {
                bg = ((Component)((CellHintPopupListener)this.cellHintPopupListener).cellContainer.getComponent()).getBackground();
            }
            if (bg == null) {
                bg = this.getBackground();
            }
            if (bg != null) {
                g.setColor(bg);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public Color getBorderColor() {
            return this.borderColor;
        }
    }
}

