/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.swingdsl;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.swingdsl.laf.ComponentFactoryDelegate;
import com.github.weisj.swingdsl.laf.DefaultComponentFactory;
import com.github.weisj.swingdsl.laf.DefaultWrappedComponent;
import com.github.weisj.swingdsl.laf.StateValue;
import com.github.weisj.swingdsl.laf.WrappedComponent;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class DarklafComponentFactory
extends ComponentFactoryDelegate {
    public DarklafComponentFactory() {
        super(DefaultComponentFactory.create());
    }

    @NotNull
    public WrappedComponent<JScrollPane> createScrollPane(@NotNull JComponent content) {
        OverlayScrollPane sp = new OverlayScrollPane(content);
        return new DefaultWrappedComponent((JComponent)sp.getScrollPane(), (JComponent)sp);
    }

    @NotNull
    public Color getBorderColor() {
        return UIManager.getColor("border");
    }

    @NotNull
    public StateValue<Color> getDividerColor() {
        return new StateValue((Object)UIManager.getColor("borderSecondary"), (Object)UIManager.getColor("widgetBorderInactive"));
    }

    @NotNull
    public Color getHyperlinkColor() {
        return UIManager.getColor("hyperlink");
    }

    @NotNull
    public Color getHyperlinkClickColor() {
        return UIManager.getColor("hyperlinkAccent");
    }

    @NotNull
    public StateValue<Icon> getExpandedIcon() {
        return new StateValue((Object)DarkUIUtil.ICON_LOADER.getIcon("navigation/arrow/thick/arrowDown.svg"), (Object)DarkUIUtil.ICON_LOADER.getIcon("navigation/arrow/thick/arrowDownDisabled.svg"));
    }

    @NotNull
    public StateValue<Icon> getCollapsedIcon() {
        return new StateValue((Object)DarkUIUtil.ICON_LOADER.getIcon("navigation/arrow/thick/arrowRight.svg"), (Object)DarkUIUtil.ICON_LOADER.getIcon("navigation/arrow/thick/arrowRightDisabled.svg"));
    }

    @NotNull
    public Color getColorBackgroundColor() {
        return UIManager.getColor("backgroundColorful");
    }

    @NotNull
    public Color getSecondaryTextForeground() {
        return UIManager.getColor("textForegroundSecondary");
    }

    @NotNull
    public Color getWarningColor() {
        return UIManager.getColor("warningIconColor");
    }

    @NotNull
    public Color getErrorColor() {
        return UIManager.getColor("errorIconColor");
    }
}

