/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.text;

import com.github.weisj.darklaf.components.PlainAction;
import com.github.weisj.darklaf.components.ScrollPopupMenu;
import com.github.weisj.darklaf.components.text.SearchEvent;
import com.github.weisj.darklaf.components.text.SearchListener;
import com.github.weisj.darklaf.components.text.SearchTextField;
import com.github.weisj.darklaf.util.StringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JTextField;

public class TextFieldHistoryPopup
extends ScrollPopupMenu
implements SearchListener {
    private final Set<String> history;
    private final JTextField textField;
    private int capacity;

    public TextFieldHistoryPopup(SearchTextField textField, final int capacity, int maxH) {
        super(maxH);
        this.textField = textField;
        textField.addSearchListener(this);
        this.setCapacity(capacity);
        this.history = Collections.newSetFromMap(new LinkedHashMap<String, Boolean>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
                return this.size() > capacity;
            }
        });
    }

    public List<String> getHistory() {
        return new ArrayList<String>(this.history);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) throws IllegalArgumentException {
        if (capacity < 0) {
            throw new IllegalArgumentException("Negative history size is not supported");
        }
        this.capacity = capacity;
    }

    public int getLength() {
        return this.history.size();
    }

    @Override
    public void searchPerformed(SearchEvent e) {
        String text = e.getText();
        if (!StringUtil.isBlank((String)text)) {
            this.addEntry(text);
        }
    }

    public void addEntry(String entry) {
        this.history.remove(entry);
        this.history.add(entry);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (this.history.size() == 0) {
            return;
        }
        this.removeAll();
        LinkedList<String> list = new LinkedList<String>(this.history);
        Iterator<String> itr = list.descendingIterator();
        while (itr.hasNext()) {
            String item = itr.next();
            this.add(new JMenuItem(new PlainAction(item, () -> this.textField.setText(item))));
        }
        super.show(invoker, x, y);
    }

    public void clearHistory() {
        this.history.clear();
    }
}

