/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class BufferedReaderExt
extends BufferedReader {
    private int pos;
    private Charset charset;

    public BufferedReaderExt(Reader in, String encoding) {
        super(in);
        this.charset = Charset.forName(encoding);
    }

    public int getPos() {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res <= 127) {
            ++this.pos;
        } else {
            byte[] buf = new String(new char[]{(char)res}).getBytes(this.charset);
            this.pos += buf.length;
        }
        return res;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = super.read(cbuf, off, len);
        this.pos += count;
        return count;
    }

    @Override
    public String readLine() throws IOException {
        String res = super.readLine();
        this.pos += res.length();
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        long res = super.skip(n);
        this.pos = (int)((long)this.pos + res);
        return res;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.pos = 0;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        int res = super.read(target);
        this.pos += res;
        return res;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        int res = super.read(cbuf);
        this.pos += res;
        return res;
    }
}

