/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0002%&Bk\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u000e0\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00032\u0006\u0010\"\u001a\u00020!H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0003H\u0016R\u0014\u0010\u0010\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u000e0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0015R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Ljetbrains/datalore/plot/builder/assemble/facet/FacetWrap;", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "facets", "", "", "levels", "", "nrow", "", "ncol", "direction", "Ljetbrains/datalore/plot/builder/assemble/facet/FacetWrap$Direction;", "facetOrdering", "facetFormatters", "Lkotlin/Function1;", "(Ljava/util/List;Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Integer;Ljetbrains/datalore/plot/builder/assemble/facet/FacetWrap$Direction;Ljava/util/List;Ljava/util/List;)V", "colCount", "getColCount", "()I", "isDefined", "", "()Z", "Ljava/lang/Integer;", "numTiles", "getNumTiles", "rowCount", "getRowCount", "shape", "Lkotlin/Pair;", "variables", "getVariables", "()Ljava/util/List;", "dataByTile", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "tileInfos", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets$FacetTileInfo;", "Companion", "Direction", "plot-builder-portable"})
public final class FacetWrap
extends PlotFacets {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> facets;
    @Nullable
    private final Integer nrow;
    @Nullable
    private final Integer ncol;
    @NotNull
    private final Direction direction;
    @NotNull
    private final List<Function1<Object, String>> facetFormatters;
    private final boolean isDefined;
    @NotNull
    private final List<List<Object>> levels;
    private final int numTiles;
    @NotNull
    private final Pair<Integer, Integer> shape;
    private final int colCount;
    private final int rowCount;
    @NotNull
    private final List<String> variables;

    public FacetWrap(@NotNull List<String> facets, @NotNull List<? extends List<? extends Object>> levels, @Nullable Integer nrow, @Nullable Integer ncol, @NotNull Direction direction, @NotNull List<Integer> facetOrdering, @NotNull List<? extends Function1<Object, String>> facetFormatters) {
        Intrinsics.checkNotNullParameter(facets, (String)"facets");
        Intrinsics.checkNotNullParameter(levels, (String)"levels");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter(facetOrdering, (String)"facetOrdering");
        Intrinsics.checkNotNullParameter(facetFormatters, (String)"facetFormatters");
        this.facets = facets;
        this.nrow = nrow;
        this.ncol = ncol;
        this.direction = direction;
        this.facetFormatters = facetFormatters;
        this.isDefined = true;
        this.levels = PlotFacets.Companion.reorderLevels(this.facets, levels, facetOrdering);
        this.numTiles = FacetWrap.Companion.numTiles(this.facets, levels);
        this.shape = FacetWrap.Companion.shape(this.getNumTiles(), this.ncol, this.nrow, this.direction);
        this.colCount = ((Number)this.shape.getFirst()).intValue();
        this.rowCount = ((Number)this.shape.getSecond()).intValue();
        this.variables = this.facets;
    }

    @Override
    public boolean isDefined() {
        return this.isDefined;
    }

    @Override
    public int getNumTiles() {
        return this.numTiles;
    }

    @Override
    public int getColCount() {
        return this.colCount;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    @NotNull
    public List<String> getVariables() {
        return this.variables;
    }

    @Override
    @NotNull
    public List<DataFrame> dataByTile(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        List<Pair<List<Object>, DataFrame>> dataByLevelTuple = PlotFacets.Companion.dataByLevelTuple(data, this.getVariables(), this.levels);
        List dataByTile = new ArrayList();
        for (Pair<List<Object>, DataFrame> pair : dataByLevelTuple) {
            DataFrame tileData = (DataFrame)pair.component2();
            dataByTile.add(tileData);
        }
        return dataByTile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PlotFacets.FacetTileInfo> tileInfos() {
        List list;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        List it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        List<List<Pair<String, Object>>> levelTuples = PlotFacets.Companion.createNameLevelTuples(this.facets, this.levels);
        Iterable $this$map$iv = levelTuples;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            List list2 = (List)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Iterable $this$map$iv2 = it;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                void pair;
                Pair pair2 = (Pair)item$iv$iv2;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                object = pair.getSecond();
                collection2.add(object);
            }
            list = (List)destination$iv$iv;
            collection.add(list);
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void $this$mapIndexedTo$iv$iv;
            it = (List)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Iterable $this$mapIndexed$iv = it;
            boolean $i$f$mapIndexed = false;
            $this$mapTo$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv3 : $this$mapIndexedTo$iv$iv) {
                void level;
                void i;
                int n = index$iv$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                object = item$iv$iv3;
                int n2 = n;
                Collection collection3 = destination$iv$iv;
                boolean bl4 = false;
                String string = (String)this.facetFormatters.get((int)i).invoke((Object)level);
                collection3.add(string);
            }
            list = (List)destination$iv$iv;
            collection.add(list);
        }
        List tileLabels = (List)destination$iv$iv2;
        ArrayList<PlotFacets.FacetTileInfo> infos = new ArrayList<PlotFacets.FacetTileInfo>();
        Iterator iterator = tileLabels.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            List tileLabelTuple = (List)iterator.next();
            int col = FacetWrap.tileInfos$toCol(this, i);
            int row = FacetWrap.tileInfos$toRow(this, i);
            boolean hasXAxis = FacetWrap.tileInfos$isBottom(this, col, row);
            boolean hasYAxis = col == 0;
            infos.add(new PlotFacets.FacetTileInfo(col, row, tileLabelTuple, null, hasXAxis, hasYAxis, i));
        }
        boolean bl = false;
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getRow());
                it = (PlotFacets.FacetTileInfo)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Integer.valueOf(it.getRow());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
        n = 0;
        return CollectionsKt.sortedWith((Iterable)infos, (Comparator)new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getCol());
                    it = (PlotFacets.FacetTileInfo)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = Integer.valueOf(it.getCol());
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
                return n;
            }
        });
    }

    private static final int tileInfos$toCol(FacetWrap this$0, int index) {
        int n;
        Direction direction = this$0.direction;
        int n2 = WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
        switch (n2) {
            case 1: {
                n = index % this$0.getColCount();
                break;
            }
            case 2: {
                n = index / this$0.getRowCount();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final int tileInfos$toRow(FacetWrap this$0, int index) {
        int n;
        Direction direction = this$0.direction;
        int n2 = WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
        switch (n2) {
            case 1: {
                n = index / this$0.getColCount();
                break;
            }
            case 2: {
                n = index % this$0.getRowCount();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final int tileInfos$toIndex(FacetWrap this$0, int col, int row) {
        int n;
        Direction direction = this$0.direction;
        int n2 = WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
        switch (n2) {
            case 1: {
                n = row * this$0.getColCount() + col;
                break;
            }
            case 2: {
                n = col * this$0.getRowCount() + row;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final boolean tileInfos$isBottom(FacetWrap this$0, int col, int row) {
        int nextRowIndex = FacetWrap.tileInfos$toIndex(this$0, col, row + 1);
        return (row + 1) % this$0.getRowCount() == 0 || nextRowIndex >= this$0.getNumTiles();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/builder/assemble/facet/FacetWrap$Direction;", "", "(Ljava/lang/String;I)V", "H", "V", "plot-builder-portable"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction H = new Direction();
        public static final /* enum */ Direction V = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.H, Direction.V};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00060\u0006H\u0002J=\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/builder/assemble/facet/FacetWrap$Companion;", "", "()V", "numTiles", "", "facets", "", "", "levels", "shape", "Lkotlin/Pair;", "tilesCount", "ncol", "nrow", "dir", "Ljetbrains/datalore/plot/builder/assemble/facet/FacetWrap$Direction;", "(ILjava/lang/Integer;Ljava/lang/Integer;Ljetbrains/datalore/plot/builder/assemble/facet/FacetWrap$Direction;)Lkotlin/Pair;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final int numTiles(List<String> facets, List<? extends List<? extends Object>> levels) {
            Collection collection = facets;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "List of facets is empty.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl2 = CollectionsKt.distinct((Iterable)facets).size() == facets.size();
            bl = false;
            bl3 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = Intrinsics.stringPlus((String)"Duplicated values in the facets list: ", facets);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl2 = facets.size() == levels.size();
            bl = false;
            bl3 = false;
            bl3 = false;
            boolean bl6 = false;
            if (!bl2) {
                boolean bl7 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return PlotFacets.Companion.createNameLevelTuples(facets, levels).size();
        }

        private final Pair<Integer, Integer> shape(int tilesCount, Integer ncol, Integer nrow, Direction dir) {
            Pair pair;
            Pair shape;
            int ncolActual;
            Pair pair2;
            int nrowActual;
            int n;
            int $i$a$-require-FacetWrap$Companion$shape$82;
            boolean bl;
            boolean bl2;
            boolean bl3;
            int it;
            int n2;
            boolean bl4;
            Integer n3 = ncol;
            if (n3 == null) {
                bl4 = true;
            } else {
                Integer n4 = n3;
                boolean bl5 = false;
                n2 = 0;
                it = ((Number)n4).intValue();
                boolean bl6 = false;
                bl4 = bl3 = ncol > 0;
            }
            boolean bl7 = bl4;
            bl3 = false;
            boolean bl8 = false;
            if (!bl7) {
                bl2 = false;
                String string = Intrinsics.stringPlus((String)"'ncol' must be positive, was ", (Object)ncol);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Integer n5 = nrow;
            if (n5 == null) {
                bl = true;
            } else {
                Integer n6 = n5;
                bl2 = false;
                n2 = 0;
                it = ((Number)n6).intValue();
                boolean bl9 = false;
                bl = bl3 = nrow > 0;
            }
            boolean bl10 = bl;
            bl3 = false;
            int n7 = 0;
            if (!bl10) {
                $i$a$-require-FacetWrap$Companion$shape$82 = 0;
                String string = Intrinsics.stringPlus((String)"'nrow' must be positive, was ", (Object)nrow);
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (ncol != null) {
                n7 = ncol;
                $i$a$-require-FacetWrap$Companion$shape$82 = 0;
                int ncolActual2 = Math.min(n7, tilesCount);
                double $i$a$-require-FacetWrap$Companion$shape$82 = (double)tilesCount / (double)ncolActual2;
                n = 0;
                nrowActual = (int)Math.ceil($i$a$-require-FacetWrap$Companion$shape$82);
                $i$a$-require-FacetWrap$Companion$shape$82 = 1;
                n2 = 0;
                pair2 = TuplesKt.to((Object)ncolActual2, (Object)Math.max($i$a$-require-FacetWrap$Companion$shape$82, nrowActual));
            } else if (nrow != null) {
                nrowActual = nrow;
                $i$a$-require-FacetWrap$Companion$shape$82 = 0;
                int nrowActual2 = Math.min(nrowActual, tilesCount);
                double $i$a$-require-FacetWrap$Companion$shape$82 = (double)tilesCount / (double)nrowActual2;
                n = 0;
                ncolActual = (int)Math.ceil($i$a$-require-FacetWrap$Companion$shape$82);
                $i$a$-require-FacetWrap$Companion$shape$82 = 1;
                n2 = 0;
                pair2 = TuplesKt.to((Object)ncolActual, (Object)Math.max($i$a$-require-FacetWrap$Companion$shape$82, nrowActual2));
            } else {
                ncolActual = 4;
                $i$a$-require-FacetWrap$Companion$shape$82 = 1;
                n2 = tilesCount / 2;
                n = 0;
                $i$a$-require-FacetWrap$Companion$shape$82 = Math.max($i$a$-require-FacetWrap$Companion$shape$82, n2);
                n2 = 0;
                int w = Math.min(ncolActual, $i$a$-require-FacetWrap$Companion$shape$82);
                $i$a$-require-FacetWrap$Companion$shape$82 = 1;
                double d = (double)tilesCount / (double)w;
                boolean bl11 = false;
                n2 = (int)Math.ceil(d);
                n = 0;
                int h = Math.max($i$a$-require-FacetWrap$Companion$shape$82, n2);
                pair2 = TuplesKt.to((Object)w, (Object)h);
            }
            Pair pair3 = shape = pair2;
            int w = ((Number)pair3.component1()).intValue();
            int h = ((Number)pair3.component2()).intValue();
            Direction direction = dir;
            n = WhenMappings.$EnumSwitchMapping$0[direction.ordinal()];
            switch (n) {
                case 1: {
                    double d = (double)tilesCount / (double)w;
                    boolean bl12 = false;
                    Pair pair4 = new Pair((Object)w, (Object)((int)Math.ceil(d)));
                    pair = pair4;
                    break;
                }
                case 2: {
                    double d = (double)tilesCount / (double)h;
                    boolean bl13 = false;
                    Pair pair5 = new Pair((Object)((int)Math.ceil(d)), (Object)h);
                    pair = pair5;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Direction.values().length];
                nArray[Direction.H.ordinal()] = 1;
                nArray[Direction.V.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            nArray[Direction.H.ordinal()] = 1;
            nArray[Direction.V.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

