/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.logging;

import java.lang.reflect.Constructor;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class LoggingUtils {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static void addLoggingConfig() {
        if (LoggingUtils.isJMeter32orLater()) {
            LoggingUtils.configureCMDLogging();
        }
    }

    private static void configureCMDLogging() {
        try {
            Class<?> cls = Class.forName("kg.apc.logging.LoggingConfigurator");
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            System.out.println("Fail to configure logging " + ex.getMessage());
            ex.printStackTrace(System.out);
        }
    }

    public static boolean isJMeter32orLater() {
        try {
            Class<?> cls = LoggingUtils.class.getClassLoader().loadClass("org.apache.jmeter.gui.logging.GuiLogEventBus");
            if (cls != null) {
                return true;
            }
        }
        catch (ClassNotFoundException ex) {
            log.debug("Class 'org.apache.jmeter.gui.logging.GuiLogEventBus' not found", (Throwable)ex);
        }
        catch (Throwable ex) {
            log.warn("Fail to detect JMeter version", ex);
        }
        return false;
    }
}

