/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel;

import java.nio.DoubleBuffer;
import java.util.PrimitiveIterator;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.EXPERIMENTAL, since="5.5")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\t\u0010\t\u001a\u00020\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/apache/jmeter/threads/openmodel/PoissonArrivalsRamp;", "Ljava/util/PrimitiveIterator$OfDouble;", "()V", "events", "Ljava/nio/DoubleBuffer;", "ensureCapacity", "", "len", "", "hasNext", "", "nextDouble", "", "prepare", "beginRate", "endRate", "duration", "random", "Ljava/util/Random;", "remove", "Companion", "ApacheJMeter_core"})
public final class PoissonArrivalsRamp
implements PrimitiveIterator.OfDouble {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private DoubleBuffer events;
    @Deprecated
    private static final Logger log = LoggerFactory.getLogger(PoissonArrivalsRamp.class);

    @Override
    public void remove() {
        String string = "Element removal is not supported";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean hasNext() {
        DoubleBuffer doubleBuffer = this.events;
        if (doubleBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"events");
            doubleBuffer = null;
        }
        return doubleBuffer.hasRemaining();
    }

    @Override
    public double nextDouble() {
        DoubleBuffer doubleBuffer = this.events;
        if (doubleBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"events");
            doubleBuffer = null;
        }
        return doubleBuffer.get();
    }

    private final void ensureCapacity(int len) {
        if (this.events != null) {
            DoubleBuffer doubleBuffer = this.events;
            if (doubleBuffer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"events");
                doubleBuffer = null;
            }
            if (doubleBuffer.capacity() >= len) {
                DoubleBuffer doubleBuffer2 = this.events;
                if (doubleBuffer2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"events");
                    doubleBuffer2 = null;
                }
                doubleBuffer2.clear();
                return;
            }
        }
        DoubleBuffer doubleBuffer = DoubleBuffer.allocate(len);
        Intrinsics.checkNotNullExpressionValue((Object)doubleBuffer, (String)"allocate(len)");
        this.events = doubleBuffer;
    }

    public final void prepare(double beginRate, double endRate, double duration, @NotNull Random random) {
        DoubleBuffer events;
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        double minRate = Math.min(beginRate, endRate);
        int numEvents = (int)((beginRate + endRate) / (double)2 * duration);
        this.ensureCapacity(numEvents);
        int flatEvents = (int)(minRate * duration);
        DoubleBuffer doubleBuffer = this.events;
        if (doubleBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"events");
            doubleBuffer = events = null;
        }
        if (minRate > 0.0) {
            int n = 0;
            while (n < flatEvents) {
                int it = n++;
                boolean bl = false;
                events.put(random.nextDouble() * duration);
            }
        }
        int eventsLeft = numEvents - flatEvents;
        if (log.isInfoEnabled()) {
            Object[] objectArray = new Object[]{numEvents, beginRate, endRate, duration};
            log.info("Generating {} events, beginRate = {} / sec, endRate = {} / sec, duration = {} sec", objectArray);
        }
        if (!(beginRate == endRate) && eventsLeft != 0) {
            for (int i = 0; i < eventsLeft; ++i) {
                int it = i;
                boolean bl = false;
                double time = Math.sqrt(random.nextDouble());
                if (beginRate > endRate) {
                    time = 1.0 - time;
                }
                events.put(time * duration);
            }
        }
        double[] dArray = events.array();
        Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"events.array()");
        ArraysKt.sort((double[])dArray, (int)0, (int)events.position());
        events.flip();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/jmeter/threads/openmodel/PoissonArrivalsRamp$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ApacheJMeter_core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

