/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel;

import java.io.Serializable;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.math.MathKt;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.TestCompilerHelper;
import org.apache.jmeter.threads.openmodel.ThreadSchedule;
import org.apache.jmeter.threads.openmodel.ThreadScheduleProcessGenerator;
import org.apache.jmeter.threads.openmodel.ThreadScheduleUtils;
import org.apache.jorphan.collections.ListedHashTree;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@GUIMenuSortOrder(value=1)
@API(status=API.Status.EXPERIMENTAL, since="5.5")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0007\u0018\u0000 42\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u000245B\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J(\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010*\u001a\u00020$H\u0016J\u001a\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u00122\u0006\u0010.\u001a\u00020,H\u0016J\b\u0010/\u001a\u00020$H\u0016J\u0012\u00100\u001a\u00020$2\b\u00101\u001a\u0004\u0018\u00010\tH\u0016J\b\u00102\u001a\u00020,H\u0016J\b\u00103\u001a\u00020$H\u0016R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/apache/jmeter/threads/openmodel/OpenModelThreadGroup;", "Lorg/apache/jmeter/threads/AbstractThreadGroup;", "Ljava/io/Serializable;", "Lorg/apache/jmeter/control/Controller;", "Lorg/apache/jmeter/threads/JMeterThreadMonitor;", "Lorg/apache/jmeter/threads/TestCompilerHelper;", "()V", "activeThreads", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/apache/jmeter/threads/JMeterThread;", "Ljava/util/concurrent/Future;", "executorService", "Ljava/util/concurrent/ExecutorService;", "randomSeed", "", "getRandomSeed", "()J", "value", "", "randomSeedString", "getRandomSeedString", "()Ljava/lang/String;", "setRandomSeedString", "(Ljava/lang/String;)V", "scheduleString", "getScheduleString", "setScheduleString", "threadStarterFuture", "Ljava/util/concurrent/atomic/AtomicReference;", "addNewThread", "delay", "", "engine", "Lorg/apache/jmeter/engine/StandardJMeterEngine;", "numberOfActiveThreads", "start", "", "threadGroupIndex", "notifier", "Lorg/apache/jmeter/threads/ListenerNotifier;", "threadGroupTree", "Lorg/apache/jorphan/collections/ListedHashTree;", "stop", "stopThread", "", "threadName", "now", "tellThreadsToStop", "threadFinished", "thread", "verifyThreadsStopped", "waitThreadsStopped", "Companion", "ThreadsStarter", "ApacheJMeter_core"})
public final class OpenModelThreadGroup
extends AbstractThreadGroup
implements Serializable,
Controller,
JMeterThreadMonitor,
TestCompilerHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ExecutorService executorService;
    @NotNull
    private final AtomicReference<Future<?>> threadStarterFuture = new AtomicReference();
    @NotNull
    private final ConcurrentHashMap<JMeterThread, Future<?>> activeThreads = new ConcurrentHashMap();
    private static final Logger log = LoggerFactory.getLogger(OpenModelThreadGroup.class);
    @NotNull
    public static final String SCHEDULE = "OpenModelThreadGroup.schedule";
    @NotNull
    public static final String RANDOM_SEED = "OpenModelThreadGroup.random_seed";
    private static final ExecutorService houseKeepingThreadPool = Executors.newCachedThreadPool();
    private static final long serialVersionUID = 1L;

    @NotNull
    public final String getScheduleString() {
        String string = this.getPropertyAsString(SCHEDULE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPropertyAsString(SCHEDULE)");
        return string;
    }

    public final void setScheduleString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setProperty(SCHEDULE, value);
    }

    public final long getRandomSeed() {
        return this.getPropertyAsLong(RANDOM_SEED);
    }

    @NotNull
    public final String getRandomSeedString() {
        String string = this.getPropertyAsString(RANDOM_SEED);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPropertyAsString(RANDOM_SEED)");
        return string;
    }

    public final void setRandomSeedString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setProperty(RANDOM_SEED, value);
    }

    @Override
    public void start(int threadGroupIndex, @NotNull ListenerNotifier notifier, @NotNull ListedHashTree threadGroupTree, @NotNull StandardJMeterEngine engine) {
        Intrinsics.checkNotNullParameter((Object)notifier, (String)"notifier");
        Intrinsics.checkNotNullParameter((Object)threadGroupTree, (String)"threadGroupTree");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        try {
            ExecutorService executorService;
            JMeterContext jMeterContext = JMeterContextService.getContext();
            JMeterVariables variables = jMeterContext.getVariables();
            String schedule = this.getScheduleString();
            log.info("Starting OpenModelThreadGroup#{} with schedule {}", (Object)threadGroupIndex, (Object)schedule);
            ThreadSchedule parsedSchedule = ThreadScheduleUtils.ThreadSchedule(schedule);
            long seed = this.getRandomSeed();
            Random rnd = seed == 0L ? new Random() : new Random(seed);
            ThreadScheduleProcessGenerator gen = new ThreadScheduleProcessGenerator(rnd, parsedSchedule);
            long testStartTime = JMeterContextService.getTestStartTime();
            this.executorService = executorService = Executors.newCachedThreadPool();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executorService");
            ThreadsStarter starter2 = new ThreadsStarter(testStartTime, executorService, (Map)this.activeThreads, gen, (Function1<? super Integer, ? extends JMeterThread>)((Function1)new Function1<Integer, JMeterThread>(threadGroupTree, this, engine, notifier, threadGroupIndex, variables){
                final /* synthetic */ ListedHashTree $threadGroupTree;
                final /* synthetic */ OpenModelThreadGroup this$0;
                final /* synthetic */ StandardJMeterEngine $engine;
                final /* synthetic */ ListenerNotifier $notifier;
                final /* synthetic */ int $threadGroupIndex;
                final /* synthetic */ JMeterVariables $variables;
                {
                    this.$threadGroupTree = $threadGroupTree;
                    this.this$0 = $receiver;
                    this.$engine = $engine;
                    this.$notifier = $notifier;
                    this.$threadGroupIndex = $threadGroupIndex;
                    this.$variables = $variables;
                    super(1);
                }

                @NotNull
                public final JMeterThread invoke(int threadNumber) {
                    ListedHashTree clonedTree = AbstractThreadGroup.cloneTree(this.$threadGroupTree);
                    JMeterThread jMeterThread = OpenModelThreadGroup.access$makeThread(this.this$0, this.$engine, this.this$0, this.$notifier, this.$threadGroupIndex, threadNumber, clonedTree, this.$variables);
                    Intrinsics.checkNotNullExpressionValue((Object)jMeterThread, (String)"makeThread(engine, this,\u2026r, clonedTree, variables)");
                    return jMeterThread;
                }
            }));
            this.threadStarterFuture.set(houseKeepingThreadPool.submit(() -> OpenModelThreadGroup.start$lambda-0(this, threadGroupIndex, starter2)));
        }
        catch (Throwable expected) {
            log.error("Unable to start thread group", expected);
        }
    }

    @Override
    public void threadFinished(@Nullable JMeterThread thread) {
        TypeIntrinsics.asMutableMap((Object)this.activeThreads).remove(thread);
    }

    @Override
    @NotNull
    public JMeterThread addNewThread(int delay, @Nullable StandardJMeterEngine engine) {
        String string = "Will not be implemented as the semantics of the API is unclear";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public boolean stopThread(@Nullable String threadName, boolean now) {
        String string = "Will not be implemented as the semantics of the API is unclear";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public int numberOfActiveThreads() {
        return this.activeThreads.size();
    }

    @Override
    public boolean verifyThreadsStopped() {
        ExecutorService executorService = this.executorService;
        return !(executorService != null ? !executorService.awaitTermination(0L, TimeUnit.SECONDS) : false);
    }

    @Override
    public void waitThreadsStopped() {
        block0: {
            ExecutorService executorService = this.executorService;
            if (executorService == null) break block0;
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
    }

    @Override
    public void stop() {
        log.info("Gracefully stopping the threads");
        Future future = this.threadStarterFuture.getAndSet(null);
        if (future != null) {
            future.cancel(true);
        }
        this.activeThreads.forEach(OpenModelThreadGroup::stop$lambda-1);
    }

    @Override
    public void tellThreadsToStop() {
        block1: {
            this.stop();
            log.info("Interrupting the threads");
            Object object = this.executorService;
            if (object == null || (object = object.shutdownNow()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Runnable it = (Runnable)element$iv;
                boolean bl = false;
                TypeIntrinsics.asMutableMap((Object)this.activeThreads).remove(it);
            }
        }
    }

    private static final void start$lambda-0(OpenModelThreadGroup this$0, int $threadGroupIndex, ThreadsStarter $starter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$starter, (String)"$starter");
        Thread.currentThread().setName("open-model-thread-starter-" + this$0.getName() + '-' + $threadGroupIndex);
        $starter.run();
    }

    private static final void stop$lambda-1(JMeterThread thread, Future future) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)future, (String)"<anonymous parameter 1>");
        log.info("Gracefully stopping thread {}", (Object)thread);
        thread.stop();
    }

    public static final /* synthetic */ JMeterThread access$makeThread(OpenModelThreadGroup $this, StandardJMeterEngine engine, JMeterThreadMonitor monitor, ListenerNotifier notifier, int groupNumber, int threadNumber, ListedHashTree threadGroupTree, JMeterVariables variables) {
        return $this.makeThread(engine, monitor, notifier, groupNumber, threadNumber, threadGroupTree, variables);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/apache/jmeter/threads/openmodel/OpenModelThreadGroup$Companion;", "", "()V", "RANDOM_SEED", "", "SCHEDULE", "houseKeepingThreadPool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "serialVersionUID", "", "ApacheJMeter_core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BX\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/apache/jmeter/threads/openmodel/OpenModelThreadGroup$ThreadsStarter;", "Ljava/lang/Runnable;", "testStartTime", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "activeThreads", "", "Lorg/apache/jmeter/threads/JMeterThread;", "Ljava/util/concurrent/Future;", "gen", "Lorg/apache/jmeter/threads/openmodel/ThreadScheduleProcessGenerator;", "jmeterThreadFactory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "threadNumber", "(JLjava/util/concurrent/ExecutorService;Ljava/util/Map;Lorg/apache/jmeter/threads/openmodel/ThreadScheduleProcessGenerator;Lkotlin/jvm/functions/Function1;)V", "run", "", "ApacheJMeter_core"})
    private static final class ThreadsStarter
    implements Runnable {
        private final long testStartTime;
        @NotNull
        private final ExecutorService executorService;
        @NotNull
        private final Map<JMeterThread, Future<?>> activeThreads;
        @NotNull
        private final ThreadScheduleProcessGenerator gen;
        @NotNull
        private final Function1<Integer, JMeterThread> jmeterThreadFactory;

        public ThreadsStarter(long testStartTime, @NotNull ExecutorService executorService, @NotNull Map<JMeterThread, Future<?>> activeThreads, @NotNull ThreadScheduleProcessGenerator gen, @NotNull Function1<? super Integer, ? extends JMeterThread> jmeterThreadFactory) {
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            Intrinsics.checkNotNullParameter(activeThreads, (String)"activeThreads");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter(jmeterThreadFactory, (String)"jmeterThreadFactory");
            this.testStartTime = testStartTime;
            this.executorService = executorService;
            this.activeThreads = activeThreads;
            this.gen = gen;
            this.jmeterThreadFactory = jmeterThreadFactory;
        }

        @Override
        public void run() {
            log.info("Thread starting init");
            long endTime = MathKt.roundToLong((double)((double)this.testStartTime + this.gen.getTotalDuration() * (double)1000));
            int threadNumber = 0;
            long prevTime = 0L;
            while (this.gen.hasNext()) {
                Future<?> future;
                long nextDelay;
                long scheduledTime = this.testStartTime + MathKt.roundToLong((double)(this.gen.nextDouble() * (double)1000));
                if (scheduledTime >= prevTime && (nextDelay = scheduledTime - (prevTime = System.currentTimeMillis())) > 0L) {
                    Thread.sleep(nextDelay);
                }
                JMeterThread jmeterThread = (JMeterThread)this.jmeterThreadFactory.invoke((Object)threadNumber++);
                jmeterThread.setEndTime(endTime);
                Map<JMeterThread, Future<?>> map = this.activeThreads;
                Intrinsics.checkNotNullExpressionValue(this.executorService.submit(() -> ThreadsStarter.run$lambda-0(jmeterThread)), (String)"executorService.submit {\u2026d.run()\n                }");
                map.put(jmeterThread, future);
            }
            long timeLeft = endTime - System.currentTimeMillis();
            if (timeLeft > 0L) {
                log.info("There will be no more events, so will wait for {} sec till the end of the schedule", (Object)TimeUnit.MILLISECONDS.toSeconds(timeLeft));
                Thread.sleep(timeLeft);
            } else {
                log.info("Thread schedule finished {} ms ago", (Object)(-timeLeft));
            }
            int threadsStillRunning = this.activeThreads.size();
            if (threadsStillRunning == 0) {
                log.info("There will be no more events, will shutdown the thread pool");
            } else {
                log.info("Test schedule finished, however, there are {} thread(s) still running. Will interrupt the threads. If you want to keep some time for the threads to complete, consider adding pause(10 min) at the end of the schedule.", (Object)threadsStillRunning);
                this.activeThreads.forEach(ThreadsStarter::run$lambda-1);
            }
            this.executorService.shutdownNow();
            log.info("Thread starting done");
        }

        private static final void run$lambda-0(JMeterThread $jmeterThread) {
            Intrinsics.checkNotNullParameter((Object)$jmeterThread, (String)"$jmeterThread");
            Thread.currentThread().setName($jmeterThread.getThreadName());
            $jmeterThread.run();
        }

        private static final void run$lambda-1(JMeterThread thread, Future future) {
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)future, (String)"future");
            log.info("Terminating thread {}", (Object)thread);
            thread.stop();
            future.cancel(true);
        }
    }
}

