/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;

public class StringProperty
extends AbstractProperty {
    private static final long serialVersionUID = 233L;
    private String value;
    private transient String savedValue;

    public StringProperty(String name, String value) {
        super(name);
        this.value = value;
    }

    public StringProperty() {
    }

    @Override
    public void setRunningVersion(boolean runningVersion) {
        super.setRunningVersion(runningVersion);
        this.savedValue = runningVersion ? this.value : null;
    }

    @Override
    public void setObjectValue(Object v) {
        this.value = v.toString();
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public Object getObjectValue() {
        return this.value;
    }

    @Override
    public StringProperty clone() {
        StringProperty prop = (StringProperty)super.clone();
        prop.value = this.value;
        return prop;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void recoverRunningVersion(TestElement owner) {
        if (this.savedValue != null) {
            this.value = this.savedValue;
        }
    }
}

