/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.save.ScriptWrapper;
import org.apache.jmeter.save.converters.ConversionHelp;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;

public class ScriptWrapperConverter
implements Converter {
    private static final String ATT_PROPERTIES = "properties";
    private static final String ATT_VERSION = "version";
    private static final String ATT_JMETER = "jmeter";
    private final Mapper classMapper;

    public static String getVersion() {
        return "$Revision$";
    }

    public ScriptWrapperConverter(Mapper classMapper) {
        this.classMapper = classMapper;
    }

    public boolean canConvert(Class arg0) {
        return arg0.equals(ScriptWrapper.class);
    }

    public void marshal(Object arg0, HierarchicalStreamWriter writer, MarshallingContext context) {
        ScriptWrapper wrap = (ScriptWrapper)arg0;
        String version = SaveService.getVERSION();
        ConversionHelp.setOutVersion(version);
        writer.addAttribute(ATT_VERSION, version);
        writer.addAttribute(ATT_PROPERTIES, SaveService.getPropertiesVersion());
        writer.addAttribute(ATT_JMETER, JMeterUtils.getJMeterVersion());
        writer.startNode(this.classMapper.serializedClass(wrap.testPlan.getClass()));
        context.convertAnother((Object)wrap.testPlan);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ScriptWrapper wrap = new ScriptWrapper();
        wrap.version = reader.getAttribute(ATT_VERSION);
        ConversionHelp.setInVersion(wrap.version);
        reader.moveDown();
        try {
            wrap.testPlan = (HashTree)context.convertAnother((Object)wrap, this.getNextType(reader));
        }
        catch (Exception | NoClassDefFoundError e) {
            throw this.createConversionException(e);
        }
        return wrap;
    }

    private ConversionException createConversionException(Throwable e) {
        ConversionException conversionException = new ConversionException(e);
        StackTraceElement[] ste = e.getStackTrace();
        if (ste != null) {
            for (StackTraceElement top : ste) {
                String className = top.getClassName();
                if (!className.startsWith("org.apache.jmeter.")) continue;
                conversionException.add("first-jmeter-class", top.toString());
                break;
            }
        }
        return conversionException;
    }

    protected Class<?> getNextType(HierarchicalStreamReader reader) {
        String classAttribute = reader.getAttribute("class");
        Class type = classAttribute == null ? this.classMapper.realClass(reader.getNodeName()) : this.classMapper.realClass(classAttribute);
        return type;
    }
}

