/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.TimeRateAggregatorFactory;
import org.apache.jmeter.report.processor.graph.AbstractOverTimeGraphConsumer;
import org.apache.jmeter.report.processor.graph.AbstractSeriesSelector;
import org.apache.jmeter.report.processor.graph.GraphValueSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.TimeStampKeysSelector;

public class BytesThroughputGraphConsumer
extends AbstractOverTimeGraphConsumer {
    private static final String RECEIVED_BYTES_SERIES_LABEL = "Bytes received per second";
    private static final String SENT_BYTES_SERIES_LABEL = "Bytes sent per second";

    @Override
    protected TimeStampKeysSelector createTimeStampKeysSelector() {
        TimeStampKeysSelector keysSelector = new TimeStampKeysSelector();
        keysSelector.setSelectBeginTime(false);
        return keysSelector;
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        AbstractSeriesSelector seriesSelector = new AbstractSeriesSelector(){
            private final Iterable<String> values = Arrays.asList("Bytes received per second", "Bytes sent per second");

            @Override
            public Iterable<String> select(Sample sample) {
                return this.values;
            }
        };
        GraphValueSelector graphValueSelector = (series, sample) -> {
            if (sample.isController()) {
                return null;
            }
            return RECEIVED_BYTES_SERIES_LABEL.equals(series) ? sample.getReceivedBytes() : sample.getSentBytes();
        };
        return Collections.singletonMap("Generic group", new GroupInfo(new TimeRateAggregatorFactory(), seriesSelector, graphValueSelector, false, false));
    }

    @Override
    public void setGranularity(long granularity) {
        super.setGranularity(granularity);
    }

    @Override
    public void initialize() {
        super.initialize();
        ((TimeRateAggregatorFactory)this.getGroupInfos().get("Generic group").getAggregatorFactory()).setGranularity(this.getGranularity());
    }
}

