/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jorphan.util.JOrphanUtils;

public class JMeterCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 241L;
    private static final int DEFAULT_LENGTH = 15;
    private static final String BLANK = StringUtils.repeat((char)' ', (int)15);
    private static final Border RED_BORDER = BorderFactory.createLineBorder(Color.red);
    private static final Border BLUE_BORDER = BorderFactory.createLineBorder(Color.blue);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean p_hasFocus) {
        JMeterTreeNode node = (JMeterTreeNode)value;
        super.getTreeCellRendererComponent(tree, JOrphanUtils.isBlank((String)node.getName()) ? BLANK : node.getName(), sel, expanded, leaf, row, p_hasFocus);
        boolean enabled = node.isEnabled();
        ImageIcon ic = node.getIcon(enabled);
        if (ic != null) {
            if (enabled) {
                this.setIcon(ic);
            } else {
                this.setDisabledIcon(ic);
            }
        } else if (!enabled && (ic = node.getIcon()) != null) {
            this.setDisabledIcon(ic);
        }
        this.setEnabled(enabled);
        if (node.isMarkedBySearch()) {
            this.setBorder(RED_BORDER);
        } else if (node.isChildrenMarkedBySearch()) {
            this.setBorder(BLUE_BORDER);
        } else {
            this.setBorder(null);
        }
        return this;
    }
}

