/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui.ui;

import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.UndoManager;

class DefaultUndoManager
extends UndoManager {
    private final AtomicInteger undoEpoch;
    private int ourUndoEpoch;

    DefaultUndoManager(AtomicInteger undoEpoch) {
        this.undoEpoch = undoEpoch;
        this.ourUndoEpoch = undoEpoch.get();
    }

    @Override
    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.ourUndoEpoch = this.undoEpoch.get();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        int epoch = this.undoEpoch.get();
        if (this.ourUndoEpoch != epoch) {
            this.discardAllEdits();
        }
        super.undoableEditHappened(e);
    }

    @Override
    public synchronized boolean canUndo() {
        return this.ourUndoEpoch == this.undoEpoch.get() && super.canUndo();
    }

    @Override
    public synchronized boolean canRedo() {
        return this.ourUndoEpoch == this.undoEpoch.get() && super.canRedo();
    }
}

