/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.interact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.event.MouseEvent;
import jetbrains.datalore.base.event.MouseEventSpec;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.event.EventHandlerExtKt;
import jetbrains.datalore.base.registration.CompositeRegistration;
import jetbrains.datalore.base.registration.Disposable;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.plot.base.interact.GeomTarget;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.builder.event.MouseEventPeer;
import jetbrains.datalore.plot.builder.interact.PlotTooltipBounds;
import jetbrains.datalore.plot.builder.interact.TooltipSpec;
import jetbrains.datalore.plot.builder.interact.TooltipSpecFactory;
import jetbrains.datalore.plot.builder.interact.loc.LocatedTargetsPicker;
import jetbrains.datalore.plot.builder.interact.loc.TransformedTargetLocator;
import jetbrains.datalore.plot.builder.presentation.Defaults;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import jetbrains.datalore.plot.builder.tooltip.CrosshairComponent;
import jetbrains.datalore.plot.builder.tooltip.TooltipBox;
import jetbrains.datalore.plot.builder.tooltip.layout.LayoutManager;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgGraphicsElement;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001;B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ$\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)J\b\u0010+\u001a\u00020#H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001f0)2\u0006\u0010-\u001a\u00020\u0007H\u0002J$\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001f0)2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0)2\u0006\u00100\u001a\u00020\u0007H\u0002J\b\u00101\u001a\u00020#H\u0016J\u0012\u00102\u001a\u0004\u0018\u00010\u00122\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010'2\u0006\u0010-\u001a\u00020\u0007H\u0002J\b\u00104\u001a\u00020#H\u0002J\u001e\u00105\u001a\u00020#2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001a0)2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u00107\u001a\u00020#2\u0006\u00108\u001a\u00020\u0007H\u0002J\f\u00109\u001a\u00020\u0005*\u00020:H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0018\u001a\u00020\u0019*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006<"}, d2={"Ljetbrains/datalore/plot/builder/interact/TooltipRenderer;", "Ljetbrains/datalore/base/registration/Disposable;", "decorationLayer", "Ljetbrains/datalore/vis/svg/SvgNode;", "flippedAxis", "", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "xAxisTheme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "yAxisTheme", "mouseEventPeer", "Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "(Ljetbrains/datalore/vis/svg/SvgNode;ZLjetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/theme/AxisTheme;Ljetbrains/datalore/plot/builder/theme/AxisTheme;Ljetbrains/datalore/plot/builder/event/MouseEventPeer;)V", "myLayoutManager", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager;", "myTileInfos", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/builder/interact/TooltipRenderer$TileInfo;", "Lkotlin/collections/ArrayList;", "myTooltipLayer", "Ljetbrains/datalore/vis/svg/SvgGElement;", "regs", "Ljetbrains/datalore/base/registration/CompositeRegistration;", "orientation", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;", "getOrientation", "(Ljetbrains/datalore/plot/builder/tooltip/layout/LayoutManager$PositionedTooltip;)Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "style", "", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec;", "getStyle", "(Ljetbrains/datalore/plot/builder/interact/TooltipSpec;)Ljava/lang/String;", "addTileInfo", "", "geomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "tooltipBounds", "Ljetbrains/datalore/plot/builder/interact/PlotTooltipBounds;", "targetLocators", "", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "clearTooltips", "createTooltipSpecs", "plotCoord", "lookupResults", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupResult;", "axisOrigin", "dispose", "findTileInfo", "getTooltipBounds", "hideTooltip", "showCrosshair", "tooltips", "showTooltips", "cursor", "isReadableOnWhite", "Ljetbrains/datalore/base/values/Color;", "TileInfo", "plot-builder"})
public final class TooltipRenderer
implements Disposable {
    private final boolean flippedAxis;
    @NotNull
    private final AxisTheme xAxisTheme;
    @NotNull
    private final AxisTheme yAxisTheme;
    @NotNull
    private final CompositeRegistration regs;
    @NotNull
    private final LayoutManager myLayoutManager;
    @NotNull
    private final SvgGElement myTooltipLayer;
    @NotNull
    private final ArrayList<TileInfo> myTileInfos;

    /*
     * WARNING - void declaration
     */
    public TooltipRenderer(@NotNull SvgNode decorationLayer, boolean flippedAxis, @NotNull DoubleVector plotSize2, @NotNull AxisTheme xAxisTheme, @NotNull AxisTheme yAxisTheme, @NotNull MouseEventPeer mouseEventPeer) {
        void it;
        Intrinsics.checkNotNullParameter((Object)decorationLayer, (String)"decorationLayer");
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)xAxisTheme, (String)"xAxisTheme");
        Intrinsics.checkNotNullParameter((Object)yAxisTheme, (String)"yAxisTheme");
        Intrinsics.checkNotNullParameter((Object)mouseEventPeer, (String)"mouseEventPeer");
        this.flippedAxis = flippedAxis;
        this.xAxisTheme = xAxisTheme;
        this.yAxisTheme = yAxisTheme;
        this.regs = new CompositeRegistration(new Registration[0]);
        this.myTileInfos = new ArrayList();
        DoubleRectangle viewport = new DoubleRectangle(DoubleVector.Companion.getZERO(), plotSize2);
        this.myLayoutManager = new LayoutManager(viewport, LayoutManager.HorizontalAlignment.LEFT);
        SvgGElement svgGElement = new SvgGElement();
        boolean bl = false;
        boolean bl2 = false;
        SvgGElement svgGElement2 = svgGElement;
        TooltipRenderer tooltipRenderer = this;
        boolean bl3 = false;
        decorationLayer.children().add(it);
        Unit unit = Unit.INSTANCE;
        tooltipRenderer.myTooltipLayer = svgGElement;
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_MOVED, EventHandlerExtKt.handler((Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.showTooltips(it.getLocation().toDoubleVector());
            }
        })));
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_DRAGGED, EventHandlerExtKt.handler((Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.hideTooltip();
            }
        })));
        this.regs.add(mouseEventPeer.addEventHandler(MouseEventSpec.MOUSE_LEFT, EventHandlerExtKt.handler((Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.hideTooltip();
            }
        })));
    }

    @Override
    public void dispose() {
        this.myTileInfos.clear();
        this.regs.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private final void showTooltips(DoubleVector cursor) {
        void $this$mapTo$iv$iv;
        Object object;
        boolean bl;
        boolean bl2;
        Collection collection;
        void $this$mapTo$iv$iv22322;
        Iterable<LayoutManager.PositionedTooltip> $this$map$iv;
        Object object2;
        TooltipSpec spec;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<TooltipSpec> tooltipSpecs = this.createTooltipSpecs(cursor);
        PlotTooltipBounds tooltipBounds = this.getTooltipBounds(cursor);
        this.clearTooltips();
        Iterable iterable = tooltipSpecs;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            spec = (TooltipSpec)t;
            boolean bl3 = false;
            object2 = spec.getLines();
            boolean bl4 = false;
            boolean bl5 = !object2.isEmpty();
            if (!bl5) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv22322) {
            Color color;
            Object it;
            Color color2;
            Color color3;
            void spec2;
            spec = (TooltipSpec)t;
            collection = destination$iv$iv;
            bl2 = false;
            Color fillColor = spec2.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP ? this.xAxisTheme.tooltipFill() : (spec2.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP ? this.yAxisTheme.tooltipFill() : (spec2.isOutlier() ? Colors.INSTANCE.mimicTransparency(spec2.getFill(), (double)spec2.getFill().getAlpha() / 255.0, Color.Companion.getWHITE()) : Color.Companion.getWHITE()));
            if (spec2.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP) {
                color3 = this.xAxisTheme.tooltipTextColor();
            } else if (spec2.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP) {
                color3 = this.yAxisTheme.tooltipTextColor();
            } else if (spec2.isOutlier()) {
                color2 = Defaults.Common.Tooltip.INSTANCE.getLIGHT_TEXT_COLOR();
                bl = false;
                boolean bl6 = false;
                it = color2;
                boolean bl7 = false;
                Color color4 = color = this.isReadableOnWhite(fillColor) ? color2 : null;
                color3 = color == null ? Defaults.Common.Tooltip.INSTANCE.getDARK_TEXT_COLOR() : color;
            } else {
                color2 = spec2.getFill();
                bl = false;
                boolean bl7 = false;
                it = color2;
                boolean bl9 = false;
                Color color5 = color = this.isReadableOnWhite((Color)it) ? color2 : null;
                if (color == null) {
                    Color color6 = Colors.darker$default(Colors.INSTANCE, spec2.getFill(), 0.0, 2, null);
                    color3 = color6;
                    Intrinsics.checkNotNull((Object)color6);
                } else {
                    color3 = color;
                }
            }
            Color textColor2 = color3;
            Color borderColor = spec2.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP ? this.xAxisTheme.tooltipColor() : (spec2.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP ? this.yAxisTheme.tooltipColor() : textColor2);
            double strokeWidth = spec2.getLayoutHint().getKind() == TipLayoutHint.Kind.X_AXIS_TOOLTIP ? this.xAxisTheme.tooltipStrokeWidth() : (spec2.getLayoutHint().getKind() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP ? this.yAxisTheme.tooltipStrokeWidth() : 1.0);
            it = new TooltipBox();
            boolean bl8 = false;
            boolean bl9 = false;
            Object $this$showTooltips_u24lambda_u2d5_u24lambda_u2d4 = it;
            boolean bl12 = false;
            ((SvgComponent)$this$showTooltips_u24lambda_u2d5_u24lambda_u2d4).getRootGroup().visibility().set(SvgGraphicsElement.Visibility.HIDDEN);
            this.myTooltipLayer.children().add(((SvgComponent)$this$showTooltips_u24lambda_u2d5_u24lambda_u2d4).getRootGroup());
            Object tooltipBox = it;
            ((TooltipBox)tooltipBox).update(fillColor, textColor2, borderColor, strokeWidth, spec2.getLines(), this.getStyle((TooltipSpec)spec2), spec2.getLayoutHint().getKind() == TipLayoutHint.Kind.ROTATED_TOOLTIP, spec2.getMinWidth());
            object = new LayoutManager.MeasuredTooltip((TooltipSpec)spec2, (TooltipBox)tooltipBox);
            collection.add(object);
        }
        $this$map$iv = (List<LayoutManager.PositionedTooltip>)destination$iv$iv;
        $i$f$map = false;
        boolean $this$mapTo$iv$iv22322 = false;
        List<LayoutManager.PositionedTooltip> $this$showTooltips_u24lambda_u2d6 = $this$map$iv;
        boolean bl13 = false;
        $this$map$iv = this.myLayoutManager.arrange((List<LayoutManager.MeasuredTooltip>)$this$showTooltips_u24lambda_u2d6, cursor, tooltipBounds);
        $i$f$map = false;
        $this$mapTo$iv$iv22322 = false;
        List<LayoutManager.PositionedTooltip> tooltips = $this$map$iv;
        boolean bl14 = false;
        PlotTooltipBounds plotTooltipBounds = tooltipBounds;
        if (plotTooltipBounds != null) {
            Iterator iterator2 = plotTooltipBounds;
            boolean spec2 = false;
            bl2 = false;
            Iterator it = iterator2;
            boolean bl15 = false;
            this.showCrosshair(tooltips, ((PlotTooltipBounds)((Object)it)).getHandlingArea());
        }
        $this$map$iv = $this$map$iv;
        $i$f$map = false;
        Iterable<LayoutManager.PositionedTooltip> $this$mapTo$iv$iv22322 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            void arranged;
            LayoutManager.PositionedTooltip spec2 = (LayoutManager.PositionedTooltip)t;
            collection = destination$iv$iv;
            boolean bl16 = false;
            object2 = arranged.getTooltipBox();
            boolean bl10 = false;
            bl = false;
            Object $this$showTooltips_u24lambda_u2d10_u24lambda_u2d9 = object2;
            boolean bl18 = false;
            ((TooltipBox)$this$showTooltips_u24lambda_u2d10_u24lambda_u2d9).setPosition$plot_builder(arranged.getTooltipCoord(), arranged.getStemCoord(), this.getOrientation((LayoutManager.PositionedTooltip)arranged));
            ((SvgComponent)$this$showTooltips_u24lambda_u2d10_u24lambda_u2d9).getRootGroup().visibility().set(SvgGraphicsElement.Visibility.VISIBLE);
            object = object2;
            collection.add(object);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    private final void hideTooltip() {
        this.clearTooltips();
    }

    private final void clearTooltips() {
        this.myTooltipLayer.children().clear();
    }

    /*
     * WARNING - void declaration
     */
    private final void showCrosshair(List<LayoutManager.PositionedTooltip> tooltips, DoubleRectangle geomBounds) {
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        boolean showHorizontal;
        Iterable $this$any$iv;
        boolean showVertical;
        Object element$iv2;
        block11: {
            boolean bl;
            boolean bl2;
            block10: {
                Iterable $this$any$iv2 = tooltips;
                boolean $i$f$any = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv2) {
                        LayoutManager.PositionedTooltip it = (LayoutManager.PositionedTooltip)element$iv2;
                        boolean bl3 = false;
                        if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.X_AXIS_TOOLTIP)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            showVertical = bl2;
            $this$any$iv = tooltips;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    LayoutManager.PositionedTooltip it = (LayoutManager.PositionedTooltip)element$iv3;
                    boolean bl4 = false;
                    if (!(it.getHintKind$plot_builder() == TipLayoutHint.Kind.Y_AXIS_TOOLTIP)) continue;
                    bl = true;
                    break block11;
                }
                bl = showHorizontal = false;
            }
        }
        if (!showVertical && !showHorizontal) {
            return;
        }
        $this$any$iv = tooltips;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LayoutManager.PositionedTooltip tooltip = (LayoutManager.PositionedTooltip)element$iv$iv;
            boolean bl = false;
            if (!tooltip.getTooltipSpec().isCrosshairEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DoubleVector doubleVector;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            LayoutManager.PositionedTooltip tooltip = (LayoutManager.PositionedTooltip)element$iv$iv;
            boolean bl5 = false;
            if (tooltip.getTooltipSpec().getLayoutHint().getCoord() == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            DoubleVector it$iv$iv = doubleVector;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv) {
            DoubleVector coord = (DoubleVector)element$iv3;
            boolean bl = false;
            CrosshairComponent crosshairComponent = new CrosshairComponent(coord, geomBounds, showHorizontal, showVertical);
            boolean bl9 = false;
            boolean bl10 = false;
            CrosshairComponent $this$showCrosshair_u24lambda_u2d16_u24lambda_u2d15 = crosshairComponent;
            boolean bl11 = false;
            this.myTooltipLayer.children().add(0, $this$showCrosshair_u24lambda_u2d16_u24lambda_u2d15.getRootGroup());
        }
    }

    public final void addTileInfo(@NotNull DoubleRectangle geomBounds, @NotNull PlotTooltipBounds tooltipBounds, @NotNull List<? extends GeomTargetLocator> targetLocators) {
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter((Object)tooltipBounds, (String)"tooltipBounds");
        Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
        TileInfo tileInfo = new TileInfo(geomBounds, tooltipBounds, targetLocators, this.flippedAxis);
        this.myTileInfos.add(tileInfo);
    }

    private final List<TooltipSpec> createTooltipSpecs(DoubleVector plotCoord) {
        TileInfo tileInfo = this.findTileInfo(plotCoord);
        if (tileInfo == null) {
            return CollectionsKt.emptyList();
        }
        TileInfo tileInfo2 = tileInfo;
        List<GeomTargetLocator.LookupResult> lookupResults = tileInfo2.findTargets$plot_builder(plotCoord);
        return this.createTooltipSpecs(lookupResults, tileInfo2.getAxisOrigin$plot_builder());
    }

    private final PlotTooltipBounds getTooltipBounds(DoubleVector plotCoord) {
        TileInfo tileInfo = this.findTileInfo(plotCoord);
        if (tileInfo == null) {
            return null;
        }
        TileInfo tileInfo2 = tileInfo;
        return tileInfo2.getTooltipBounds();
    }

    private final TileInfo findTileInfo(DoubleVector plotCoord) {
        for (TileInfo tileInfo : this.myTileInfos) {
            if (!tileInfo.contains$plot_builder(plotCoord)) continue;
            return tileInfo;
        }
        return null;
    }

    private final List<TooltipSpec> createTooltipSpecs(List<? extends GeomTargetLocator.LookupResult> lookupResults, DoubleVector axisOrigin) {
        ArrayList tooltipSpecs = new ArrayList();
        Iterable $this$forEach$iv = lookupResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GeomTargetLocator.LookupResult result = (GeomTargetLocator.LookupResult)element$iv;
            boolean bl = false;
            TooltipSpecFactory factory = new TooltipSpecFactory(result.getContextualMapping(), axisOrigin, this.flippedAxis, this.xAxisTheme, this.yAxisTheme);
            Iterable $this$forEach$iv2 = result.getTargets();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                GeomTarget geomTarget = (GeomTarget)element$iv2;
                boolean bl2 = false;
                tooltipSpecs.addAll(factory.create(geomTarget));
            }
        }
        return tooltipSpecs;
    }

    private final boolean isReadableOnWhite(Color $this$isReadableOnWhite) {
        return Colors.INSTANCE.luminance($this$isReadableOnWhite) < 0.5;
    }

    private final String getStyle(TooltipSpec $this$style) {
        String string;
        TipLayoutHint.Kind kind = $this$style.getLayoutHint().getKind();
        int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
        switch (n) {
            case 1: {
                string = "plt-axis-tooltip";
                break;
            }
            case 2: {
                string = "plt-axis-tooltip";
                break;
            }
            case 3: {
                string = "plt-data-tooltip";
                break;
            }
            case 4: {
                string = "plt-data-tooltip";
                break;
            }
            case 5: {
                string = "plt-data-tooltip";
                break;
            }
            case 6: {
                string = "plt-data-tooltip";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final TooltipBox.Orientation getOrientation(LayoutManager.PositionedTooltip $this$orientation) {
        TooltipBox.Orientation orientation;
        TipLayoutHint.Kind kind = $this$orientation.getHintKind$plot_builder();
        int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
        switch (n) {
            case 4: {
                orientation = TooltipBox.Orientation.HORIZONTAL;
                break;
            }
            case 2: {
                orientation = TooltipBox.Orientation.HORIZONTAL;
                break;
            }
            case 3: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            case 5: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            case 1: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            case 6: {
                orientation = TooltipBox.Orientation.VERTICAL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return orientation;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\rH\u0080\u0002\u00a2\u0006\u0002\b\u0018J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00072\u0006\u0010\u0017\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001bR\u0014\u0010\f\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Ljetbrains/datalore/plot/builder/interact/TooltipRenderer$TileInfo;", "", "geomBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "tooltipBounds", "Ljetbrains/datalore/plot/builder/interact/PlotTooltipBounds;", "targetLocators", "", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "flippedAxis", "", "(Ljetbrains/datalore/base/geometry/DoubleRectangle;Ljetbrains/datalore/plot/builder/interact/PlotTooltipBounds;Ljava/util/List;Z)V", "axisOrigin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getAxisOrigin$plot_builder", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getGeomBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "myTargetLocators", "Ljetbrains/datalore/plot/builder/interact/loc/TransformedTargetLocator;", "getTooltipBounds", "()Ljetbrains/datalore/plot/builder/interact/PlotTooltipBounds;", "contains", "plotCoord", "contains$plot_builder", "findTargets", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupResult;", "findTargets$plot_builder", "FlippedTileTargetLocator", "TileTargetLocator", "plot-builder"})
    private static final class TileInfo {
        @NotNull
        private final DoubleRectangle geomBounds;
        @NotNull
        private final PlotTooltipBounds tooltipBounds;
        private final boolean flippedAxis;
        @NotNull
        private final List<TransformedTargetLocator> myTargetLocators;

        /*
         * WARNING - void declaration
         */
        public TileInfo(@NotNull DoubleRectangle geomBounds, @NotNull PlotTooltipBounds tooltipBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, boolean flippedAxis) {
            Collection<TransformedTargetLocator> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
            Intrinsics.checkNotNullParameter((Object)tooltipBounds, (String)"tooltipBounds");
            Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
            this.geomBounds = geomBounds;
            this.tooltipBounds = tooltipBounds;
            this.flippedAxis = flippedAxis;
            Iterable iterable = targetLocators;
            TileInfo tileInfo = this;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GeomTargetLocator geomTargetLocator = (GeomTargetLocator)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                TransformedTargetLocator transformedTargetLocator = this.flippedAxis ? (TransformedTargetLocator)new FlippedTileTargetLocator((GeomTargetLocator)it) : (TransformedTargetLocator)new TileTargetLocator((GeomTargetLocator)it);
                collection.add(transformedTargetLocator);
            }
            collection = (List)destination$iv$iv;
            tileInfo.myTargetLocators = collection;
        }

        @NotNull
        public final DoubleRectangle getGeomBounds() {
            return this.geomBounds;
        }

        @NotNull
        public final PlotTooltipBounds getTooltipBounds() {
            return this.tooltipBounds;
        }

        @NotNull
        public final DoubleVector getAxisOrigin$plot_builder() {
            return new DoubleVector(this.geomBounds.getLeft(), this.geomBounds.getBottom());
        }

        @NotNull
        public final List<GeomTargetLocator.LookupResult> findTargets$plot_builder(@NotNull DoubleVector plotCoord) {
            Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
            LocatedTargetsPicker locatedTargetsPicker = new LocatedTargetsPicker(this.flippedAxis);
            boolean bl = false;
            boolean bl2 = false;
            LocatedTargetsPicker $this$findTargets_u24lambda_u2d1 = locatedTargetsPicker;
            boolean bl3 = false;
            for (TransformedTargetLocator locator : this.myTargetLocators) {
                GeomTargetLocator.LookupResult result = locator.search(plotCoord);
                if (result == null) continue;
                $this$findTargets_u24lambda_u2d1.addLookupResult(result, plotCoord);
            }
            LocatedTargetsPicker targetsPicker = locatedTargetsPicker;
            return targetsPicker.getPicked();
        }

        public final boolean contains$plot_builder(@NotNull DoubleVector plotCoord) {
            Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
            return this.geomBounds.contains(plotCoord);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/builder/interact/TooltipRenderer$TileInfo$TileTargetLocator;", "Ljetbrains/datalore/plot/builder/interact/loc/TransformedTargetLocator;", "locator", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "(Ljetbrains/datalore/plot/builder/interact/TooltipRenderer$TileInfo;Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;)V", "convertToPlotCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "coord", "convertToPlotDistance", "", "distance", "convertToTargetCoord", "plot-builder"})
        private final class TileTargetLocator
        extends TransformedTargetLocator {
            public TileTargetLocator(GeomTargetLocator locator) {
                Intrinsics.checkNotNullParameter((Object)TileInfo.this, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
                super(locator);
            }

            @Override
            @NotNull
            protected DoubleVector convertToTargetCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.subtract(TileInfo.this.getGeomBounds().getOrigin());
            }

            @Override
            @NotNull
            protected DoubleVector convertToPlotCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.add(TileInfo.this.getGeomBounds().getOrigin());
            }

            @Override
            protected double convertToPlotDistance(double distance) {
                return distance;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0014\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/builder/interact/TooltipRenderer$TileInfo$FlippedTileTargetLocator;", "Ljetbrains/datalore/plot/builder/interact/loc/TransformedTargetLocator;", "locator", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "(Ljetbrains/datalore/plot/builder/interact/TooltipRenderer$TileInfo;Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;)V", "convertToPlotCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "coord", "convertToPlotDistance", "", "distance", "convertToTargetCoord", "plot-builder"})
        private final class FlippedTileTargetLocator
        extends TransformedTargetLocator {
            public FlippedTileTargetLocator(GeomTargetLocator locator) {
                Intrinsics.checkNotNullParameter((Object)TileInfo.this, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
                super(locator);
            }

            @Override
            @NotNull
            protected DoubleVector convertToTargetCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.subtract(TileInfo.this.getGeomBounds().getOrigin()).flip();
            }

            @Override
            @NotNull
            protected DoubleVector convertToPlotCoord(@NotNull DoubleVector coord) {
                Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
                return coord.flip().add(TileInfo.this.getGeomBounds().getOrigin());
            }

            @Override
            protected double convertToPlotDistance(double distance) {
                return distance;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TipLayoutHint.Kind.values().length];
            nArray[TipLayoutHint.Kind.X_AXIS_TOOLTIP.ordinal()] = 1;
            nArray[TipLayoutHint.Kind.Y_AXIS_TOOLTIP.ordinal()] = 2;
            nArray[TipLayoutHint.Kind.VERTICAL_TOOLTIP.ordinal()] = 3;
            nArray[TipLayoutHint.Kind.HORIZONTAL_TOOLTIP.ordinal()] = 4;
            nArray[TipLayoutHint.Kind.CURSOR_TOOLTIP.ordinal()] = 5;
            nArray[TipLayoutHint.Kind.ROTATED_TOOLTIP.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

