/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.MathArrays;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunction;
import jetbrains.datalore.plot.base.stat.math3.PolynomialSplineFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/SplineInterpolator;", "", "()V", "interpolate", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialSplineFunction;", "x", "", "y", "plot-base-portable"})
public final class SplineInterpolator {
    @NotNull
    public final PolynomialSplineFunction interpolate(@NotNull double[] x2, @NotNull double[] y2) {
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y2, (String)"y");
        if (x2.length != y2.length) {
            String string = "Dimension mismatch " + x2.length + " != " + y2.length;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (x2.length < 3) {
            String string = "Too small value of points number: " + x2.length + " < 3";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int n = x2.length - 1;
        MathArrays.INSTANCE.checkOrder(x2);
        double[] h = new double[n];
        int n2 = 0;
        if (n2 < n) {
            do {
                int i = n2++;
                h[i] = x2[i + 1] - x2[i];
            } while (n2 < n);
        }
        double[] mu = new double[n];
        double[] z = new double[n + 1];
        mu[0] = 0.0;
        z[0] = 0.0;
        int n3 = 1;
        if (n3 < n) {
            do {
                int i = n3++;
                double g = 2.0 * (x2[i + 1] - x2[i - 1]) - h[i - 1] * mu[i - 1];
                mu[i] = h[i] / g;
                z[i] = (3.0 * (y2[i + 1] * h[i - 1] - y2[i] * (x2[i + 1] - x2[i - 1]) + y2[i - 1] * h[i]) / (h[i - 1] * h[i]) - h[i - 1] * z[i - 1]) / g;
            } while (n3 < n);
        }
        double[] b = new double[n];
        double[] c = new double[n + 1];
        double[] d = new double[n];
        z[n] = 0.0;
        c[n] = 0.0;
        int n4 = n - 1;
        if (0 <= n4) {
            do {
                int j = n4--;
                c[j] = z[j] - mu[j] * c[j + 1];
                b[j] = (y2[j + 1] - y2[j]) / h[j] - h[j] * (c[j + 1] + 2.0 * c[j]) / 3.0;
                d[j] = (c[j + 1] - c[j]) / (3.0 * h[j]);
            } while (0 <= n4);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[4];
        int n5 = 0;
        if (n5 < n) {
            do {
                int i = n5++;
                coefficients[0] = y2[i];
                coefficients[1] = b[i];
                coefficients[2] = c[i];
                coefficients[3] = d[i];
                polynomials[i] = new PolynomialFunction(coefficients);
            } while (n5 < n);
        }
        return new PolynomialSplineFunction(x2, polynomials);
    }
}

