/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.base.util.MutableDouble;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0019\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJJ\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\bJ\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000e2\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStatUtil;", "", "()V", "MAX_BIN_COUNT", "", "binCountAndWidth", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$CountAndWidth;", "dataRange", "", "binOptions", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "computeBins", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinsData;", "valuesX", "", "startX", "binCount", "binWidth", "weightAtIndex", "Lkotlin/Function1;", "densityNormalizingFactor", "data", "Ljetbrains/datalore/plot/base/DataFrame;", "weightVector", "dataLength", "BinOptions", "BinsData", "CountAndWidth", "plot-base-portable"})
public final class BinStatUtil {
    @NotNull
    public static final BinStatUtil INSTANCE = new BinStatUtil();
    private static final int MAX_BIN_COUNT = 500;

    private BinStatUtil() {
    }

    @NotNull
    public final Function1<Integer, Double> weightAtIndex(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(TransformVar.INSTANCE.getWEIGHT())) {
            List<Double> weights = data.getNumeric(TransformVar.INSTANCE.getWEIGHT());
            return (Function1)new Function1<Integer, Double>(weights){
                final /* synthetic */ List<Double> $weights;
                {
                    this.$weights = $weights;
                    super(1);
                }

                @NotNull
                public final Double invoke(int index) {
                    Double weight = this.$weights.get(index);
                    return SeriesUtil.INSTANCE.asFinite(weight, 0.0);
                }
            };
        }
        return weightAtIndex.2.INSTANCE;
    }

    @NotNull
    public final List<Double> weightVector(int dataLength, @NotNull DataFrame data) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(TransformVar.INSTANCE.getWEIGHT())) {
            list2 = data.getNumeric(TransformVar.INSTANCE.getWEIGHT());
        } else {
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<Double> arrayList = new ArrayList<Double>(dataLength);
            boolean bl3 = false;
            int n = 0;
            n = 0;
            int n2 = dataLength;
            while (n < n2) {
                int n3 = n++;
                boolean bl4 = false;
                int n4 = n3;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl5 = false;
                Double d = 1.0;
                arrayList2.add(d);
            }
            list2 = arrayList;
        }
        return list2;
    }

    @NotNull
    public final CountAndWidth binCountAndWidth(double dataRange, @NotNull BinOptions binOptions) {
        Intrinsics.checkNotNullParameter((Object)binOptions, (String)"binOptions");
        int binCount = binOptions.getBinCount();
        double binWidth = 0.0;
        if (binOptions.hasBinWidth()) {
            Double d = binOptions.getBinWidth();
            Intrinsics.checkNotNull((Object)d);
            binWidth = d;
            double count2 = dataRange / binWidth;
            double d2 = 500.0;
            boolean bl = false;
            count2 = Math.min(d2, count2);
            boolean bl2 = false;
            binCount = (int)Math.ceil(count2);
        } else {
            binWidth = dataRange / (double)binCount;
        }
        return new CountAndWidth(binCount, binWidth);
    }

    @NotNull
    public final BinsData computeBins(@NotNull List<Double> valuesX, double startX, int binCount, double binWidth, @NotNull Function1<? super Integer, Double> weightAtIndex2, double densityNormalizingFactor) {
        Intrinsics.checkNotNullParameter(valuesX, (String)"valuesX");
        Intrinsics.checkNotNullParameter(weightAtIndex2, (String)"weightAtIndex");
        double totalCount = 0.0;
        HashMap countByBinIndex = new HashMap();
        int n = 0;
        int n2 = valuesX.size() + -1;
        if (n <= n2) {
            do {
                int dataIndex;
                Double x2;
                if (!SeriesUtil.INSTANCE.isFinite(x2 = valuesX.get(dataIndex = n++))) continue;
                double weight = ((Number)weightAtIndex2.invoke((Object)dataIndex)).doubleValue();
                totalCount += weight;
                Double d = x2;
                Intrinsics.checkNotNull((Object)d);
                double d2 = (d - startX) / binWidth;
                boolean bl = false;
                int binIndex = (int)Math.floor(d2);
                if (!countByBinIndex.containsKey(binIndex)) {
                    Map map2 = countByBinIndex;
                    Integer n3 = binIndex;
                    MutableDouble mutableDouble = new MutableDouble(0.0);
                    boolean bl2 = false;
                    map2.put(n3, mutableDouble);
                }
                Object v = countByBinIndex.get(binIndex);
                Intrinsics.checkNotNull(v);
                ((MutableDouble)v).getAndAdd(weight);
            } while (n <= n2);
        }
        ArrayList<Double> x3 = new ArrayList<Double>();
        ArrayList<Double> counts = new ArrayList<Double>();
        ArrayList<Double> densities = new ArrayList<Double>();
        double x0 = startX + binWidth / (double)2;
        int n4 = 0;
        if (n4 < binCount) {
            do {
                int i = n4++;
                x3.add(x0 + (double)i * binWidth);
                double count2 = 0.0;
                if (countByBinIndex.containsKey(i)) {
                    Object v = countByBinIndex.get(i);
                    Intrinsics.checkNotNull(v);
                    count2 = ((MutableDouble)v).get();
                }
                counts.add(count2);
                double density2 = count2 / totalCount * densityNormalizingFactor;
                densities.add(density2);
            } while (n4 < binCount);
        }
        return new BinsData((List<Double>)x3, (List<Double>)counts, (List<Double>)densities);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "", "binCount", "", "binWidth", "", "(ILjava/lang/Double;)V", "getBinCount", "()I", "getBinWidth", "()Ljava/lang/Double;", "Ljava/lang/Double;", "hasBinWidth", "", "plot-base-portable"})
    public static final class BinOptions {
        @Nullable
        private final Double binWidth;
        private final int binCount;

        public BinOptions(int binCount, @Nullable Double binWidth) {
            this.binWidth = binWidth;
            int n = 500;
            int n2 = 1;
            boolean bl = false;
            n2 = Math.max(n2, binCount);
            bl = false;
            this.binCount = Math.min(n, n2);
        }

        @Nullable
        public final Double getBinWidth() {
            return this.binWidth;
        }

        public final int getBinCount() {
            return this.binCount;
        }

        public final boolean hasBinWidth() {
            return this.binWidth != null && this.binWidth > 0.0;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStatUtil$CountAndWidth;", "", "count", "", "width", "", "(ID)V", "getCount", "()I", "getWidth", "()D", "plot-base-portable"})
    public static final class CountAndWidth {
        private final int count;
        private final double width;

        public CountAndWidth(int count2, double width2) {
            this.count = count2;
            this.width = width2;
        }

        public final int getCount() {
            return this.count;
        }

        public final double getWidth() {
            return this.width;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinsData;", "", "x", "", "", "count", "density", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getCount$plot_base_portable", "()Ljava/util/List;", "getDensity$plot_base_portable", "getX$plot_base_portable", "plot-base-portable"})
    public static final class BinsData {
        @NotNull
        private final List<Double> x;
        @NotNull
        private final List<Double> count;
        @NotNull
        private final List<Double> density;

        public BinsData(@NotNull List<Double> x2, @NotNull List<Double> count2, @NotNull List<Double> density2) {
            Intrinsics.checkNotNullParameter(x2, (String)"x");
            Intrinsics.checkNotNullParameter(count2, (String)"count");
            Intrinsics.checkNotNullParameter(density2, (String)"density");
            this.x = x2;
            this.count = count2;
            this.density = density2;
        }

        @NotNull
        public final List<Double> getX$plot_base_portable() {
            return this.x;
        }

        @NotNull
        public final List<Double> getCount$plot_base_portable() {
            return this.count;
        }

        @NotNull
        public final List<Double> getDensity$plot_base_portable() {
            return this.density;
        }
    }
}

