/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.pos;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.pos.PositionAdjustments;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/base/pos/JitterPos;", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "width", "", "height", "(Ljava/lang/Double;Ljava/lang/Double;)V", "myHeight", "myWidth", "handlesGroups", "", "translate", "Ljetbrains/datalore/base/geometry/DoubleVector;", "v", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "plot-base-portable"})
public final class JitterPos
implements PositionAdjustment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double myWidth;
    private final double myHeight;
    private static final double DEF_JITTER_WIDTH = 0.4;
    private static final double DEF_JITTER_HEIGHT = 0.4;

    public JitterPos(@Nullable Double width2, @Nullable Double height) {
        Double d = width2;
        this.myWidth = d == null ? DEF_JITTER_WIDTH : d;
        d = height;
        this.myHeight = d == null ? DEF_JITTER_HEIGHT : d;
    }

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        double x2 = ((double)2 * Random.Default.nextDouble() - 1.0) * this.myWidth * ctx2.getResolution(Aes.Companion.getX());
        double y2 = ((double)2 * Random.Default.nextDouble() - 1.0) * this.myHeight * ctx2.getResolution(Aes.Companion.getY());
        return v.add(new DoubleVector(x2, y2));
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.JITTER.handlesGroups();
    }

    @Override
    public boolean isIdentity() {
        return PositionAdjustment.DefaultImpls.isIdentity(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/pos/JitterPos$Companion;", "", "()V", "DEF_JITTER_HEIGHT", "", "getDEF_JITTER_HEIGHT", "()D", "DEF_JITTER_WIDTH", "getDEF_JITTER_WIDTH", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public final double getDEF_JITTER_WIDTH() {
            return DEF_JITTER_WIDTH;
        }

        public final double getDEF_JITTER_HEIGHT() {
            return DEF_JITTER_HEIGHT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

