/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import jetbrains.datalore.vis.svg.SvgPathDataBuilder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "myCenter", "Ljetbrains/datalore/base/geometry/DoubleVector;", "myRadius", "", "(Ljetbrains/datalore/base/geometry/DoubleVector;D)V", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "PieHelper", "plot-base-portable"})
public final class PieGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleVector myCenter;
    private final double myRadius;
    @NotNull
    private static final List<Aes<? extends Object>> RENDERS;
    public static final boolean HANDLES_GROUPS = false;

    public PieGeom(@NotNull DoubleVector myCenter, double myRadius) {
        Intrinsics.checkNotNullParameter((Object)myCenter, (String)"myCenter");
        this.myCenter = myCenter;
        this.myRadius = myRadius;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        PieHelper helper = new PieHelper(pos, coord, ctx2);
        List<LinePath> segments = helper.createSegments$plot_base_portable(aesthetics, this.myCenter, this.myRadius);
        GeomBase.Companion.appendNodes(segments, root);
    }

    static {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getCOLOR(), Aes.Companion.getFILL(), Aes.Companion.getALPHA(), Aes.Companion.getWIDTH(), Aes.Companion.getSIZE()};
        RENDERS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$PieHelper;", "Ljetbrains/datalore/plot/base/geom/util/LinesHelper;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "(Ljetbrains/datalore/plot/base/PositionAdjustment;Ljetbrains/datalore/plot/base/CoordinateSystem;Ljetbrains/datalore/plot/base/GeomContext;)V", "createSegments", "", "Ljetbrains/datalore/plot/base/render/svg/LinePath;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "center", "Ljetbrains/datalore/base/geometry/DoubleVector;", "radius", "", "createSegments$plot_base_portable", "plot-base-portable"})
    private static final class PieHelper
    extends LinesHelper {
        public PieHelper(@NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            super(pos, coord, ctx2);
        }

        @NotNull
        public final List<LinePath> createSegments$plot_base_portable(@NotNull Aesthetics aesthetics, @NotNull DoubleVector center, double radius) {
            Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            ArrayList<LinePath> result = new ArrayList<LinePath>();
            DoubleVector basis = new DoubleVector(0.0, -radius);
            double curAngle = Double.NaN;
            for (DataPointAesthetics p : Companion.dataPoints(aesthetics)) {
                Double d = p.y();
                Intrinsics.checkNotNull((Object)d);
                double segmentSize = Companion.shareToRad(d);
                double d2 = curAngle;
                boolean bl = false;
                if (Double.isNaN(d2)) {
                    curAngle = segmentSize;
                }
                double angle = -segmentSize;
                SvgPathDataBuilder builder = new SvgPathDataBuilder(true);
                builder.moveTo(center);
                builder.lineTo(center.add(basis.rotate(curAngle)));
                DoubleVector arcTo = center.add(basis.rotate(curAngle + angle));
                builder.ellipticalArc(radius, radius, 0.0, -angle > Math.PI, false, arcTo);
                builder.closePath();
                curAngle += angle;
                LinePath path2 = new LinePath(builder);
                this.decorate(path2, p, true);
                result.add(path2);
            }
            return result;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "RENDERS", "", "Ljetbrains/datalore/plot/base/Aes;", "getRENDERS", "()Ljava/util/List;", "allEqualX", "hasX", "", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "value", "", "(Ljava/lang/Iterable;Ljava/lang/Double;)Z", "dataPoints", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "shareToRad", "share", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Aes<? extends Object>> getRENDERS() {
            return RENDERS;
        }

        private final Iterable<DataPointAesthetics> dataPoints(Aesthetics aesthetics) {
            List<DataPointAesthetics> withX = GeomUtil.INSTANCE.with_X_Y(aesthetics.dataPoints());
            return withX.isEmpty() || this.allEqualX((Iterable<? extends DataPointAesthetics>)withX, withX.get(0).x()) ? GeomUtil.INSTANCE.ordered_Y((Iterable<? extends DataPointAesthetics>)GeomUtil.INSTANCE.with_Y(aesthetics.dataPoints()), true) : GeomUtil.INSTANCE.ordered_X((Iterable<? extends DataPointAesthetics>)withX);
        }

        private final boolean allEqualX(Iterable<? extends DataPointAesthetics> hasX, Double value) {
            for (DataPointAesthetics dataPointAesthetics : hasX) {
                if (Intrinsics.areEqual((Double)dataPointAesthetics.x(), (Double)value)) continue;
                return false;
            }
            return true;
        }

        private final double shareToRad(double share) {
            return 6.282556988648868 * share;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

