/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.geometry;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.Segment;
import jetbrains.datalore.base.geometry.Vector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\tJ\u0006\u0010\u0019\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\tJ\u0011\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\tH\u0086\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\tJ\u0013\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010$\u001a\u00020\u0003H\u0016J\u000e\u0010%\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\u000e\u0010(\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020\u0000J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\tJ\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000300J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000300R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u00062"}, d2={"Ljetbrains/datalore/base/geometry/Rectangle;", "", "x", "", "y", "width", "height", "(IIII)V", "origin", "Ljetbrains/datalore/base/geometry/Vector;", "dimension", "(Ljetbrains/datalore/base/geometry/Vector;Ljetbrains/datalore/base/geometry/Vector;)V", "boundPoints", "", "getBoundPoints", "()[Ljetbrains/datalore/base/geometry/Vector;", "boundSegments", "Ljetbrains/datalore/base/geometry/Segment;", "getBoundSegments", "()[Ljetbrains/datalore/base/geometry/Segment;", "getDimension", "()Ljetbrains/datalore/base/geometry/Vector;", "getOrigin", "add", "v", "center", "changeDimension", "dim", "contains", "", "r", "distance", "", "to", "equals", "other", "hashCode", "innerIntersects", "rect", "intersect", "intersects", "sub", "toDoubleRectangle", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "toString", "", "union", "xRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "yRange", "base-portable"})
public final class Rectangle {
    @NotNull
    private final Vector origin;
    @NotNull
    private final Vector dimension;

    public Rectangle(@NotNull Vector origin, @NotNull Vector dimension) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        this.origin = origin;
        this.dimension = dimension;
    }

    @NotNull
    public final Vector getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Vector getDimension() {
        return this.dimension;
    }

    @NotNull
    public final Segment[] getBoundSegments() {
        Vector[] p = this.getBoundPoints();
        Segment[] segmentArray = new Segment[]{new Segment(p[0], p[1]), new Segment(p[1], p[2]), new Segment(p[2], p[3]), new Segment(p[3], p[0])};
        return segmentArray;
    }

    private final Vector[] getBoundPoints() {
        Vector[] vectorArray = new Vector[]{this.origin, this.origin.add(new Vector(this.dimension.getX(), 0)), this.origin.add(this.dimension), this.origin.add(new Vector(0, this.dimension.getY()))};
        return vectorArray;
    }

    public Rectangle(int x2, int y2, int width2, int height) {
        this(new Vector(x2, y2), new Vector(width2, height));
    }

    @NotNull
    public final Rectangle add(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Rectangle(this.origin.add(v), this.dimension);
    }

    @NotNull
    public final Rectangle sub(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Rectangle(this.origin.sub(v), this.dimension);
    }

    public final boolean contains(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.origin) && this.contains(r.origin.add(r.dimension));
    }

    public final boolean contains(@NotNull Vector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.origin.getX() <= v.getX() && this.origin.getX() + this.dimension.getX() >= v.getX() && this.origin.getY() <= v.getY() && this.origin.getY() + this.dimension.getY() >= v.getY();
    }

    @NotNull
    public final Rectangle union(@NotNull Rectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        Vector newOrigin = this.origin.min(rect2.origin);
        Vector corner = this.origin.add(this.dimension);
        Vector rectCorner = rect2.origin.add(rect2.dimension);
        Vector newCorner = corner.max(rectCorner);
        Vector newDimension = newCorner.sub(newOrigin);
        return new Rectangle(newOrigin, newDimension);
    }

    public final boolean intersects(@NotNull Rectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        Vector t1 = this.origin;
        Vector t2 = this.origin.add(this.dimension);
        Vector r1 = rect2.origin;
        Vector r2 = rect2.origin.add(rect2.dimension);
        return r2.getX() >= t1.getX() && t2.getX() >= r1.getX() && r2.getY() >= t1.getY() && t2.getY() >= r1.getY();
    }

    @NotNull
    public final Rectangle intersect(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        if (!this.intersects(r)) {
            throw new IllegalStateException("rectangle [" + this + "] doesn't intersect [" + r + ']');
        }
        Vector too = this.origin.add(this.dimension);
        Vector roo = r.origin.add(r.dimension);
        Vector ioo = too.min(roo);
        Vector io = this.origin.max(r.origin);
        return new Rectangle(io, ioo.sub(io));
    }

    public final boolean innerIntersects(@NotNull Rectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        Vector t1 = this.origin;
        Vector t2 = this.origin.add(this.dimension);
        Vector r1 = rect2.origin;
        Vector r2 = rect2.origin.add(rect2.dimension);
        return r2.getX() > t1.getX() && t2.getX() > r1.getX() && r2.getY() > t1.getY() && t2.getY() > r1.getY();
    }

    @NotNull
    public final Rectangle changeDimension(@NotNull Vector dim) {
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        return new Rectangle(this.origin, dim);
    }

    public final double distance(@NotNull Vector to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.toDoubleRectangle().distance(to.toDoubleVector());
    }

    @NotNull
    public final ClosedRange<Integer> xRange() {
        return new ClosedRange<Comparable>(Integer.valueOf(this.origin.getX()), Integer.valueOf(this.origin.getX() + this.dimension.getX()));
    }

    @NotNull
    public final ClosedRange<Integer> yRange() {
        return new ClosedRange<Comparable>(Integer.valueOf(this.origin.getY()), Integer.valueOf(this.origin.getY() + this.dimension.getY()));
    }

    public int hashCode() {
        return this.origin.hashCode() * 31 + this.dimension.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Rectangle)) {
            return false;
        }
        Rectangle otherRect = (Rectangle)other;
        return Intrinsics.areEqual((Object)this.origin, (Object)otherRect.origin) && Intrinsics.areEqual((Object)this.dimension, (Object)otherRect.dimension);
    }

    private final DoubleRectangle toDoubleRectangle() {
        return new DoubleRectangle(this.origin.toDoubleVector(), this.dimension.toDoubleVector());
    }

    @NotNull
    public final Vector center() {
        return this.origin.add(new Vector(this.dimension.getX() / 2, this.dimension.getY() / 2));
    }

    @NotNull
    public String toString() {
        return this.origin + " - " + this.dimension;
    }
}

