/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.time;

import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.base.datetime.Instant;
import jetbrains.datalore.base.datetime.tz.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/common/time/TimeUtil;", "", "()V", "asDateTimeUTC", "Ljetbrains/datalore/base/datetime/DateTime;", "instant", "", "asInstantUTC", "", "dateTime", "yearStart", "year", "", "plot-common-portable"})
public final class TimeUtil {
    @NotNull
    public static final TimeUtil INSTANCE = new TimeUtil();

    private TimeUtil() {
    }

    @NotNull
    public final DateTime asDateTimeUTC(double instant) {
        try {
            return TimeZone.Companion.getUTC().toDateTime(new Instant(MathKt.roundToLong((double)instant)));
        }
        catch (RuntimeException ignored) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Can't create DateTime from instant ", (Object)instant));
        }
    }

    public final long asInstantUTC(@NotNull DateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        return TimeZone.Companion.getUTC().toInstant(dateTime).getTimeSinceEpoch();
    }

    @NotNull
    public final DateTime yearStart(int year) {
        return new DateTime(Date.Companion.firstDayOf$default((Date.Companion)Date.Companion, (int)year, null, (int)2, null), null, 2, null);
    }
}

