/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  factory(root["Bokeh"], undefined);
})(this, function(Bokeh, version) {
  var define;
  return (function(modules, entry, aliases, externals) {
    const bokeh = typeof Bokeh !== "undefined" && (version != null ? Bokeh[version] : Bokeh);
    if (bokeh != null) {
      return bokeh.register_plugin(modules, entry, aliases);
    } else {
      throw new Error("Cannot find Bokeh " + version + ". You have to load it prior to loading plugins.");
    }
  })
({
521: function _(r,t,e,i,_){i();var o=r(1).__importStar(r(522));e.Widgets=o,r(122).register_models(o)},
522: function _(t,e,o,r,u){r(),u("AbstractButton",t(523).AbstractButton),u("AbstractIcon",t(526).AbstractIcon),u("AutocompleteInput",t(527).AutocompleteInput),u("Button",t(532).Button),u("CheckboxButtonGroup",t(533).CheckboxButtonGroup),u("CheckboxGroup",t(535).CheckboxGroup),u("ColorPicker",t(537).ColorPicker),u("DatePicker",t(538).DatePicker),u("DateRangeSlider",t(541).DateRangeSlider),u("DateSlider",t(547).DateSlider),u("Div",t(548).Div),u("Dropdown",t(552).Dropdown),u("FileInput",t(553).FileInput),u("InputWidget",t(529).InputWidget),u("Markup",t(549).Markup),u("MultiSelect",t(554).MultiSelect),u("Paragraph",t(555).Paragraph),u("PasswordInput",t(556).PasswordInput),u("MultiChoice",t(557).MultiChoice),u("NumericInput",t(560).NumericInput),u("PreText",t(561).PreText),u("RadioButtonGroup",t(562).RadioButtonGroup),u("RadioGroup",t(563).RadioGroup),u("RangeSlider",t(564).RangeSlider),u("Select",t(565).Select),u("Slider",t(566).Slider),u("Spinner",t(567).Spinner),u("TextInput",t(528).TextInput),u("TextAreaInput",t(568).TextAreaInput),u("Toggle",t(569).Toggle),u("Widget",t(589).Widget)},
523: function _(t,n,e,i,o){i();var r=t(1),s=t(135),l=t(187),u=t(231),c=t(524),a=t(526),_=t(418),p=r.__importDefault(t(419)),h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(n,t),n.prototype.controls=function(){return r.__generator(this,(function(t){switch(t.label){case 0:return[4,this.button_el];case 1:return t.sent(),[2]}}))},n.prototype.lazy_initialize=function(){return r.__awaiter(this,void 0,void 0,(function(){var n,e;return r.__generator(this,(function(i){switch(i.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return i.sent(),null==(n=this.model.icon)?[3,3]:(e=this,[4,u.build_view(n,{parent:this})]);case 2:e.icon_view=i.sent(),i.label=3;case 3:return[2]}}))}))},n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return n.render()}))},n.prototype.remove=function(){null!=this.icon_view&&this.icon_view.remove(),t.prototype.remove.call(this)},n.prototype.styles=function(){return r.__spread(t.prototype.styles.call(this),[p.default])},n.prototype._render_button=function(){for(var t=[],n=0;n<arguments.length;n++)t[n]=arguments[n];return l.button.apply(void 0,r.__spread([{type:"button",disabled:this.model.disabled,class:[_.bk_btn,_.bk_btn_type(this.model.button_type)]}],t))},n.prototype.render=function(){var n=this;t.prototype.render.call(this),this.button_el=this._render_button(this.model.label),this.button_el.addEventListener("click",(function(){return n.click()})),null!=this.icon_view&&(l.prepend(this.button_el,this.icon_view.el,l.nbsp()),this.icon_view.render()),this.group_el=l.div({class:_.bk_btn_group},this.button_el),this.el.appendChild(this.group_el)},n.prototype.click=function(){},n}(c.ControlView);e.AbstractButtonView=h,h.__name__="AbstractButtonView";var b=function(t){function n(n){return t.call(this,n)||this}return r.__extends(n,t),n.init_AbstractButton=function(){this.define((function(t){var n=t.String,e=t.Ref;return{label:[n,"Button"],icon:[(0,t.Nullable)(e(a.AbstractIcon)),null],button_type:[s.ButtonType,"default"]}}))},n}(c.Control);e.AbstractButton=b,b.__name__="AbstractButton",b.init_AbstractButton()},
524: function _(t,n,e,r,o){r();var i=t(1),l=t(589),a=t(187),s=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this);var e=this.model.properties;this.on_change(e.disabled,(function(){var t,e;try{for(var r=i.__values(n.controls()),o=r.next();!o.done;o=r.next()){var l=o.value;a.toggle_attribute(l,"disabled",n.model.disabled)}}catch(n){t={error:n}}finally{try{o&&!o.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}}))},n}(l.WidgetView);e.ControlView=s,s.__name__="ControlView";var _=function(t){function n(n){return t.call(this,n)||this}return i.__extends(n,t),n}(l.Widget);e.Control=_,_.__name__="Control"},
589: function _(t,i,e,n,o){n();var r=t(1),l=t(412),h=t(135),_=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(i,t),i.prototype._width_policy=function(){return"horizontal"==this.model.orientation?t.prototype._width_policy.call(this):"fixed"},i.prototype._height_policy=function(){return"horizontal"==this.model.orientation?"fixed":t.prototype._height_policy.call(this)},i.prototype.box_sizing=function(){var i=t.prototype.box_sizing.call(this);return"horizontal"==this.model.orientation?null==i.width&&(i.width=this.model.default_size):null==i.height&&(i.height=this.model.default_size),i},i}(l.HTMLBoxView);e.WidgetView=_,_.__name__="WidgetView";var u=function(t){function i(i){return t.call(this,i)||this}return r.__extends(i,t),i.init_Widget=function(){this.define((function(t){var i=t.Number;return{orientation:[h.Orientation,"horizontal"],default_size:[i,300]}})),this.override({margin:[5,5,5,5]})},i}(l.HTMLBox);e.Widget=u,u.__name__="Widget",u.init_Widget()},
526: function _(n,t,c,e,r){e();var _=n(1),i=n(196),a=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return _.__extends(t,n),t}(n(193).DOMView);c.AbstractIconView=a,a.__name__="AbstractIconView";var o=function(n){function t(t){return n.call(this,t)||this}return _.__extends(t,n),t}(i.Model);c.AbstractIcon=o,o.__name__="AbstractIcon"},
527: function _(e,t,n,i,r){i();var o=e(1),s=e(528),u=e(187),h=e(125),_=e(304),a=e(302),c=o.__importDefault(e(299)),l=function(e){function t(){var t=e.apply(this,o.__spread(arguments))||this;return t._open=!1,t._last_value="",t._hover_index=0,t}return o.__extends(t,e),t.prototype.styles=function(){return o.__spread(e.prototype.styles.call(this),[c.default])},t.prototype.render=function(){var t=this;e.prototype.render.call(this),this.input_el.addEventListener("keydown",(function(e){return t._keydown(e)})),this.input_el.addEventListener("keyup",(function(e){return t._keyup(e)})),this.menu=u.div({class:[a.bk_menu,_.bk_below]}),this.menu.addEventListener("click",(function(e){return t._menu_click(e)})),this.menu.addEventListener("mouseover",(function(e){return t._menu_hover(e)})),this.el.appendChild(this.menu),u.undisplay(this.menu)},t.prototype.change_input=function(){this._open&&this.menu.children.length>0&&(this.model.value=this.menu.children[this._hover_index].textContent,this.input_el.focus(),this._hide_menu()),this.model.restrict||e.prototype.change_input.call(this)},t.prototype._update_completions=function(e){var t,n;u.empty(this.menu);try{for(var i=o.__values(e),r=i.next();!r.done;r=i.next()){var s=r.value,h=u.div({},s);this.menu.appendChild(h)}}catch(e){t={error:e}}finally{try{r&&!r.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}e.length>0&&this.menu.children[0].classList.add(_.bk_active)},t.prototype._show_menu=function(){var e=this;if(!this._open){this._open=!0,this._hover_index=0,this._last_value=this.model.value,u.display(this.menu);var t=function(n){var i=n.target;i instanceof HTMLElement&&!e.el.contains(i)&&(document.removeEventListener("click",t),e._hide_menu())};document.addEventListener("click",t)}},t.prototype._hide_menu=function(){this._open&&(this._open=!1,u.undisplay(this.menu))},t.prototype._menu_click=function(e){e.target!=e.currentTarget&&e.target instanceof Element&&(this.model.value=e.target.textContent,this.input_el.focus(),this._hide_menu())},t.prototype._menu_hover=function(e){if(e.target!=e.currentTarget&&e.target instanceof Element){var t=0;for(t=0;t<this.menu.children.length&&this.menu.children[t].textContent!=e.target.textContent;t++);this._bump_hover(t)}},t.prototype._bump_hover=function(e){var t=this.menu.children.length;this._open&&t>0&&(this.menu.children[this._hover_index].classList.remove(_.bk_active),this._hover_index=h.clamp(e,0,t-1),this.menu.children[this._hover_index].classList.add(_.bk_active))},t.prototype._keydown=function(e){},t.prototype._keyup=function(e){var t,n;switch(e.keyCode){case u.Keys.Enter:this.change_input();break;case u.Keys.Esc:this._hide_menu();break;case u.Keys.Up:this._bump_hover(this._hover_index-1);break;case u.Keys.Down:this._bump_hover(this._hover_index+1);break;default:var i=this.input_el.value;if(i.length<this.model.min_characters)return void this._hide_menu();var r=[],s=void 0;s=this.model.case_sensitive?function(e){return e}:function(e){return e.toLowerCase()};try{for(var h=o.__values(this.model.completions),_=h.next();!_.done;_=h.next()){var a=_.value;s(a).startsWith(s(i))&&r.push(a)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(n=h.return)&&n.call(h)}finally{if(t)throw t.error}}this._update_completions(r),0==r.length?this._hide_menu():this._show_menu()}},t}(s.TextInputView);n.AutocompleteInputView=l,l.__name__="AutocompleteInputView";var p=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_AutocompleteInput=function(){this.prototype.default_view=l,this.define((function(e){var t=e.Boolean,n=e.Int,i=e.String;return{completions:[(0,e.Array)(i),[]],min_characters:[n,2],case_sensitive:[t,!0],restrict:[t,!0]}}))},t}(s.TextInput);n.AutocompleteInput=p,p.__name__="AutocompleteInput",p.init_AutocompleteInput()},
528: function _(t,e,n,i,u){i();var l=t(1),o=t(529),p=t(187),a=t(531),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,(function(){var t;return e.input_el.name=null!==(t=e.model.name)&&void 0!==t?t:""})),this.connect(this.model.properties.value.change,(function(){return e.input_el.value=e.model.value})),this.connect(this.model.properties.value_input.change,(function(){return e.input_el.value=e.model.value_input})),this.connect(this.model.properties.disabled.change,(function(){return e.input_el.disabled=e.model.disabled})),this.connect(this.model.properties.placeholder.change,(function(){return e.input_el.placeholder=e.model.placeholder}))},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.input_el=p.input({type:"text",class:a.bk_input,name:this.model.name,value:this.model.value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.input_el.addEventListener("change",(function(){return e.change_input()})),this.input_el.addEventListener("input",(function(){return e.change_input_oninput()})),this.group_el.appendChild(this.input_el)},e.prototype.change_input=function(){this.model.value=this.input_el.value,t.prototype.change_input.call(this)},e.prototype.change_input_oninput=function(){this.model.value_input=this.input_el.value,t.prototype.change_input.call(this)},e}(o.InputWidgetView);n.TextInputView=r,r.__name__="TextInputView";var c=function(t){function e(e){return t.call(this,e)||this}return l.__extends(e,t),e.init_TextInput=function(){this.prototype.default_view=r,this.define((function(t){var e=t.String;return{value:[e,""],value_input:[e,""],placeholder:[e,""]}}))},e}(o.InputWidget);n.TextInput=c,c.__name__="TextInput",c.init_TextInput()},
529: function _(t,e,n,i,o){i();var l=t(1),r=t(524),s=t(187),u=l.__importDefault(t(530)),p=t(531),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.prototype.controls=function(){return l.__generator(this,(function(t){switch(t.label){case 0:return[4,this.input_el];case 1:return t.sent(),[2]}}))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.title.change,(function(){e.label_el.textContent=e.model.title}))},e.prototype.styles=function(){return l.__spread(t.prototype.styles.call(this),[u.default])},e.prototype.render=function(){t.prototype.render.call(this);var e=this.model.title;this.label_el=s.label({style:{display:0==e.length?"none":""}},e),this.group_el=s.div({class:p.bk_input_group},this.label_el),this.el.appendChild(this.group_el)},e.prototype.change_input=function(){},e}(r.ControlView);n.InputWidgetView=_,_.__name__="InputWidgetView";var c=function(t){function e(e){return t.call(this,e)||this}return l.__extends(e,t),e.init_InputWidget=function(){this.define((function(t){return{title:[t.String,""]}}))},e}(r.Control);n.InputWidget=c,c.__name__="InputWidget",c.init_InputWidget()},
530: function _(n,o,t,i,r){i();t.default='\n.bk-root .bk-input {\n  display: inline-block;\n  width: 100%;\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  min-height: 31px;\n  padding: 0 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n}\n.bk-root .bk-input:focus {\n  border-color: #66afe9;\n  outline: 0;\n  box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075), 0 0 8px rgba(102, 175, 233, 0.6);\n}\n.bk-root .bk-input::placeholder,\n.bk-root .bk-input:-ms-input-placeholder,\n.bk-root .bk-input::-moz-placeholder,\n.bk-root .bk-input::-webkit-input-placeholder {\n  color: #999;\n  opacity: 1;\n}\n.bk-root .bk-input[disabled] {\n  cursor: not-allowed;\n  background-color: #eee;\n  opacity: 1;\n}\n.bk-root select:not([multiple]).bk-input,\n.bk-root select:not([size]).bk-input {\n  height: auto;\n  appearance: none;\n  -webkit-appearance: none;\n  background-image: url(\'data:image/svg+xml;utf8,<svg version="1.1" viewBox="0 0 25 20" xmlns="http://www.w3.org/2000/svg"><path d="M 0,0 25,0 12.5,20 Z" fill="black" /></svg>\');\n  background-position: right 0.5em center;\n  background-size: 8px 6px;\n  background-repeat: no-repeat;\n}\n.bk-root select[multiple].bk-input,\n.bk-root select[size].bk-input,\n.bk-root textarea.bk-input {\n  height: auto;\n}\n.bk-root .bk-input-group {\n  width: 100%;\n  height: 100%;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: start;\n  -webkit-align-items: start;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  white-space: nowrap;\n}\n.bk-root .bk-input-group.bk-inline {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-input-group.bk-inline > *:not(:first-child) {\n  margin-left: 5px;\n}\n.bk-root .bk-input-group input[type="checkbox"] + span,\n.bk-root .bk-input-group input[type="radio"] + span {\n  position: relative;\n  top: -2px;\n  margin-left: 3px;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper {\n  display: inherit;\n  width: inherit;\n  height: inherit;\n  position: relative;\n  overflow: hidden;\n  padding: 0;\n  vertical-align: middle;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper input {\n  padding-right: 20px;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn {\n  position: absolute;\n  display: block;\n  height: 50%;\n  min-height: 0;\n  min-width: 0;\n  width: 30px;\n  padding: 0;\n  margin: 0;\n  right: 0;\n  border: none;\n  background: none;\n  cursor: pointer;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn:before {\n  content: "";\n  display: inline-block;\n  transform: translateY(-50%);\n  border-left: 5px solid transparent;\n  border-right: 5px solid transparent;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up {\n  top: 0;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up:before {\n  border-bottom: 5px solid black;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-up:disabled:before {\n  border-bottom-color: grey;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down {\n  bottom: 0;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down:before {\n  border-top: 5px solid black;\n}\n.bk-root .bk-input-group > .bk-spin-wrapper > .bk-spin-btn.bk-spin-btn-down:disabled:before {\n  border-top-color: grey;\n}\n'},
531: function _(u,n,p,i,t){i(),p.bk_input="bk-input",p.bk_input_group="bk-input-group"},
532: function _(t,n,i,e,o){e();var u=t(1),r=t(523),_=t(430),c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return u.__extends(n,t),n.prototype.click=function(){this.model.trigger_event(new _.ButtonClick),t.prototype.click.call(this)},n}(r.AbstractButtonView);i.ButtonView=c,c.__name__="ButtonView";var l=function(t){function n(n){return t.call(this,n)||this}return u.__extends(n,t),n.init_Button=function(){this.prototype.default_view=c,this.override({label:"Button"})},n}(r.AbstractButton);i.Button=l,l.__name__="Button",l.init_Button()},
533: function _(t,e,n,o,i){o();var u=t(1),r=t(534),c=t(187),a=t(304),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return u.__extends(e,t),Object.defineProperty(e.prototype,"active",{get:function(){return new Set(this.model.active)},enumerable:!1,configurable:!0}),e.prototype.change_active=function(t){var e=this.active;e.has(t)?e.delete(t):e.add(t),this.model.active=u.__spread(e).sort()},e.prototype._update_active=function(){var t=this.active;this._buttons.forEach((function(e,n){c.classes(e).toggle(a.bk_active,t.has(n))}))},e}(r.ButtonGroupView);n.CheckboxButtonGroupView=_,_.__name__="CheckboxButtonGroupView";var h=function(t){function e(e){return t.call(this,e)||this}return u.__extends(e,t),e.init_CheckboxButtonGroup=function(){this.prototype.default_view=_,this.define((function(t){var e=t.Int;return{active:[(0,t.Array)(e),[]]}}))},e}(r.ButtonGroup);n.CheckboxButtonGroup=h,h.__name__="CheckboxButtonGroup",h.init_CheckboxButtonGroup()},
534: function _(t,n,e,r,o){r();var i=t(1),u=t(524),s=t(135),a=t(187),_=t(418),c=i.__importDefault(t(419)),l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return i.__extends(n,t),n.prototype.controls=function(){return i.__generator(this,(function(t){switch(t.label){case 0:return[5,i.__values(this._buttons)];case 1:return t.sent(),[2]}}))},n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this);var e=this.model.properties;this.on_change(e.button_type,(function(){return n.render()})),this.on_change(e.labels,(function(){return n.render()})),this.on_change(e.active,(function(){return n._update_active()}))},n.prototype.styles=function(){return i.__spread(t.prototype.styles.call(this),[c.default])},n.prototype.render=function(){var n=this;t.prototype.render.call(this),this._buttons=this.model.labels.map((function(t,e){var r=a.div({class:[_.bk_btn,_.bk_btn_type(n.model.button_type)],disabled:n.model.disabled},t);return r.addEventListener("click",(function(){return n.change_active(e)})),r})),this._update_active();var e=a.div({class:_.bk_btn_group},this._buttons);this.el.appendChild(e)},n}(u.ControlView);e.ButtonGroupView=l,l.__name__="ButtonGroupView";var p=function(t){function n(n){return t.call(this,n)||this}return i.__extends(n,t),n.init_ButtonGroup=function(){this.define((function(t){var n=t.String;return{labels:[(0,t.Array)(n),[]],button_type:[s.ButtonType,"default"]}}))},n}(u.Control);e.ButtonGroup=p,p.__name__="ButtonGroup",p.init_ButtonGroup()},
535: function _(e,t,n,i,r){i();var o=e(1),a=e(536),u=e(187),l=e(124),c=e(304),p=e(531),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.render=function(){var t=this;e.prototype.render.call(this);var n=u.div({class:[p.bk_input_group,this.model.inline?c.bk_inline:null]});this.el.appendChild(n);var i=this.model,r=i.active,o=i.labels;this._inputs=[];for(var a=function(e){var i=u.input({type:"checkbox",value:""+e});i.addEventListener("change",(function(){return t.change_active(e)})),s._inputs.push(i),s.model.disabled&&(i.disabled=!0),l.includes(r,e)&&(i.checked=!0);var a=u.label({},i,u.span({},o[e]));n.appendChild(a)},s=this,h=0;h<o.length;h++)a(h)},t.prototype.change_active=function(e){var t=new Set(this.model.active);t.has(e)?t.delete(e):t.add(e),this.model.active=o.__spread(t).sort()},t}(a.InputGroupView);n.CheckboxGroupView=s,s.__name__="CheckboxGroupView";var h=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_CheckboxGroup=function(){this.prototype.default_view=s,this.define((function(e){var t=e.Boolean,n=e.Int,i=e.String,r=e.Array;return{active:[r(n),[]],labels:[r(i),[]],inline:[t,!1]}}))},t}(a.InputGroup);n.CheckboxGroup=h,h.__name__="CheckboxGroup",h.init_CheckboxGroup()},
536: function _(t,n,e,r,o){r();var u=t(1),i=t(524),s=u.__importDefault(t(530)),c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return u.__extends(n,t),n.prototype.controls=function(){return u.__generator(this,(function(t){switch(t.label){case 0:return[5,u.__values(this._inputs)];case 1:return t.sent(),[2]}}))},n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return n.render()}))},n.prototype.styles=function(){return u.__spread(t.prototype.styles.call(this),[s.default])},n}(i.ControlView);e.InputGroupView=c,c.__name__="InputGroupView";var _=function(t){function n(n){return t.call(this,n)||this}return u.__extends(n,t),n}(i.Control);e.InputGroup=_,_.__name__="InputGroup"},
537: function _(e,t,n,i,o){i();var r=e(1),l=e(529),c=e(187),u=e(531),s=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return r.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,(function(){var e;return t.input_el.name=null!==(e=t.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.color.change,(function(){return t.input_el.value=t.model.color})),this.connect(this.model.properties.disabled.change,(function(){return t.input_el.disabled=t.model.disabled}))},t.prototype.render=function(){var t=this;e.prototype.render.call(this),this.input_el=c.input({type:"color",class:u.bk_input,name:this.model.name,value:this.model.color,disabled:this.model.disabled}),this.input_el.addEventListener("change",(function(){return t.change_input()})),this.group_el.appendChild(this.input_el)},t.prototype.change_input=function(){this.model.color=this.input_el.value,e.prototype.change_input.call(this)},t}(l.InputWidgetView);n.ColorPickerView=s,s.__name__="ColorPickerView";var p=function(e){function t(t){return e.call(this,t)||this}return r.__extends(t,e),t.init_ColorPicker=function(){this.prototype.default_view=s,this.define((function(e){return{color:[e.Color,"#000000"]}}))},t}(l.InputWidget);n.ColorPicker=p,p.__name__="ColorPicker",p.init_ColorPicker()},
538: function _(e,t,n,i,a){i();var o=e(1),r=o.__importDefault(e(539)),l=e(529),s=e(187),u=e(135),c=e(123),d=e(531),_=o.__importDefault(e(540));function p(e){var t,n,i=[];try{for(var a=o.__values(e),r=a.next();!r.done;r=a.next()){var l=r.value;if(c.isString(l))i.push(l);else{var s=o.__read(l,2),u=s[0],d=s[1];i.push({from:u,to:d})}}}catch(e){t={error:e}}finally{try{r&&!r.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}return i}var h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var n=this.model.properties,i=n.value,a=n.min_date,o=n.max_date,r=n.disabled_dates,l=n.enabled_dates,s=n.position,u=n.inline;this.connect(i.change,(function(){var e;return null===(e=t._picker)||void 0===e?void 0:e.setDate(i.value())})),this.connect(a.change,(function(){var e;return null===(e=t._picker)||void 0===e?void 0:e.set("minDate",a.value())})),this.connect(o.change,(function(){var e;return null===(e=t._picker)||void 0===e?void 0:e.set("maxDate",o.value())})),this.connect(r.change,(function(){var e;return null===(e=t._picker)||void 0===e?void 0:e.set("disable",r.value())})),this.connect(l.change,(function(){var e;return null===(e=t._picker)||void 0===e?void 0:e.set("enable",l.value())})),this.connect(s.change,(function(){var e;return null===(e=t._picker)||void 0===e?void 0:e.set("position",s.value())})),this.connect(u.change,(function(){var e;return null===(e=t._picker)||void 0===e?void 0:e.set("inline",u.value())}))},t.prototype.remove=function(){var t;null===(t=this._picker)||void 0===t||t.destroy(),e.prototype.remove.call(this)},t.prototype.styles=function(){return o.__spread(e.prototype.styles.call(this),[_.default])},t.prototype.render=function(){var t=this;null==this._picker&&(e.prototype.render.call(this),this.input_el=s.input({type:"text",class:d.bk_input,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el),this._picker=r.default(this.input_el,{defaultDate:this.model.value,minDate:this.model.min_date,maxDate:this.model.max_date,inline:this.model.inline,position:this.model.position,disable:p(this.model.disabled_dates),enable:p(this.model.enabled_dates),onChange:function(e,n,i){return t._on_change(e,n,i)}}))},t.prototype._on_change=function(e,t,n){this.model.value=t,this.change_input()},t}(l.InputWidgetView);n.DatePickerView=h,h.__name__="DatePickerView";var v=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_DatePicker=function(){this.prototype.default_view=h,this.define((function(e){var t=e.Boolean,n=e.String,i=e.Array,a=e.Tuple,o=i((0,e.Or)(n,a(n,n)));return{value:[n],min_date:[n],max_date:[n],disabled_dates:[o,[]],enabled_dates:[o,[]],position:[u.CalendarPosition,"auto"],inline:[t,!1]}}))},t}(l.InputWidget);n.DatePicker=v,v.__name__="DatePicker",v.init_DatePicker()},
539: function _(e,n,t,a,i){
/* flatpickr v4.6.6, @license MIT */var o,r;o=this,r=function(){"use strict";
/*! *****************************************************************************
        Copyright (c) Microsoft Corporation.
    
        Permission to use, copy, modify, and/or distribute this software for any
        purpose with or without fee is hereby granted.
    
        THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
        REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
        AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
        INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
        LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
        OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
        PERFORMANCE OF THIS SOFTWARE.
        ***************************************************************************** */var e=function(){return(e=Object.assign||function(e){for(var n,t=1,a=arguments.length;t<a;t++)for(var i in n=arguments[t])Object.prototype.hasOwnProperty.call(n,i)&&(e[i]=n[i]);return e}).apply(this,arguments)};function n(){for(var e=0,n=0,t=arguments.length;n<t;n++)e+=arguments[n].length;var a=Array(e),i=0;for(n=0;n<t;n++)for(var o=arguments[n],r=0,l=o.length;r<l;r++,i++)a[i]=o[r];return a}var t=["onChange","onClose","onDayCreate","onDestroy","onKeyDown","onMonthChange","onOpen","onParseConfig","onReady","onValueUpdate","onYearChange","onPreCalendarPosition"],a={_disable:[],_enable:[],allowInput:!1,allowInvalidPreload:!1,altFormat:"F j, Y",altInput:!1,altInputClass:"form-control input",animate:"object"==typeof window&&-1===window.navigator.userAgent.indexOf("MSIE"),ariaDateFormat:"F j, Y",autoFillDefaultTime:!0,clickOpens:!0,closeOnSelect:!0,conjunction:", ",dateFormat:"Y-m-d",defaultHour:12,defaultMinute:0,defaultSeconds:0,disable:[],disableMobile:!1,enable:[],enableSeconds:!1,enableTime:!1,errorHandler:function(e){return"undefined"!=typeof console&&console.warn(e)},getWeek:function(e){var n=new Date(e.getTime());n.setHours(0,0,0,0),n.setDate(n.getDate()+3-(n.getDay()+6)%7);var t=new Date(n.getFullYear(),0,4);return 1+Math.round(((n.getTime()-t.getTime())/864e5-3+(t.getDay()+6)%7)/7)},hourIncrement:1,ignoredFocusElements:[],inline:!1,locale:"default",minuteIncrement:5,mode:"single",monthSelectorType:"dropdown",nextArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",noCalendar:!1,now:new Date,onChange:[],onClose:[],onDayCreate:[],onDestroy:[],onKeyDown:[],onMonthChange:[],onOpen:[],onParseConfig:[],onReady:[],onValueUpdate:[],onYearChange:[],onPreCalendarPosition:[],plugins:[],position:"auto",positionElement:void 0,prevArrow:"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",shorthandCurrentMonth:!1,showMonths:1,static:!1,time_24hr:!1,weekNumbers:!1,wrap:!1},i={weekdays:{shorthand:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],longhand:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"]},months:{shorthand:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],longhand:["January","February","March","April","May","June","July","August","September","October","November","December"]},daysInMonth:[31,28,31,30,31,30,31,31,30,31,30,31],firstDayOfWeek:0,ordinal:function(e){var n=e%100;if(n>3&&n<21)return"th";switch(n%10){case 1:return"st";case 2:return"nd";case 3:return"rd";default:return"th"}},rangeSeparator:" to ",weekAbbreviation:"Wk",scrollTitle:"Scroll to increment",toggleTitle:"Click to toggle",amPM:["AM","PM"],yearAriaLabel:"Year",monthAriaLabel:"Month",hourAriaLabel:"Hour",minuteAriaLabel:"Minute",time_24hr:!1},o=function(e,n){return void 0===n&&(n=2),("000"+e).slice(-1*n)},r=function(e){return!0===e?1:0};function l(e,n,t){var a;return void 0===t&&(t=!1),function(){var i=this,o=arguments;null!==a&&clearTimeout(a),a=window.setTimeout((function(){a=null,t||e.apply(i,o)}),n),t&&!a&&e.apply(i,o)}}var c=function(e){return e instanceof Array?e:[e]};function d(e,n,t){if(!0===t)return e.classList.add(n);e.classList.remove(n)}function s(e,n,t){var a=window.document.createElement(e);return n=n||"",t=t||"",a.className=n,void 0!==t&&(a.textContent=t),a}function u(e){for(;e.firstChild;)e.removeChild(e.firstChild)}function f(e,n){var t=s("div","numInputWrapper"),a=s("input","numInput "+e),i=s("span","arrowUp"),o=s("span","arrowDown");if(-1===navigator.userAgent.indexOf("MSIE 9.0")?a.type="number":(a.type="text",a.pattern="\\d*"),void 0!==n)for(var r in n)a.setAttribute(r,n[r]);return t.appendChild(a),t.appendChild(i),t.appendChild(o),t}function m(e){try{return"function"==typeof e.composedPath?e.composedPath()[0]:e.target}catch(n){return e.target}}var g=function(){},p=function(e,n,t){return t.months[n?"shorthand":"longhand"][e]},h={D:g,F:function(e,n,t){e.setMonth(t.months.longhand.indexOf(n))},G:function(e,n){e.setHours(parseFloat(n))},H:function(e,n){e.setHours(parseFloat(n))},J:function(e,n){e.setDate(parseFloat(n))},K:function(e,n,t){e.setHours(e.getHours()%12+12*r(new RegExp(t.amPM[1],"i").test(n)))},M:function(e,n,t){e.setMonth(t.months.shorthand.indexOf(n))},S:function(e,n){e.setSeconds(parseFloat(n))},U:function(e,n){return new Date(1e3*parseFloat(n))},W:function(e,n,t){var a=parseInt(n),i=new Date(e.getFullYear(),0,2+7*(a-1),0,0,0,0);return i.setDate(i.getDate()-i.getDay()+t.firstDayOfWeek),i},Y:function(e,n){e.setFullYear(parseFloat(n))},Z:function(e,n){return new Date(n)},d:function(e,n){e.setDate(parseFloat(n))},h:function(e,n){e.setHours(parseFloat(n))},i:function(e,n){e.setMinutes(parseFloat(n))},j:function(e,n){e.setDate(parseFloat(n))},l:g,m:function(e,n){e.setMonth(parseFloat(n)-1)},n:function(e,n){e.setMonth(parseFloat(n)-1)},s:function(e,n){e.setSeconds(parseFloat(n))},u:function(e,n){return new Date(parseFloat(n))},w:g,y:function(e,n){e.setFullYear(2e3+parseFloat(n))}},v={D:"(\\w+)",F:"(\\w+)",G:"(\\d\\d|\\d)",H:"(\\d\\d|\\d)",J:"(\\d\\d|\\d)\\w+",K:"",M:"(\\w+)",S:"(\\d\\d|\\d)",U:"(.+)",W:"(\\d\\d|\\d)",Y:"(\\d{4})",Z:"(.+)",d:"(\\d\\d|\\d)",h:"(\\d\\d|\\d)",i:"(\\d\\d|\\d)",j:"(\\d\\d|\\d)",l:"(\\w+)",m:"(\\d\\d|\\d)",n:"(\\d\\d|\\d)",s:"(\\d\\d|\\d)",u:"(.+)",w:"(\\d\\d|\\d)",y:"(\\d{2})"},D={Z:function(e){return e.toISOString()},D:function(e,n,t){return n.weekdays.shorthand[D.w(e,n,t)]},F:function(e,n,t){return p(D.n(e,n,t)-1,!1,n)},G:function(e,n,t){return o(D.h(e,n,t))},H:function(e){return o(e.getHours())},J:function(e,n){return void 0!==n.ordinal?e.getDate()+n.ordinal(e.getDate()):e.getDate()},K:function(e,n){return n.amPM[r(e.getHours()>11)]},M:function(e,n){return p(e.getMonth(),!0,n)},S:function(e){return o(e.getSeconds())},U:function(e){return e.getTime()/1e3},W:function(e,n,t){return t.getWeek(e)},Y:function(e){return o(e.getFullYear(),4)},d:function(e){return o(e.getDate())},h:function(e){return e.getHours()%12?e.getHours()%12:12},i:function(e){return o(e.getMinutes())},j:function(e){return e.getDate()},l:function(e,n){return n.weekdays.longhand[e.getDay()]},m:function(e){return o(e.getMonth()+1)},n:function(e){return e.getMonth()+1},s:function(e){return e.getSeconds()},u:function(e){return e.getTime()},w:function(e){return e.getDay()},y:function(e){return String(e.getFullYear()).substring(2)}},w=function(e){var n=e.config,t=void 0===n?a:n,o=e.l10n,r=void 0===o?i:o,l=e.isMobile,c=void 0!==l&&l;return function(e,n,a){var i=a||r;return void 0===t.formatDate||c?n.split("").map((function(n,a,o){return D[n]&&"\\"!==o[a-1]?D[n](e,i,t):"\\"!==n?n:""})).join(""):t.formatDate(e,n,i)}},b=function(e){var n=e.config,t=void 0===n?a:n,o=e.l10n,r=void 0===o?i:o;return function(e,n,i,o){if(0===e||e){var l,c=o||r,d=e;if(e instanceof Date)l=new Date(e.getTime());else if("string"!=typeof e&&void 0!==e.toFixed)l=new Date(e);else if("string"==typeof e){var s=n||(t||a).dateFormat,u=String(e).trim();if("today"===u)l=new Date,i=!0;else if(/Z$/.test(u)||/GMT$/.test(u))l=new Date(e);else if(t&&t.parseDate)l=t.parseDate(e,s);else{l=t&&t.noCalendar?new Date((new Date).setHours(0,0,0,0)):new Date((new Date).getFullYear(),0,1,0,0,0,0);for(var f=void 0,m=[],g=0,p=0,D="";g<s.length;g++){var w=s[g],b="\\"===w,C="\\"===s[g-1]||b;if(v[w]&&!C){D+=v[w];var M=new RegExp(D).exec(e);M&&(f=!0)&&m["Y"!==w?"push":"unshift"]({fn:h[w],val:M[++p]})}else b||(D+=".");m.forEach((function(e){var n=e.fn,t=e.val;return l=n(l,t,c)||l}))}l=f?l:void 0}}if(l instanceof Date&&!isNaN(l.getTime()))return!0===i&&l.setHours(0,0,0,0),l;t.errorHandler(new Error("Invalid date provided: "+d))}}};function C(e,n,t){return void 0===t&&(t=!0),!1!==t?new Date(e.getTime()).setHours(0,0,0,0)-new Date(n.getTime()).setHours(0,0,0,0):e.getTime()-n.getTime()}var M=864e5;function y(g,h){var D={config:e(e({},a),E.defaultConfig),l10n:i};function y(e){return e.bind(D)}function x(){var e=D.config;!1===e.weekNumbers&&1===e.showMonths||!0!==e.noCalendar&&window.requestAnimationFrame((function(){if(void 0!==D.calendarContainer&&(D.calendarContainer.style.visibility="hidden",D.calendarContainer.style.display="block"),void 0!==D.daysContainer){var n=(D.days.offsetWidth+1)*e.showMonths;D.daysContainer.style.width=n+"px",D.calendarContainer.style.width=n+(void 0!==D.weekWrapper?D.weekWrapper.offsetWidth:0)+"px",D.calendarContainer.style.removeProperty("visibility"),D.calendarContainer.style.removeProperty("display")}}))}function k(e){if(0===D.selectedDates.length){var n=void 0!==D.config.minDate?new Date(D.config.minDate.getTime()):new Date,t=S(),a=t.hours,i=t.minutes,l=t.seconds;n.setHours(a,i,l,0),D.setDate(n,!1)}void 0!==e&&"blur"!==e.type&&function(e){e.preventDefault();var n="keydown"===e.type,t=m(e),a=t;void 0!==D.amPM&&t===D.amPM&&(D.amPM.textContent=D.l10n.amPM[r(D.amPM.textContent===D.l10n.amPM[0])]);var i=parseFloat(a.getAttribute("min")),l=parseFloat(a.getAttribute("max")),c=parseFloat(a.getAttribute("step")),d=parseInt(a.value,10),s=e.delta||(n?38===e.which?1:-1:0),u=d+c*s;if(void 0!==a.value&&2===a.value.length){var f=a===D.hourElement,g=a===D.minuteElement;u<i?(u=l+u+r(!f)+(r(f)&&r(!D.amPM)),g&&Y(void 0,-1,D.hourElement)):u>l&&(u=a===D.hourElement?u-l-r(!D.amPM):i,g&&Y(void 0,1,D.hourElement)),D.amPM&&f&&(1===c?u+d===23:Math.abs(u-d)>c)&&(D.amPM.textContent=D.l10n.amPM[r(D.amPM.textContent===D.l10n.amPM[0])]),a.value=o(u)}}(e);var c=D._input.value;T(),we(),D._input.value!==c&&D._debouncedChange()}function T(){if(void 0!==D.hourElement&&void 0!==D.minuteElement){var e,n,t=(parseInt(D.hourElement.value.slice(-2),10)||0)%24,a=(parseInt(D.minuteElement.value,10)||0)%60,i=void 0!==D.secondElement?(parseInt(D.secondElement.value,10)||0)%60:0;void 0!==D.amPM&&(e=t,n=D.amPM.textContent,t=e%12+12*r(n===D.l10n.amPM[1]));var o=void 0!==D.config.minTime||D.config.minDate&&D.minDateHasTime&&D.latestSelectedDateObj&&0===C(D.latestSelectedDateObj,D.config.minDate,!0);if(void 0!==D.config.maxTime||D.config.maxDate&&D.maxDateHasTime&&D.latestSelectedDateObj&&0===C(D.latestSelectedDateObj,D.config.maxDate,!0)){var l=void 0!==D.config.maxTime?D.config.maxTime:D.config.maxDate;(t=Math.min(t,l.getHours()))===l.getHours()&&(a=Math.min(a,l.getMinutes())),a===l.getMinutes()&&(i=Math.min(i,l.getSeconds()))}if(o){var c=void 0!==D.config.minTime?D.config.minTime:D.config.minDate;(t=Math.max(t,c.getHours()))===c.getHours()&&(a=Math.max(a,c.getMinutes())),a===c.getMinutes()&&(i=Math.max(i,c.getSeconds()))}_(t,a,i)}}function I(e){var n=e||D.latestSelectedDateObj;n&&_(n.getHours(),n.getMinutes(),n.getSeconds())}function S(){var e=D.config.defaultHour,n=D.config.defaultMinute,t=D.config.defaultSeconds;if(void 0!==D.config.minDate){var a=D.config.minDate.getHours(),i=D.config.minDate.getMinutes();(e=Math.max(e,a))===a&&(n=Math.max(i,n)),e===a&&n===i&&(t=D.config.minDate.getSeconds())}if(void 0!==D.config.maxDate){var o=D.config.maxDate.getHours(),r=D.config.maxDate.getMinutes();(e=Math.min(e,o))===o&&(n=Math.min(r,n)),e===o&&n===r&&(t=D.config.maxDate.getSeconds())}return{hours:e,minutes:n,seconds:t}}function _(e,n,t){void 0!==D.latestSelectedDateObj&&D.latestSelectedDateObj.setHours(e%24,n,t||0,0),D.hourElement&&D.minuteElement&&!D.isMobile&&(D.hourElement.value=o(D.config.time_24hr?e:(12+e)%12+12*r(e%12==0)),D.minuteElement.value=o(n),void 0!==D.amPM&&(D.amPM.textContent=D.l10n.amPM[r(e>=12)]),void 0!==D.secondElement&&(D.secondElement.value=o(t)))}function O(e){var n=m(e),t=parseInt(n.value)+(e.delta||0);(t/1e3>1||"Enter"===e.key&&!/[^\d]/.test(t.toString()))&&Z(t)}function F(e,n,t,a){return n instanceof Array?n.forEach((function(n){return F(e,n,t,a)})):e instanceof Array?e.forEach((function(e){return F(e,n,t,a)})):(e.addEventListener(n,t,a),void D._handlers.push({element:e,event:n,handler:t,options:a}))}function N(){ge("onChange")}function A(e,n){var t=void 0!==e?D.parseDate(e):D.latestSelectedDateObj||(D.config.minDate&&D.config.minDate>D.now?D.config.minDate:D.config.maxDate&&D.config.maxDate<D.now?D.config.maxDate:D.now),a=D.currentYear,i=D.currentMonth;try{void 0!==t&&(D.currentYear=t.getFullYear(),D.currentMonth=t.getMonth())}catch(e){e.message="Invalid date supplied: "+t,D.config.errorHandler(e)}n&&D.currentYear!==a&&(ge("onYearChange"),J()),!n||D.currentYear===a&&D.currentMonth===i||ge("onMonthChange"),D.redraw()}function P(e){var n=m(e);~n.className.indexOf("arrow")&&Y(e,n.classList.contains("arrowUp")?1:-1)}function Y(e,n,t){var a=e&&m(e),i=t||a&&a.parentNode&&a.parentNode.firstChild,o=pe("increment");o.delta=n,i&&i.dispatchEvent(o)}function H(e,n,t,a){var i=Q(n,!0),o=s("span","flatpickr-day "+e,n.getDate().toString());return o.dateObj=n,o.$i=a,o.setAttribute("aria-label",D.formatDate(n,D.config.ariaDateFormat)),-1===e.indexOf("hidden")&&0===C(n,D.now)&&(D.todayDateElem=o,o.classList.add("today"),o.setAttribute("aria-current","date")),i?(o.tabIndex=-1,he(n)&&(o.classList.add("selected"),D.selectedDateElem=o,"range"===D.config.mode&&(d(o,"startRange",D.selectedDates[0]&&0===C(n,D.selectedDates[0],!0)),d(o,"endRange",D.selectedDates[1]&&0===C(n,D.selectedDates[1],!0)),"nextMonthDay"===e&&o.classList.add("inRange")))):o.classList.add("flatpickr-disabled"),"range"===D.config.mode&&function(e){return!("range"!==D.config.mode||D.selectedDates.length<2)&&C(e,D.selectedDates[0])>=0&&C(e,D.selectedDates[1])<=0}(n)&&!he(n)&&o.classList.add("inRange"),D.weekNumbers&&1===D.config.showMonths&&"prevMonthDay"!==e&&t%7==1&&D.weekNumbers.insertAdjacentHTML("beforeend","<span class='flatpickr-day'>"+D.config.getWeek(n)+"</span>"),ge("onDayCreate",o),o}function j(e){e.focus(),"range"===D.config.mode&&te(e)}function L(e){for(var n=e>0?0:D.config.showMonths-1,t=e>0?D.config.showMonths:-1,a=n;a!=t;a+=e)for(var i=D.daysContainer.children[a],o=e>0?0:i.children.length-1,r=e>0?i.children.length:-1,l=o;l!=r;l+=e){var c=i.children[l];if(-1===c.className.indexOf("hidden")&&Q(c.dateObj))return c}}function W(e,n){var t=X(document.activeElement||document.body),a=void 0!==e?e:t?document.activeElement:void 0!==D.selectedDateElem&&X(D.selectedDateElem)?D.selectedDateElem:void 0!==D.todayDateElem&&X(D.todayDateElem)?D.todayDateElem:L(n>0?1:-1);void 0===a?D._input.focus():t?function(e,n){for(var t=-1===e.className.indexOf("Month")?e.dateObj.getMonth():D.currentMonth,a=n>0?D.config.showMonths:-1,i=n>0?1:-1,o=t-D.currentMonth;o!=a;o+=i)for(var r=D.daysContainer.children[o],l=t-D.currentMonth===o?e.$i+n:n<0?r.children.length-1:0,c=r.children.length,d=l;d>=0&&d<c&&d!=(n>0?c:-1);d+=i){var s=r.children[d];if(-1===s.className.indexOf("hidden")&&Q(s.dateObj)&&Math.abs(e.$i-d)>=Math.abs(n))return j(s)}D.changeMonth(i),W(L(i),0)}(a,n):j(a)}function R(e,n){for(var t=(new Date(e,n,1).getDay()-D.l10n.firstDayOfWeek+7)%7,a=D.utils.getDaysInMonth((n-1+12)%12,e),i=D.utils.getDaysInMonth(n,e),o=window.document.createDocumentFragment(),r=D.config.showMonths>1,l=r?"prevMonthDay hidden":"prevMonthDay",c=r?"nextMonthDay hidden":"nextMonthDay",d=a+1-t,u=0;d<=a;d++,u++)o.appendChild(H(l,new Date(e,n-1,d),d,u));for(d=1;d<=i;d++,u++)o.appendChild(H("",new Date(e,n,d),d,u));for(var f=i+1;f<=42-t&&(1===D.config.showMonths||u%7!=0);f++,u++)o.appendChild(H(c,new Date(e,n+1,f%i),f,u));var m=s("div","dayContainer");return m.appendChild(o),m}function B(){if(void 0!==D.daysContainer){u(D.daysContainer),D.weekNumbers&&u(D.weekNumbers);for(var e=document.createDocumentFragment(),n=0;n<D.config.showMonths;n++){var t=new Date(D.currentYear,D.currentMonth,1);t.setMonth(D.currentMonth+n),e.appendChild(R(t.getFullYear(),t.getMonth()))}D.daysContainer.appendChild(e),D.days=D.daysContainer.firstChild,"range"===D.config.mode&&1===D.selectedDates.length&&te()}}function J(){if(!(D.config.showMonths>1||"dropdown"!==D.config.monthSelectorType)){var e=function(e){return!(void 0!==D.config.minDate&&D.currentYear===D.config.minDate.getFullYear()&&e<D.config.minDate.getMonth()||void 0!==D.config.maxDate&&D.currentYear===D.config.maxDate.getFullYear()&&e>D.config.maxDate.getMonth())};D.monthsDropdownContainer.tabIndex=-1,D.monthsDropdownContainer.innerHTML="";for(var n=0;n<12;n++)if(e(n)){var t=s("option","flatpickr-monthDropdown-month");t.value=new Date(D.currentYear,n).getMonth().toString(),t.textContent=p(n,D.config.shorthandCurrentMonth,D.l10n),t.tabIndex=-1,D.currentMonth===n&&(t.selected=!0),D.monthsDropdownContainer.appendChild(t)}}}function K(){var e,n=s("div","flatpickr-month"),t=window.document.createDocumentFragment();D.config.showMonths>1||"static"===D.config.monthSelectorType?e=s("span","cur-month"):(D.monthsDropdownContainer=s("select","flatpickr-monthDropdown-months"),D.monthsDropdownContainer.setAttribute("aria-label",D.l10n.monthAriaLabel),F(D.monthsDropdownContainer,"change",(function(e){var n=m(e),t=parseInt(n.value,10);D.changeMonth(t-D.currentMonth),ge("onMonthChange")})),J(),e=D.monthsDropdownContainer);var a=f("cur-year",{tabindex:"-1"}),i=a.getElementsByTagName("input")[0];i.setAttribute("aria-label",D.l10n.yearAriaLabel),D.config.minDate&&i.setAttribute("min",D.config.minDate.getFullYear().toString()),D.config.maxDate&&(i.setAttribute("max",D.config.maxDate.getFullYear().toString()),i.disabled=!!D.config.minDate&&D.config.minDate.getFullYear()===D.config.maxDate.getFullYear());var o=s("div","flatpickr-current-month");return o.appendChild(e),o.appendChild(a),t.appendChild(o),n.appendChild(t),{container:n,yearElement:i,monthElement:e}}function U(){u(D.monthNav),D.monthNav.appendChild(D.prevMonthNav),D.config.showMonths&&(D.yearElements=[],D.monthElements=[]);for(var e=D.config.showMonths;e--;){var n=K();D.yearElements.push(n.yearElement),D.monthElements.push(n.monthElement),D.monthNav.appendChild(n.container)}D.monthNav.appendChild(D.nextMonthNav)}function q(){D.weekdayContainer?u(D.weekdayContainer):D.weekdayContainer=s("div","flatpickr-weekdays");for(var e=D.config.showMonths;e--;){var n=s("div","flatpickr-weekdaycontainer");D.weekdayContainer.appendChild(n)}return $(),D.weekdayContainer}function $(){if(D.weekdayContainer){var e=D.l10n.firstDayOfWeek,t=n(D.l10n.weekdays.shorthand);e>0&&e<t.length&&(t=n(t.splice(e,t.length),t.splice(0,e)));for(var a=D.config.showMonths;a--;)D.weekdayContainer.children[a].innerHTML="\n      <span class='flatpickr-weekday'>\n        "+t.join("</span><span class='flatpickr-weekday'>")+"\n      </span>\n      "}}function z(e,n){void 0===n&&(n=!0);var t=n?e:e-D.currentMonth;t<0&&!0===D._hidePrevMonthArrow||t>0&&!0===D._hideNextMonthArrow||(D.currentMonth+=t,(D.currentMonth<0||D.currentMonth>11)&&(D.currentYear+=D.currentMonth>11?1:-1,D.currentMonth=(D.currentMonth+12)%12,ge("onYearChange"),J()),B(),ge("onMonthChange"),ve())}function G(e){return!(!D.config.appendTo||!D.config.appendTo.contains(e))||D.calendarContainer.contains(e)}function V(e){if(D.isOpen&&!D.config.inline){var n=m(e),t=G(n),a=n===D.input||n===D.altInput||D.element.contains(n)||e.path&&e.path.indexOf&&(~e.path.indexOf(D.input)||~e.path.indexOf(D.altInput)),i="blur"===e.type?a&&e.relatedTarget&&!G(e.relatedTarget):!a&&!t&&!G(e.relatedTarget),o=!D.config.ignoredFocusElements.some((function(e){return e.contains(n)}));i&&o&&(void 0!==D.timeContainer&&void 0!==D.minuteElement&&void 0!==D.hourElement&&""!==D.input.value&&void 0!==D.input.value&&k(),D.close(),D.config&&"range"===D.config.mode&&1===D.selectedDates.length&&(D.clear(!1),D.redraw()))}}function Z(e){if(!(!e||D.config.minDate&&e<D.config.minDate.getFullYear()||D.config.maxDate&&e>D.config.maxDate.getFullYear())){var n=e,t=D.currentYear!==n;D.currentYear=n||D.currentYear,D.config.maxDate&&D.currentYear===D.config.maxDate.getFullYear()?D.currentMonth=Math.min(D.config.maxDate.getMonth(),D.currentMonth):D.config.minDate&&D.currentYear===D.config.minDate.getFullYear()&&(D.currentMonth=Math.max(D.config.minDate.getMonth(),D.currentMonth)),t&&(D.redraw(),ge("onYearChange"),J())}}function Q(e,n){void 0===n&&(n=!0);var t=D.parseDate(e,void 0,n);if(D.config.minDate&&t&&C(t,D.config.minDate,void 0!==n?n:!D.minDateHasTime)<0||D.config.maxDate&&t&&C(t,D.config.maxDate,void 0!==n?n:!D.maxDateHasTime)>0)return!1;if(0===D.config.enable.length&&0===D.config.disable.length)return!0;if(void 0===t)return!1;for(var a=D.config.enable.length>0,i=a?D.config.enable:D.config.disable,o=0,r=void 0;o<i.length;o++){if("function"==typeof(r=i[o])&&r(t))return a;if(r instanceof Date&&void 0!==t&&r.getTime()===t.getTime())return a;if("string"==typeof r&&void 0!==t){var l=D.parseDate(r,void 0,!0);return l&&l.getTime()===t.getTime()?a:!a}if("object"==typeof r&&void 0!==t&&r.from&&r.to&&t.getTime()>=r.from.getTime()&&t.getTime()<=r.to.getTime())return a}return!a}function X(e){return void 0!==D.daysContainer&&-1===e.className.indexOf("hidden")&&-1===e.className.indexOf("flatpickr-disabled")&&D.daysContainer.contains(e)}function ee(e){e.target!==D._input||e.relatedTarget&&G(e.relatedTarget)||D.setDate(D._input.value,!0,e.target===D.altInput?D.config.altFormat:D.config.dateFormat)}function ne(e){var n=m(e),t=D.config.wrap?g.contains(n):n===D._input,a=D.config.allowInput,i=D.isOpen&&(!a||!t),o=D.config.inline&&t&&!a;if(13===e.keyCode&&t){if(a)return D.setDate(D._input.value,!0,n===D.altInput?D.config.altFormat:D.config.dateFormat),n.blur();D.open()}else if(G(n)||i||o){var r=!!D.timeContainer&&D.timeContainer.contains(n);switch(e.keyCode){case 13:r?(e.preventDefault(),k(),de()):se(e);break;case 27:e.preventDefault(),de();break;case 8:case 46:t&&!D.config.allowInput&&(e.preventDefault(),D.clear());break;case 37:case 39:if(r||t)D.hourElement&&D.hourElement.focus();else if(e.preventDefault(),void 0!==D.daysContainer&&(!1===a||document.activeElement&&X(document.activeElement))){var l=39===e.keyCode?1:-1;e.ctrlKey?(e.stopPropagation(),z(l),W(L(1),0)):W(void 0,l)}break;case 38:case 40:e.preventDefault();var c=40===e.keyCode?1:-1;D.daysContainer&&void 0!==n.$i||n===D.input||n===D.altInput?e.ctrlKey?(e.stopPropagation(),Z(D.currentYear-c),W(L(1),0)):r||W(void 0,7*c):n===D.currentYearElement?Z(D.currentYear-c):D.config.enableTime&&(!r&&D.hourElement&&D.hourElement.focus(),k(e),D._debouncedChange());break;case 9:if(r){var d=[D.hourElement,D.minuteElement,D.secondElement,D.amPM].concat(D.pluginElements).filter((function(e){return e})),s=d.indexOf(n);if(-1!==s){var u=d[s+(e.shiftKey?-1:1)];e.preventDefault(),(u||D._input).focus()}}else!D.config.noCalendar&&D.daysContainer&&D.daysContainer.contains(n)&&e.shiftKey&&(e.preventDefault(),D._input.focus())}}if(void 0!==D.amPM&&n===D.amPM)switch(e.key){case D.l10n.amPM[0].charAt(0):case D.l10n.amPM[0].charAt(0).toLowerCase():D.amPM.textContent=D.l10n.amPM[0],T(),we();break;case D.l10n.amPM[1].charAt(0):case D.l10n.amPM[1].charAt(0).toLowerCase():D.amPM.textContent=D.l10n.amPM[1],T(),we()}(t||G(n))&&ge("onKeyDown",e)}function te(e){if(1===D.selectedDates.length&&(!e||e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled"))){for(var n=e?e.dateObj.getTime():D.days.firstElementChild.dateObj.getTime(),t=D.parseDate(D.selectedDates[0],void 0,!0).getTime(),a=Math.min(n,D.selectedDates[0].getTime()),i=Math.max(n,D.selectedDates[0].getTime()),o=!1,r=0,l=0,c=a;c<i;c+=M)Q(new Date(c),!0)||(o=o||c>a&&c<i,c<t&&(!r||c>r)?r=c:c>t&&(!l||c<l)&&(l=c));for(var d=0;d<D.config.showMonths;d++)for(var s=D.daysContainer.children[d],u=function(a,i){var c,d,u,f=s.children[a],m=f.dateObj.getTime(),g=r>0&&m<r||l>0&&m>l;return g?(f.classList.add("notAllowed"),["inRange","startRange","endRange"].forEach((function(e){f.classList.remove(e)})),"continue"):o&&!g?"continue":(["startRange","inRange","endRange","notAllowed"].forEach((function(e){f.classList.remove(e)})),void(void 0!==e&&(e.classList.add(n<=D.selectedDates[0].getTime()?"startRange":"endRange"),t<n&&m===t?f.classList.add("startRange"):t>n&&m===t&&f.classList.add("endRange"),m>=r&&(0===l||m<=l)&&(d=t,u=n,(c=m)>Math.min(d,u)&&c<Math.max(d,u))&&f.classList.add("inRange"))))},f=0,m=s.children.length;f<m;f++)u(f)}}function ae(){!D.isOpen||D.config.static||D.config.inline||le()}function ie(e){return function(n){var t=D.config["_"+e+"Date"]=D.parseDate(n,D.config.dateFormat),a=D.config["_"+("min"===e?"max":"min")+"Date"];void 0!==t&&(D["min"===e?"minDateHasTime":"maxDateHasTime"]=t.getHours()>0||t.getMinutes()>0||t.getSeconds()>0),D.selectedDates&&(D.selectedDates=D.selectedDates.filter((function(e){return Q(e)})),D.selectedDates.length||"min"!==e||I(t),we()),D.daysContainer&&(ce(),void 0!==t?D.currentYearElement[e]=t.getFullYear().toString():D.currentYearElement.removeAttribute(e),D.currentYearElement.disabled=!!a&&void 0!==t&&a.getFullYear()===t.getFullYear())}}function oe(){return D.config.wrap?g.querySelector("[data-input]"):g}function re(){"object"!=typeof D.config.locale&&void 0===E.l10ns[D.config.locale]&&D.config.errorHandler(new Error("flatpickr: invalid locale "+D.config.locale)),D.l10n=e(e({},E.l10ns.default),"object"==typeof D.config.locale?D.config.locale:"default"!==D.config.locale?E.l10ns[D.config.locale]:void 0),v.K="("+D.l10n.amPM[0]+"|"+D.l10n.amPM[1]+"|"+D.l10n.amPM[0].toLowerCase()+"|"+D.l10n.amPM[1].toLowerCase()+")",void 0===e(e({},h),JSON.parse(JSON.stringify(g.dataset||{}))).time_24hr&&void 0===E.defaultConfig.time_24hr&&(D.config.time_24hr=D.l10n.time_24hr),D.formatDate=w(D),D.parseDate=b({config:D.config,l10n:D.l10n})}function le(e){if(void 0!==D.calendarContainer){ge("onPreCalendarPosition");var n=e||D._positionElement,t=Array.prototype.reduce.call(D.calendarContainer.children,(function(e,n){return e+n.offsetHeight}),0),a=D.calendarContainer.offsetWidth,i=D.config.position.split(" "),o=i[0],r=i.length>1?i[1]:null,l=n.getBoundingClientRect(),c=window.innerHeight-l.bottom,s="above"===o||"below"!==o&&c<t&&l.top>t,u=window.pageYOffset+l.top+(s?-t-2:n.offsetHeight+2);if(d(D.calendarContainer,"arrowTop",!s),d(D.calendarContainer,"arrowBottom",s),!D.config.inline){var f=window.pageXOffset+l.left,m=!1,g=!1;"center"===r?(f-=(a-l.width)/2,m=!0):"right"===r&&(f-=a-l.width,g=!0),d(D.calendarContainer,"arrowLeft",!m&&!g),d(D.calendarContainer,"arrowCenter",m),d(D.calendarContainer,"arrowRight",g);var p=window.document.body.offsetWidth-(window.pageXOffset+l.right),h=f+a>window.document.body.offsetWidth,v=p+a>window.document.body.offsetWidth;if(d(D.calendarContainer,"rightMost",h),!D.config.static)if(D.calendarContainer.style.top=u+"px",h)if(v){var w=function(){for(var e=null,n=0;n<document.styleSheets.length;n++){var t=document.styleSheets[n];try{t.cssRules}catch(e){continue}e=t;break}return null!=e?e:(a=document.createElement("style"),document.head.appendChild(a),a.sheet);var a}();if(void 0===w)return;var b=window.document.body.offsetWidth,C=Math.max(0,b/2-a/2),M=w.cssRules.length,y="{left:"+l.left+"px;right:auto;}";d(D.calendarContainer,"rightMost",!1),d(D.calendarContainer,"centerMost",!0),w.insertRule(".flatpickr-calendar.centerMost:before,.flatpickr-calendar.centerMost:after"+y,M),D.calendarContainer.style.left=C+"px",D.calendarContainer.style.right="auto"}else D.calendarContainer.style.left="auto",D.calendarContainer.style.right=p+"px";else D.calendarContainer.style.left=f+"px",D.calendarContainer.style.right="auto"}}}function ce(){D.config.noCalendar||D.isMobile||(J(),ve(),B())}function de(){D._input.focus(),-1!==window.navigator.userAgent.indexOf("MSIE")||void 0!==navigator.msMaxTouchPoints?setTimeout(D.close,0):D.close()}function se(e){e.preventDefault(),e.stopPropagation();var n=function e(n,t){return t(n)?n:n.parentNode?e(n.parentNode,t):void 0}(m(e),(function(e){return e.classList&&e.classList.contains("flatpickr-day")&&!e.classList.contains("flatpickr-disabled")&&!e.classList.contains("notAllowed")}));if(void 0!==n){var t=n,a=D.latestSelectedDateObj=new Date(t.dateObj.getTime()),i=(a.getMonth()<D.currentMonth||a.getMonth()>D.currentMonth+D.config.showMonths-1)&&"range"!==D.config.mode;if(D.selectedDateElem=t,"single"===D.config.mode)D.selectedDates=[a];else if("multiple"===D.config.mode){var o=he(a);o?D.selectedDates.splice(parseInt(o),1):D.selectedDates.push(a)}else"range"===D.config.mode&&(2===D.selectedDates.length&&D.clear(!1,!1),D.latestSelectedDateObj=a,D.selectedDates.push(a),0!==C(a,D.selectedDates[0],!0)&&D.selectedDates.sort((function(e,n){return e.getTime()-n.getTime()})));if(T(),i){var r=D.currentYear!==a.getFullYear();D.currentYear=a.getFullYear(),D.currentMonth=a.getMonth(),r&&(ge("onYearChange"),J()),ge("onMonthChange")}if(ve(),B(),we(),i||"range"===D.config.mode||1!==D.config.showMonths?void 0!==D.selectedDateElem&&void 0===D.hourElement&&D.selectedDateElem&&D.selectedDateElem.focus():j(t),void 0!==D.hourElement&&void 0!==D.hourElement&&D.hourElement.focus(),D.config.closeOnSelect){var l="single"===D.config.mode&&!D.config.enableTime,c="range"===D.config.mode&&2===D.selectedDates.length&&!D.config.enableTime;(l||c)&&de()}N()}}D.parseDate=b({config:D.config,l10n:D.l10n}),D._handlers=[],D.pluginElements=[],D.loadedPlugins=[],D._bind=F,D._setHoursFromDate=I,D._positionCalendar=le,D.changeMonth=z,D.changeYear=Z,D.clear=function(e,n){if(void 0===e&&(e=!0),void 0===n&&(n=!0),D.input.value="",void 0!==D.altInput&&(D.altInput.value=""),void 0!==D.mobileInput&&(D.mobileInput.value=""),D.selectedDates=[],D.latestSelectedDateObj=void 0,!0===n&&(D.currentYear=D._initialDate.getFullYear(),D.currentMonth=D._initialDate.getMonth()),!0===D.config.enableTime){var t=S(),a=t.hours,i=t.minutes,o=t.seconds;_(a,i,o)}D.redraw(),e&&ge("onChange")},D.close=function(){D.isOpen=!1,D.isMobile||(void 0!==D.calendarContainer&&D.calendarContainer.classList.remove("open"),void 0!==D._input&&D._input.classList.remove("active")),ge("onClose")},D._createElement=s,D.destroy=function(){void 0!==D.config&&ge("onDestroy");for(var e=D._handlers.length;e--;){var n=D._handlers[e];n.element.removeEventListener(n.event,n.handler,n.options)}if(D._handlers=[],D.mobileInput)D.mobileInput.parentNode&&D.mobileInput.parentNode.removeChild(D.mobileInput),D.mobileInput=void 0;else if(D.calendarContainer&&D.calendarContainer.parentNode)if(D.config.static&&D.calendarContainer.parentNode){var t=D.calendarContainer.parentNode;if(t.lastChild&&t.removeChild(t.lastChild),t.parentNode){for(;t.firstChild;)t.parentNode.insertBefore(t.firstChild,t);t.parentNode.removeChild(t)}}else D.calendarContainer.parentNode.removeChild(D.calendarContainer);D.altInput&&(D.input.type="text",D.altInput.parentNode&&D.altInput.parentNode.removeChild(D.altInput),delete D.altInput),D.input&&(D.input.type=D.input._type,D.input.classList.remove("flatpickr-input"),D.input.removeAttribute("readonly")),["_showTimeInput","latestSelectedDateObj","_hideNextMonthArrow","_hidePrevMonthArrow","__hideNextMonthArrow","__hidePrevMonthArrow","isMobile","isOpen","selectedDateElem","minDateHasTime","maxDateHasTime","days","daysContainer","_input","_positionElement","innerContainer","rContainer","monthNav","todayDateElem","calendarContainer","weekdayContainer","prevMonthNav","nextMonthNav","monthsDropdownContainer","currentMonthElement","currentYearElement","navigationCurrentMonth","selectedDateElem","config"].forEach((function(e){try{delete D[e]}catch(e){}}))},D.isEnabled=Q,D.jumpToDate=A,D.open=function(e,n){if(void 0===n&&(n=D._positionElement),!0===D.isMobile){if(e){e.preventDefault();var t=m(e);t&&t.blur()}return void 0!==D.mobileInput&&(D.mobileInput.focus(),D.mobileInput.click()),void ge("onOpen")}if(!D._input.disabled&&!D.config.inline){var a=D.isOpen;D.isOpen=!0,a||(D.calendarContainer.classList.add("open"),D._input.classList.add("active"),ge("onOpen"),le(n)),!0===D.config.enableTime&&!0===D.config.noCalendar&&(!1!==D.config.allowInput||void 0!==e&&D.timeContainer.contains(e.relatedTarget)||setTimeout((function(){return D.hourElement.select()}),50))}},D.redraw=ce,D.set=function(e,n){if(null!==e&&"object"==typeof e)for(var a in Object.assign(D.config,e),e)void 0!==ue[a]&&ue[a].forEach((function(e){return e()}));else D.config[e]=n,void 0!==ue[e]?ue[e].forEach((function(e){return e()})):t.indexOf(e)>-1&&(D.config[e]=c(n));D.redraw(),we(!0)},D.setDate=function(e,n,t){if(void 0===n&&(n=!1),void 0===t&&(t=D.config.dateFormat),0!==e&&!e||e instanceof Array&&0===e.length)return D.clear(n);fe(e,t),D.latestSelectedDateObj=D.selectedDates[D.selectedDates.length-1],D.redraw(),A(void 0,n),I(),0===D.selectedDates.length&&D.clear(!1),we(n),n&&ge("onChange")},D.toggle=function(e){if(!0===D.isOpen)return D.close();D.open(e)};var ue={locale:[re,$],showMonths:[U,x,q],minDate:[A],maxDate:[A]};function fe(e,n){var t=[];if(e instanceof Array)t=e.map((function(e){return D.parseDate(e,n)}));else if(e instanceof Date||"number"==typeof e)t=[D.parseDate(e,n)];else if("string"==typeof e)switch(D.config.mode){case"single":case"time":t=[D.parseDate(e,n)];break;case"multiple":t=e.split(D.config.conjunction).map((function(e){return D.parseDate(e,n)}));break;case"range":t=e.split(D.l10n.rangeSeparator).map((function(e){return D.parseDate(e,n)}))}else D.config.errorHandler(new Error("Invalid date supplied: "+JSON.stringify(e)));D.selectedDates=D.config.allowInvalidPreload?t:t.filter((function(e){return e instanceof Date&&Q(e,!1)})),"range"===D.config.mode&&D.selectedDates.sort((function(e,n){return e.getTime()-n.getTime()}))}function me(e){return e.slice().map((function(e){return"string"==typeof e||"number"==typeof e||e instanceof Date?D.parseDate(e,void 0,!0):e&&"object"==typeof e&&e.from&&e.to?{from:D.parseDate(e.from,void 0),to:D.parseDate(e.to,void 0)}:e})).filter((function(e){return e}))}function ge(e,n){if(void 0!==D.config){var t=D.config[e];if(void 0!==t&&t.length>0)for(var a=0;t[a]&&a<t.length;a++)t[a](D.selectedDates,D.input.value,D,n);"onChange"===e&&(D.input.dispatchEvent(pe("change")),D.input.dispatchEvent(pe("input")))}}function pe(e){var n=document.createEvent("Event");return n.initEvent(e,!0,!0),n}function he(e){for(var n=0;n<D.selectedDates.length;n++)if(0===C(D.selectedDates[n],e))return""+n;return!1}function ve(){D.config.noCalendar||D.isMobile||!D.monthNav||(D.yearElements.forEach((function(e,n){var t=new Date(D.currentYear,D.currentMonth,1);t.setMonth(D.currentMonth+n),D.config.showMonths>1||"static"===D.config.monthSelectorType?D.monthElements[n].textContent=p(t.getMonth(),D.config.shorthandCurrentMonth,D.l10n)+" ":D.monthsDropdownContainer.value=t.getMonth().toString(),e.value=t.getFullYear().toString()})),D._hidePrevMonthArrow=void 0!==D.config.minDate&&(D.currentYear===D.config.minDate.getFullYear()?D.currentMonth<=D.config.minDate.getMonth():D.currentYear<D.config.minDate.getFullYear()),D._hideNextMonthArrow=void 0!==D.config.maxDate&&(D.currentYear===D.config.maxDate.getFullYear()?D.currentMonth+1>D.config.maxDate.getMonth():D.currentYear>D.config.maxDate.getFullYear()))}function De(e){return D.selectedDates.map((function(n){return D.formatDate(n,e)})).filter((function(e,n,t){return"range"!==D.config.mode||D.config.enableTime||t.indexOf(e)===n})).join("range"!==D.config.mode?D.config.conjunction:D.l10n.rangeSeparator)}function we(e){void 0===e&&(e=!0),void 0!==D.mobileInput&&D.mobileFormatStr&&(D.mobileInput.value=void 0!==D.latestSelectedDateObj?D.formatDate(D.latestSelectedDateObj,D.mobileFormatStr):""),D.input.value=De(D.config.dateFormat),void 0!==D.altInput&&(D.altInput.value=De(D.config.altFormat)),!1!==e&&ge("onValueUpdate")}function be(e){var n=m(e),t=D.prevMonthNav.contains(n),a=D.nextMonthNav.contains(n);t||a?z(t?-1:1):D.yearElements.indexOf(n)>=0?n.select():n.classList.contains("arrowUp")?D.changeYear(D.currentYear+1):n.classList.contains("arrowDown")&&D.changeYear(D.currentYear-1)}return function(){D.element=D.input=g,D.isOpen=!1,function(){var n=["wrap","weekNumbers","allowInput","allowInvalidPreload","clickOpens","time_24hr","enableTime","noCalendar","altInput","shorthandCurrentMonth","inline","static","enableSeconds","disableMobile"],i=e(e({},JSON.parse(JSON.stringify(g.dataset||{}))),h),o={};D.config.parseDate=i.parseDate,D.config.formatDate=i.formatDate,Object.defineProperty(D.config,"enable",{get:function(){return D.config._enable},set:function(e){D.config._enable=me(e)}}),Object.defineProperty(D.config,"disable",{get:function(){return D.config._disable},set:function(e){D.config._disable=me(e)}});var r="time"===i.mode;if(!i.dateFormat&&(i.enableTime||r)){var l=E.defaultConfig.dateFormat||a.dateFormat;o.dateFormat=i.noCalendar||r?"H:i"+(i.enableSeconds?":S":""):l+" H:i"+(i.enableSeconds?":S":"")}if(i.altInput&&(i.enableTime||r)&&!i.altFormat){var d=E.defaultConfig.altFormat||a.altFormat;o.altFormat=i.noCalendar||r?"h:i"+(i.enableSeconds?":S K":" K"):d+" h:i"+(i.enableSeconds?":S":"")+" K"}Object.defineProperty(D.config,"minDate",{get:function(){return D.config._minDate},set:ie("min")}),Object.defineProperty(D.config,"maxDate",{get:function(){return D.config._maxDate},set:ie("max")});var s=function(e){return function(n){D.config["min"===e?"_minTime":"_maxTime"]=D.parseDate(n,"H:i:S")}};Object.defineProperty(D.config,"minTime",{get:function(){return D.config._minTime},set:s("min")}),Object.defineProperty(D.config,"maxTime",{get:function(){return D.config._maxTime},set:s("max")}),"time"===i.mode&&(D.config.noCalendar=!0,D.config.enableTime=!0),Object.assign(D.config,o,i);for(var u=0;u<n.length;u++)D.config[n[u]]=!0===D.config[n[u]]||"true"===D.config[n[u]];for(t.filter((function(e){return void 0!==D.config[e]})).forEach((function(e){D.config[e]=c(D.config[e]||[]).map(y)})),D.isMobile=!D.config.disableMobile&&!D.config.inline&&"single"===D.config.mode&&!D.config.disable.length&&!D.config.enable.length&&!D.config.weekNumbers&&/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent),u=0;u<D.config.plugins.length;u++){var f=D.config.plugins[u](D)||{};for(var m in f)t.indexOf(m)>-1?D.config[m]=c(f[m]).map(y).concat(D.config[m]):void 0===i[m]&&(D.config[m]=f[m])}i.altInputClass||(D.config.altInputClass=oe().className+" "+D.config.altInputClass),ge("onParseConfig")}(),re(),D.input=oe(),D.input?(D.input._type=D.input.type,D.input.type="text",D.input.classList.add("flatpickr-input"),D._input=D.input,D.config.altInput&&(D.altInput=s(D.input.nodeName,D.config.altInputClass),D._input=D.altInput,D.altInput.placeholder=D.input.placeholder,D.altInput.disabled=D.input.disabled,D.altInput.required=D.input.required,D.altInput.tabIndex=D.input.tabIndex,D.altInput.type="text",D.input.setAttribute("type","hidden"),!D.config.static&&D.input.parentNode&&D.input.parentNode.insertBefore(D.altInput,D.input.nextSibling)),D.config.allowInput||D._input.setAttribute("readonly","readonly"),D._positionElement=D.config.positionElement||D._input):D.config.errorHandler(new Error("Invalid input element specified")),function(){D.selectedDates=[],D.now=D.parseDate(D.config.now)||new Date;var e=D.config.defaultDate||("INPUT"!==D.input.nodeName&&"TEXTAREA"!==D.input.nodeName||!D.input.placeholder||D.input.value!==D.input.placeholder?D.input.value:null);e&&fe(e,D.config.dateFormat),D._initialDate=D.selectedDates.length>0?D.selectedDates[0]:D.config.minDate&&D.config.minDate.getTime()>D.now.getTime()?D.config.minDate:D.config.maxDate&&D.config.maxDate.getTime()<D.now.getTime()?D.config.maxDate:D.now,D.currentYear=D._initialDate.getFullYear(),D.currentMonth=D._initialDate.getMonth(),D.selectedDates.length>0&&(D.latestSelectedDateObj=D.selectedDates[0]),void 0!==D.config.minTime&&(D.config.minTime=D.parseDate(D.config.minTime,"H:i")),void 0!==D.config.maxTime&&(D.config.maxTime=D.parseDate(D.config.maxTime,"H:i")),D.minDateHasTime=!!D.config.minDate&&(D.config.minDate.getHours()>0||D.config.minDate.getMinutes()>0||D.config.minDate.getSeconds()>0),D.maxDateHasTime=!!D.config.maxDate&&(D.config.maxDate.getHours()>0||D.config.maxDate.getMinutes()>0||D.config.maxDate.getSeconds()>0)}(),D.utils={getDaysInMonth:function(e,n){return void 0===e&&(e=D.currentMonth),void 0===n&&(n=D.currentYear),1===e&&(n%4==0&&n%100!=0||n%400==0)?29:D.l10n.daysInMonth[e]}},D.isMobile||function(){var e=window.document.createDocumentFragment();if(D.calendarContainer=s("div","flatpickr-calendar"),D.calendarContainer.tabIndex=-1,!D.config.noCalendar){if(e.appendChild((D.monthNav=s("div","flatpickr-months"),D.yearElements=[],D.monthElements=[],D.prevMonthNav=s("span","flatpickr-prev-month"),D.prevMonthNav.innerHTML=D.config.prevArrow,D.nextMonthNav=s("span","flatpickr-next-month"),D.nextMonthNav.innerHTML=D.config.nextArrow,U(),Object.defineProperty(D,"_hidePrevMonthArrow",{get:function(){return D.__hidePrevMonthArrow},set:function(e){D.__hidePrevMonthArrow!==e&&(d(D.prevMonthNav,"flatpickr-disabled",e),D.__hidePrevMonthArrow=e)}}),Object.defineProperty(D,"_hideNextMonthArrow",{get:function(){return D.__hideNextMonthArrow},set:function(e){D.__hideNextMonthArrow!==e&&(d(D.nextMonthNav,"flatpickr-disabled",e),D.__hideNextMonthArrow=e)}}),D.currentYearElement=D.yearElements[0],ve(),D.monthNav)),D.innerContainer=s("div","flatpickr-innerContainer"),D.config.weekNumbers){var n=function(){D.calendarContainer.classList.add("hasWeeks");var e=s("div","flatpickr-weekwrapper");e.appendChild(s("span","flatpickr-weekday",D.l10n.weekAbbreviation));var n=s("div","flatpickr-weeks");return e.appendChild(n),{weekWrapper:e,weekNumbers:n}}(),t=n.weekWrapper,a=n.weekNumbers;D.innerContainer.appendChild(t),D.weekNumbers=a,D.weekWrapper=t}D.rContainer=s("div","flatpickr-rContainer"),D.rContainer.appendChild(q()),D.daysContainer||(D.daysContainer=s("div","flatpickr-days"),D.daysContainer.tabIndex=-1),B(),D.rContainer.appendChild(D.daysContainer),D.innerContainer.appendChild(D.rContainer),e.appendChild(D.innerContainer)}D.config.enableTime&&e.appendChild(function(){D.calendarContainer.classList.add("hasTime"),D.config.noCalendar&&D.calendarContainer.classList.add("noCalendar"),D.timeContainer=s("div","flatpickr-time"),D.timeContainer.tabIndex=-1;var e=s("span","flatpickr-time-separator",":"),n=f("flatpickr-hour",{"aria-label":D.l10n.hourAriaLabel});D.hourElement=n.getElementsByTagName("input")[0];var t=f("flatpickr-minute",{"aria-label":D.l10n.minuteAriaLabel});if(D.minuteElement=t.getElementsByTagName("input")[0],D.hourElement.tabIndex=D.minuteElement.tabIndex=-1,D.hourElement.value=o(D.latestSelectedDateObj?D.latestSelectedDateObj.getHours():D.config.time_24hr?D.config.defaultHour:function(e){switch(e%24){case 0:case 12:return 12;default:return e%12}}(D.config.defaultHour)),D.minuteElement.value=o(D.latestSelectedDateObj?D.latestSelectedDateObj.getMinutes():D.config.defaultMinute),D.hourElement.setAttribute("step",D.config.hourIncrement.toString()),D.minuteElement.setAttribute("step",D.config.minuteIncrement.toString()),D.hourElement.setAttribute("min",D.config.time_24hr?"0":"1"),D.hourElement.setAttribute("max",D.config.time_24hr?"23":"12"),D.minuteElement.setAttribute("min","0"),D.minuteElement.setAttribute("max","59"),D.timeContainer.appendChild(n),D.timeContainer.appendChild(e),D.timeContainer.appendChild(t),D.config.time_24hr&&D.timeContainer.classList.add("time24hr"),D.config.enableSeconds){D.timeContainer.classList.add("hasSeconds");var a=f("flatpickr-second");D.secondElement=a.getElementsByTagName("input")[0],D.secondElement.value=o(D.latestSelectedDateObj?D.latestSelectedDateObj.getSeconds():D.config.defaultSeconds),D.secondElement.setAttribute("step",D.minuteElement.getAttribute("step")),D.secondElement.setAttribute("min","0"),D.secondElement.setAttribute("max","59"),D.timeContainer.appendChild(s("span","flatpickr-time-separator",":")),D.timeContainer.appendChild(a)}return D.config.time_24hr||(D.amPM=s("span","flatpickr-am-pm",D.l10n.amPM[r((D.latestSelectedDateObj?D.hourElement.value:D.config.defaultHour)>11)]),D.amPM.title=D.l10n.toggleTitle,D.amPM.tabIndex=-1,D.timeContainer.appendChild(D.amPM)),D.timeContainer}()),d(D.calendarContainer,"rangeMode","range"===D.config.mode),d(D.calendarContainer,"animate",!0===D.config.animate),d(D.calendarContainer,"multiMonth",D.config.showMonths>1),D.calendarContainer.appendChild(e);var i=void 0!==D.config.appendTo&&void 0!==D.config.appendTo.nodeType;if((D.config.inline||D.config.static)&&(D.calendarContainer.classList.add(D.config.inline?"inline":"static"),D.config.inline&&(!i&&D.element.parentNode?D.element.parentNode.insertBefore(D.calendarContainer,D._input.nextSibling):void 0!==D.config.appendTo&&D.config.appendTo.appendChild(D.calendarContainer)),D.config.static)){var l=s("div","flatpickr-wrapper");D.element.parentNode&&D.element.parentNode.insertBefore(l,D.element),l.appendChild(D.element),D.altInput&&l.appendChild(D.altInput),l.appendChild(D.calendarContainer)}D.config.static||D.config.inline||(void 0!==D.config.appendTo?D.config.appendTo:window.document.body).appendChild(D.calendarContainer)}(),function(){if(D.config.wrap&&["open","close","toggle","clear"].forEach((function(e){Array.prototype.forEach.call(D.element.querySelectorAll("[data-"+e+"]"),(function(n){return F(n,"click",D[e])}))})),D.isMobile)!function(){var e=D.config.enableTime?D.config.noCalendar?"time":"datetime-local":"date";D.mobileInput=s("input",D.input.className+" flatpickr-mobile"),D.mobileInput.tabIndex=1,D.mobileInput.type=e,D.mobileInput.disabled=D.input.disabled,D.mobileInput.required=D.input.required,D.mobileInput.placeholder=D.input.placeholder,D.mobileFormatStr="datetime-local"===e?"Y-m-d\\TH:i:S":"date"===e?"Y-m-d":"H:i:S",D.selectedDates.length>0&&(D.mobileInput.defaultValue=D.mobileInput.value=D.formatDate(D.selectedDates[0],D.mobileFormatStr)),D.config.minDate&&(D.mobileInput.min=D.formatDate(D.config.minDate,"Y-m-d")),D.config.maxDate&&(D.mobileInput.max=D.formatDate(D.config.maxDate,"Y-m-d")),D.input.getAttribute("step")&&(D.mobileInput.step=String(D.input.getAttribute("step"))),D.input.type="hidden",void 0!==D.altInput&&(D.altInput.type="hidden");try{D.input.parentNode&&D.input.parentNode.insertBefore(D.mobileInput,D.input.nextSibling)}catch(e){}F(D.mobileInput,"change",(function(e){D.setDate(m(e).value,!1,D.mobileFormatStr),ge("onChange"),ge("onClose")}))}();else{var e=l(ae,50);if(D._debouncedChange=l(N,300),D.daysContainer&&!/iPhone|iPad|iPod/i.test(navigator.userAgent)&&F(D.daysContainer,"mouseover",(function(e){"range"===D.config.mode&&te(m(e))})),F(window.document.body,"keydown",ne),D.config.inline||D.config.static||F(window,"resize",e),void 0!==window.ontouchstart?F(window.document,"touchstart",V):F(window.document,"click",V),F(window.document,"focus",V,{capture:!0}),!0===D.config.clickOpens&&(F(D._input,"focus",D.open),F(D._input,"click",D.open)),void 0!==D.daysContainer&&(F(D.monthNav,"click",be),F(D.monthNav,["keyup","increment"],O),F(D.daysContainer,"click",se)),void 0!==D.timeContainer&&void 0!==D.minuteElement&&void 0!==D.hourElement){var n=function(e){return m(e).select()};F(D.timeContainer,["increment"],k),F(D.timeContainer,"blur",k,{capture:!0}),F(D.timeContainer,"click",P),F([D.hourElement,D.minuteElement],["focus","click"],n),void 0!==D.secondElement&&F(D.secondElement,"focus",(function(){return D.secondElement&&D.secondElement.select()})),void 0!==D.amPM&&F(D.amPM,"click",(function(e){k(e),N()}))}D.config.allowInput&&F(D._input,"blur",ee)}}(),(D.selectedDates.length||D.config.noCalendar)&&(D.config.enableTime&&I(D.config.noCalendar?D.latestSelectedDateObj||D.config.minDate:void 0),we(!1)),x();var n=/^((?!chrome|android).)*safari/i.test(navigator.userAgent);!D.isMobile&&n&&le(),ge("onReady")}(),D}function x(e,n){for(var t=Array.prototype.slice.call(e).filter((function(e){return e instanceof HTMLElement})),a=[],i=0;i<t.length;i++){var o=t[i];try{if(null!==o.getAttribute("data-fp-omit"))continue;void 0!==o._flatpickr&&(o._flatpickr.destroy(),o._flatpickr=void 0),o._flatpickr=y(o,n||{}),a.push(o._flatpickr)}catch(e){console.error(e)}}return 1===a.length?a[0]:a}"function"!=typeof Object.assign&&(Object.assign=function(e){for(var n=[],t=1;t<arguments.length;t++)n[t-1]=arguments[t];if(!e)throw TypeError("Cannot convert undefined or null to object");for(var a=function(n){n&&Object.keys(n).forEach((function(t){return e[t]=n[t]}))},i=0,o=n;i<o.length;i++){var r=o[i];a(r)}return e}),"undefined"!=typeof HTMLElement&&"undefined"!=typeof HTMLCollection&&"undefined"!=typeof NodeList&&(HTMLCollection.prototype.flatpickr=NodeList.prototype.flatpickr=function(e){return x(this,e)},HTMLElement.prototype.flatpickr=function(e){return x([this],e)});var E=function(e,n){return"string"==typeof e?x(window.document.querySelectorAll(e),n):e instanceof Node?x([e],n):x(e,n)};return E.defaultConfig={},E.l10ns={en:e({},i),default:e({},i)},E.localize=function(n){E.l10ns.default=e(e({},E.l10ns.default),n)},E.setDefaults=function(n){E.defaultConfig=e(e({},E.defaultConfig),n)},E.parseDate=b({}),E.formatDate=w({}),E.compareDates=C,"undefined"!=typeof jQuery&&void 0!==jQuery.fn&&(jQuery.fn.flatpickr=function(e){return x(this,e)}),Date.prototype.fp_incr=function(e){return new Date(this.getFullYear(),this.getMonth(),this.getDate()+("string"==typeof e?parseInt(e,10):e))},"undefined"!=typeof window&&(window.flatpickr=E),E},"object"==typeof t&&void 0!==n?n.exports=r():"function"==typeof define&&define.amd?define(r):(o=o||self).flatpickr=r()},
540: function _(n,t,e,a,r){a();e.default='\n.flatpickr-calendar {\n  background: transparent;\n  opacity: 0;\n  display: none;\n  text-align: center;\n  visibility: hidden;\n  padding: 0;\n  -webkit-animation: none;\n  animation: none;\n  direction: ltr;\n  border: 0;\n  font-size: 14px;\n  line-height: 24px;\n  border-radius: 5px;\n  position: absolute;\n  width: 307.875px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  -ms-touch-action: manipulation;\n  touch-action: manipulation;\n  background: #fff;\n  -webkit-box-shadow: 1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, 0.08);\n  box-shadow: 1px 0 0 #e6e6e6, -1px 0 0 #e6e6e6, 0 1px 0 #e6e6e6, 0 -1px 0 #e6e6e6, 0 3px 13px rgba(0, 0, 0, 0.08);\n}\n.flatpickr-calendar.open,\n.flatpickr-calendar.inline {\n  opacity: 1;\n  max-height: 640px;\n  visibility: visible;\n}\n.flatpickr-calendar.open {\n  display: inline-block;\n  z-index: 99999;\n}\n.flatpickr-calendar.animate.open {\n  -webkit-animation: fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);\n  animation: fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);\n}\n.flatpickr-calendar.inline {\n  display: block;\n  position: relative;\n  top: 2px;\n}\n.flatpickr-calendar.static {\n  position: absolute;\n  top: calc(100% + 2px);\n}\n.flatpickr-calendar.static.open {\n  z-index: 999;\n  display: block;\n}\n.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+1) .flatpickr-day.inRange:nth-child(7n+7) {\n  -webkit-box-shadow: none !important;\n  box-shadow: none !important;\n}\n.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+2) .flatpickr-day.inRange:nth-child(7n+1) {\n  -webkit-box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n  box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n}\n.flatpickr-calendar .hasWeeks .dayContainer,\n.flatpickr-calendar .hasTime .dayContainer {\n  border-bottom: 0;\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0;\n}\n.flatpickr-calendar .hasWeeks .dayContainer {\n  border-left: 0;\n}\n.flatpickr-calendar.hasTime .flatpickr-time {\n  height: 40px;\n  border-top: 1px solid #e6e6e6;\n}\n.flatpickr-calendar.noCalendar.hasTime .flatpickr-time {\n  height: auto;\n}\n.flatpickr-calendar:before,\n.flatpickr-calendar:after {\n  position: absolute;\n  display: block;\n  pointer-events: none;\n  border: solid transparent;\n  content: \'\';\n  height: 0;\n  width: 0;\n  left: 22px;\n}\n.flatpickr-calendar.rightMost:before,\n.flatpickr-calendar.arrowRight:before,\n.flatpickr-calendar.rightMost:after,\n.flatpickr-calendar.arrowRight:after {\n  left: auto;\n  right: 22px;\n}\n.flatpickr-calendar.arrowCenter:before,\n.flatpickr-calendar.arrowCenter:after {\n  left: 50%;\n  right: 50%;\n}\n.flatpickr-calendar:before {\n  border-width: 5px;\n  margin: 0 -5px;\n}\n.flatpickr-calendar:after {\n  border-width: 4px;\n  margin: 0 -4px;\n}\n.flatpickr-calendar.arrowTop:before,\n.flatpickr-calendar.arrowTop:after {\n  bottom: 100%;\n}\n.flatpickr-calendar.arrowTop:before {\n  border-bottom-color: #e6e6e6;\n}\n.flatpickr-calendar.arrowTop:after {\n  border-bottom-color: #fff;\n}\n.flatpickr-calendar.arrowBottom:before,\n.flatpickr-calendar.arrowBottom:after {\n  top: 100%;\n}\n.flatpickr-calendar.arrowBottom:before {\n  border-top-color: #e6e6e6;\n}\n.flatpickr-calendar.arrowBottom:after {\n  border-top-color: #fff;\n}\n.flatpickr-calendar:focus {\n  outline: 0;\n}\n.flatpickr-wrapper {\n  position: relative;\n  display: inline-block;\n}\n.flatpickr-months {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n}\n.flatpickr-months .flatpickr-month {\n  background: transparent;\n  color: rgba(0, 0, 0, 0.9);\n  fill: rgba(0, 0, 0, 0.9);\n  height: 34px;\n  line-height: 1;\n  text-align: center;\n  position: relative;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  overflow: hidden;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n}\n.flatpickr-months .flatpickr-prev-month,\n.flatpickr-months .flatpickr-next-month {\n  text-decoration: none;\n  cursor: pointer;\n  position: absolute;\n  top: 0;\n  height: 34px;\n  padding: 10px;\n  z-index: 3;\n  color: rgba(0, 0, 0, 0.9);\n  fill: rgba(0, 0, 0, 0.9);\n}\n.flatpickr-months .flatpickr-prev-month.flatpickr-disabled,\n.flatpickr-months .flatpickr-next-month.flatpickr-disabled {\n  display: none;\n}\n.flatpickr-months .flatpickr-prev-month i,\n.flatpickr-months .flatpickr-next-month i {\n  position: relative;\n}\n.flatpickr-months .flatpickr-prev-month.flatpickr-prev-month,\n.flatpickr-months .flatpickr-next-month.flatpickr-prev-month {\n  /*\n      /*rtl:begin:ignore*/\n  /*\n      */\n  left: 0;\n  /*\n      /*rtl:end:ignore*/\n  /*\n      */\n}\n/*\n      /*rtl:begin:ignore*/\n/*\n      /*rtl:end:ignore*/\n.flatpickr-months .flatpickr-prev-month.flatpickr-next-month,\n.flatpickr-months .flatpickr-next-month.flatpickr-next-month {\n  /*\n      /*rtl:begin:ignore*/\n  /*\n      */\n  right: 0;\n  /*\n      /*rtl:end:ignore*/\n  /*\n      */\n}\n/*\n      /*rtl:begin:ignore*/\n/*\n      /*rtl:end:ignore*/\n.flatpickr-months .flatpickr-prev-month:hover,\n.flatpickr-months .flatpickr-next-month:hover {\n  color: #959ea9;\n}\n.flatpickr-months .flatpickr-prev-month:hover svg,\n.flatpickr-months .flatpickr-next-month:hover svg {\n  fill: #f64747;\n}\n.flatpickr-months .flatpickr-prev-month svg,\n.flatpickr-months .flatpickr-next-month svg {\n  width: 14px;\n  height: 14px;\n}\n.flatpickr-months .flatpickr-prev-month svg path,\n.flatpickr-months .flatpickr-next-month svg path {\n  -webkit-transition: fill 0.1s;\n  transition: fill 0.1s;\n  fill: inherit;\n}\n.numInputWrapper {\n  position: relative;\n  height: auto;\n}\n.numInputWrapper input,\n.numInputWrapper span {\n  display: inline-block;\n}\n.numInputWrapper input {\n  width: 100%;\n}\n.numInputWrapper input::-ms-clear {\n  display: none;\n}\n.numInputWrapper input::-webkit-outer-spin-button,\n.numInputWrapper input::-webkit-inner-spin-button {\n  margin: 0;\n  -webkit-appearance: none;\n}\n.numInputWrapper span {\n  position: absolute;\n  right: 0;\n  width: 14px;\n  padding: 0 4px 0 2px;\n  height: 50%;\n  line-height: 50%;\n  opacity: 0;\n  cursor: pointer;\n  border: 1px solid rgba(57, 57, 57, 0.15);\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.numInputWrapper span:hover {\n  background: rgba(0, 0, 0, 0.1);\n}\n.numInputWrapper span:active {\n  background: rgba(0, 0, 0, 0.2);\n}\n.numInputWrapper span:after {\n  display: block;\n  content: "";\n  position: absolute;\n}\n.numInputWrapper span.arrowUp {\n  top: 0;\n  border-bottom: 0;\n}\n.numInputWrapper span.arrowUp:after {\n  border-left: 4px solid transparent;\n  border-right: 4px solid transparent;\n  border-bottom: 4px solid rgba(57, 57, 57, 0.6);\n  top: 26%;\n}\n.numInputWrapper span.arrowDown {\n  top: 50%;\n}\n.numInputWrapper span.arrowDown:after {\n  border-left: 4px solid transparent;\n  border-right: 4px solid transparent;\n  border-top: 4px solid rgba(57, 57, 57, 0.6);\n  top: 40%;\n}\n.numInputWrapper span svg {\n  width: inherit;\n  height: auto;\n}\n.numInputWrapper span svg path {\n  fill: rgba(0, 0, 0, 0.5);\n}\n.numInputWrapper:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.numInputWrapper:hover span {\n  opacity: 1;\n}\n.flatpickr-current-month {\n  font-size: 135%;\n  line-height: inherit;\n  font-weight: 300;\n  color: inherit;\n  position: absolute;\n  width: 75%;\n  left: 12.5%;\n  padding: 7.48px 0 0 0;\n  line-height: 1;\n  height: 34px;\n  display: inline-block;\n  text-align: center;\n  -webkit-transform: translate3d(0px, 0px, 0px);\n  transform: translate3d(0px, 0px, 0px);\n}\n.flatpickr-current-month span.cur-month {\n  font-family: inherit;\n  font-weight: 700;\n  color: inherit;\n  display: inline-block;\n  margin-left: 0.5ch;\n  padding: 0;\n}\n.flatpickr-current-month span.cur-month:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.flatpickr-current-month .numInputWrapper {\n  width: 6ch;\n  width: 7ch\0;\n  display: inline-block;\n}\n.flatpickr-current-month .numInputWrapper span.arrowUp:after {\n  border-bottom-color: rgba(0, 0, 0, 0.9);\n}\n.flatpickr-current-month .numInputWrapper span.arrowDown:after {\n  border-top-color: rgba(0, 0, 0, 0.9);\n}\n.flatpickr-current-month input.cur-year {\n  background: transparent;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  color: inherit;\n  cursor: text;\n  padding: 0 0 0 0.5ch;\n  margin: 0;\n  display: inline-block;\n  font-size: inherit;\n  font-family: inherit;\n  font-weight: 300;\n  line-height: inherit;\n  height: auto;\n  border: 0;\n  border-radius: 0;\n  vertical-align: initial;\n  -webkit-appearance: textfield;\n  -moz-appearance: textfield;\n  appearance: textfield;\n}\n.flatpickr-current-month input.cur-year:focus {\n  outline: 0;\n}\n.flatpickr-current-month input.cur-year[disabled],\n.flatpickr-current-month input.cur-year[disabled]:hover {\n  font-size: 100%;\n  color: rgba(0, 0, 0, 0.5);\n  background: transparent;\n  pointer-events: none;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months {\n  appearance: menulist;\n  background: transparent;\n  border: none;\n  border-radius: 0;\n  box-sizing: border-box;\n  color: inherit;\n  cursor: pointer;\n  font-size: inherit;\n  font-family: inherit;\n  font-weight: 300;\n  height: auto;\n  line-height: inherit;\n  margin: -1px 0 0 0;\n  outline: none;\n  padding: 0 0 0 0.5ch;\n  position: relative;\n  vertical-align: initial;\n  -webkit-box-sizing: border-box;\n  -webkit-appearance: menulist;\n  -moz-appearance: menulist;\n  width: auto;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months:focus,\n.flatpickr-current-month .flatpickr-monthDropdown-months:active {\n  outline: none;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months .flatpickr-monthDropdown-month {\n  background-color: transparent;\n  outline: none;\n  padding: 0;\n}\n.flatpickr-weekdays {\n  background: transparent;\n  text-align: center;\n  overflow: hidden;\n  width: 100%;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -webkit-align-items: center;\n  -ms-flex-align: center;\n  align-items: center;\n  height: 28px;\n}\n.flatpickr-weekdays .flatpickr-weekdaycontainer {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n}\nspan.flatpickr-weekday {\n  cursor: default;\n  font-size: 90%;\n  background: transparent;\n  color: rgba(0, 0, 0, 0.54);\n  line-height: 1;\n  margin: 0;\n  text-align: center;\n  display: block;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  font-weight: bolder;\n}\n.dayContainer,\n.flatpickr-weeks {\n  padding: 1px 0 0 0;\n}\n.flatpickr-days {\n  position: relative;\n  overflow: hidden;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: start;\n  -webkit-align-items: flex-start;\n  -ms-flex-align: start;\n  align-items: flex-start;\n  width: 307.875px;\n}\n.flatpickr-days:focus {\n  outline: 0;\n}\n.dayContainer {\n  padding: 0;\n  outline: 0;\n  text-align: left;\n  width: 307.875px;\n  min-width: 307.875px;\n  max-width: 307.875px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  display: inline-block;\n  display: -ms-flexbox;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: flex;\n  -webkit-flex-wrap: wrap;\n  flex-wrap: wrap;\n  -ms-flex-wrap: wrap;\n  -ms-flex-pack: justify;\n  -webkit-justify-content: space-around;\n  justify-content: space-around;\n  -webkit-transform: translate3d(0px, 0px, 0px);\n  transform: translate3d(0px, 0px, 0px);\n  opacity: 1;\n}\n.dayContainer + .dayContainer {\n  -webkit-box-shadow: -1px 0 0 #e6e6e6;\n  box-shadow: -1px 0 0 #e6e6e6;\n}\n.flatpickr-day {\n  background: none;\n  border: 1px solid transparent;\n  border-radius: 150px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  color: #393939;\n  cursor: pointer;\n  font-weight: 400;\n  width: 14.2857143%;\n  -webkit-flex-basis: 14.2857143%;\n  -ms-flex-preferred-size: 14.2857143%;\n  flex-basis: 14.2857143%;\n  max-width: 39px;\n  height: 39px;\n  line-height: 39px;\n  margin: 0;\n  display: inline-block;\n  position: relative;\n  -webkit-box-pack: center;\n  -webkit-justify-content: center;\n  -ms-flex-pack: center;\n  justify-content: center;\n  text-align: center;\n}\n.flatpickr-day.inRange,\n.flatpickr-day.prevMonthDay.inRange,\n.flatpickr-day.nextMonthDay.inRange,\n.flatpickr-day.today.inRange,\n.flatpickr-day.prevMonthDay.today.inRange,\n.flatpickr-day.nextMonthDay.today.inRange,\n.flatpickr-day:hover,\n.flatpickr-day.prevMonthDay:hover,\n.flatpickr-day.nextMonthDay:hover,\n.flatpickr-day:focus,\n.flatpickr-day.prevMonthDay:focus,\n.flatpickr-day.nextMonthDay:focus {\n  cursor: pointer;\n  outline: 0;\n  background: #e6e6e6;\n  border-color: #e6e6e6;\n}\n.flatpickr-day.today {\n  border-color: #959ea9;\n}\n.flatpickr-day.today:hover,\n.flatpickr-day.today:focus {\n  border-color: #959ea9;\n  background: #959ea9;\n  color: #fff;\n}\n.flatpickr-day.selected,\n.flatpickr-day.startRange,\n.flatpickr-day.endRange,\n.flatpickr-day.selected.inRange,\n.flatpickr-day.startRange.inRange,\n.flatpickr-day.endRange.inRange,\n.flatpickr-day.selected:focus,\n.flatpickr-day.startRange:focus,\n.flatpickr-day.endRange:focus,\n.flatpickr-day.selected:hover,\n.flatpickr-day.startRange:hover,\n.flatpickr-day.endRange:hover,\n.flatpickr-day.selected.prevMonthDay,\n.flatpickr-day.startRange.prevMonthDay,\n.flatpickr-day.endRange.prevMonthDay,\n.flatpickr-day.selected.nextMonthDay,\n.flatpickr-day.startRange.nextMonthDay,\n.flatpickr-day.endRange.nextMonthDay {\n  background: #569ff7;\n  -webkit-box-shadow: none;\n  box-shadow: none;\n  color: #fff;\n  border-color: #569ff7;\n}\n.flatpickr-day.selected.startRange,\n.flatpickr-day.startRange.startRange,\n.flatpickr-day.endRange.startRange {\n  border-radius: 50px 0 0 50px;\n}\n.flatpickr-day.selected.endRange,\n.flatpickr-day.startRange.endRange,\n.flatpickr-day.endRange.endRange {\n  border-radius: 0 50px 50px 0;\n}\n.flatpickr-day.selected.startRange + .endRange:not(:nth-child(7n+1)),\n.flatpickr-day.startRange.startRange + .endRange:not(:nth-child(7n+1)),\n.flatpickr-day.endRange.startRange + .endRange:not(:nth-child(7n+1)) {\n  -webkit-box-shadow: -10px 0 0 #569ff7;\n  box-shadow: -10px 0 0 #569ff7;\n}\n.flatpickr-day.selected.startRange.endRange,\n.flatpickr-day.startRange.startRange.endRange,\n.flatpickr-day.endRange.startRange.endRange {\n  border-radius: 50px;\n}\n.flatpickr-day.inRange {\n  border-radius: 0;\n  -webkit-box-shadow: -5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n  box-shadow: -5px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n}\n.flatpickr-day.flatpickr-disabled,\n.flatpickr-day.flatpickr-disabled:hover,\n.flatpickr-day.prevMonthDay,\n.flatpickr-day.nextMonthDay,\n.flatpickr-day.notAllowed,\n.flatpickr-day.notAllowed.prevMonthDay,\n.flatpickr-day.notAllowed.nextMonthDay {\n  color: rgba(57, 57, 57, 0.3);\n  background: transparent;\n  border-color: transparent;\n  cursor: default;\n}\n.flatpickr-day.flatpickr-disabled,\n.flatpickr-day.flatpickr-disabled:hover {\n  cursor: not-allowed;\n  color: rgba(57, 57, 57, 0.1);\n}\n.flatpickr-day.week.selected {\n  border-radius: 0;\n  -webkit-box-shadow: -5px 0 0 #569ff7, 5px 0 0 #569ff7;\n  box-shadow: -5px 0 0 #569ff7, 5px 0 0 #569ff7;\n}\n.flatpickr-day.hidden {\n  visibility: hidden;\n}\n.rangeMode .flatpickr-day {\n  margin-top: 1px;\n}\n.flatpickr-weekwrapper {\n  float: left;\n}\n.flatpickr-weekwrapper .flatpickr-weeks {\n  padding: 0 12px;\n  -webkit-box-shadow: 1px 0 0 #e6e6e6;\n  box-shadow: 1px 0 0 #e6e6e6;\n}\n.flatpickr-weekwrapper .flatpickr-weekday {\n  float: none;\n  width: 100%;\n  line-height: 28px;\n}\n.flatpickr-weekwrapper span.flatpickr-day,\n.flatpickr-weekwrapper span.flatpickr-day:hover {\n  display: block;\n  width: 100%;\n  max-width: none;\n  color: rgba(57, 57, 57, 0.3);\n  background: transparent;\n  cursor: default;\n  border: none;\n}\n.flatpickr-innerContainer {\n  display: block;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  overflow: hidden;\n}\n.flatpickr-rContainer {\n  display: inline-block;\n  padding: 0;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.flatpickr-time {\n  text-align: center;\n  outline: 0;\n  display: block;\n  height: 0;\n  line-height: 40px;\n  max-height: 40px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  overflow: hidden;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n}\n.flatpickr-time:after {\n  content: "";\n  display: table;\n  clear: both;\n}\n.flatpickr-time .numInputWrapper {\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  width: 40%;\n  height: 40px;\n  float: left;\n}\n.flatpickr-time .numInputWrapper span.arrowUp:after {\n  border-bottom-color: #393939;\n}\n.flatpickr-time .numInputWrapper span.arrowDown:after {\n  border-top-color: #393939;\n}\n.flatpickr-time.hasSeconds .numInputWrapper {\n  width: 26%;\n}\n.flatpickr-time.time24hr .numInputWrapper {\n  width: 49%;\n}\n.flatpickr-time input {\n  background: transparent;\n  -webkit-box-shadow: none;\n  box-shadow: none;\n  border: 0;\n  border-radius: 0;\n  text-align: center;\n  margin: 0;\n  padding: 0;\n  height: inherit;\n  line-height: inherit;\n  color: #393939;\n  font-size: 14px;\n  position: relative;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  -webkit-appearance: textfield;\n  -moz-appearance: textfield;\n  appearance: textfield;\n}\n.flatpickr-time input.flatpickr-hour {\n  font-weight: bold;\n}\n.flatpickr-time input.flatpickr-minute,\n.flatpickr-time input.flatpickr-second {\n  font-weight: 400;\n}\n.flatpickr-time input:focus {\n  outline: 0;\n  border: 0;\n}\n.flatpickr-time .flatpickr-time-separator,\n.flatpickr-time .flatpickr-am-pm {\n  height: inherit;\n  float: left;\n  line-height: inherit;\n  color: #393939;\n  font-weight: bold;\n  width: 2%;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  -webkit-align-self: center;\n  -ms-flex-item-align: center;\n  align-self: center;\n}\n.flatpickr-time .flatpickr-am-pm {\n  outline: 0;\n  width: 18%;\n  cursor: pointer;\n  text-align: center;\n  font-weight: 400;\n}\n.flatpickr-time input:hover,\n.flatpickr-time .flatpickr-am-pm:hover,\n.flatpickr-time input:focus,\n.flatpickr-time .flatpickr-am-pm:focus {\n  background: #eee;\n}\n.flatpickr-input[readonly] {\n  cursor: pointer;\n}\n@-webkit-keyframes fpFadeInDown {\n  from {\n    opacity: 0;\n    -webkit-transform: translate3d(0, -20px, 0);\n    transform: translate3d(0, -20px, 0);\n  }\n  to {\n    opacity: 1;\n    -webkit-transform: translate3d(0, 0, 0);\n    transform: translate3d(0, 0, 0);\n  }\n}\n@keyframes fpFadeInDown {\n  from {\n    opacity: 0;\n    -webkit-transform: translate3d(0, -20px, 0);\n    transform: translate3d(0, -20px, 0);\n  }\n  to {\n    opacity: 1;\n    -webkit-transform: translate3d(0, 0, 0);\n    transform: translate3d(0, 0, 0);\n  }\n}\n.flatpickr-calendar {\n  background: transparent;\n  opacity: 0;\n  display: none;\n  text-align: center;\n  visibility: hidden;\n  padding: 0;\n  -webkit-animation: none;\n  animation: none;\n  direction: ltr;\n  border: 0;\n  font-size: 14px;\n  line-height: 24px;\n  border-radius: 5px;\n  position: absolute;\n  width: 307.875px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  -ms-touch-action: manipulation;\n  touch-action: manipulation;\n  -webkit-box-shadow: 0 3px 13px rgba(0, 0, 0, 0.08);\n  box-shadow: 0 3px 13px rgba(0, 0, 0, 0.08);\n}\n.flatpickr-calendar.open,\n.flatpickr-calendar.inline {\n  opacity: 1;\n  max-height: 640px;\n  visibility: visible;\n}\n.flatpickr-calendar.open {\n  display: inline-block;\n  z-index: 99999;\n}\n.flatpickr-calendar.animate.open {\n  -webkit-animation: fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);\n  animation: fpFadeInDown 300ms cubic-bezier(0.23, 1, 0.32, 1);\n}\n.flatpickr-calendar.inline {\n  display: block;\n  position: relative;\n  top: 2px;\n}\n.flatpickr-calendar.static {\n  position: absolute;\n  top: calc(100% + 2px);\n}\n.flatpickr-calendar.static.open {\n  z-index: 999;\n  display: block;\n}\n.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+1) .flatpickr-day.inRange:nth-child(7n+7) {\n  -webkit-box-shadow: none !important;\n  box-shadow: none !important;\n}\n.flatpickr-calendar.multiMonth .flatpickr-days .dayContainer:nth-child(n+2) .flatpickr-day.inRange:nth-child(7n+1) {\n  -webkit-box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n  box-shadow: -2px 0 0 #e6e6e6, 5px 0 0 #e6e6e6;\n}\n.flatpickr-calendar .hasWeeks .dayContainer,\n.flatpickr-calendar .hasTime .dayContainer {\n  border-bottom: 0;\n  border-bottom-right-radius: 0;\n  border-bottom-left-radius: 0;\n}\n.flatpickr-calendar .hasWeeks .dayContainer {\n  border-left: 0;\n}\n.flatpickr-calendar.hasTime .flatpickr-time {\n  height: 40px;\n  border-top: 1px solid #eceef1;\n}\n.flatpickr-calendar.hasTime .flatpickr-innerContainer {\n  border-bottom: 0;\n}\n.flatpickr-calendar.hasTime .flatpickr-time {\n  border: 1px solid #eceef1;\n}\n.flatpickr-calendar.noCalendar.hasTime .flatpickr-time {\n  height: auto;\n}\n.flatpickr-calendar:before,\n.flatpickr-calendar:after {\n  position: absolute;\n  display: block;\n  pointer-events: none;\n  border: solid transparent;\n  content: \'\';\n  height: 0;\n  width: 0;\n  left: 22px;\n}\n.flatpickr-calendar.rightMost:before,\n.flatpickr-calendar.arrowRight:before,\n.flatpickr-calendar.rightMost:after,\n.flatpickr-calendar.arrowRight:after {\n  left: auto;\n  right: 22px;\n}\n.flatpickr-calendar.arrowCenter:before,\n.flatpickr-calendar.arrowCenter:after {\n  left: 50%;\n  right: 50%;\n}\n.flatpickr-calendar:before {\n  border-width: 5px;\n  margin: 0 -5px;\n}\n.flatpickr-calendar:after {\n  border-width: 4px;\n  margin: 0 -4px;\n}\n.flatpickr-calendar.arrowTop:before,\n.flatpickr-calendar.arrowTop:after {\n  bottom: 100%;\n}\n.flatpickr-calendar.arrowTop:before {\n  border-bottom-color: #eceef1;\n}\n.flatpickr-calendar.arrowTop:after {\n  border-bottom-color: #eceef1;\n}\n.flatpickr-calendar.arrowBottom:before,\n.flatpickr-calendar.arrowBottom:after {\n  top: 100%;\n}\n.flatpickr-calendar.arrowBottom:before {\n  border-top-color: #eceef1;\n}\n.flatpickr-calendar.arrowBottom:after {\n  border-top-color: #eceef1;\n}\n.flatpickr-calendar:focus {\n  outline: 0;\n}\n.flatpickr-wrapper {\n  position: relative;\n  display: inline-block;\n}\n.flatpickr-months {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n}\n.flatpickr-months .flatpickr-month {\n  border-radius: 5px 5px 0 0;\n  background: #eceef1;\n  color: #5a6171;\n  fill: #5a6171;\n  height: 34px;\n  line-height: 1;\n  text-align: center;\n  position: relative;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  overflow: hidden;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n}\n.flatpickr-months .flatpickr-prev-month,\n.flatpickr-months .flatpickr-next-month {\n  text-decoration: none;\n  cursor: pointer;\n  position: absolute;\n  top: 0;\n  height: 34px;\n  padding: 10px;\n  z-index: 3;\n  color: #5a6171;\n  fill: #5a6171;\n}\n.flatpickr-months .flatpickr-prev-month.flatpickr-disabled,\n.flatpickr-months .flatpickr-next-month.flatpickr-disabled {\n  display: none;\n}\n.flatpickr-months .flatpickr-prev-month i,\n.flatpickr-months .flatpickr-next-month i {\n  position: relative;\n}\n.flatpickr-months .flatpickr-prev-month.flatpickr-prev-month,\n.flatpickr-months .flatpickr-next-month.flatpickr-prev-month {\n  /*\n      /*rtl:begin:ignore*/\n  /*\n      */\n  left: 0;\n  /*\n      /*rtl:end:ignore*/\n  /*\n      */\n}\n/*\n      /*rtl:begin:ignore*/\n/*\n      /*rtl:end:ignore*/\n.flatpickr-months .flatpickr-prev-month.flatpickr-next-month,\n.flatpickr-months .flatpickr-next-month.flatpickr-next-month {\n  /*\n      /*rtl:begin:ignore*/\n  /*\n      */\n  right: 0;\n  /*\n      /*rtl:end:ignore*/\n  /*\n      */\n}\n/*\n      /*rtl:begin:ignore*/\n/*\n      /*rtl:end:ignore*/\n.flatpickr-months .flatpickr-prev-month:hover,\n.flatpickr-months .flatpickr-next-month:hover {\n  color: #bbb;\n}\n.flatpickr-months .flatpickr-prev-month:hover svg,\n.flatpickr-months .flatpickr-next-month:hover svg {\n  fill: #f64747;\n}\n.flatpickr-months .flatpickr-prev-month svg,\n.flatpickr-months .flatpickr-next-month svg {\n  width: 14px;\n  height: 14px;\n}\n.flatpickr-months .flatpickr-prev-month svg path,\n.flatpickr-months .flatpickr-next-month svg path {\n  -webkit-transition: fill 0.1s;\n  transition: fill 0.1s;\n  fill: inherit;\n}\n.numInputWrapper {\n  position: relative;\n  height: auto;\n}\n.numInputWrapper input,\n.numInputWrapper span {\n  display: inline-block;\n}\n.numInputWrapper input {\n  width: 100%;\n}\n.numInputWrapper input::-ms-clear {\n  display: none;\n}\n.numInputWrapper input::-webkit-outer-spin-button,\n.numInputWrapper input::-webkit-inner-spin-button {\n  margin: 0;\n  -webkit-appearance: none;\n}\n.numInputWrapper span {\n  position: absolute;\n  right: 0;\n  width: 14px;\n  padding: 0 4px 0 2px;\n  height: 50%;\n  line-height: 50%;\n  opacity: 0;\n  cursor: pointer;\n  border: 1px solid rgba(72, 72, 72, 0.15);\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.numInputWrapper span:hover {\n  background: rgba(0, 0, 0, 0.1);\n}\n.numInputWrapper span:active {\n  background: rgba(0, 0, 0, 0.2);\n}\n.numInputWrapper span:after {\n  display: block;\n  content: "";\n  position: absolute;\n}\n.numInputWrapper span.arrowUp {\n  top: 0;\n  border-bottom: 0;\n}\n.numInputWrapper span.arrowUp:after {\n  border-left: 4px solid transparent;\n  border-right: 4px solid transparent;\n  border-bottom: 4px solid rgba(72, 72, 72, 0.6);\n  top: 26%;\n}\n.numInputWrapper span.arrowDown {\n  top: 50%;\n}\n.numInputWrapper span.arrowDown:after {\n  border-left: 4px solid transparent;\n  border-right: 4px solid transparent;\n  border-top: 4px solid rgba(72, 72, 72, 0.6);\n  top: 40%;\n}\n.numInputWrapper span svg {\n  width: inherit;\n  height: auto;\n}\n.numInputWrapper span svg path {\n  fill: rgba(90, 97, 113, 0.5);\n}\n.numInputWrapper:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.numInputWrapper:hover span {\n  opacity: 1;\n}\n.flatpickr-current-month {\n  font-size: 135%;\n  line-height: inherit;\n  font-weight: 300;\n  color: inherit;\n  position: absolute;\n  width: 75%;\n  left: 12.5%;\n  padding: 7.48px 0 0 0;\n  line-height: 1;\n  height: 34px;\n  display: inline-block;\n  text-align: center;\n  -webkit-transform: translate3d(0px, 0px, 0px);\n  transform: translate3d(0px, 0px, 0px);\n}\n.flatpickr-current-month span.cur-month {\n  font-family: inherit;\n  font-weight: 700;\n  color: inherit;\n  display: inline-block;\n  margin-left: 0.5ch;\n  padding: 0;\n}\n.flatpickr-current-month span.cur-month:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.flatpickr-current-month .numInputWrapper {\n  width: 6ch;\n  width: 7ch\0;\n  display: inline-block;\n}\n.flatpickr-current-month .numInputWrapper span.arrowUp:after {\n  border-bottom-color: #5a6171;\n}\n.flatpickr-current-month .numInputWrapper span.arrowDown:after {\n  border-top-color: #5a6171;\n}\n.flatpickr-current-month input.cur-year {\n  background: transparent;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  color: inherit;\n  cursor: text;\n  padding: 0 0 0 0.5ch;\n  margin: 0;\n  display: inline-block;\n  font-size: inherit;\n  font-family: inherit;\n  font-weight: 300;\n  line-height: inherit;\n  height: auto;\n  border: 0;\n  border-radius: 0;\n  vertical-align: initial;\n  -webkit-appearance: textfield;\n  -moz-appearance: textfield;\n  appearance: textfield;\n}\n.flatpickr-current-month input.cur-year:focus {\n  outline: 0;\n}\n.flatpickr-current-month input.cur-year[disabled],\n.flatpickr-current-month input.cur-year[disabled]:hover {\n  font-size: 100%;\n  color: rgba(90, 97, 113, 0.5);\n  background: transparent;\n  pointer-events: none;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months {\n  appearance: menulist;\n  background: #eceef1;\n  border: none;\n  border-radius: 0;\n  box-sizing: border-box;\n  color: inherit;\n  cursor: pointer;\n  font-size: inherit;\n  font-family: inherit;\n  font-weight: 300;\n  height: auto;\n  line-height: inherit;\n  margin: -1px 0 0 0;\n  outline: none;\n  padding: 0 0 0 0.5ch;\n  position: relative;\n  vertical-align: initial;\n  -webkit-box-sizing: border-box;\n  -webkit-appearance: menulist;\n  -moz-appearance: menulist;\n  width: auto;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months:focus,\n.flatpickr-current-month .flatpickr-monthDropdown-months:active {\n  outline: none;\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months:hover {\n  background: rgba(0, 0, 0, 0.05);\n}\n.flatpickr-current-month .flatpickr-monthDropdown-months .flatpickr-monthDropdown-month {\n  background-color: #eceef1;\n  outline: none;\n  padding: 0;\n}\n.flatpickr-weekdays {\n  background: #eceef1;\n  text-align: center;\n  overflow: hidden;\n  width: 100%;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: center;\n  -webkit-align-items: center;\n  -ms-flex-align: center;\n  align-items: center;\n  height: 28px;\n}\n.flatpickr-weekdays .flatpickr-weekdaycontainer {\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n}\nspan.flatpickr-weekday {\n  cursor: default;\n  font-size: 90%;\n  background: #eceef1;\n  color: #5a6171;\n  line-height: 1;\n  margin: 0;\n  text-align: center;\n  display: block;\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  font-weight: bolder;\n}\n.dayContainer,\n.flatpickr-weeks {\n  padding: 1px 0 0 0;\n}\n.flatpickr-days {\n  position: relative;\n  overflow: hidden;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-align: start;\n  -webkit-align-items: flex-start;\n  -ms-flex-align: start;\n  align-items: flex-start;\n  width: 307.875px;\n  border-left: 1px solid #eceef1;\n  border-right: 1px solid #eceef1;\n}\n.flatpickr-days:focus {\n  outline: 0;\n}\n.dayContainer {\n  padding: 0;\n  outline: 0;\n  text-align: left;\n  width: 307.875px;\n  min-width: 307.875px;\n  max-width: 307.875px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  display: inline-block;\n  display: -ms-flexbox;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: flex;\n  -webkit-flex-wrap: wrap;\n  flex-wrap: wrap;\n  -ms-flex-wrap: wrap;\n  -ms-flex-pack: justify;\n  -webkit-justify-content: space-around;\n  justify-content: space-around;\n  -webkit-transform: translate3d(0px, 0px, 0px);\n  transform: translate3d(0px, 0px, 0px);\n  opacity: 1;\n}\n.dayContainer + .dayContainer {\n  -webkit-box-shadow: -1px 0 0 #eceef1;\n  box-shadow: -1px 0 0 #eceef1;\n}\n.flatpickr-day {\n  background: none;\n  border: 1px solid transparent;\n  border-radius: 150px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  color: #484848;\n  cursor: pointer;\n  font-weight: 400;\n  width: 14.2857143%;\n  -webkit-flex-basis: 14.2857143%;\n  -ms-flex-preferred-size: 14.2857143%;\n  flex-basis: 14.2857143%;\n  max-width: 39px;\n  height: 39px;\n  line-height: 39px;\n  margin: 0;\n  display: inline-block;\n  position: relative;\n  -webkit-box-pack: center;\n  -webkit-justify-content: center;\n  -ms-flex-pack: center;\n  justify-content: center;\n  text-align: center;\n}\n.flatpickr-day.inRange,\n.flatpickr-day.prevMonthDay.inRange,\n.flatpickr-day.nextMonthDay.inRange,\n.flatpickr-day.today.inRange,\n.flatpickr-day.prevMonthDay.today.inRange,\n.flatpickr-day.nextMonthDay.today.inRange,\n.flatpickr-day:hover,\n.flatpickr-day.prevMonthDay:hover,\n.flatpickr-day.nextMonthDay:hover,\n.flatpickr-day:focus,\n.flatpickr-day.prevMonthDay:focus,\n.flatpickr-day.nextMonthDay:focus {\n  cursor: pointer;\n  outline: 0;\n  background: #e2e2e2;\n  border-color: #e2e2e2;\n}\n.flatpickr-day.today {\n  border-color: #bbb;\n}\n.flatpickr-day.today:hover,\n.flatpickr-day.today:focus {\n  border-color: #bbb;\n  background: #bbb;\n  color: #fff;\n}\n.flatpickr-day.selected,\n.flatpickr-day.startRange,\n.flatpickr-day.endRange,\n.flatpickr-day.selected.inRange,\n.flatpickr-day.startRange.inRange,\n.flatpickr-day.endRange.inRange,\n.flatpickr-day.selected:focus,\n.flatpickr-day.startRange:focus,\n.flatpickr-day.endRange:focus,\n.flatpickr-day.selected:hover,\n.flatpickr-day.startRange:hover,\n.flatpickr-day.endRange:hover,\n.flatpickr-day.selected.prevMonthDay,\n.flatpickr-day.startRange.prevMonthDay,\n.flatpickr-day.endRange.prevMonthDay,\n.flatpickr-day.selected.nextMonthDay,\n.flatpickr-day.startRange.nextMonthDay,\n.flatpickr-day.endRange.nextMonthDay {\n  background: #ff5a5f;\n  -webkit-box-shadow: none;\n  box-shadow: none;\n  color: #fff;\n  border-color: #ff5a5f;\n}\n.flatpickr-day.selected.startRange,\n.flatpickr-day.startRange.startRange,\n.flatpickr-day.endRange.startRange {\n  border-radius: 50px 0 0 50px;\n}\n.flatpickr-day.selected.endRange,\n.flatpickr-day.startRange.endRange,\n.flatpickr-day.endRange.endRange {\n  border-radius: 0 50px 50px 0;\n}\n.flatpickr-day.selected.startRange + .endRange:not(:nth-child(7n+1)),\n.flatpickr-day.startRange.startRange + .endRange:not(:nth-child(7n+1)),\n.flatpickr-day.endRange.startRange + .endRange:not(:nth-child(7n+1)) {\n  -webkit-box-shadow: -10px 0 0 #ff5a5f;\n  box-shadow: -10px 0 0 #ff5a5f;\n}\n.flatpickr-day.selected.startRange.endRange,\n.flatpickr-day.startRange.startRange.endRange,\n.flatpickr-day.endRange.startRange.endRange {\n  border-radius: 50px;\n}\n.flatpickr-day.inRange {\n  border-radius: 0;\n  -webkit-box-shadow: -5px 0 0 #e2e2e2, 5px 0 0 #e2e2e2;\n  box-shadow: -5px 0 0 #e2e2e2, 5px 0 0 #e2e2e2;\n}\n.flatpickr-day.flatpickr-disabled,\n.flatpickr-day.flatpickr-disabled:hover,\n.flatpickr-day.prevMonthDay,\n.flatpickr-day.nextMonthDay,\n.flatpickr-day.notAllowed,\n.flatpickr-day.notAllowed.prevMonthDay,\n.flatpickr-day.notAllowed.nextMonthDay {\n  color: rgba(72, 72, 72, 0.3);\n  background: transparent;\n  border-color: transparent;\n  cursor: default;\n}\n.flatpickr-day.flatpickr-disabled,\n.flatpickr-day.flatpickr-disabled:hover {\n  cursor: not-allowed;\n  color: rgba(72, 72, 72, 0.1);\n}\n.flatpickr-day.week.selected {\n  border-radius: 0;\n  -webkit-box-shadow: -5px 0 0 #ff5a5f, 5px 0 0 #ff5a5f;\n  box-shadow: -5px 0 0 #ff5a5f, 5px 0 0 #ff5a5f;\n}\n.flatpickr-day.hidden {\n  visibility: hidden;\n}\n.rangeMode .flatpickr-day {\n  margin-top: 1px;\n}\n.flatpickr-weekwrapper {\n  float: left;\n}\n.flatpickr-weekwrapper .flatpickr-weeks {\n  padding: 0 12px;\n  border-left: 1px solid #eceef1;\n}\n.flatpickr-weekwrapper .flatpickr-weekday {\n  float: none;\n  width: 100%;\n  line-height: 28px;\n}\n.flatpickr-weekwrapper span.flatpickr-day,\n.flatpickr-weekwrapper span.flatpickr-day:hover {\n  display: block;\n  width: 100%;\n  max-width: none;\n  color: rgba(72, 72, 72, 0.3);\n  background: transparent;\n  cursor: default;\n  border: none;\n}\n.flatpickr-innerContainer {\n  display: block;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  overflow: hidden;\n  background: #fff;\n  border-bottom: 1px solid #eceef1;\n}\n.flatpickr-rContainer {\n  display: inline-block;\n  padding: 0;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.flatpickr-time {\n  text-align: center;\n  outline: 0;\n  display: block;\n  height: 0;\n  line-height: 40px;\n  max-height: 40px;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  overflow: hidden;\n  display: -webkit-box;\n  display: -webkit-flex;\n  display: -ms-flexbox;\n  display: flex;\n  background: #fff;\n  border-radius: 0 0 5px 5px;\n}\n.flatpickr-time:after {\n  content: "";\n  display: table;\n  clear: both;\n}\n.flatpickr-time .numInputWrapper {\n  -webkit-box-flex: 1;\n  -webkit-flex: 1;\n  -ms-flex: 1;\n  flex: 1;\n  width: 40%;\n  height: 40px;\n  float: left;\n}\n.flatpickr-time .numInputWrapper span.arrowUp:after {\n  border-bottom-color: #484848;\n}\n.flatpickr-time .numInputWrapper span.arrowDown:after {\n  border-top-color: #484848;\n}\n.flatpickr-time.hasSeconds .numInputWrapper {\n  width: 26%;\n}\n.flatpickr-time.time24hr .numInputWrapper {\n  width: 49%;\n}\n.flatpickr-time input {\n  background: transparent;\n  -webkit-box-shadow: none;\n  box-shadow: none;\n  border: 0;\n  border-radius: 0;\n  text-align: center;\n  margin: 0;\n  padding: 0;\n  height: inherit;\n  line-height: inherit;\n  color: #484848;\n  font-size: 14px;\n  position: relative;\n  -webkit-box-sizing: border-box;\n  box-sizing: border-box;\n  -webkit-appearance: textfield;\n  -moz-appearance: textfield;\n  appearance: textfield;\n}\n.flatpickr-time input.flatpickr-hour {\n  font-weight: bold;\n}\n.flatpickr-time input.flatpickr-minute,\n.flatpickr-time input.flatpickr-second {\n  font-weight: 400;\n}\n.flatpickr-time input:focus {\n  outline: 0;\n  border: 0;\n}\n.flatpickr-time .flatpickr-time-separator,\n.flatpickr-time .flatpickr-am-pm {\n  height: inherit;\n  float: left;\n  line-height: inherit;\n  color: #484848;\n  font-weight: bold;\n  width: 2%;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  -webkit-align-self: center;\n  -ms-flex-item-align: center;\n  align-self: center;\n}\n.flatpickr-time .flatpickr-am-pm {\n  outline: 0;\n  width: 18%;\n  cursor: pointer;\n  text-align: center;\n  font-weight: 400;\n}\n.flatpickr-time input:hover,\n.flatpickr-time .flatpickr-am-pm:hover,\n.flatpickr-time input:focus,\n.flatpickr-time .flatpickr-am-pm:focus {\n  background: #eaeaea;\n}\n.flatpickr-input[readonly] {\n  cursor: pointer;\n}\n@-webkit-keyframes fpFadeInDown {\n  from {\n    opacity: 0;\n    -webkit-transform: translate3d(0, -20px, 0);\n    transform: translate3d(0, -20px, 0);\n  }\n  to {\n    opacity: 1;\n    -webkit-transform: translate3d(0, 0, 0);\n    transform: translate3d(0, 0, 0);\n  }\n}\n@keyframes fpFadeInDown {\n  from {\n    opacity: 0;\n    -webkit-transform: translate3d(0, -20px, 0);\n    transform: translate3d(0, -20px, 0);\n  }\n  to {\n    opacity: 1;\n    -webkit-transform: translate3d(0, 0, 0);\n    transform: translate3d(0, 0, 0);\n  }\n}\nspan.flatpickr-day.selected {\n  font-weight: bold;\n}\n'},
541: function _(e,t,n,i,r){i();var a=e(1),_=a.__importDefault(e(326)),o=e(542),u=e(123),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t}(o.AbstractRangeSliderView);n.DateRangeSliderView=d,d.__name__="DateRangeSliderView";var l=function(e){function t(t){var n=e.call(this,t)||this;return n.behaviour="drag",n.connected=[!1,!0,!1],n}return a.__extends(t,e),t.init_DateRangeSlider=function(){this.prototype.default_view=d,this.override({format:"%d %b %Y"})},t.prototype._formatter=function(e,t){return u.isString(t)?_.default(e,t):t.compute(e)},t}(o.AbstractSlider);n.DateRangeSlider=l,l.__name__="DateRangeSlider",l.init_DateRangeSlider()},
542: function _(t,e,i,r,o){r();var n=t(1),l=n.__importStar(t(543)),s=t(187),a=t(124),d=t(524),u=t(248),_=t(544),c=t(531),h=n.__importDefault(t(545)),p=n.__importDefault(t(546)),m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype.controls=function(){return n.__generator(this,(function(t){switch(t.label){case 0:return[4,this.slider_el];case 1:return t.sent(),[2]}}))},Object.defineProperty(e.prototype,"noUiSlider",{get:function(){return this.slider_el.noUiSlider},enumerable:!1,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var i=this.model.properties,r=i.direction,o=i.orientation,n=i.tooltips;this.on_change([r,o,n],(function(){return e.render()}));var l=this.model.properties,s=l.start,a=l.end,d=l.value,u=l.step,_=l.title;this.on_change([s,a,d,u],(function(){var t=e._calc_to(),i=t.start,r=t.end,o=t.value,n=t.step;e.noUiSlider.updateOptions({range:{min:i,max:r},start:o,step:n})}));var c=this.model.properties.bar_color;this.on_change(c,(function(){e._set_bar_color()}));var h=this.model.properties.show_value;this.on_change([d,_,h],(function(){return e._update_title()}))},e.prototype.styles=function(){return n.__spread(t.prototype.styles.call(this),[h.default,p.default])},e.prototype._update_title=function(){var t,e=this;s.empty(this.title_el);var i=null==this.model.title||0==this.model.title.length&&!this.model.show_value;if(this.title_el.style.display=i?"none":"",!i&&(0!=(null===(t=this.model.title)||void 0===t?void 0:t.length)&&(this.title_el.textContent=this.model.title+": "),this.model.show_value)){var r=this._calc_to().value.map((function(t){return e.model.pretty(t)})).join(" .. ");this.title_el.appendChild(s.span({class:_.bk_slider_value},r))}},e.prototype._set_bar_color=function(){this.model.disabled||(this.slider_el.querySelector(".noUi-connect").style.backgroundColor=this.model.bar_color)},e.prototype.render=function(){var e=this;t.prototype.render.call(this);var i,r=this._calc_to(),o=r.start,n=r.end,d=r.value,u=r.step;if(this.model.tooltips){var h={to:function(t){return e.model.pretty(t)}};i=a.repeat(h,d.length)}else i=!1;if(null==this.slider_el){this.slider_el=s.div(),l.create(this.slider_el,{range:{min:o,max:n},start:d,step:u,behaviour:this.model.behaviour,connect:this.model.connected,tooltips:i,orientation:this.model.orientation,direction:this.model.direction}),this.noUiSlider.on("slide",(function(t,i,r){return e._slide(r)})),this.noUiSlider.on("change",(function(t,i,r){return e._change(r)}));var p=function(t,r){i&&(e.slider_el.querySelectorAll(".noUi-handle")[t].querySelector(".noUi-tooltip").style.display=r?"block":"")};this.noUiSlider.on("start",(function(t,e){return p(e,!0)})),this.noUiSlider.on("end",(function(t,e){return p(e,!1)}))}else this.noUiSlider.updateOptions({range:{min:o,max:n},start:d,step:u});this._set_bar_color(),this.model.disabled?this.slider_el.setAttribute("disabled","true"):this.slider_el.removeAttribute("disabled"),this.title_el=s.div({class:_.bk_slider_title}),this._update_title(),this.group_el=s.div({class:c.bk_input_group},this.title_el,this.slider_el),this.el.appendChild(this.group_el)},e.prototype._slide=function(t){this.model.value=this._calc_from(t)},e.prototype._change=function(t){this.model.value=this._calc_from(t),this.model.value_throttled=this.model.value},e}(d.ControlView);m.__name__="AbstractBaseSliderView";var f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:[this.model.value],step:this.model.step}},e.prototype._calc_from=function(t){var e=n.__read(t,1)[0];return Number.isInteger(this.model.start)&&Number.isInteger(this.model.end)&&Number.isInteger(this.model.step)?Math.round(e):e},e}(m);i.AbstractSliderView=f,f.__name__="AbstractSliderView";var v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return n.__extends(e,t),e.prototype._calc_to=function(){return{start:this.model.start,end:this.model.end,value:this.model.value,step:this.model.step}},e.prototype._calc_from=function(t){return t},e}(m);i.AbstractRangeSliderView=v,v.__name__="AbstractRangeSliderView";var b=function(t){function e(e){var i=t.call(this,e)||this;return i.connected=!1,i}return n.__extends(e,t),e.init_AbstractSlider=function(){this.define((function(t){var e=t.Any,i=t.Boolean,r=t.Number,o=t.String,n=t.Color,l=t.Or,s=t.Enum,a=t.Ref;return{title:[(0,t.Nullable)(o),""],show_value:[i,!0],start:[e],end:[e],value:[e],value_throttled:[e],step:[r,1],format:[l(o,a(u.TickFormatter))],direction:[s("ltr","rtl"),"ltr"],tooltips:[i,!0],bar_color:[n,"#e6e6e6"]}}))},e.prototype.pretty=function(t){return this._formatter(t,this.format)},e}(d.Control);i.AbstractSlider=b,b.__name__="AbstractSlider",b.init_AbstractSlider()},
543: function _(t,e,r,n,i){
/*! nouislider - 14.6.1 - 8/17/2020 */
var o;o=function(){"use strict";var t="14.6.1";function e(t){t.parentElement.removeChild(t)}function r(t){return null!=t}function n(t){t.preventDefault()}function i(t){return"number"==typeof t&&!isNaN(t)&&isFinite(t)}function o(t,e,r){r>0&&(u(t,e),setTimeout((function(){c(t,e)}),r))}function s(t){return Math.max(Math.min(t,100),0)}function a(t){return Array.isArray(t)?t:[t]}function l(t){var e=(t=String(t)).split(".");return e.length>1?e[1].length:0}function u(t,e){t.classList&&!/\s/.test(e)?t.classList.add(e):t.className+=" "+e}function c(t,e){t.classList&&!/\s/.test(e)?t.classList.remove(e):t.className=t.className.replace(new RegExp("(^|\\b)"+e.split(" ").join("|")+"(\\b|$)","gi")," ")}function p(t){var e=void 0!==window.pageXOffset,r="CSS1Compat"===(t.compatMode||"");return{x:e?window.pageXOffset:r?t.documentElement.scrollLeft:t.body.scrollLeft,y:e?window.pageYOffset:r?t.documentElement.scrollTop:t.body.scrollTop}}function f(t,e){return 100/(e-t)}function d(t,e,r){return 100*e/(t[r+1]-t[r])}function h(t,e){for(var r=1;t>=e[r];)r+=1;return r}function m(t,e,r){if(r>=t.slice(-1)[0])return 100;var n=h(r,t),i=t[n-1],o=t[n],s=e[n-1],a=e[n];return s+function(t,e){return d(t,t[0]<0?e+Math.abs(t[0]):e-t[0],0)}([i,o],r)/f(s,a)}function g(t,e,r,n){if(100===n)return n;var i=h(n,t),o=t[i-1],s=t[i];return r?n-o>(s-o)/2?s:o:e[i-1]?t[i-1]+function(t,e){return Math.round(t/e)*e}(n-t[i-1],e[i-1]):n}function v(t,e,r){var n;if("number"==typeof e&&(e=[e]),!Array.isArray(e))throw new Error("noUiSlider (14.6.1): 'range' contains invalid value.");if(!i(n="min"===t?0:"max"===t?100:parseFloat(t))||!i(e[0]))throw new Error("noUiSlider (14.6.1): 'range' value isn't numeric.");r.xPct.push(n),r.xVal.push(e[0]),n?r.xSteps.push(!isNaN(e[1])&&e[1]):isNaN(e[1])||(r.xSteps[0]=e[1]),r.xHighestCompleteStep.push(0)}function b(t,e,r){if(e)if(r.xVal[t]!==r.xVal[t+1]){r.xSteps[t]=d([r.xVal[t],r.xVal[t+1]],e,0)/f(r.xPct[t],r.xPct[t+1]);var n=(r.xVal[t+1]-r.xVal[t])/r.xNumSteps[t],i=Math.ceil(Number(n.toFixed(3))-1),o=r.xVal[t]+r.xNumSteps[t]*i;r.xHighestCompleteStep[t]=o}else r.xSteps[t]=r.xHighestCompleteStep[t]=r.xVal[t]}function x(t,e,r){var n;this.xPct=[],this.xVal=[],this.xSteps=[r||!1],this.xNumSteps=[!1],this.xHighestCompleteStep=[],this.snap=e;var i=[];for(n in t)t.hasOwnProperty(n)&&i.push([t[n],n]);for(i.length&&"object"==typeof i[0][0]?i.sort((function(t,e){return t[0][0]-e[0][0]})):i.sort((function(t,e){return t[0]-e[0]})),n=0;n<i.length;n++)v(i[n][1],i[n][0],this);for(this.xNumSteps=this.xSteps.slice(0),n=0;n<this.xNumSteps.length;n++)b(n,this.xNumSteps[n],this)}x.prototype.getDistance=function(t){var e,r=[];for(e=0;e<this.xNumSteps.length-1;e++){var n=this.xNumSteps[e];if(n&&t/n%1!=0)throw new Error("noUiSlider (14.6.1): 'limit', 'margin' and 'padding' of "+this.xPct[e]+"% range must be divisible by step.");r[e]=d(this.xVal,t,e)}return r},x.prototype.getAbsoluteDistance=function(t,e,r){var n,i=0;if(t<this.xPct[this.xPct.length-1])for(;t>this.xPct[i+1];)i++;else t===this.xPct[this.xPct.length-1]&&(i=this.xPct.length-2);r||t!==this.xPct[i+1]||i++;var o=1,s=e[i],a=0,l=0,u=0,c=0;for(n=r?(t-this.xPct[i])/(this.xPct[i+1]-this.xPct[i]):(this.xPct[i+1]-t)/(this.xPct[i+1]-this.xPct[i]);s>0;)a=this.xPct[i+1+c]-this.xPct[i+c],e[i+c]*o+100-100*n>100?(l=a*n,o=(s-100*n)/e[i+c],n=1):(l=e[i+c]*a/100*o,o=0),r?(u-=l,this.xPct.length+c>=1&&c--):(u+=l,this.xPct.length-c>=1&&c++),s=e[i+c]*o;return t+u},x.prototype.toStepping=function(t){return t=m(this.xVal,this.xPct,t)},x.prototype.fromStepping=function(t){return function(t,e,r){if(r>=100)return t.slice(-1)[0];var n=h(r,e),i=t[n-1],o=t[n],s=e[n-1];return function(t,e){return e*(t[1]-t[0])/100+t[0]}([i,o],(r-s)*f(s,e[n]))}(this.xVal,this.xPct,t)},x.prototype.getStep=function(t){return t=g(this.xPct,this.xSteps,this.snap,t)},x.prototype.getDefaultStep=function(t,e,r){var n=h(t,this.xPct);return(100===t||e&&t===this.xPct[n-1])&&(n=Math.max(n-1,1)),(this.xVal[n]-this.xVal[n-1])/r},x.prototype.getNearbySteps=function(t){var e=h(t,this.xPct);return{stepBefore:{startValue:this.xVal[e-2],step:this.xNumSteps[e-2],highestStep:this.xHighestCompleteStep[e-2]},thisStep:{startValue:this.xVal[e-1],step:this.xNumSteps[e-1],highestStep:this.xHighestCompleteStep[e-1]},stepAfter:{startValue:this.xVal[e],step:this.xNumSteps[e],highestStep:this.xHighestCompleteStep[e]}}},x.prototype.countStepDecimals=function(){var t=this.xNumSteps.map(l);return Math.max.apply(null,t)},x.prototype.convert=function(t){return this.getStep(this.toStepping(t))};var S={to:function(t){return void 0!==t&&t.toFixed(2)},from:Number},w={target:"target",base:"base",origin:"origin",handle:"handle",handleLower:"handle-lower",handleUpper:"handle-upper",touchArea:"touch-area",horizontal:"horizontal",vertical:"vertical",background:"background",connect:"connect",connects:"connects",ltr:"ltr",rtl:"rtl",textDirectionLtr:"txt-dir-ltr",textDirectionRtl:"txt-dir-rtl",draggable:"draggable",drag:"state-drag",tap:"state-tap",active:"active",tooltip:"tooltip",pips:"pips",pipsHorizontal:"pips-horizontal",pipsVertical:"pips-vertical",marker:"marker",markerHorizontal:"marker-horizontal",markerVertical:"marker-vertical",markerNormal:"marker-normal",markerLarge:"marker-large",markerSub:"marker-sub",value:"value",valueHorizontal:"value-horizontal",valueVertical:"value-vertical",valueNormal:"value-normal",valueLarge:"value-large",valueSub:"value-sub"};function y(t){if(function(t){return"object"==typeof t&&"function"==typeof t.to&&"function"==typeof t.from}(t))return!0;throw new Error("noUiSlider (14.6.1): 'format' requires 'to' and 'from' methods.")}function E(t,e){if(!i(e))throw new Error("noUiSlider (14.6.1): 'step' is not numeric.");t.singleStep=e}function C(t,e){if(!i(e))throw new Error("noUiSlider (14.6.1): 'keyboardPageMultiplier' is not numeric.");t.keyboardPageMultiplier=e}function P(t,e){if(!i(e))throw new Error("noUiSlider (14.6.1): 'keyboardDefaultStep' is not numeric.");t.keyboardDefaultStep=e}function N(t,e){if("object"!=typeof e||Array.isArray(e))throw new Error("noUiSlider (14.6.1): 'range' is not an object.");if(void 0===e.min||void 0===e.max)throw new Error("noUiSlider (14.6.1): Missing 'min' or 'max' in 'range'.");if(e.min===e.max)throw new Error("noUiSlider (14.6.1): 'range' 'min' and 'max' cannot be equal.");t.spectrum=new x(e,t.snap,t.singleStep)}function k(t,e){if(e=a(e),!Array.isArray(e)||!e.length)throw new Error("noUiSlider (14.6.1): 'start' option is incorrect.");t.handles=e.length,t.start=e}function U(t,e){if(t.snap=e,"boolean"!=typeof e)throw new Error("noUiSlider (14.6.1): 'snap' option must be a boolean.")}function A(t,e){if(t.animate=e,"boolean"!=typeof e)throw new Error("noUiSlider (14.6.1): 'animate' option must be a boolean.")}function V(t,e){if(t.animationDuration=e,"number"!=typeof e)throw new Error("noUiSlider (14.6.1): 'animationDuration' option must be a number.")}function D(t,e){var r,n=[!1];if("lower"===e?e=[!0,!1]:"upper"===e&&(e=[!1,!0]),!0===e||!1===e){for(r=1;r<t.handles;r++)n.push(e);n.push(!1)}else{if(!Array.isArray(e)||!e.length||e.length!==t.handles+1)throw new Error("noUiSlider (14.6.1): 'connect' option doesn't match handle count.");n=e}t.connect=n}function M(t,e){switch(e){case"horizontal":t.ort=0;break;case"vertical":t.ort=1;break;default:throw new Error("noUiSlider (14.6.1): 'orientation' option is invalid.")}}function O(t,e){if(!i(e))throw new Error("noUiSlider (14.6.1): 'margin' option must be numeric.");0!==e&&(t.margin=t.spectrum.getDistance(e))}function L(t,e){if(!i(e))throw new Error("noUiSlider (14.6.1): 'limit' option must be numeric.");if(t.limit=t.spectrum.getDistance(e),!t.limit||t.handles<2)throw new Error("noUiSlider (14.6.1): 'limit' option is only supported on linear sliders with 2 or more handles.")}function z(t,e){var r;if(!i(e)&&!Array.isArray(e))throw new Error("noUiSlider (14.6.1): 'padding' option must be numeric or array of exactly 2 numbers.");if(Array.isArray(e)&&2!==e.length&&!i(e[0])&&!i(e[1]))throw new Error("noUiSlider (14.6.1): 'padding' option must be numeric or array of exactly 2 numbers.");if(0!==e){for(Array.isArray(e)||(e=[e,e]),t.padding=[t.spectrum.getDistance(e[0]),t.spectrum.getDistance(e[1])],r=0;r<t.spectrum.xNumSteps.length-1;r++)if(t.padding[0][r]<0||t.padding[1][r]<0)throw new Error("noUiSlider (14.6.1): 'padding' option must be a positive number(s).");var n=e[0]+e[1],o=t.spectrum.xVal[0];if(n/(t.spectrum.xVal[t.spectrum.xVal.length-1]-o)>1)throw new Error("noUiSlider (14.6.1): 'padding' option must not exceed 100% of the range.")}}function H(t,e){switch(e){case"ltr":t.dir=0;break;case"rtl":t.dir=1;break;default:throw new Error("noUiSlider (14.6.1): 'direction' option was not recognized.")}}function j(t,e){if("string"!=typeof e)throw new Error("noUiSlider (14.6.1): 'behaviour' must be a string containing options.");var r=e.indexOf("tap")>=0,n=e.indexOf("drag")>=0,i=e.indexOf("fixed")>=0,o=e.indexOf("snap")>=0,s=e.indexOf("hover")>=0,a=e.indexOf("unconstrained")>=0;if(i){if(2!==t.handles)throw new Error("noUiSlider (14.6.1): 'fixed' behaviour must be used with 2 handles");O(t,t.start[1]-t.start[0])}if(a&&(t.margin||t.limit))throw new Error("noUiSlider (14.6.1): 'unconstrained' behaviour cannot be used with margin or limit");t.events={tap:r||o,drag:n,fixed:i,snap:o,hover:s,unconstrained:a}}function F(t,e){if(!1!==e)if(!0===e){t.tooltips=[];for(var r=0;r<t.handles;r++)t.tooltips.push(!0)}else{if(t.tooltips=a(e),t.tooltips.length!==t.handles)throw new Error("noUiSlider (14.6.1): must pass a formatter for all handles.");t.tooltips.forEach((function(t){if("boolean"!=typeof t&&("object"!=typeof t||"function"!=typeof t.to))throw new Error("noUiSlider (14.6.1): 'tooltips' must be passed a formatter or 'false'.")}))}}function R(t,e){t.ariaFormat=e,y(e)}function T(t,e){t.format=e,y(e)}function B(t,e){if(t.keyboardSupport=e,"boolean"!=typeof e)throw new Error("noUiSlider (14.6.1): 'keyboardSupport' option must be a boolean.")}function q(t,e){t.documentElement=e}function X(t,e){if("string"!=typeof e&&!1!==e)throw new Error("noUiSlider (14.6.1): 'cssPrefix' must be a string or `false`.");t.cssPrefix=e}function _(t,e){if("object"!=typeof e)throw new Error("noUiSlider (14.6.1): 'cssClasses' must be an object.");if("string"==typeof t.cssPrefix)for(var r in t.cssClasses={},e)e.hasOwnProperty(r)&&(t.cssClasses[r]=t.cssPrefix+e[r]);else t.cssClasses=e}function Y(t){var e={margin:0,limit:0,padding:0,animate:!0,animationDuration:300,ariaFormat:S,format:S},n={step:{r:!1,t:E},keyboardPageMultiplier:{r:!1,t:C},keyboardDefaultStep:{r:!1,t:P},start:{r:!0,t:k},connect:{r:!0,t:D},direction:{r:!0,t:H},snap:{r:!1,t:U},animate:{r:!1,t:A},animationDuration:{r:!1,t:V},range:{r:!0,t:N},orientation:{r:!1,t:M},margin:{r:!1,t:O},limit:{r:!1,t:L},padding:{r:!1,t:z},behaviour:{r:!0,t:j},ariaFormat:{r:!1,t:R},format:{r:!1,t:T},tooltips:{r:!1,t:F},keyboardSupport:{r:!0,t:B},documentElement:{r:!1,t:q},cssPrefix:{r:!0,t:X},cssClasses:{r:!0,t:_}},i={connect:!1,direction:"ltr",behaviour:"tap",orientation:"horizontal",keyboardSupport:!0,cssPrefix:"noUi-",cssClasses:w,keyboardPageMultiplier:5,keyboardDefaultStep:10};t.format&&!t.ariaFormat&&(t.ariaFormat=t.format),Object.keys(n).forEach((function(o){if(!r(t[o])&&void 0===i[o]){if(n[o].r)throw new Error("noUiSlider (14.6.1): '"+o+"' is required.");return!0}n[o].t(e,r(t[o])?t[o]:i[o])})),e.pips=t.pips;var o=document.createElement("div"),s=void 0!==o.style.msTransform,a=void 0!==o.style.transform;return e.transformRule=a?"transform":s?"msTransform":"webkitTransform",e.style=[["left","top"],["right","bottom"]][e.dir][e.ort],e}function I(t,r,i){var l,f,d,h,m,g,v,b,x=window.navigator.pointerEnabled?{start:"pointerdown",move:"pointermove",end:"pointerup"}:window.navigator.msPointerEnabled?{start:"MSPointerDown",move:"MSPointerMove",end:"MSPointerUp"}:{start:"mousedown touchstart",move:"mousemove touchmove",end:"mouseup touchend"},S=window.CSS&&CSS.supports&&CSS.supports("touch-action","none")&&function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",null,e)}catch(t){}return t}(),w=t,y=r.spectrum,E=[],C=[],P=[],N=0,k={},U=t.ownerDocument,A=r.documentElement||U.documentElement,V=U.body,D="rtl"===U.dir||1===r.ort?0:100;function M(t,e){var r=U.createElement("div");return e&&u(r,e),t.appendChild(r),r}function O(t,e){var n=M(t,r.cssClasses.origin),i=M(n,r.cssClasses.handle);return M(i,r.cssClasses.touchArea),i.setAttribute("data-handle",e),r.keyboardSupport&&(i.setAttribute("tabindex","0"),i.addEventListener("keydown",(function(t){return function(t,e){if(H()||j(e))return!1;var n=["Left","Right"],i=["Down","Up"],o=["PageDown","PageUp"],s=["Home","End"];r.dir&&!r.ort?n.reverse():r.ort&&!r.dir&&(i.reverse(),o.reverse());var a,l=t.key.replace("Arrow",""),u=l===o[0],c=l===o[1],p=l===i[0]||l===n[0]||u,f=l===i[1]||l===n[1]||c,d=l===s[0],h=l===s[1];if(!(p||f||d||h))return!0;if(t.preventDefault(),f||p){var m=r.keyboardPageMultiplier,g=p?0:1,v=ft(e)[g];if(null===v)return!1;!1===v&&(v=y.getDefaultStep(C[e],p,r.keyboardDefaultStep)),(c||u)&&(v*=m),v=Math.max(v,1e-7),v*=p?-1:1,a=E[e]+v}else a=h?r.spectrum.xVal[r.spectrum.xVal.length-1]:r.spectrum.xVal[0];return at(e,y.toStepping(a),!0,!0),et("slide",e),et("update",e),et("change",e),et("set",e),!1}(t,e)}))),i.setAttribute("role","slider"),i.setAttribute("aria-orientation",r.ort?"vertical":"horizontal"),0===e?u(i,r.cssClasses.handleLower):e===r.handles-1&&u(i,r.cssClasses.handleUpper),n}function L(t,e){return!!e&&M(t,r.cssClasses.connect)}function z(t,e){return!!r.tooltips[e]&&M(t.firstChild,r.cssClasses.tooltip)}function H(){return w.hasAttribute("disabled")}function j(t){return f[t].hasAttribute("disabled")}function F(){m&&(tt("update.tooltips"),m.forEach((function(t){t&&e(t)})),m=null)}function R(){F(),m=f.map(z),Z("update.tooltips",(function(t,e,n){if(m[e]){var i=t[e];!0!==r.tooltips[e]&&(i=r.tooltips[e].to(n[e])),m[e].innerHTML=i}}))}function T(t,e,n){var i=U.createElement("div"),o=[];o[0]=r.cssClasses.valueNormal,o[1]=r.cssClasses.valueLarge,o[2]=r.cssClasses.valueSub;var s=[];s[0]=r.cssClasses.markerNormal,s[1]=r.cssClasses.markerLarge,s[2]=r.cssClasses.markerSub;var a=[r.cssClasses.valueHorizontal,r.cssClasses.valueVertical],l=[r.cssClasses.markerHorizontal,r.cssClasses.markerVertical];function c(t,e){var n=e===r.cssClasses.value,i=n?o:s;return e+" "+(n?a:l)[r.ort]+" "+i[t]}return u(i,r.cssClasses.pips),u(i,0===r.ort?r.cssClasses.pipsHorizontal:r.cssClasses.pipsVertical),Object.keys(t).forEach((function(o){!function(t,o,s){if(-1!==(s=e?e(o,s):s)){var a=M(i,!1);a.className=c(s,r.cssClasses.marker),a.style[r.style]=t+"%",s>0&&((a=M(i,!1)).className=c(s,r.cssClasses.value),a.setAttribute("data-value",o),a.style[r.style]=t+"%",a.innerHTML=n.to(o))}}(o,t[o][0],t[o][1])})),i}function B(){h&&(e(h),h=null)}function q(t){B();var e=t.mode,r=t.density||1,n=t.filter||!1,i=function(t,e,r){if("range"===t||"steps"===t)return y.xVal;if("count"===t){if(e<2)throw new Error("noUiSlider (14.6.1): 'values' (>= 2) required for mode 'count'.");var n=e-1,i=100/n;for(e=[];n--;)e[n]=n*i;e.push(100),t="positions"}return"positions"===t?e.map((function(t){return y.fromStepping(r?y.getStep(t):t)})):"values"===t?r?e.map((function(t){return y.fromStepping(y.getStep(y.toStepping(t)))})):e:void 0}(e,t.values||!1,t.stepped||!1),o=function(t,e,r){var n,i={},o=y.xVal[0],s=y.xVal[y.xVal.length-1],a=!1,l=!1,u=0;return n=r.slice().sort((function(t,e){return t-e})),(r=n.filter((function(t){return!this[t]&&(this[t]=!0)}),{}))[0]!==o&&(r.unshift(o),a=!0),r[r.length-1]!==s&&(r.push(s),l=!0),r.forEach((function(n,o){var s,c,p,f,d,h,m,g,v,b,x=n,S=r[o+1],w="steps"===e;if(w&&(s=y.xNumSteps[o]),s||(s=S-x),!1!==x)for(void 0===S&&(S=x),s=Math.max(s,1e-7),c=x;c<=S;c=(c+s).toFixed(7)/1){for(g=(d=(f=y.toStepping(c))-u)/t,b=d/(v=Math.round(g)),p=1;p<=v;p+=1)i[(h=u+p*b).toFixed(5)]=[y.fromStepping(h),0];m=r.indexOf(c)>-1?1:w?2:0,!o&&a&&c!==S&&(m=0),c===S&&l||(i[f.toFixed(5)]=[c,m]),u=f}})),i}(r,e,i),s=t.format||{to:Math.round};return h=w.appendChild(T(o,n,s))}function X(){var t=l.getBoundingClientRect(),e="offset"+["Width","Height"][r.ort];return 0===r.ort?t.width||l[e]:t.height||l[e]}function _(t,e,n,i){var o=function(o){return!!(o=function(t,e,r){var n,i,o=0===t.type.indexOf("touch"),s=0===t.type.indexOf("mouse"),a=0===t.type.indexOf("pointer");if(0===t.type.indexOf("MSPointer")&&(a=!0),o){var l=function(t){return t.target===r||r.contains(t.target)||t.target.shadowRoot&&t.target.shadowRoot.contains(r)};if("touchstart"===t.type){var u=Array.prototype.filter.call(t.touches,l);if(u.length>1)return!1;n=u[0].pageX,i=u[0].pageY}else{var c=Array.prototype.find.call(t.changedTouches,l);if(!c)return!1;n=c.pageX,i=c.pageY}}return e=e||p(U),(s||a)&&(n=t.clientX+e.x,i=t.clientY+e.y),t.pageOffset=e,t.points=[n,i],t.cursor=s||a,t}(o,i.pageOffset,i.target||e))&&!(H()&&!i.doNotReject)&&(s=w,a=r.cssClasses.tap,!((s.classList?s.classList.contains(a):new RegExp("\\b"+a+"\\b").test(s.className))&&!i.doNotReject)&&!(t===x.start&&void 0!==o.buttons&&o.buttons>1)&&(!i.hover||!o.buttons)&&(S||o.preventDefault(),o.calcPoint=o.points[r.ort],void n(o,i)));var s,a},s=[];return t.split(" ").forEach((function(t){e.addEventListener(t,o,!!S&&{passive:!0}),s.push([t,o])})),s}function I(t){var e,n,i,o,a,u,c=100*(t-(e=l,n=r.ort,i=e.getBoundingClientRect(),o=e.ownerDocument,a=o.documentElement,u=p(o),/webkit.*Chrome.*Mobile/i.test(navigator.userAgent)&&(u.x=0),n?i.top+u.y-a.clientTop:i.left+u.x-a.clientLeft))/X();return c=s(c),r.dir?100-c:c}function W(t,e){"mouseout"===t.type&&"HTML"===t.target.nodeName&&null===t.relatedTarget&&G(t,e)}function $(t,e){if(-1===navigator.appVersion.indexOf("MSIE 9")&&0===t.buttons&&0!==e.buttonsProperty)return G(t,e);var n=(r.dir?-1:1)*(t.calcPoint-e.startCalcPoint);it(n>0,100*n/e.baseSize,e.locations,e.handleNumbers)}function G(t,e){e.handle&&(c(e.handle,r.cssClasses.active),N-=1),e.listeners.forEach((function(t){A.removeEventListener(t[0],t[1])})),0===N&&(c(w,r.cssClasses.drag),st(),t.cursor&&(V.style.cursor="",V.removeEventListener("selectstart",n))),e.handleNumbers.forEach((function(t){et("change",t),et("set",t),et("end",t)}))}function J(t,e){if(e.handleNumbers.some(j))return!1;var i;1===e.handleNumbers.length&&(i=f[e.handleNumbers[0]].children[0],N+=1,u(i,r.cssClasses.active)),t.stopPropagation();var o=[],s=_(x.move,A,$,{target:t.target,handle:i,listeners:o,startCalcPoint:t.calcPoint,baseSize:X(),pageOffset:t.pageOffset,handleNumbers:e.handleNumbers,buttonsProperty:t.buttons,locations:C.slice()}),a=_(x.end,A,G,{target:t.target,handle:i,listeners:o,doNotReject:!0,handleNumbers:e.handleNumbers}),l=_("mouseout",A,W,{target:t.target,handle:i,listeners:o,doNotReject:!0,handleNumbers:e.handleNumbers});o.push.apply(o,s.concat(a,l)),t.cursor&&(V.style.cursor=getComputedStyle(t.target).cursor,f.length>1&&u(w,r.cssClasses.drag),V.addEventListener("selectstart",n,!1)),e.handleNumbers.forEach((function(t){et("start",t)}))}function K(t){if(!t.buttons&&!t.touches)return!1;t.stopPropagation();var e=I(t.calcPoint),n=function(t){var e=100,r=!1;return f.forEach((function(n,i){if(!j(i)){var o=C[i],s=Math.abs(o-t);(s<e||s<=e&&t>o||100===s&&100===e)&&(r=i,e=s)}})),r}(e);if(!1===n)return!1;r.events.snap||o(w,r.cssClasses.tap,r.animationDuration),at(n,e,!0,!0),st(),et("slide",n,!0),et("update",n,!0),et("change",n,!0),et("set",n,!0),r.events.snap&&J(t,{handleNumbers:[n]})}function Q(t){var e=I(t.calcPoint),r=y.getStep(e),n=y.fromStepping(r);Object.keys(k).forEach((function(t){"hover"===t.split(".")[0]&&k[t].forEach((function(t){t.call(g,n)}))}))}function Z(t,e){k[t]=k[t]||[],k[t].push(e),"update"===t.split(".")[0]&&f.forEach((function(t,e){et("update",e)}))}function tt(t){var e=t&&t.split(".")[0],r=e&&t.substring(e.length);Object.keys(k).forEach((function(t){var n=t.split(".")[0],i=t.substring(n.length);e&&e!==n||r&&r!==i||delete k[t]}))}function et(t,e,n){Object.keys(k).forEach((function(i){var o=i.split(".")[0];t===o&&k[i].forEach((function(t){t.call(g,E.map(r.format.to),e,E.slice(),n||!1,C.slice(),g)}))}))}function rt(t,e,n,i,o,a){var l;return f.length>1&&!r.events.unconstrained&&(i&&e>0&&(l=y.getAbsoluteDistance(t[e-1],r.margin,0),n=Math.max(n,l)),o&&e<f.length-1&&(l=y.getAbsoluteDistance(t[e+1],r.margin,1),n=Math.min(n,l))),f.length>1&&r.limit&&(i&&e>0&&(l=y.getAbsoluteDistance(t[e-1],r.limit,0),n=Math.min(n,l)),o&&e<f.length-1&&(l=y.getAbsoluteDistance(t[e+1],r.limit,1),n=Math.max(n,l))),r.padding&&(0===e&&(l=y.getAbsoluteDistance(0,r.padding[0],0),n=Math.max(n,l)),e===f.length-1&&(l=y.getAbsoluteDistance(100,r.padding[1],1),n=Math.min(n,l))),!((n=s(n=y.getStep(n)))===t[e]&&!a)&&n}function nt(t,e){var n=r.ort;return(n?e:t)+", "+(n?t:e)}function it(t,e,r,n){var i=r.slice(),o=[!t,t],s=[t,!t];n=n.slice(),t&&n.reverse(),n.length>1?n.forEach((function(t,r){var n=rt(i,t,i[t]+e,o[r],s[r],!1);!1===n?e=0:(e=n-i[t],i[t]=n)})):o=s=[!0];var a=!1;n.forEach((function(t,n){a=at(t,r[t]+e,o[n],s[n])||a})),a&&n.forEach((function(t){et("update",t),et("slide",t)}))}function ot(t,e){return r.dir?100-t-e:t}function st(){P.forEach((function(t){var e=C[t]>50?-1:1,r=3+(f.length+e*t);f[t].style.zIndex=r}))}function at(t,e,n,i){return!1!==(e=rt(C,t,e,n,i,!1))&&(function(t,e){C[t]=e,E[t]=y.fromStepping(e);var n="translate("+nt(10*(ot(e,0)-D)+"%","0")+")";f[t].style[r.transformRule]=n,lt(t),lt(t+1)}(t,e),!0)}function lt(t){if(d[t]){var e=0,n=100;0!==t&&(e=C[t-1]),t!==d.length-1&&(n=C[t]);var i=n-e,o="translate("+nt(ot(e,i)+"%","0")+")",s="scale("+nt(i/100,"1")+")";d[t].style[r.transformRule]=o+" "+s}}function ut(t,e){return null===t||!1===t||void 0===t?C[e]:("number"==typeof t&&(t=String(t)),t=r.format.from(t),!1===(t=y.toStepping(t))||isNaN(t)?C[e]:t)}function ct(t,e){var n=a(t),i=void 0===C[0];e=void 0===e||!!e,r.animate&&!i&&o(w,r.cssClasses.tap,r.animationDuration),P.forEach((function(t){at(t,ut(n[t],t),!0,!1)}));for(var s=1===P.length?0:1;s<P.length;++s)P.forEach((function(t){at(t,C[t],!0,!0)}));st(),P.forEach((function(t){et("update",t),null!==n[t]&&e&&et("set",t)}))}function pt(){var t=E.map(r.format.to);return 1===t.length?t[0]:t}function ft(t){var e=C[t],n=y.getNearbySteps(e),i=E[t],o=n.thisStep.step,s=null;if(r.snap)return[i-n.stepBefore.startValue||null,n.stepAfter.startValue-i||null];!1!==o&&i+o>n.stepAfter.startValue&&(o=n.stepAfter.startValue-i),s=i>n.thisStep.startValue?n.thisStep.step:!1!==n.stepBefore.step&&i-n.stepBefore.highestStep,100===e?o=null:0===e&&(s=null);var a=y.countStepDecimals();return null!==o&&!1!==o&&(o=Number(o.toFixed(a))),null!==s&&!1!==s&&(s=Number(s.toFixed(a))),[s,o]}return u(v=w,r.cssClasses.target),0===r.dir?u(v,r.cssClasses.ltr):u(v,r.cssClasses.rtl),0===r.ort?u(v,r.cssClasses.horizontal):u(v,r.cssClasses.vertical),u(v,"rtl"===getComputedStyle(v).direction?r.cssClasses.textDirectionRtl:r.cssClasses.textDirectionLtr),l=M(v,r.cssClasses.base),function(t,e){var n=M(e,r.cssClasses.connects);f=[],(d=[]).push(L(n,t[0]));for(var i=0;i<r.handles;i++)f.push(O(e,i)),P[i]=i,d.push(L(n,t[i+1]))}(r.connect,l),(b=r.events).fixed||f.forEach((function(t,e){_(x.start,t.children[0],J,{handleNumbers:[e]})})),b.tap&&_(x.start,l,K,{}),b.hover&&_(x.move,l,Q,{hover:!0}),b.drag&&d.forEach((function(t,e){if(!1!==t&&0!==e&&e!==d.length-1){var n=f[e-1],i=f[e],o=[t];u(t,r.cssClasses.draggable),b.fixed&&(o.push(n.children[0]),o.push(i.children[0])),o.forEach((function(t){_(x.start,t,J,{handles:[n,i],handleNumbers:[e-1,e]})}))}})),ct(r.start),r.pips&&q(r.pips),r.tooltips&&R(),Z("update",(function(t,e,n,i,o){P.forEach((function(t){var e=f[t],i=rt(C,t,0,!0,!0,!0),s=rt(C,t,100,!0,!0,!0),a=o[t],l=r.ariaFormat.to(n[t]);i=y.fromStepping(i).toFixed(1),s=y.fromStepping(s).toFixed(1),a=y.fromStepping(a).toFixed(1),e.children[0].setAttribute("aria-valuemin",i),e.children[0].setAttribute("aria-valuemax",s),e.children[0].setAttribute("aria-valuenow",a),e.children[0].setAttribute("aria-valuetext",l)}))})),g={destroy:function(){for(var t in r.cssClasses)r.cssClasses.hasOwnProperty(t)&&c(w,r.cssClasses[t]);for(;w.firstChild;)w.removeChild(w.firstChild);delete w.noUiSlider},steps:function(){return P.map(ft)},on:Z,off:tt,get:pt,set:ct,setHandle:function(t,e,r){if(!((t=Number(t))>=0&&t<P.length))throw new Error("noUiSlider (14.6.1): invalid handle number, got: "+t);at(t,ut(e,t),!0,!0),et("update",t),r&&et("set",t)},reset:function(t){ct(r.start,t)},__moveHandles:function(t,e,r){it(t,e,C,r)},options:i,updateOptions:function(t,e){var n=pt(),o=["margin","limit","padding","range","animate","snap","step","format","pips","tooltips"];o.forEach((function(e){void 0!==t[e]&&(i[e]=t[e])}));var s=Y(i);o.forEach((function(e){void 0!==t[e]&&(r[e]=s[e])})),y=s.spectrum,r.margin=s.margin,r.limit=s.limit,r.padding=s.padding,r.pips?q(r.pips):B(),r.tooltips?R():F(),C=[],ct(t.start||n,e)},target:w,removePips:B,removeTooltips:F,getTooltips:function(){return m},getOrigins:function(){return f},pips:q}}return{__spectrum:x,version:t,cssClasses:w,create:function(t,e){if(!t||!t.nodeName)throw new Error("noUiSlider (14.6.1): create requires a single element, got: "+t);if(t.noUiSlider)throw new Error("noUiSlider (14.6.1): Slider was already initialized.");var r=I(t,Y(e),e);return t.noUiSlider=r,r}}},"function"==typeof define&&define.amd?define([],o):"object"==typeof r?e.exports=o():window.noUiSlider=o()},
544: function _(e,l,i,t,_){t(),i.bk_slider_value="bk-slider-value",i.bk_slider_title="bk-slider-title"},
545: function _(n,o,t,i,r){i();t.default="\n.bk-root {\n  /*! nouislider - 14.6.1 - 8/17/2020 */\n  /* Functional styling;\n * These styles are required for noUiSlider to function.\n * You don't need to change these rules to apply your design.\n */\n  /* Wrapper for all connect elements.\n */\n  /* Offset direction\n */\n  /* Give origins 0 height/width so they don't interfere with clicking the\n * connect elements.\n */\n  /* Slider size and handle placement;\n */\n  /* Styling;\n * Giving the connect element a border radius causes issues with using transform: scale\n */\n  /* Handles and cursors;\n */\n  /* Handle stripes;\n */\n  /* Disabled state;\n */\n  /* Base;\n *\n */\n  /* Values;\n *\n */\n  /* Markings;\n *\n */\n  /* Horizontal layout;\n *\n */\n  /* Vertical layout;\n *\n */\n}\n.bk-root .noUi-target,\n.bk-root .noUi-target * {\n  -webkit-touch-callout: none;\n  -webkit-tap-highlight-color: rgba(0, 0, 0, 0);\n  -webkit-user-select: none;\n  -ms-touch-action: none;\n  touch-action: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  user-select: none;\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .noUi-target {\n  position: relative;\n}\n.bk-root .noUi-base,\n.bk-root .noUi-connects {\n  width: 100%;\n  height: 100%;\n  position: relative;\n  z-index: 1;\n}\n.bk-root .noUi-connects {\n  overflow: hidden;\n  z-index: 0;\n}\n.bk-root .noUi-connect,\n.bk-root .noUi-origin {\n  will-change: transform;\n  position: absolute;\n  z-index: 1;\n  top: 0;\n  right: 0;\n  -ms-transform-origin: 0 0;\n  -webkit-transform-origin: 0 0;\n  -webkit-transform-style: preserve-3d;\n  transform-origin: 0 0;\n  transform-style: flat;\n}\n.bk-root .noUi-connect {\n  height: 100%;\n  width: 100%;\n}\n.bk-root .noUi-origin {\n  height: 10%;\n  width: 10%;\n}\n.bk-root .noUi-txt-dir-rtl.noUi-horizontal .noUi-origin {\n  left: 0;\n  right: auto;\n}\n.bk-root .noUi-vertical .noUi-origin {\n  width: 0;\n}\n.bk-root .noUi-horizontal .noUi-origin {\n  height: 0;\n}\n.bk-root .noUi-handle {\n  -webkit-backface-visibility: hidden;\n  backface-visibility: hidden;\n  position: absolute;\n}\n.bk-root .noUi-touch-area {\n  height: 100%;\n  width: 100%;\n}\n.bk-root .noUi-state-tap .noUi-connect,\n.bk-root .noUi-state-tap .noUi-origin {\n  -webkit-transition: transform 0.3s;\n  transition: transform 0.3s;\n}\n.bk-root .noUi-state-drag * {\n  cursor: inherit !important;\n}\n.bk-root .noUi-horizontal {\n  height: 18px;\n}\n.bk-root .noUi-horizontal .noUi-handle {\n  width: 34px;\n  height: 28px;\n  right: -17px;\n  top: -6px;\n}\n.bk-root .noUi-vertical {\n  width: 18px;\n}\n.bk-root .noUi-vertical .noUi-handle {\n  width: 28px;\n  height: 34px;\n  right: -6px;\n  top: -17px;\n}\n.bk-root .noUi-txt-dir-rtl.noUi-horizontal .noUi-handle {\n  left: -17px;\n  right: auto;\n}\n.bk-root .noUi-target {\n  background: #FAFAFA;\n  border-radius: 4px;\n  border: 1px solid #D3D3D3;\n  box-shadow: inset 0 1px 1px #F0F0F0, 0 3px 6px -5px #BBB;\n}\n.bk-root .noUi-connects {\n  border-radius: 3px;\n}\n.bk-root .noUi-connect {\n  background: #3FB8AF;\n}\n.bk-root .noUi-draggable {\n  cursor: ew-resize;\n}\n.bk-root .noUi-vertical .noUi-draggable {\n  cursor: ns-resize;\n}\n.bk-root .noUi-handle {\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #FFF;\n  cursor: default;\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #EBEBEB, 0 3px 6px -3px #BBB;\n}\n.bk-root .noUi-active {\n  box-shadow: inset 0 0 1px #FFF, inset 0 1px 7px #DDD, 0 3px 6px -3px #BBB;\n}\n.bk-root .noUi-handle:before,\n.bk-root .noUi-handle:after {\n  content: \"\";\n  display: block;\n  position: absolute;\n  height: 14px;\n  width: 1px;\n  background: #E8E7E6;\n  left: 14px;\n  top: 6px;\n}\n.bk-root .noUi-handle:after {\n  left: 17px;\n}\n.bk-root .noUi-vertical .noUi-handle:before,\n.bk-root .noUi-vertical .noUi-handle:after {\n  width: 14px;\n  height: 1px;\n  left: 6px;\n  top: 14px;\n}\n.bk-root .noUi-vertical .noUi-handle:after {\n  top: 17px;\n}\n.bk-root [disabled] .noUi-connect {\n  background: #B8B8B8;\n}\n.bk-root [disabled].noUi-target,\n.bk-root [disabled].noUi-handle,\n.bk-root [disabled] .noUi-handle {\n  cursor: not-allowed;\n}\n.bk-root .noUi-pips,\n.bk-root .noUi-pips * {\n  -moz-box-sizing: border-box;\n  box-sizing: border-box;\n}\n.bk-root .noUi-pips {\n  position: absolute;\n  color: #999;\n}\n.bk-root .noUi-value {\n  position: absolute;\n  white-space: nowrap;\n  text-align: center;\n}\n.bk-root .noUi-value-sub {\n  color: #ccc;\n  font-size: 10px;\n}\n.bk-root .noUi-marker {\n  position: absolute;\n  background: #CCC;\n}\n.bk-root .noUi-marker-sub {\n  background: #AAA;\n}\n.bk-root .noUi-marker-large {\n  background: #AAA;\n}\n.bk-root .noUi-pips-horizontal {\n  padding: 10px 0;\n  height: 80px;\n  top: 100%;\n  left: 0;\n  width: 100%;\n}\n.bk-root .noUi-value-horizontal {\n  -webkit-transform: translate(-50%, 50%);\n  transform: translate(-50%, 50%);\n}\n.bk-root .noUi-rtl .noUi-value-horizontal {\n  -webkit-transform: translate(50%, 50%);\n  transform: translate(50%, 50%);\n}\n.bk-root .noUi-marker-horizontal.noUi-marker {\n  margin-left: -1px;\n  width: 2px;\n  height: 5px;\n}\n.bk-root .noUi-marker-horizontal.noUi-marker-sub {\n  height: 10px;\n}\n.bk-root .noUi-marker-horizontal.noUi-marker-large {\n  height: 15px;\n}\n.bk-root .noUi-pips-vertical {\n  padding: 0 10px;\n  height: 100%;\n  top: 0;\n  left: 100%;\n}\n.bk-root .noUi-value-vertical {\n  -webkit-transform: translate(0, -50%);\n  transform: translate(0, -50%);\n  padding-left: 25px;\n}\n.bk-root .noUi-rtl .noUi-value-vertical {\n  -webkit-transform: translate(0, 50%);\n  transform: translate(0, 50%);\n}\n.bk-root .noUi-marker-vertical.noUi-marker {\n  width: 5px;\n  height: 2px;\n  margin-top: -1px;\n}\n.bk-root .noUi-marker-vertical.noUi-marker-sub {\n  width: 10px;\n}\n.bk-root .noUi-marker-vertical.noUi-marker-large {\n  width: 15px;\n}\n.bk-root .noUi-tooltip {\n  display: block;\n  position: absolute;\n  border: 1px solid #D9D9D9;\n  border-radius: 3px;\n  background: #fff;\n  color: #000;\n  padding: 5px;\n  text-align: center;\n  white-space: nowrap;\n}\n.bk-root .noUi-horizontal .noUi-tooltip {\n  -webkit-transform: translate(-50%, 0);\n  transform: translate(-50%, 0);\n  left: 50%;\n  bottom: 120%;\n}\n.bk-root .noUi-vertical .noUi-tooltip {\n  -webkit-transform: translate(0, -50%);\n  transform: translate(0, -50%);\n  top: 50%;\n  right: 120%;\n}\n.bk-root .noUi-horizontal .noUi-origin > .noUi-tooltip {\n  -webkit-transform: translate(50%, 0);\n  transform: translate(50%, 0);\n  left: auto;\n  bottom: 10px;\n}\n.bk-root .noUi-vertical .noUi-origin > .noUi-tooltip {\n  -webkit-transform: translate(0, -18px);\n  transform: translate(0, -18px);\n  top: auto;\n  right: 28px;\n}\n.bk-root .noUi-handle {\n  cursor: grab;\n  cursor: -webkit-grab;\n}\n.bk-root .noUi-handle.noUi-active {\n  cursor: grabbing;\n  cursor: -webkit-grabbing;\n}\n.bk-root .noUi-handle:after,\n.bk-root .noUi-handle:before {\n  display: none;\n}\n.bk-root .noUi-tooltip {\n  display: none;\n  white-space: nowrap;\n}\n.bk-root .noUi-handle:hover .noUi-tooltip {\n  display: block;\n}\n.bk-root .noUi-horizontal {\n  width: 100%;\n  height: 10px;\n}\n.bk-root .noUi-vertical {\n  width: 10px;\n  height: 100%;\n}\n.bk-root .noUi-horizontal .noUi-handle {\n  width: 14px;\n  height: 18px;\n  right: -7px;\n  top: -5px;\n}\n.bk-root .noUi-vertical .noUi-handle {\n  width: 18px;\n  height: 14px;\n  right: -5px;\n  top: -7px;\n}\n.bk-root .noUi-target.noUi-horizontal {\n  margin: 5px 0px;\n}\n.bk-root .noUi-target.noUi-vertical {\n  margin: 0px 5px;\n}\n"},
546: function _(n,t,e,o,i){o();e.default="\n.bk-root .bk-slider-title {\n  white-space: nowrap;\n}\n.bk-root .bk-slider-value {\n  font-weight: 600;\n}\n"},
547: function _(t,e,i,r,n){r();var a=t(1),_=a.__importDefault(t(326)),o=t(542),u=t(123),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return a.__extends(e,t),e}(o.AbstractSliderView);i.DateSliderView=l,l.__name__="DateSliderView";var d=function(t){function e(e){var i=t.call(this,e)||this;return i.behaviour="tap",i.connected=[!0,!1],i}return a.__extends(e,t),e.init_DateSlider=function(){this.prototype.default_view=l,this.override({format:"%d %b %Y"})},e.prototype._formatter=function(t,e){return u.isString(e)?_.default(t,e):e.compute(t)},e}(o.AbstractSlider);i.DateSlider=d,d.__name__="DateSlider",d.init_DateSlider()},
548: function _(t,e,n,i,r){i();var _=t(1),o=t(549),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return _.__extends(e,t),e.prototype.render=function(){t.prototype.render.call(this),this.model.render_as_text?this.markup_el.textContent=this.model.text:this.markup_el.innerHTML=this.model.text},e}(o.MarkupView);n.DivView=u,u.__name__="DivView";var s=function(t){function e(e){return t.call(this,e)||this}return _.__extends(e,t),e.init_Div=function(){this.prototype.default_view=u,this.define((function(t){return{render_as_text:[t.Boolean,!1]}}))},e}(o.Markup);n.Div=s,s.__name__="Div",s.init_Div()},
549: function _(t,e,i,n,a){n();var r=t(1),o=t(357),s=t(187),l=t(589),u=t(550),c=r.__importDefault(t(551)),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return r.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){e.layout.invalidate_cache(),e.render(),e.root.compute_layout()}))},e.prototype.styles=function(){return r.__spread(t.prototype.styles.call(this),[c.default])},e.prototype._update_layout=function(){this.layout=new o.CachedVariadicBox(this.el),this.layout.set_sizing(this.box_sizing())},e.prototype.render=function(){t.prototype.render.call(this);var e=Object.assign(Object.assign({},this.model.style),{display:"inline-block"});this.markup_el=s.div({class:u.bk_clearfix,style:e}),this.el.appendChild(this.markup_el)},e}(l.WidgetView);i.MarkupView=p,p.__name__="MarkupView";var _=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Markup=function(){this.define((function(t){var e=t.String;return{text:[e,""],style:[(0,t.Dict)(e),{}]}}))},e}(l.Widget);i.Markup=_,_.__name__="Markup",_.init_Markup()},
550: function _(c,f,i,a,b){a(),i.bk_clearfix="bk-clearfix"},
551: function _(n,e,t,o,r){o();t.default='\n.bk-root .bk-clearfix:before,\n.bk-root .bk-clearfix:after {\n  content: "";\n  display: table;\n}\n.bk-root .bk-clearfix:after {\n  clear: both;\n}\n'},
552: function _(t,e,n,i,o){i();var r=t(1),s=t(523),u=t(430),l=t(187),_=t(123),p=t(304),d=t(418),c=t(302),a=r.__importDefault(t(299)),h=function(t){function e(){var e=t.apply(this,r.__spread(arguments))||this;return e._open=!1,e}return r.__extends(e,t),e.prototype.styles=function(){return r.__spread(t.prototype.styles.call(this),[a.default])},e.prototype.render=function(){var e=this;t.prototype.render.call(this);var n=l.div({class:[c.bk_caret,p.bk_down]});if(this.model.is_split){var i=this._render_button(n);i.classList.add(d.bk_dropdown_toggle),i.addEventListener("click",(function(){return e._toggle_menu()})),this.group_el.appendChild(i)}else this.button_el.appendChild(n);var o=this.model.menu.map((function(t,n){if(null==t)return l.div({class:c.bk_divider});var i=_.isString(t)?t:t[0],o=l.div({},i);return o.addEventListener("click",(function(){return e._item_click(n)})),o}));this.menu=l.div({class:[c.bk_menu,p.bk_below]},o),this.el.appendChild(this.menu),l.undisplay(this.menu)},e.prototype._show_menu=function(){var t=this;if(!this._open){this._open=!0,l.display(this.menu);var e=function(n){var i=n.target;i instanceof HTMLElement&&!t.el.contains(i)&&(document.removeEventListener("click",e),t._hide_menu())};document.addEventListener("click",e)}},e.prototype._hide_menu=function(){this._open&&(this._open=!1,l.undisplay(this.menu))},e.prototype._toggle_menu=function(){this._open?this._hide_menu():this._show_menu()},e.prototype.click=function(){this.model.is_split?(this._hide_menu(),this.model.trigger_event(new u.ButtonClick),t.prototype.click.call(this)):this._toggle_menu()},e.prototype._item_click=function(t){this._hide_menu();var e=this.model.menu[t];if(null!=e){var n=_.isString(e)?e:e[1];_.isString(n)?this.model.trigger_event(new u.MenuItemClick(n)):n.execute(this.model,{index:t})}},e}(s.AbstractButtonView);n.DropdownView=h,h.__name__="DropdownView";var m=function(t){function e(e){return t.call(this,e)||this}return r.__extends(e,t),e.init_Dropdown=function(){this.prototype.default_view=h,this.define((function(t){var e=t.Null,n=t.Boolean,i=t.String,o=t.Array,r=t.Tuple,s=t.Or;return{split:[n,!1],menu:[o(s(i,r(i,s(i)),e)),[]]}})),this.override({label:"Dropdown"})},Object.defineProperty(e.prototype,"is_split",{get:function(){return this.split},enumerable:!1,configurable:!0}),e}(s.AbstractButton);n.Dropdown=m,m.__name__="Dropdown",m.init_Dropdown()},
553: function _(e,t,i,n,l){n();var o=e(1),a=e(589),r=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.render()})),this.connect(this.model.properties.width.change,(function(){return t.render()}))},t.prototype.render=function(){var e=this;null==this.dialogEl&&(this.dialogEl=document.createElement("input"),this.dialogEl.type="file",this.dialogEl.multiple=this.model.multiple,this.dialogEl.onchange=function(){var t=e.dialogEl.files;null!=t&&e.load_files(t)},this.el.appendChild(this.dialogEl)),null!=this.model.accept&&""!=this.model.accept&&(this.dialogEl.accept=this.model.accept),this.dialogEl.style.width="{this.model.width}px",this.dialogEl.disabled=this.model.disabled},t.prototype.load_files=function(e){return o.__awaiter(this,void 0,void 0,(function(){var t,i,n,l,a,r,s,u;return o.__generator(this,(function(d){switch(d.label){case 0:t=[],i=[],n=[],l=0,d.label=1;case 1:return l<e.length?(i.push(e[l].name),[4,this.readfile(e[l])]):[3,4];case 2:a=d.sent(),r=o.__read(a.split(/[:;,]/,4),4),s=r[1],u=r[3],t.push(u),n.push(s),d.label=3;case 3:return l++,[3,1];case 4:return this.model.multiple?(this.model.filename=i,this.model.mime_type=n,this.model.value=t):(this.model.filename=i[0],this.model.mime_type=n[0],this.model.value=t[0]),[2]}}))}))},t.prototype.readfile=function(e){return new Promise((function(t,i){var n=new FileReader;n.onload=function(){var l,o=n.result;null!=o?t(o):i(null!==(l=n.error)&&void 0!==l?l:new Error("unable to read '"+e.name+"'"))},n.readAsDataURL(e)}))},t}(a.WidgetView);i.FileInputView=r,r.__name__="FileInputView";var s=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_FileInput=function(){this.prototype.default_view=r,this.define((function(e){var t=e.Boolean,i=e.String,n=e.Array,l=e.Or;return{value:[l(i,n(i)),""],mime_type:[l(i,n(i)),""],filename:[l(i,n(i)),""],accept:[i,""],multiple:[t,!1]}}))},t}(a.Widget);i.FileInput=s,s.__name__="FileInput",s.init_FileInput()},
554: function _(e,t,n,i,r){i();var l=e(1),o=e(187),s=e(123),c=e(529),u=e(531),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return l.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.value.change,(function(){return t.render_selection()})),this.connect(this.model.properties.options.change,(function(){return t.render()})),this.connect(this.model.properties.name.change,(function(){return t.render()})),this.connect(this.model.properties.title.change,(function(){return t.render()})),this.connect(this.model.properties.size.change,(function(){return t.render()})),this.connect(this.model.properties.disabled.change,(function(){return t.render()}))},t.prototype.render=function(){var t=this;e.prototype.render.call(this);var n=this.model.options.map((function(e){var t,n,i;return s.isString(e)?n=i=e:(n=(t=l.__read(e,2))[0],i=t[1]),o.option({value:n},i)}));this.input_el=o.select({multiple:!0,class:u.bk_input,name:this.model.name,disabled:this.model.disabled},n),this.input_el.addEventListener("change",(function(){return t.change_input()})),this.group_el.appendChild(this.input_el),this.render_selection()},t.prototype.render_selection=function(){var e,t,n=new Set(this.model.value);try{for(var i=l.__values(this.el.querySelectorAll("option")),r=i.next();!r.done;r=i.next()){var o=r.value;o.selected=n.has(o.value)}}catch(t){e={error:t}}finally{try{r&&!r.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}this.input_el.size=this.model.size},t.prototype.change_input=function(){var t,n,i=null!=this.el.querySelector("select:focus"),r=[];try{for(var o=l.__values(this.el.querySelectorAll("option")),s=o.next();!s.done;s=o.next()){var c=s.value;c.selected&&r.push(c.value)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(n=o.return)&&n.call(o)}finally{if(t)throw t.error}}this.model.value=r,e.prototype.change_input.call(this),i&&this.input_el.focus()},t}(c.InputWidgetView);n.MultiSelectView=a,a.__name__="MultiSelectView";var h=function(e){function t(t){return e.call(this,t)||this}return l.__extends(t,e),t.init_MultiSelect=function(){this.prototype.default_view=a,this.define((function(e){var t=e.Int,n=e.String,i=e.Array,r=e.Tuple,l=e.Or;return{value:[i(n),[]],options:[i(l(n,r(n,n))),[]],size:[t,4]}}))},t}(c.InputWidget);n.MultiSelect=h,h.__name__="MultiSelect",h.init_MultiSelect()},
555: function _(r,t,a,n,e){n();var i=r(1),p=r(549),_=r(187),u=function(r){function t(){return null!==r&&r.apply(this,arguments)||this}return i.__extends(t,r),t.prototype.render=function(){r.prototype.render.call(this);var t=_.p({style:{margin:0}},this.model.text);this.markup_el.appendChild(t)},t}(p.MarkupView);a.ParagraphView=u,u.__name__="ParagraphView";var h=function(r){function t(t){return r.call(this,t)||this}return i.__extends(t,r),t.init_Paragraph=function(){this.prototype.default_view=u},t}(p.Markup);a.Paragraph=h,h.__name__="Paragraph",h.init_Paragraph()},
556: function _(t,n,e,r,i){r();var s=t(1),u=t(528),o=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return s.__extends(n,t),n.prototype.render=function(){t.prototype.render.call(this),this.input_el.type="password"},n}(u.TextInputView);e.PasswordInputView=o,o.__name__="PasswordInputView";var p=function(t){function n(n){return t.call(this,n)||this}return s.__extends(n,t),n.init_PasswordInput=function(){this.prototype.default_view=o},n}(u.TextInput);e.PasswordInput=p,p.__name__="PasswordInput",p.init_PasswordInput()},
557: function _(t,e,i,l,n){l();var o=t(1),s=o.__importDefault(t(558)),a=t(187),r=t(123),u=t(357),h=t(531),c=o.__importDefault(t(559)),_=t(529),d=function(t){function e(){var e=t.apply(this,o.__spread(arguments))||this;return e._last_height=null,e}return o.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.disabled.change,(function(){return e.set_disabled()}));var i=this.model.properties,l=i.value,n=i.max_items,o=i.option_limit,s=i.delete_button,a=i.placeholder,r=i.options,u=i.name,h=i.title;this.on_change([l,n,o,s,a,r,u,h],(function(){return e.render()}))},e.prototype.styles=function(){return o.__spread(t.prototype.styles.call(this),[c.default])},e.prototype._update_layout=function(){this.layout=new u.CachedVariadicBox(this.el),this.layout.set_sizing(this.box_sizing())},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.input_el=a.select({multiple:!0,class:h.bk_input,name:this.model.name,disabled:this.model.disabled}),this.group_el.appendChild(this.input_el);var i=new Set(this.model.value),l=this.model.options.map((function(t){var e,l,n;return r.isString(t)?l=n=t:(l=(e=o.__read(t,2))[0],n=e[1]),{value:l,label:n,selected:i.has(l)}})),n=this.model.solid?"solid":"light",u="choices__item "+n,c="choices__button "+n,_={choices:l,duplicateItemsAllowed:!1,removeItemButton:this.model.delete_button,classNames:{item:u,button:c}};null!=this.model.placeholder&&(_.placeholderValue=this.model.placeholder),null!=this.model.max_items&&(_.maxItemCount=this.model.max_items),null!=this.model.option_limit&&(_.renderChoiceLimit=this.model.option_limit),this.choice_el=new s.default(this.input_el,_);var d=function(){return e.choice_el.containerOuter.element.getBoundingClientRect().height};null!=this._last_height&&this._last_height!=d()&&this.root.invalidate_layout(),this._last_height=d(),this.input_el.addEventListener("change",(function(){return e.change_input()}))},e.prototype.set_disabled=function(){this.model.disabled?this.choice_el.disable():this.choice_el.enable()},e.prototype.change_input=function(){var e,i,l=null!=this.el.querySelector("select:focus"),n=[];try{for(var s=o.__values(this.el.querySelectorAll("option")),a=s.next();!a.done;a=s.next()){var r=a.value;r.selected&&n.push(r.value)}}catch(t){e={error:t}}finally{try{a&&!a.done&&(i=s.return)&&i.call(s)}finally{if(e)throw e.error}}this.model.value=n,t.prototype.change_input.call(this),l&&this.input_el.focus()},e}(_.InputWidgetView);i.MultiChoiceView=d,d.__name__="MultiChoiceView";var p=function(t){function e(e){return t.call(this,e)||this}return o.__extends(e,t),e.init_MultiChoice=function(){this.prototype.default_view=d,this.define((function(t){var e=t.Boolean,i=t.Int,l=t.String,n=t.Array,o=t.Tuple,s=t.Or,a=t.Nullable;return{value:[n(l),[]],options:[n(s(l,o(l,l))),[]],max_items:[a(i),null],delete_button:[e,!0],placeholder:[a(l),null],option_limit:[a(i),null],solid:[e,!0]}}))},e}(_.InputWidget);i.MultiChoice=p,p.__name__="MultiChoice",p.init_MultiChoice()},
558: function _(e,t,i,n,s){
/*! choices.js v9.0.1 | © 2019 Josh Johnson | https://github.com/jshjohnson/Choices#readme */
var r,o;r=window,o=function(){return function(e){var t={};function i(n){if(t[n])return t[n].exports;var s=t[n]={i:n,l:!1,exports:{}};return e[n].call(s.exports,s,s.exports,i),s.l=!0,s.exports}return i.m=e,i.c=t,i.d=function(e,t,n){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i.t=function(e,t){if(1&t&&(e=i(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var s in e)i.d(n,s,function(t){return e[t]}.bind(null,s));return n},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="/public/assets/scripts/",i(i.s=4)}([function(e,t,i){"use strict";var n=function(e){return function(e){return!!e&&"object"==typeof e}(e)&&!function(e){var t=Object.prototype.toString.call(e);return"[object RegExp]"===t||"[object Date]"===t||function(e){return e.$$typeof===s}(e)}(e)},s="function"==typeof Symbol&&Symbol.for?Symbol.for("react.element"):60103;function r(e,t){return!1!==t.clone&&t.isMergeableObject(e)?l((i=e,Array.isArray(i)?[]:{}),e,t):e;var i}function o(e,t,i){return e.concat(t).map((function(e){return r(e,i)}))}function a(e){return Object.keys(e).concat(function(e){return Object.getOwnPropertySymbols?Object.getOwnPropertySymbols(e).filter((function(t){return e.propertyIsEnumerable(t)})):[]}(e))}function c(e,t,i){var n={};return i.isMergeableObject(e)&&a(e).forEach((function(t){n[t]=r(e[t],i)})),a(t).forEach((function(s){(function(e,t){try{return t in e&&!(Object.hasOwnProperty.call(e,t)&&Object.propertyIsEnumerable.call(e,t))}catch(e){return!1}})(e,s)||(i.isMergeableObject(t[s])&&e[s]?n[s]=function(e,t){if(!t.customMerge)return l;var i=t.customMerge(e);return"function"==typeof i?i:l}(s,i)(e[s],t[s],i):n[s]=r(t[s],i))})),n}function l(e,t,i){(i=i||{}).arrayMerge=i.arrayMerge||o,i.isMergeableObject=i.isMergeableObject||n,i.cloneUnlessOtherwiseSpecified=r;var s=Array.isArray(t);return s===Array.isArray(e)?s?i.arrayMerge(e,t,i):c(e,t,i):r(t,i)}l.all=function(e,t){if(!Array.isArray(e))throw new Error("first argument should be an array");return e.reduce((function(e,i){return l(e,i,t)}),{})};var h=l;e.exports=h},function(e,t,i){"use strict";(function(e,n){var s,r=i(3);s="undefined"!=typeof self?self:"undefined"!=typeof window?window:void 0!==e?e:n;var o=Object(r.a)(s);t.a=o}).call(this,i(5),i(6)(e))},function(e,t,i){
/*!
                 * Fuse.js v3.4.5 - Lightweight fuzzy-search (http://fusejs.io)
                 *
                 * Copyright (c) 2012-2017 Kirollos Risk (http://kiro.me)
                 * All Rights Reserved. Apache Software License 2.0
                 *
                 * http://www.apache.org/licenses/LICENSE-2.0
                 */
e.exports=function(e){var t={};function i(n){if(t[n])return t[n].exports;var s=t[n]={i:n,l:!1,exports:{}};return e[n].call(s.exports,s,s.exports,i),s.l=!0,s.exports}return i.m=e,i.c=t,i.d=function(e,t,n){i.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:n})},i.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},i.t=function(e,t){if(1&t&&(e=i(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(i.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var s in e)i.d(n,s,function(t){return e[t]}.bind(null,s));return n},i.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return i.d(t,"a",t),t},i.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},i.p="",i(i.s=1)}([function(e,t){e.exports=function(e){return Array.isArray?Array.isArray(e):"[object Array]"===Object.prototype.toString.call(e)}},function(e,t,i){function n(e){return(n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e})(e)}function s(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var r=i(2),o=i(8),a=i(0),c=function(){function e(t,i){var n=i.location,s=void 0===n?0:n,r=i.distance,a=void 0===r?100:r,c=i.threshold,l=void 0===c?.6:c,h=i.maxPatternLength,u=void 0===h?32:h,d=i.caseSensitive,p=void 0!==d&&d,m=i.tokenSeparator,f=void 0===m?/ +/g:m,v=i.findAllMatches,g=void 0!==v&&v,_=i.minMatchCharLength,b=void 0===_?1:_,y=i.id,E=void 0===y?null:y,I=i.keys,S=void 0===I?[]:I,w=i.shouldSort,O=void 0===w||w,C=i.getFn,A=void 0===C?o:C,L=i.sortFn,T=void 0===L?function(e,t){return e.score-t.score}:L,x=i.tokenize,k=void 0!==x&&x,P=i.matchAllTokens,D=void 0!==P&&P,M=i.includeMatches,N=void 0!==M&&M,F=i.includeScore,j=void 0!==F&&F,K=i.verbose,R=void 0!==K&&K;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.options={location:s,distance:a,threshold:l,maxPatternLength:u,isCaseSensitive:p,tokenSeparator:f,findAllMatches:g,minMatchCharLength:b,id:E,keys:S,includeMatches:N,includeScore:j,shouldSort:O,getFn:A,sortFn:T,verbose:R,tokenize:k,matchAllTokens:D},this.setCollection(t)}var t,i,c;return t=e,(i=[{key:"setCollection",value:function(e){return this.list=e,e}},{key:"search",value:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{limit:!1};this._log('---------\nSearch pattern: "'.concat(e,'"'));var i=this._prepareSearchers(e),n=i.tokenSearchers,s=i.fullSearcher,r=this._search(n,s),o=r.weights,a=r.results;return this._computeScore(o,a),this.options.shouldSort&&this._sort(a),t.limit&&"number"==typeof t.limit&&(a=a.slice(0,t.limit)),this._format(a)}},{key:"_prepareSearchers",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",t=[];if(this.options.tokenize)for(var i=e.split(this.options.tokenSeparator),n=0,s=i.length;n<s;n+=1)t.push(new r(i[n],this.options));return{tokenSearchers:t,fullSearcher:new r(e,this.options)}}},{key:"_search",value:function(){var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1?arguments[1]:void 0,i=this.list,n={},s=[];if("string"==typeof i[0]){for(var r=0,o=i.length;r<o;r+=1)this._analyze({key:"",value:i[r],record:r,index:r},{resultMap:n,results:s,tokenSearchers:e,fullSearcher:t});return{weights:null,results:s}}for(var a={},c=0,l=i.length;c<l;c+=1)for(var h=i[c],u=0,d=this.options.keys.length;u<d;u+=1){var p=this.options.keys[u];if("string"!=typeof p){if(a[p.name]={weight:1-p.weight||1},p.weight<=0||p.weight>1)throw new Error("Key weight has to be > 0 and <= 1");p=p.name}else a[p]={weight:1};this._analyze({key:p,value:this.options.getFn(h,p),record:h,index:c},{resultMap:n,results:s,tokenSearchers:e,fullSearcher:t})}return{weights:a,results:s}}},{key:"_analyze",value:function(e,t){var i=e.key,n=e.arrayIndex,s=void 0===n?-1:n,r=e.value,o=e.record,c=e.index,l=t.tokenSearchers,h=void 0===l?[]:l,u=t.fullSearcher,d=void 0===u?[]:u,p=t.resultMap,m=void 0===p?{}:p,f=t.results,v=void 0===f?[]:f;if(null!=r){var g=!1,_=-1,b=0;if("string"==typeof r){this._log("\nKey: ".concat(""===i?"-":i));var y=d.search(r);if(this._log('Full text: "'.concat(r,'", score: ').concat(y.score)),this.options.tokenize){for(var E=r.split(this.options.tokenSeparator),I=[],S=0;S<h.length;S+=1){var w=h[S];this._log('\nPattern: "'.concat(w.pattern,'"'));for(var O=!1,C=0;C<E.length;C+=1){var A=E[C],L=w.search(A),T={};L.isMatch?(T[A]=L.score,g=!0,O=!0,I.push(L.score)):(T[A]=1,this.options.matchAllTokens||I.push(1)),this._log('Token: "'.concat(A,'", score: ').concat(T[A]))}O&&(b+=1)}_=I[0];for(var x=I.length,k=1;k<x;k+=1)_+=I[k];_/=x,this._log("Token score average:",_)}var P=y.score;_>-1&&(P=(P+_)/2),this._log("Score average:",P);var D=!this.options.tokenize||!this.options.matchAllTokens||b>=h.length;if(this._log("\nCheck Matches: ".concat(D)),(g||y.isMatch)&&D){var M=m[c];M?M.output.push({key:i,arrayIndex:s,value:r,score:P,matchedIndices:y.matchedIndices}):(m[c]={item:o,output:[{key:i,arrayIndex:s,value:r,score:P,matchedIndices:y.matchedIndices}]},v.push(m[c]))}}else if(a(r))for(var N=0,F=r.length;N<F;N+=1)this._analyze({key:i,arrayIndex:N,value:r[N],record:o,index:c},{resultMap:m,results:v,tokenSearchers:h,fullSearcher:d})}}},{key:"_computeScore",value:function(e,t){this._log("\n\nComputing score:\n");for(var i=0,n=t.length;i<n;i+=1){for(var s=t[i].output,r=s.length,o=1,a=1,c=0;c<r;c+=1){var l=e?e[s[c].key].weight:1,h=(1===l?s[c].score:s[c].score||.001)*l;1!==l?a=Math.min(a,h):(s[c].nScore=h,o*=h)}t[i].score=1===a?o:a,this._log(t[i])}}},{key:"_sort",value:function(e){this._log("\n\nSorting...."),e.sort(this.options.sortFn)}},{key:"_format",value:function(e){var t=[];if(this.options.verbose){var i=[];this._log("\n\nOutput:\n\n",JSON.stringify(e,(function(e,t){if("object"===n(t)&&null!==t){if(-1!==i.indexOf(t))return;i.push(t)}return t}))),i=null}var s=[];this.options.includeMatches&&s.push((function(e,t){var i=e.output;t.matches=[];for(var n=0,s=i.length;n<s;n+=1){var r=i[n];if(0!==r.matchedIndices.length){var o={indices:r.matchedIndices,value:r.value};r.key&&(o.key=r.key),r.hasOwnProperty("arrayIndex")&&r.arrayIndex>-1&&(o.arrayIndex=r.arrayIndex),t.matches.push(o)}}})),this.options.includeScore&&s.push((function(e,t){t.score=e.score}));for(var r=0,o=e.length;r<o;r+=1){var a=e[r];if(this.options.id&&(a.item=this.options.getFn(a.item,this.options.id)[0]),s.length){for(var c={item:a.item},l=0,h=s.length;l<h;l+=1)s[l](a,c);t.push(c)}else t.push(a.item)}return t}},{key:"_log",value:function(){var e;this.options.verbose&&(e=console).log.apply(e,arguments)}}])&&s(t.prototype,i),c&&s(t,c),e}();e.exports=c},function(e,t,i){function n(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var s=i(3),r=i(4),o=i(7),a=function(){function e(t,i){var n=i.location,s=void 0===n?0:n,r=i.distance,a=void 0===r?100:r,c=i.threshold,l=void 0===c?.6:c,h=i.maxPatternLength,u=void 0===h?32:h,d=i.isCaseSensitive,p=void 0!==d&&d,m=i.tokenSeparator,f=void 0===m?/ +/g:m,v=i.findAllMatches,g=void 0!==v&&v,_=i.minMatchCharLength,b=void 0===_?1:_;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.options={location:s,distance:a,threshold:l,maxPatternLength:u,isCaseSensitive:p,tokenSeparator:f,findAllMatches:g,minMatchCharLength:b},this.pattern=this.options.isCaseSensitive?t:t.toLowerCase(),this.pattern.length<=u&&(this.patternAlphabet=o(this.pattern))}var t,i,a;return t=e,(i=[{key:"search",value:function(e){if(this.options.isCaseSensitive||(e=e.toLowerCase()),this.pattern===e)return{isMatch:!0,score:0,matchedIndices:[[0,e.length-1]]};var t=this.options,i=t.maxPatternLength,n=t.tokenSeparator;if(this.pattern.length>i)return s(e,this.pattern,n);var o=this.options,a=o.location,c=o.distance,l=o.threshold,h=o.findAllMatches,u=o.minMatchCharLength;return r(e,this.pattern,this.patternAlphabet,{location:a,distance:c,threshold:l,findAllMatches:h,minMatchCharLength:u})}}])&&n(t.prototype,i),a&&n(t,a),e}();e.exports=a},function(e,t){var i=/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g;e.exports=function(e,t){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:/ +/g,s=new RegExp(t.replace(i,"\\$&").replace(n,"|")),r=e.match(s),o=!!r,a=[];if(o)for(var c=0,l=r.length;c<l;c+=1){var h=r[c];a.push([e.indexOf(h),h.length-1])}return{score:o?.5:1,isMatch:o,matchedIndices:a}}},function(e,t,i){var n=i(5),s=i(6);e.exports=function(e,t,i,r){for(var o=r.location,a=void 0===o?0:o,c=r.distance,l=void 0===c?100:c,h=r.threshold,u=void 0===h?.6:h,d=r.findAllMatches,p=void 0!==d&&d,m=r.minMatchCharLength,f=void 0===m?1:m,v=a,g=e.length,_=u,b=e.indexOf(t,v),y=t.length,E=[],I=0;I<g;I+=1)E[I]=0;if(-1!==b){var S=n(t,{errors:0,currentLocation:b,expectedLocation:v,distance:l});if(_=Math.min(S,_),-1!==(b=e.lastIndexOf(t,v+y))){var w=n(t,{errors:0,currentLocation:b,expectedLocation:v,distance:l});_=Math.min(w,_)}}b=-1;for(var O=[],C=1,A=y+g,L=1<<y-1,T=0;T<y;T+=1){for(var x=0,k=A;x<k;)n(t,{errors:T,currentLocation:v+k,expectedLocation:v,distance:l})<=_?x=k:A=k,k=Math.floor((A-x)/2+x);A=k;var P=Math.max(1,v-k+1),D=p?g:Math.min(v+k,g)+y,M=Array(D+2);M[D+1]=(1<<T)-1;for(var N=D;N>=P;N-=1){var F=N-1,j=i[e.charAt(F)];if(j&&(E[F]=1),M[N]=(M[N+1]<<1|1)&j,0!==T&&(M[N]|=(O[N+1]|O[N])<<1|1|O[N+1]),M[N]&L&&(C=n(t,{errors:T,currentLocation:F,expectedLocation:v,distance:l}))<=_){if(_=C,(b=F)<=v)break;P=Math.max(1,2*v-b)}}if(n(t,{errors:T+1,currentLocation:v,expectedLocation:v,distance:l})>_)break;O=M}return{isMatch:b>=0,score:0===C?.001:C,matchedIndices:s(E,f)}}},function(e,t){e.exports=function(e,t){var i=t.errors,n=void 0===i?0:i,s=t.currentLocation,r=void 0===s?0:s,o=t.expectedLocation,a=void 0===o?0:o,c=t.distance,l=void 0===c?100:c,h=n/e.length,u=Math.abs(a-r);return l?h+u/l:u?1:h}},function(e,t){e.exports=function(){for(var e=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:1,i=[],n=-1,s=-1,r=0,o=e.length;r<o;r+=1){var a=e[r];a&&-1===n?n=r:a||-1===n||((s=r-1)-n+1>=t&&i.push([n,s]),n=-1)}return e[r-1]&&r-n>=t&&i.push([n,r-1]),i}},function(e,t){e.exports=function(e){for(var t={},i=e.length,n=0;n<i;n+=1)t[e.charAt(n)]=0;for(var s=0;s<i;s+=1)t[e.charAt(s)]|=1<<i-s-1;return t}},function(e,t,i){var n=i(0);e.exports=function(e,t){return function e(t,i,s){if(i){var r=i.indexOf("."),o=i,a=null;-1!==r&&(o=i.slice(0,r),a=i.slice(r+1));var c=t[o];if(null!=c)if(a||"string"!=typeof c&&"number"!=typeof c)if(n(c))for(var l=0,h=c.length;l<h;l+=1)e(c[l],a,s);else a&&e(c,a,s);else s.push(c.toString())}else s.push(t);return s}(e,t,[])}}])},function(e,t,i){"use strict";function n(e){var t,i=e.Symbol;return"function"==typeof i?i.observable?t=i.observable:(t=i("observable"),i.observable=t):t="@@observable",t}i.d(t,"a",(function(){return n}))},function(e,t,i){e.exports=i(7)},function(e,t){var i;i=function(){return this}();try{i=i||new Function("return this")()}catch(e){"object"==typeof window&&(i=window)}e.exports=i},function(e,t){e.exports=function(e){if(!e.webpackPolyfill){var t=Object.create(e);t.children||(t.children=[]),Object.defineProperty(t,"loaded",{enumerable:!0,get:function(){return t.l}}),Object.defineProperty(t,"id",{enumerable:!0,get:function(){return t.i}}),Object.defineProperty(t,"exports",{enumerable:!0}),t.webpackPolyfill=1}return t}},function(e,t,i){"use strict";i.r(t);var n=i(2),s=i.n(n),r=i(0),o=i.n(r),a=i(1),c=function(){return Math.random().toString(36).substring(7).split("").join(".")},l={INIT:"@@redux/INIT"+c(),REPLACE:"@@redux/REPLACE"+c(),PROBE_UNKNOWN_ACTION:function(){return"@@redux/PROBE_UNKNOWN_ACTION"+c()}};function h(e){if("object"!=typeof e||null===e)return!1;for(var t=e;null!==Object.getPrototypeOf(t);)t=Object.getPrototypeOf(t);return Object.getPrototypeOf(e)===t}function u(e,t,i){var n;if("function"==typeof t&&"function"==typeof i||"function"==typeof i&&"function"==typeof arguments[3])throw new Error("It looks like you are passing several store enhancers to createStore(). This is not supported. Instead, compose them together to a single function.");if("function"==typeof t&&void 0===i&&(i=t,t=void 0),void 0!==i){if("function"!=typeof i)throw new Error("Expected the enhancer to be a function.");return i(u)(e,t)}if("function"!=typeof e)throw new Error("Expected the reducer to be a function.");var s=e,r=t,o=[],c=o,d=!1;function p(){c===o&&(c=o.slice())}function m(){if(d)throw new Error("You may not call store.getState() while the reducer is executing. The reducer has already received the state as an argument. Pass it down from the top reducer instead of reading it from the store.");return r}function f(e){if("function"!=typeof e)throw new Error("Expected the listener to be a function.");if(d)throw new Error("You may not call store.subscribe() while the reducer is executing. If you would like to be notified after the store has been updated, subscribe from a component and invoke store.getState() in the callback to access the latest state. See https://redux.js.org/api-reference/store#subscribe(listener) for more details.");var t=!0;return p(),c.push(e),function(){if(t){if(d)throw new Error("You may not unsubscribe from a store listener while the reducer is executing. See https://redux.js.org/api-reference/store#subscribe(listener) for more details.");t=!1,p();var i=c.indexOf(e);c.splice(i,1)}}}function v(e){if(!h(e))throw new Error("Actions must be plain objects. Use custom middleware for async actions.");if(void 0===e.type)throw new Error('Actions may not have an undefined "type" property. Have you misspelled a constant?');if(d)throw new Error("Reducers may not dispatch actions.");try{d=!0,r=s(r,e)}finally{d=!1}for(var t=o=c,i=0;i<t.length;i++)(0,t[i])();return e}function g(e){if("function"!=typeof e)throw new Error("Expected the nextReducer to be a function.");s=e,v({type:l.REPLACE})}function _(){var e,t=f;return(e={subscribe:function(e){if("object"!=typeof e||null===e)throw new TypeError("Expected the observer to be an object.");function i(){e.next&&e.next(m())}return i(),{unsubscribe:t(i)}}})[a.a]=function(){return this},e}return v({type:l.INIT}),(n={dispatch:v,subscribe:f,getState:m,replaceReducer:g})[a.a]=_,n}function d(e,t){var i=t&&t.type;return"Given "+(i&&'action "'+String(i)+'"'||"an action")+', reducer "'+e+'" returned undefined. To ignore an action, you must explicitly return the previous state. If you want this reducer to hold no value, you can return null instead of undefined.'}var p,m=[],f=[],v=[],g={loading:!1},_=function(e,t){switch(void 0===e&&(e=g),t.type){case"SET_IS_LOADING":return{loading:t.isLoading};default:return e}},b=function(e){return Array.from({length:e},(function(){return(e=0,t=36,Math.floor(Math.random()*(t-e)+e)).toString(36);var e,t})).join("")},y=function(e){return Object.prototype.toString.call(e).slice(8,-1)},E=function(e,t){return null!=t&&y(t)===e},I=function(e){return"string"!=typeof e?e:e.replace(/&/g,"&amp;").replace(/>/g,"&rt;").replace(/</g,"&lt;").replace(/"/g,"&quot;")},S=(p=document.createElement("div"),function(e){var t=e.trim();p.innerHTML=t;for(var i=p.children[0];p.firstChild;)p.removeChild(p.firstChild);return i}),w=function(e,t){return e.score-t.score},O=function(e){return JSON.parse(JSON.stringify(e))},C=function(e){for(var t=Object.keys(e),i={},n=0;n<t.length;n++){var s=t[n];"function"==typeof e[s]&&(i[s]=e[s])}var r,o=Object.keys(i);try{!function(e){Object.keys(e).forEach((function(t){var i=e[t];if(void 0===i(void 0,{type:l.INIT}))throw new Error('Reducer "'+t+"\" returned undefined during initialization. If the state passed to the reducer is undefined, you must explicitly return the initial state. The initial state may not be undefined. If you don't want to set a value for this reducer, you can use null instead of undefined.");if(void 0===i(void 0,{type:l.PROBE_UNKNOWN_ACTION()}))throw new Error('Reducer "'+t+"\" returned undefined when probed with a random type. Don't try to handle "+l.INIT+' or other actions in "redux/*" namespace. They are considered private. Instead, you must return the current state for any unknown actions, unless it is undefined, in which case you must return the initial state, regardless of the action type. The initial state may not be undefined, but can be null.')}))}(i)}catch(e){r=e}return function(e,t){if(void 0===e&&(e={}),r)throw r;for(var n=!1,s={},a=0;a<o.length;a++){var c=o[a],l=i[c],h=e[c],u=l(h,t);if(void 0===u){var p=d(c,t);throw new Error(p)}s[c]=u,n=n||u!==h}return n?s:e}}({items:function(e,t){switch(void 0===e&&(e=m),t.type){case"ADD_ITEM":return[].concat(e,[{id:t.id,choiceId:t.choiceId,groupId:t.groupId,value:t.value,label:t.label,active:!0,highlighted:!1,customProperties:t.customProperties,placeholder:t.placeholder||!1,keyCode:null}]).map((function(e){var t=e;return t.highlighted=!1,t}));case"REMOVE_ITEM":return e.map((function(e){var i=e;return i.id===t.id&&(i.active=!1),i}));case"HIGHLIGHT_ITEM":return e.map((function(e){var i=e;return i.id===t.id&&(i.highlighted=t.highlighted),i}));default:return e}},groups:function(e,t){switch(void 0===e&&(e=f),t.type){case"ADD_GROUP":return[].concat(e,[{id:t.id,value:t.value,active:t.active,disabled:t.disabled}]);case"CLEAR_CHOICES":return[];default:return e}},choices:function(e,t){switch(void 0===e&&(e=v),t.type){case"ADD_CHOICE":return[].concat(e,[{id:t.id,elementId:t.elementId,groupId:t.groupId,value:t.value,label:t.label||t.value,disabled:t.disabled||!1,selected:!1,active:!0,score:9999,customProperties:t.customProperties,placeholder:t.placeholder||!1,keyCode:null}]);case"ADD_ITEM":return t.activateOptions?e.map((function(e){var i=e;return i.active=t.active,i})):t.choiceId>-1?e.map((function(e){var i=e;return i.id===parseInt(t.choiceId,10)&&(i.selected=!0),i})):e;case"REMOVE_ITEM":return t.choiceId>-1?e.map((function(e){var i=e;return i.id===parseInt(t.choiceId,10)&&(i.selected=!1),i})):e;case"FILTER_CHOICES":return e.map((function(e){var i=e;return i.active=t.results.some((function(e){var t=e.item,n=e.score;return t.id===i.id&&(i.score=n,!0)})),i}));case"ACTIVATE_CHOICES":return e.map((function(e){var i=e;return i.active=t.active,i}));case"CLEAR_CHOICES":return v;default:return e}},general:_}),A=function(e,t){var i=e;if("CLEAR_ALL"===t.type)i=void 0;else if("RESET_TO"===t.type)return O(t.state);return C(i,t)};function L(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var T=function(){function e(){this._store=u(A,window.__REDUX_DEVTOOLS_EXTENSION__&&window.__REDUX_DEVTOOLS_EXTENSION__())}var t,i,n,s=e.prototype;return s.subscribe=function(e){this._store.subscribe(e)},s.dispatch=function(e){this._store.dispatch(e)},s.isLoading=function(){return this.state.general.loading},s.getChoiceById=function(e){return this.activeChoices.find((function(t){return t.id===parseInt(e,10)}))},s.getGroupById=function(e){return this.groups.find((function(t){return t.id===e}))},t=e,(i=[{key:"state",get:function(){return this._store.getState()}},{key:"items",get:function(){return this.state.items}},{key:"activeItems",get:function(){return this.items.filter((function(e){return!0===e.active}))}},{key:"highlightedActiveItems",get:function(){return this.items.filter((function(e){return e.active&&e.highlighted}))}},{key:"choices",get:function(){return this.state.choices}},{key:"activeChoices",get:function(){return this.choices.filter((function(e){return!0===e.active}))}},{key:"selectableChoices",get:function(){return this.choices.filter((function(e){return!0!==e.disabled}))}},{key:"searchableChoices",get:function(){return this.selectableChoices.filter((function(e){return!0!==e.placeholder}))}},{key:"placeholderChoice",get:function(){return[].concat(this.choices).reverse().find((function(e){return!0===e.placeholder}))}},{key:"groups",get:function(){return this.state.groups}},{key:"activeGroups",get:function(){var e=this.groups,t=this.choices;return e.filter((function(e){var i=!0===e.active&&!1===e.disabled,n=t.some((function(e){return!0===e.active&&!1===e.disabled}));return i&&n}),[])}}])&&L(t.prototype,i),n&&L(t,n),e}();function x(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var k=function(){function e(e){var t=e.element,i=e.type,n=e.classNames;this.element=t,this.classNames=n,this.type=i,this.isActive=!1}var t,i,n,s=e.prototype;return s.getChild=function(e){return this.element.querySelector(e)},s.show=function(){return this.element.classList.add(this.classNames.activeState),this.element.setAttribute("aria-expanded","true"),this.isActive=!0,this},s.hide=function(){return this.element.classList.remove(this.classNames.activeState),this.element.setAttribute("aria-expanded","false"),this.isActive=!1,this},t=e,(i=[{key:"distanceFromTopWindow",get:function(){return this.element.getBoundingClientRect().bottom}}])&&x(t.prototype,i),n&&x(t,n),e}(),P={items:[],choices:[],silent:!1,renderChoiceLimit:-1,maxItemCount:-1,addItems:!0,addItemFilter:null,removeItems:!0,removeItemButton:!1,editItems:!1,duplicateItemsAllowed:!0,delimiter:",",paste:!0,searchEnabled:!0,searchChoices:!0,searchFloor:1,searchResultLimit:4,searchFields:["label","value"],position:"auto",resetScrollPosition:!0,shouldSort:!0,shouldSortItems:!1,sorter:function(e,t){var i=e.value,n=e.label,s=void 0===n?i:n,r=t.value,o=t.label,a=void 0===o?r:o;return s.localeCompare(a,[],{sensitivity:"base",ignorePunctuation:!0,numeric:!0})},placeholder:!0,placeholderValue:null,searchPlaceholderValue:null,prependValue:null,appendValue:null,renderSelectedChoices:"auto",loadingText:"Loading...",noResultsText:"No results found",noChoicesText:"No choices to choose from",itemSelectText:"Press to select",uniqueItemText:"Only unique values can be added",customAddItemText:"Only values matching specific conditions can be added",addItemText:function(e){return'Press Enter to add <b>"'+I(e)+'"</b>'},maxItemText:function(e){return"Only "+e+" values can be added"},valueComparer:function(e,t){return e===t},fuseOptions:{includeScore:!0},callbackOnInit:null,callbackOnCreateTemplates:null,classNames:{containerOuter:"choices",containerInner:"choices__inner",input:"choices__input",inputCloned:"choices__input--cloned",list:"choices__list",listItems:"choices__list--multiple",listSingle:"choices__list--single",listDropdown:"choices__list--dropdown",item:"choices__item",itemSelectable:"choices__item--selectable",itemDisabled:"choices__item--disabled",itemChoice:"choices__item--choice",placeholder:"choices__placeholder",group:"choices__group",groupHeading:"choices__heading",button:"choices__button",activeState:"is-active",focusState:"is-focused",openState:"is-open",disabledState:"is-disabled",highlightedState:"is-highlighted",selectedState:"is-selected",flippedState:"is-flipped",loadingState:"is-loading",noResults:"has-no-results",noChoices:"has-no-choices"}},D="showDropdown",M="hideDropdown",N="change",F="choice",j="search",K="addItem",R="removeItem",H="highlightItem",B="highlightChoice",V="ADD_CHOICE",G="FILTER_CHOICES",q="ACTIVATE_CHOICES",U="CLEAR_CHOICES",z="ADD_GROUP",W="ADD_ITEM",X="REMOVE_ITEM",$="HIGHLIGHT_ITEM",J=46,Y=8,Z=13,Q=65,ee=27,te=38,ie=40,ne=33,se=34,re="text",oe="select-one",ae="select-multiple",ce=function(){function e(e){var t=e.element,i=e.type,n=e.classNames,s=e.position;this.element=t,this.classNames=n,this.type=i,this.position=s,this.isOpen=!1,this.isFlipped=!1,this.isFocussed=!1,this.isDisabled=!1,this.isLoading=!1,this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this)}var t=e.prototype;return t.addEventListeners=function(){this.element.addEventListener("focus",this._onFocus),this.element.addEventListener("blur",this._onBlur)},t.removeEventListeners=function(){this.element.removeEventListener("focus",this._onFocus),this.element.removeEventListener("blur",this._onBlur)},t.shouldFlip=function(e){if("number"!=typeof e)return!1;var t=!1;return"auto"===this.position?t=!window.matchMedia("(min-height: "+(e+1)+"px)").matches:"top"===this.position&&(t=!0),t},t.setActiveDescendant=function(e){this.element.setAttribute("aria-activedescendant",e)},t.removeActiveDescendant=function(){this.element.removeAttribute("aria-activedescendant")},t.open=function(e){this.element.classList.add(this.classNames.openState),this.element.setAttribute("aria-expanded","true"),this.isOpen=!0,this.shouldFlip(e)&&(this.element.classList.add(this.classNames.flippedState),this.isFlipped=!0)},t.close=function(){this.element.classList.remove(this.classNames.openState),this.element.setAttribute("aria-expanded","false"),this.removeActiveDescendant(),this.isOpen=!1,this.isFlipped&&(this.element.classList.remove(this.classNames.flippedState),this.isFlipped=!1)},t.focus=function(){this.isFocussed||this.element.focus()},t.addFocusState=function(){this.element.classList.add(this.classNames.focusState)},t.removeFocusState=function(){this.element.classList.remove(this.classNames.focusState)},t.enable=function(){this.element.classList.remove(this.classNames.disabledState),this.element.removeAttribute("aria-disabled"),this.type===oe&&this.element.setAttribute("tabindex","0"),this.isDisabled=!1},t.disable=function(){this.element.classList.add(this.classNames.disabledState),this.element.setAttribute("aria-disabled","true"),this.type===oe&&this.element.setAttribute("tabindex","-1"),this.isDisabled=!0},t.wrap=function(e){!function(e,t){void 0===t&&(t=document.createElement("div")),e.nextSibling?e.parentNode.insertBefore(t,e.nextSibling):e.parentNode.appendChild(t),t.appendChild(e)}(e,this.element)},t.unwrap=function(e){this.element.parentNode.insertBefore(e,this.element),this.element.parentNode.removeChild(this.element)},t.addLoadingState=function(){this.element.classList.add(this.classNames.loadingState),this.element.setAttribute("aria-busy","true"),this.isLoading=!0},t.removeLoadingState=function(){this.element.classList.remove(this.classNames.loadingState),this.element.removeAttribute("aria-busy"),this.isLoading=!1},t._onFocus=function(){this.isFocussed=!0},t._onBlur=function(){this.isFocussed=!1},e}();function le(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var he=function(){function e(e){var t=e.element,i=e.type,n=e.classNames,s=e.preventPaste;this.element=t,this.type=i,this.classNames=n,this.preventPaste=s,this.isFocussed=this.element===document.activeElement,this.isDisabled=t.disabled,this._onPaste=this._onPaste.bind(this),this._onInput=this._onInput.bind(this),this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this)}var t,i,n,s=e.prototype;return s.addEventListeners=function(){this.element.addEventListener("paste",this._onPaste),this.element.addEventListener("input",this._onInput,{passive:!0}),this.element.addEventListener("focus",this._onFocus,{passive:!0}),this.element.addEventListener("blur",this._onBlur,{passive:!0})},s.removeEventListeners=function(){this.element.removeEventListener("input",this._onInput,{passive:!0}),this.element.removeEventListener("paste",this._onPaste),this.element.removeEventListener("focus",this._onFocus,{passive:!0}),this.element.removeEventListener("blur",this._onBlur,{passive:!0})},s.enable=function(){this.element.removeAttribute("disabled"),this.isDisabled=!1},s.disable=function(){this.element.setAttribute("disabled",""),this.isDisabled=!0},s.focus=function(){this.isFocussed||this.element.focus()},s.blur=function(){this.isFocussed&&this.element.blur()},s.clear=function(e){return void 0===e&&(e=!0),this.element.value&&(this.element.value=""),e&&this.setWidth(),this},s.setWidth=function(){var e=this.element,t=e.style,i=e.value,n=e.placeholder;t.minWidth=n.length+1+"ch",t.width=i.length+1+"ch"},s.setActiveDescendant=function(e){this.element.setAttribute("aria-activedescendant",e)},s.removeActiveDescendant=function(){this.element.removeAttribute("aria-activedescendant")},s._onInput=function(){this.type!==oe&&this.setWidth()},s._onPaste=function(e){this.preventPaste&&e.preventDefault()},s._onFocus=function(){this.isFocussed=!0},s._onBlur=function(){this.isFocussed=!1},t=e,(i=[{key:"placeholder",set:function(e){this.element.placeholder=e}},{key:"value",get:function(){return I(this.element.value)},set:function(e){this.element.value=e}}])&&le(t.prototype,i),n&&le(t,n),e}(),ue=function(){function e(e){var t=e.element;this.element=t,this.scrollPos=this.element.scrollTop,this.height=this.element.offsetHeight}var t=e.prototype;return t.clear=function(){this.element.innerHTML=""},t.append=function(e){this.element.appendChild(e)},t.getChild=function(e){return this.element.querySelector(e)},t.hasChildren=function(){return this.element.hasChildNodes()},t.scrollToTop=function(){this.element.scrollTop=0},t.scrollToChildElement=function(e,t){var i=this;if(e){var n=this.element.offsetHeight,s=this.element.scrollTop+n,r=e.offsetHeight,o=e.offsetTop+r,a=t>0?this.element.scrollTop+o-s:e.offsetTop;requestAnimationFrame((function(){i._animateScroll(a,t)}))}},t._scrollDown=function(e,t,i){var n=(i-e)/t,s=n>1?n:1;this.element.scrollTop=e+s},t._scrollUp=function(e,t,i){var n=(e-i)/t,s=n>1?n:1;this.element.scrollTop=e-s},t._animateScroll=function(e,t){var i=this,n=this.element.scrollTop,s=!1;t>0?(this._scrollDown(n,4,e),n<e&&(s=!0)):(this._scrollUp(n,4,e),n>e&&(s=!0)),s&&requestAnimationFrame((function(){i._animateScroll(e,t)}))},e}();function de(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var pe=function(){function e(e){var t=e.element,i=e.classNames;if(this.element=t,this.classNames=i,!(t instanceof HTMLInputElement||t instanceof HTMLSelectElement))throw new TypeError("Invalid element passed");this.isDisabled=!1}var t,i,n,s=e.prototype;return s.conceal=function(){this.element.classList.add(this.classNames.input),this.element.hidden=!0,this.element.tabIndex=-1;var e=this.element.getAttribute("style");e&&this.element.setAttribute("data-choice-orig-style",e),this.element.setAttribute("data-choice","active")},s.reveal=function(){this.element.classList.remove(this.classNames.input),this.element.hidden=!1,this.element.removeAttribute("tabindex");var e=this.element.getAttribute("data-choice-orig-style");e?(this.element.removeAttribute("data-choice-orig-style"),this.element.setAttribute("style",e)):this.element.removeAttribute("style"),this.element.removeAttribute("data-choice"),this.element.value=this.element.value},s.enable=function(){this.element.removeAttribute("disabled"),this.element.disabled=!1,this.isDisabled=!1},s.disable=function(){this.element.setAttribute("disabled",""),this.element.disabled=!0,this.isDisabled=!0},s.triggerEvent=function(e,t){!function(e,t,i){void 0===i&&(i=null);var n=new CustomEvent(t,{detail:i,bubbles:!0,cancelable:!0});e.dispatchEvent(n)}(this.element,e,t)},t=e,(i=[{key:"isActive",get:function(){return"active"===this.element.dataset.choice}},{key:"dir",get:function(){return this.element.dir}},{key:"value",get:function(){return this.element.value},set:function(e){this.element.value=e}}])&&de(t.prototype,i),n&&de(t,n),e}();function me(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var fe=function(e){var t,i,n,s,r;function o(t){var i,n=t.element,s=t.classNames,r=t.delimiter;return(i=e.call(this,{element:n,classNames:s})||this).delimiter=r,i}return i=e,(t=o).prototype=Object.create(i.prototype),t.prototype.constructor=t,t.__proto__=i,n=o,(s=[{key:"value",get:function(){return this.element.value},set:function(e){var t=e.map((function(e){return e.value})).join(this.delimiter);this.element.setAttribute("value",t),this.element.value=t}}])&&me(n.prototype,s),r&&me(n,r),o}(pe);function ve(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var ge=function(e){var t,i,n,s,r;function o(t){var i,n=t.element,s=t.classNames,r=t.template;return(i=e.call(this,{element:n,classNames:s})||this).template=r,i}return i=e,(t=o).prototype=Object.create(i.prototype),t.prototype.constructor=t,t.__proto__=i,o.prototype.appendDocFragment=function(e){this.element.innerHTML="",this.element.appendChild(e)},n=o,(s=[{key:"placeholderOption",get:function(){return this.element.querySelector('option[value=""]')||this.element.querySelector("option[placeholder]")}},{key:"optionGroups",get:function(){return Array.from(this.element.getElementsByTagName("OPTGROUP"))}},{key:"options",get:function(){return Array.from(this.element.options)},set:function(e){var t=this,i=document.createDocumentFragment();e.forEach((function(e){return n=e,s=t.template(n),void i.appendChild(s);var n,s})),this.appendDocFragment(i)}}])&&ve(n.prototype,s),r&&ve(n,r),o}(pe),_e={containerOuter:function(e,t,i,n,s,r){var o=e.containerOuter,a=Object.assign(document.createElement("div"),{className:o});return a.dataset.type=r,t&&(a.dir=t),n&&(a.tabIndex=0),i&&(a.setAttribute("role",s?"combobox":"listbox"),s&&a.setAttribute("aria-autocomplete","list")),a.setAttribute("aria-haspopup","true"),a.setAttribute("aria-expanded","false"),a},containerInner:function(e){var t=e.containerInner;return Object.assign(document.createElement("div"),{className:t})},itemList:function(e,t){var i=e.list,n=e.listSingle,s=e.listItems;return Object.assign(document.createElement("div"),{className:i+" "+(t?n:s)})},placeholder:function(e,t){var i=e.placeholder;return Object.assign(document.createElement("div"),{className:i,innerHTML:t})},item:function(e,t,i){var n=e.item,s=e.button,r=e.highlightedState,o=e.itemSelectable,a=e.placeholder,c=t.id,l=t.value,h=t.label,u=t.customProperties,d=t.active,p=t.disabled,m=t.highlighted,f=t.placeholder,v=Object.assign(document.createElement("div"),{className:n,innerHTML:h});if(Object.assign(v.dataset,{item:"",id:c,value:l,customProperties:u}),d&&v.setAttribute("aria-selected","true"),p&&v.setAttribute("aria-disabled","true"),f&&v.classList.add(a),v.classList.add(m?r:o),i){p&&v.classList.remove(o),v.dataset.deletable="";var g="Remove item",_=Object.assign(document.createElement("button"),{type:"button",className:s,innerHTML:g});_.setAttribute("aria-label","Remove item: '"+l+"'"),_.dataset.button="",v.appendChild(_)}return v},choiceList:function(e,t){var i=e.list,n=Object.assign(document.createElement("div"),{className:i});return t||n.setAttribute("aria-multiselectable","true"),n.setAttribute("role","listbox"),n},choiceGroup:function(e,t){var i=e.group,n=e.groupHeading,s=e.itemDisabled,r=t.id,o=t.value,a=t.disabled,c=Object.assign(document.createElement("div"),{className:i+" "+(a?s:"")});return c.setAttribute("role","group"),Object.assign(c.dataset,{group:"",id:r,value:o}),a&&c.setAttribute("aria-disabled","true"),c.appendChild(Object.assign(document.createElement("div"),{className:n,innerHTML:o})),c},choice:function(e,t,i){var n=e.item,s=e.itemChoice,r=e.itemSelectable,o=e.selectedState,a=e.itemDisabled,c=e.placeholder,l=t.id,h=t.value,u=t.label,d=t.groupId,p=t.elementId,m=t.disabled,f=t.selected,v=t.placeholder,g=Object.assign(document.createElement("div"),{id:p,innerHTML:u,className:n+" "+s});return f&&g.classList.add(o),v&&g.classList.add(c),g.setAttribute("role",d>0?"treeitem":"option"),Object.assign(g.dataset,{choice:"",id:l,value:h,selectText:i}),m?(g.classList.add(a),g.dataset.choiceDisabled="",g.setAttribute("aria-disabled","true")):(g.classList.add(r),g.dataset.choiceSelectable=""),g},input:function(e,t){var i=e.input,n=e.inputCloned,s=Object.assign(document.createElement("input"),{type:"text",className:i+" "+n,autocomplete:"off",autocapitalize:"off",spellcheck:!1});return s.setAttribute("role","textbox"),s.setAttribute("aria-autocomplete","list"),s.setAttribute("aria-label",t),s},dropdown:function(e){var t=e.list,i=e.listDropdown,n=document.createElement("div");return n.classList.add(t,i),n.setAttribute("aria-expanded","false"),n},notice:function(e,t,i){var n=e.item,s=e.itemChoice,r=e.noResults,o=e.noChoices;void 0===i&&(i="");var a=[n,s];return"no-choices"===i?a.push(o):"no-results"===i&&a.push(r),Object.assign(document.createElement("div"),{innerHTML:t,className:a.join(" ")})},option:function(e){var t=e.label,i=e.value,n=e.customProperties,s=e.active,r=e.disabled,o=new Option(t,i,!1,s);return n&&(o.dataset.customProperties=n),o.disabled=r,o}},be=function(e){return void 0===e&&(e=!0),{type:q,active:e}},ye=function(e,t){return{type:$,id:e,highlighted:t}},Ee=function(e){var t=e.value,i=e.id,n=e.active,s=e.disabled;return{type:z,value:t,id:i,active:n,disabled:s}},Ie=function(e){return{type:"SET_IS_LOADING",isLoading:e}};function Se(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}var we="-ms-scroll-limit"in document.documentElement.style&&"-ms-ime-align"in document.documentElement.style,Oe={},Ce=function(){var e,t,i;function n(e,t){var i=this;void 0===e&&(e="[data-choice]"),void 0===t&&(t={}),this.config=o.a.all([P,n.defaults.options,t],{arrayMerge:function(e,t){return[].concat(t)}});var s,r,a,c,l=(s=this.config,r=P,a=Object.keys(s).sort(),c=Object.keys(r).sort(),a.filter((function(e){return c.indexOf(e)<0})));l.length&&console.warn("Unknown config option(s) passed",l.join(", "));var h="string"==typeof e?document.querySelector(e):e;if(!(h instanceof HTMLInputElement||h instanceof HTMLSelectElement))throw TypeError("Expected one of the following types text|select-one|select-multiple");if(this._isTextElement=h.type===re,this._isSelectOneElement=h.type===oe,this._isSelectMultipleElement=h.type===ae,this._isSelectElement=this._isSelectOneElement||this._isSelectMultipleElement,this.config.searchEnabled=this._isSelectMultipleElement||this.config.searchEnabled,["auto","always"].includes(this.config.renderSelectedChoices)||(this.config.renderSelectedChoices="auto"),t.addItemFilter&&"function"!=typeof t.addItemFilter){var u=t.addItemFilter instanceof RegExp?t.addItemFilter:new RegExp(t.addItemFilter);this.config.addItemFilter=u.test.bind(u)}if(this._isTextElement?this.passedElement=new fe({element:h,classNames:this.config.classNames,delimiter:this.config.delimiter}):this.passedElement=new ge({element:h,classNames:this.config.classNames,template:function(e){return i._templates.option(e)}}),this.initialised=!1,this._store=new T,this._initialState={},this._currentState={},this._prevState={},this._currentValue="",this._canSearch=this.config.searchEnabled,this._isScrollingOnIe=!1,this._highlightPosition=0,this._wasTap=!0,this._placeholderValue=this._generatePlaceholderValue(),this._baseId=function(e,t){var i=e.id||e.name&&e.name+"-"+b(2)||b(4);return t+"-"+i.replace(/(:|\.|\[|\]|,)/g,"")}(this.passedElement.element,"choices-"),this._direction=this.passedElement.dir,!this._direction){var d=window.getComputedStyle(this.passedElement.element).direction;d!==window.getComputedStyle(document.documentElement).direction&&(this._direction=d)}if(this._idNames={itemChoice:"item-choice"},this._presetGroups=this.passedElement.optionGroups,this._presetOptions=this.passedElement.options,this._presetChoices=this.config.choices,this._presetItems=this.config.items,this.passedElement.value&&(this._presetItems=this._presetItems.concat(this.passedElement.value.split(this.config.delimiter))),this.passedElement.options&&this.passedElement.options.forEach((function(e){i._presetChoices.push({value:e.value,label:e.innerHTML,selected:e.selected,disabled:e.disabled||e.parentNode.disabled,placeholder:""===e.value||e.hasAttribute("placeholder"),customProperties:e.getAttribute("data-custom-properties")})})),this._render=this._render.bind(this),this._onFocus=this._onFocus.bind(this),this._onBlur=this._onBlur.bind(this),this._onKeyUp=this._onKeyUp.bind(this),this._onKeyDown=this._onKeyDown.bind(this),this._onClick=this._onClick.bind(this),this._onTouchMove=this._onTouchMove.bind(this),this._onTouchEnd=this._onTouchEnd.bind(this),this._onMouseDown=this._onMouseDown.bind(this),this._onMouseOver=this._onMouseOver.bind(this),this._onFormReset=this._onFormReset.bind(this),this._onAKey=this._onAKey.bind(this),this._onEnterKey=this._onEnterKey.bind(this),this._onEscapeKey=this._onEscapeKey.bind(this),this._onDirectionKey=this._onDirectionKey.bind(this),this._onDeleteKey=this._onDeleteKey.bind(this),this.passedElement.isActive)return this.config.silent||console.warn("Trying to initialise Choices on element already initialised"),void(this.initialised=!0);this.init()}e=n,i=[{key:"defaults",get:function(){return Object.preventExtensions({get options(){return Oe},get templates(){return _e}})}}],(t=null)&&Se(e.prototype,t),i&&Se(e,i);var r=n.prototype;return r.init=function(){if(!this.initialised){this._createTemplates(),this._createElements(),this._createStructure(),this._initialState=O(this._store.state),this._store.subscribe(this._render),this._render(),this._addEventListeners(),(!this.config.addItems||this.passedElement.element.hasAttribute("disabled"))&&this.disable(),this.initialised=!0;var e=this.config.callbackOnInit;e&&"function"==typeof e&&e.call(this)}},r.destroy=function(){this.initialised&&(this._removeEventListeners(),this.passedElement.reveal(),this.containerOuter.unwrap(this.passedElement.element),this.clearStore(),this._isSelectElement&&(this.passedElement.options=this._presetOptions),this._templates=null,this.initialised=!1)},r.enable=function(){return this.passedElement.isDisabled&&this.passedElement.enable(),this.containerOuter.isDisabled&&(this._addEventListeners(),this.input.enable(),this.containerOuter.enable()),this},r.disable=function(){return this.passedElement.isDisabled||this.passedElement.disable(),this.containerOuter.isDisabled||(this._removeEventListeners(),this.input.disable(),this.containerOuter.disable()),this},r.highlightItem=function(e,t){if(void 0===t&&(t=!0),!e)return this;var i=e.id,n=e.groupId,s=void 0===n?-1:n,r=e.value,o=void 0===r?"":r,a=e.label,c=void 0===a?"":a,l=s>=0?this._store.getGroupById(s):null;return this._store.dispatch(ye(i,!0)),t&&this.passedElement.triggerEvent(H,{id:i,value:o,label:c,groupValue:l&&l.value?l.value:null}),this},r.unhighlightItem=function(e){if(!e)return this;var t=e.id,i=e.groupId,n=void 0===i?-1:i,s=e.value,r=void 0===s?"":s,o=e.label,a=void 0===o?"":o,c=n>=0?this._store.getGroupById(n):null;return this._store.dispatch(ye(t,!1)),this.passedElement.triggerEvent(H,{id:t,value:r,label:a,groupValue:c&&c.value?c.value:null}),this},r.highlightAll=function(){var e=this;return this._store.items.forEach((function(t){return e.highlightItem(t)})),this},r.unhighlightAll=function(){var e=this;return this._store.items.forEach((function(t){return e.unhighlightItem(t)})),this},r.removeActiveItemsByValue=function(e){var t=this;return this._store.activeItems.filter((function(t){return t.value===e})).forEach((function(e){return t._removeItem(e)})),this},r.removeActiveItems=function(e){var t=this;return this._store.activeItems.filter((function(t){return t.id!==e})).forEach((function(e){return t._removeItem(e)})),this},r.removeHighlightedItems=function(e){var t=this;return void 0===e&&(e=!1),this._store.highlightedActiveItems.forEach((function(i){t._removeItem(i),e&&t._triggerChange(i.value)})),this},r.showDropdown=function(e){var t=this;return this.dropdown.isActive||requestAnimationFrame((function(){t.dropdown.show(),t.containerOuter.open(t.dropdown.distanceFromTopWindow),!e&&t._canSearch&&t.input.focus(),t.passedElement.triggerEvent(D,{})})),this},r.hideDropdown=function(e){var t=this;return this.dropdown.isActive?(requestAnimationFrame((function(){t.dropdown.hide(),t.containerOuter.close(),!e&&t._canSearch&&(t.input.removeActiveDescendant(),t.input.blur()),t.passedElement.triggerEvent(M,{})})),this):this},r.getValue=function(e){void 0===e&&(e=!1);var t=this._store.activeItems.reduce((function(t,i){var n=e?i.value:i;return t.push(n),t}),[]);return this._isSelectOneElement?t[0]:t},r.setValue=function(e){var t=this;return this.initialised?(e.forEach((function(e){return t._setChoiceOrItem(e)})),this):this},r.setChoiceByValue=function(e){var t=this;return!this.initialised||this._isTextElement||(Array.isArray(e)?e:[e]).forEach((function(e){return t._findAndSelectChoiceByValue(e)})),this},r.setChoices=function(e,t,i,n){var s=this;if(void 0===e&&(e=[]),void 0===t&&(t="value"),void 0===i&&(i="label"),void 0===n&&(n=!1),!this.initialised)throw new ReferenceError("setChoices was called on a non-initialized instance of Choices");if(!this._isSelectElement)throw new TypeError("setChoices can't be used with INPUT based Choices");if("string"!=typeof t||!t)throw new TypeError("value parameter must be a name of 'value' field in passed objects");if(n&&this.clearChoices(),"function"==typeof e){var r=e(this);if("function"==typeof Promise&&r instanceof Promise)return new Promise((function(e){return requestAnimationFrame(e)})).then((function(){return s._handleLoadingState(!0)})).then((function(){return r})).then((function(e){return s.setChoices(e,t,i,n)})).catch((function(e){s.config.silent||console.error(e)})).then((function(){return s._handleLoadingState(!1)})).then((function(){return s}));if(!Array.isArray(r))throw new TypeError(".setChoices first argument function must return either array of choices or Promise, got: "+typeof r);return this.setChoices(r,t,i,!1)}if(!Array.isArray(e))throw new TypeError(".setChoices must be called either with array of choices with a function resulting into Promise of array of choices");return this.containerOuter.removeLoadingState(),this._startLoading(),e.forEach((function(e){e.choices?s._addGroup({id:parseInt(e.id,10)||null,group:e,valueKey:t,labelKey:i}):s._addChoice({value:e[t],label:e[i],isSelected:e.selected,isDisabled:e.disabled,customProperties:e.customProperties,placeholder:e.placeholder})})),this._stopLoading(),this},r.clearChoices=function(){return this._store.dispatch({type:U}),this},r.clearStore=function(){return this._store.dispatch({type:"CLEAR_ALL"}),this},r.clearInput=function(){var e=!this._isSelectOneElement;return this.input.clear(e),!this._isTextElement&&this._canSearch&&(this._isSearching=!1,this._store.dispatch(be(!0))),this},r._render=function(){if(!this._store.isLoading()){this._currentState=this._store.state;var e=this._currentState.choices!==this._prevState.choices||this._currentState.groups!==this._prevState.groups||this._currentState.items!==this._prevState.items,t=this._isSelectElement,i=this._currentState.items!==this._prevState.items;e&&(t&&this._renderChoices(),i&&this._renderItems(),this._prevState=this._currentState)}},r._renderChoices=function(){var e=this,t=this._store,i=t.activeGroups,n=t.activeChoices,s=document.createDocumentFragment();if(this.choiceList.clear(),this.config.resetScrollPosition&&requestAnimationFrame((function(){return e.choiceList.scrollToTop()})),i.length>=1&&!this._isSearching){var r=n.filter((function(e){return!0===e.placeholder&&-1===e.groupId}));r.length>=1&&(s=this._createChoicesFragment(r,s)),s=this._createGroupsFragment(i,n,s)}else n.length>=1&&(s=this._createChoicesFragment(n,s));if(s.childNodes&&s.childNodes.length>0){var o=this._store.activeItems,a=this._canAddItem(o,this.input.value);a.response?(this.choiceList.append(s),this._highlightChoice()):this.choiceList.append(this._getTemplate("notice",a.notice))}else{var c,l;this._isSearching?(l="function"==typeof this.config.noResultsText?this.config.noResultsText():this.config.noResultsText,c=this._getTemplate("notice",l,"no-results")):(l="function"==typeof this.config.noChoicesText?this.config.noChoicesText():this.config.noChoicesText,c=this._getTemplate("notice",l,"no-choices")),this.choiceList.append(c)}},r._renderItems=function(){var e=this._store.activeItems||[];this.itemList.clear();var t=this._createItemsFragment(e);t.childNodes&&this.itemList.append(t)},r._createGroupsFragment=function(e,t,i){var n=this;return void 0===i&&(i=document.createDocumentFragment()),this.config.shouldSort&&e.sort(this.config.sorter),e.forEach((function(e){var s=function(e){return t.filter((function(t){return n._isSelectOneElement?t.groupId===e.id:t.groupId===e.id&&("always"===n.config.renderSelectedChoices||!t.selected)}))}(e);if(s.length>=1){var r=n._getTemplate("choiceGroup",e);i.appendChild(r),n._createChoicesFragment(s,i,!0)}})),i},r._createChoicesFragment=function(e,t,i){var n=this;void 0===t&&(t=document.createDocumentFragment()),void 0===i&&(i=!1);var s=this.config,r=s.renderSelectedChoices,o=s.searchResultLimit,a=s.renderChoiceLimit,c=this._isSearching?w:this.config.sorter,l=function(e){if("auto"!==r||n._isSelectOneElement||!e.selected){var i=n._getTemplate("choice",e,n.config.itemSelectText);t.appendChild(i)}},h=e;"auto"!==r||this._isSelectOneElement||(h=e.filter((function(e){return!e.selected})));var u=h.reduce((function(e,t){return t.placeholder?e.placeholderChoices.push(t):e.normalChoices.push(t),e}),{placeholderChoices:[],normalChoices:[]}),d=u.placeholderChoices,p=u.normalChoices;(this.config.shouldSort||this._isSearching)&&p.sort(c);var m=h.length,f=this._isSelectOneElement?[].concat(d,p):p;this._isSearching?m=o:a&&a>0&&!i&&(m=a);for(var v=0;v<m;v+=1)f[v]&&l(f[v]);return t},r._createItemsFragment=function(e,t){var i=this;void 0===t&&(t=document.createDocumentFragment());var n=this.config,s=n.shouldSortItems,r=n.sorter,o=n.removeItemButton;return s&&!this._isSelectOneElement&&e.sort(r),this._isTextElement?this.passedElement.value=e:this.passedElement.options=e,e.forEach((function(e){var n=i._getTemplate("item",e,o);t.appendChild(n)})),t},r._triggerChange=function(e){null!=e&&this.passedElement.triggerEvent(N,{value:e})},r._selectPlaceholderChoice=function(){var e=this._store.placeholderChoice;e&&(this._addItem({value:e.value,label:e.label,choiceId:e.id,groupId:e.groupId,placeholder:e.placeholder}),this._triggerChange(e.value))},r._handleButtonAction=function(e,t){if(e&&t&&this.config.removeItems&&this.config.removeItemButton){var i=t.parentNode.getAttribute("data-id"),n=e.find((function(e){return e.id===parseInt(i,10)}));this._removeItem(n),this._triggerChange(n.value),this._isSelectOneElement&&this._selectPlaceholderChoice()}},r._handleItemAction=function(e,t,i){var n=this;if(void 0===i&&(i=!1),e&&t&&this.config.removeItems&&!this._isSelectOneElement){var s=t.getAttribute("data-id");e.forEach((function(e){e.id!==parseInt(s,10)||e.highlighted?!i&&e.highlighted&&n.unhighlightItem(e):n.highlightItem(e)})),this.input.focus()}},r._handleChoiceAction=function(e,t){if(e&&t){var i=t.dataset.id,n=this._store.getChoiceById(i);if(n){var s=e[0]&&e[0].keyCode?e[0].keyCode:null,r=this.dropdown.isActive;n.keyCode=s,this.passedElement.triggerEvent(F,{choice:n}),n.selected||n.disabled||this._canAddItem(e,n.value).response&&(this._addItem({value:n.value,label:n.label,choiceId:n.id,groupId:n.groupId,customProperties:n.customProperties,placeholder:n.placeholder,keyCode:n.keyCode}),this._triggerChange(n.value)),this.clearInput(),r&&this._isSelectOneElement&&(this.hideDropdown(!0),this.containerOuter.focus())}}},r._handleBackspace=function(e){if(this.config.removeItems&&e){var t=e[e.length-1],i=e.some((function(e){return e.highlighted}));this.config.editItems&&!i&&t?(this.input.value=t.value,this.input.setWidth(),this._removeItem(t),this._triggerChange(t.value)):(i||this.highlightItem(t,!1),this.removeHighlightedItems(!0))}},r._startLoading=function(){this._store.dispatch(Ie(!0))},r._stopLoading=function(){this._store.dispatch(Ie(!1))},r._handleLoadingState=function(e){void 0===e&&(e=!0);var t=this.itemList.getChild("."+this.config.classNames.placeholder);e?(this.disable(),this.containerOuter.addLoadingState(),this._isSelectOneElement?t?t.innerHTML=this.config.loadingText:(t=this._getTemplate("placeholder",this.config.loadingText),this.itemList.append(t)):this.input.placeholder=this.config.loadingText):(this.enable(),this.containerOuter.removeLoadingState(),this._isSelectOneElement?t.innerHTML=this._placeholderValue||"":this.input.placeholder=this._placeholderValue||"")},r._handleSearch=function(e){if(e&&this.input.isFocussed){var t=this._store.choices,i=this.config,n=i.searchFloor,s=i.searchChoices,r=t.some((function(e){return!e.active}));if(e&&e.length>=n){var o=s?this._searchChoices(e):0;this.passedElement.triggerEvent(j,{value:e,resultCount:o})}else r&&(this._isSearching=!1,this._store.dispatch(be(!0)))}},r._canAddItem=function(e,t){var i=!0,n="function"==typeof this.config.addItemText?this.config.addItemText(t):this.config.addItemText;if(!this._isSelectOneElement){var s=function(e,t,i){return void 0===i&&(i="value"),e.some((function(e){return"string"==typeof t?e[i]===t.trim():e[i]===t}))}(e,t);this.config.maxItemCount>0&&this.config.maxItemCount<=e.length&&(i=!1,n="function"==typeof this.config.maxItemText?this.config.maxItemText(this.config.maxItemCount):this.config.maxItemText),!this.config.duplicateItemsAllowed&&s&&i&&(i=!1,n="function"==typeof this.config.uniqueItemText?this.config.uniqueItemText(t):this.config.uniqueItemText),this._isTextElement&&this.config.addItems&&i&&"function"==typeof this.config.addItemFilter&&!this.config.addItemFilter(t)&&(i=!1,n="function"==typeof this.config.customAddItemText?this.config.customAddItemText(t):this.config.customAddItemText)}return{response:i,notice:n}},r._searchChoices=function(e){var t="string"==typeof e?e.trim():e,i="string"==typeof this._currentValue?this._currentValue.trim():this._currentValue;if(t.length<1&&t===i+" ")return 0;var n=this._store.searchableChoices,r=t,o=[].concat(this.config.searchFields),a=Object.assign(this.config.fuseOptions,{keys:o}),c=new s.a(n,a).search(r);return this._currentValue=t,this._highlightPosition=0,this._isSearching=!0,this._store.dispatch(function(e){return{type:G,results:e}}(c)),c.length},r._addEventListeners=function(){var e=document.documentElement;e.addEventListener("touchend",this._onTouchEnd,!0),this.containerOuter.element.addEventListener("keydown",this._onKeyDown,!0),this.containerOuter.element.addEventListener("mousedown",this._onMouseDown,!0),e.addEventListener("click",this._onClick,{passive:!0}),e.addEventListener("touchmove",this._onTouchMove,{passive:!0}),this.dropdown.element.addEventListener("mouseover",this._onMouseOver,{passive:!0}),this._isSelectOneElement&&(this.containerOuter.element.addEventListener("focus",this._onFocus,{passive:!0}),this.containerOuter.element.addEventListener("blur",this._onBlur,{passive:!0})),this.input.element.addEventListener("keyup",this._onKeyUp,{passive:!0}),this.input.element.addEventListener("focus",this._onFocus,{passive:!0}),this.input.element.addEventListener("blur",this._onBlur,{passive:!0}),this.input.element.form&&this.input.element.form.addEventListener("reset",this._onFormReset,{passive:!0}),this.input.addEventListeners()},r._removeEventListeners=function(){var e=document.documentElement;e.removeEventListener("touchend",this._onTouchEnd,!0),this.containerOuter.element.removeEventListener("keydown",this._onKeyDown,!0),this.containerOuter.element.removeEventListener("mousedown",this._onMouseDown,!0),e.removeEventListener("click",this._onClick),e.removeEventListener("touchmove",this._onTouchMove),this.dropdown.element.removeEventListener("mouseover",this._onMouseOver),this._isSelectOneElement&&(this.containerOuter.element.removeEventListener("focus",this._onFocus),this.containerOuter.element.removeEventListener("blur",this._onBlur)),this.input.element.removeEventListener("keyup",this._onKeyUp),this.input.element.removeEventListener("focus",this._onFocus),this.input.element.removeEventListener("blur",this._onBlur),this.input.element.form&&this.input.element.form.removeEventListener("reset",this._onFormReset),this.input.removeEventListeners()},r._onKeyDown=function(e){var t,i=e.target,n=e.keyCode,s=e.ctrlKey,r=e.metaKey,o=this._store.activeItems,a=this.input.isFocussed,c=this.dropdown.isActive,l=this.itemList.hasChildren(),h=String.fromCharCode(n),u=J,d=Y,p=Z,m=Q,f=ee,v=te,g=ie,_=ne,b=se,y=s||r;!this._isTextElement&&/[a-zA-Z0-9-_ ]/.test(h)&&this.showDropdown();var E=((t={})[m]=this._onAKey,t[p]=this._onEnterKey,t[f]=this._onEscapeKey,t[v]=this._onDirectionKey,t[_]=this._onDirectionKey,t[g]=this._onDirectionKey,t[b]=this._onDirectionKey,t[d]=this._onDeleteKey,t[u]=this._onDeleteKey,t);E[n]&&E[n]({event:e,target:i,keyCode:n,metaKey:r,activeItems:o,hasFocusedInput:a,hasActiveDropdown:c,hasItems:l,hasCtrlDownKeyPressed:y})},r._onKeyUp=function(e){var t=e.target,i=e.keyCode,n=this.input.value,s=this._store.activeItems,r=this._canAddItem(s,n),o=J,a=Y;if(this._isTextElement)if(r.notice&&n){var c=this._getTemplate("notice",r.notice);this.dropdown.element.innerHTML=c.outerHTML,this.showDropdown(!0)}else this.hideDropdown(!0);else{var l=(i===o||i===a)&&!t.value,h=!this._isTextElement&&this._isSearching,u=this._canSearch&&r.response;l&&h?(this._isSearching=!1,this._store.dispatch(be(!0))):u&&this._handleSearch(this.input.value)}this._canSearch=this.config.searchEnabled},r._onAKey=function(e){var t=e.hasItems;e.hasCtrlDownKeyPressed&&t&&(this._canSearch=!1,this.config.removeItems&&!this.input.value&&this.input.element===document.activeElement&&this.highlightAll())},r._onEnterKey=function(e){var t=e.event,i=e.target,n=e.activeItems,s=e.hasActiveDropdown,r=Z,o=i.hasAttribute("data-button");if(this._isTextElement&&i.value){var a=this.input.value;this._canAddItem(n,a).response&&(this.hideDropdown(!0),this._addItem({value:a}),this._triggerChange(a),this.clearInput())}if(o&&(this._handleButtonAction(n,i),t.preventDefault()),s){var c=this.dropdown.getChild("."+this.config.classNames.highlightedState);c&&(n[0]&&(n[0].keyCode=r),this._handleChoiceAction(n,c)),t.preventDefault()}else this._isSelectOneElement&&(this.showDropdown(),t.preventDefault())},r._onEscapeKey=function(e){e.hasActiveDropdown&&(this.hideDropdown(!0),this.containerOuter.focus())},r._onDirectionKey=function(e){var t,i,n,s=e.event,r=e.hasActiveDropdown,o=e.keyCode,a=e.metaKey,c=ie,l=ne,h=se;if(r||this._isSelectOneElement){this.showDropdown(),this._canSearch=!1;var u,d=o===c||o===h?1:-1,p="[data-choice-selectable]";if(a||o===h||o===l)u=d>0?this.dropdown.element.querySelector("[data-choice-selectable]:last-of-type"):this.dropdown.element.querySelector(p);else{var m=this.dropdown.element.querySelector("."+this.config.classNames.highlightedState);u=m?function(e,t,i){if(void 0===i&&(i=1),e instanceof Element&&"string"==typeof t){for(var n=(i>0?"next":"previous")+"ElementSibling",s=e[n];s;){if(s.matches(t))return s;s=s[n]}return s}}(m,p,d):this.dropdown.element.querySelector(p)}u&&(t=u,i=this.choiceList.element,void 0===(n=d)&&(n=1),t&&(n>0?i.scrollTop+i.offsetHeight>=t.offsetTop+t.offsetHeight:t.offsetTop>=i.scrollTop)||this.choiceList.scrollToChildElement(u,d),this._highlightChoice(u)),s.preventDefault()}},r._onDeleteKey=function(e){var t=e.event,i=e.target,n=e.hasFocusedInput,s=e.activeItems;!n||i.value||this._isSelectOneElement||(this._handleBackspace(s),t.preventDefault())},r._onTouchMove=function(){this._wasTap&&(this._wasTap=!1)},r._onTouchEnd=function(e){var t=(e||e.touches[0]).target;this._wasTap&&this.containerOuter.element.contains(t)&&((t===this.containerOuter.element||t===this.containerInner.element)&&(this._isTextElement?this.input.focus():this._isSelectMultipleElement&&this.showDropdown()),e.stopPropagation()),this._wasTap=!0},r._onMouseDown=function(e){var t=e.target;if(t instanceof HTMLElement){if(we&&this.choiceList.element.contains(t)){var i=this.choiceList.element.firstElementChild,n="ltr"===this._direction?e.offsetX>=i.offsetWidth:e.offsetX<i.offsetLeft;this._isScrollingOnIe=n}if(t!==this.input.element){var s=t.closest("[data-button],[data-item],[data-choice]");if(s instanceof HTMLElement){var r=e.shiftKey,o=this._store.activeItems,a=s.dataset;"button"in a?this._handleButtonAction(o,s):"item"in a?this._handleItemAction(o,s,r):"choice"in a&&this._handleChoiceAction(o,s)}e.preventDefault()}}},r._onMouseOver=function(e){var t=e.target;t instanceof HTMLElement&&"choice"in t.dataset&&this._highlightChoice(t)},r._onClick=function(e){var t=e.target;this.containerOuter.element.contains(t)?this.dropdown.isActive||this.containerOuter.isDisabled?this._isSelectOneElement&&t!==this.input.element&&!this.dropdown.element.contains(t)&&this.hideDropdown():this._isTextElement?document.activeElement!==this.input.element&&this.input.focus():(this.showDropdown(),this.containerOuter.focus()):(this._store.highlightedActiveItems.length>0&&this.unhighlightAll(),this.containerOuter.removeFocusState(),this.hideDropdown(!0))},r._onFocus=function(e){var t,i=this,n=e.target;this.containerOuter.element.contains(n)&&((t={}).text=function(){n===i.input.element&&i.containerOuter.addFocusState()},t["select-one"]=function(){i.containerOuter.addFocusState(),n===i.input.element&&i.showDropdown(!0)},t["select-multiple"]=function(){n===i.input.element&&(i.showDropdown(!0),i.containerOuter.addFocusState())},t)[this.passedElement.element.type]()},r._onBlur=function(e){var t=this,i=e.target;if(this.containerOuter.element.contains(i)&&!this._isScrollingOnIe){var n,s=this._store.activeItems.some((function(e){return e.highlighted}));((n={}).text=function(){i===t.input.element&&(t.containerOuter.removeFocusState(),s&&t.unhighlightAll(),t.hideDropdown(!0))},n["select-one"]=function(){t.containerOuter.removeFocusState(),(i===t.input.element||i===t.containerOuter.element&&!t._canSearch)&&t.hideDropdown(!0)},n["select-multiple"]=function(){i===t.input.element&&(t.containerOuter.removeFocusState(),t.hideDropdown(!0),s&&t.unhighlightAll())},n)[this.passedElement.element.type]()}else this._isScrollingOnIe=!1,this.input.element.focus()},r._onFormReset=function(){this._store.dispatch({type:"RESET_TO",state:this._initialState})},r._highlightChoice=function(e){var t=this;void 0===e&&(e=null);var i=Array.from(this.dropdown.element.querySelectorAll("[data-choice-selectable]"));if(i.length){var n=e;Array.from(this.dropdown.element.querySelectorAll("."+this.config.classNames.highlightedState)).forEach((function(e){e.classList.remove(t.config.classNames.highlightedState),e.setAttribute("aria-selected","false")})),n?this._highlightPosition=i.indexOf(n):(n=i.length>this._highlightPosition?i[this._highlightPosition]:i[i.length-1])||(n=i[0]),n.classList.add(this.config.classNames.highlightedState),n.setAttribute("aria-selected","true"),this.passedElement.triggerEvent(B,{el:n}),this.dropdown.isActive&&(this.input.setActiveDescendant(n.id),this.containerOuter.setActiveDescendant(n.id))}},r._addItem=function(e){var t=e.value,i=e.label,n=void 0===i?null:i,s=e.choiceId,r=void 0===s?-1:s,o=e.groupId,a=void 0===o?-1:o,c=e.customProperties,l=void 0===c?null:c,h=e.placeholder,u=void 0!==h&&h,d=e.keyCode,p=void 0===d?null:d,m="string"==typeof t?t.trim():t,f=p,v=l,g=this._store.items,_=n||m,b=r||-1,y=a>=0?this._store.getGroupById(a):null,E=g?g.length+1:1;return this.config.prependValue&&(m=this.config.prependValue+m.toString()),this.config.appendValue&&(m+=this.config.appendValue.toString()),this._store.dispatch(function(e){var t=e.value,i=e.label,n=e.id,s=e.choiceId,r=e.groupId,o=e.customProperties,a=e.placeholder,c=e.keyCode;return{type:W,value:t,label:i,id:n,choiceId:s,groupId:r,customProperties:o,placeholder:a,keyCode:c}}({value:m,label:_,id:E,choiceId:b,groupId:a,customProperties:l,placeholder:u,keyCode:f})),this._isSelectOneElement&&this.removeActiveItems(E),this.passedElement.triggerEvent(K,{id:E,value:m,label:_,customProperties:v,groupValue:y&&y.value?y.value:void 0,keyCode:f}),this},r._removeItem=function(e){if(!e||!E("Object",e))return this;var t=e.id,i=e.value,n=e.label,s=e.choiceId,r=e.groupId,o=r>=0?this._store.getGroupById(r):null;return this._store.dispatch(function(e,t){return{type:X,id:e,choiceId:t}}(t,s)),o&&o.value?this.passedElement.triggerEvent(R,{id:t,value:i,label:n,groupValue:o.value}):this.passedElement.triggerEvent(R,{id:t,value:i,label:n}),this},r._addChoice=function(e){var t=e.value,i=e.label,n=void 0===i?null:i,s=e.isSelected,r=void 0!==s&&s,o=e.isDisabled,a=void 0!==o&&o,c=e.groupId,l=void 0===c?-1:c,h=e.customProperties,u=void 0===h?null:h,d=e.placeholder,p=void 0!==d&&d,m=e.keyCode,f=void 0===m?null:m;if(null!=t){var v=this._store.choices,g=n||t,_=v?v.length+1:1,b=this._baseId+"-"+this._idNames.itemChoice+"-"+_;this._store.dispatch(function(e){var t=e.value,i=e.label,n=e.id,s=e.groupId,r=e.disabled,o=e.elementId,a=e.customProperties,c=e.placeholder,l=e.keyCode;return{type:V,value:t,label:i,id:n,groupId:s,disabled:r,elementId:o,customProperties:a,placeholder:c,keyCode:l}}({id:_,groupId:l,elementId:b,value:t,label:g,disabled:a,customProperties:u,placeholder:p,keyCode:f})),r&&this._addItem({value:t,label:g,choiceId:_,customProperties:u,placeholder:p,keyCode:f})}},r._addGroup=function(e){var t=this,i=e.group,n=e.id,s=e.valueKey,r=void 0===s?"value":s,o=e.labelKey,a=void 0===o?"label":o,c=E("Object",i)?i.choices:Array.from(i.getElementsByTagName("OPTION")),l=n||Math.floor((new Date).valueOf()*Math.random()),h=!!i.disabled&&i.disabled;c?(this._store.dispatch(Ee({value:i.label,id:l,active:!0,disabled:h})),c.forEach((function(e){var i=e.disabled||e.parentNode&&e.parentNode.disabled;t._addChoice({value:e[r],label:E("Object",e)?e[a]:e.innerHTML,isSelected:e.selected,isDisabled:i,groupId:l,customProperties:e.customProperties,placeholder:e.placeholder})}))):this._store.dispatch(Ee({value:i.label,id:i.id,active:!1,disabled:i.disabled}))},r._getTemplate=function(e){var t;if(!e)return null;for(var i=this.config.classNames,n=arguments.length,s=new Array(n>1?n-1:0),r=1;r<n;r++)s[r-1]=arguments[r];return(t=this._templates[e]).call.apply(t,[this,i].concat(s))},r._createTemplates=function(){var e=this.config.callbackOnCreateTemplates,t={};e&&"function"==typeof e&&(t=e.call(this,S)),this._templates=o()(_e,t)},r._createElements=function(){this.containerOuter=new ce({element:this._getTemplate("containerOuter",this._direction,this._isSelectElement,this._isSelectOneElement,this.config.searchEnabled,this.passedElement.element.type),classNames:this.config.classNames,type:this.passedElement.element.type,position:this.config.position}),this.containerInner=new ce({element:this._getTemplate("containerInner"),classNames:this.config.classNames,type:this.passedElement.element.type,position:this.config.position}),this.input=new he({element:this._getTemplate("input",this._placeholderValue),classNames:this.config.classNames,type:this.passedElement.element.type,preventPaste:!this.config.paste}),this.choiceList=new ue({element:this._getTemplate("choiceList",this._isSelectOneElement)}),this.itemList=new ue({element:this._getTemplate("itemList",this._isSelectOneElement)}),this.dropdown=new k({element:this._getTemplate("dropdown"),classNames:this.config.classNames,type:this.passedElement.element.type})},r._createStructure=function(){this.passedElement.conceal(),this.containerInner.wrap(this.passedElement.element),this.containerOuter.wrap(this.containerInner.element),this._isSelectOneElement?this.input.placeholder=this.config.searchPlaceholderValue||"":this._placeholderValue&&(this.input.placeholder=this._placeholderValue,this.input.setWidth()),this.containerOuter.element.appendChild(this.containerInner.element),this.containerOuter.element.appendChild(this.dropdown.element),this.containerInner.element.appendChild(this.itemList.element),this._isTextElement||this.dropdown.element.appendChild(this.choiceList.element),this._isSelectOneElement?this.config.searchEnabled&&this.dropdown.element.insertBefore(this.input.element,this.dropdown.element.firstChild):this.containerInner.element.appendChild(this.input.element),this._isSelectElement&&(this._highlightPosition=0,this._isSearching=!1,this._startLoading(),this._presetGroups.length?this._addPredefinedGroups(this._presetGroups):this._addPredefinedChoices(this._presetChoices),this._stopLoading()),this._isTextElement&&this._addPredefinedItems(this._presetItems)},r._addPredefinedGroups=function(e){var t=this,i=this.passedElement.placeholderOption;i&&"SELECT"===i.parentNode.tagName&&this._addChoice({value:i.value,label:i.innerHTML,isSelected:i.selected,isDisabled:i.disabled,placeholder:!0}),e.forEach((function(e){return t._addGroup({group:e,id:e.id||null})}))},r._addPredefinedChoices=function(e){var t=this;this.config.shouldSort&&e.sort(this.config.sorter);var i=e.some((function(e){return e.selected})),n=e.findIndex((function(e){return void 0===e.disabled||!e.disabled}));e.forEach((function(e,s){var r=e.value,o=e.label,a=e.customProperties,c=e.placeholder;if(t._isSelectElement)if(e.choices)t._addGroup({group:e,id:e.id||null});else{var l=!(!t._isSelectOneElement||i||s!==n)||e.selected,h=e.disabled;t._addChoice({value:r,label:o,isSelected:l,isDisabled:h,customProperties:a,placeholder:c})}else t._addChoice({value:r,label:o,isSelected:e.selected,isDisabled:e.disabled,customProperties:a,placeholder:c})}))},r._addPredefinedItems=function(e){var t=this;e.forEach((function(e){"object"==typeof e&&e.value&&t._addItem({value:e.value,label:e.label,choiceId:e.id,customProperties:e.customProperties,placeholder:e.placeholder}),"string"==typeof e&&t._addItem({value:e})}))},r._setChoiceOrItem=function(e){var t=this;({object:function(){e.value&&(t._isTextElement?t._addItem({value:e.value,label:e.label,choiceId:e.id,customProperties:e.customProperties,placeholder:e.placeholder}):t._addChoice({value:e.value,label:e.label,isSelected:!0,isDisabled:!1,customProperties:e.customProperties,placeholder:e.placeholder}))},string:function(){t._isTextElement?t._addItem({value:e}):t._addChoice({value:e,label:e,isSelected:!0,isDisabled:!1})}})[y(e).toLowerCase()]()},r._findAndSelectChoiceByValue=function(e){var t=this,i=this._store.choices.find((function(i){return t.config.valueComparer(i.value,e)}));i&&!i.selected&&this._addItem({value:i.value,label:i.label,choiceId:i.id,groupId:i.groupId,customProperties:i.customProperties,placeholder:i.placeholder,keyCode:i.keyCode})},r._generatePlaceholderValue=function(){if(this._isSelectElement){var e=this.passedElement.placeholderOption;return!!e&&e.text}var t=this.config,i=t.placeholder,n=t.placeholderValue,s=this.passedElement.element.dataset;if(i){if(n)return n;if(s.placeholder)return s.placeholder}return!1},n}();t.default=Ce}]).default},"object"==typeof i&&"object"==typeof t?t.exports=o():"function"==typeof define&&define.amd?define([],o):"object"==typeof i?i.Choices=o():r.Choices=o()},
559: function _(n,o,e,i,t){i();e.default="\n.bk-root {\n  /*===============================\n=            Choices            =\n===============================*/\n  /*=====  End of Choices  ======*/\n}\n.bk-root .choices {\n  position: relative;\n  margin-bottom: 24px;\n  font-size: 16px;\n}\n.bk-root .choices:focus {\n  outline: none;\n}\n.bk-root .choices:last-child {\n  margin-bottom: 0;\n}\n.bk-root .choices.is-disabled .choices__inner,\n.bk-root .choices.is-disabled .choices__input {\n  background-color: #eaeaea;\n  cursor: not-allowed;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n}\n.bk-root .choices.is-disabled .choices__item {\n  cursor: not-allowed;\n}\n.bk-root .choices [hidden] {\n  display: none !important;\n}\n.bk-root .choices[data-type*='select-one'] {\n  cursor: pointer;\n}\n.bk-root .choices[data-type*='select-one'] .choices__inner {\n  padding-bottom: 7.5px;\n}\n.bk-root .choices[data-type*='select-one'] .choices__input {\n  display: block;\n  width: 100%;\n  padding: 10px;\n  border-bottom: 1px solid #dddddd;\n  background-color: #ffffff;\n  margin: 0;\n}\n.bk-root .choices[data-type*='select-one'] .choices__button {\n  background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjMDAwIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);\n  padding: 0;\n  background-size: 8px;\n  position: absolute;\n  top: 50%;\n  right: 0;\n  margin-top: -10px;\n  margin-right: 25px;\n  height: 20px;\n  width: 20px;\n  border-radius: 10em;\n  opacity: 0.5;\n}\n.bk-root .choices[data-type*='select-one'] .choices__button:hover,\n.bk-root .choices[data-type*='select-one'] .choices__button:focus {\n  opacity: 1;\n}\n.bk-root .choices[data-type*='select-one'] .choices__button:focus {\n  box-shadow: 0px 0px 0px 2px #00bcd4;\n}\n.bk-root .choices[data-type*='select-one'] .choices__item[data-value=''] .choices__button {\n  display: none;\n}\n.bk-root .choices[data-type*='select-one']:after {\n  content: '';\n  height: 0;\n  width: 0;\n  border-style: solid;\n  border-color: #333333 transparent transparent transparent;\n  border-width: 5px;\n  position: absolute;\n  right: 11.5px;\n  top: 50%;\n  margin-top: -2.5px;\n  pointer-events: none;\n}\n.bk-root .choices[data-type*='select-one'].is-open:after {\n  border-color: transparent transparent #333333 transparent;\n  margin-top: -7.5px;\n}\n.bk-root .choices[data-type*='select-one'][dir='rtl']:after {\n  left: 11.5px;\n  right: auto;\n}\n.bk-root .choices[data-type*='select-one'][dir='rtl'] .choices__button {\n  right: auto;\n  left: 0;\n  margin-left: 25px;\n  margin-right: 0;\n}\n.bk-root .choices[data-type*='select-multiple'] .choices__inner,\n.bk-root .choices[data-type*='text'] .choices__inner {\n  cursor: text;\n}\n.bk-root .choices[data-type*='select-multiple'] .choices__button,\n.bk-root .choices[data-type*='text'] .choices__button {\n  position: relative;\n  display: inline-block;\n  margin-top: 0;\n  margin-right: -4px;\n  margin-bottom: 0;\n  margin-left: 8px;\n  padding-left: 16px;\n  border-left: 1px solid #008fa1;\n  background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjRkZGIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);\n  background-size: 8px;\n  width: 8px;\n  line-height: 1;\n  opacity: 0.75;\n  border-radius: 0;\n}\n.bk-root .choices[data-type*='select-multiple'] .choices__button:hover,\n.bk-root .choices[data-type*='select-multiple'] .choices__button:focus,\n.bk-root .choices[data-type*='text'] .choices__button:hover,\n.bk-root .choices[data-type*='text'] .choices__button:focus {\n  opacity: 1;\n}\n.bk-root .choices__inner {\n  display: inline-block;\n  vertical-align: top;\n  width: 100%;\n  background-color: #f9f9f9;\n  padding: 7.5px 7.5px 3.75px;\n  border: 1px solid #dddddd;\n  border-radius: 2.5px;\n  font-size: 14px;\n  min-height: 44px;\n  overflow: hidden;\n}\n.bk-root .is-focused .choices__inner,\n.bk-root .is-open .choices__inner {\n  border-color: #b7b7b7;\n}\n.bk-root .is-open .choices__inner {\n  border-radius: 2.5px 2.5px 0 0;\n}\n.bk-root .is-flipped.is-open .choices__inner {\n  border-radius: 0 0 2.5px 2.5px;\n}\n.bk-root .choices__list {\n  margin: 0;\n  padding-left: 0;\n  list-style: none;\n}\n.bk-root .choices__list--single {\n  display: inline-block;\n  padding: 4px 16px 4px 4px;\n  width: 100%;\n}\n.bk-root [dir='rtl'] .choices__list--single {\n  padding-right: 4px;\n  padding-left: 16px;\n}\n.bk-root .choices__list--single .choices__item {\n  width: 100%;\n}\n.bk-root .choices__list--multiple {\n  display: inline;\n}\n.bk-root .choices__list--multiple .choices__item {\n  display: inline-block;\n  vertical-align: middle;\n  border-radius: 20px;\n  padding: 4px 10px;\n  font-size: 12px;\n  font-weight: 500;\n  margin-right: 3.75px;\n  margin-bottom: 3.75px;\n  background-color: #00bcd4;\n  border: 1px solid #00a5bb;\n  color: #ffffff;\n  word-break: break-all;\n  box-sizing: border-box;\n}\n.bk-root .choices__list--multiple .choices__item[data-deletable] {\n  padding-right: 5px;\n}\n.bk-root [dir='rtl'] .choices__list--multiple .choices__item {\n  margin-right: 0;\n  margin-left: 3.75px;\n}\n.bk-root .choices__list--multiple .choices__item.is-highlighted {\n  background-color: #00a5bb;\n  border: 1px solid #008fa1;\n}\n.bk-root .is-disabled .choices__list--multiple .choices__item {\n  background-color: #aaaaaa;\n  border: 1px solid #919191;\n}\n.bk-root .choices__list--dropdown {\n  visibility: hidden;\n  z-index: 1;\n  position: absolute;\n  width: 100%;\n  background-color: #ffffff;\n  border: 1px solid #dddddd;\n  top: 100%;\n  margin-top: -1px;\n  border-bottom-left-radius: 2.5px;\n  border-bottom-right-radius: 2.5px;\n  overflow: hidden;\n  word-break: break-all;\n  will-change: visibility;\n}\n.bk-root .choices__list--dropdown.is-active {\n  visibility: visible;\n}\n.bk-root .is-open .choices__list--dropdown {\n  border-color: #b7b7b7;\n}\n.bk-root .is-flipped .choices__list--dropdown {\n  top: auto;\n  bottom: 100%;\n  margin-top: 0;\n  margin-bottom: -1px;\n  border-radius: 0.25rem 0.25rem 0 0;\n}\n.bk-root .choices__list--dropdown .choices__list {\n  position: relative;\n  max-height: 300px;\n  overflow: auto;\n  -webkit-overflow-scrolling: touch;\n  will-change: scroll-position;\n}\n.bk-root .choices__list--dropdown .choices__item {\n  position: relative;\n  padding: 10px;\n  font-size: 14px;\n}\n.bk-root [dir='rtl'] .choices__list--dropdown .choices__item {\n  text-align: right;\n}\n@media (min-width: 640px) {\n  .bk-root .choices__list--dropdown .choices__item--selectable {\n    padding-right: 100px;\n  }\n  .bk-root .choices__list--dropdown .choices__item--selectable:after {\n    content: attr(data-select-text);\n    font-size: 12px;\n    opacity: 0;\n    position: absolute;\n    right: 10px;\n    top: 50%;\n    transform: translateY(-50%);\n  }\n  .bk-root [dir='rtl'] .choices__list--dropdown .choices__item--selectable {\n    text-align: right;\n    padding-left: 100px;\n    padding-right: 10px;\n  }\n  .bk-root [dir='rtl'] .choices__list--dropdown .choices__item--selectable:after {\n    right: auto;\n    left: 10px;\n  }\n}\n.bk-root .choices__list--dropdown .choices__item--selectable.is-highlighted {\n  background-color: #f2f2f2;\n}\n.bk-root .choices__list--dropdown .choices__item--selectable.is-highlighted:after {\n  opacity: 0.5;\n}\n.bk-root .choices__item {\n  cursor: default;\n}\n.bk-root .choices__item--selectable {\n  cursor: pointer;\n}\n.bk-root .choices__item--disabled {\n  cursor: not-allowed;\n  -webkit-user-select: none;\n  -ms-user-select: none;\n  user-select: none;\n  opacity: 0.5;\n}\n.bk-root .choices__heading {\n  font-weight: 600;\n  font-size: 12px;\n  padding: 10px;\n  border-bottom: 1px solid #f7f7f7;\n  color: gray;\n}\n.bk-root .choices__button {\n  text-indent: -9999px;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  border: 0;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center;\n  cursor: pointer;\n}\n.bk-root .choices__button:focus {\n  outline: none;\n}\n.bk-root .choices__input {\n  display: inline-block;\n  vertical-align: baseline;\n  background-color: #f9f9f9;\n  font-size: 14px;\n  margin-bottom: 5px;\n  border: 0;\n  border-radius: 0;\n  max-width: 100%;\n  padding: 4px 0 4px 2px;\n}\n.bk-root .choices__input:focus {\n  outline: 0;\n}\n.bk-root [dir='rtl'] .choices__input {\n  padding-right: 2px;\n  padding-left: 0;\n}\n.bk-root .choices__placeholder {\n  opacity: 0.5;\n}\n.bk-root .choices {\n  width: 100%;\n}\n.bk-root .choices {\n  box-sizing: border-box;\n}\n.bk-root .choices *,\n.bk-root .choices *:before,\n.bk-root .choices *:after {\n  box-sizing: inherit;\n}\n.bk-root .choices__inner .choices__item.light {\n  background-color: rgba(0, 126, 255, 0.08);\n  border-radius: 5px;\n  border: 1px solid rgba(0, 126, 255, 0.24);\n  color: #007eff;\n}\n.bk-root .choices__inner .choices__item.solid {\n  background-color: #1f77b4;\n  border: none;\n  border-radius: 5px;\n  color: white;\n}\n.bk-root .choices__inner .choices__item.solid .is-highlighted {\n  background-color: #1f77b4;\n  border: none;\n}\n.bk-root .choices__input {\n  background-color: transparent;\n}\n.bk-root .choices__inner {\n  background: transparent;\n  border: 1px solid darkgray;\n  border-radius: 5px;\n  min-height: unset;\n}\n.bk-root .choices__list {\n  white-space: initial;\n}\n.bk-root .choices[data-type*=select-multiple] .choices__button.light {\n  background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjMDA3ZWZmIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);\n}\n.bk-root .choices[data-type*=select-multiple] .choices__button.solid {\n  background-image: url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjEiIGhlaWdodD0iMjEiIHZpZXdCb3g9IjAgMCAyMSAyMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48ZyBmaWxsPSIjZmZmZmZmIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPjxwYXRoIGQ9Ik0yLjU5Mi4wNDRsMTguMzY0IDE4LjM2NC0yLjU0OCAyLjU0OEwuMDQ0IDIuNTkyeiIvPjxwYXRoIGQ9Ik0wIDE4LjM2NEwxOC4zNjQgMGwyLjU0OCAyLjU0OEwyLjU0OCAyMC45MTJ6Ii8+PC9nPjwvc3ZnPg==);\n  border-left: 1px solid white;\n  opacity: 1;\n}\n"},
560: function _(e,t,n,l,i){l();var u=e(1),o=u.__importStar(e(328)),r=e(529),a=e(248),s=e(187),h=e(123),p=e(126),c=e(531),d=/^[-+]?\d*$/,_=/^[-+]?\d*\.?\d*(?:(?:\d|\d.)[eE][-+]?)*\d*$/,m=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return u.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,(function(){var e;return t.input_el.name=null!==(e=t.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(function(){t.input_el.value=t.format_value,t.old_value=t.input_el.value})),this.connect(this.model.properties.low.change,(function(){var e=t.model,n=e.value,l=e.low,i=e.high;null!=l&&null!=i&&p.assert(l<=i,"Invalid bounds, low must be inferior to high"),null!=n&&null!=l&&(t.model.value=Math.max(n,l))})),this.connect(this.model.properties.high.change,(function(){var e=t.model,n=e.value,l=e.low,i=e.high;null!=l&&null!=i&&p.assert(i>=l,"Invalid bounds, high must be superior to low"),null!=n&&null!=i&&(t.model.value=Math.min(n,i))})),this.connect(this.model.properties.high.change,(function(){return t.input_el.placeholder=t.model.placeholder})),this.connect(this.model.properties.disabled.change,(function(){return t.input_el.disabled=t.model.disabled})),this.connect(this.model.properties.placeholder.change,(function(){return t.input_el.placeholder=t.model.placeholder}))},Object.defineProperty(t.prototype,"format_value",{get:function(){return null!=this.model.value?this.model.pretty(this.model.value):""},enumerable:!1,configurable:!0}),t.prototype._set_input_filter=function(e){var t=this;this.input_el.addEventListener("input",(function(){var n=t.input_el,l=n.selectionStart,i=n.selectionEnd;if(e(t.input_el.value))t.old_value=t.input_el.value;else{var u=t.old_value.length-t.input_el.value.length;t.input_el.value=t.old_value,l&&i&&t.input_el.setSelectionRange(l-1,i+u)}}))},t.prototype.render=function(){var t=this;e.prototype.render.call(this),this.input_el=s.input({type:"text",class:c.bk_input,name:this.model.name,value:this.format_value,disabled:this.model.disabled,placeholder:this.model.placeholder}),this.old_value=this.format_value,this.set_input_filter(),this.input_el.addEventListener("change",(function(){return t.change_input()})),this.input_el.addEventListener("focusout",(function(){return t.input_el.value=t.format_value})),this.group_el.appendChild(this.input_el)},t.prototype.set_input_filter=function(){"int"==this.model.mode?this._set_input_filter((function(e){return d.test(e)})):"float"==this.model.mode&&this._set_input_filter((function(e){return _.test(e)}))},t.prototype.bound_value=function(e){var t=e,n=this.model,l=n.low,i=n.high;return t=null!=l?Math.max(l,t):t,t=null!=i?Math.min(i,t):t},Object.defineProperty(t.prototype,"value",{get:function(){var e=""!=this.input_el.value?Number(this.input_el.value):null;return null!=e&&(e=this.bound_value(e)),e},enumerable:!1,configurable:!0}),t.prototype.change_input=function(){null==this.value?this.model.value=null:Number.isNaN(this.value)||(this.model.value=this.value)},t}(r.InputWidgetView);n.NumericInputView=m,m.__name__="NumericInputView";var f=function(e){function t(t){return e.call(this,t)||this}return u.__extends(t,e),t.init_NumericInput=function(){this.prototype.default_view=m,this.define((function(e){var t=e.Number,n=e.String,l=e.Enum,i=e.Ref,u=e.Or,o=e.Nullable;return{value:[o(t),null],placeholder:[n,""],mode:[l("int","float"),"int"],format:[o(u(n,i(a.TickFormatter))),null],low:[o(t),null],high:[o(t),null]}}))},t.prototype._formatter=function(e,t){return h.isString(t)?o.format(e,t):t.doFormat([e],{loc:0})[0]},t.prototype.pretty=function(e){return null!=this.format?this._formatter(e,this.format):""+e},t}(r.InputWidget);n.NumericInput=f,f.__name__="NumericInput",f.init_NumericInput()},
561: function _(e,t,r,n,i){n();var o=e(1),u=e(549),_=e(187),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return o.__extends(t,e),t.prototype.render=function(){e.prototype.render.call(this);var t=_.pre({style:{overflow:"auto"}},this.model.text);this.markup_el.appendChild(t)},t}(u.MarkupView);r.PreTextView=a,a.__name__="PreTextView";var p=function(e){function t(t){return e.call(this,t)||this}return o.__extends(t,e),t.init_PreText=function(){this.prototype.default_view=a},t}(u.Markup);r.PreText=p,p.__name__="PreText",p.init_PreText()},
562: function _(t,n,o,i,u){i();var e=t(1),a=t(534),r=t(187),c=t(304),_=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return e.__extends(n,t),n.prototype.change_active=function(t){this.model.active!==t&&(this.model.active=t)},n.prototype._update_active=function(){var t=this.model.active;this._buttons.forEach((function(n,o){r.classes(n).toggle(c.bk_active,t===o)}))},n}(a.ButtonGroupView);o.RadioButtonGroupView=_,_.__name__="RadioButtonGroupView";var p=function(t){function n(n){return t.call(this,n)||this}return e.__extends(n,t),n.init_RadioButtonGroup=function(){this.prototype.default_view=_,this.define((function(t){var n=t.Int;return{active:[(0,t.Nullable)(n),null]}}))},n}(a.ButtonGroup);o.RadioButtonGroup=p,p.__name__="RadioButtonGroup",p.init_RadioButtonGroup()},
563: function _(n,i,e,t,a){t();var r=n(1),o=n(187),u=n(144),l=n(536),p=n(304),d=n(531),s=function(n){function i(){return null!==n&&n.apply(this,arguments)||this}return r.__extends(i,n),i.prototype.render=function(){var i=this;n.prototype.render.call(this);var e=o.div({class:[d.bk_input_group,this.model.inline?p.bk_inline:null]});this.el.appendChild(e);var t=u.uniqueId(),a=this.model,r=a.active,l=a.labels;this._inputs=[];for(var s=function(n){var a=o.input({type:"radio",name:t,value:""+n});a.addEventListener("change",(function(){return i.change_active(n)})),c._inputs.push(a),c.model.disabled&&(a.disabled=!0),n==r&&(a.checked=!0);var u=o.label({},a,o.span({},l[n]));e.appendChild(u)},c=this,_=0;_<l.length;_++)s(_)},i.prototype.change_active=function(n){this.model.active=n},i}(l.InputGroupView);e.RadioGroupView=s,s.__name__="RadioGroupView";var c=function(n){function i(i){return n.call(this,i)||this}return r.__extends(i,n),i.init_RadioGroup=function(){this.prototype.default_view=s,this.define((function(n){var i=n.Boolean,e=n.Int,t=n.String;return{active:[e],labels:[(0,n.Array)(t),[]],inline:[i,!1]}}))},i}(l.InputGroup);e.RadioGroup=c,c.__name__="RadioGroup",c.init_RadioGroup()},
564: function _(e,t,n,r,i){r();var a=e(1),o=a.__importStar(e(328)),_=e(542),u=e(123),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return a.__extends(t,e),t}(_.AbstractRangeSliderView);n.RangeSliderView=d,d.__name__="RangeSliderView";var l=function(e){function t(t){var n=e.call(this,t)||this;return n.behaviour="drag",n.connected=[!1,!0,!1],n}return a.__extends(t,e),t.init_RangeSlider=function(){this.prototype.default_view=d,this.override({format:"0[.]00"})},t.prototype._formatter=function(e,t){return u.isString(t)?o.format(e,t):t.compute(e)},t}(_.AbstractSlider);n.RangeSlider=l,l.__name__="RangeSlider",l.init_RangeSlider()},
565: function _(t,e,n,i,o){i();var l=t(1),u=t(187),r=t(123),p=t(128),a=t(529),s=t(531),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties,i=n.value,o=n.options;this.on_change(i,(function(){e._update_value()})),this.on_change(o,(function(){u.empty(e.input_el),u.append.apply(void 0,l.__spread([e.input_el],e.options_el()))}))},e.prototype.options_el=function(){function t(t){return t.map((function(t){var e,n,i;return r.isString(t)?n=i=t:(n=(e=l.__read(t,2))[0],i=e[1]),u.option({value:n},i)}))}var e=this.model.options;return r.isArray(e)?t(e):p.entries(e).map((function(e){var n=l.__read(e,2),i=n[0],o=n[1];return u.optgroup({label:i},t(o))}))},e.prototype.render=function(){var e=this;t.prototype.render.call(this),this.input_el=u.select({class:s.bk_input,name:this.model.name,disabled:this.model.disabled},this.options_el()),this._update_value(),this.input_el.addEventListener("change",(function(){return e.change_input()})),this.group_el.appendChild(this.input_el)},e.prototype.change_input=function(){var e=this.input_el.value;this.model.value=e,t.prototype.change_input.call(this)},e.prototype._update_value=function(){var t=this.model.value;null!=t&&0!=t.length&&(this.input_el.value=this.model.value)},e}(a.InputWidgetView);n.SelectView=_,_.__name__="SelectView";var c=function(t){function e(e){return t.call(this,e)||this}return l.__extends(e,t),e.init_Select=function(){this.prototype.default_view=_,this.define((function(t){var e=t.String,n=t.Array,i=t.Tuple,o=t.Dict,l=t.Or,u=n(l(e,i(e,e)));return{value:[e,""],options:[l(u,o(u)),[]]}}))},e}(a.InputWidget);n.Select=c,c.__name__="Select",c.init_Select()},
566: function _(t,r,i,e,n){e();var o=t(1),_=o.__importStar(t(328)),a=t(542),u=t(123),l=function(t){function r(){return null!==t&&t.apply(this,arguments)||this}return o.__extends(r,t),r}(a.AbstractSliderView);i.SliderView=l,l.__name__="SliderView";var c=function(t){function r(r){var i=t.call(this,r)||this;return i.behaviour="tap",i.connected=[!0,!1],i}return o.__extends(r,t),r.init_Slider=function(){this.prototype.default_view=l,this.override({format:"0[.]00"})},r.prototype._formatter=function(t,r){return u.isString(r)?_.format(t,r):r.compute(t)},r}(a.AbstractSlider);i.Slider=c,c.__name__="Slider",c.init_Slider()},
567: function _(t,e,n,i,r){i();var l=t(1),o=t(560),a=t(187),s=Math.min,u=Math.max,p=Math.floor,_=Math.abs;function h(t){return p(t)!==t?t.toFixed(16).replace(/0+$/,"").split(".")[1].length:0}var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return l.__extends(e,t),e.prototype.buttons=function(){return l.__generator(this,(function(t){switch(t.label){case 0:return[4,this.btn_up_el];case 1:return t.sent(),[4,this.btn_down_el];case 2:return t.sent(),[2]}}))},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._interval=200},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties;this.on_change(n.disabled,(function(){var t,n;try{for(var i=l.__values(e.buttons()),r=i.next();!r.done;r=i.next()){var o=r.value;a.toggle_attribute(o,"disabled",e.model.disabled)}}catch(e){t={error:e}}finally{try{r&&!r.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}}))},e.prototype.render=function(){var e,n,i,r,o,s,u=this;t.prototype.render.call(this),this.wrapper_el=a.div({class:"bk-spin-wrapper"}),this.group_el.replaceChild(this.wrapper_el,this.input_el),this.btn_up_el=a.button({class:"bk-spin-btn bk-spin-btn-up"}),this.btn_down_el=a.button({class:"bk-spin-btn bk-spin-btn-down"}),this.wrapper_el.appendChild(this.input_el),this.wrapper_el.appendChild(this.btn_up_el),this.wrapper_el.appendChild(this.btn_down_el);try{for(var p=l.__values(this.buttons()),_=p.next();!_.done;_=p.next()){var h=_.value;a.toggle_attribute(h,"disabled",this.model.disabled),h.addEventListener("mousedown",(function(t){return u._btn_mouse_down(t)})),h.addEventListener("mouseup",(function(){return u._btn_mouse_up()})),h.addEventListener("mouseleave",(function(){return u._btn_mouse_leave()}))}}catch(t){e={error:t}}finally{try{_&&!_.done&&(n=p.return)&&n.call(p)}finally{if(e)throw e.error}}this.input_el.addEventListener("keydown",(function(t){return u._input_key_down(t)})),this.input_el.addEventListener("keyup",(function(){return u.model.value_throttled=u.model.value})),this.input_el.addEventListener("wheel",(function(t){return u._input_mouse_wheel(t)})),this.input_el.addEventListener("wheel",(i=function(){u.model.value_throttled=u.model.value},r=this.model.wheel_wait,void 0===(o=!1)&&(o=!1),function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];var n=this,l=function(){s=void 0,o||i.apply(n,t)},a=o&&void 0===s;void 0!==s&&clearTimeout(s),s=setTimeout(l,r),a&&i.apply(n,t)}))},Object.defineProperty(e.prototype,"precision",{get:function(){var t=this.model,e=t.low,n=t.high,i=t.step,r=h;return u(r(_(null!=e?e:0)),r(_(null!=n?n:0)),r(_(i)))},enumerable:!1,configurable:!0}),e.prototype._start_incrementation=function(t){var e=this;clearInterval(this._interval_handle),this._counter=0;var n=this.model.step,i=function(t){if(e._counter+=1,e._counter%5==0){var n=Math.floor(e._counter/5);n<10?(clearInterval(e._interval_handle),e._interval_handle=setInterval((function(){return i(t)}),e._interval/(n+1))):n>=10&&n<=13&&(clearInterval(e._interval_handle),e._interval_handle=setInterval((function(){return i(2*t)}),e._interval/10))}e.increment(t)};this._interval_handle=setInterval((function(){return i(t*n)}),this._interval)},e.prototype._stop_incrementation=function(){clearInterval(this._interval_handle),this.model.value_throttled=this.model.value},e.prototype._btn_mouse_down=function(t){t.preventDefault();var e=t.currentTarget===this.btn_up_el?1:-1;this.increment(e*this.model.step),this.input_el.focus(),this._start_incrementation(e)},e.prototype._btn_mouse_up=function(){this._stop_incrementation()},e.prototype._btn_mouse_leave=function(){this._stop_incrementation()},e.prototype._input_mouse_wheel=function(t){if(document.activeElement===this.input_el){t.preventDefault();var e=t.deltaY>0?-1:1;this.increment(e*this.model.step)}},e.prototype._input_key_down=function(t){switch(t.keyCode){case a.Keys.Up:return t.preventDefault(),this.increment(this.model.step);case a.Keys.Down:return t.preventDefault(),this.increment(-this.model.step);case a.Keys.PageUp:return t.preventDefault(),this.increment(this.model.page_step_multiplier*this.model.step);case a.Keys.PageDown:return t.preventDefault(),this.increment(-this.model.page_step_multiplier*this.model.step)}},e.prototype.adjust_to_precision=function(t){return this.bound_value(Number(t.toFixed(this.precision)))},e.prototype.increment=function(t){var e=this.model,n=e.low,i=e.high;null==this.model.value?t>0?this.model.value=null!=n?n:null!=i?s(0,i):0:t<0&&(this.model.value=null!=i?i:null!=n?u(n,0):0):this.model.value=this.adjust_to_precision(this.model.value+t)},e.prototype.change_input=function(){t.prototype.change_input.call(this),this.model.value_throttled=this.model.value},e}(o.NumericInputView);n.SpinnerView=d,d.__name__="SpinnerView";var c=function(t){function e(e){return t.call(this,e)||this}return l.__extends(e,t),e.init_Spinner=function(){this.prototype.default_view=d,this.define((function(t){var e=t.Number;return{value_throttled:[(0,t.Nullable)(e),null],step:[e,1],page_step_multiplier:[e,10],wheel_wait:[e,100]}})),this.override({mode:"float"})},e}(o.NumericInput);n.Spinner=c,c.__name__="Spinner",c.init_Spinner()},
568: function _(e,t,n,i,o){i();var l=e(1),r=e(529),s=e(187),a=e(531),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return l.__extends(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.name.change,(function(){var e;return t.input_el.name=null!==(e=t.model.name)&&void 0!==e?e:""})),this.connect(this.model.properties.value.change,(function(){return t.input_el.value=t.model.value})),this.connect(this.model.properties.disabled.change,(function(){return t.input_el.disabled=t.model.disabled})),this.connect(this.model.properties.placeholder.change,(function(){return t.input_el.placeholder=t.model.placeholder})),this.connect(this.model.properties.rows.change,(function(){return t.input_el.rows=t.model.rows})),this.connect(this.model.properties.cols.change,(function(){return t.input_el.cols=t.model.cols})),this.connect(this.model.properties.max_length.change,(function(){return t.input_el.maxLength=t.model.max_length}))},t.prototype.render=function(){var t=this;e.prototype.render.call(this),this.input_el=s.textarea({class:a.bk_input,name:this.model.name,disabled:this.model.disabled,placeholder:this.model.placeholder,cols:this.model.cols,rows:this.model.rows,maxLength:this.model.max_length}),this.input_el.textContent=this.model.value,this.input_el.addEventListener("change",(function(){return t.change_input()})),this.group_el.appendChild(this.input_el)},t.prototype.change_input=function(){this.model.value=this.input_el.value,e.prototype.change_input.call(this)},t}(r.InputWidgetView);n.TextAreaInputView=u,u.__name__="TextAreaInputView";var c=function(e){function t(t){return e.call(this,t)||this}return l.__extends(t,e),t.init_TextAreaInput=function(){this.prototype.default_view=u,this.define((function(e){var t=e.Int,n=e.String;return{value:[n,""],value_input:[n,""],placeholder:[n,""],cols:[t,20],rows:[t,2],max_length:[t,500]}}))},t}(r.InputWidget);n.TextAreaInput=c,c.__name__="TextAreaInput",c.init_TextAreaInput()},
569: function _(t,e,i,n,o){n();var c=t(1),l=t(523),r=t(187),a=t(304),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return c.__extends(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){return e._update_active()}))},e.prototype.render=function(){t.prototype.render.call(this),this._update_active()},e.prototype.click=function(){this.model.active=!this.model.active,t.prototype.click.call(this)},e.prototype._update_active=function(){r.classes(this.button_el).toggle(a.bk_active,this.model.active)},e}(l.AbstractButtonView);i.ToggleView=s,s.__name__="ToggleView";var u=function(t){function e(e){return t.call(this,e)||this}return c.__extends(e,t),e.init_Toggle=function(){this.prototype.default_view=s,this.define((function(t){return{active:[t.Boolean,!1]}})),this.override({label:"Toggle"})},e}(l.AbstractButton);i.Toggle=u,u.__name__="Toggle",u.init_Toggle()},
}, 521, {"models/widgets/main":521,"models/widgets/index":522,"models/widgets/abstract_button":523,"models/widgets/control":524,"models/widgets/widget":589,"models/widgets/abstract_icon":526,"models/widgets/autocomplete_input":527,"models/widgets/text_input":528,"models/widgets/input_widget":529,"styles/widgets/inputs.css":530,"styles/widgets/inputs":531,"models/widgets/button":532,"models/widgets/checkbox_button_group":533,"models/widgets/button_group":534,"models/widgets/checkbox_group":535,"models/widgets/input_group":536,"models/widgets/color_picker":537,"models/widgets/date_picker":538,"styles/widgets/flatpickr.css":540,"models/widgets/date_range_slider":541,"models/widgets/abstract_slider":542,"styles/widgets/sliders":544,"styles/widgets/nouislider.css":545,"styles/widgets/sliders.css":546,"models/widgets/date_slider":547,"models/widgets/div":548,"models/widgets/markup":549,"styles/clearfix":550,"styles/clearfix.css":551,"models/widgets/dropdown":552,"models/widgets/file_input":553,"models/widgets/multiselect":554,"models/widgets/paragraph":555,"models/widgets/password_input":556,"models/widgets/multichoice":557,"styles/widgets/choices.css":559,"models/widgets/numeric_input":560,"models/widgets/pretext":561,"models/widgets/radio_button_group":562,"models/widgets/radio_group":563,"models/widgets/range_slider":564,"models/widgets/selectbox":565,"models/widgets/slider":566,"models/widgets/spinner":567,"models/widgets/textarea_input":568,"models/widgets/toggle":569}, {});
})

