# Aksharamukha Python Package

Aksharamukha aims to provide transliteration a.k.a script conversion between various scripts within the Indic cultural sphere.  These include historic scripts, contemporary Brahmi-derived/inspired scripts, scripts invented for minority Indian languages, scripts that have co-existed with Indic scripts (like Avestan) or linguistically related scripts like Old Persian. It also specifically provides lossless transliteration between the main Indian scripts (along with Sinhala).

Apart from the simple mapping of characters, Askharamukha also attempts to implement various script/language-specific orthographic conventions (where known) such as vowel lengths, gemination and nasalization. It also provides several customization options to fine-tune and get the desired orthography.

Aksharamukha as of now supports 94 scripts and several romanization methods.

*Ahom, Ariyaka, Assamese, Avestan, Balinese, Batak Karo, Batak Mandailing, Batak Pakpak, Batak Toba, Batak Simalungun, Bengali (Bangla), Brahmi, Bhaiksuki, Buginese (Lontara), Buhid, Burmese (Myanmar), Chakma, Cham, Devanagari, Dogra, Gondi (Gunjala), Gondi (Masaram), Grantha, Grantha (Pandya), Gujarati, Hanunoo, Hebrew, Japanese (Hiragana), Japanese (Katakana), Javanese, Kaithi, Kannada, Kawi, Khamti Shan, Kharoshthi, Khmer (Cambodian), Khojki, Khom Thai, Khudawadi, Lao, Lao (Pali), Lepcha, Limbu, Malayalam, Mahajani, Marchen, Meetei Mayek (Manipuri), Modi, Mon, Mongolian (Ali Gali), Mro, Multani, Newa (Nepal Bhasa), Old Persian, Oriya (Odia), Pallava, PhagsPa, Punjabi (Gurmukhi), Ranjana (Lantsa), Rejang, Rohingya (Hanifi), Santali (Ol Chiki), Saurashtra, Siddham, Shan, Sharada, Sinhala, Sora Sompeng, Soyombo, Sundanese, Syloti Nagari, Tagbanwa, Tagalog, Tai Laing, Takri, Tamil, Tamil (Extended), Tamil Brahmi, Telugu, Thaana (Dhivehi), Thai, Tham (Lanna), Tham (Lao), Tham (Tai Khuen), Tham (Tai Lue), Tibetan, Tirhuta (Maithili), Urdu, Vatteluttu, Wancho, Warang Citi, Zanabazar Square, Cyrillic (Russian), IPA*

The Romanization Formats supported are: *Harvard-Kyoto, ITRANS, Velthuis, IAST, IAST (Pāḷi), ISO, ISO (Pāḷi), Titus, SLP1, WX, Roman (Readable), Roman (Colloquial)*

## Usage and Examples

Please use `pip aksharamukha` to install the Python package.

Please find the usage instructions and relevant documentation [here](http://aksharamukha.appspot.com/#/python).

## Online Version

The package as an online tool with a pretty web interface is available [here](http://aksharamukha.appspot.com/).

## Contact

If you have any questions please head to [Github](https://github.com/virtualvinodh/aksharamukha-python) or mail vinodh@virtualvinodh.com
