import * as imagebuilder from '@aws-cdk/aws-imagebuilder';
export * from './ssm_update';
export * from './source_action_builder';
export * from './source_action';
export * from './component_builder';
export * from './pipeline_builder';
export * from './ami_pipeline_lib';
export * from './slack_notification';
export * from './component_dependency';
export * from './component_synchronizer';
/**
 * @stability stable
 */
export declare class ArnComponentRef {
    /**
     * @stability stable
     */
    ref: string;
    /**
     * @stability stable
     */
    name: string;
    /**
     * @stability stable
     */
    constructor(arn: string, name: string);
}
export declare type Component = ArnComponentRef | imagebuilder.CfnComponent;
/**
 * @stability stable
 */
export interface StringComponentMap {
    [name: string]: Component;
}
