"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImageRecipeVersionBump = void 0;
const path = require("path");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
class ImageRecipeVersionBump extends cdk.Construct {
    constructor(scope, id, recipeName) {
        super(scope, id);
        this.recipeName = recipeName;
        const fn = new lambda.SingletonFunction(this, 'ImageRecipeLatestVersion', {
            uuid: '35399eb5-3b70-49d2-bcf6-ab26006ee648',
            runtime: lambda.Runtime.PYTHON_3_8,
            handler: 'index.handler',
            code: lambda.Code.fromAsset(path.join(__dirname, '..', 'lambda', 'imagerecipe-latest-version')),
            initialPolicy: [
                aws_iam_1.PolicyStatement.fromJson({
                    Sid: 'VisualEditor0',
                    Effect: 'Allow',
                    Action: [
                        'imagebuilder:ListImagePipelines',
                        'imagebuilder:ListComponents',
                        'imagebuilder:ListImageRecipes',
                    ],
                    Resource: '*',
                }),
            ],
            timeout: cdk.Duration.minutes(5),
        });
        const provider = new cr.Provider(this, 'ImageRecipeCrProvider', {
            onEventHandler: fn,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const customResource = new cdk.CustomResource(this, 'ImageRecipeLatestVersionCustom', {
            serviceToken: provider.serviceToken,
            properties: {
                RecipeName: this.recipeName,
                RefreshToken: Date.now(),
            },
        });
        this.nextVersion = customResource.getAtt('NextVersion').toString();
    }
}
exports.ImageRecipeVersionBump = ImageRecipeVersionBump;
//# sourceMappingURL=data:application/json;base64,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