"""Sevseg, by Al Sweigart al@inventwithpython.com

A seven-segment display module.
More info at https://en.wikipedia.org/wiki/Seven-segment_display
Tags: short, module"""
__version__ = 0

"""
A labeled seven-segment display, with each segment labeled A to G:
 __A__
|     |
F     B
|__G__|
|     |
E     C
|__D__|

Each digit in a seven-segment display:
 __       __   __        __   __  __   __   __
|  |   |  __|  __| |__| |__  |__    | |__| |__|
|__|   | |__   __|    |  __| |__|   | |__|  __|

"""


def getSevSegStr(number, digits=0):
    """Return a seven-segment display string of number. The digits
    argument is the minimum number of digits in the returned string,
    padded with zeros if needed."""
    # Convert to string in case it's an int or float:
    number = str(number).zfill(digits)

    rows = ['', '', '']
    for i, numeral in enumerate(number):
        if numeral == '.':
            # Render the decimal point:
            rows[0] += ' '
            rows[1] += ' '
            rows[2] += '.'
            continue  # Skip the space in between digits.
        elif numeral == '-':
            # Render the negative sign:
            rows[0] += '    '
            rows[1] += ' __ '
            rows[2] += '    '
        elif numeral == '0':
            # Render the 0:
            rows[0] += ' __ '
            rows[1] += '|  |'
            rows[2] += '|__|'
        elif numeral == '1':
            # Render the 1:
            rows[0] += '    '
            rows[1] += '   |'
            rows[2] += '   |'
        elif numeral == '2':
            # Render the 2:
            rows[0] += ' __ '
            rows[1] += ' __|'
            rows[2] += '|__ '
        elif numeral == '3':
            # Render the 3:
            rows[0] += ' __ '
            rows[1] += ' __|'
            rows[2] += ' __|'
        elif numeral == '4':
            # Render the 4:
            rows[0] += '    '
            rows[1] += '|__|'
            rows[2] += '   |'
        elif numeral == '5':
            # Render the 5:
            rows[0] += ' __ '
            rows[1] += '|__ '
            rows[2] += ' __|'
        elif numeral == '6':
            # Render the 6:
            rows[0] += ' __ '
            rows[1] += '|__ '
            rows[2] += '|__|'
        elif numeral == '7':
            # Render the 7:
            rows[0] += ' __ '
            rows[1] += '   |'
            rows[2] += '   |'
        elif numeral == '8':
            # Render the 8:
            rows[0] += ' __ '
            rows[1] += '|__|'
            rows[2] += '|__|'
        elif numeral == '9':
            # Render the 9:
            rows[0] += ' __ '
            rows[1] += '|__|'
            rows[2] += ' __|'

        # Add a space (for the space in between numerals) if this
        # isn't the last numeral:
        if i != len(number) - 1:
            rows[0] += ' '
            rows[1] += ' '
            rows[2] += ' '

    return '\n'.join(rows)


# If this program isn't being imported, display the numbers 00 to 99.
if __name__ == '__main__':
    for i in range(100):
        print(getSevSegStr(i, 2))
