PROGRAMS = [   {   'desc': 'A time-based quiz game to see how fast you can alphabetize letters.\nTags: short, game\n',
        'filename': 'alphabetizequiz.py',
        'hash': 478819440,
        'name': 'Alphabetize Quiz'},
    {   'desc': 'A time-based quiz game to see how fast you can alphabetize words.\nTags: short, game\n',
        'filename': 'alphabetizewordquiz.py',
        'hash': 1881567240,
        'name': 'Alphabetize Word Quiz'},
    {   'desc': 'An analog clock animation. Press Ctrl-C to stop.\nTags: large, artistic, bext\n',
        'filename': 'analogclock.py',
        'hash': 3342974364,
        'name': 'Analog Clock'},
    {   'desc': 'A deductive logic game where you must guess a number based on clues.\n'
                'A version of this game is featured in the book, "Invent Your Own Computer\n'
                '# Games with Python. https://nostarch.com/inventwithpython\n'
                'Tags: short, game, puzzle game\n',
        'filename': 'bagels.py',
        'hash': 128322529,
        'name': 'Bagels'},
    {   'desc': 'Explore the mathematics of the "Birthday Paradox".\n'
                'More info at https://en.wikipedia.org/wiki/Birthday_problem\n'
                'Tags: short, math, simulation\n',
        'filename': 'birthdayparadox.py',
        'hash': 2744184881,
        'name': 'Birthday Paradox Simulation'},
    {   'desc': 'A card game also known as 21.\n'
                'More info at: https://en.wikipedia.org/wiki/Blackjack\n'
                'Tags: large, game, card game\n',
        'filename': 'blackjack.py',
        'hash': 343504572,
        'name': 'Blackjack'},
    {   'desc': 'A bouncing dots animation. Press Ctrl-C to stop.\n'
                '\n'
                'NOTE: Do not resize the terminal window while this program is running.\n'
                'Tags: short, artistic, bext\n',
        'filename': 'bouncingdots.py',
        'hash': 1047140187,
        'name': 'Bouncing Dots'},
    {   'desc': 'A bouncing line animation. Press Ctrl-C to stop.\n'
                '\n'
                'NOTE: Do not resize the terminal window while this program is running.\n'
                'Tags: large, artistic, bext\n',
        'filename': 'bouncinglines.py',
        'hash': 1942485720,
        'name': 'Bouncing Lines'},
    {   'desc': 'Create monthly calendars, saved to a text file and fit for printing.\nTags: short, artistic\n',
        'filename': 'calendarmaker.py',
        'hash': 2396341551,
        'name': 'Calendar Maker'},
    {   'desc': 'A silly bluffing game between two human players. Based on the game\n'
                'from the show, 8 Out of 10 Cats.\n'
                'Tags: large, game, two-player\n',
        'filename': 'carrotinabox.py',
        'hash': 447666550,
        'name': 'Carrot in a Box'},
    {   'desc': 'Checkers, but you can move 3 random checkers per turn.\n'
                "These checkers are randomly decided, and can be the player's own\n"
                "checkers or their opponents', but you can't move your opponents'\n"
                'promoted checkers. In this version, capturing is not mandatory.\n'
                'Tags: extra-large, board game, game, two-player\n',
        'filename': 'chancecheckers.py',
        'hash': 2403689682,
        'name': 'Chance Checkers'},
    {   'desc': 'Try to get the robots to crash into each other.\nTags: large, game\n',
        'filename': 'chase.py',
        'hash': 701254371,
        'name': 'Daleks'},
    {   'desc': 'The classic checkers board game.\n'
                'In this version, capturing is not mandatory.\n'
                'Tags: extra-large, board game, game, two-player\n',
        'filename': 'checkers.py',
        'hash': 3889603676,
        'name': 'Checkers'},
    {   'desc': 'A dangerously delicious logic game.\n'
                'Inspired by a Frederik Schuh and David Gale puzzle, published by\n'
                'Martin Gardner in Scientific American (January 1973).\n'
                'More info at: https://en.wikipedia.org/wiki/Chomp\n'
                'Tags: short, game, puzzle game\n',
        'filename': 'chomp.py',
        'hash': 2908011443,
        'name': 'Chomp'},
    {   'desc': 'A clickbait headline generator for your soulless content farm.\nTags: large, humor, word\n',
        'filename': 'clickbait.py',
        'hash': 506908592,
        'name': 'Clickbait Headline Generator'},
    {   'desc': 'Simulate a large number of coin flips.\nTags: tiny, simulation\n',
        'filename': 'coinflipsimulator.py',
        'hash': 3356504169,
        'name': 'Coin Flip Simulator'},
    {   'desc': 'Generates numbers for the Collatz sequence, given a starting number.\n'
                '\n'
                'More info at: https://en.wikipedia.org/wiki/Collatz_conjecture\n'
                'An XKCD comic about Collatz numbers is at: https://www.xkcd.com/710/\n'
                'Tags: short, math, algorithm\n',
        'filename': 'collatz.py',
        'hash': 110707710,
        'name': 'Collatz Sequence'},
    {   'desc': 'Finds out how long various Collatz Sequences are.\n'
                'More info at: https://en.wikipedia.org/wiki/Collatz_conjecture\n'
                'Tags: short, math\n',
        'filename': 'collatzstats.py',
        'hash': 279382596,
        'name': 'Collatz Sequence Stats'},
    {   'desc': 'The classic cellular automata simulation. Press Ctrl-C to stop.\n'
                'More info at: https://en.wikipedia.org/wiki/Conway%27s_Game_of_Life\n'
                'Tags: short, artistic, simulation\n',
        'filename': 'conwaysgameoflife1.py',
        'hash': 1337918998,
        'name': "Conway's Game of Life"},
    {   'desc': "This version of Conway's Game of Life uses squares instead of text\n"
                'characters.\n'
                '\n'
                'The classic cellular automata simulation. Press Ctrl-C to stop.\n'
                'More info at: https://en.wikipedia.org/wiki/Conway%27s_Game_of_Life\n'
                '\n'
                'NOTE: Do not resize the terminal window while this program is running.\n'
                'Tags: large, artistic, simulation, bext\n',
        'filename': 'conwaysgameoflife2.py',
        'hash': 2769375244,
        'name': "Conway's Game of Life"},
    {   'desc': 'Show a countdown timer animation using a seven-segment display.\n'
                'Press Ctrl-C to stop.\n'
                'More info at https://en.wikipedia.org/wiki/Seven-segment_display\n'
                'Requires our sevseg.py program.\n'
                'Tags: short\n',
        'filename': 'countdown.py',
        'hash': 2144068838,
        'name': 'Countdown'},
    {   'desc': 'Prints out a random, diagonal maze. (It is not a true\n'
                'maze, but rather an artistic maze-like picture.)\n'
                'Inspired by the 10 PRINT CHR$(205.5+RND(1)); : GOTO 10 program.\n'
                'Tags: tiny, artistic, maze\n',
        'filename': 'diagonalmaze.py',
        'hash': 903133291,
        'name': 'Diagonal Maze'},
    {   'desc': 'Draws diamonds of various sizes.\n'
                '                           /\\       /\\\n'
                '                          /  \\     //\\\\\n'
                '            /\\     /\\    /    \\   ///\\\\\\\n'
                '           /  \\   //\\\\  /      \\ ////\\\\\\\\\n'
                ' /\\   /\\  /    \\ ///\\\\\\ \\      / \\\\\\\\////\n'
                '/  \\ //\\\\ \\    / \\\\\\///  \\    /   \\\\\\///\n'
                '\\  / \\\\//  \\  /   \\\\//    \\  /     \\\\//\n'
                ' \\/   \\/    \\/     \\/      \\/       \\/\n'
                ' Tags: short, artistic\n',
        'filename': 'diamond.py',
        'hash': 3299445168,
        'name': '"Diamond Drawings'},
    {   'desc': 'Simulates dice rolls using the Dungeons & Dragons notation.\nTags: short, simulation\n',
        'filename': 'diceroller.py',
        'hash': 3016849415,
        'name': 'Dice Roller'},
    {   'desc': 'Display a digital clock of the current time with a seven-segment display.\n'
                'Press Ctrl-C to stop.\n'
                'More info at https://en.wikipedia.org/wiki/Seven-segment_display\n'
                'Requires our sevseg.py program.\n'
                'Tags: short\n',
        'filename': 'digitalclock.py',
        'hash': 325968908,
        'name': 'Digital Clock'},
    {   'desc': 'A simple animation of a DNA double-helix. Press Ctrl-C to stop.\n'
                'Inspired by matoken https://asciinema.org/a/155441\n'
                'Tags: short, artistic, scrolling, science\n',
        'filename': 'dna.py',
        'hash': 3784067857,
        'name': 'DNA'},
    {   'desc': 'A screensaver of many many ducklings.\n'
                '\n'
                '>" )   =\'\')    (``=   ("=  >")    ("=\n'
                '(  >)  (  ^)  (v  )  (^ )  ( >)  (v )\n'
                ' ^ ^    ^ ^    ^ ^    ^^    ^^    ^^\n'
                '\n'
                "Ducklings based on ASCII art designs from the now-defunct Moijie's Room:\n"
                'http://www.geocities.jp/luckynopopo/\n'
                'Tags: large, scrolling, artistic\n'
                '\n',
        'filename': 'ducklings.py',
        'hash': 1274603454,
        'name': 'Duckling Screensaver'},
    {   'desc': 'An elimination game for multiple players. Press Ctrl-C to stop.\n'
                'More info at https://en.wikipedia.org/wiki/Eeny,_meeny,_miny,_moe\n'
                'More info at https://en.wikipedia.org/wiki/Josephus_problem\n'
                'Tags: short, game, multiplayer\n',
        'filename': 'eenymeeny.py',
        'hash': 659148283,
        'name': 'Eeny-Meeny-Miny-Moe'},
    {   'desc': 'An art program that draws a continuous line around the screen using the\n'
                'WASD keys.\n'
                '\n'
                'For example, you can draw Hilbert Curve fractal with:\n'
                'SDWDDSASDSAAWASSDSASSDWDSDWWAWDDDSASSDWDSDWWAWDWWASAAWDWAWDDSDW\n'
                '\n'
                'Or an even larger Hilbert Curve fractal with:\n'
                'DDSAASSDDWDDSDDWWAAWDDDDSDDWDDDDSAASDDSAAAAWAASSSDDWDDDDSAASDDSAAAAWA\n'
                'ASAAAAWDDWWAASAAWAASSDDSAASSDDWDDDDSAASDDSAAAAWAASSDDSAASSDDWDDSDDWWA\n'
                'AWDDDDDDSAASSDDWDDSDDWWAAWDDWWAASAAAAWDDWAAWDDDDSDDWDDSDDWDDDDSAASDDS\n'
                'AAAAWAASSDDSAASSDDWDDSDDWWAAWDDDDDDSAASSDDWDDSDDWWAAWDDWWAASAAAAWDDWA\n'
                'AWDDDDSDDWWAAWDDWWAASAAWAASSDDSAAAAWAASAAAAWDDWAAWDDDDSDDWWWAASAAAAWD\n'
                'DWAAWDDDDSDDWDDDDSAASSDDWDDSDDWWAAWDD\n'
                'Tags: large, artistic\n',
        'filename': 'etchasketch.py',
        'hash': 3452190299,
        'name': 'Etch a Sketch'},
    {   'desc': 'Finds all the factors of a number.\nTags: tiny, math\n',
        'filename': 'factorfinder.py',
        'hash': 1066216994,
        'name': 'Factorization'},
    {   'desc': 'Try to out-draw the computer in this gunfighter game.\nTags: tiny, game\n',
        'filename': 'fastdraw.py',
        'hash': 4197015893,
        'name': 'Fast Draw'},
    {   'desc': 'Calculates numbers in the Fibonacci sequence: 0 1 1 2 3 5 8 13...\nTags: short, math, algorithm\n',
        'filename': 'fibonacci.py',
        'hash': 491700390,
        'name': 'Fibonacci Sequence'},
    {   'desc': 'A beautiful animation of fireflies. Press Ctrl-C to stop.\nTags: large, artistic\n',
        'filename': 'fireflies.py',
        'hash': 1423773647,
        'name': 'Fireflies'},
    {   'desc': 'A peaceful animation of a fish tank. Press Ctrl-C to stop.\n'
                'Similar to ASCIIQuarium, but mine is based on an older ASCII fish tank\n'
                'program for DOS. https://robobunny.com/projects/asciiquarium/html/\n'
                'Tags: extra-large, artistic, bext\n',
        'filename': 'fishtank.py',
        'hash': 1689477754,
        'name': 'Fish Tank'},
    {   'desc': 'Fizz Buzz is a game where you count up from 1. If the number is a\n'
                'multiple of 3, you say "fizz" instead of the number. If the number is a\n'
                'multiple of 5, you say "buzz" instead of the number. If the number is a\n'
                'multiple of 3 and 5, you say "fizzbuzz".\n'
                '\n'
                'More info at: https://en.wikipedia.org/wiki/Fizz_buzz\n'
                'Tags: tiny, math\n',
        'filename': 'fizzbuzz.py',
        'hash': 676701532,
        'name': 'Fizz Buzz Calculation'},
    {   'desc': 'A number game where you also race against the clock.\nTags: tiny, game, math\n',
        'filename': 'fizzbuzzgame.py',
        'hash': 620127127,
        'name': 'FizzBuzz Game'},
    {   'desc': 'A colorful game where you try to fill the board with a single color.\nTags: large, game, bext\n',
        'filename': 'floodit.py',
        'hash': 1593605814,
        'name': 'Flood It!'},
    {   'desc': 'A colorful game where you try to fill the board with a single color.\n'
                '(This version uses letters instead of colors for colorblind users.)\n'
                'Tags: short, game\n',
        'filename': 'flooditletters.py',
        'hash': 3875218435,
        'name': 'Flood It! (Letter Version)'},
    {   'desc': 'A simulation of fires spreading in a growing forest.\n'
                'Press Ctrl-C to stop.\n'
                "Inspired by Nicky Case's Emoji Sim http://ncase.me/simulating/model/\n"
                'Tags: short, simulation, bext\n',
        'filename': 'forestfiresim.py',
        'hash': 3371732758,
        'name': 'Forest Fire Sim'},
    {   'desc': 'Tags: large, game, board game, two-player\n',
        'filename': 'fourinarow.py',
        'hash': 595629643,
        'name': 'FOUR IN A ROW'},
    {   'desc': 'Draws nonuniform fractal trees with turtle graphics.\n',
        'filename': 'fractalnonuniformtree.py',
        'hash': 2605734237,
        'name': 'Nonuniform Fractal Tree Drawer'},
    {   'desc': 'Draws fractal trees with turtle graphics.\n',
        'filename': 'fractaltree.py',
        'hash': 700222017,
        'name': 'Fractal Tree Drawer'},
    {   'desc': 'A sliding tile game to combine exponentially-increasing numbers.\n'
                "Inspired by Gabriele Cirulli's 2048, which is a clone of Veewo Studios'\n"
                '1024, which in turn is a clone of the Threes! game.\n'
                'More info at https://en.wikipedia.org/wiki/2048_(video_game)\n'
                'Tags: large, game, puzzle game\n',
        'filename': 'game2048.py',
        'hash': 1457838291,
        'name': '2048 Game'},
    {   'desc': 'Follow the trail to see who wins!\n'
                'More info at: https://en.wikipedia.org/wiki/Ghost_Leg\n'
                'Tags: large, artistic\n',
        'filename': 'ghostleglottery.py',
        'hash': 295815553,
        'name': 'Ghost Leg Lottery'},
    {   'desc': 'While given hints, try to guess the secret number.\nTags: tiny, game\n',
        'filename': 'guess.py',
        'hash': 4116613675,
        'name': 'Guess the Number'},
    {   'desc': 'A French variant of Hangman with different graphics. Ooh la la!\n'
                'Tags: large, game, word, puzzle game\n',
        'filename': 'guillotine.py',
        'hash': 949674584,
        'name': 'Guillotine'},
    {   'desc': 'The hacking mini-game from "Fallout 3". Find out which seven-letter\n'
                'word is the password by using clues each guess gives you.\n'
                'Tags: large, game, artistic\n',
        'filename': 'hacking.py',
        'hash': 2727878018,
        'name': 'Hacking'},
    {   'desc': 'The classic game Hamurabi.bas [sic] by Doug Dyment, popularized by David\n'
                'Ahl.\n'
                'Tags: large, game, simulation\n',
        'filename': 'hammurabi.py',
        'hash': 3522885446,
        'name': 'Hammurabi'},
    {   'desc': 'A program for making silly pluralizations. Press Ctrl-C to stop.\nTags: short, word, humor\n',
        'filename': 'hamsburger.py',
        'hash': 925556624,
        'name': 'Hamsburger'},
    {   'desc': 'A word-guessing game.\nTags: large, game, word, puzzle game\n',
        'filename': 'hangman.py',
        'hash': 1561317581,
        'name': 'Hangman'},
    {   'desc': 'A completely unfair word-guessing game. (This is a joke program.)\n'
                'Tags: large, game, word, puzzle game, humor\n',
        'filename': 'hangmanunfair.py',
        'hash': 712539536,
        'name': 'Hangman with Random Letters'},
    {   'desc': 'Play tic tac toe against the computer. Every possible move has been\n'
                'hard-coded into this program. The program is 5200 lines long.\n'
                "This is a joke program, don't actually write code like this.\n"
                'Tags: extra-large, game\n',
        'filename': 'hardcodedtictactoe.py',
        'hash': 4290344214,
        'name': 'Hard-coded Tic Tac Toe'},
    {   'desc': 'A pawn-only chess variant where you must try to move one of your\n'
                'pawns to the opposite end of the board. You also win if you block\n'
                'your opponent from making a move. The original Hexapawn had a 3x3\n'
                'board with six pawns, but this program lets you use boards of any\n'
                'size.\n'
                '\n'
                "Based on Martin Gardner's puzzle.\n"
                'More info at: https://en.wikipedia.org/wiki/Hexapawn\n'
                'Tags: extra-large, game, two-player, board game\n',
        'filename': 'hexapawn.py',
        'hash': 2007823290,
        'name': 'Hexapawn'},
    {   'desc': 'Displays a simple tessellation of a hexagon grid.\nTags: tiny, artistic\n',
        'filename': 'hexgrid.py',
        'hash': 1586473858,
        'name': 'Hex Grid'},
    {   'desc': 'Draws the Hilbert Curve fractal with turtle graphics.\n'
                'More info at: https://en.wikipedia.org/wiki/hilbertCurve\n'
                'Good videos on space-filling curves: https://youtu.be/RU0wScIj36o\n'
                'and https://youtu.be/3s7h2MHQtxc\n',
        'filename': 'hilbertcurve.py',
        'hash': 3356123256,
        'name': 'Hilbert Curve'},
    {   'desc': 'A tunnel animation.\nTags: tiny, scrolling, artistic\n',
        'filename': 'hole.py',
        'hash': 1307741419,
        'name': 'Hole'},
    {   'desc': 'An animation of an hour glass filled with falling sand.\n'
                'Press Ctrl-C to stop.\n'
                'Tags: large, artistic, simulation, bext\n',
        'filename': 'hourglass.py',
        'hash': 1946725551,
        'name': 'Hour Glass Animation'},
    {   'desc': 'How to keep an idiot busy for hours. (This is a joke program.)\nTags: tiny, humor\n',
        'filename': 'idiot.py',
        'hash': 2793858938,
        'name': 'Idiot'},
    {   'desc': 'A mystery game of intrigue and a missing cat.\n'
                'Inspired by Homestar Runner\'s "Where\'s an Egg?" game\n'
                'Tags: extra-large, game, puzzle game, humor\n',
        'filename': 'jaccuse.py',
        'hash': 3444366418,
        'name': "J'ACCUSE!"},
    {   'desc': 'Draws a Koch snowflake fractal with turtle graphics.\n',
        'filename': 'kochsnowflake.py',
        'hash': 2270959339,
        'name': 'Koch Snowflake'},
    {   'desc': 'A cellular automata animation. Press Ctrl-C to stop.\n'
                'More info: https://en.wikipedia.org/wiki/Langton%27s_ant\n'
                'Tags: large, simulation, bext, artistic\n',
        'filename': 'langtonsant.py',
        'hash': 3677352337,
        'name': "Langton's Ant"},
    {   'desc': 'Watch grass get cut and grow again. Press Ctrl-C to stop.\n'
                'Inspired by Tondeuse by Jules Villard, https://asciinema.org/a/21743\n'
                'https://bitbucket.org/jvillard/tondeuse/src/default/\n'
                'Tags: large, artistic\n',
        'filename': 'lawnmower.py',
        'hash': 1564736660,
        'name': 'Lawn mower'},
    {   'desc': 'Translates English messages into l33t5p34]<.\nTags: tiny, word, pyperclip\n',
        'filename': 'leetspeak.py',
        'hash': 2623987445,
        'name': 'Leetspeak'},
    {   'desc': 'Try to find your lost kitten Zophie by moving around the neighborhood\n'
                "streets and avenues. You'll get hints at how near or far she is.\n"
                'This game that teaches cartesian coordinates, cardinal directions, and\n'
                'the Pythagorean Theorem.\n'
                'Tags: large, game\n',
        'filename': 'lostkitty.py',
        'hash': 2573565510,
        'name': 'Lost Kitty'},
    {   'desc': 'The mathematics behind credit card numbers.\n'
                'More info at: https://en.wikipedia.org/wiki/Luhn_algorithm\n'
                'More info at: https://youtu.be/Erp8IAUouus\n'
                'Tags: short, math, algorithm\n',
        'filename': 'luhn.py',
        'hash': 2707939212,
        'name': 'Luhn Checksum Algorithm'},
    {   'desc': 'Ask a yes/no question about your future.\nTags: tiny, humor\n',
        'filename': 'magic8ball.py',
        'hash': 1181999882,
        'name': 'Magic Eight Ball'},
    {   'desc': 'Place numbers in a hexagon so each row adds up to 38.\n'
                'More info at https://en.wikipedia.org/wiki/Magic_hexagon\n'
                'More info at https://www.youtube.com/watch?v=ZkVSRwFWjy0\n'
                'Tags: large, game, puzzle game, board game\n',
        'filename': 'magichexagon.py',
        'hash': 3696828570,
        'name': 'Magic Hexagon'},
    {   'desc': 'Tags: large, game, board game, two-player\n',
        'filename': 'mancala.py',
        'hash': 345576642,
        'name': 'MANCALA'},
    {   'desc': 'A parentheses/bracket/braces matching algorithm.\nTags: short, algorithm\n',
        'filename': 'matchingparens.py',
        'hash': 3051602193,
        'name': 'Matching Parentheses'},
    {   'desc': 'A screensaver in the style of The Matrix movie\'s "digital rain"\n'
                'visual.\n'
                'Tags: tiny, scrolling, artistic\n',
        'filename': 'matrixscreensaver.py',
        'hash': 2832230919,
        'name': 'Matrix Screensaver'},
    {   'desc': 'Make mazes with the recursive backtracker algorithm.\n'
                'More info at: https://en.wikipedia.org/wiki/Maze_generation_algorithm#Recursive_backtracker\n'
                'An animated demo: https://scratch.mit.edu/projects/17358777/\n'
                'Tags: short, maze\n',
        'filename': 'mazemakerrec.py',
        'hash': 1962140561,
        'name': 'Maze Maker'},
    {   'desc': 'Move around a maze and try to escape. Maze files are generated by\n'
                'mazemakerrec.py.\n'
                'Tags: large, maze\n',
        'filename': 'mazerunner2d.py',
        'hash': 1816451069,
        'name': 'Maze Runner'},
    {   'desc': 'Move around a maze and try to escape... in 3D!\nTags: extra-large, maze, game, artistic\n',
        'filename': 'mazerunner3d.py',
        'hash': 1685986547,
        'name': 'Maze 3D'},
    {   'desc': 'Scrambles the middle letters of words, but not the first and last\nletters.\nTags: tiny, word\n',
        'filename': 'middleletterscrambler.py',
        'hash': 2922789481,
        'name': 'Middle Letter Scrambler'},
    {   'desc': 'A simulation of one million dice rolls.\nTags: tiny, simulation\n',
        'filename': 'milliondicestats.py',
        'hash': 553539697,
        'name': 'Million Dice Roll Stats'},
    {   'desc': 'Draws an Andy Warhol-like drawing of the Mona Lisa with turtle\ngraphics.\n',
        'filename': 'monalisa.py',
        'hash': 2548314894,
        'name': 'Mona Lisa'},
    {   'desc': 'Randomly generates art in the style of Piet Mondrian.\n'
                '\n'
                'More info at: https://en.wikipedia.org/wiki/Piet_Mondrian\n'
                'Tags: large, artistic\n',
        'filename': 'mondrian.py',
        'hash': 1254042116,
        'name': 'Mondrian Art Generator'},
    {   'desc': 'A simulation of the Monty Hall game show problem.\n'
                'More info at https://en.wikipedia.org/wiki/Monty_Hall_problem\n'
                'Tags: large, game, math, simulation\n',
        'filename': 'montyhall.py',
        'hash': 98946205,
        'name': 'Monty Hall Problem'},
    {   'desc': 'Translates between English and Morse Code.\n'
                'More info at: https://en.wikipedia.org/wiki/Morse_code\n'
                'Tags: short, word\n',
        'filename': 'morsecode.py',
        'hash': 327480707,
        'name': 'Morse Code'},
    {   'desc': 'Print a multiplication table.\nTags: tiny, math\n',
        'filename': 'multiplicationtable.py',
        'hash': 3664112242,
        'name': 'Multiplication Table'},
    {   'desc': 'A fun math challenge.\n'
                '\n'
                'For more information about this topic, see https://youtu.be/Wim9WJeDTHQ\n'
                'Tags: tiny, math\n',
        'filename': 'multiplicativepersistence.py',
        'hash': 1997611464,
        'name': 'Multiplicative Persistence'},
    {   'desc': 'Print the full lyrics to one of the most longest songs ever!\n'
                'Press Ctrl-C to stop.\n'
                'Tags: tiny, scrolling\n',
        'filename': 'ninetyninebottles.py',
        'hash': 2902366961,
        'name': '99 Bottles of Beer on the Wall'},
    {   'desc': 'Shows the equivalent numbers in decimal, hexadecimal, and binary.\nTags: short, math\n',
        'filename': 'numeralsystems.py',
        'hash': 3292095943,
        'name': 'Numeral System Counters'},
    {   'desc': 'A single-player, peg-jumping game to eliminate all the pegs.\n'
                'More info at https://en.wikipedia.org/wiki/Peg_solitaire\n'
                'Tags: large, game, board game\n',
        'filename': 'pegsolitaire.py',
        'hash': 3260740495,
        'name': 'Peg Solitaire'},
    {   'desc': 'Displays atomic information for all the elements.\nTags: short, science\n',
        'filename': 'periodictable.py',
        'hash': 3768798000,
        'name': 'Periodic Table of Elements'},
    {   'desc': 'Translates English messages into Igpay Atinlay.\nTags: short, word\n',
        'filename': 'piglatin.py',
        'hash': 2407907377,
        'name': 'Pig Latin'},
    {   'desc': 'A turtle program to draw polygons. Every line is the same length.\n',
        'filename': 'polygons.py',
        'hash': 3131723845,
        'name': 'Polygons'},
    {   'desc': 'A simulation of the lottery so you can experience the thrill of\n'
                'losing the lottery without wasting your money.\n'
                'Tags: short, simulation, humor\n',
        'filename': 'powerballlottery.py',
        'hash': 2747897462,
        'name': 'Powerball Lottery'},
    {   'desc': 'A sample progress bar animation that can be used in other programs.\nTags: short, module\n',
        'filename': 'progressbar.py',
        'hash': 2698355831,
        'name': 'Progress Bar Simulation'},
    {'desc': 'Drawing pythons with turtle graphics.\n', 'filename': 'pythons.py', 'hash': 574472191, 'name': 'Pythons'},
    {   'desc': 'The "rail fence" cipher for encrypting text.\n'
                'More info at: https://en.wikipedia.org/wiki/Rail_fence_cipher\n'
                'Tags: large, cryptography, pyperclip\n',
        'filename': 'railfencecipher.py',
        'hash': 967306142,
        'name': 'Rail Fence Cipher'},
    {   'desc': 'Shows a simple rainbow animation. Press Ctrl-C to stop.\nTags: tiny, scrolling, artistic, bext\n',
        'filename': 'rainbow.py',
        'hash': 236191490,
        'name': 'Rainbow'},
    {   'desc': 'Shows a simple squiggle rainbow animation. Press Ctrl-C to stop.\n'
                'Tags: tiny, scrolling, artistic, bext\n',
        'filename': 'rainbow2.py',
        'hash': 2500579411,
        'name': 'Rainbow 2'},
    {   'desc': 'Generate splatter-art with the "random walk" algorithm.\n'
                'Press Ctrl-C to stop.\n'
                'More info at: https://en.wikipedia.org/wiki/Random_walk\n'
                'Tags: short, artistic, bext\n',
        'filename': 'randomwalk.py',
        'hash': 2743684440,
        'name': 'Random Walk'},
    {   'desc': 'A tile flipping game, also called reversi.\n'
                'More info https://en.wikipedia.org/wiki/Reversi\n'
                'Tags: extra-large, game, two-player, board game\n',
        'filename': 'reversi.py',
        'hash': 1120228341,
        'name': 'Reversi'},
    {   'desc': 'A hand game of luck.\nTags: short, game\n',
        'filename': 'rockpaperscissors.py',
        'hash': 1990981243,
        'name': 'Rock-Paper-Scissors'},
    {   'desc': 'A hand game of luck, except you cannot lose.\nTags: tiny, game, humor\n',
        'filename': 'rockpaperscissorsalwayswin.py',
        'hash': 202627445,
        'name': 'Rock-Paper-Scissors (Always Win)'},
    {   'desc': 'The simplest cipher for encrypting and decrypting text.\n'
                'More info at https://en.wikipedia.org/wiki/ROT13\n'
                'Tags: tiny, cryptography, pyperclip\n',
        'filename': 'rot13.py',
        'hash': 1797986346,
        'name': 'ROT13 Cipher'},
    {   'desc': 'A rotating cube animation. Press Ctrl-C to stop.\nTags: large, artistic, math\n',
        'filename': 'rotatingcube.py',
        'hash': 3244390420,
        'name': 'Rotating Cube'},
    {   'desc': 'A sliding tile puzzle game to move cars out of the way.\n'
                'Original game by Nob Yoshihagara\n'
                'More info at https://www.michaelfogleman.com/rush/\n'
                'Tags: large, game, puzzle game, board game\n',
        'filename': 'rushhour.py',
        'hash': 3714693623,
        'name': 'Rush Hour'},
    {   'desc': 'A falling sand animation. (Must be run from a Terminal window.)\n'
                'Inspired by https://asciinema.org/a/6515\n'
                'Tags: short, simulation\n',
        'filename': 'sandfall.py',
        'hash': 3199332099,
        'name': 'Sand Fall'},
    {   'desc': 'A seven-segment display module.\n'
                'More info at https://en.wikipedia.org/wiki/Seven-segment_display\n'
                'Tags: short, module\n',
        'filename': 'sevseg.py',
        'hash': 2504400352,
        'name': 'Sevseg'},
    {   'desc': 'A random gambling game.\nTags: tiny, game\n',
        'filename': 'shellgame.py',
        'hash': 837460454,
        'name': 'Shell Game'},
    {   'desc': 'Displays a tessellation of the carpet pattern from The Shining.\nTags: tiny, artistic\n',
        'filename': 'shiningcarpet.py',
        'hash': 1309846221,
        'name': 'Shining Carpet'},
    {   'desc': 'Sierpinkski\'s "game" is an algorithm that draws Sierpinski\'s Triangle\n'
                'with turtle graphics.\n'
                'More info at https://en.wikipedia.org/wiki/Chaos_game\n',
        'filename': 'sierpinskisgame.py',
        'hash': 396754219,
        'name': "Sierpinkski's Game"},
    {   'desc': 'Draws the Sierpinski Square (also called Carpet) with turtle graphics.\n'
                'More info at: https://en.wikipedia.org/wiki/Sierpinski_carpet\n',
        'filename': 'sierpinskisquare.py',
        'hash': 4286961791,
        'name': 'Sierpinski Square'},
    {   'desc': 'Draws the Sierpinski Triangle fractal with turtle graphics.\n',
        'filename': 'sierpinskitriangle.py',
        'hash': 3134533681,
        'name': 'Sierpinski Triangle'},
    {   'desc': 'Slide the numbered tiles into the correct order.\nTags: large, game, puzzle game\n',
        'filename': 'slidingpuzzle.py',
        'hash': 1326851921,
        'name': '15-Sliding Puzzle'},
    {   'desc': 'Fast-paced snail racing action!\nTags: short, artistic, game, multiplayer\n',
        'filename': 'snailrace.py',
        'hash': 3793776533,
        'name': 'Snail Race'},
    {   'desc': 'The classic crate-pushing game.\nTags: large, game, puzzle game\n',
        'filename': 'sokoban.py',
        'hash': 962354975,
        'name': 'Sokoban clone'},
    {   'desc': 'Try to locate treasure chests hidden under the waves.\nTags: large, game\n',
        'filename': 'sonar.py',
        'hash': 2526228993,
        'name': 'Sonar Treasure Hunt'},
    {   'desc': 'A simulation of a Japanese abacus calculator tool.\n'
                'More info at: https://en.wikipedia.org/wiki/Soroban\n'
                'Tags: large, simulation, math, artistic\n',
        'filename': 'soroban.py',
        'hash': 2642879714,
        'name': 'Soroban'},
    {   'desc': 'Translates English messages into sPOnGEtExT.\nTags: tiny, word\n',
        'filename': 'spongetext.py',
        'hash': 4165508854,
        'name': 'sPoNgEtExT'},
    {   'desc': 'A program that draws a bunch of random squiggles.\nTags: large, artistic\n',
        'filename': 'squiggles.py',
        'hash': 2086690610,
        'name': 'Squiggles'},
    {   'desc': 'The classic 9x9 number placement puzzle.\n'
                'More info at https://en.wikipedia.org/wiki/Sudoku\n'
                'Tags: large, game, puzzle game\n',
        'filename': 'sudoku.py',
        'hash': 81181441,
        'name': 'Sudoku'},
    {   'desc': 'Find the Queen of Hearts after cards have been swapped around.\n'
                '(In the real-life version, the scammer palms the Queen of Hearts so you\n'
                'always lose.)\n'
                'More info at https://en.wikipedia.org/wiki/Three-card_Monte\n'
                'Tags: large, game, card game\n',
        'filename': 'threecardmonte.py',
        'hash': 506266536,
        'name': 'Three-Card Monte'},
    {   'desc': 'The classic board game.\nTags: short, game, two-player\n',
        'filename': 'tictactoe.py',
        'hash': 2811229163,
        'name': 'Tic Tac Toe'},
    {   'desc': 'The classic board game. (Object-oriented programming version.)\n'
                'Tags: large, game, two-player, board game, object-oriented\n',
        'filename': 'tictactoeoop.py',
        'hash': 1377227149,
        'name': 'Tic Tac Toe (OOP)'},
    {   'desc': 'A stack-moving puzzle game.\nTags: short, game, puzzle game\n',
        'filename': 'towerofhanoi.py',
        'hash': 3496452219,
        'name': 'THE TOWER OF HANOI'},
    {   'desc': 'A quiz of several trick questions.\nTags: large, humor\n',
        'filename': 'trickquestions.py',
        'hash': 1640821181,
        'name': 'Trick Questions'},
    {   'desc': 'The Ulam spiral is a mysterious mathematics pattern for prime numbers\n'
                'with turtle graphics.\n'
                'More info at https://en.wikipedia.org/wiki/Ulam_spiral\n',
        'filename': 'ulamspiral.py',
        'hash': 1919625381,
        'name': 'Ulam Spiral'},
    {   'desc': 'A water pouring puzzle.\n'
                'More info: https://en.wikipedia.org/wiki/Water_pouring_puzzle\n'
                'Tags: large, object-oriented, game, puzzle game, math\n',
        'filename': 'waterbucket.py',
        'hash': 2829582306,
        'name': 'Water Bucket Puzzle'},
    {   'desc': 'A simple zig zag animation. Press Ctrl-C to stop.\nTags: tiny, artistic, scrolling\n',
        'filename': 'zigzag.py',
        'hash': 1440878538,
        'name': 'Zigzag'},
    {   'desc': '(Requires Pygame) Play against the computer and try to flip their tiles.\n',
        'filename': 'pygame_games/flippy.py',
        'hash': 3713351773,
        'name': 'Flippy (a Reversi clone)'},
    {   'desc': '(Requires Pygame) Play against the computer, dropping tiles to connect four.\n',
        'filename': 'pygame_games/fourinarow.py',
        'hash': 530766230,
        'name': 'Four-In-A-Row'},
    {   'desc': '(Requires Pygame) An addictive jewel matching game.\n',
        'filename': 'pygame_games/gemgem.py',
        'hash': 3403778852,
        'name': 'Gemgem (a Bejeweled clone)'},
    {   'desc': '(Requires Pygame) Try to make the entire field a single color.\n',
        'filename': 'pygame_games/inkspill.py',
        'hash': 1212986240,
        'name': 'Ink Spill (a Flood It clone)'},
    {   'desc': '(Requires Pygame) A simple memory matching game.\n',
        'filename': 'pygame_games/memorypuzzle.py',
        'hash': 2764951721,
        'name': 'Memory Puzzle'},
    {   'desc': '(Requires Pygame) Like Pygame, except with 5-box blocks.\n',
        'filename': 'pygame_games/pentomino.py',
        'hash': 2488726696,
        'name': 'Pentomino'},
    {   'desc': '(Requires Pygame) Copy the pattern of flashing lights for as long as possible.\n',
        'filename': 'pygame_games/simulate.py',
        'hash': 1595074871,
        'name': 'Simulate (a Simon clone)'},
    {   'desc': '(Requires Pygame) The classic 15-tile slide puzzle.\n',
        'filename': 'pygame_games/slidepuzzle.py',
        'hash': 2239300442,
        'name': 'Slide Puzzle'},
    {   'desc': '(Requires Pygame) A game where squirrels eat each other and grow monstrously large.\n',
        'filename': 'pygame_games/squirrel.py',
        'hash': 3066255054,
        'name': 'Squirrel Eat Squirrel'},
    {   'desc': '(Requires Pygame) A puzzle game where you push the stars over their goals.\n',
        'filename': 'pygame_games/starpusher.py',
        'hash': 869642124,
        'name': 'Star Pusher (a Sokoban clone)'},
    {   'desc': '(Requires Pygame) The classic block falling puzzle from the Soviet Union.\n',
        'filename': 'pygame_games/tetromino.py',
        'hash': 2002643604,
        'name': 'Tetromino (a Tetris clone)'},
    {   'desc': '(Requires Pygame) Tetris, but... simpler.\n',
        'filename': 'pygame_games/tetrominoforidiots.py',
        'hash': 96477611,
        'name': 'Tetromino for Idiots'},
    {   'desc': '(Requires Pygame) Lead the green snake around the screen eating red apples.\n',
        'filename': 'pygame_games/wormy.py',
        'hash': 4058946360,
        'name': 'Wormy'}]


SUPPORT_FILES = {   'alphabetizewordquiz.py': ['commonenglishwords.txt'],
    'hamsburger.py': ['nounlist.txt'],
    'mazerunner2d.py': ['maze11x11s1.txt', 'maze51x17s42.txt'],
    'periodictable.py': ['elements.csv'],
    'pygame_games/flippy.py': [   'pygame_games',
                                  'pygame_games/freesansbold.ttf',
                                  'pygame_games/flippyboard.png',
                                  'pygame_games/flippybackground.png'],
    'pygame_games/fourinarow.py': [   'pygame_games/4row_red.png',
                                      'pygame_games/4row_black.png',
                                      'pygame_games/4row_humanwinner.png',
                                      'pygame_games/4row_computerwinner.png',
                                      'pygame_games/4row_tie.png',
                                      'pygame_games/4row_arrow.png'],
    'pygame_games/gemgem.py': [   'pygame_games/freesansbold.ttf',
                                  'pygame_games/badswap.wav',
                                  'pygame_games/match0.wav',
                                  'pygame_games/match1.wav',
                                  'pygame_games/match2.wav',
                                  'pygame_games/match3.wav',
                                  'pygame_games/match4.wav',
                                  'pygame_games/match5.wav',
                                  'pygame_games/gem1.png',
                                  'pygame_games/gem2.png',
                                  'pygame_games/gem3.png',
                                  'pygame_games/gem4.png',
                                  'pygame_games/gem5.png',
                                  'pygame_games/gem6.png',
                                  'pygame_games/gem7.png'],
    'pygame_games/inkspill.py': [   'pygame_games/inkspilllogo.png',
                                    'pygame_games/inkspillspot.png',
                                    'pygame_games/inkspillsettings.png',
                                    'pygame_games/inkspillsettingsbutton.png',
                                    'pygame_games/inkspillresetbutton.png'],
    'pygame_games/pentomino.py': [   'pygame_games/freesansbold.ttf',
                                     'pygame_games/tetrisb.mid',
                                     'pygame_games/tetrisc.mid'],
    'pygame_games/simulate.py': [   'pygame_games/freesansbold.ttf',
                                    'pygame_games/beep1.ogg',
                                    'pygame_games/beep2.ogg',
                                    'pygame_games/beep3.ogg',
                                    'pygame_games/beep4.ogg'],
    'pygame_games/slidepuzzle.py': ['pygame_games/freesansbold.ttf'],
    'pygame_games/squirrel.py': [   'pygame_games/freesansbold.ttf',
                                    'pygame_games/gameicon.png',
                                    'pygame_games/squirrel.png',
                                    'pygame_games/grass1.png',
                                    'pygame_games/grass2.png',
                                    'pygame_games/grass3.png',
                                    'pygame_games/grass4.png'],
    'pygame_games/starpusher.py': [   'pygame_games/RedSelector.png',
                                      'pygame_games/Selector.png',
                                      'pygame_games/Star.png',
                                      'pygame_games/Wall_Block_Tall.png',
                                      'pygame_games/Wood_Block_Tall.png',
                                      'pygame_games/Plain_Block.png',
                                      'pygame_games/Grass_Block.png',
                                      'pygame_games/star_title.png',
                                      'pygame_games/star_solved.png',
                                      'pygame_games/princess.png',
                                      'pygame_games/boy.png',
                                      'pygame_games/catgirl.png',
                                      'pygame_games/horngirl.png',
                                      'pygame_games/pinkgirl.png',
                                      'pygame_games/Rock.png',
                                      'pygame_games/Tree_Short.png',
                                      'pygame_games/Tree_Tall.png',
                                      'pygame_games/Tree_Ugly.png',
                                      'pygame_games/starPusherLevels.txt'],
    'pygame_games/tetromino.py': [   'pygame_games/freesansbold.ttf',
                                     'pygame_games/tetrisb.mid',
                                     'pygame_games/tetrisc.mid'],
    'pygame_games/tetrominoforidiots.py': [   'pygame_games/freesansbold.ttf',
                                              'pygame_games/tetrisb.mid',
                                              'pygame_games/tetrisc.mid'],
    'pygame_games/wormy.py': ['pygame_games/freesansbold.ttf'],
    'rushhour.py': ['rushhourpuzzles.txt'],
    'sokoban.py': ['sokobanlevels.txt'],
    'sudoku.py': ['sudokupuzzles.txt']}