..
   Copyright 2021 IRT Saint Exupéry, https://www.irt-saintexupery.com

   This work is licensed under the Creative Commons Attribution-ShareAlike 4.0
   International License. To view a copy of this license, visit
   http://creativecommons.org/licenses/by-sa/4.0/ or send a letter to Creative
   Commons, PO Box 1866, Mountain View, CA 94042, USA.

..
   Contributors:
          :author: Matthias De Lozzo

.. raw:: latex

   \part{Quick start}

.. toctree::
   :caption: Quick start
   :maxdepth: 1
   :hidden:

   /quickstart/overview
   /quickstart/installation
   /quickstart/api
   /quickstart/faq
   /quickstart/release

.. raw:: latex

   \part{In a nutshell}

.. toctree::
   :caption: In a nutshell
   :maxdepth: 1
   :hidden:

   A. Disciplines </nutshell/disciplines>
   B. Design space </nutshell/design_space>
   C. Scenario </nutshell/scenario>
   D. Post-processing </nutshell/post_processing>

.. raw:: latex

   \part{Tutorials}

.. toctree::
   :caption: Tutorials
   :maxdepth: 1
   :hidden:

   Solve an optimization problem </tutorials/basics_of_optimization/simple_opt_example>
   Solve an MDO problem </tutorials/sellar/nutshell>
   Carry out a trade-off study </tutorials/ssbj/doe_scenarios_construction>
   Build a scalable model (Sellar) </tutorials/scalable/scalable>
   Build a scalable model (Aerostructure) </tutorials/aerostruct/aerostruct_toy_example>
   Application: Sobieski's SSBJ </tutorials/ssbj/sobieski_use_case>
   See the benchmark problems </tutorials/benchmark_problems>

.. raw:: latex

   \part{Features: Basics of MDO}

.. toctree::
   :caption: Features: Basics of MDO
   :maxdepth: 1
   :hidden:

   /features/computing/caching
   /features/mdo/mdo_formulations
   /features/mdo/mda
   /features/mdo/optimization
   Post-processing and analysis </features/computing/post_processing>
   /features/metamodels/surrogates

.. raw:: latex

   \part{Features: Advanced MDO}

.. toctree::
   :caption: Features: Advanced MDO
   :maxdepth: 1
   :hidden:

   Analytic disciplines </features/mdo/analytic_discipline>
   /features/computing/jacobian_assembly
   /features/computing/monitoring
   /features/mdo/odd
   Scalable models </features/metamodels/scalable>

.. raw:: latex

   \part{Plug-in options}

.. toctree::
   :caption: Plug-in options
   :maxdepth: 1
   :hidden:

   Optimization algorithms </features/opt_algos>
   Designs of experiments </features/doe_algos>
   Multidisciplinary analyses </features/mda_algos>
   MDO formulations </features/formulation_algos>
   Post-processing and analysis </features/post_algos>

.. raw:: latex

   \part{Development}

.. toctree::
   :caption: Development
   :maxdepth: 1
   :hidden:

   /development/system_architecture
   /development/software_connection
   Optimization by Domain Decomposition </features/computing/odd>

.. raw:: latex

   \part{Miscellaneous}

.. toctree::
   :caption: Miscellaneous
   :maxdepth: 1
   :hidden:

   /zreferences
   /misc/glossary
   /genindex
   /_modules/modules

.. raw:: latex

   \part{About us}

.. toctree::
   :caption: About us
   :maxdepth: 1
   :hidden:

   /aboutus/contributors
   /aboutus/citation
