# Copyright 2021 IRT Saint Exupéry, https://www.irt-saintexupery.com
#
# This work is licensed under a BSD 0-Clause License.
#
# Permission to use, copy, modify, and/or distribute this software
# for any purpose with or without fee is hereby granted.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
# WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL
# THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT,
# OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
# FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
# NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
# WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
# Contributors:
#    INITIAL AUTHORS - initial API and implementation and/or initial
#                           documentation
#        :author: Matthias De Lozzo
#    OTHER AUTHORS   - MACROSCOPIC CHANGES
"""
Plot - Andrews curves
=====================

"""
from gemseo.api import configure_logger
from gemseo.api import load_dataset
from gemseo.post.dataset.andrews_curves import AndrewsCurves
from matplotlib import pyplot as plt

configure_logger()


############################################################################
# Load a dataset
# --------------
iris = load_dataset("IrisDataset")

############################################################################
# Plot Andrews Curves
# -------------------
# We can use the :class:`.AndrewsCurves` plot
# which can be viewed as a smooth
# version of the parallel coordinates. Each sample is represented by a curve
# and if there is structure in data, it may be visible in the plot.
AndrewsCurves(iris, "specy").execute(save=False, show=False)
# Workaround for HTML rendering, instead of ``show=True``
plt.show()
